<?php

/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_config.tpl.php,v 1.16 2012-01-27 20:50:46 vinicius Exp $
 */


/* Protecao contra hacks */

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {

    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .

        'invalid access to system file.');

}

$options_schemas = $this->GetVar('options_schemas');

$options_log = $this->GetVar('options_log');

$options_menu = $this->GetVar('options_menu');

$options_api = $this->GetVar('options_api');
$options_smtp_api = $this->GetVar('options_smtp_api');
$options_sms_api = $this->GetVar('options_sms_api');
$config_tam = $this->GetVar('config_tam');
$content_initial_data = $this->GetVar('content_config_initial_data');
$content_add_apps = $this->GetVar('content_config_add_apss');
if($this->GetVar('count_langs_prj') == '1'){
    $checkbox_yes = '';
    $checkbox_no  = 'checked="checked"';
}else{
    $checkbox_yes = 'checked="checked"';
    $checkbox_no  = '';
}
?>
<style>
    .tab {
        min-height: 300px;
    }

    .ui.menu.tabular .item {
        text-transform: none !important;
    }

    body {
        font-family: Lato, 'Helvetica Neue', Arial, Helvetica, sans-serif !important;
    }
</style>

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['menu']['conf']"); ?></h3>
    </div>

    <div class="right floated foar wide column"
         style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
<div class="ui divider"></div>

<div class="ui top attached tabular menu">
    <a class="active item aba_clicked" id='general' data-tab="general" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['general']"); ?>
    </a>

    <a class="item"
           data-tab="config_email" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['email_sett']"); ?></a>

    <a class="item"
           data-tab="config_sms" onclick="nm_verify_deps($(this).attr('data-tab'));">SMS</a>

    <a class="item" data-tab="config_add_apps" onclick="nm_verify_deps($(this).attr('data-tab'));"><?php echo nm_get_text_lang("['menu']['popular_app']"); ?></a>

</div>

<div class="ui bottom attached active tab segment" data-tab="general">
    <div class="ui ">

        <div class="ui form">
            <div class="two fields">
                <div class="field">
                    <label><?php echo nm_get_text_lang("['prefix_app']['title']"); ?></label>

                    <input type='text' id='id_prefix_app' name='config_general[prefix_app]' value='notif_'>
                </div>
                <div class=" field">
                    <label><?php echo nm_get_text_lang("['folder']['title']"); ?></label>

                    <input type="text" name="config_general[folder_notification]" value="Notification" size="20"
                           maxlength="64" id='id_folder_security'>

                </div>

            </div>
            <div class="two fields">


            </div>
            <div class="fields two">
                <div class=" field">
                    <label><?php echo nm_get_text_lang("['theme']['title']"); ?></label>

                    <select name="config_general[theme]" class='ui fluid dropdown search'>
                        <?php echo $options_schemas; ?>
                    </select>
                </div>
                <div class=" field">
                    <label><?php echo nm_get_text_lang("['log']['title']"); ?></label>

                    <select name="config_general[log]" class='ui fluid dropdown'>

                        <?php echo $options_log; ?>

                    </select>
                </div>
            </div>
            <div class="fields two">
                <div class="field">
                    <label><?php echo nm_get_text_lang("['menu']['title']"); ?></label>


                    <select name="config_general[menu]" class='ui fluid dropdown'
                            onchange="if(this.value=='new_menu'){ $('.menuField').removeClass('disabled'); } else { $('.menuField').addClass('disabled'); } ">

                        <?php echo $options_menu; ?>

                    </select>

                </div>
                <div class=" field menuField">
                    <label><?php echo nm_get_text_lang("['menu_theme']['title']"); ?></label>


                    <select name="config_general[menu_theme]" class='ui fluid dropdown' id="theme_list">
                        <?php
                        $themes_arr = $this->GetVar('themes_arr');
                        $selected = isset($_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme']) && isset($themes_arr[$_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme']]) ? $_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme'] : 'dark-cobalt';
                        foreach ($themes_arr as $k => $theme) {
                            ?>
                            <option value="<?php echo $k; ?>" <?php echo ($selected == $k? 'selected="selected"' : '');?> ><?php echo $theme['name']; ?></option>
                            <?php
                        }
                        ?>
                    </select>

                </div>
            </div>

            <div class="fields two">
                <div class=" field menuField">
                    <label><?php echo nm_get_text_lang("['menu_layout']['title']"); ?></label>


                    <select name="config_general[menu_layout]" class='ui fluid dropdown'>
                        <option value='h' checked='checked'><?php echo nm_get_text_lang("['horizontal']"); ?></option>
                        <option value='v'><?php echo nm_get_text_lang("['vertical']"); ?></option>
                    </select>

                </div>
            </div>
        </div>
    </div>
</div>


<div class="ui bottom attached tab segment" data-tab="config_email">
    <div class="ui ">
        <div class="ui form centered">

            <div class=" fields three equal width">

                <div class="field" id="id_combobox_smtp_api">
                    <label for=""><?php echo nm_get_text_lang("['api']"); ?></label>

                    <div class="ui action input">
                        <select name="config_general[smtp_api]" id="smtp_api" class='ui input large nmInput '
                                style="width: 100%;">
                            <option value=""><?php echo nm_get_text_lang("['btn_disabled']"); ?></option>
                            <option value="same_of_security"><?php echo nm_get_text_lang("['use_same_security']"); ?></option>
                            <option value="custom"><?php echo nm_get_text_lang("['custom']"); ?></option>
                            <?php foreach ($options_smtp_api as $mod => $apis): ?>
                                <optgroup label="<?php echo nm_get_text_lang("['mod_" . $mod . "']"); ?>">
                                    <?php foreach ($apis as $api => $desc): ?>
                                        <option value="<?php echo $mod . '__NM__' . $api; ?>"><?php echo $desc; ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                        <a href="javascript: nm_reload_apis('email', 'smtp_api', 1, 1);">
                            <div class="ui button">
                                <i class="fa fa-rotate-right"></i>
                            </div>
                        </a>
                        <a href="javascript: parent.nm_exec_menu('prj_api')">
                            <div class="ui button">
                                <i class="fa fa-pencil"></i>
                            </div>
                        </a>
                    </div>


                </div>
            </div>
            <div class="fields table_custom_smtp two">
                <div class="field ">
                    <label for="id_config_email_smtp_server"><?php echo nm_get_text_lang("['smtp']['server']"); ?></label>
                    <input type="text" name='config_email[smtp_server]' id='id_config_email_smtp_server'
                           class='config_email_custom' placeholder="smtp.example.com"/>
                </div>
                <div class="field ">
                    <label for="id_config_email_smtp_port"><?php echo nm_get_text_lang("['smtp']['port']"); ?></label>
                    <input type="number" name='config_email[smtp_port]' id='id_config_email_smtp_port'
                           class='config_email_custom' placeholder="465"/>
                </div>
            </div>
            <div class="fields two table_custom_smtp">
                <div class="field">
                    <label for="id_config_email_smtp_security"><?php echo nm_get_text_lang("['smtp']['security']"); ?></label>
                    <select class='ui fluid dropdown' name='config_email[smtp_security]'
                            id='id_config_email_smtp_security'>
                        <option value="" selected="selected"></option>
                        <option value="ssl">SSL</option>
                        <option value="tls">TLS</option>
                    </select>
                </div>

                <div class="field">
                    <label for="id_config_email_smtp_user"><?php echo nm_get_text_lang("['smtp']['usr']"); ?></label>
                    <input type="text" name='config_email[smtp_user]' id='id_config_email_smtp_user'
                           class='config_email_custom' placeholder="default@example.com"/>
                </div>
            </div>
            <div class="fields two table_custom_smtp">
                <div class="field">
                    <label for="id_config_email_smtp_pass"><?php echo nm_get_text_lang("['smtp']['pass']"); ?></label>
                    <div class="ui icon input">
                        <input type="text" name='config_email[smtp_pass]' id='id_config_email_smtp_pass'
                               class='config_email_custom' placeholder="********"/>
                        <i class="eye link icon nm_password" onclick="nm_show_password($(this));"></i>
                    </div>
                </div>
                <div class="field">
                    <label for="id_config_email_smtp_email"><?php echo nm_get_text_lang("['smtp']['email']"); ?></label>
                    <input type="text" name='config_email[smtp_email]' id='id_config_email_smtp_email'
                           class='config_email_custom' placeholder="default@example.com"/>
                </div>
            </div>
            <div class="fields two table_custom_smtp">
                <div class="field">
                    <label for="id_config_email_smtp_name"><?php echo nm_get_text_lang("['smtp']['name']"); ?></label>
                    <input type="text" name='config_email[smtp_name]' id='id_config_email_smtp_name'
                           class='config_email_custom'
                           placeholder="<?php echo nm_get_text_lang("['smtp']['name']"); ?>"/>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="ui bottom attached tab segment" data-tab="config_sms">
    <div class="ui ">
        <div class="ui form centered">

            <div class=" fields three equal width">

                <div class="field" id="id_combobox_sms_api">
                    <label for=""><?php echo nm_get_text_lang("['api']"); ?></label>

                    <div class="ui action input">
                        <select name="config_general[sms_api]" id="sms_api" class='ui input large nmInput '
                                style="width: 100%;">
                            <option value=""><?php echo nm_get_text_lang("['btn_disabled']"); ?></option>
                            <?php foreach ($options_sms_api as $mod => $apis): ?>
                                <optgroup label="<?php echo nm_get_text_lang("['mod_" . $mod . "']"); ?>">
                                    <?php foreach ($apis as $api => $desc): ?>
                                        <option value="<?php echo $mod . '__NM__' . $api; ?>"><?php echo $desc; ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                        <a href="javascript: nm_reload_apis('sms', 'sms_api', 0, 1);">
                            <div class="ui button">
                                <i class="fa fa-rotate-right"></i>
                            </div>
                        </a>
                        <a href="javascript: parent.nm_exec_menu('prj_api')">
                            <div class="ui button">
                                <i class="fa fa-pencil"></i>
                            </div>
                        </a>
                    </div>


                </div>
            </div>
            <div class="fields two">
                <div class="field ">
                    <label for="id_sms_qtd"><?php echo nm_get_text_lang("['sms']['qtd']"); ?></label>
                    <input type="number" name='config_sms[qtd]' id='id_config_sms_qtd'
                           class='config_sms_qtd' placeholder="160"/>
                </div>
                <div class="field ">

                </div>
            </div>
        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="config_add_apps">
    <?php $this->Display('body_popular_app', 'module_notification'); ?>
</div>
<input type='hidden' id='id_hid_has_app'/>
<div class="ui modal tiny" id="modal-save-perfil">
    <div class="content">
		<span id="modal-save-perfil-span-description">
			<?php $this->Display('body_step_save_profile', 'module_notification'); ?>
		</span>
    </div>
    <div class="actions">
        <div class="ui cancel button">
            Cancel
        </div>
        <div class="ui primary approve button">
            OK
        </div>
    </div>
</div>
<div class="ui modal tiny" id="modal-all-tabs-click">
    <div class="content">
		<span id="modal-all-tabs-click-span-description"></span>
	</div>
    <div class="actions">
        <div class="ui cancel button">
        	Cancel
        </div>
        <div class="ui primary approve button">
        	OK
        </div>
    </div>
</div>