<?php

include_once(dirname(__FILE__).'/../nmGen.class.php');

nm_load_class('interface', 'NewMenuThemes');
class nmGenNavMenu extends nmGen
{

    var $arr_menu_data;
    var $menu_itens;
    var $user_items;
    var $tb_itens;
    var $layout;
    var $theme;
    var $cssArr;
    var $moustache_replacements = [];
    var $moustache_inactive = [];

    public function writeMain()
    {
//        $htmlData = $this->readHTML();
//        $jsMainData = $this->readJSMain();
//        $jsAppData = $this->readJS();
//        $cssData = $this->readCSS();
//        $cssMainData = $this->readCSSMain();
//        $this->writeItemsData($attr_menu_itens);
//        //$this->writeApplicationInit($this->main_file);
//        $this->appendToMainFile($htmlData);
//        $this->appendJSToMainFile('var items_data = '.json_encode($attr_menu_itens));
//        $this->appendJSToMainFile('var user_menu_data = '.json_encode($user_items));
//        $this->appendJSToMainFile($jsAppData);
//        $this->appendJSToMainFile($jsMainData);
//        $this->appendCSSToMainFile($cssData);

    }
    function loadData($arq, $data)
    {
        parent::loadData($arq, $data);
        $this->loadItens();
        $this->buildThemesArr();
        $this->verifyMoustacheVars();
    }

    public function checkHeaderString() {
        $string_place = $this->arr_menu_data['header_string_pos'];

        $is_horizontal = $this->arr_menu_data['layout'] == 'H';
        $has_split = $this->arr_menu_data['check_split'] == 'S';
        $has_tb = $this->arr_menu_data['check_toolbar'] == 'S';

        if ($is_horizontal) {
            if ($has_split) {
                $string_place = 'H';
            }
        } else {
            if (!$has_tb) {
                $string_place = 'M';
            }
        }

        if ($string_place == 'M') {
            $this->moustache_inactive[] = 'header_string_h_placement';
        } else {
            $this->moustache_inactive[] = 'header_string_m_placement';
        }
    }

    public function checkUseTabs() {
        if ($this->app_data['menu_parms1']['open_itens_tab'] != 'S') {
            $this->moustache_inactive[] = 'tabs_placement';
        }
        if ($this->app_data['menu_parms1']['show_breadcrumbs'] != 'S') {
            $this->moustache_inactive[] = 'breadcrumbs_placement';
        }
    }

    public function checkNotifications() {
        foreach ($this->arr_menu_data['tb_items'] as $_tb_item) {
            if (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'notification') {
                return false;
            }
        }
        $this->moustache_inactive[] = 'notification';
        return true;
    }
    public function verifyMoustacheVars() {
        global $nm_config;
        $this->checkUseTabs();
        $this->checkHeaderString();
        $this->checkNotifications();
        $this->moustache_replacements = [
            'google_font_css' => $this->buildGoogleFontCss(),
            'tabs_placement' => $this->buildTabsHTML(),
            'breadcrumbs_placement' => $this->buildBreadcrumbsHTML(),
            'header_string_h_placement' => $this->buildHeaderString('h'),
            'header_string_m_placement' => $this->buildHeaderString('m'),
            'themes-panel' => $this->buildPanelHTML('themes'),
            'languages-panel' => $this->buildPanelHTML('languages'),
            'fav-panel' => $this->buildPanelHTML('fav'),
            'search-panel' => $this->buildPanelHTML('search'),
            'notification' => $this->buildPanelHTML('notification'),
            'megamenu' => ($nm_config['flag_versao']['megamenu']['has']) ? $this->buildPanelHTML('megamenu') : '',
//            'menu_theme' => $this->theme,
            'menu_theme' => "<?php echo ( isset(\$_COOKIE[\"menuTheme\"]) && !empty(\$_COOKIE[\"menuTheme\"]) && in_array(\$_COOKIE[\"menuTheme\"], \$menu_data[\"pick_themes\"]) ) ? \$_COOKIE[\"menuTheme\"] : \"" . $this->theme . "\"; ?>",
/*            'menu_theme' => "<?php echo ( isset(\$_COOKIE[\"menuTheme\"]) && !empty(\$_COOKIE[\"menuTheme\"]) && in_array(\$_COOKIE[\"menuTheme\"], \$menu_data[\"pick_themes\"]) ) ? \$_COOKIE[\"menuTheme\"] : \"" . $this->theme . "\"; ?>",*/
            'username' =>  $this->buildVarReading('username'),
            'userimage' => $this->buildVarReading('userimage'),
            'userdesc' => $this->buildVarReading('userdesc'),
            'notif_login_var' => $this->buildVarReading('notif_login_var'),
            'header_string' =>  $this->buildVarReading('header_string'),
            'logo' => "<?php echo \"" . $this->arr_menu_data['logo'] . "\"; ?>",
            'logo_compact' => "<?php echo \"" . $this->arr_menu_data['logo_compact'] . "\"; ?>",
        ];
    }
    public function renderMoustacheVars(&$htmlData) {

        foreach ($this->moustache_replacements as $k => $v) {
            $replacement = $v;
            if (in_array($k, $this->moustache_inactive)) {
                $replacement = '';
            }
            $htmlData = str_replace('{{'.$k.'}}', $replacement, $htmlData);
        }
    }
    public function loadItens() {
        $this->arr_menu_data = json_decode(json_encode($this->app_data['arr_apldata']['MenuItens']), true);
        $this->menu_itens = $this->arr_menu_data['items'];
        $this->user_items = $this->arr_menu_data['user_items'];
        $this->tb_itens = $this->arr_menu_data['user_items'];
        $this->theme = $this->arr_menu_data['theme'];

        $this->layout = 'desktop_h_resp';

        if ($this->arr_menu_data['layout'] == 'H') {
            if ($this->arr_menu_data['check_split'] == 'S') {
                $this->layout = 'desktop_h_split';
            }
        } else {
            if ($this->arr_menu_data['check_toolbar'] == 'S') {
                if ($this->arr_menu_data['layout_usr_pos'] == 'in') {
                    $this->layout = 'desktop_v_user_toolbar';
                } else {
                    $this->layout = 'desktop_v_toolbar';
                }
            } else {
                $this->layout = 'desktop_v_user';
            }
        }
    }

    public function buildGoogleFontCss() {
        $panelHTML = '';
        $panelHTML .= file_get_contents(dirname(__FILE__).'/common/google_font_css.php');
        return $panelHTML;
    }
    public function buildHeaderString($pos) {
        $panelHTML = '';
        $panelHTML .= file_get_contents(dirname(__FILE__).'/common/header_string_'.$pos.'.php');
        return $panelHTML;
    }
    public function buildPanelHTML($panelName) {
        $panelHTML = '';
        $panelHTML .= file_get_contents(dirname(__FILE__).'/common/panels/'.$panelName.'.php');
        return $panelHTML;
    }
    public function buildTabsHTML() {
        $tabsHTML = ' ';
        $tabsHTML .= file_get_contents(dirname(__FILE__).'/common/tabs.php');
        $tabsHTML .= " <script> ";
        $tabsHTML .= file_get_contents(dirname(__FILE__).'/common/tabs.js');
        $tabsHTML .= " </script> ";

        return $tabsHTML;
    }
    public function buildBreadcrumbsHTML() {
        $bcHTML = ' ';
        $bcHTML .= file_get_contents(dirname(__FILE__).'/common/breadcrumbs.php');
        $bcHTML .= " <script> ";
        $bcHTML .= file_get_contents(dirname(__FILE__).'/common/breadcrumbs.js');
        $bcHTML .= " </script> ";

        return $bcHTML;
    }
    public function buildJSONResponse() {
        $jrHTML = ' ';
        $jrHTML .= file_get_contents(dirname(__FILE__).'/common/notification_ajax.php');

        return $jrHTML;
    }
    public function getData() {
        return $this->arr_menu_data;
    }
    public function hasNotif() {
        $has_notif = false;
        if(isset($this->arr_menu_data['tb_items']) && !empty($this->arr_menu_data['tb_items'])) {
            foreach ($this->arr_menu_data['tb_items'] as $_tb_item) {
                if (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'notification') {
                    $has_notif = true;
                }
            }
        }
        return $has_notif;
    }
    public function buildVarReading($varname) {
        global $apl_charset;
        $ret = $varname;
        if (!isset($this->arr_menu_data[$varname])) {
            return '';
        }
        if (is_string( $this->arr_menu_data[$varname])) {
            $ret = preg_replace_callback('/\[([A-Za-z_]{1}\w*)\]/', function ($match) {
/*                return '<?php echo $this->sc_temp_' . $match[1] . '; ?>';*/
                return $match[1];
            }, $this->arr_menu_data[$varname]);
        }
        $conv_ini = '';
        $conv_end = '';
        if (strpos($ret, '$_SESSION') === false && $apl_charset != 'UTF-8') {
            $conv_ini = "mb_convert_encoding(";
            $conv_end = ", '$apl_charset', 'UTF-8')";

            $ret = json_encode($ret, 2097152);
            $ret = substr($ret, 1, -1);
            $ret = str_replace('\\/','/',  $ret);
            $ret = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
                return '&#x'.$match[1].';';
            }, $ret);
        }

/*        return  "<?php echo ".$conv_ini."\"" . $ret . "\"".$conv_end."; ?>";*/
        return  "<?php echo \"" . $ret ."\"; ?>";
    }
    public function readHTML() {
        $htmlData = file_get_contents(dirname(__FILE__).'/templates/'.$this->layout.'/index.php');
        $this->renderMoustacheVars($htmlData);
        return $htmlData;
    }
    public function readJSMain() {
        global $nm_config;
        $jsAppData = file_get_contents(dirname(__FILE__).'/common/sc-menu.class.js');
        $jsAppData .= file_get_contents(dirname(__FILE__).'/common/main.js');
        if ($nm_config['flag_versao']['megamenu']['has']) {
            $jsAppData .= file_get_contents(dirname(__FILE__) . '/common/megamenu.js');
        }
        return $jsAppData;
    }
    public function getSCThemeArr() {
        $arr_sc = file_get_contents(dirname(__FILE__) . '/common/themes.css');

        $arr_sc_themes = BreakCSS($arr_sc);
        $arr_sc = [];
        foreach ( $arr_sc_themes['all'] as $k=> $v) {
            if (strpos($k, 'data-aetheme=') !== false && strpos($k, '@') === false) {
                $out = preg_replace("/\*\[data\-aetheme\=([A-Za-z0-9\_\-]*)\]/", '$1', $k );
                $name = ucwords(str_replace('-', ' ', $out));
                $arr_sc[$out] = [
                    'name' => $name,
                    'scope' => 'scriptcase',
                    'p' => $v['--theme-color-primary'],
                    's' => $v['--theme-color-secondary'],
                    'a' => $v['--theme-color-accent'],
                    'm' => $v['--theme-color-muted'],
                    't' => $v['--theme-color-text'],
                    'b' => $v['--theme-box-shadow'],
                    'n' => $v['--theme-alert-color'],
                ];
            }
        }
        return $arr_sc;
    }
    public function buildThemesArr() {
        global $nm_config;
        $cssArr = [];
//        $arr_sc = $this->getSCThemeArr();

        $themeHandler = new nmNewMenuThemes();
        $arr_sc = $themeHandler->getArrayFromScope($themeHandler::SCRIPTCASE_SCOPE, true);
        if ($nm_config['flag_versao']['new_menu_themes']['has']) {
//            $arr_push = $themeHandler->getArrayFromScope($themeHandler::SCRIPTCASE_SCOPE, true);
//            $cssArr = array_merge($cssArr, $arr_push);
            $arr_push = $themeHandler->getArrayFromScope($themeHandler::PROJECT_SCOPE, true);
            $cssArr = array_merge($cssArr, $arr_push);
            $arr_push = $themeHandler->getArrayFromScope($themeHandler::PUBLIC_SCOPE, true);
            $cssArr = array_merge($cssArr, $arr_push);
        }
        if (!isset($cssArr[$this->theme]) && !isset($arr_sc[$this->theme])) {
            $mens = nm_get_text_lang("['generator']['schema_not_found']");
            $mens2 = nm_get_text_lang("['generator']['erro_replaced_schema']");

            nmgp_erro_geracao(sprintf($mens, "<strong>" . $this->theme . "</strong>") . sprintf($mens2, "<strong>Dark Cobalt</strong>"));
            $this->arr_menu_data['theme'] = 'dark-cobalt';
            $this->theme = 'dark-cobalt';
        }
        $this->cssArr = $cssArr;
    }
    public function buildThemesCSS() {
        global $nm_config;
        $cssStr = '';
        $cssStr .= file_get_contents(dirname(__FILE__) . '/common/themes.css');
        if (!$nm_config['flag_versao']['new_menu_themes']['has']) {
            foreach (['monochromatic-blue','monochromatic-blue-berry','monochromatic-navy','monochromatic-green','monochromatic-lemon','monochromatic-yellow','monochromatic-orange','monochromatic-dark-orange','monochromatic-red','monochromatic-guava','monochromatic-purple','monochromatic-pink','monochromatic-coral','monochromatic-beige','monochromatic-leather','monochromatic-gray','monochromatic-black','navy-energy','organic-nature','tropical','vibrant-modern','autumn-days','tech-future','luxury','midnight'] as $themename) {
                $cssStr = str_replace($themename, rand(0, 99999999), $cssStr);
            }
        }
        $cssArr = $this->cssArr;
        $cssStr .= $this->buildCssFromArr($cssArr);
//        if (!$nm_config['flag_versao']['new_menu_themes']['has']) {
//            foreach (['monochromatic-blue','monochromatic-blue-berry','monochromatic-navy','monochromatic-green','monochromatic-lemon','monochromatic-yellow','monochromatic-orange','monochromatic-dark-orange','monochromatic-red','monochromatic-guava','monochromatic-purple','monochromatic-pink','monochromatic-coral','monochromatic-beige','monochromatic-leather','monochromatic-gray','monochromatic-black','navy-energy','organic-nature','tropical','vibrant-modern','autumn-days','tech-future','luxury','midnight'] as $themename) {
//                $cssStr = str_replace($themename, rand(0, 99999999), $cssStr);
//            }
//        }
        return $cssStr;
    }
    public function buildCssFromArr($cssArr) {
        $str_in = '';
        foreach ($cssArr as $css) {
            $key = $css['name'];
            if (in_array($css['scope'], ['sys', 'grp'])) {

                $key = $css['scope'].'__'.$css['name'];
            }
            ob_start();
            ?>
            *[data-aetheme="<?php echo $key; ?>"] {
                --theme-color-primary: <?php echo $css['p']; ?>;
                --theme-color-secondary:  <?php echo $css['s']; ?>;
                --theme-color-accent: <?php echo $css['a']; ?>;
                --theme-color-muted: <?php echo $css['m']; ?>;
                --theme-color-text: <?php echo $css['t']; ?>;
                --theme-alert-color: <?php echo $css['n']; ?>;
                --theme-box-shadow: <?php echo $css['b']; ?>;
            }
            <?php
            $str_in .= ob_get_clean();
        }
        return $str_in;
    }
    public function readCSSMain() {
        $cssAppData = file_get_contents(dirname(__FILE__).'/common/sc-menu.class.css');
        $cssAppData .= $this->buildThemesCSS();
        $cssAppData .= file_get_contents(dirname(__FILE__).'/common/common.css');
        return $cssAppData;
    }
    public function readJS() {
        $jsAppData = file_get_contents(dirname(__FILE__).'/templates/'. $this->layout.'/assets/sc-menu.class.js');
        return $jsAppData;
    }

    public function readCSS() {
//        $cssData = file_get_contents(dirname(__FILE__).'/templates/'. $this->layout.'/assets/sc-menu.class.css');
        $cssData = '';
        return $cssData;
    }

    public function buildItemsData() {
        return $this->arrayToNotation($this->menu_itens);
    }

    public function writeItemsData() {
        $this->appendPHPToMainFile("\$menu_items = ".$this->buildItemsData());
    }

    public function writeApplicationInit($arq) {
        $nm_php_codigo = $this->app_data['nm_php_codigo'];
        $nome_classe = $this->app_data['nome_classe'];

        $nmgp_tem_redirect = false;
        if (isset($nm_php_codigo['onApplicationInit']) && !empty($nm_php_codigo['onApplicationInit']))
        {
            $_SESSION['scriptcase']['evt_process'] = "Evt.onApplicationInit:";
            $nmgp_formula = $nm_php_codigo['onApplicationInit'];
            $nmgp_formula = str_replace("sc_redirect", "sc_redir", $nmgp_formula);
            $nmgp_formula = str_replace("sc_redir", "sc_redirect", $nmgp_formula);
            nm_formula_php($nmgp_formula, "menu", "0");
            if ($nmgp_tem_redirect)
            {
                $nmgp_formula = str_replace("\$_SESSION['scriptcase']['sc_apl_menu_link']", "\$" . $nome_classe . "_menuData['url']['link']", $nmgp_formula);
                $nmgp_formula = str_replace('_form_php.php', '.php', $nmgp_formula);
            }
            $nmgp_formula = str_replace("\$this->Ini->path_link", "\$path_link", $nmgp_formula);
            $nmgp_formula = str_replace("\$this->Campos_Mens_erro", "\$Campos_Mens_erro", $nmgp_formula);
            $nmgp_formula = str_replace("\$this->Ini->sc_page", "'1'", $nmgp_formula);
            $nmgp_formula = str_replace("\$this->Ini->", "\$this->", $nmgp_formula);
            $this->appendToFile($arq, "<?php ");
            $this->appendToFile($arq, "      " . $nmgp_formula . "\r\n");
            $this->appendToFile($arq, " ?> ");
        }
    }

}

?>