PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for "main"."company"
-- ----------------------------

CREATE TABLE company (
  companyid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  fld_name VARCHAR(200) COLLATE NOCASE NULL
);

-- ----------------------------
-- Records of company
-- ----------------------------
INSERT INTO "company" VALUES (1, 'Large Bank and Trust');
INSERT INTO "company" VALUES (2, 'Sample Co');
INSERT INTO "company" VALUES (3, 'Healthy Care');
INSERT INTO "company" VALUES (4, 'Aircrafts Inc');
INSERT INTO "company" VALUES (5, 'Acme Technology');

-- ----------------------------
-- Table structure for "main"."contacts"
-- ----------------------------

CREATE TABLE contacts (
contactid INTEGER PRIMARY KEY,
fld_name VARCHAR(200) COLLATE NOCASE NOT NULL DEFAULT '""',
company INTEGER,
title VARCHAR(200) COLLATE NOCASE,
department INTEGER,
phone VARCHAR(30) COLLATE NOCASE,
mobile VARCHAR(30) COLLATE NOCASE,
fax VARCHAR(30) COLLATE NOCASE,
email VARCHAR(200) COLLATE NOCASE,
recordowner INTEGER,
lastmodifyby INTEGER
);

-- ----------------------------
-- Records of contacts
-- ----------------------------
INSERT INTO "contacts" VALUES (1, 'Lisa Jones', 1, 'Finance Director', 1, 6175554567, '', '', 'jones@example.com', 1, 1);
INSERT INTO "contacts" VALUES (2, 'John Hunh', 1, 'Vp Special Proejcts', 2, 8132208977, '', '', 'hunh@example.com', 1, 1);
INSERT INTO "contacts" VALUES (3, 'Linda Rice', 2, 'VP Customer Service', 3, 6175559874, '', '', 'rice@example.com', 1, 1);
INSERT INTO "contacts" VALUES (4, 'Susan Campbell', 3, 'IT Manager', 4, 6175552345, '', '', 'campbell@example.com', 3, 3);
INSERT INTO "contacts" VALUES (5, 'Marshall Azar', 4, 'Development Manager', 2, 6175551234, '', '', 'asar@example.com', 3, 3);
INSERT INTO "contacts" VALUES (6, 'Alan White', 5, 'Marketing Director', 6, 6175551111, '', '', 'white@example.com', 3, 3);

-- ----------------------------
-- Table structure for "main"."department"
-- ----------------------------

CREATE TABLE department (
  departmentid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  fld_name VARCHAR(200) COLLATE NOCASE NULL
);

-- ----------------------------
-- Records of department
-- ----------------------------
INSERT INTO "department" VALUES (1, 'Finance');
INSERT INTO "department" VALUES (2, 'Engineering');
INSERT INTO "department" VALUES (3, 'Operations');
INSERT INTO "department" VALUES (4, 'Information Technology');
INSERT INTO "department" VALUES (5, 'QA');
INSERT INTO "department" VALUES (6, 'Marketing');
INSERT INTO "department" VALUES (7, 'Management');

-- ----------------------------
-- Table structure for "main"."documenthistory"
-- ----------------------------

CREATE TABLE documenthistory (
  documenthistoryid INTEGER  NOT NULL PRIMARY KEY AUTOINCREMENT,
  documentlibraryid INTEGER  NOT NULL,
  revision INTEGER  NULL,
  datecreated DATE NULL,
  fileformat VARCHAR(100) COLLATE NOCASE NULL,
  attachment BLOB NULL,
  recordowner INTEGER  NULL,
  documentcurrent CHAR(1) NULL
);

-- ----------------------------
-- Records of documenthistory
-- ----------------------------
INSERT INTO "documenthistory" VALUES (1, 1, 1, '2009-07-14', 'scproject.xml', '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', 1, 'N');
INSERT INTO "documenthistory" VALUES (2, 1, 2, '2009-07-14', 'scproject.xml', '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', 1, 'N');
INSERT INTO "documenthistory" VALUES (3, 1, 3, '2009-07-14', 'scproject.xml', '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', 1, 'Y');
INSERT INTO "documenthistory" VALUES (4, 2, 1, '2010-02-24', 'samples.txt', 'NjQsNjMsNjINCg0KSU5TRVJUIElOVE8gYG5tX2V4ZW1wbG9zX2dydXBvc19pdGVuc2AgKA0KYGNvZGlnb2AgLA0KYGV4ZW1wbG9fZ3J1cG9zYCAsDQpgdGl0dWxvYCAsDQpgdXJsYCAsDQpgdXJsX3ZpZGVvYCAsDQpgdGFyZ2V0YCAsDQpgdGFyZ2V0X3ZpZGVvYCAsDQpgb3JkZW1gICwNCmBzZWxvYWpheF9zbmAgLA0KYHNlbG9uZXdfc25gICwNCmBkZXNjcmAgLA0KYGRlc3RhcXVlX29yZGVyYCAsDQpgdmlld3NgDQopDQpWQUxVRVMgKA0KTlVMTCAsICcyJywgJ0xpbmUgY2hhcnQgJywgJy9zaXN0ZW1hcy92NS9leGVtcGxvc19lbl91cy9ncmlkNDIvZ3JpZDQyLnBocCcsIE5VTEwsICdfYmxhbmsnLCAncG9wdXAnLCAnMicsICdTJywgJ1MnLCAnVGhpcyBleGFtcGxlIHNob3dzIGFuIGdyaWQgYXBwbGljYXRpb24gdXNpbmcgdGhlIGxpbmUgY2hhcnQnLCAnMicsICcxJw0KKTsNCg0KDQoNCklOU0VSVCBJTlRPIGBubV9leGVtcGxvc19ncnVwb3NfaXRlbnNgICgNCmBjb2RpZ29gICwNCmBleGVtcGxvX2dydXBvc2AgLA0KYHRpdHVsb2AgLA0KYHVybGAgLA0KYHVybF92aWRlb2AgLA0KYHRhcmdldGAgLA0KYHRhcmdldF92aWRlb2AgLA0KYG9yZGVtYCAsDQpgc2Vsb2FqYXhfc25gICwNCmBzZWxvbmV3X3NuYCAsDQpgZGVzY3JgICwNCmBkZXN0YXF1ZV9vcmRlcmAgLA0KYHZpZXdzYA0KKQ0KVkFMVUVTICgNCk5VTEwgLCAnNCcsICdNZW51IHVzaW5nIGluaXRpYWwgQXBwbGljYXRpb24nLCAnL3Npc3RlbWFzL3Y1L2V4ZW1wbG9zX2VuX3VzL21lbnUwMy9tZW51MDMucGhwJywgTlVMTCAsICdfYmxhbmsnLCAncG9wdXAnLCAnMicsICdTJywgJ1MnLCAnTWVudSBhcHBsaWNhdGlvbiB1c2luZyBpbml0aWFsIGFwcGxpY2F0aW9uJywgJzMnLCAnMScNCik7DQoNCi9ubS93d3cvc2NyaXB0Y2FzZTVubS9kZXZlbC9jb25mL3NjcmlwdGNhc2Uvbm1fc2FtcGxlcy5kYg==', 2, 'N');
INSERT INTO "documenthistory" VALUES (5, 2, 2, '2010-02-24', 'samples.txt', '', 2, 'Y');

-- ----------------------------
-- Table structure for "main"."documentlibrary"
-- ----------------------------

CREATE TABLE documentlibrary (
  documentlibraryid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  projectid INTEGER NULL,
  title VARCHAR(200) COLLATE NOCASE NULL,
  description TEXT COLLATE NOCASE NULL,
  attachment BLOB NULL,
  filetype VARCHAR(30) COLLATE NOCASE NULL,
  fileformat VARCHAR(100) COLLATE NOCASE NULL,
  datecreated DATE NULL,
  datemodified DATE NULL,
  recordowner INTEGER NULL,
  lastmodifiedby INTEGER NULL
);

-- ----------------------------
-- Records of documentlibrary
-- ----------------------------
INSERT INTO "documentlibrary" VALUES (2, 7, 'Project MER', 'test', 'NjQsNjMsNjINCg0KSU5TRVJUIElOVE8gYG5tX2V4ZW1wbG9zX2dydXBvc19pdGVuc2AgKA0KYGNvZGlnb2AgLA0KYGV4ZW1wbG9fZ3J1cG9zYCAsDQpgdGl0dWxvYCAsDQpgdXJsYCAsDQpgdXJsX3ZpZGVvYCAsDQpgdGFyZ2V0YCAsDQpgdGFyZ2V0X3ZpZGVvYCAsDQpgb3JkZW1gICwNCmBzZWxvYWpheF9zbmAgLA0KYHNlbG9uZXdfc25gICwNCmBkZXNjcmAgLA0KYGRlc3RhcXVlX29yZGVyYCAsDQpgdmlld3NgDQopDQpWQUxVRVMgKA0KTlVMTCAsICcyJywgJ0xpbmUgY2hhcnQgJywgJy9zaXN0ZW1hcy92NS9leGVtcGxvc19lbl91cy9ncmlkNDIvZ3JpZDQyLnBocCcsIE5VTEwsICdfYmxhbmsnLCAncG9wdXAnLCAnMicsICdTJywgJ1MnLCAnVGhpcyBleGFtcGxlIHNob3dzIGFuIGdyaWQgYXBwbGljYXRpb24gdXNpbmcgdGhlIGxpbmUgY2hhcnQnLCAnMicsICcxJw0KKTsNCg0KDQoNCklOU0VSVCBJTlRPIGBubV9leGVtcGxvc19ncnVwb3NfaXRlbnNgICgNCmBjb2RpZ29gICwNCmBleGVtcGxvX2dydXBvc2AgLA0KYHRpdHVsb2AgLA0KYHVybGAgLA0KYHVybF92aWRlb2AgLA0KYHRhcmdldGAgLA0KYHRhcmdldF92aWRlb2AgLA0KYG9yZGVtYCAsDQpgc2Vsb2FqYXhfc25gICwNCmBzZWxvbmV3X3NuYCAsDQpgZGVzY3JgICwNCmBkZXN0YXF1ZV9vcmRlcmAgLA0KYHZpZXdzYA0KKQ0KVkFMVUVTICgNCk5VTEwgLCAnNCcsICdNZW51IHVzaW5nIGluaXRpYWwgQXBwbGljYXRpb24nLCAnL3Npc3RlbWFzL3Y1L2V4ZW1wbG9zX2VuX3VzL21lbnUwMy9tZW51MDMucGhwJywgTlVMTCAsICdfYmxhbmsnLCAncG9wdXAnLCAnMicsICdTJywgJ1MnLCAnTWVudSBhcHBsaWNhdGlvbiB1c2luZyBpbml0aWFsIGFwcGxpY2F0aW9uJywgJzMnLCAnMScNCik7DQoNCi9ubS93d3cvc2NyaXB0Y2FzZTVubS9kZXZlbC9jb25mL3NjcmlwdGNhc2Uvbm1fc2FtcGxlcy5kYg==', 'SPECIFICATION', 'samples.txt', '2010-02-24', '2010-02-24', 2, 2);

-- ----------------------------
-- Table structure for "main"."filetype"
-- ----------------------------

CREATE TABLE filetype (
  filetypeid VARCHAR(30) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(filetypeid)
);

-- ----------------------------
-- Records of filetype
-- ----------------------------
INSERT INTO "filetype" VALUES ('BUDGET', 'Budget');
INSERT INTO "filetype" VALUES ('COPY', 'Copy');
INSERT INTO "filetype" VALUES ('MARKETING-DOCUMENT', 'Marketing Document');
INSERT INTO "filetype" VALUES ('REQUIREMENTS', 'Requirements');
INSERT INTO "filetype" VALUES ('SPECIFICATION', 'Specification');

-- ----------------------------
-- Table structure for "main"."issuepriority"
-- ----------------------------

CREATE TABLE issuepriority (
  priorityid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(priorityid)
);

-- ----------------------------
-- Records of issuepriority
-- ----------------------------
INSERT INTO "issuepriority" VALUES ('HIGH', 'High');
INSERT INTO "issuepriority" VALUES ('MEDIUM', 'Medium');
INSERT INTO "issuepriority" VALUES ('LOW', 'Low');

-- ----------------------------
-- Table structure for "main"."issues"
-- ----------------------------

CREATE TABLE issues (
issueid INTEGER NOT NULL PRIMARY KEY,
issuename VARCHAR(200) COLLATE NOCASE,
description TEXT COLLATE NOCASE,
assignedto INTEGER,
duedate DATE,
issuestatus VARCHAR(100) COLLATE NOCASE,
projectid INTEGER,
updates TEXT COLLATE NOCASE,
resolution TEXT COLLATE NOCASE,
issuepriority VARCHAR(100) COLLATE NOCASE,
dateidentified DATE,
daysoverdue INT,
dateresolved DATE ,
datecreated DATE,
datemodified DATE,
recordowner INTEGER,
lastmodifiedby INTEGER
);

-- ----------------------------
-- Records of issues
-- ----------------------------
INSERT INTO "issues" VALUES (1, 'Security audit problems', X'5468652070726F706F736564206E6574776F726B20746F706F6C6F677920646964206E6F74207061737320746865207363727574696E79206F6620746865207365637572697479207465616D207765206E65656420746F20616464206D6F7265206C6179657273206F662070726F74656374696F6E20746F20746865206F726967696E616C2064657369676E0A', 3, '2008-11-14', 'CLOSED', 6, '', X'4164646564206C617965727473206F662070726F74656374696F6E20616E64207465737465642E20200A', 'HIGH', '2008-11-07', 472, '2010-03-01', '2009-08-04', '2010-03-01', 2, 2);
INSERT INTO "issues" VALUES (2, 'Significant usability feedback ', X'5468652075736162696C69747920666565646261636B20696E64696361746573206D616A6F722070726F626C656D7320776974682066756E64616D656E74616C2064657369676E2E205765206E65656420746F20676F206261636B20746F207468652064726177696E6720626F6172642E0D0A', 4, '2009-01-06', 'OPEN', 8, '', '', 'HIGH', '2008-11-29', 210, null, '2009-08-04', '2009-08-04', 2, 2);
INSERT INTO "issues" VALUES (3, 'ROI model is flawed ', X'54686520524F49206D6F64656C207468617420776173206372656174656420666F72207468652070726F6A65637420697320666C617765642E20497420756E646572657374696D617465732074686520616D6F756E74206F6620656E64207573657273207669736974696E67207468652073697465207468657265666F72652074686520636F73742070657220636C69656E7420697320746F6F206C6F772E205765206E65656420746F2072657669736520616E642073656E64206261636B20746F2074686520636C69656E740D0A', 1, '2008-11-17', 'OPEN', 9, X'5B4645422D31312D303320517569636B426173655D20466F756E64206C6173742079656172732073697465207669736974730D0A', X'466F756E642061637475616C2076697369747320666F72206C617374207965617220616E64206372656174656420616E20757020746F206461746520666F7265636173742E0D0A', 'LOW', '2008-11-15', 260, null, '2009-08-04', '2009-08-04', 2, 2);

-- ----------------------------
-- Table structure for "main"."issuestatus"
-- ----------------------------

CREATE TABLE issuestatus (
  statusid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(statusid)
);

-- ----------------------------
-- Records of issuestatus
-- ----------------------------
INSERT INTO "issuestatus" VALUES ('OPEN', 'Open');
INSERT INTO "issuestatus" VALUES ('CLOSED', 'Closed');

-- ----------------------------
-- Table structure for "main"."lookup"
-- ----------------------------

CREATE TABLE "lookup" (
"code"  VARCHAR(100) COLLATE NOCASE,
"xkey"  VARCHAR(100) COLLATE NOCASE,
"description"  VARCHAR(200) COLLATE NOCASE,
"pm_type"  VARCHAR(100) COLLATE NOCASE,
PRIMARY KEY ("code" ASC, "xkey")
);

-- ----------------------------
-- Records of lookup
-- ----------------------------
INSERT INTO "lookup" VALUES ('contactid', 'contacts', 'contactid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('name', 'contacts', 'name', 'TEXT');
INSERT INTO "lookup" VALUES ('company', 'contacts', 'company', 'NUMERIC');
INSERT INTO "lookup" VALUES ('title', 'contacts', 'title', 'TEXT');
INSERT INTO "lookup" VALUES ('department', 'contacts', 'department', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Phone', 'contacts', 'Phone', 'TEXT');
INSERT INTO "lookup" VALUES ('Mobile', 'contacts', 'Mobile', 'TEXT');
INSERT INTO "lookup" VALUES ('Fax', 'contacts', 'Fax', 'TEXT');
INSERT INTO "lookup" VALUES ('EMail', 'contacts', 'EMail', 'TEXT');
INSERT INTO "lookup" VALUES ('RecordOwner', 'contacts', 'RecordOwner', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LastModifyBy', 'contacts', 'LastModifyBy', 'NUMERIC');
INSERT INTO "lookup" VALUES ('documentlibraryid', 'documentlibrary', 'documentlibraryid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('projectid', 'documentlibrary', 'projectid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('title', 'documentlibrary', 'title', 'TEXT');
INSERT INTO "lookup" VALUES ('description', 'documentlibrary', 'description', 'TEXT');
INSERT INTO "lookup" VALUES ('Attachment', 'documentlibrary', 'Attachment', 'BLOB');
INSERT INTO "lookup" VALUES ('filetype', 'documentlibrary', 'filetype', 'TEXT');
INSERT INTO "lookup" VALUES ('FileFormat', 'documentlibrary', 'FileFormat', 'TEXT');
INSERT INTO "lookup" VALUES ('DateCreated', 'documentlibrary', 'DateCreated', 'DATE');
INSERT INTO "lookup" VALUES ('DateModified', 'documentlibrary', 'DateModified', 'DATE');
INSERT INTO "lookup" VALUES ('RecordOwner', 'documentlibrary', 'RecordOwner', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LastModifiedBy', 'documentlibrary', 'LastModifiedBy', 'NUMERIC');
INSERT INTO "lookup" VALUES ('IssueID', 'issues', 'IssueID', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Issuename', 'issues', 'Issuename', 'TEXT');
INSERT INTO "lookup" VALUES ('description', 'issues', 'description', 'TEXT');
INSERT INTO "lookup" VALUES ('AssignedTo', 'issues', 'AssignedTo', 'NUMERIC');
INSERT INTO "lookup" VALUES ('DueDate', 'issues', 'DueDate', 'DATE');
INSERT INTO "lookup" VALUES ('IssueStatus', 'issues', 'IssueStatus', 'TEXT');
INSERT INTO "lookup" VALUES ('projectid', 'issues', 'projectid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Updates', 'issues', 'Updates', 'TEXT');
INSERT INTO "lookup" VALUES ('Resolution', 'issues', 'Resolution', 'TEXT');
INSERT INTO "lookup" VALUES ('issuepriority', 'issues', 'issuepriority', 'TEXT');
INSERT INTO "lookup" VALUES ('DateIdentified', 'issues', 'DateIdentified', 'DATE');
INSERT INTO "lookup" VALUES ('DataResolved', 'issues', 'DataResolved', 'DATE');
INSERT INTO "lookup" VALUES ('DateCreated', 'issues', 'DateCreated', 'DATE');
INSERT INTO "lookup" VALUES ('DateModified', 'issues', 'DateModified', 'DATE');
INSERT INTO "lookup" VALUES ('RecordOwner', 'issues', 'RecordOwner', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LastModifiedBy', 'issues', 'LastModifiedBy', 'NUMERIC');
INSERT INTO "lookup" VALUES ('projectid', 'projects', 'projectid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('RecordOwner', 'projects', 'RecordOwner', 'TEXT');
INSERT INTO "lookup" VALUES ('ProjectLead', 'projects', 'ProjectLead', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LastModifiedBy', 'projects', 'LastModifiedBy', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Projectname', 'projects', 'Projectname', 'NUMERIC');
INSERT INTO "lookup" VALUES ('company', 'projects', 'company', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Contactname', 'projects', 'Contactname', 'TEXT');
INSERT INTO "lookup" VALUES ('Summary', 'projects', 'Summary', 'TEXT');
INSERT INTO "lookup" VALUES ('EstimatedProjectStart', 'projects', 'EstimatedProjectStart', 'DATE');
INSERT INTO "lookup" VALUES ('EstimatedProjectEnd', 'projects', 'EstimatedProjectEnd', 'DATE');
INSERT INTO "lookup" VALUES ('projectpriority', 'projects', 'projectpriority', 'TEXT');
INSERT INTO "lookup" VALUES ('projectstatus', 'projects', 'projectstatus', 'TEXT');
INSERT INTO "lookup" VALUES ('Notes', 'projects', 'Notes', 'TEXT');
INSERT INTO "lookup" VALUES ('Start', 'projects', 'Start', 'DATE');
INSERT INTO "lookup" VALUES ('PlannedFinishDate', 'projects', 'PlannedFinishDate', 'DATE');
INSERT INTO "lookup" VALUES ('PercenteComplete', 'projects', 'PercenteComplete', 'NUMERIC');
INSERT INTO "lookup" VALUES ('CustomerContact', 'projects', 'CustomerContact', 'NUMERIC');
INSERT INTO "lookup" VALUES ('ActualCost', 'projects', 'ActualCost', 'NUMERIC');
INSERT INTO "lookup" VALUES ('EstimatedCost', 'projects', 'EstimatedCost', 'NUMERIC');
INSERT INTO "lookup" VALUES ('ActualHours', 'projects', 'ActualHours', 'NUMERIC');
INSERT INTO "lookup" VALUES ('EstimetedHours', 'projects', 'EstimetedHours', 'NUMERIC');
INSERT INTO "lookup" VALUES ('PercentOverBudget', 'projects', 'PercentOverBudget', 'NUMERIC');
INSERT INTO "lookup" VALUES ('DateCreated', 'projects', 'DateCreated', 'NUMERIC');
INSERT INTO "lookup" VALUES ('DateModified', 'projects', 'DateModified', 'NUMERIC');
INSERT INTO "lookup" VALUES ('TaskID', 'tasks', 'TaskID', 'NUMERIC');
INSERT INTO "lookup" VALUES ('projectid', 'tasks', 'projectid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('projectphase', 'tasks', 'projectphase', 'TEXT');
INSERT INTO "lookup" VALUES ('Taskname', 'tasks', 'Taskname', 'TEXT');
INSERT INTO "lookup" VALUES ('Milestone', 'tasks', 'Milestone', 'TEXT');
INSERT INTO "lookup" VALUES ('description', 'tasks', 'description', 'TEXT');
INSERT INTO "lookup" VALUES ('Duration', 'tasks', 'Duration', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Start', 'tasks', 'Start', 'DATE');
INSERT INTO "lookup" VALUES ('FinishDate', 'tasks', 'FinishDate', 'DATE');
INSERT INTO "lookup" VALUES ('DaysOverdue', 'tasks', 'DaysOverdue', 'NUMERIC');
INSERT INTO "lookup" VALUES ('taskstatus', 'tasks', 'taskstatus', 'TEXT');
INSERT INTO "lookup" VALUES ('PercentComplete', 'tasks', 'PercentComplete', 'NUMERIC');
INSERT INTO "lookup" VALUES ('taskpriority', 'tasks', 'taskpriority', 'TEXT');
INSERT INTO "lookup" VALUES ('AssignedTo', 'tasks', 'AssignedTo', 'NUMERIC');
INSERT INTO "lookup" VALUES ('HistoryNote', 'tasks', 'HistoryNote', 'TEXT');
INSERT INTO "lookup" VALUES ('DateCreated', 'tasks', 'DateCreated', 'DATE');
INSERT INTO "lookup" VALUES ('DateModified', 'tasks', 'DateModified', 'DATE');
INSERT INTO "lookup" VALUES ('RecordOwner', 'tasks', 'RecordOwner', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LastModifiedBy', 'tasks', 'LastModifiedBy', 'NUMERIC');
INSERT INTO "lookup" VALUES ('TaskPredecessor', 'tasks', 'TaskPredecessor', 'TEXT');
INSERT INTO "lookup" VALUES ('timecardID', 'timecard', 'timecardID', 'NUMERIC');
INSERT INTO "lookup" VALUES ('projectid', 'timecard', 'projectid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('ResourceID', 'timecard', 'ResourceID', 'NUMERIC');
INSERT INTO "lookup" VALUES ('WeekStartingOn', 'timecard', 'WeekStartingOn', 'DATE');
INSERT INTO "lookup" VALUES ('Sun', 'timecard', 'Sun', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Mon', 'timecard', 'Mon', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Tue', 'timecard', 'Tue', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Wed', 'timecard', 'Wed', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Thu', 'timecard', 'Thu', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Fri', 'timecard', 'Fri', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Sat', 'timecard', 'Sat', 'NUMERIC');
INSERT INTO "lookup" VALUES ('DateCreated', 'timecard', 'DateCreated', 'DATE');
INSERT INTO "lookup" VALUES ('DateModified', 'timecard', 'DateModified', 'DATE');
INSERT INTO "lookup" VALUES ('RecordOwner', 'timecard', 'RecordOwner', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LastModifiedBy', 'timecard', 'LastModifiedBy', 'NUMERIC');
INSERT INTO "lookup" VALUES ('EQUALTO', 'CRITERIA', 'Equal to', 'NUMERIC');
INSERT INTO "lookup" VALUES ('BEGINNINGWITH', 'CRITERIA', 'Beginning with', 'NUMERIC');
INSERT INTO "lookup" VALUES ('CONTAINS', 'CRITERIA', 'Contains', 'NUMERIC');
INSERT INTO "lookup" VALUES ('DIFFERENT', 'CRITERIA', 'Different', 'NUMERIC');
INSERT INTO "lookup" VALUES ('GREATERTHAN', 'CRITERIA', 'Greater than', 'NUMERIC');
INSERT INTO "lookup" VALUES ('GREATEREQUAL', 'CRITERIA', 'Greater Equal', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LESSTHAN', 'CRITERIA', 'Less than', 'NUMERIC');
INSERT INTO "lookup" VALUES ('LESSEQUAL', 'CRITERIA', 'Less Equal', 'NUMERIC');
INSERT INTO "lookup" VALUES ('BETWEEN', 'CRITERIA', 'Between', 'NUMERIC');
INSERT INTO "lookup" VALUES ('IN', 'CRITERIA', 'In', 'NUMERIC');
INSERT INTO "lookup" VALUES ('NULL', 'CRITERIA', 'NULL', 'NUMERIC');
INSERT INTO "lookup" VALUES ('NOTNULL', 'CRITERIA', 'Not NULL', 'NUMERIC');
INSERT INTO "lookup" VALUES ('ResourceID', 'resources', 'ResourceID', 'NUMERIC');
INSERT INTO "lookup" VALUES ('name', 'resources', 'name', 'NUMERIC');
INSERT INTO "lookup" VALUES ('BussinesPhone', 'resources', 'BussinesPhone', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Rate', 'resources', 'Rate', 'NUMERIC');
INSERT INTO "lookup" VALUES ('Jobtitle', 'resources', 'Jobtitle', 'NUMERIC');
INSERT INTO "lookup" VALUES ('companyid', 'resources', 'companyid', 'NUMERIC');
INSERT INTO "lookup" VALUES ('departmentID', 'resources', 'departmentID', 'NUMERIC');
INSERT INTO "lookup" VALUES ('DaysOverdue', 'issues', 'Days Overdue', 'NUMERIC');

-- ----------------------------
-- Table structure for "main"."projectphase"
-- ----------------------------

CREATE TABLE projectphase (
  projectphaseid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(projectphaseid)
);

-- ----------------------------
-- Records of projectphase
-- ----------------------------
INSERT INTO "projectphase" VALUES ('PLANINNG', 'Planning');
INSERT INTO "projectphase" VALUES ('DESIGN', 'Design');
INSERT INTO "projectphase" VALUES ('DEVELOPMENT', 'Development');
INSERT INTO "projectphase" VALUES ('TEST', 'Test');

-- ----------------------------
-- Table structure for "main"."projectpriority"
-- ----------------------------

CREATE TABLE projectpriority (
  priorityid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(priorityid)
);

-- ----------------------------
-- Records of projectpriority
-- ----------------------------
INSERT INTO "projectpriority" VALUES ('HIGH', 'High');
INSERT INTO "projectpriority" VALUES ('MEDIUM', 'Medium');
INSERT INTO "projectpriority" VALUES ('LOW', 'Low');
INSERT INTO "projectpriority" VALUES ('VERYHIGH', 'Very High');

-- ----------------------------
-- Table structure for "main"."projects"
-- ----------------------------

CREATE TABLE projects (
projectid INTEGER NOT NULL PRIMARY KEY,
recordowner VARCHAR(200) COLLATE NOCASE NOT NULL DEFAULT "",
projectlead INTEGER NOT NULL,
lastmodifiedby INTEGER NOT NULL,
projectname INTEGER,
company INTEGER,
contactname VARCHAR(200) COLLATE NOCASE,
summary TEXT COLLATE NOCASE,
estimatedprojectstart DATE,
estimatedprojectend DATE,
projectpriority VARCHAR(100) COLLATE NOCASE,
projectstatus VARCHAR(100) COLLATE NOCASE,
notes TEXT COLLATE NOCASE,
startdate DATE,
plannedfinishdate DATE,
percentecomplete INTEGER,
customercontact INTEGER,
actualcost NUMERIC(20,3),
estimatedcost NUMERIC(20,3),
actualhours INTEGER,
estimetedhours INTEGER,
percentoverbudget INTEGER,
datecreated INTEGER,
datemodified INTEGER
);

-- ----------------------------
-- Records of projects
-- ----------------------------
INSERT INTO "projects" VALUES (6, 3, 2, 3, 'Customer Service system update', 2, 'Linda Rice', X'55706461746520616E6420737570706C79206E657720636F6D70757465727320746F20637573746F6D65722073657276696365207465616D2E2020546869732070726F6A6563742077696C6C20696E636C756465206E6574776F726B696E6720616C6C206F6620746865736520636F6D70757465727320746F206769766520757365727320746865206162696C69747920746F207368617265204F7261636C65206461746162617365733B20696E7465726E6574206163636573733B20616E64206F74686572206D756C74692D7461736B696E672066756E6374696F6E732E0A', '2008-08-16', null, 'HIGH', 'OPEN', '', '2008-08-16', null, 81.25, 0, 3520, 5000, 32, 60, 70, 1998, 1997);
INSERT INTO "projects" VALUES (7, 3, 2, 3, 'Customer Financial system upgrade', 2, 'John Hunh', X'5570646174652077697468206C61746573742072656C65617365206F662044424D5320616E6420696E7374616C6C206E65772066696E616E6369616C207061636B6167650A', '2007-08-16', null, 'MEDIUM', 'COMPLETED', '', '2007-08-16', '2009-08-04', 100, 0, 5845, 15000, 63, 200, 38, 1998, 2006);
INSERT INTO "projects" VALUES (8, 3, 4, 3, 'Increase Web Presence', 2, 'Alan White', X'526566696E6520616E6420657870616E6420696E7465726E65742070726573656E636520666F7220576972656C657373207465616D207468726F7567682061206D6F726520736F706869737469636174656420616E6420696E74657261637469766520776562207369746520746861742077696C6C20616C6C6F7720696E646976696475616C7320746F2062726F77736520617661696C61626C6520746563686E6F6C6F67790A', '2008-09-15', '2009-10-20', 'LOW', 'IN-PROGRESS', '', '2008-09-15', null, 66, 0, 2250, 4150, 30, 50, 54, 1998, 2006);
INSERT INTO "projects" VALUES (9, 2, 4, 2, 'Wireless initiative', 2, 'John Hunh', '', '2008-09-08', null, 'MEDIUM', 'IN-PROGRESS', '', '2008-09-08', null, 42, 0, 0, 1500, 0, 50, 0, 1998, 1997);
INSERT INTO "projects" VALUES (10, 2, 2, 2, 'Deploy Document Management system', 2, 'Marshall Azar', X'496E7374616C6C20646F63756D656E74206D616E6167656D656E742073797374656D20616E6420747261696E20656E67696E656572696E672073746166660A', '2009-08-01', null, 'MEDIUM', 'OPEN', '', '2009-08-03', null, 50, 0, 6955, 8000, 91, 100, 86, 1998, 2006);
INSERT INTO "projects" VALUES (11, 2, 4, 2, 'T3 install', 2, 'Susan Campbell', X'43617264696E616C20686173207365656E2061207472656D656E646F75732067726F77746820666F72207468656972206F6E6C696E6520736572766963657320616E64207468656972206C6F63616C206E6574776F726B206F7065726174696F6E732063656E746572206E6565647320616E20757067726164652066726F6D20543120746F2054330D0A', '2008-11-14', null, 'LOW', 'IN-PROGRESS', '', null, null, 7.5, 0, 6210, 10000, 76, 100, 0, 1998, 1998);
INSERT INTO "projects" VALUES (12, 2, 1, 2, 'ScriptCase Project Manager v1.0', 2, 'Alan White', 'Finish all the system requirements and prepare a release for it', '2009-09-16', '2009-09-18', 'HIGH', 'IN-PROGRESS', '', '2009-09-16', null, 0, 0, 110, 2000, 1, 20, 0, 1984, 1984);

-- ----------------------------
-- Table structure for "main"."projectstatus"
-- ----------------------------

CREATE TABLE projectstatus (
  statusid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(statusid)
);

-- ----------------------------
-- Records of projectstatus
-- ----------------------------
INSERT INTO "projectstatus" VALUES ('OPEN', 'Open');
INSERT INTO "projectstatus" VALUES ('IN-PROGRESS', 'In-progress');
INSERT INTO "projectstatus" VALUES ('COMPLETED', 'Completed');
INSERT INTO "projectstatus" VALUES ('ON-HOLD', 'On-Hold');

-- ----------------------------
-- Table structure for "main"."resources"
-- ----------------------------

CREATE TABLE "resources" (
resourceid  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
fld_name  VARCHAR(100) COLLATE NOCASE,
bussinesphone  VARCHAR(10) COLLATE NOCASE,
skillset  TEXT COLLATE NOCASE,
rate  NUMERIC(20,3),
notes  TEXT COLLATE NOCASE,
jobtitle  VARCHAR(100) COLLATE NOCASE,
reportsto  VARCHAR(100) COLLATE NOCASE,
departmentid  INTEGER,
companyid  INTEGER,
bussinessfax  VARCHAR(30) COLLATE NOCASE,
photo  BLOB,
datecreated  DATE,
datemodified  DATE,
recordowner  INTEGER,
lastmodifiedby  INTEGER,
login  varchar(255) COLLATE NOCASE,
pwd  varchar(255) COLLATE NOCASE
);

-- ----------------------------
-- Records of resources
-- ----------------------------
INSERT INTO "resources" VALUES (1, 'Albert Cruz', '(617) 555-4444', '', 110, '', 'Copywriter', '', 6, 2, '(617) 555-1111', '', '2009-07-13', '2009-09-17', 1, 1, 'admin', '21232f297a57a5a743894a0e4a801fc3');
INSERT INTO "resources" VALUES (2, 'Chris Baker', '(617) 555-1111', '', 90, '', 'Project Manager', '', 7, 2, '', '', '2009-07-23', '2010-02-24', 1, 1, 'chris', '21232f297a57a5a743894a0e4a801fc3');
INSERT INTO "resources" VALUES (3, 'Gregory Baxter', '(617) 555-5555', '', 80, '', 'HTML Editor', '', 6, 2, '', '', '2009-07-23', '2009-08-03', 1, 1, 'gregory', '21232f297a57a5a743894a0e4a801fc3');
INSERT INTO "resources" VALUES (4, 'Colleen Garton', '(617) 555-2233', '', 75, '', 'Developer', '', 2, 2, '', '', '2009-08-03', '2009-08-03', 3, 3, 'colleen', '21232f297a57a5a743894a0e4a801fc3');

-- ----------------------------
-- Table structure for "main"."taskpriority"
-- ----------------------------

CREATE TABLE taskpriority (
  priorityid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(priorityid)
);

-- ----------------------------
-- Records of taskpriority
-- ----------------------------
INSERT INTO "taskpriority" VALUES ('HIGH', 'High');
INSERT INTO "taskpriority" VALUES ('MEDIUM', 'Medium');
INSERT INTO "taskpriority" VALUES ('LOW', 'Low');
INSERT INTO "taskpriority" VALUES ('SAMPLE', 'Sample');

-- ----------------------------
-- Table structure for "main"."tasks"
-- ----------------------------

CREATE TABLE tasks (
taskid INTEGER NOT NULL PRIMARY KEY,
projectid INTEGER UNSIGNED,
projectphase VARCHAR(100) COLLATE NOCASE,
taskname VARCHAR(200) COLLATE NOCASE,
milestone CHAR(1),
description TEXT COLLATE NOCASE,
duration INTEGER,
startdate DATE,
finishdate DATE,
daysoverdue INTEGER,
taskstatus VARCHAR(100) COLLATE NOCASE,
percentcomplete INTEGER,
taskpriority VARCHAR(100) COLLATE NOCASE,
assignedto INTEGER,
historynote TEXT COLLATE NOCASE,
datecreated DATE,
datemodified DATE,
recordowner INTEGER,
lastmodifiedby INTEGER,
taskpredecessor VARCHAR(200) COLLATE NOCASE,
actualfinishdate DATE 
);

-- ----------------------------
-- Records of tasks
-- ----------------------------
INSERT INTO "tasks" VALUES (1, 7, 'DEVELOPMENT', 'Upgrade DBMS', 'Y', X'44424D5320686173206E6577207468726F756768707574206361706163697479207468652077696C6C20696E637265617365207472616E73616374696F6E207370656564206279203330250A', 4, '2008-12-06', '2008-12-10', 442, 'COMPLETED', 100, 'HIGH', 2, '', '2009-08-03', '2010-02-25', 0, 1, '', '2010-02-25');
INSERT INTO "tasks" VALUES (2, 7, 'DEVELOPMENT', 'Install latest version of Financial system', '', X'44424D5320757067726164652077696C6C2072657175697265206C61746573742076657273696F6E206F662046696E616E63652073797374656D20666F7220636F6D7061746962696C69747920726561736F6E730D0A', 3, '2008-12-19', '2008-12-22', 0, 'COMPLETED', 100, 'HIGH', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (3, 7, 'DEVELOPMENT', 'Switch to T3', 'Y', X'506879736963616C2073776974636820646174650D0A', 2, '2009-02-11', '2009-02-13', 0, 'COMPLETED', 100, 'MEDIUM', 4, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (4, 6, 'PLANINNG', 'Project Approval', 'Y', X'50726F6A65637420726571756972657320617070726F76616C2066726F6D207570706572206D616E6167656D656E7420746F206D6F766520666F7277617264207769746820706C616E0A', 0, '2008-12-06', '2008-12-06', 450, 'COMPLETED', 100, 'LOW', 3, '', '2009-08-03', '2010-03-01', 0, 4, '', '2010-03-01');
INSERT INTO "tasks" VALUES (5, 6, 'PLANINNG', 'Workstation purchase', '', X'507572636861736520323020776F726B73746174696F6E730D0A', 12, '2008-12-13', '2008-12-25', 0, 'COMPLETED', 100, 'HIGH', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (6, 6, 'TEST', 'System test', '', X'4265746120746573742073797374656D0A', 3, '2009-02-14', '2009-02-17', 374, 'COMPLETED', 100, 'LOW', 2, 'agora terminou', '2009-08-03', '2010-02-26', 0, 1, '', '2010-02-26');
INSERT INTO "tasks" VALUES (7, 6, 'TEST', 'Total system conversion', '', X'53797374656D20436F6E76657273696F6E20616E642F6F7220726F6C6C6261636B0D0A', 4, '2009-02-09', '2009-02-13', 1186, 'NOT-STARTED', 25, 'LOW', 1, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (8, 10, 'PLANINNG', 'Requirements review', '', X'436F6E6475637420726571756972656D656E74732072657669657720776974682064657369676E207465616D206964656E74696679206E6565647320616E642077616E74730D0A', 4, '2009-02-05', '2009-02-09', 0, 'COMPLETED', 100, 'HIGH', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (9, 10, 'PLANINNG', 'Develop RFP', '', X'446576656C6F7065642052465020626173656420206F6E20636C69656E7420726571756972656D656E74730D0A', 2, '2009-02-05', '2009-02-07', 0, 'COMPLETED', 100, 'MEDIUM', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (10, 10, 'DEVELOPMENT', 'Install server side package', '', X'496E7374616C6C20616C6C20736572766572207369646520636F6D706F6E656E74730D0A', 2, '2009-03-30', '2009-04-01', 1139, 'NOT-STARTED', 0, 'MEDIUM', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (11, 10, 'TEST', 'Train engineering team on use and capability', '', X'547261696E207468652044657369676E207465616D206F6E206E65772073797374656D0D0A', 4, '2009-04-08', '2009-04-12', 1128, 'NOT-STARTED', 0, 'LOW', 4, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (12, 8, 'PLANINNG', 'Meet with client team', 'Y', X'4E65656420746F206D656574207769746820636C69656E74207465616D20746F20756E6465727374616E642063757272656E74207374617465206F66207369746520616E642077686174206973206E6F7420776F726B696E672077656C6C2E0D0A', 4, '2009-12-06', '2009-12-10', 0, 'COMPLETED', 100, 'MEDIUM', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (13, 8, 'DESIGN', 'Client review', '', X'4769766520636C69656E7420736F6D652074696D6520666F722072657669657720616E6420666565646261636B20666F722063686F73656E2064657369676E0D0A', 2, '2009-01-16', '2009-01-18', 0, 'COMPLETED', 100, 'MEDIUM', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (14, 8, 'DEVELOPMENT', 'Revise based on feedback', '', X'5265766973652064657369676E206261736564206F6E20666565646261636B0D0A', 5, '2009-01-20', '2009-01-25', 1205, 'NOT-STARTED', 0, 'MEDIUM', 4, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (15, 8, 'DEVELOPMENT', 'Design 1', '', X'50726573656E7420696E697469616C2064657369676E20746F20636C69656E740D0A', 3, '2009-01-23', '2009-01-26', 0, 'COMPLETED', 100, 'MEDIUM', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (16, 8, 'DEVELOPMENT', 'Deploy redesign', '', X'4465706C6F79206E65772064657369676E0D0A', 3, '2009-01-28', '2009-01-31', 0, 'COMPLETED', 100, 'LOW', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (17, 8, 'DESIGN', 'Propose site redesign', '', X'50726F706F736520746872656520646966666572656E7420617070726F616368657320746F20736F6C76696E672070726F626C656D20616E64206861766520636C69656E742063686F6F736520617070726F6163680D0A', 2, '2009-11-18', '2009-11-20', 906, 'NOT-STARTED', 0, 'MEDIUM', 4, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (18, 11, 'PLANINNG', 'Arrange switchover date', '', X'536574206461746520666F72207377697463686F7665720D0A', 3, '2009-11-04', '2009-11-07', 919, 'IN-PROGRESS', 15, 'MEDIUM', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (19, 11, 'PLANINNG', 'Follow-up w/ local vendor', '', X'43616C6C2054332070726F766964657220746F20617272616E6765206461746520616E64206C6F676973746963730A', 4, '2009-11-09', '2009-11-13', 913, 'NOT-STARTED', 0, 'HIGH', 2, '', '2009-08-03', '2012-05-14', 0, 1, '', null);
INSERT INTO "tasks" VALUES (20, 9, 'PLANINNG', 'End user feedback', '', X'4964656E746966792074686520737065636966696320656E642D757365722070726F626C656D206265696E6720736F6C76656420776974682074686520776972656C657373206170706C69636174696F6E2E204964656E7469667920616E642061677265652075706F6E207468652066756E6374696F6E616C20656C656D656E7473206F662074686520656E642D75736572277320757361676520657870657269656E63652E20416E616C797A6520616E6420646F63756D656E742074686520776972656C657373206170706C69636174696F6E20696E7465726E616C206D61726B6574206F70706F7274756E697479202E0D0A', 5, '2009-01-05', '2009-01-10', 0, 'COMPLETED', 100, 'HIGH', 1, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (21, 9, 'PLANINNG', 'ROI assessment', '', X'4964656E746966792074686520524F4920616E64206173736F636961746564207375636365737320666163746F72732E20436F6D6D756E696361746520616E64206761696E206275792D696E2066726F6D20626F74682073656E696F72206D616E6167656D656E7420616E642074686520776972656C6573732070726F6A656374207465616D2E200D0A', 6, '2009-01-09', '2009-01-15', 0, 'COMPLETED', 100, 'HIGH', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (22, 9, 'DEVELOPMENT', 'Deployment plan', '', X'446576656C6F702061206465706C6F796D656E7420706C616E207468617420696E636C756465733A20636F6D70726973696E67206465766963652070726F766973696F6E696E673B206E6574776F726B2061637469766174696F6E3B206170706C69636174696F6E20696E7374616C6C6174696F6E3B20757361676520747261636B696E673B2062756720747261636B696E6720616E6420757067726164652070726F636564757265732E0D0A', 4, '2009-01-23', '2009-01-27', 0, 'COMPLETED', 100, 'HIGH', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (23, 9, 'PLANINNG', 'Prototype', '', X'4576616C7561746520626F7468207468652073746F7279626F61726420616E642055492070726F746F747970652062792074657374696E67207468652070726F746F7479706520776972656C657373206170706C69636174696F6E206F6E206120726570726573656E7461746976652073616D706C65206F6620696E74656E64656420656E642D75736572732E0D0A', 4, '2009-01-25', '2009-01-29', 0, 'COMPLETED', 100, 'HIGH', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', '2009-08-03');
INSERT INTO "tasks" VALUES (24, 9, 'DEVELOPMENT', 'Unit test', '', X'556E6974207465737420626F74682074686520636C69656E742D7369646520616E64207365727665722D7369646520636F6D706F6E656E74732E0D0A', 30, '2009-02-03', '2009-03-05', 1166, 'IN-PROGRESS', 65, 'MEDIUM', 1, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (25, 9, 'DEVELOPMENT', 'Network Topology design', '', X'546865206E6574776F726B20746F706F6C6F677920697320616E206578616374206475706C6963617465206F6620746865206578697374696E672073797374656D207769746820657863657074696F6E206F6620726564756E64616E7420736572766572730D0A', 2, '2009-03-08', '2009-03-10', 1161, 'IN-PROGRESS', 0, 'LOW', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (26, 9, 'DEVELOPMENT', 'Alpha test', '', X'506572666F726D206174206C656173742032207765656B73206F66207374727563747572656420616C7068612074657374696E67207769746820612067726F7570206F6620352073656C656374656420656E642D75736572732E0D0A', 3, '2009-03-19', '2009-03-22', 1149, 'NOT-STARTED', 0, 'MEDIUM', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (27, 9, 'DEVELOPMENT', 'Beta test', '', X'506572666F726D206174206C656173742033207765656B73206F66207374727563747572656420626574612074657374696E672077697468206120726570726573656E7461746976652073616D706C65206F6620656E642D75736572732028757375616C6C7920313025292E0D0A', 5, '2009-03-04', '2009-03-09', 1162, 'IN-PROGRESS', 0, 'MEDIUM', 1, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (28, 9, 'TEST', 'Post deployment', '', X'506F7374206465706C6F796D656E743B20747261636B207573616765206F662074686520766172696F7573206665617475726573206F662074686520776972656C657373206170706C69636174696F6E2E2020547261636B20524F49206F74686572207661726961626C657320616E642063616C63756C6174652061637475616C2070726F6A65637420524F492E0D0A', 2, '2009-03-30', '2009-04-01', 1139, 'NOT-STARTED', 0, 'LOW', 2, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (29, 9, 'DEVELOPMENT', 'Design applications', '', X'44657369676E206170706C69636174696F6E27732077697468206120676F616C206F66206D6178696D697A696E6720726575736162696C697479206163726F737320616C6C20706F737369626C6520706C6174666F726D732E0D0A', 4, '2009-08-07', '2009-08-11', 1007, 'IN-PROGRESS', 0, 'HIGH', 3, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (30, 9, 'DEVELOPMENT', 'Integration testing', '', X'546573742074686520696E746567726174656420736F6C7574696F6E20696E2061207374727563747572656420666F726D61742E0D0A', 14, '2009-09-02', '2009-09-16', 971, 'NOT-STARTED', 0, 'MEDIUM', 1, '', '2009-08-03', '2009-08-03', 0, 0, '', null);
INSERT INTO "tasks" VALUES (31, 12, 'DEVELOPMENT', 'Implement language indexes in main menu', 'Y', 'Implement language indexes in main menu', 2, '2009-09-16', '2009-09-18', 969, 'IN-PROGRESS', 0, 'HIGH', 1, 'Arlindo will verify this ', '2009-09-16', '2010-03-01', 2, 4, '', null);

-- ----------------------------
-- Table structure for "main"."taskstatus"
-- ----------------------------

CREATE TABLE taskstatus (
  statusid VARCHAR(100) COLLATE NOCASE NOT NULL,
  description VARCHAR(200) COLLATE NOCASE NULL,
  PRIMARY KEY(statusid)
);

-- ----------------------------
-- Records of taskstatus
-- ----------------------------
INSERT INTO "taskstatus" VALUES ('NOT-STARTED', 'Not Started');
INSERT INTO "taskstatus" VALUES ('IN-PROGRESS', 'In progress');
INSERT INTO "taskstatus" VALUES ('ON-HOLD', 'On Hold');
INSERT INTO "taskstatus" VALUES ('COMPLETED', 'Completed');

-- ----------------------------
-- Table structure for "main"."timecard"
-- ----------------------------

CREATE TABLE timecard (
  timecardid INTEGER PRIMARY KEY AUTOINCREMENT,
  projectid INTEGER NULL,
  resourceid INTEGER UNIGNED NULL,
  weekstartingon DATE NULL,
  sun INTEGER NULL,
  mon INTEGER NULL,
  tue INTEGER NULL,
  wed INTEGER NULL,
  thu INTEGER NULL,
  fri INTEGER NULL,
  sat INTEGER NULL,
  datecreated DATE NULL,
  datemodified DATE NULL,
  recordowner INTEGER NULL,
  lastmodifiedby INTEGER NULL
);

-- ----------------------------
-- Records of timecard
-- ----------------------------
INSERT INTO "timecard" VALUES (5, 7, 1, '2008-02-07', 0, 10, 8, 8, 8, 6, 0, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (6, 6, 4, '2009-04-04', 0, 8, 8, 4, 8, 8, 3, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (7, 6, 1, '2009-04-04', 0, 8, 8, 8, 2, 8, 0, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (8, 10, 3, '2009-09-19', 0, 2, 8, 8, 4, 8, 0, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (9, 10, 4, '2009-09-19', 0, 10, 8, 7, 6, 8, 0, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (10, 10, 4, '2009-09-26', 0, 8, 8, 8, 8, 8, 0, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (11, 8, 4, '2009-09-26', 0, 6, 8, 8, 4, 8, 0, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (12, 11, 2, '2009-07-19', 0, 8, 8, 7, 8, 8, 3, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (13, 11, 4, '2009-07-14', 0, 8, 8, 8, 2, 8, 10, '2009-08-03', '2009-08-03', 0, 0);
INSERT INTO "timecard" VALUES (14, 12, 1, '2009-09-16', 0, 0, 0, 1, 0, 0, 0, '2009-09-16', '2009-09-16', 2, 2);
INSERT INTO "timecard" VALUES (15, 6, 1, '2012-05-07', 0, 0, 0, 0, 0, 0, 0, '2012-05-14', '2012-05-14', 1, 1);
