// ****************************************************************************
// *                                Importações                               *
// ****************************************************************************
import { Semantic } from '../components/core.js';

// ****************************************************************************
// *                             Render                                       *
// ****************************************************************************
/**
 * @description Quando invocado, constrói o DOM do elemento
 * @param { object } ctx - ELEMENT_NODE que cria o contexto (custom tag)
 * */
function render(ctx) {
    if (ctx.nodeType === 1) {
        ctx.innerHTML = `
            <div class="ui basic segment">
                <div data-ui="show" class="ui action left icon input">
                    <i class="icon" data-feedback="color"></i>              
                    <input id="${ctx.dataset.id}" name="${ctx.dataset.id}" type="text" placeholder="selecione uma cor" data-feedback="hex">                
                    <button id="show-colorpicker" class="ui icon button"><i class="icon eye dropper"></i></button>
                </div>
                <div data-ui="colorpicker" class="wrapper ui segments scale-up-top hide">
                    <div class="header ui top attached secondary segment">                  
                        <div class="ui small header">Color Picker</div>
                        <i class="small fitted link black icon close" data-ui="hide"></i>
                    </div>              
                    <div class="ui basic segment">
                        <div data-ui="placeholder"></div>
                    </div>
                    <div class="ui basic segment flex justify-center items-center column-gap-2">
                        <div class="ui tiny right labeled left icon input">
                          <i class="icon" data-feedback="color"></i>                                                
                          <input type="text" id="colorHex" data-feedback="hex" value="">
                          <div class="ui basic label" data-ui="interactivenumber" data-feedback="alpha" ></div>
                        </div>                               
                        ${ Semantic.iconButton('eraser', 'basic small action\:clear')}
                    </div>
                    <div data-ui="colorSwatch" class="colorSwatch ui basic segment"></div>
                </div>          
            </div>  
        `
    } else {
        return false;
    }
}