/* Add table "notif_inbox"                                                   */

CREATE TABLE notiftable_inbox (
   inbox_id SERIAL NOT NULL,
   notif_id INTEGER NOT NULL,
   login CHARACTER VARYING(255) NOT NULL,
   notif_dtsent TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
   notif_ontop INTEGER NOT NULL DEFAULT '0',
   notif_isread INTEGER NOT NULL DEFAULT '0',
   notif_dtread TIMESTAMP DEFAULT NULL,
   notif_tags CHARACTER VARYING(255) DEFAULT NULL,
   notif_important INTEGER NULL DEFAULT NULL,
   PRIMARY KEY (inbox_id)
)

/* Add table "notif_pref"                                                   */

CREATE TABLE notiftable_pref (
  login CHARACTER VARYING(255) NOT NULL,
  receive_email INTEGER NOT NULL DEFAULT '0',
  receive_sms INTEGER NOT NULL DEFAULT '0',
  PRIMARY KEY (login)
)

/* Add table "notif_tags"                                                   */

CREATE TABLE notiftable_tags (
  tag_id SERIAL NOT NULL,
  tag_title CHARACTER VARYING(50) NOT NULL,
  login CHARACTER VARYING(255) NOT NULL,
  tag_color CHARACTER VARYING(100) DEFAULT NULL,
  tag_active INTEGER NOT NULL DEFAULT '1',
  PRIMARY KEY (tag_id)
)

/* Add table "notif_notifications"                                                   */

CREATE TABLE notiftable_notifications (
    notif_id SERIAL NOT NULL,
    notif_title CHARACTER VARYING(255) NOT NULL,
    notif_message TEXT NOT NULL,
    notif_dtcreated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    notif_ontop INTEGER NOT NULL DEFAULT '0',
    notif_dtexpire TIMESTAMP DEFAULT NULL,
    notif_categ CHARACTER VARYING(60) DEFAULT NULL,
    notif_login_sender CHARACTER VARYING(255) NOT NULL,
    notif_type CHARACTER VARYING(60) DEFAULT NULL,
    notif_link CHARACTER VARYING(255) DEFAULT NULL,
    deleted_at TIMESTAMP DEFAULT NULL,
    PRIMARY KEY (notif_id)
)

/* Add table "notif_profiles"                                                   */

CREATE TABLE notiftable_profiles (
    profile_id SERIAL NOT NULL,
    profile_name CHARACTER VARYING(255) NOT NULL,
    profile_users TEXT NULL,
    profile_groups TEXT NULL,
    profile_public INTEGER NOT NULL DEFAULT '0',
    profile_owner CHARACTER VARYING(255) NULL,
    PRIMARY KEY (profile_id)
)

/* Add table "notif_user_tags"                                                   */

CREATE TABLE notiftable_user_tags (
    user_tags_id SERIAL NOT NULL,
    login CHARACTER VARYING(255) NOT NULL,
    login_sender CHARACTER VARYING(255) NOT NULL,
    tags CHARACTER VARYING(255) DEFAULT NULL,
    PRIMARY KEY (user_tags_id)
)


