SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `students` (
  `student_id` INT NOT NULL AUTO_INCREMENT,
  `student_name` varchar(100) NOT NULL,
  PRIMARY KEY (`student_id`)
);

INSERT INTO `students` (`student_id`, `student_name`) VALUES (1,	'Jacob');
INSERT INTO `students` (`student_id`, `student_name`) VALUES (2,	'Emma');
INSERT INTO `students` (`student_id`, `student_name`) VALUES (3,	'Jayden');
INSERT INTO `students` (`student_id`, `student_name`) VALUES (4,	'William');

CREATE TABLE `subjects` (
  `subject_id` INT NOT NULL AUTO_INCREMENT,
  `subject_descr` varchar(100) NOT NULL,
  PRIMARY KEY (`subject_id`)
);

INSERT INTO `subjects` (`subject_id`, `subject_descr`) VALUES (1,	'English');
INSERT INTO `subjects` (`subject_id`, `subject_descr`) VALUES (2,	'Maths');
INSERT INTO `subjects` (`subject_id`, `subject_descr`) VALUES (3,	'Physics');
INSERT INTO `subjects` (`subject_id`, `subject_descr`) VALUES (4,	'History');
INSERT INTO `subjects` (`subject_id`, `subject_descr`) VALUES (5,	'Economics');

CREATE TABLE `students_subjects` (
  `student_id` INT NOT NULL,
  `subject_id` INT NOT NULL,
  `grade` numeric(16,2) NOT NULL,
  PRIMARY KEY (`student_id`,`subject_id`)
);

insert into `students_subjects` (`student_id`, `subject_id`, `grade`) VALUES (1, 1, 3.7),
(1, 2, 4.3),
(1, 3, 4.0),
(1, 4, 3.3),
(1, 5, 3.1),
(2, 1, 3.6),
(2, 2, 4.0),
(2, 3, 3.2),
(2, 4, 2.6),
(2, 5, 3.2),
(3, 1, 3.8),
(3, 2, 4.1),
(3, 3, 3.9),
(3, 4, 2.6),
(3, 5, 2.0),
(4, 1, 3.4),
(4, 2, 3.2),
(4, 3, 4.0),
(4, 4, 2.5),
(4, 5, 3.1);

CREATE TABLE `gross_export` (
    `id` INT AUTO_INCREMENT,
    `from_country` VARCHAR(100) NOT NULL,
    `to_country` VARCHAR(100) NOT NULL,
    `val_export` DECIMAL(15, 2) NOT NULL,
    PRIMARY KEY (`id`)
);

INSERT INTO gross_export (from_country, to_country, val_export) VALUES
    ('India', 'Canada', 30400000.00),
    ('India', 'USA', 465000000.00),
    ('India', 'China', 127000000.00),
    ('India', 'UK', 88600000.00),
    ('India', 'UAE', 275000000.00),
    ('Canada', 'India', 244900000.00),
    ('Canada', 'USA', 3100000000.00),
    ('Canada', 'China', 183000000.00),
    ('Canada', 'UK', 93200000.00),
    ('Canada', 'UAE', 18300000.00),
    ('USA', 'India', 241000000.00),
    ('USA', 'Canada', 2770000000.00),
    ('USA', 'China', 1320000000.00),
    ('USA', 'UK', 536000000.00),
    ('USA', 'UAE', 199000000.00),
    ('China', 'India', 681000000.00),
    ('China', 'Canada', 519000000.00),
    ('China', 'USA', 4800000000.00),
    ('China', 'UK', 568000000.00),
    ('China', 'UAE', 458000000.00),
    ('UK', 'Canada', 624000000.00),
    ('UK', 'USA', 57800000.00),
    ('UK', 'India', 5180000.00),
    ('UK', 'China', 212000000.00),
    ('UK', 'UAE', 92700000.00),
    ('UAE', 'India', 205000000.00),
    ('UAE', 'Canada', 2990000.00),
    ('UAE', 'USA', 74700000.00),
    ('UAE', 'China', 11600000.00),
    ('UAE', 'UK', 35500000.00);



CREATE TABLE country_regions (
    id INT AUTO_INCREMENT,
    continent_short CHAR(2) NOT NULL,
    continent_label VARCHAR(255) NOT NULL,
    region VARCHAR(255) NOT NULL,
    fs_map VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (`id`)
);

INSERT INTO country_regions (id, continent_short, continent_label, region, fs_map) VALUES
    (1, 'AF', 'Africa', 'North Africa', 'map_north_africa'),
    (2, 'AF', 'Africa', 'West Africa', 'map_west_africa'),
    (3, 'AF', 'Africa', 'East Africa', 'map_east_africa'),
    (4, 'AF', 'Africa', 'Southern Africa', 'map_southern_africa'),
    (5, 'AS', 'Asia', 'South Asia', 'map_south_asia'),
    (6, 'AS', 'Asia', 'East Asia', 'map_east_asia'),
    (7, 'AS', 'Asia', 'Southeast Asia', 'map_southeast_asia'),
    (8, 'AS', 'Asia', 'West Asia', 'map_west_asia'),
    (9, 'EU', 'Europe', 'Eastern Europe', 'map_eastern_europe'),
    (10, 'EU', 'Europe', 'Western Europe', 'map_western_europe'),
    (11, 'EU', 'Europe', 'Northern Europe', 'map_northern_europe'),
    (12, 'EU', 'Europe', 'Southern Europe', 'map_southern_europe'),
    (13, 'AM', 'Americas', 'North America', 'map_north_america'),
    (14, 'AM', 'Americas', 'Central America', 'map_central_america'),
    (15, 'AM', 'Americas', 'South America', 'map_south_america'),
    (16, 'OC', 'Oceania', 'Australia and New Zealand', 'map_australia_nz'),
    (17, 'OC', 'Oceania', 'Melanesia', 'map_melanesia'),
    (18, 'OC', 'Oceania', 'Micronesia', 'map_micronesia'),
    (19, 'OC', 'Oceania', 'Polynesia', 'map_polynesia');

CREATE TABLE `countries` (
    `iso` CHAR(2) NOT NULL,
    `name` VARCHAR(80) NOT NULL,
    `printable_name` VARCHAR(80) NOT NULL,
    `iso3` CHAR(3) DEFAULT NULL,
    `numcode` INT DEFAULT NULL,
    `country_region` INT DEFAULT NULL,
    `fs_map` VARCHAR(255) DEFAULT NULL,
    `fs_id` VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (`iso`)
);

INSERT INTO `countries` (`iso`, `name`, `printable_name`, `iso3`, `numcode`, `country_region`, `fs_map`, `fs_id`) VALUES 
('AD',	'ANDORRA',	'Andorra',	'AND',	20,	9,	'andorra',	'002'),
('AE',	'UNITED ARAB EMIRATES',	'United Arab Emirates',	'ARE',	784,	8,	'uae',	'18'),
('AF',	'AFGHANISTAN',	'Afghanistan',	'AFG',	4,	5,	'afghanistan',	'01'),
('AL',	'ALBANIA',	'Albania',	'ALB',	8,	2,	'albania',	'001'),
('AM',	'ARMENIA',	'Armenia',	'ARM',	51,	1,	'armenia',	'002'),
('AN',	'NETHERLANDS ANTILLES',	'Netherlands Antilles',	'ANT',	530,	13,	NULL,	NULL),
('AO',	'ANGOLA',	'Angola',	'AGO',	24,	3,	'angola',	'002'),
('AR',	'ARGENTINA',	'Argentina',	'ARG',	32,	15,	'argentina',	'001'),
('AS',	'AMERICAN SAMOA',	'American Samoa',	'ASM',	16,	16,	NULL,	NULL),
('AT',	'AUSTRIA',	'Austria',	'AUT',	40,	10,	'austria',	'003'),
('AU',	'AUSTRALIA',	'Australia',	'AUS',	36,	16,	'australia',	'001'),
('AZ',	'AZERBAIJAN',	'Azerbaijan',	'AZE',	31,	1,	'azerbaijan',	'003'),
('BA',	'BOSNIA AND HERZEGOVINA',	'Bosnia and Herzegovina',	'BIH',	70,	8,	'bahrain',	'02'),
('BB',	'BARBADOS',	'Barbados',	'BRB',	52,	NULL,	NULL,	NULL),
('BD',	'BANGLADESH',	'Bangladesh',	'BGD',	50,	5,	'bangladesh',	'005'),
('BE',	'BELGIUM',	'Belgium',	'BEL',	56,	10,	'belgium',	'005'),
('BF',	'BURKINA FASO',	'Burkina Faso',	'BFA',	854,	2,	'burkinafaso',	'005'),
('BG',	'BULGARIA',	'Bulgaria',	'BGR',	100,	2,	'bulgaria',	'007'),
('BH',	'BAHRAIN',	'Bahrain',	'BHR',	48,	6,	'belize',	'01'),
('BI',	'BURUNDI',	'Burundi',	'BDI',	108,	3,	'burundi',	'006'),
('BJ',	'BENIN',	'Benin',	'BEN',	204,	3,	'benin',	'003'),
('BM',	'BERMUDA',	'Bermuda',	'BMU',	60,	NULL,	NULL,	NULL),
('BN',	'BRUNEI DARUSSALAM',	'Brunei Darussalam',	'BRN',	96,	1,	'brunei',	'007'),
('BO',	'BOLIVIA',	'Bolivia',	'BOL',	68,	15,	'bolivia',	'002'),
('BR',	'BRAZIL',	'Brazil',	'BRA',	76,	15,	'brazil',	'003'),
('BS',	'BAHAMAS',	'Bahamas',	'BHS',	44,	NULL,	NULL,	NULL),
('BT',	'BHUTAN',	'Bhutan',	'BTN',	64,	1,	'bhutan',	'006'),
('BW',	'BOTSWANA',	'Botswana',	'BWA',	72,	4,	'botswana',	'004'),
('BY',	'BELARUS',	'Belarus',	'BLR',	112,	2,	'belarus',	'004'),
('BZ',	'BELIZE',	'Belize',	'BLZ',	84,	NULL,	NULL,	NULL),
('CA',	'CANADA',	'Canada',	'CAN',	124,	13,	'canaryislands',	'059'),
('CD',	'CONGO, THE DEMOCRATIC REPUBLIC OF THE',	'Congo, the Democratic Republic of the',	'COD',	180,	3,	'democraticrepublicofcongo',	'013'),
('CF',	'CENTRAL AFRICAN REPUBLIC',	'Central African Republic',	'CAF',	140,	NULL,	NULL,	NULL),
('CG',	'CONGO',	'Congo',	'COG',	178,	3,	'congo',	'057'),
('CH',	'SWITZERLAND',	'Switzerland',	'CHE',	756,	2,	'switzerland',	'040'),
('CI',	'COTE DIVOIRE',	'Cote DIvoire',	'CIV',	384,	2,	'cotedivoire',	'012'),
('CK',	'COOK ISLANDS',	'Cook Islands',	'COK',	184,	NULL,	NULL,	NULL),
('CL',	'CHILE',	'Chile',	'CHL',	152,	15,	'chile',	'004'),
('CM',	'CAMEROON',	'Cameroon',	'CMR',	120,	3,	'cameroon',	'007'),
('CN',	'CHINA',	'China',	'CHN',	156,	6,	'china',	'010'),
('CO',	'COLOMBIA',	'Colombia',	'COL',	170,	15,	'colombia',	'005'),
('CR',	'COSTA RICA',	'Costa Rica',	'CRI',	188,	14,	'centralafricanrepublic',	'009'),
('CS',	'SERBIA AND MONTENEGRO',	'Serbia and Montenegro',	'',	0,	6,	'costarica',	'02'),
('CU',	'CUBA',	'Cuba',	'CUB',	192,	4,	NULL,	NULL),
('CV',	'CAPE VERDE',	'Cape Verde',	'CPV',	132,	3,	'capeverde',	'008'),
('CX',	'CHRISTMAS ISLAND',	'Christmas Island',	NULL,	NULL,	NULL,	NULL,	NULL),
('CY',	'CYPRUS',	'Cyprus',	'CYP',	196,	12,	'cyprus',	'044'),
('CZ',	'CZECH REPUBLIC',	'Czech Republic',	'CZE',	203,	9,	'czechrepublic',	'009'),
('DE',	'GERMANY',	'Germany',	'DEU',	276,	10,	'germany',	'014'),
('DJ',	'DJIBOUTI',	'Djibouti',	'DJI',	262,	3,	'djibouti',	'014'),
('DK',	'DENMARK',	'Denmark',	'DNK',	208,	11,	'denmark',	'010'),
('DM',	'DOMINICA',	'Dominica',	'DMA',	212,	NULL,	NULL,	NULL),
('DO',	'DOMINICAN REPUBLIC',	'Dominican Republic',	'DOM',	214,	NULL,	NULL,	NULL),
('DZ',	'ALGERIA',	'Algeria',	'DZA',	12,	1,	'algeria',	'001'),
('EC',	'ECUADOR',	'Ecuador',	'ECU',	218,	15,	'ecuador',	'006'),
('EE',	'ESTONIA',	'Estonia',	'EST',	233,	2,	'estonia',	'011'),
('EG',	'EGYPT',	'Egypt',	'EGY',	818,	1,	NULL,	NULL),
('EH',	'WESTERN SAHARA',	'Western Sahara',	'ESH',	732,	NULL,	NULL,	NULL),
('ER',	'ERITREA',	'Eritrea',	'ERI',	232,	3,	'eritrea',	'017'),
('ES',	'SPAIN',	'Spain',	'ESP',	724,	12,	'spain',	'03'),
('ET',	'ETHIOPIA',	'Ethiopia',	'ETH',	231,	3,	'ethiopia',	'018'),
('FI',	'FINLAND',	'Finland',	'FIN',	246,	11,	'finland',	'012'),
('FJ',	'FIJI',	'Fiji',	'FJI',	242,	17,	'fiji',	'002');
INSERT INTO `countries` (`iso`, `name`, `printable_name`, `iso3`, `numcode`, `country_region`, `fs_map`, `fs_id`) VALUES  ('FM',	'MICRONESIA, FEDERATED STATES OF',	'Micronesia, Federated States of',	'FSM',	583,	18,	'micronesia',	'005'),
('FO',	'FAROE ISLANDS',	'Faroe Islands',	'FRO',	234,	NULL,	NULL,	NULL),
('FR',	'FRANCE',	'France',	'FRA',	250,	10,	'france',	'013'),
('GA',	'GABON',	'Gabon',	'GAB',	266,	3,	'gabon',	'019'),
('GD',	'GRENADA',	'Grenada',	'GRD',	308,	NULL,	NULL,	NULL),
('GE',	'GEORGIA',	'Georgia',	'GEO',	268,	1,	'georgia',	'013'),
('GF',	'FRENCH GUIANA',	'French Guiana',	'GUF',	254,	5,	'frenchguiana',	'008'),
('GH',	'GHANA',	'Ghana',	'GHA',	288,	2,	'ghana',	'020'),
('GI',	'GIBRALTAR',	'Gibraltar',	'GIB',	292,	5,	NULL,	NULL),
('GL',	'GREENLAND',	'Greenland',	'GRL',	304,	4,	'greenland',	'024'),
('GM',	'GAMBIA',	'Gambia',	'GMB',	270,	3,	'gambia',	'056'),
('GN',	'GUINEA',	'Guinea',	'GIN',	324,	3,	'guinea',	'021'),
('GP',	'GUADELOUPE',	'Guadeloupe',	'GLP',	312,	NULL,	NULL,	NULL),
('GQ',	'EQUATORIAL GUINEA',	'Equatorial Guinea',	'GNQ',	226,	3,	NULL,	NULL),
('GR',	'GREECE',	'Greece',	'GRC',	300,	12,	NULL,	NULL),
('GS',	'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS',	'South Georgia and the South Sandwich Islands',	NULL,	NULL,	NULL,	NULL,	NULL),
('GT',	'GUATEMALA',	'Guatemala',	'GTM',	320,	14,	'guatemala',	'04'),
('GU',	'GUAM',	'Guam',	'GUM',	316,	NULL,	NULL,	NULL),
('GW',	'GUINEA-BISSAU',	'Guinea-Bissau',	'GNB',	624,	3,	'guineabissau',	'022'),
('GY',	'GUYANA',	'Guyana',	'GUY',	328,	15,	'guyana',	'009'),
('HK',	'HONG KONG',	'Hong Kong',	'HKG',	344,	1,	'hongkong',	'050'),
('HM',	'HEARD ISLAND AND MCDONALD ISLANDS',	'Heard Island and Mcdonald Islands',	'',	0,	NULL,	NULL,	NULL),
('HN',	'HONDURAS',	'Honduras',	'HND',	340,	14,	NULL,	NULL),
('HR',	'CROATIA',	'Croatia',	'HRV',	191,	NULL,	NULL,	NULL),
('HT',	'HAITI',	'Haiti',	'HTI',	332,	NULL,	NULL,	NULL),
('HU',	'HUNGARY',	'Hungary',	'HUN',	348,	9,	NULL,	NULL),
('ID',	'INDONESIA',	'Indonesia',	'IDN',	360,	7,	NULL,	NULL),
('IE',	'IRELAND',	'Ireland',	'IRL',	372,	2,	'ireland',	'018'),
('IL',	'ISRAEL',	'Israel',	'ISR',	376,	8,	NULL,	NULL),
('IN',	'INDIA',	'India',	'IND',	356,	5,	'iran',	'03'),
('IO',	'BRITISH INDIAN OCEAN TERRITORY',	'British Indian Ocean Territory',	'',	0,	NULL,	NULL,	NULL),
('IQ',	'IRAQ',	'Iraq',	'IRQ',	368,	8,	NULL,	NULL),
('IR',	'IRAN, ISLAMIC REPUBLIC OF',	'Iran, Islamic Republic of',	'IRN',	364,	NULL,	NULL,	NULL),
('IS',	'ICELAND',	'Iceland',	'ISL',	352,	11,	'israel',	'05'),
('IT',	'ITALY',	'Italy',	'ITA',	380,	12,	'italy',	'019'),
('JM',	'JAMAICA',	'Jamaica',	'JAM',	388,	NULL,	NULL,	NULL),
('JO',	'JORDAN',	'Jordan',	'JOR',	400,	8,	'jordan',	'06'),
('JP',	'JAPAN',	'Japan',	'JPN',	392,	6,	'japan',	'019'),
('KE',	'KENYA',	'Kenya',	'KEN',	404,	3,	'kenya',	'023'),
('KG',	'KYRGYZSTAN',	'Kyrgyzstan',	'KGZ',	417,	8,	'kyrgyzstan',	'08'),
('KH',	'CAMBODIA',	'Cambodia',	'KHM',	116,	1,	'cambodia',	'009'),
('KI',	'KIRIBATI',	'Kiribati',	'KIR',	296,	19,	'kiribati',	'003'),
('KM',	'COMOROS',	'Comoros',	'COM',	174,	3,	'comoros',	'011'),
('KN',	'SAINT KITTS AND NEVIS',	'Saint Kitts and Nevis',	'KNA',	659,	NULL,	NULL,	NULL),
('KP',	'KOREA, DEMOCRATIC PEOPLES REPUBLIC OF',	'Korea, Democratic Peoples Republic of',	'PRK',	408,	1,	'northkorea',	'022'),
('KR',	'KOREA, REPUBLIC OF',	'Korea, Republic of',	'KOR',	410,	6,	'southkorea',	'023'),
('KW',	'KUWAIT',	'Kuwait',	'KWT',	414,	NULL,	NULL,	NULL),
('KY',	'CAYMAN ISLANDS',	'Cayman Islands',	'CYM',	136,	NULL,	NULL,	NULL),
('KZ',	'KAZAKHSTAN',	'Kazakhstan',	'KAZ',	398,	1,	'kazakhstan',	'021'),
('LA',	'LAO PEOPLES DEMOCRATIC REPUBLIC',	'Lao Peoples Democratic Republic',	'LAO',	418,	1,	'laos',	'026'),
('LB',	'LEBANON',	'Lebanon',	'LBN',	422,	NULL,	NULL,	NULL),
('LC',	'SAINT LUCIA',	'Saint Lucia',	'LCA',	662,	NULL,	NULL,	NULL),
('LI',	'LIECHTENSTEIN',	'Liechtenstein',	'LIE',	438,	3,	'liberia',	'025'),
('LK',	'SRI LANKA',	'Sri Lanka',	'LKA',	144,	5,	'srilanka',	'039'),
('LR',	'LIBERIA',	'Liberia',	'LBR',	430,	3,	'libya',	'026'),
('LS',	'LESOTHO',	'Lesotho',	'LSO',	426,	3,	'lesotho',	'024'),
('LT',	'LITHUANIA',	'Lithuania',	'LTU',	440,	2,	'lithuania',	'022'),
('LU',	'LUXEMBOURG',	'Luxembourg',	'LUX',	442,	2,	'luxembourg',	'023'),
('LV',	'LATVIA',	'Latvia',	'LVA',	428,	2,	'latvia',	'020'),
('LY',	'LIBYAN ARAB JAMAHIRIYA',	'Libyan Arab Jamahiriya',	'LBY',	434,	1,	NULL,	NULL),
('MA',	'MOROCCO',	'Morocco',	'MAR',	504,	1,	'morocco',	'032'),
('MC',	'MONACO',	'Monaco',	'MCO',	492,	2,	'monaco',	'027'),
('MD',	'MOLDOVA, REPUBLIC OF',	'Moldova, Republic of',	'MDA',	498,	2,	'moldova',	'026'),
('MG',	'MADAGASCAR',	'Madagascar',	'MDG',	450,	3,	'madagascar',	'027'),
('MH',	'MARSHALL ISLANDS',	'Marshall Islands',	'MHL',	584,	18,	'marshallisland',	'004'),
('MK',	'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF',	'Macedonia, the Former Yugoslav Republic of',	'MKD',	807,	2,	'macedonia',	'024'),
('ML',	'MALI',	'Mali',	'MLI',	466,	3,	'mali',	'029'),
('MM',	'MYANMAR',	'Myanmar',	'MMR',	104,	1,	'burma',	'008'),
('MN',	'MONGOLIA',	'Mongolia',	'MNG',	496,	6,	'mongolia',	'030'),
('MO',	'MACAO',	'Macao',	'MAC',	446,	1,	'macau',	'051');
INSERT INTO `countries` (`iso`, `name`, `printable_name`, `iso3`, `numcode`, `country_region`, `fs_map`, `fs_id`) VALUES  ('MR',	'MAURITANIA',	'Mauritania',	'MRT',	478,	3,	'mauritania',	'030'),
('MT',	'MALTA',	'Malta',	'MLT',	470,	2,	'malta',	'025'),
('MU',	'MAURITIUS',	'Mauritius',	'MUS',	480,	8,	'oman',	'10'),
('MV',	'MALDIVES',	'Maldives',	'MDV',	462,	NULL,	NULL,	NULL),
('MW',	'MALAWI',	'Malawi',	'MWI',	454,	4,	'malawi',	'028'),
('MX',	'MEXICO',	'Mexico',	'MEX',	484,	13,	'mexico',	'016'),
('MY',	'MALAYSIA',	'Malaysia',	'MYS',	458,	7,	'malaysia',	'028'),
('MZ',	'MOZAMBIQUE',	'Mozambique',	'MOZ',	508,	3,	'mozambique',	'033'),
('NA',	'NAMIBIA',	'Namibia',	'NAM',	516,	4,	'namibia',	'034'),
('NC',	'NEW CALEDONIA',	'New Caledonia',	'NCL',	540,	17,	NULL,	NULL),
('NE',	'NIGER',	'Niger',	'NER',	562,	3,	'niger',	'035'),
('NG',	'NIGERIA',	'Nigeria',	'NGA',	566,	2,	'nigeria',	'036'),
('NI',	'NICARAGUA',	'Nicaragua',	'NIC',	558,	14,	NULL,	NULL),
('NL',	'NETHERLANDS',	'Netherlands',	'NLD',	528,	10,	'netherlands',	'029'),
('NO',	'NORWAY',	'Norway',	'NOR',	578,	11,	'norway',	'030'),
('NP',	'NEPAL',	'Nepal',	'NPL',	524,	5,	'nepal',	'031'),
('NR',	'NAURU',	'Nauru',	'NRU',	520,	18,	'nauru',	'006'),
('NU',	'NIUE',	'Niue',	'NIU',	570,	6,	'nicaragua',	'06'),
('NZ',	'NEW ZEALAND',	'New Zealand',	'NZL',	554,	16,	'newzealand',	'007'),
('OM',	'OMAN',	'Oman',	'OMN',	512,	NULL,	NULL,	NULL),
('PA',	'PANAMA',	'Panama',	'PAN',	591,	NULL,	NULL,	NULL),
('PE',	'PERU',	'Peru',	'PER',	604,	15,	'peru',	'011'),
('PF',	'FRENCH POLYNESIA',	'French Polynesia',	'PYF',	258,	NULL,	NULL,	NULL),
('PG',	'PAPUA NEW GUINEA',	'Papua New Guinea',	'PNG',	598,	16,	'papuanewguinea',	'009'),
('PH',	'PHILIPPINES',	'Philippines',	'PHL',	608,	1,	'philippines',	'034'),
('PK',	'PAKISTAN',	'Pakistan',	'PAK',	586,	5,	'pakistan',	'11'),
('PL',	'POLAND',	'Poland',	'POL',	616,	9,	'poland',	'031'),
('PM',	'SAINT PIERRE AND MIQUELON',	'Saint Pierre and Miquelon',	'SPM',	666,	6,	'panama',	'07'),
('PR',	'PUERTO RICO',	'Puerto Rico',	'PRI',	630,	NULL,	NULL,	NULL),
('PT',	'PORTUGAL',	'Portugal',	'PRT',	620,	12,	'portugal',	'032'),
('PW',	'PALAU',	'Palau',	'PLW',	585,	18,	'palau',	'008'),
('PY',	'PARAGUAY',	'Paraguay',	'PRY',	600,	15,	'paraguay',	'010'),
('QA',	'QATAR',	'Qatar',	'QAT',	634,	8,	'qatar',	'12'),
('RO',	'ROMANIA',	'Romania',	'ROM',	642,	9,	'romania',	'033'),
('RU',	'RUSSIAN FEDERATION',	'Russian Federation',	'RUS',	643,	1,	'russia',	'036'),
('RW',	'RWANDA',	'Rwanda',	'RWA',	646,	3,	'rwanda',	'038'),
('SA',	'SAUDI ARABIA',	'Saudi Arabia',	'SAU',	682,	8,	'saudiarabia',	'13'),
('SB',	'SOLOMON ISLANDS',	'Solomon Islands',	'SLB',	90,	17,	'solomonislands',	'011'),
('SD',	'SUDAN',	'Sudan',	'SDN',	736,	3,	'sudan',	'046'),
('SE',	'SWEDEN',	'Sweden',	'SWE',	752,	11,	'sweden',	'039'),
('SG',	'SINGAPORE',	'Singapore',	'SGP',	702,	7,	'singapore',	'038'),
('SI',	'SLOVENIA',	'Slovenia',	'SVN',	705,	NULL,	NULL,	NULL),
('SK',	'SLOVAKIA',	'Slovakia',	'SVK',	703,	9,	'slovakia',	'036'),
('SL',	'SIERRA LEONE',	'Sierra Leone',	'SLE',	694,	3,	'sierraleone',	'043'),
('SM',	'SAN MARINO',	'San Marino',	'SMR',	674,	2,	'sanmarino',	'034'),
('SN',	'SENEGAL',	'Senegal',	'SEN',	686,	2,	'senegal',	'041'),
('SO',	'SOMALIA',	'Somalia',	'SOM',	706,	3,	'somalia',	'044'),
('SR',	'SURINAME',	'Suriname',	'SUR',	740,	15,	'suriname',	'012'),
('ST',	'SAO TOME AND PRINCIPE',	'Sao Tome and Principe',	'STP',	678,	3,	'saotomeandprincipe',	'040'),
('SV',	'EL SALVADOR',	'El Salvador',	'SLV',	222,	14,	NULL,	NULL),
('SY',	'SYRIAN ARAB REPUBLIC',	'Syrian Arab Republic',	'SYR',	760,	8,	'syria',	'14'),
('SZ',	'SWAZILAND',	'Swaziland',	'SWZ',	748,	3,	'swaziland',	'047'),
('TD',	'CHAD',	'Chad',	'TCD',	148,	3,	'chad',	'010'),
('TG',	'TOGO',	'Togo',	'TGO',	768,	3,	'togo',	'049'),
('TH',	'THAILAND',	'Thailand',	'THA',	764,	7,	'thailand',	'042'),
('TJ',	'TAJIKISTAN',	'Tajikistan',	'TJK',	762,	NULL,	NULL,	NULL),
('TK',	'TOKELAU',	'Tokelau',	'TKL',	772,	2,	'turkey',	'045'),
('TL',	'TIMOR-LESTE',	'Timor-Leste',	NULL,	NULL,	NULL,	NULL,	NULL),
('TM',	'TURKMENISTAN',	'Turkmenistan',	'TKM',	795,	NULL,	NULL,	NULL),
('TN',	'TUNISIA',	'Tunisia',	'TUN',	788,	1,	'tunisia',	'051'),
('TO',	'TONGA',	'Tonga',	'TON',	776,	19,	'tonga',	'012'),
('TR',	'TURKEY',	'Turkey',	'TUR',	792,	NULL,	NULL,	NULL),
('TT',	'TRINIDAD AND TOBAGO',	'Trinidad and Tobago',	'TTO',	780,	NULL,	NULL,	NULL),
('TV',	'TUVALU',	'Tuvalu',	'TUV',	798,	19,	'tuvalu',	'013'),
('TW',	'TAIWAN, PROVINCE OF CHINA',	'Taiwan, Province of China',	'TWN',	158,	6,	'taiwan',	'049'),
('TZ',	'TANZANIA, UNITED REPUBLIC OF',	'Tanzania, United Republic of',	'TZA',	834,	3,	'tanzania',	'048'),
('UA',	'UKRAINE',	'Ukraine',	'UKR',	804,	2,	'ukraine',	'041'),
('UG',	'UGANDA',	'Uganda',	'UGA',	800,	3,	'uganda',	'052'),
('UK',	'UNITED KINGDOM',	'United Kingdom',	'UKG',	NULL,	11,	'uk',	'042'),
('US',	'UNITED STATES',	'United States',	'USA',	840,	13,	'usa',	'023'),
('UY',	'URUGUAY',	'Uruguay',	'URY',	858,	15,	'uruguay',	'013'),
('UZ',	'UZBEKISTAN',	'Uzbekistan',	'UZB',	860,	8,	'uzbekistan',	'19'),
('VE',	'VENEZUELA',	'Venezuela',	'VEN',	862,	15,	'venezuela',	'014'),
('VN',	'VIET NAM',	'Viet Nam',	'VNM',	704,	7,	'vietnam',	'047'),
('VU',	'VANUATU',	'Vanuatu',	'VUT',	548,	17,	'vanuatu',	'014'),
('WS',	'SAMOA',	'Samoa',	'WSM',	882,	19,	'westernsahara',	'053'),
('YE',	'YEMEN',	'Yemen',	'YEM',	887,	NULL,	NULL,	NULL),
('ZA',	'SOUTH AFRICA',	'South Africa',	'ZAF',	710,	4,	'southafrica',	'045'),
('ZM',	'ZAMBIA',	'Zambia',	'ZMB',	894,	4,	'zambia',	'054'),
('ZW',	'ZIMBABWE',	'Zimbabwe',	'ZWE',	716,	3,	'zimbabwe',	'055');


CREATE TABLE `sales2` (
  `id` int NOT null AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `store` varchar(50) NOT NULL,
  `product_category` varchar(15) NOT NULL,
  `product` varchar(40) NOT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `qtysold` int NOT NULL,
  `cost` decimal(16,2) NOT NULL DEFAULT '0.00',
  `sales` decimal(16,2) DEFAULT NULL,
  `profit` decimal(17,2) DEFAULT NULL,
  `country` varchar(2) DEFAULT NULL,
  `ship_from` varchar(2) DEFAULT NULL,
    PRIMARY KEY (`id`)
);


INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-08-13','Store ABC','SEAFOOD','Konbu','Yoshi Tannamuri',7,36.30,50.82,14.52,'JP','PY'),
	 ('2023-03-12','Store ABC','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Yoshi Tannamuri',5,50.82,84.70,33.88,'JP','IN'),
	 ('2023-01-13','Store ABC','BEVERAGES','Outback Lager','Yoshi Tannamuri',5,54.45,90.75,36.30,'JP','HK'),
	 ('2024-08-05','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Felipe Izquierdo',15,108.90,163.35,54.45,'ES','PT'),
	 ('2024-05-19','Store QWE','DAIRY PRODUCTS','Gorgonzola Telino','Maurizio Moroni',16,157.30,251.68,94.38,'IT','TH'),
	 ('2024-05-25','Store ABC','BEVERAGES','Chang 555','Janete Limeira',12,229.90,275.88,45.98,'BR','PT'),
	 ('2022-12-08','Store ABC','CONFECTIONS','Chocolade','Mary Saveley',8,78.65,125.84,47.19,'US','TH'),
	 ('2024-03-08','Store QWE','DAIRY PRODUCTS','Geitost','Jose Pavarotti',16,36.30,58.08,21.78,'IT','TH'),
	 ('2023-12-31','Store QWE','BEVERAGES','Ipoh Coffee','Patricio Simpson',7,278.30,389.62,111.32,'AR','PY'),
	 ('2024-03-01','Store XYZ','SEAFOOD','Chai','Lucia Carvalho',10,118.58,169.40,50.82,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-09-02','Store XYZ','SEAFOOD','Inlagd Sill','Lucia Carvalho',5,54.45,90.75,36.30,'BR','PT'),
	 ('2024-11-12','Store QWE','DAIRY PRODUCTS','Gudbrandsdalsost','Henriette Pfalzheim',15,350.90,526.35,175.45,'DE','PT'),
	 ('2023-03-16','Store QWE','DAIRY PRODUCTS','Flotemysost','Henriette Pfalzheim',15,205.70,308.55,102.85,'DE','TH'),
	 ('2023-10-08','Store QWE','PRODUCE','Manjimup Dried Apples','Art Braunschweiger',6,192.39,384.78,192.39,'DE','UK'),
	 ('2024-10-06','Store QWE','CONFECTIONS','Tarte au sucre','Helvetius Nagy',3,118.58,177.87,59.29,'HU','PT'),
	 ('2024-05-29','Store QWE','BEVERAGES','Outback Lager','Helvetius Nagy',6,54.45,108.90,54.45,'HU','TH'),
	 ('2023-04-04','Store RTY','SEAFOOD','Gravad lax','Martine Rance',10,177.87,254.10,76.23,'SN','PT'),
	 ('2023-03-31','Store RTY','MEAT/POULTRY','Tourtire','Martine Rance',6,21.78,43.56,21.78,'SN','HK'),
	 ('2024-09-29','Store QWE','GRAINS/CEREALS','Ravioli Angelo','Carlos Gonzalez',15,242.00,363.00,121.00,'ES','UK'),
	 ('2023-12-06','Store QWE','CONDIMENTS','Original Frankfurter grine Sode','Carlos Gonzalez',15,157.30,235.95,78.65,'ES','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-02-10','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Maria Larsson',12,121.00,145.20,24.20,'SE','TH'),
	 ('2024-05-07','Store QWE','BEVERAGES','Outback Lager','Maria Larsson',9,127.05,163.35,36.30,'SE','TH'),
	 ('2024-09-27','Store ABC','CONFECTIONS','Gumber Gummibrchen','Sven Ottlieb',12,375.10,450.12,75.02,'DE','TH'),
	 ('2023-12-09','Store XYZ','PRODUCE','Tofu','Yvonne Moncada',12,229.90,275.88,45.98,'ZA','PY'),
	 ('2024-06-05','Store XYZ','CONFECTIONS','Sir Rodney','Yvonne Moncada',12,96.80,116.16,19.36,'ZA','PT'),
	 ('2023-09-07','Store JKL','DAIRY PRODUCTS','Raclette Courdavault','Elizabeth Lincoln',16,532.40,851.84,319.44,'US','PY'),
	 ('2022-12-29','Store JKL','DAIRY PRODUCTS','Raclette Courdavault','Elizabeth Lincoln',9,372.68,479.16,106.48,'US','TH'),
	 ('2023-09-17','Store XYZ','GRAINS/CEREALS','Ravioli Angelo','Frederique Citeaux',15,242.00,363.00,121.00,'FR','PT'),
	 ('2024-10-12','Store QWE','SEAFOOD','Ikura','Laurence Lebihan',15,375.10,562.65,187.55,'FR','PT'),
	 ('2023-07-30','Store ABC','CONFECTIONS','Sir Rodney','Sergio Gutierrez',5,294.03,490.05,196.02,'AR','HK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-11-11','Store XYZ','BEVERAGES','Chang 555','Helen Bennett',10,160.93,229.90,68.97,'GB','TH'),
	 ('2024-07-27','Store XYZ','SEAFOOD','Konbu','Helen Bennett',10,50.82,72.60,21.78,'GB','PY'),
	 ('2024-01-24','Store JKL','CONDIMENTS','Grandma','Anabela Domingues',6,90.75,181.50,90.75,'BR','UK'),
	 ('2024-04-27','Store XYZ','BEVERAGES','Steeleye Stout','Jonas Bergulfsen',8,108.90,174.24,65.34,'NO','UK'),
	 ('2023-10-10','Store XYZ','BEVERAGES','Cite de Blaye','Jonas Bergulfsen',8,1597.20,2555.52,958.32,'NO','HK'),
	 ('2023-08-15','Store XYZ','BEVERAGES','Ipoh Coffee','Jonas Bergulfsen',9,389.62,500.94,111.32,'NO','PT'),
	 ('2024-05-21','Store XYZ','SEAFOOD','Konbu','Annette Roulet',3,14.52,21.78,7.26,'FR','TH'),
	 ('2023-01-31','Store XYZ','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Annette Roulet',10,118.58,169.40,50.82,'FR','TH'),
	 ('2024-09-16','Store XYZ','CONDIMENTS','Gula Malacca','Annette Roulet',16,229.90,367.84,137.94,'FR','TH'),
	 ('2024-02-07','Store XYZ','GRAINS/CEREALS','Wimmers gute Semmelkndel','Annette Roulet',3,79.86,119.79,39.93,'FR','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2022-12-23','Store XYZ','BEVERAGES','Lakkalikri','Annette Roulet',14,169.40,237.16,67.76,'FR','UK'),
	 ('2024-04-01','Store JKL','MEAT/POULTRY','Thringer Rostbratwurst','Anabela Domingues',8,750.20,1200.32,450.12,'BR','UK'),
	 ('2024-09-16','Store QWE','DAIRY PRODUCTS','Raclette Courdavault','Maria Anders s',15,665.50,998.25,332.75,'DE','PY'),
	 ('2024-10-14','Store QWE','DAIRY PRODUCTS','Gorgonzola Telino','Henriette Pfalzheim',9,110.11,141.57,31.46,'DE','HK'),
	 ('2024-08-25','Store QWE','MEAT/POULTRY','Perth Pasties','Henriette Pfalzheim',9,279.51,359.37,79.86,'DE','PT'),
	 ('2023-08-21','Store XYZ','BEVERAGES','Steeleye Stout','Roland Mendel',6,65.34,130.68,65.34,'DE','HK'),
	 ('2024-01-29','Store QWE','SEAFOOD','Konbu','Christina Berglund',6,21.78,43.56,21.78,'SE','TH'),
	 ('2022-12-28','Store XYZ','MEAT/POULTRY','Perth Pasties','Pirkko Koskitalo',10,220.22,314.60,94.38,'FI','HK'),
	 ('2024-11-13','Store QWE','CONDIMENTS','Sirop d''rable','Horst Kloss',16,278.30,445.28,166.98,'DE','PT'),
	 ('2023-09-12','Store QWE','PRODUCE','Longlife Tofu','Horst Kloss',15,96.80,145.20,48.40,'DE','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-05-09','Store QWE','SEAFOOD','Chai','Felipe Izquierdo',4,43.56,87.12,43.56,'ES','UK'),
	 ('2024-03-11','Store JKL','DAIRY PRODUCTS','Mozzarella di Giovanni','Anabela Domingues',15,423.50,635.25,211.75,'BR','IN'),
	 ('2024-01-06','Store QWE','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Felipe Izquierdo',6,50.82,101.64,50.82,'ES','UK'),
	 ('2023-07-21','Store QWE','BEVERAGES','Chartreuse verte','Felipe Izquierdo',10,152.46,217.80,65.34,'ES','UK'),
	 ('2024-10-20','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Pascale Cartrain',15,157.30,235.95,78.65,'FR','TH'),
	 ('2024-11-26','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Miguel Angel Paolino',15,254.10,381.15,127.05,'AR','HK'),
	 ('2023-02-18','Store XYZ','BEVERAGES','Ipoh Coffee','Miguel Angel Paolino',5,166.98,278.30,111.32,'AR','TH'),
	 ('2024-10-07','Store XYZ','BEVERAGES','Outback Lager','Miguel Angel Paolino',12,181.50,217.80,36.30,'AR','PT'),
	 ('2024-11-23','Store ABC','SEAFOOD','Ikura','Pascale Cartrain',16,375.10,600.16,225.06,'FR','HK'),
	 ('2023-02-26','Store ABC','PRODUCE','Manjimup Dried Apples','Mary Saveley',4,128.26,256.52,128.26,'US','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-05-16','Store JKL','BEVERAGES','Outback Lager','Paula Parente',8,72.60,116.16,43.56,'AO','PT'),
	 ('2023-11-08','Store ABC','CONFECTIONS','Teatime Chocolate Biscuits','Bernardo Batista',4,16.94,33.88,16.94,'BR','PT'),
	 ('2024-08-21','Store ABC','MEAT/POULTRY','Perth Pasties','Bernardo Batista',15,314.60,471.90,157.30,'BR','PT'),
	 ('2023-05-06','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Bernardo Batista',10,84.70,121.00,36.30,'BR','PT'),
	 ('2024-08-30','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Jose Pavarotti',12,108.90,130.68,21.78,'IT','TH'),
	 ('2022-12-03','Store RTY','MEAT/POULTRY','Mishi Kobe Niku','Elizabeth Brown',3,234.74,352.11,117.37,'US','TH'),
	 ('2023-02-27','Store ABC','DAIRY PRODUCTS','Geitost','Mary Saveley',4,7.26,14.52,7.26,'US','PT'),
	 ('2023-11-12','Store QWE','DAIRY PRODUCTS','Gorgonzola Telino','Andresa Fonseca',14,121.00,169.40,48.40,'BR','PT'),
	 ('2024-02-05','Store XYZ','MEAT/POULTRY','Piti chinois','Annette Roulet',10,160.93,229.90,68.97,'FR','UK'),
	 ('2024-08-24','Store ABC','BEVERAGES','Chang 555','Janete Limeira',5,68.97,114.95,45.98,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-09','Store ABC','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Janete Limeira',10,118.58,169.40,50.82,'BR','PT'),
	 ('2023-09-19','Store ABC','GRAINS/CEREALS','Ravioli Angelo','Janete Limeira',10,169.40,242.00,72.60,'BR','PT'),
	 ('2024-03-04','Store RTY','BEVERAGES','Chang 555','Paula Wilson',15,229.90,344.85,114.95,'US','TH'),
	 ('2023-07-09','Store RTY','MEAT/POULTRY','Alice Mutton','Paula Wilson',6,141.57,283.14,141.57,'US','PT'),
	 ('2023-08-30','New England','SEAFOOD','Carnarvon Tigers','Hanna Moos',10,533.61,762.30,228.69,'DE','TH'),
	 ('2023-08-20','Store JKL','DAIRY PRODUCTS','Gorgonzola Telino','Rene Phillips',14,157.30,220.22,62.92,'US','PT'),
	 ('2023-08-15','Store JKL','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Rene Phillips',15,254.10,381.15,127.05,'US','PT'),
	 ('2024-07-18','Store QWE','GRAINS/CEREALS','Gnocchi di nonna Alice','Eduardo Saavedra',5,108.90,181.50,72.60,'ES','UK'),
	 ('2023-07-02','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Eduardo Saavedra',7,163.35,228.69,65.34,'ES','UK'),
	 ('2024-11-17','Store QWE','MEAT/POULTRY','Thringer Rostbratwurst','Christina Berglund',10,1050.28,1500.40,450.12,'SE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-01-21','Store QWE','PRODUCE','Uncle Bob','Daniel Tonini',5,108.90,181.50,72.60,'IT','PT'),
	 ('2023-06-25','Store QWE','CONFECTIONS','Schoggi Schokolade','Daniel Tonini',10,372.68,532.40,159.72,'IT','PT'),
	 ('2023-04-24','Store QWE','BEVERAGES','Outback Lager','Daniel Tonini',4,36.30,72.60,36.30,'IT','TH'),
	 ('2024-01-12','Store JKL','PRODUCE','Manjimup Dried Apples','Carine Schmitt',3,128.26,192.39,64.13,'FR','TH'),
	 ('2024-05-20','Store QWE','CONFECTIONS','Tarte au sucre','Karl Jablonski',3,118.58,177.87,59.29,'PL','TH'),
	 ('2022-12-04','Store JKL','GRAINS/CEREALS','Filo Mix','Renate Messner',8,42.35,67.76,25.41,'DE','IN'),
	 ('2023-08-26','Store QWE','CONFECTIONS','Gumber Gummibrchen','Art Braunschweiger',10,211.75,302.50,90.75,'DE','IN'),
	 ('2024-11-27','Store JKL','SEAFOOD','Escargots de Bourgogne','Carlos Hernandez',12,157.30,188.76,31.46,'MX','PT'),
	 ('2024-02-11','Store XYZ','BEVERAGES','Steeleye Stout','Thomas Hardy',4,43.56,87.12,43.56,'GB','PT'),
	 ('2024-10-09','Store XYZ','BEVERAGES','Laughing Lumberjack Lager','Thomas Hardy',15,169.40,254.10,84.70,'GB','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-05-20','Store QWE','BEVERAGES','Guarana Fantastica','Christina Berglund',6,18.15,36.30,18.15,'SE','TH'),
	 ('2024-08-17','Store QWE','MEAT/POULTRY','Perth Pasties','Fran Wilson',3,79.86,119.79,39.93,'US','TH'),
	 ('2023-03-05','Store QWE','DAIRY PRODUCTS','Queso Cabrales','Maria Larsson',6,61.71,123.42,61.71,'SE','HK'),
	 ('2023-05-26','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Hari Kumar',10,177.87,254.10,76.23,'US','TH'),
	 ('2023-07-21','Store QWE','BEVERAGES','Steeleye Stout','Zbyszek  Piestrzeniewicz',3,43.56,65.34,21.78,'','PT'),
	 ('2023-10-29','Store RTY','BEVERAGES','Chang 555','Elizabeth Brown',10,127.05,181.50,54.45,'US','TH'),
	 ('2023-12-26','Store RTY','GRAINS/CEREALS','Gustaf','Elizabeth Brown',12,205.70,246.84,41.14,'US','PT'),
	 ('2023-02-25','Store RTY','DAIRY PRODUCTS','Mozzarella di Giovanni','Elizabeth Brown',10,237.16,338.80,101.64,'US','TH'),
	 ('2024-01-29','Store QWE','CONFECTIONS','Pavlova','Laurence Lebihan',12,205.70,246.84,41.14,'FR','TH'),
	 ('2022-12-24','Store QWE','MEAT/POULTRY','Alice Mutton','Laurence Lebihan',16,471.90,755.04,283.14,'FR','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-01-18','Store QWE','MEAT/POULTRY','Piti chinois','Josi Pedro Freyre',10,203.28,290.40,87.12,'BR','PT'),
	 ('2024-01-28','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Josi Pedro Freyre',15,399.30,598.95,199.65,'BR','TH'),
	 ('2024-09-23','Store XYZ','SEAFOOD','Spegesild','Frederique Citeaux',5,36.30,60.50,24.20,'FR','IN'),
	 ('2023-12-06','Store XYZ','MEAT/POULTRY','Perth Pasties','Pirkko Koskitalo',15,314.60,471.90,157.30,'FI','PT'),
	 ('2024-08-04','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Karin Josephs',15,84.70,127.05,42.35,'DE','PT'),
	 ('2024-07-03','Store XYZ','GRAINS/CEREALS','Ravioli Angelo','Karin Josephs',15,193.60,290.40,96.80,'DE','HK'),
	 ('2023-03-22','Store XYZ','PRODUCE','Russle Sauerkraut','Matti Karttunen',3,111.32,166.98,55.66,'FI','PY'),
	 ('2023-08-30','Store QWE','SEAFOOD','Ikura','Josi Pedro Freyre',10,262.57,375.10,112.53,'BR','PT'),
	 ('2023-03-19','Store QWE','CONFECTIONS','Maxilaku','Christina Berglund',15,242.00,363.00,121.00,'SE','PT'),
	 ('2024-01-26','Store QWE','DAIRY PRODUCTS','Queso Manchego La Pastora','Jean Fresniere',15,363.00,544.50,181.50,'CA','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-05-13','Store QWE','CONFECTIONS','Pavlova','Jean Fresniere',16,169.40,271.04,101.64,'CA','IN'),
	 ('2023-11-21','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Jean Fresniere',6,98.01,196.02,98.01,'CA','PY'),
	 ('2023-08-26','Store XYZ','SEAFOOD','Boston Crab Meat','Matti Karttunen',12,217.80,261.36,43.56,'FI','TH'),
	 ('2024-11-13','Store XYZ','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Matti Karttunen',10,177.87,254.10,76.23,'FI','TH'),
	 ('2023-12-23','Store XYZ','BEVERAGES','Lakkalikri','Matti Karttunen',10,152.46,217.80,65.34,'FI','PT'),
	 ('2024-06-08','Store QWE','SEAFOOD','Rid Kaviar','Patricio Simpson',10,127.05,181.50,54.45,'AR','UK'),
	 ('2024-10-27','Store QWE','DAIRY PRODUCTS','Queso Cabrales','Maurizio Moroni',6,61.71,123.42,61.71,'IT','HK'),
	 ('2023-01-26','Store QWE','PRODUCE','Russle Sauerkraut','Maurizio Moroni',12,435.60,522.72,87.12,'IT','PY'),
	 ('2024-06-24','Store QWE','MEAT/POULTRY','Alice Mutton','Christina Berglund',10,262.57,375.10,112.53,'SE','UK'),
	 ('2024-10-12','Store QWE','CONFECTIONS','Gumber Gummibrchen','Christina Berglund',15,302.50,453.75,151.25,'SE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2022-12-27','Store QWE','BEVERAGES','Steeleye Stout','Christina Berglund',8,84.70,135.52,50.82,'SE','TH'),
	 ('2023-11-10','Store QWE','BEVERAGES','Guarana Fantastica','Fran Wilson',8,30.25,48.40,18.15,'US','PT'),
	 ('2023-04-29','Store QWE','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Jaime Yorres',12,254.10,304.92,50.82,'ES','UK'),
	 ('2023-07-02','Store ABC','BEVERAGES','Guarana Fantastica','Pascale Cartrain',12,60.50,72.60,12.10,'FR','PT'),
	 ('2023-05-29','Store QWE','BEVERAGES','Chartreuse verte','Christina Berglund',6,50.82,101.64,50.82,'SE','HK'),
	 ('2023-01-27','Store QWE','MEAT/POULTRY','Tourtire','Christina Berglund',15,72.60,108.90,36.30,'SE','TH'),
	 ('2024-01-27','Store QWE','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Eduardo Saavedra',5,50.82,84.70,33.88,'ES','UK'),
	 ('2024-05-20','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Karin Josephs',12,84.70,101.64,16.94,'DE','TH'),
	 ('2024-03-18','Store XYZ','DAIRY PRODUCTS','Gorgonzola Telino','Karin Josephs',3,24.20,36.30,12.10,'DE','TH'),
	 ('2024-02-13','Store XYZ','GRAINS/CEREALS','Filo Mix','Karin Josephs',15,72.60,108.90,36.30,'DE','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-04-17','Store XYZ','MEAT/POULTRY','Alice Mutton','Janine Labrune',15,471.90,707.85,235.95,'FR','UK'),
	 ('2023-07-01','Store XYZ','BEVERAGES','Sasquatch Ale','Janine Labrune',10,118.58,169.40,50.82,'FR','PT'),
	 ('2024-03-08','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Janine Labrune',14,121.00,169.40,48.40,'FR','TH'),
	 ('2023-05-30','Store ABC','CONFECTIONS','Gumber Gummibrchen','Sergio Gutierrez',6,90.75,181.50,90.75,'AR','IN'),
	 ('2024-03-13','Store JKL','SEAFOOD','Nord-Ost Matjeshering','Renate Messner',15,314.60,471.90,157.30,'DE','PT'),
	 ('2023-03-24','Store XYZ','SEAFOOD','Ikura','Frederique Citeaux',14,302.50,423.50,121.00,'FR','PT'),
	 ('2023-12-20','Store RTY','BEVERAGES','Guarana Fantastica','Philip Cramer',10,42.35,60.50,18.15,'US','HK'),
	 ('2024-03-08','Store ABC','MEAT/POULTRY','Tourtire','Mary Saveley',6,21.78,43.56,21.78,'US','HK'),
	 ('2023-04-23','Store ABC','SEAFOOD','Rogede sild','Catherine Dewey',15,121.00,181.50,60.50,'US','TH'),
	 ('2024-07-02','Store ABC','GRAINS/CEREALS','Gnocchi di nonna Alice','Catherine Dewey',16,459.80,735.68,275.88,'US','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-10','Store QWE','PRODUCE','Russle Sauerkraut','Jose Pavarotti',15,435.60,653.40,217.80,'IT','TH'),
	 ('2023-11-04','Store XYZ','SEAFOOD','Konbu','Yvonne Moncada',5,21.78,36.30,14.52,'ZA','PT'),
	 ('2024-08-19','Store QWE','BEVERAGES','Chartreuse verte','Carlos Gonzalez',8,108.90,174.24,65.34,'ES','UK'),
	 ('2024-09-12','Store JKL','BEVERAGES','Outback Lager','Paula Parente',3,36.30,54.45,18.15,'AO','UK'),
	 ('2024-01-23','Store XYZ','CONFECTIONS','Chocolade','Thomas Hardy',15,121.00,181.50,60.50,'GB','TH'),
	 ('2023-04-08','Store XYZ','SEAFOOD','Spegesild','Annette Roulet',10,84.70,121.00,36.30,'FR','TH'),
	 ('2023-03-27','Store QWE','CONFECTIONS','Tarte au sucre','Maria Larsson',6,177.87,355.74,177.87,'SE','PT'),
	 ('2024-10-03','Store QWE','SEAFOOD','Escargots de Bourgogne','Karl Jablonski',15,157.30,235.95,78.65,'PL','UK'),
	 ('2023-03-18','Store QWE','CONDIMENTS','Sirop d''rable','Zbyszek  Piestrzeniewicz',15,350.90,526.35,175.45,'','TH'),
	 ('2024-07-26','New England','BEVERAGES','Rhinbru Klosterbier','Dominique Perrier',14,96.80,135.52,38.72,'FR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-11-29','Store ABC','GRAINS/CEREALS','Gnocchi di nonna Alice','Pascale Cartrain',15,363.00,544.50,181.50,'FR','HK'),
	 ('2023-12-12','Store QWE','GRAINS/CEREALS','Filo Mix','Maurizio Moroni',14,84.70,118.58,33.88,'IT','PT'),
	 ('2024-07-30','Store XYZ','PRODUCE','Uncle Bob','Jonas Bergulfsen',12,363.00,435.60,72.60,'NO','TH'),
	 ('2023-04-25','Store XYZ','CONFECTIONS','Pavlova','Jonas Bergulfsen',15,205.70,308.55,102.85,'NO','PT'),
	 ('2024-09-14','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Jonas Bergulfsen',5,36.30,60.50,24.20,'NO','PT'),
	 ('2024-10-01','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Matti Karttunen',12,108.90,130.68,21.78,'FI','PT'),
	 ('2023-12-01','Store XYZ','CONFECTIONS','Maxilaku','Matti Karttunen',10,169.40,242.00,72.60,'FI','PT'),
	 ('2023-05-27','Store XYZ','CONDIMENTS','Sirop d''rable','Matti Karttunen',5,105.27,175.45,70.18,'FI','PT'),
	 ('2023-07-27','Store QWE','SEAFOOD','Chai','Josi Pedro Freyre',10,152.46,217.80,65.34,'BR','TH'),
	 ('2023-12-22','Store QWE','MEAT/POULTRY','Alice Mutton','Josi Pedro Freyre',12,471.90,566.28,94.38,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-13','Store QWE','BEVERAGES','Laughing Lumberjack Lager','Josi Pedro Freyre',15,169.40,254.10,84.70,'BR','PT'),
	 ('2024-09-18','Store XYZ','SEAFOOD','Escargots de Bourgogne','Lucia Carvalho',15,157.30,235.95,78.65,'BR','PT'),
	 ('2024-06-26','Store ABC','PRODUCE','Uncle Bob','Mary Saveley',16,290.40,464.64,174.24,'US','TH'),
	 ('2024-02-12','Store XYZ','MEAT/POULTRY','Alice Mutton','Miguel Angel Paolino',10,330.33,471.90,141.57,'AR','PT'),
	 ('2024-03-14','Store XYZ','MEAT/POULTRY','Tourtire','Miguel Angel Paolino',10,59.29,84.70,25.41,'AR','IN'),
	 ('2024-02-12','Store ABC','CONFECTIONS','Pavlova','Sergio Gutierrez',6,61.71,123.42,61.71,'AR','UK'),
	 ('2024-02-06','Store ABC','DAIRY PRODUCTS','Mascarpone Fabioli','Sergio Gutierrez',6,116.16,232.32,116.16,'AR','HK'),
	 ('2023-12-10','Store QWE','BEVERAGES','Rhinbru Klosterbier','Maria Larsson',4,14.52,29.04,14.52,'SE','PT'),
	 ('2023-06-21','Store XYZ','DAIRY PRODUCTS','Camembert Pierrot','Alejandra Camino',10,287.98,411.40,123.42,'ES','UK'),
	 ('2023-08-29','Store ABC','BEVERAGES','Steeleye Stout','Palle Ibsen',10,152.46,217.80,65.34,'DK','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2022-12-09','Store XYZ','MEAT/POULTRY','Alice Mutton','Mario Pontes',15,471.90,707.85,235.95,'BR','PT'),
	 ('2024-06-20','Store XYZ','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Annette Roulet',10,118.58,169.40,50.82,'FR','PY'),
	 ('2023-11-01','Store XYZ','BEVERAGES','Ipoh Coffee','Annette Roulet',10,389.62,556.60,166.98,'FR','IN'),
	 ('2023-02-25','Store JKL','BEVERAGES','Ipoh Coffee','Lino Rodriguez',3,89.54,134.31,44.77,'ES','UK'),
	 ('2024-10-21','Store JKL','CONDIMENTS','Chef Anton''s Cajun Seasoning','Lino Rodriguez',16,217.80,348.48,130.68,'ES','TH'),
	 ('2023-08-26','Store QWE','BEVERAGES','Rhinbru Klosterbier','Christina Berglund',6,29.04,58.08,29.04,'SE','HK'),
	 ('2024-07-23','Store XYZ','GRAINS/CEREALS','Filo Mix','Mario Pontes',12,84.70,101.64,16.94,'BR','PT'),
	 ('2024-09-15','Store XYZ','SEAFOOD','Konbu','Ana Trujillo',10,50.82,72.60,21.78,'MX','PT'),
	 ('2023-08-09','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Ana Trujillo',7,54.45,76.23,21.78,'MX','PT'),
	 ('2023-07-20','Store XYZ','DAIRY PRODUCTS','Mozzarella di Giovanni','Ana Trujillo',10,296.45,423.50,127.05,'MX','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-08-18','Store QWE','CONFECTIONS','Sir Rodney','Daniel Tonini',5,294.03,490.05,196.02,'IT','TH'),
	 ('2024-04-19','Store QWE','GRAINS/CEREALS','Filo Mix','Daniel Tonini',5,25.41,42.35,16.94,'IT','UK'),
	 ('2023-11-23','Store QWE','CONFECTIONS','Zaanse koeken','Eduardo Saavedra',5,36.30,60.50,24.20,'ES','UK'),
	 ('2023-11-08','Store QWE','BEVERAGES','Lakkalikri','Eduardo Saavedra',5,65.34,108.90,43.56,'ES','PT'),
	 ('2023-07-20','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Peter Franken',15,157.30,235.95,78.65,'DE','TH'),
	 ('2024-01-08','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Pedro Afonso',10,143.99,205.70,61.71,'BR','PT'),
	 ('2023-11-17','Store XYZ','SEAFOOD','Spegesild','Pedro Afonso',5,36.30,60.50,24.20,'BR','IN'),
	 ('2023-08-20','Store XYZ','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Giovanni Rovelli',12,133.10,159.72,26.62,'IT','PT'),
	 ('2024-03-08','Store QWE','CONFECTIONS','Tarte au sucre','Laurence Lebihan',14,592.90,830.06,237.16,'FR','PY'),
	 ('2024-10-09','Store QWE','DAIRY PRODUCTS','Mozzarella di Giovanni','Laurence Lebihan',16,423.50,677.60,254.10,'FR','IN');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-04-25','Store RTY','SEAFOOD','Nord-Ost Matjeshering','Philip Cramer',8,127.05,203.28,76.23,'US','PT'),
	 ('2023-01-26','Store RTY','BEVERAGES','Ipoh Coffee','Philip Cramer',15,447.70,671.55,223.85,'US','PT'),
	 ('2023-12-20','Store JKL','SEAFOOD','Carnarvon Tigers','Paula Parente',4,152.46,304.92,152.46,'AO','PT'),
	 ('2023-12-04','Store JKL','GRAINS/CEREALS','Tunnbred','Paula Parente',8,54.45,87.12,32.67,'AO','IN'),
	 ('2023-09-04','Store QWE','PRODUCE','Russle Sauerkraut','Patricio Simpson',8,278.30,445.28,166.98,'AR','PY'),
	 ('2023-03-20','Store XYZ','BEVERAGES','Chang 555','Giovanni Rovelli',10,160.93,229.90,68.97,'IT','TH'),
	 ('2023-10-19','Store QWE','GRAINS/CEREALS','Tunnbred','Laurence Lebihan',15,84.70,127.05,42.35,'FR','UK'),
	 ('2024-09-20','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Laurence Lebihan',8,163.35,261.36,98.01,'FR','PT'),
	 ('2022-12-23','Store QWE','PRODUCE','Uncle Bob','Laurence Lebihan',8,181.50,290.40,108.90,'FR','HK'),
	 ('2024-03-28','Store XYZ','SEAFOOD','Konbu','Victoria Ashworth',15,72.60,108.90,36.30,'GB','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-02-25','Store XYZ','SEAFOOD','Spegesild','Victoria Ashworth',15,145.20,217.80,72.60,'GB','TH'),
	 ('2024-04-23','Store JKL','DAIRY PRODUCTS','Queso Cabrales','Elizabeth Lincoln',5,76.23,127.05,50.82,'US','TH'),
	 ('2023-04-12','Store JKL','DAIRY PRODUCTS','Gorgonzola Telino','Alexander Feuer',10,110.11,157.30,47.19,'DE','TH'),
	 ('2023-03-27','Store XYZ','DAIRY PRODUCTS','Geitost','Helen Bennett',12,24.20,29.04,4.84,'GB','TH'),
	 ('2023-08-22','Store XYZ','DAIRY PRODUCTS','Flotemysost','Helen Bennett',12,205.70,246.84,41.14,'GB','PT'),
	 ('2023-06-30','Store JKL','PRODUCE','Tofu','Guillermo Fernandez',12,229.90,275.88,45.98,'AR','IN'),
	 ('2023-10-10','Store JKL','BEVERAGES','Rhinbru Klosterbier','Guillermo Fernandez',10,50.82,72.60,21.78,'AR','IN'),
	 ('2023-05-12','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Victoria Ashworth',4,133.10,266.20,133.10,'GB','TH'),
	 ('2023-10-31','Store QWE','CONFECTIONS','Valkoinen suklaa','Josi Pedro Freyre',9,135.52,174.24,38.72,'BR','PT'),
	 ('2023-04-07','Store QWE','MEAT/POULTRY','Piti chinois','Josi Pedro Freyre',4,58.08,116.16,58.08,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-01-02','Store JKL','CONDIMENTS','Grandma','Elizabeth Lincoln',12,302.50,363.00,60.50,'US','PT'),
	 ('2023-06-11','Store JKL','MEAT/POULTRY','Alice Mutton','Elizabeth Lincoln',6,141.57,283.14,141.57,'US','PT'),
	 ('2024-09-09','Store QWE','CONDIMENTS','Grandma','Maria Anders s',16,302.50,484.00,181.50,'DE','PT'),
	 ('2024-05-08','Store XYZ','CONDIMENTS','Chef Anton''s Cajun Seasoning','Giovanni Rovelli',5,79.86,133.10,53.24,'IT','PT'),
	 ('2024-02-12','New England','DAIRY PRODUCTS','Geitost','Michael Holz',15,36.30,54.45,18.15,'DE','PT'),
	 ('2024-02-20','New England','SEAFOOD','Jack''s New England Clam Chowder','Michael Holz',6,36.30,72.60,36.30,'DE','HK'),
	 ('2024-05-28','Store JKL','BEVERAGES','Outback Lager','Carlos Hernandez',12,145.20,174.24,29.04,'MX','PT'),
	 ('2023-04-03','Store QWE','SEAFOOD','Chai','Isabel de Castro',15,169.40,254.10,84.70,'BR','UK'),
	 ('2022-12-08','Store QWE','BEVERAGES','Rhinbru Klosterbier','Maria Larsson',12,96.80,116.16,19.36,'SE','PY'),
	 ('2024-04-06','New England','CONFECTIONS','Sir Rodney','Hanna Moos',12,121.00,145.20,24.20,'DE','PY');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-03-20','New England','CONFECTIONS','Zaanse koeken','Hanna Moos',14,121.00,169.40,48.40,'DE','TH'),
	 ('2024-05-24','New England','PRODUCE','Manjimup Dried Apples','Hanna Moos',8,320.65,513.04,192.39,'DE','TH'),
	 ('2023-08-06','Store JKL','GRAINS/CEREALS','Wimmers gute Semmelkndel','Carlos Hernandez',8,199.65,319.44,119.79,'MX','TH'),
	 ('2023-04-16','Store XYZ','PRODUCE','Uncle Bob','Yvonne Moncada',6,108.90,217.80,108.90,'ZA','PT'),
	 ('2023-07-16','Store XYZ','DAIRY PRODUCTS','Mozzarella di Giovanni','Yvonne Moncada',5,127.05,211.75,84.70,'ZA','TH'),
	 ('2024-03-01','Store JKL','BEVERAGES','Guarana Fantastica','Carlos Hernandez',10,42.35,60.50,18.15,'MX','PY'),
	 ('2023-01-07','Store XYZ','GRAINS/CEREALS','Filo Mix','Lucia Carvalho',6,25.41,50.82,25.41,'BR','PT'),
	 ('2023-06-14','Store QWE','DAIRY PRODUCTS','Gudbrandsdalsost','Horst Kloss',9,304.92,392.04,87.12,'DE','UK'),
	 ('2023-01-22','Store RTY','DAIRY PRODUCTS','Raclette Courdavault','Martine Rance',12,532.40,638.88,106.48,'SN','PT'),
	 ('2023-05-15','New England','SEAFOOD','Carnarvon Tigers','Dominique Perrier',6,228.69,457.38,228.69,'FR','HK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-03-31','New England','BEVERAGES','Cite de Blaye','Dominique Perrier',5,958.32,1597.20,638.88,'FR','UK'),
	 ('2024-06-15','New England','DAIRY PRODUCTS','Gudbrandsdalsost','Dominique Perrier',10,304.92,435.60,130.68,'FR','UK'),
	 ('2024-05-28','Store JKL','PRODUCE','Manjimup Dried Apples','Rene Phillips',16,641.30,1026.08,384.78,'US','TH'),
	 ('2024-07-23','Store RTY','SEAFOOD','Gravad lax','Yang Wang',8,157.30,251.68,94.38,'CN','PT'),
	 ('2023-12-05','Store RTY','GRAINS/CEREALS','Gnocchi di nonna Alice','Yang Wang',12,459.80,551.76,91.96,'CN','TH'),
	 ('2023-07-24','Store RTY','CONFECTIONS','Tarte au sucre','Yang Wang',12,592.90,711.48,118.58,'CN','HK'),
	 ('2023-01-06','Store ABC','SEAFOOD','Boston Crab Meat','John Steel',10,127.05,181.50,54.45,'US','TH'),
	 ('2023-01-24','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Karin Josephs',12,108.90,130.68,21.78,'DE','UK'),
	 ('2024-03-01','Store XYZ','GRAINS/CEREALS','Wimmers gute Semmelkndel','Roland Mendel',4,79.86,159.72,79.86,'DE','TH'),
	 ('2024-11-16','Store XYZ','SEAFOOD','Spegesild','Pedro Afonso',9,101.64,130.68,29.04,'BR','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-02-05','Store XYZ','CONFECTIONS','Sir Rodney','Victoria Ashworth',14,96.80,135.52,38.72,'GB','TH'),
	 ('2023-08-30','Store XYZ','SEAFOOD','Boston Crab Meat','Victoria Ashworth',10,127.05,181.50,54.45,'GB','TH'),
	 ('2023-12-11','Store XYZ','PRODUCE','Manjimup Dried Apples','Victoria Ashworth',3,101.64,152.46,50.82,'GB','HK'),
	 ('2023-12-26','Store JKL','MEAT/POULTRY','Thringer Rostbratwurst','Carine Schmitt',14,1500.40,2100.56,600.16,'FR','PY'),
	 ('2024-09-11','Store QWE','MEAT/POULTRY','Alice Mutton','Daniel Tonini',6,141.57,283.14,141.57,'IT','TH'),
	 ('2024-04-22','Store QWE','DAIRY PRODUCTS','Geitost','Daniel Tonini',7,18.15,25.41,7.26,'IT','TH'),
	 ('2023-07-21','Store QWE','CONFECTIONS','Gumber Gummibrchen','Daniel Tonini',5,112.53,187.55,75.02,'IT','TH'),
	 ('2024-07-09','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Daniel Tonini',6,36.30,72.60,36.30,'IT','PT'),
	 ('2023-05-13','Store QWE','BEVERAGES','Rhinbru Klosterbier','Daniel Tonini',10,67.76,96.80,29.04,'IT','TH'),
	 ('2023-09-03','Store QWE','CONDIMENTS','Vegie-spread','Art Braunschweiger',10,372.68,532.40,159.72,'DE','HK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-02-03','Store JKL','CONDIMENTS','Northwoods Cranberry Sauce','Elizabeth Lincoln',16,484.00,774.40,290.40,'US','PT'),
	 ('2024-11-19','Store JKL','BEVERAGES','Rhinbru Klosterbier','Elizabeth Lincoln',10,67.76,96.80,29.04,'US','TH'),
	 ('2023-12-11','Store JKL','DAIRY PRODUCTS','Queso Cabrales','Carlos Hernandez',5,61.71,102.85,41.14,'MX','PY'),
	 ('2024-04-17','Store JKL','PRODUCE','Longlife Tofu','Carlos Hernandez',16,96.80,154.88,58.08,'MX','PY'),
	 ('2024-01-03','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Lucia Carvalho',5,25.41,42.35,16.94,'BR','PT'),
	 ('2024-07-11','Store QWE','PRODUCE','Manjimup Dried Apples','Maria Larsson',10,448.91,641.30,192.39,'SE','PT'),
	 ('2024-02-04','Store ABC','SEAFOOD','Boston Crab Meat','Catherine Dewey',10,152.46,217.80,65.34,'US','PT'),
	 ('2024-03-18','Store ABC','CONDIMENTS','Gula Malacca','Catherine Dewey',6,68.97,137.94,68.97,'US','PY'),
	 ('2023-02-17','Store JKL','BEVERAGES','Ipoh Coffee','Elizabeth Lincoln',9,389.62,500.94,111.32,'US','TH'),
	 ('2023-05-25','Store QWE','GRAINS/CEREALS','Ravioli Angelo','Jose Pavarotti',15,242.00,363.00,121.00,'IT','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-07-09','Store JKL','DAIRY PRODUCTS','Queso Cabrales','Georg Pipps',15,205.70,308.55,102.85,'AT','TH'),
	 ('2022-12-22','Store QWE','SEAFOOD','Carnarvon Tigers','Patricia McKenna',8,381.15,609.84,228.69,'US','TH'),
	 ('2024-05-14','Store XYZ','CONFECTIONS','Sir Rodney','Yvonne Moncada',15,980.10,1470.15,490.05,'ZA','PT'),
	 ('2023-07-20','Store XYZ','BEVERAGES','Lakkalikri','Yvonne Moncada',10,152.46,217.80,65.34,'ZA','HK'),
	 ('2023-06-04','Store XYZ','CONDIMENTS','Original Frankfurter grine Sode','Yvonne Moncada',15,157.30,235.95,78.65,'ZA','PT'),
	 ('2023-04-16','Store JKL','CONDIMENTS','Gula Malacca','Lino Rodriguez',15,193.60,290.40,96.80,'ES','UK'),
	 ('2023-01-15','Store JKL','CONDIMENTS','Original Frankfurter grine Sode','Lino Rodriguez',7,60.50,84.70,24.20,'ES','UK'),
	 ('2024-11-12','Store ABC','BEVERAGES','Ipoh Coffee','Ann Devon',6,166.98,333.96,166.98,'US','PT'),
	 ('2023-07-24','Store ABC','DAIRY PRODUCTS','Queso Cabrales','Bernardo Batista',15,254.10,381.15,127.05,'BR','PT'),
	 ('2024-08-11','Store ABC','SEAFOOD','Jack''s New England Clam Chowder','Bernardo Batista',4,24.20,48.40,24.20,'BR','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-08-15','Store XYZ','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Annette Roulet',15,205.70,308.55,102.85,'FR','PT'),
	 ('2024-10-11','Store XYZ','CONDIMENTS','Louisiana Hot Spiced Okra','Annette Roulet',10,118.58,169.40,50.82,'FR','PT'),
	 ('2022-12-04','Store XYZ','DAIRY PRODUCTS','Gudbrandsdalsost','Annette Roulet',10,245.63,350.90,105.27,'FR','TH'),
	 ('2024-03-02','Store JKL','DAIRY PRODUCTS','Camembert Pierrot','Guillermo Fernandez',4,82.28,164.56,82.28,'AR','UK'),
	 ('2022-12-06','Store ABC','GRAINS/CEREALS','Tunnbred','Yoshi Tannamuri',10,59.29,84.70,25.41,'JP','HK'),
	 ('2024-04-16','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Yoshi Tannamuri',5,36.30,60.50,24.20,'JP','PT'),
	 ('2024-07-01','Store QWE','BEVERAGES','Guarana Fantastica','Zbyszek  Piestrzeniewicz',12,60.50,72.60,12.10,'','IN'),
	 ('2023-05-01','Store QWE','CONDIMENTS','Sirop d''rable','Zbyszek  Piestrzeniewicz',7,175.45,245.63,70.18,'','PT'),
	 ('2023-01-07','Store QWE','PRODUCE','Manjimup Dried Apples','Henriette Pfalzheim',15,641.30,961.95,320.65,'DE','PT'),
	 ('2023-01-10','Store JKL','GRAINS/CEREALS','Gnocchi di nonna Alice','Renate Messner',14,363.00,508.20,145.20,'DE','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-10-22','Store QWE','MEAT/POULTRY','Piti chinois','Maria Larsson',6,87.12,174.24,87.12,'SE','HK'),
	 ('2024-02-27','Store QWE','BEVERAGES','Steeleye Stout','Jose Pavarotti',15,217.80,326.70,108.90,'IT','TH'),
	 ('2024-10-25','Store QWE','SEAFOOD','Chai','Liu Wong',4,43.56,87.12,43.56,'CN','PT'),
	 ('2024-05-02','Store QWE','SEAFOOD','Boston Crab Meat','Liu Wong',10,152.46,217.80,65.34,'CN','PY'),
	 ('2023-04-25','Store QWE','GRAINS/CEREALS','Filo Mix','Liu Wong',10,59.29,84.70,25.41,'CN','TH'),
	 ('2024-03-09','Store JKL','BEVERAGES','Guarana Fantastica','Carlos Hernandez',14,60.50,84.70,24.20,'MX','TH'),
	 ('2024-06-06','Store JKL','SEAFOOD','Boston Crab Meat','Carlos Hernandez',5,65.34,108.90,43.56,'MX','HK'),
	 ('2022-12-12','Store ABC','CONFECTIONS','Gumber Gummibrchen','Catherine Dewey',6,112.53,225.06,112.53,'US','TH'),
	 ('2023-03-05','Store ABC','BEVERAGES','Lakkalikri','Catherine Dewey',6,65.34,130.68,65.34,'US','TH'),
	 ('2023-06-01','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Matti Karttunen',10,465.85,665.50,199.65,'FI','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-03-14','Store JKL','SEAFOOD','Chai','Howard Snyder',8,108.90,174.24,65.34,'US','HK'),
	 ('2023-06-24','Store QWE','MEAT/POULTRY','Thringer Rostbratwurst','Isabel de Castro',10,1050.28,1500.40,450.12,'BR','UK'),
	 ('2024-06-30','Store QWE','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Isabel de Castro',14,169.40,237.16,67.76,'BR','UK'),
	 ('2023-10-30','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Josi Pedro Freyre',9,287.98,370.26,82.28,'BR','PT'),
	 ('2024-01-04','Store XYZ','CONDIMENTS','Genen Shouyu','Annette Roulet',12,193.60,232.32,38.72,'FR','PT'),
	 ('2024-07-11','Store XYZ','PRODUCE','Russle Sauerkraut','Annette Roulet',8,278.30,445.28,166.98,'FR','IN'),
	 ('2024-09-12','Store QWE','BEVERAGES','Guarana Fantastica','Maurizio Moroni',10,42.35,60.50,18.15,'IT','PT'),
	 ('2023-03-30','Store XYZ','GRAINS/CEREALS','Tunnbred','Alejandra Camino',10,76.23,108.90,32.67,'ES','UK'),
	 ('2024-04-05','Store XYZ','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Alejandra Camino',4,33.88,67.76,33.88,'ES','UK'),
	 ('2023-11-27','Store JKL','MEAT/POULTRY','Perth Pasties','Guillermo Fernandez',6,119.79,239.58,119.79,'AR','HK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-10-31','Store XYZ','SEAFOOD','Nord-Ost Matjeshering','Jonas Bergulfsen',15,314.60,471.90,157.30,'NO','TH'),
	 ('2023-09-15','Store XYZ','DAIRY PRODUCTS','Gorgonzola Telino','Thomas Hardy',15,157.30,235.95,78.65,'GB','PY'),
	 ('2023-12-22','Store XYZ','SEAFOOD','Inlagd Sill','Thomas Hardy',16,229.90,367.84,137.94,'GB','TH'),
	 ('2023-08-17','Store QWE','BEVERAGES','Chang 555','Karl Jablonski',12,229.90,275.88,45.98,'PL','HK'),
	 ('2023-05-02','Store QWE','CONFECTIONS','Sir Rodney','Karl Jablonski',12,121.00,145.20,24.20,'PL','HK'),
	 ('2024-08-06','Store QWE','MEAT/POULTRY','Perth Pasties','Karl Jablonski',10,279.51,399.30,119.79,'PL','UK'),
	 ('2024-11-27','Store QWE','SEAFOOD','Carnarvon Tigers','Fran Wilson',10,533.61,762.30,228.69,'US','UK'),
	 ('2023-08-20','Store QWE','GRAINS/CEREALS','Gnocchi di nonna Alice','Fran Wilson',5,137.94,229.90,91.96,'US','TH'),
	 ('2023-10-04','Store ABC','SEAFOOD','Spegesild','Sergio Gutierrez',3,29.04,43.56,14.52,'AR','IN'),
	 ('2024-03-17','Store QWE','CONFECTIONS','Tarte au sucre','Jean Fresniere',3,118.58,177.87,59.29,'CA','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-06-08','Store QWE','BEVERAGES','Chang 555','Horst Kloss',11,229.90,252.89,22.99,'DE','TH'),
	 ('2023-08-07','Store QWE','CONFECTIONS','Sir Rodney','Horst Kloss',15,980.10,1470.15,490.05,'DE','TH'),
	 ('2024-01-15','Store XYZ','PRODUCE','Uncle Bob','Victoria Ashworth',4,72.60,145.20,72.60,'GB','TH'),
	 ('2023-09-24','Store RTY','BEVERAGES','Outback Lager','Philip Cramer',14,181.50,254.10,72.60,'US','TH'),
	 ('2024-06-12','Store XYZ','BEVERAGES','Ipoh Coffee','Antonio Moreno',15,556.60,834.90,278.30,'ES','UK'),
	 ('2023-06-07','Store XYZ','CONFECTIONS','Chocolade','Antonio Moreno',15,157.30,235.95,78.65,'ES','UK'),
	 ('2023-11-28','Store ABC','CONFECTIONS','Gumber Gummibrchen','Ann Devon',12,375.10,450.12,75.02,'US','HK'),
	 ('2024-01-02','Store XYZ','SEAFOOD','Chai','Pirkko Koskitalo',10,152.46,217.80,65.34,'FI','UK'),
	 ('2024-05-13','Store QWE','SEAFOOD','Carnarvon Tigers','Paolo Accorti',8,381.15,609.84,228.69,'IT','TH'),
	 ('2024-06-01','Store QWE','PRODUCE','Manjimup Dried Apples','Paolo Accorti',10,448.91,641.30,192.39,'IT','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-12-15','Store QWE','SEAFOOD','Konbu','Henriette Pfalzheim',10,50.82,72.60,21.78,'DE','PT'),
	 ('2024-08-23','Store QWE','BEVERAGES','Chartreuse verte','Henriette Pfalzheim',10,152.46,217.80,65.34,'DE','PT'),
	 ('2023-12-29','Store RTY','CONDIMENTS','Vegie-spread','Yang Wang',12,532.40,638.88,106.48,'CN','PT'),
	 ('2024-01-25','New England','PRODUCE','Russle Sauerkraut','Hanna Moos',3,111.32,166.98,55.66,'DE','PT'),
	 ('2024-05-16','Store QWE','DAIRY PRODUCTS','Flotemysost','Jose Pavarotti',16,266.20,425.92,159.72,'IT','PT'),
	 ('2024-07-21','Store QWE','CONDIMENTS','Northwoods Cranberry Sauce','Laurence Lebihan',10,338.80,484.00,145.20,'FR','TH'),
	 ('2024-08-09','Store JKL','CONFECTIONS','Sir Rodney','Rene Phillips',15,121.00,181.50,60.50,'US','TH'),
	 ('2023-07-18','Store JKL','CONDIMENTS','Gula Malacca','Rene Phillips',12,229.90,275.88,45.98,'US','PT'),
	 ('2024-03-01','Store JKL','CONDIMENTS','Sirop d''rable','Rene Phillips',6,105.27,210.54,105.27,'US','TH'),
	 ('2023-12-20','Store ABC','SEAFOOD','Chai','Pascale Cartrain',10,152.46,217.80,65.34,'FR','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-03-03','Store ABC','MEAT/POULTRY','Tourtire','Pascale Cartrain',10,59.29,84.70,25.41,'FR','UK'),
	 ('2024-08-02','Store ABC','SEAFOOD','Konbu','Sven Ottlieb',7,36.30,50.82,14.52,'DE','HK'),
	 ('2023-05-06','Store JKL','BEVERAGES','Guarana Fantastica','Aria Cruz',10,42.35,60.50,18.15,'US','TH'),
	 ('2024-01-17','Store JKL','SEAFOOD','Spegesild','Aria Cruz',9,101.64,130.68,29.04,'US','PT'),
	 ('2022-12-22','Store JKL','CONFECTIONS','Zaanse koeken','Aria Cruz',6,36.30,72.60,36.30,'US','TH'),
	 ('2024-03-06','Store JKL','DAIRY PRODUCTS','Camembert Pierrot','Aria Cruz',12,411.40,493.68,82.28,'US','PT'),
	 ('2024-11-22','Store QWE','BEVERAGES','Outback Lager','Josi Pedro Freyre',4,36.30,72.60,36.30,'BR','PT'),
	 ('2023-10-26','Store ABC','SEAFOOD','Boston Crab Meat','Pascale Cartrain',5,65.34,108.90,43.56,'FR','HK'),
	 ('2023-04-28','Store QWE','CONDIMENTS','Sirop d''rable','Rita Muller',15,350.90,526.35,175.45,'DE','PT'),
	 ('2024-09-09','Store XYZ','CONDIMENTS','Gula Malacca','Pedro Afonso',15,229.90,344.85,114.95,'BR','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-03-29','Store XYZ','CONDIMENTS','Sirop d''rable','Pedro Afonso',4,70.18,140.36,70.18,'BR','IN'),
	 ('2023-06-27','New England','DAIRY PRODUCTS','Queso Cabrales','Dominique Perrier',10,177.87,254.10,76.23,'FR','PT'),
	 ('2024-08-13','Store QWE','MEAT/POULTRY','Mishi Kobe Niku','Horst Kloss',16,1173.70,1877.92,704.22,'DE','UK'),
	 ('2024-09-04','Store QWE','DAIRY PRODUCTS','Geitost','Horst Kloss',16,36.30,58.08,21.78,'DE','PT'),
	 ('2023-01-14','Store QWE','CONFECTIONS','Tarte au sucre','Zbyszek  Piestrzeniewicz',12,592.90,711.48,118.58,'','PT'),
	 ('2023-05-24','Store JKL','DAIRY PRODUCTS','Geitost','Elizabeth Lincoln',15,36.30,54.45,18.15,'US','PT'),
	 ('2024-03-23','Store QWE','DAIRY PRODUCTS','Mascarpone Fabioli','Rita Muller',15,387.20,580.80,193.60,'DE','PT'),
	 ('2024-09-14','Store XYZ','GRAINS/CEREALS','Filo Mix','Simon Crowther',6,25.41,50.82,25.41,'GB','PT'),
	 ('2023-04-29','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Simon Crowther',4,133.10,266.20,133.10,'GB','TH'),
	 ('2024-01-19','Store XYZ','BEVERAGES','Outback Lager','Simon Crowther',6,54.45,108.90,54.45,'GB','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-08-24','Store QWE','BEVERAGES','Chang 555','Andresa Fonseca',10,160.93,229.90,68.97,'BR','PT'),
	 ('2024-03-26','Store QWE','DAIRY PRODUCTS','Queso Manchego La Pastora','Andresa Fonseca',4,91.96,183.92,91.96,'BR','PT'),
	 ('2024-09-25','Store XYZ','BEVERAGES','Guarana Fantastica','Miguel Angel Paolino',5,18.15,30.25,12.10,'AR','PT'),
	 ('2023-04-22','Store XYZ','BEVERAGES','Cite de Blaye','Miguel Angel Paolino',15,3194.40,4791.60,1597.20,'AR','PY'),
	 ('2024-07-27','Store XYZ','CONDIMENTS','Gula Malacca','Miguel Angel Paolino',9,160.93,206.91,45.98,'AR','TH'),
	 ('2024-11-26','Store XYZ','BEVERAGES','Guarana Fantastica','Annette Roulet',10,42.35,60.50,18.15,'FR','TH'),
	 ('2023-06-03','Store XYZ','CONDIMENTS','Sirop d''rable','Mario Pontes',10,245.63,350.90,105.27,'BR','PT'),
	 ('2024-09-30','Store RTY','SEAFOOD','Ikura','Yang Wang',16,375.10,600.16,225.06,'CN','PT'),
	 ('2022-12-30','Store RTY','DAIRY PRODUCTS','Camembert Pierrot','Yang Wang',10,287.98,411.40,123.42,'CN','PT'),
	 ('2023-02-16','Store QWE','DAIRY PRODUCTS','Geitost','Patricio Simpson',10,25.41,36.30,10.89,'AR','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2022-12-31','Store JKL','BEVERAGES','Guarana Fantastica','Carlos Hernandez',15,60.50,90.75,30.25,'MX','PT'),
	 ('2023-09-04','Store JKL','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Carlos Hernandez',15,169.40,254.10,84.70,'MX','HK'),
	 ('2023-03-23','Store XYZ','BEVERAGES','Guarana Fantastica','Jonas Bergulfsen',8,30.25,48.40,18.15,'NO','PT'),
	 ('2023-06-09','Store XYZ','MEAT/POULTRY','Perth Pasties','Jonas Bergulfsen',5,119.79,199.65,79.86,'NO','HK'),
	 ('2023-08-09','Store QWE','BEVERAGES','Steeleye Stout','Patricio Simpson',3,43.56,65.34,21.78,'AR','PT'),
	 ('2023-11-14','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Patricio Simpson',10,84.70,121.00,36.30,'AR','UK'),
	 ('2023-01-23','Store QWE','CONFECTIONS','Scottish Longbreads','Patricio Simpson',6,47.19,94.38,47.19,'AR','PT'),
	 ('2023-03-24','Store XYZ','BEVERAGES','Outback Lager','Simon Crowther',3,36.30,54.45,18.15,'GB','TH'),
	 ('2023-04-02','New England','CONFECTIONS','Sir Rodney','Hanna Moos',3,24.20,36.30,12.10,'DE','TH'),
	 ('2023-05-07','New England','CONDIMENTS','Sirop d''rable','Hanna Moos',4,70.18,140.36,70.18,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-08-27','Store ABC','MEAT/POULTRY','Alice Mutton','Janete Limeira',12,471.90,566.28,94.38,'BR','PT'),
	 ('2024-06-01','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Paolo Accorti',4,82.28,164.56,82.28,'IT','TH'),
	 ('2023-07-10','Store QWE','CONDIMENTS','Original Frankfurter grine Sode','Paolo Accorti',10,110.11,157.30,47.19,'IT','UK'),
	 ('2024-02-18','Store JKL','DAIRY PRODUCTS','Camembert Pierrot','Howard Snyder',15,411.40,617.10,205.70,'US','PT'),
	 ('2023-02-18','Store QWE','MEAT/POULTRY','Perth Pasties','Maurizio Moroni',10,279.51,399.30,119.79,'IT','PT'),
	 ('2023-01-22','Store QWE','BEVERAGES','Outback Lager','Maurizio Moroni',12,181.50,217.80,36.30,'IT','HK'),
	 ('2024-05-20','Store XYZ','CONFECTIONS','Sir Rodney','Hari Kumar',15,980.10,1470.15,490.05,'US','PT'),
	 ('2023-07-20','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Hari Kumar',6,36.30,72.60,36.30,'US','PT'),
	 ('2024-08-13','Store QWE','SEAFOOD','Nord-Ost Matjeshering','Christina Berglund',10,220.22,314.60,94.38,'SE','TH'),
	 ('2022-12-18','Store QWE','MEAT/POULTRY','Tourtire','Christina Berglund',15,84.70,127.05,42.35,'SE','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-07-01','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Jose Pavarotti',12,121.00,145.20,24.20,'IT','PT'),
	 ('2023-01-09','Store QWE','MEAT/POULTRY','Piti chinois','Jose Pavarotti',4,58.08,116.16,58.08,'IT','PT'),
	 ('2023-03-23','Store QWE','SEAFOOD','Nord-Ost Matjeshering','Carlos Gonzalez',4,62.92,125.84,62.92,'ES','TH'),
	 ('2023-12-27','Store QWE','CONFECTIONS','Pavlova','Karl Jablonski',3,41.14,61.71,20.57,'PL','HK'),
	 ('2023-02-12','Store QWE','SEAFOOD','Boston Crab Meat','Laurence Lebihan',15,217.80,326.70,108.90,'FR','HK'),
	 ('2023-01-25','Store ABC','SEAFOOD','Jack''s New England Clam Chowder','Sven Ottlieb',9,84.70,108.90,24.20,'DE','PT'),
	 ('2023-01-29','Store XYZ','PRODUCE','Russle Sauerkraut','Lucia Carvalho',8,278.30,445.28,166.98,'BR','PT'),
	 ('2023-04-06','Store XYZ','SEAFOOD','Konbu','Pirkko Koskitalo',10,50.82,72.60,21.78,'FI','HK'),
	 ('2024-09-11','Store XYZ','SEAFOOD','Chai','Pirkko Koskitalo',8,108.90,174.24,65.34,'FI','PT'),
	 ('2023-03-22','Store QWE','PRODUCE','Uncle Bob','Carlos Gonzalez',15,363.00,544.50,181.50,'ES','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-09-22','Store QWE','SEAFOOD','Konbu','Carlos Gonzalez',10,50.82,72.60,21.78,'ES','UK'),
	 ('2023-10-01','Store XYZ','BEVERAGES','Chang 555','Roland Mendel',8,114.95,183.92,68.97,'DE','PT'),
	 ('2024-04-11','Store JKL','DAIRY PRODUCTS','Queso Cabrales','Guillermo Fernandez',10,177.87,254.10,76.23,'AR','IN'),
	 ('2024-11-12','Store JKL','DAIRY PRODUCTS','Queso Cabrales','Howard Snyder',3,50.82,76.23,25.41,'US','PT'),
	 ('2023-10-30','Store JKL','DAIRY PRODUCTS','Geitost','Howard Snyder',8,18.15,29.04,10.89,'US','PT'),
	 ('2023-10-20','Store JKL','DAIRY PRODUCTS','Mozzarella di Giovanni','Howard Snyder',9,296.45,381.15,84.70,'US','TH'),
	 ('2022-12-21','Store QWE','CONFECTIONS','Pavlova','Jytte Petersen',14,205.70,287.98,82.28,'DK','IN'),
	 ('2024-04-05','New England','BEVERAGES','Chang 555','Michael Holz',10,160.93,229.90,68.97,'DE','TH'),
	 ('2024-08-19','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Laurence Lebihan',10,76.23,108.90,32.67,'FR','HK'),
	 ('2023-10-27','Store RTY','CONDIMENTS','Aniseed Syrup','Paula Wilson',4,24.20,48.40,24.20,'US','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-02-25','Store RTY','SEAFOOD','Konbu','Paula Wilson',4,14.52,29.04,14.52,'US','PT'),
	 ('2023-04-24','Store RTY','SEAFOOD','Jack''s New England Clam Chowder','Paula Wilson',3,24.20,36.30,12.10,'US','PT'),
	 ('2024-02-25','Store RTY','SEAFOOD','Spegesild','Paula Wilson',3,29.04,43.56,14.52,'US','PT'),
	 ('2024-04-23','Store RTY','BEVERAGES','Rhinbru Klosterbier','Paula Wilson',4,19.36,38.72,19.36,'US','PT'),
	 ('2023-03-28','Store ABC','MEAT/POULTRY','Piti chinois','Catherine Dewey',14,290.40,406.56,116.16,'US','PT'),
	 ('2024-02-28','Store ABC','DAIRY PRODUCTS','Gudbrandsdalsost','Catherine Dewey',10,304.92,435.60,130.68,'US','TH'),
	 ('2024-02-14','Store ABC','SEAFOOD','Nord-Ost Matjeshering','Ann Devon',15,314.60,471.90,157.30,'US','PY'),
	 ('2024-02-29','Store JKL','SEAFOOD','Nord-Ost Matjeshering','Renate Messner',10,220.22,314.60,94.38,'DE','TH'),
	 ('2024-06-03','Store JKL','SEAFOOD','Boston Crab Meat','Renate Messner',10,152.46,217.80,65.34,'DE','PT'),
	 ('2024-07-16','Store JKL','MEAT/POULTRY','Tourtire','Renate Messner',10,59.29,84.70,25.41,'DE','IN');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-09-26','Store XYZ','SEAFOOD','Boston Crab Meat','Antonio Moreno',10,152.46,217.80,65.34,'ES','PT'),
	 ('2024-04-17','Store XYZ','GRAINS/CEREALS','Ravioli Angelo','Antonio Moreno',5,72.60,121.00,48.40,'ES','UK'),
	 ('2024-08-10','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Antonio Moreno',15,665.50,998.25,332.75,'ES','UK'),
	 ('2023-04-04','Store JKL','DAIRY PRODUCTS','Queso Manchego La Pastora','Renate Messner',15,459.80,689.70,229.90,'DE','PT'),
	 ('2024-05-17','New England','PRODUCE','Manjimup Dried Apples','Michael Holz',6,192.39,384.78,192.39,'DE','PT'),
	 ('2024-06-20','New England','SEAFOOD','Rid Kaviar','Michael Holz',9,127.05,163.35,36.30,'DE','PT'),
	 ('2024-06-06','Store XYZ','BEVERAGES','Outback Lager','Victoria Ashworth',7,90.75,127.05,36.30,'GB','PT'),
	 ('2024-07-20','Store XYZ','SEAFOOD','Konbu','Victoria Ashworth',8,36.30,58.08,21.78,'GB','PT'),
	 ('2023-08-03','Store XYZ','CONFECTIONS','Sir Rodney','Victoria Ashworth',15,121.00,181.50,60.50,'GB','PT'),
	 ('2023-12-31','Store XYZ','DAIRY PRODUCTS','Geitost','Victoria Ashworth',15,36.30,54.45,18.15,'GB','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-11-15','Store XYZ','CONFECTIONS','Maxilaku','Victoria Ashworth',6,72.60,145.20,72.60,'GB','PT'),
	 ('2024-09-26','Store XYZ','BEVERAGES','Cite de Blaye','Mario Pontes',4,638.88,1277.76,638.88,'BR','PY'),
	 ('2023-06-09','Store XYZ','DAIRY PRODUCTS','Flotemysost','Mario Pontes',9,186.34,239.58,53.24,'BR','PT'),
	 ('2023-07-25','Store RTY','DAIRY PRODUCTS','Queso Cabrales','Philip Cramer',15,254.10,381.15,127.05,'US','TH'),
	 ('2024-08-07','Store QWE','PRODUCE','Russle Sauerkraut','Fran Wilson',7,278.30,389.62,111.32,'US','IN'),
	 ('2024-05-19','Store QWE','BEVERAGES','Laughing Lumberjack Lager','Fran Wilson',7,84.70,118.58,33.88,'US','IN'),
	 ('2023-02-14','Store ABC','DAIRY PRODUCTS','Queso Cabrales','John Steel',10,177.87,254.10,76.23,'US','TH'),
	 ('2024-06-08','Store ABC','PRODUCE','Uncle Bob','Mary Saveley',10,254.10,363.00,108.90,'US','PT'),
	 ('2024-10-20','Store XYZ','BEVERAGES','Sasquatch Ale','Karin Josephs',10,118.58,169.40,50.82,'DE','TH'),
	 ('2023-07-20','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Karin Josephs',14,121.00,169.40,48.40,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-08-10','Store QWE','MEAT/POULTRY','Alice Mutton','Josi Pedro Freyre',8,235.95,377.52,141.57,'BR','PT'),
	 ('2023-07-29','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Josi Pedro Freyre',10,76.23,108.90,32.67,'BR','PT'),
	 ('2024-04-17','Store QWE','CONFECTIONS','Sir Rodney','Josi Pedro Freyre',6,36.30,72.60,36.30,'BR','PT'),
	 ('2023-07-01','Store QWE','CONDIMENTS','Sirop d''rable','Josi Pedro Freyre',10,245.63,350.90,105.27,'BR','TH'),
	 ('2023-06-09','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Pirkko Koskitalo',15,254.10,381.15,127.05,'FI','TH'),
	 ('2024-09-02','Store XYZ','CONFECTIONS','Pavlova','Pirkko Koskitalo',14,205.70,287.98,82.28,'FI','PT'),
	 ('2024-06-14','Store XYZ','BEVERAGES','Steeleye Stout','Pirkko Koskitalo',6,65.34,130.68,65.34,'FI','PT'),
	 ('2023-10-07','Store QWE','CONDIMENTS','Original Frankfurter grine Sode','Henriette Pfalzheim',10,110.11,157.30,47.19,'DE','PT'),
	 ('2024-09-03','Store XYZ','SEAFOOD','Rid Kaviar','Thomas Hardy',3,36.30,54.45,18.15,'GB','PT'),
	 ('2024-03-07','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Frederique Citeaux',12,121.00,145.20,24.20,'FR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2022-12-05','Store ABC','CONFECTIONS','Tarte au sucre','Peter Franken',15,592.90,889.35,296.45,'DE','UK'),
	 ('2023-04-17','Store QWE','CONDIMENTS','Gula Malacca','Maria Larsson',10,160.93,229.90,68.97,'SE','PT'),
	 ('2024-06-08','Store QWE','CONFECTIONS','Tarte au sucre','Maurizio Moroni',10,415.03,592.90,177.87,'IT','TH'),
	 ('2024-02-27','Store RTY','MEAT/POULTRY','Alice Mutton','Paula Wilson',16,471.90,755.04,283.14,'US','PT'),
	 ('2024-02-03','Store RTY','DAIRY PRODUCTS','Gorgonzola Telino','Paula Wilson',6,47.19,94.38,47.19,'US','PT'),
	 ('2023-12-18','Store XYZ','BEVERAGES','Lakkalikri','Frederique Citeaux',10,152.46,217.80,65.34,'FR','HK'),
	 ('2024-03-09','Store QWE','PRODUCE','Manjimup Dried Apples','Patricia McKenna',3,128.26,192.39,64.13,'US','PY'),
	 ('2023-03-16','Store QWE','SEAFOOD','Ikura','Eduardo Saavedra',5,112.53,187.55,75.02,'ES','UK'),
	 ('2023-01-08','Store QWE','DAIRY PRODUCTS','Queso Cabrales','Jean Fresniere',15,254.10,381.15,127.05,'CA','TH'),
	 ('2024-02-09','Store XYZ','PRODUCE','Tofu','Roland Mendel',11,278.30,306.13,27.83,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-10-26','Store QWE','CONFECTIONS','Pavlova','Christina Berglund',12,205.70,246.84,41.14,'SE','TH'),
	 ('2023-05-25','Store QWE','DAIRY PRODUCTS','Mascarpone Fabioli','Christina Berglund',10,271.04,387.20,116.16,'SE','TH'),
	 ('2023-12-06','Store QWE','BEVERAGES','Rhinbru Klosterbier','Christina Berglund',15,96.80,145.20,48.40,'SE','PT'),
	 ('2023-12-12','Store QWE','DAIRY PRODUCTS','Geitost','Helvetius Nagy',14,36.30,50.82,14.52,'HU','HK'),
	 ('2023-09-27','Store QWE','CONFECTIONS','Tarte au sucre','Helvetius Nagy',10,415.03,592.90,177.87,'HU','PT'),
	 ('2024-06-27','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Helvetius Nagy',6,119.79,239.58,119.79,'HU','TH'),
	 ('2024-11-12','Store JKL','DAIRY PRODUCTS','Raclette Courdavault','Alexander Feuer',12,665.50,798.60,133.10,'DE','TH'),
	 ('2023-12-27','Store JKL','CONDIMENTS','Vegie-spread','Alexander Feuer',6,159.72,319.44,159.72,'DE','PY'),
	 ('2024-03-21','Store JKL','BEVERAGES','Lakkalikri','Alexander Feuer',10,152.46,217.80,65.34,'DE','TH'),
	 ('2023-07-25','Store XYZ','SEAFOOD','Chai','Miguel Angel Paolino',10,152.46,217.80,65.34,'AR','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-01-08','Store QWE','BEVERAGES','Chartreuse verte','Helvetius Nagy',10,152.46,217.80,65.34,'HU','PT'),
	 ('2023-12-08','Store XYZ','GRAINS/CEREALS','Ravioli Angelo','Victoria Ashworth',6,72.60,145.20,72.60,'GB','PT'),
	 ('2024-10-17','Store QWE','CONDIMENTS','Genen Shouyu','Jaime Yorres',10,135.52,193.60,58.08,'ES','PT'),
	 ('2024-11-17','Store QWE','PRODUCE','Tofu','Henriette Pfalzheim',15,278.30,417.45,139.15,'DE','PT'),
	 ('2023-08-15','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Henriette Pfalzheim',9,84.70,108.90,24.20,'DE','PT'),
	 ('2024-01-21','New England','GRAINS/CEREALS','Ravioli Angelo','Hanna Moos',4,48.40,96.80,48.40,'DE','PT'),
	 ('2023-10-29','New England','BEVERAGES','Lakkalikri','Hanna Moos',14,217.80,304.92,87.12,'DE','PT'),
	 ('2022-12-30','Store XYZ','MEAT/POULTRY','Thringer Rostbratwurst','Pirkko Koskitalo',10,1050.28,1500.40,450.12,'FI','HK'),
	 ('2023-12-25','Store XYZ','DAIRY PRODUCTS','Gudbrandsdalsost','Pirkko Koskitalo',10,304.92,435.60,130.68,'FI','TH'),
	 ('2024-06-22','Store JKL','CONFECTIONS','Zaanse koeken','Paula Parente',15,121.00,181.50,60.50,'AO','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-02-11','Store QWE','GRAINS/CEREALS','Filo Mix','Maurizio Moroni',4,16.94,33.88,16.94,'IT','TH'),
	 ('2024-08-22','Store ABC','CONFECTIONS','Gumber Gummibrchen','Bernardo Batista',6,112.53,225.06,112.53,'BR','PT'),
	 ('2023-05-03','Store JKL','BEVERAGES','Steeleye Stout','Howard Snyder',4,43.56,87.12,43.56,'US','TH'),
	 ('2023-02-19','Store XYZ','DAIRY PRODUCTS','Geitost','Jonas Bergulfsen',3,83.56,0.00,83.56,'NO','IN'),
	 ('2023-12-29','Store ABC','CONDIMENTS','Aniseed Syrup','Palle Ibsen',14,121.00,169.40,48.40,'DK','UK'),
	 ('2023-12-21','Store ABC','PRODUCE','Uncle Bob','Palle Ibsen',10,254.10,363.00,108.90,'DK','PT'),
	 ('2023-06-08','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Mario Pontes',10,67.76,96.80,29.04,'BR','PT'),
	 ('2023-09-25','Store ABC','GRAINS/CEREALS','Gustaf','Mary Saveley',6,61.71,123.42,61.71,'US','PT'),
	 ('2023-05-01','Store JKL','CONFECTIONS','Gumber Gummibrchen','Renate Messner',5,112.53,187.55,75.02,'DE','TH'),
	 ('2023-09-04','Store JKL','BEVERAGES','Lakkalikri','Renate Messner',4,43.56,87.12,43.56,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-08-18','Store RTY','BEVERAGES','Guarana Fantastica','Yang Wang',15,48.40,72.60,24.20,'CN','TH'),
	 ('2023-11-01','Store QWE','GRAINS/CEREALS','Gnocchi di nonna Alice','Karl Jablonski',5,137.94,229.90,91.96,'PL','PT'),
	 ('2024-06-14','Store JKL','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Georg Pipps',12,254.10,304.92,50.82,'AT','IN'),
	 ('2023-02-01','Store RTY','DAIRY PRODUCTS','Flotemysost','Paula Wilson',9,186.34,239.58,53.24,'US','TH'),
	 ('2024-04-24','Store JKL','MEAT/POULTRY','Perth Pasties','Paula Parente',15,314.60,471.90,157.30,'AO','PT'),
	 ('2024-06-29','Store JKL','CONDIMENTS','Original Frankfurter grine Sode','Paula Parente',12,121.00,145.20,24.20,'AO','TH'),
	 ('2024-04-09','Store XYZ','CONFECTIONS','Tarte au sucre','Victoria Ashworth',10,415.03,592.90,177.87,'GB','PT'),
	 ('2024-10-09','Store JKL','BEVERAGES','Chartreuse verte','Carlos Hernandez',6,50.82,101.64,50.82,'MX','TH'),
	 ('2023-09-29','Store JKL','CONDIMENTS','Original Frankfurter grine Sode','Carlos Hernandez',15,121.00,181.50,60.50,'MX','PT'),
	 ('2023-08-29','Store XYZ','MEAT/POULTRY','Tourtire','Yoshi Latimer',4,16.94,33.88,16.94,'JP','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-07-05','Store XYZ','DAIRY PRODUCTS','Mascarpone Fabioli','Roland Mendel',6,94.38,188.76,94.38,'DE','TH'),
	 ('2023-08-19','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Palle Ibsen',5,47.19,78.65,31.46,'DK','UK'),
	 ('2023-12-20','New England','CONFECTIONS','Sir Rodney','Francisco Chang',10,67.76,96.80,29.04,'CN','PT'),
	 ('2023-02-21','Store JKL','CONFECTIONS','Chocolade','Lino Rodriguez',6,47.19,94.38,47.19,'ES','UK'),
	 ('2023-05-03','Store JKL','BEVERAGES','Lakkalikri','Lino Rodriguez',10,152.46,217.80,65.34,'ES','UK'),
	 ('2024-03-17','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Henriette Pfalzheim',16,96.80,154.88,58.08,'DE','TH'),
	 ('2024-05-03','Store QWE','CONFECTIONS','Tarte au sucre','Henriette Pfalzheim',15,471.90,707.85,235.95,'DE','PT'),
	 ('2024-05-01','Store QWE','DAIRY PRODUCTS','Flotemysost','Jean Fresniere',15,266.20,399.30,133.10,'CA','PT'),
	 ('2023-02-21','Store RTY','CONDIMENTS','Chef Anton''s Gumbo Mix','Paula Wilson',12,205.70,246.84,41.14,'US','PT'),
	 ('2023-12-17','Store RTY','PRODUCE','Uncle Bob','Paula Wilson',15,290.40,435.60,145.20,'US','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-11-01','Store JKL','CONFECTIONS','Tarte au sucre','Anabela Domingues',10,415.03,592.90,177.87,'BR','TH'),
	 ('2024-09-27','Store QWE','DAIRY PRODUCTS','Geitost','Jose Pavarotti',14,36.30,50.82,14.52,'IT','PT'),
	 ('2023-07-17','Store QWE','DAIRY PRODUCTS','Mozzarella di Giovanni','Jose Pavarotti',12,423.50,508.20,84.70,'IT','UK'),
	 ('2023-10-15','Store XYZ','SEAFOOD','Chai','Janine Labrune',3,43.56,65.34,21.78,'FR','IN'),
	 ('2023-02-19','Store XYZ','SEAFOOD','Ikura','Janine Labrune',10,262.57,375.10,112.53,'FR','TH'),
	 ('2024-08-02','Store XYZ','CONFECTIONS','Sir Rodney','Janine Labrune',6,36.30,72.60,36.30,'FR','IN'),
	 ('2023-10-06','Store QWE','SEAFOOD','Chai','Zbyszek  Piestrzeniewicz',6,65.34,130.68,65.34,'','TH'),
	 ('2023-04-04','Store QWE','BEVERAGES','Chang 555','Zbyszek  Piestrzeniewicz',10,160.93,229.90,68.97,'','PT'),
	 ('2023-08-31','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Zbyszek  Piestrzeniewicz',15,411.40,617.10,205.70,'','IN'),
	 ('2024-05-03','Store XYZ','DAIRY PRODUCTS','Queso Manchego La Pastora','Pirkko Koskitalo',12,363.00,435.60,72.60,'FI','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-07-17','Store ABC','BEVERAGES','Lakkalikri','Peter Franken',15,169.40,254.10,84.70,'DE','TH'),
	 ('2024-07-26','Store JKL','SEAFOOD','Konbu','Carlos Hernandez',8,36.30,58.08,21.78,'MX','PY'),
	 ('2022-12-06','New England','DAIRY PRODUCTS','Queso Cabrales','Hanna Moos',14,254.10,355.74,101.64,'DE','IN'),
	 ('2024-07-16','New England','CONFECTIONS','Sir Rodney','Hanna Moos',8,60.50,96.80,36.30,'DE','PT'),
	 ('2023-04-23','New England','BEVERAGES','Chartreuse verte','Hanna Moos',5,65.34,108.90,43.56,'DE','TH'),
	 ('2023-03-12','Store QWE','MEAT/POULTRY','Thringer Rostbratwurst','Manuel Pereira',10,838.53,1197.90,359.37,'BR','UK'),
	 ('2023-05-30','Store QWE','DAIRY PRODUCTS','Mozzarella di Giovanni','Manuel Pereira',4,67.76,135.52,67.76,'BR','UK'),
	 ('2024-05-04','Store XYZ','MEAT/POULTRY','Piti chinois','Matti Karttunen',5,87.12,145.20,58.08,'FI','HK'),
	 ('2023-03-01','Store JKL','BEVERAGES','Cite de Blaye','Howard Snyder',15,3194.40,4791.60,1597.20,'US','PT'),
	 ('2024-04-27','Store JKL','GRAINS/CEREALS','Gnocchi di nonna Alice','Howard Snyder',14,459.80,643.72,183.92,'US','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-04-12','Store JKL','BEVERAGES','Outback Lager','Howard Snyder',15,181.50,272.25,90.75,'US','TH'),
	 ('2024-05-22','Store JKL','DAIRY PRODUCTS','Flotemysost','Howard Snyder',15,266.20,399.30,133.10,'US','PT'),
	 ('2024-08-07','Store QWE','CONFECTIONS','Scottish Longbreads','Jean Fresniere',15,157.30,235.95,78.65,'CA','PY'),
	 ('2024-09-25','Store RTY','CONFECTIONS','Sir Rodney','Paula Wilson',6,235.95,471.90,235.95,'US','PT'),
	 ('2024-01-31','Store QWE','DAIRY PRODUCTS','Gorgonzola Telino','Horst Kloss',15,121.00,181.50,60.50,'DE','TH'),
	 ('2024-03-26','Store ABC','BEVERAGES','Guarana Fantastica','Yoshi Tannamuri',5,18.15,30.25,12.10,'JP','PT'),
	 ('2024-09-20','Store ABC','GRAINS/CEREALS','Filo Mix','Yoshi Tannamuri',5,25.41,42.35,16.94,'JP','PY'),
	 ('2023-12-06','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Helen Bennett',5,32.67,54.45,21.78,'GB','TH'),
	 ('2023-06-02','Store XYZ','GRAINS/CEREALS','Tunnbred','Helen Bennett',10,76.23,108.90,32.67,'GB','TH'),
	 ('2024-04-02','Store XYZ','DAIRY PRODUCTS','Flotemysost','Helen Bennett',15,266.20,399.30,133.10,'GB','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-11-04','Store RTY','DAIRY PRODUCTS','Mozzarella di Giovanni','Paul Henriot',7,169.40,237.16,67.76,'FR','UK'),
	 ('2023-04-10','Store XYZ','BEVERAGES','Guarana Fantastica','Giovanni Rovelli',12,48.40,58.08,9.68,'IT','TH'),
	 ('2024-04-21','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Giovanni Rovelli',6,159.72,319.44,159.72,'IT','TH'),
	 ('2023-05-09','Store ABC','CONFECTIONS','Teatime Chocolate Biscuits','Peter Franken',15,108.90,163.35,54.45,'DE','TH'),
	 ('2024-05-29','Store ABC','BEVERAGES','Guarana Fantastica','Peter Franken',3,12.10,18.15,6.05,'DE','PT'),
	 ('2023-06-04','Store QWE','PRODUCE','Russle Sauerkraut','Liu Wong',10,389.62,556.60,166.98,'CN','TH'),
	 ('2024-03-10','Store QWE','MEAT/POULTRY','Thringer Rostbratwurst','Liu Wong',6,450.12,900.24,450.12,'CN','PT'),
	 ('2023-03-03','Store QWE','CONDIMENTS','Gula Malacca','Liu Wong',10,160.93,229.90,68.97,'CN','HK'),
	 ('2024-05-12','Store XYZ','SEAFOOD','Ikura','Miguel Angel Paolino',15,302.50,453.75,151.25,'AR','UK'),
	 ('2024-10-21','Store XYZ','SEAFOOD','Konbu','Miguel Angel Paolino',10,42.35,60.50,18.15,'AR','IN');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-07-09','Store XYZ','PRODUCE','Tofu','Ana Trujillo',3,55.66,83.49,27.83,'MX','PT'),
	 ('2023-04-12','Store XYZ','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Ana Trujillo',5,50.82,84.70,33.88,'MX','IN'),
	 ('2024-06-02','Store XYZ','DAIRY PRODUCTS','Camembert Pierrot','Ana Trujillo',10,287.98,411.40,123.42,'MX','TH'),
	 ('2023-07-25','Store JKL','CONFECTIONS','Tarte au sucre','Alexander Feuer',12,471.90,566.28,94.38,'DE','PT'),
	 ('2024-08-08','Store QWE','MEAT/POULTRY','Perth Pasties','Christina Berglund',12,399.30,479.16,79.86,'SE','TH'),
	 ('2024-03-11','Store QWE','CONFECTIONS','Tarte au sucre','Jose Pavarotti',15,592.90,889.35,296.45,'IT','PT'),
	 ('2024-05-22','Store QWE','CONDIMENTS','Gula Malacca','Christina Berglund',16,193.60,309.76,116.16,'SE','TH'),
	 ('2024-05-07','Store QWE','DAIRY PRODUCTS','Raclette Courdavault','Christina Berglund',15,532.40,798.60,266.20,'SE','TH'),
	 ('2023-02-15','Store QWE','CONDIMENTS','Vegie-spread','Christina Berglund',8,211.75,338.80,127.05,'SE','TH'),
	 ('2024-08-14','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Josi Pedro Freyre',9,279.51,359.37,79.86,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-02-25','Store JKL','MEAT/POULTRY','Alice Mutton','Renate Messner',15,375.10,562.65,187.55,'DE','TH'),
	 ('2023-08-28','Store RTY','MEAT/POULTRY','Piti chinois','Philip Cramer',12,290.40,348.48,58.08,'US','PT'),
	 ('2024-01-06','Store QWE','BEVERAGES','Guarana Fantastica','Christina Berglund',12,48.40,58.08,9.68,'SE','PY'),
	 ('2023-04-01','Store XYZ','BEVERAGES','Guarana Fantastica','Alejandra Camino',6,14.52,29.04,14.52,'ES','UK'),
	 ('2024-08-30','Store XYZ','BEVERAGES','Steeleye Stout','Alejandra Camino',4,33.88,67.76,33.88,'ES','PT'),
	 ('2023-07-29','Store XYZ','BEVERAGES','Rhinbru Klosterbier','Annette Roulet',8,48.40,77.44,29.04,'FR','PY'),
	 ('2022-12-04','Store XYZ','SEAFOOD','Nord-Ost Matjeshering','Alejandra Camino',6,76.23,152.46,76.23,'ES','UK'),
	 ('2023-10-23','Store XYZ','SEAFOOD','Konbu','Roland Mendel',13,72.60,94.38,21.78,'DE','IN'),
	 ('2023-04-07','Store RTY','PRODUCE','Manjimup Dried Apples','Martine Rance',15,641.30,961.95,320.65,'SN','IN'),
	 ('2023-04-25','Store QWE','DAIRY PRODUCTS','Mozzarella di Giovanni','Carlos Gonzalez',3,67.76,101.64,33.88,'ES','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2022-12-27','Store XYZ','CONDIMENTS','Chef Anton''s Cajun Seasoning','Giovanni Rovelli',10,186.34,266.20,79.86,'IT','PT'),
	 ('2023-01-14','Store XYZ','CONDIMENTS','Chef Anton''s Gumbo Mix','Giovanni Rovelli',15,254.10,381.15,127.05,'IT','TH'),
	 ('2023-09-06','Store JKL','CONFECTIONS','Schoggi Schokolade','Renate Messner',15,423.50,635.25,211.75,'DE','PT'),
	 ('2024-07-30','Store JKL','BEVERAGES','Laughing Lumberjack Lager','Renate Messner',5,39.93,66.55,26.62,'DE','PT'),
	 ('2023-02-26','Store XYZ','SEAFOOD','Escargots de Bourgogne','Pirkko Koskitalo',6,47.19,94.38,47.19,'FI','PT'),
	 ('2023-06-10','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Lucia Carvalho',10,177.87,254.10,76.23,'BR','PT'),
	 ('2024-08-16','Store XYZ','SEAFOOD','Carnarvon Tigers','Jonas Bergulfsen',8,381.15,609.84,228.69,'NO','PT'),
	 ('2024-07-02','Store QWE','BEVERAGES','Outback Lager','Rita Muller',15,181.50,272.25,90.75,'DE','PT'),
	 ('2023-11-07','Store ABC','SEAFOOD','Spegesild','Janete Limeira',15,121.00,181.50,60.50,'BR','PT'),
	 ('2022-12-10','Store QWE','MEAT/POULTRY','Tourtire','Maurizio Moroni',10,50.82,72.60,21.78,'IT','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-05-31','Store QWE','CONFECTIONS','Scottish Longbreads','Maurizio Moroni',3,24.20,36.30,12.10,'IT','TH'),
	 ('2023-10-21','Store QWE','PRODUCE','Russle Sauerkraut','Maria Anders s',15,556.60,834.90,278.30,'DE','HK'),
	 ('2022-12-13','Store JKL','SEAFOOD','Carnarvon Tigers','Paula Parente',4,152.46,304.92,152.46,'AO','PT'),
	 ('2023-08-02','Store XYZ','GRAINS/CEREALS','Wimmers gute Semmelkndel','Victoria Ashworth',9,228.69,294.03,65.34,'GB','TH'),
	 ('2023-04-27','Store XYZ','SEAFOOD','Inlagd Sill','Mario Pontes',15,229.90,344.85,114.95,'BR','PT'),
	 ('2024-05-02','Store XYZ','MEAT/POULTRY','Thringer Rostbratwurst','Pedro Afonso',15,1197.90,1796.85,598.95,'BR','HK'),
	 ('2023-07-21','Store XYZ','CONFECTIONS','Maxilaku','Pedro Afonso',15,193.60,290.40,96.80,'BR','PT'),
	 ('2024-07-13','Store XYZ','CONDIMENTS','Original Frankfurter grine Sode','Pedro Afonso',10,84.70,121.00,36.30,'BR','PT'),
	 ('2023-06-29','Store QWE','SEAFOOD','Chai','Patricia McKenna',15,217.80,326.70,108.90,'US','PT'),
	 ('2023-03-25','Store ABC','GRAINS/CEREALS','Gustaf','Janete Limeira',15,254.10,381.15,127.05,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-26','Store ABC','BEVERAGES','Guarana Fantastica','Janete Limeira',15,60.50,90.75,30.25,'BR','PT'),
	 ('2023-09-24','Store ABC','DAIRY PRODUCTS','Mozzarella di Giovanni','Catherine Dewey',15,423.50,635.25,211.75,'US','PY'),
	 ('2024-04-18','Store XYZ','SEAFOOD','Carnarvon Tigers','Miguel Angel Paolino',12,605.00,726.00,121.00,'AR','IN'),
	 ('2023-05-11','Store XYZ','BEVERAGES','Guarana Fantastica','Miguel Angel Paolino',10,33.88,48.40,14.52,'AR','HK'),
	 ('2024-03-23','Store XYZ','CONDIMENTS','Vegie-spread','Miguel Angel Paolino',5,127.05,211.75,84.70,'AR','PY'),
	 ('2024-02-14','Store XYZ','BEVERAGES','Rhinbru Klosterbier','Miguel Angel Paolino',6,21.78,43.56,21.78,'AR','IN'),
	 ('2023-02-26','Store RTY','MEAT/POULTRY','Alice Mutton','Paula Wilson',15,375.10,562.65,187.55,'US','PT'),
	 ('2024-05-22','Store RTY','BEVERAGES','Ipoh Coffee','Paula Wilson',15,447.70,671.55,223.85,'US','TH'),
	 ('2023-09-06','Store RTY','BEVERAGES','Rhinbru Klosterbier','Paula Wilson',6,21.78,43.56,21.78,'US','TH'),
	 ('2024-03-28','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Rita Muller',12,108.90,130.68,21.78,'DE','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-10','Store RTY','GRAINS/CEREALS','Gnocchi di nonna Alice','Paul Henriot',4,72.60,145.20,72.60,'FR','TH'),
	 ('2023-07-15','Store QWE','CONDIMENTS','Chef Anton''s Cajun Seasoning','Christina Berglund',12,266.20,319.44,53.24,'SE','PT'),
	 ('2023-07-27','Store QWE','MEAT/POULTRY','Tourtire','Christina Berglund',6,25.41,50.82,25.41,'SE','PT'),
	 ('2023-07-04','Store QWE','DAIRY PRODUCTS','Queso Cabrales','Carlos Gonzalez',12,205.70,246.84,41.14,'ES','UK'),
	 ('2023-06-08','Store QWE','DAIRY PRODUCTS','Gudbrandsdalsost','Carlos Gonzalez',15,350.90,526.00,175.10,'ES','UK'),
	 ('2024-06-06','Store JKL','PRODUCE','Tofu','Howard Snyder',3,55.66,83.49,27.83,'US','HK'),
	 ('2023-09-07','Store JKL','CONFECTIONS','Zaanse koeken','Howard Snyder',6,36.30,72.60,36.30,'US','HK'),
	 ('2023-11-02','Store QWE','CONFECTIONS','Zaanse koeken','Jose Pavarotti',10,84.70,121.00,36.30,'IT','IN'),
	 ('2024-02-08','Store QWE','CONFECTIONS','Tarte au sucre','Patricia McKenna',15,471.90,707.85,235.95,'US','TH'),
	 ('2024-10-06','Store ABC','CONFECTIONS','Teatime Chocolate Biscuits','Janete Limeira',15,84.70,127.05,42.35,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-03-04','Store QWE','SEAFOOD','Boston Crab Meat','Rita Muller',10,127.05,181.50,54.45,'DE','PY'),
	 ('2022-12-17','Store QWE','BEVERAGES','Chartreuse verte','Patricia McKenna',3,43.56,65.34,21.78,'US','TH'),
	 ('2024-10-03','Store QWE','CONFECTIONS','Scottish Longbreads','Fran Wilson',10,110.11,157.30,47.19,'US','PT'),
	 ('2023-07-14','Store JKL','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Lino Rodriguez',15,254.10,381.15,127.05,'ES','UK'),
	 ('2024-04-01','Store ABC','BEVERAGES','Ipoh Coffee','Pascale Cartrain',12,447.70,537.24,89.54,'FR','TH'),
	 ('2023-01-17','Store JKL','GRAINS/CEREALS','Gnocchi di nonna Alice','Lino Rodriguez',12,459.80,551.76,91.96,'ES','UK'),
	 ('2023-04-15','Store QWE','BEVERAGES','Lakkalikri','Fran Wilson',10,152.46,217.80,65.34,'US','IN'),
	 ('2024-05-17','Store QWE','CONFECTIONS','Scottish Longbreads','Josi Pedro Freyre',15,121.00,181.50,60.50,'BR','PT'),
	 ('2024-10-27','New England','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Michael Holz',10,177.87,254.10,76.23,'DE','TH'),
	 ('2023-03-13','Store XYZ','DAIRY PRODUCTS','Flotemysost','Roland Mendel',14,266.20,372.68,106.48,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-03-31','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Miguel Angel Paolino',10,372.68,532.40,159.72,'AR','HK'),
	 ('2024-07-17','Store QWE','DAIRY PRODUCTS','Gorgonzola Telino','Rita Muller',8,78.65,125.84,47.19,'DE','IN'),
	 ('2024-10-10','Store QWE','MEAT/POULTRY','Piti chinois','Rita Muller',4,58.08,116.16,58.08,'DE','PT'),
	 ('2024-07-25','Store QWE','GRAINS/CEREALS','Wimmers gute Semmelkndel','Rita Muller',15,399.30,598.95,199.65,'DE','HK'),
	 ('2024-11-01','Store XYZ','SEAFOOD','Nord-Ost Matjeshering','Alejandra Camino',10,177.87,254.10,76.23,'ES','UK'),
	 ('2024-05-29','Store XYZ','MEAT/POULTRY','Perth Pasties','Alejandra Camino',10,220.22,314.60,94.38,'ES','UK'),
	 ('2023-02-06','Store XYZ','MEAT/POULTRY','Tourtire','Alejandra Camino',5,21.78,36.30,14.52,'ES','UK'),
	 ('2023-08-05','Store JKL','CONFECTIONS','Pavlova','Carine Schmitt',10,143.99,205.70,61.71,'FR','UK'),
	 ('2023-09-05','Store JKL','CONFECTIONS','Tarte au sucre','Carine Schmitt',10,415.03,592.90,177.87,'FR','UK'),
	 ('2023-01-27','Store JKL','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Carine Schmitt',12,254.10,304.92,50.82,'FR','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-11-18','Store QWE','BEVERAGES','Cite de Blaye','Christina Berglund',15,3194.40,4791.60,1597.20,'SE','TH'),
	 ('2024-06-11','Store QWE','DAIRY PRODUCTS','Flotemysost','Christina Berglund',12,266.20,319.44,53.24,'SE','PY'),
	 ('2024-01-11','Store QWE','CONFECTIONS','Tarte au sucre','Fran Wilson',10,330.33,471.90,141.57,'US','PT'),
	 ('2023-11-09','Store QWE','CONFECTIONS','Scottish Longbreads','Fran Wilson',3,24.20,36.30,12.10,'US','PT'),
	 ('2024-06-19','Store XYZ','CONFECTIONS','Pavlova','Matti Karttunen',3,41.14,61.71,20.57,'FI','TH'),
	 ('2024-04-17','Store XYZ','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Matti Karttunen',6,50.82,101.64,50.82,'FI','PT'),
	 ('2024-10-05','Store XYZ','BEVERAGES','Ipoh Coffee','Matti Karttunen',6,166.98,333.96,166.98,'FI','TH'),
	 ('2023-10-19','Store XYZ','GRAINS/CEREALS','Tunnbred','Helen Bennett',5,32.67,54.45,21.78,'GB','PT'),
	 ('2024-10-20','Store XYZ','BEVERAGES','Outback Lager','Ana Trujillo',5,43.56,72.60,29.04,'MX','PT'),
	 ('2023-10-08','Store ABC','MEAT/POULTRY','Perth Pasties','Peter Franken',10,279.51,399.30,119.79,'DE','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-06-04','Store QWE','DAIRY PRODUCTS','Flotemysost','Patricia McKenna',3,41.14,61.71,20.57,'US','TH'),
	 ('2024-10-02','Store XYZ','CONFECTIONS','Pavlova','Liz Nixon',10,118.58,169.40,50.82,'US','TH'),
	 ('2022-12-12','Store XYZ','CONFECTIONS','Tarte au sucre','Liz Nixon',5,141.57,235.95,94.38,'US','IN'),
	 ('2024-03-07','Store XYZ','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Janine Labrune',6,39.93,79.86,39.93,'FR','PT'),
	 ('2024-02-12','Store XYZ','DAIRY PRODUCTS','Gudbrandsdalsost','Janine Labrune',7,175.45,245.63,70.18,'FR','TH'),
	 ('2024-03-23','Store XYZ','CONFECTIONS','Teatime Chocolate Biscuits','Miguel Angel Paolino',7,54.45,76.23,21.78,'AR','PT'),
	 ('2023-06-07','Store XYZ','DAIRY PRODUCTS','Geitost','Antonio Moreno',8,18.15,29.04,10.89,'ES','UK'),
	 ('2024-03-01','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Frederique Citeaux',12,665.50,798.60,133.10,'FR','HK'),
	 ('2023-03-06','Store QWE','PRODUCE','Russle Sauerkraut','Rita Muller',4,87.12,174.24,87.12,'DE','TH'),
	 ('2024-09-28','Store QWE','BEVERAGES','Rhinbru Klosterbier','Rita Muller',10,50.82,72.60,21.78,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-10-18','Store QWE','SEAFOOD','Inlagd Sill','Horst Kloss',12,181.50,217.80,36.30,'DE','PT'),
	 ('2024-11-14','Store JKL','CONFECTIONS','Sir Rodney','Howard Snyder',12,121.00,145.20,24.20,'US','IN'),
	 ('2024-05-11','Store XYZ','CONDIMENTS','Louisiana Hot Spiced Okra','Antonio Moreno',4,41.14,82.28,41.14,'ES','PT'),
	 ('2024-08-31','Store XYZ','GRAINS/CEREALS','Filo Mix','Janine Labrune',9,59.29,76.23,16.94,'FR','TH'),
	 ('2024-05-24','Store XYZ','BEVERAGES','Sasquatch Ale','Helen Bennett',14,133.10,186.34,53.24,'GB','TH'),
	 ('2023-03-30','Store RTY','SEAFOOD','Jack''s New England Clam Chowder','Paula Wilson',10,67.76,96.80,29.04,'US','TH'),
	 ('2024-06-21','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Andresa Fonseca',4,24.20,48.40,24.20,'BR','PT'),
	 ('2024-08-14','Store QWE','CONFECTIONS','Zaanse koeken','Andresa Fonseca',15,121.00,181.50,60.50,'BR','PT'),
	 ('2024-04-05','Store JKL','CONFECTIONS','Gumber Gummibrchen','Georg Pipps',15,375.10,562.65,187.55,'AT','HK'),
	 ('2023-08-09','Store QWE','MEAT/POULTRY','Thringer Rostbratwurst','Patricia McKenna',10,1050.28,1500.40,450.12,'US','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-10-03','Store QWE','SEAFOOD','Inlagd Sill','Patricia McKenna',6,68.97,137.94,68.97,'US','TH'),
	 ('2022-12-17','Store ABC','BEVERAGES','Sasquatch Ale','Palle Ibsen',14,169.40,237.16,67.76,'DK','PT'),
	 ('2024-06-13','Store XYZ','BEVERAGES','Lakkalikri','Helen Bennett',6,50.82,101.64,50.82,'GB','IN'),
	 ('2024-04-29','Store XYZ','MEAT/POULTRY','Alice Mutton','Miguel Angel Paolino',8,187.55,300.08,112.53,'AR','PT'),
	 ('2024-04-17','Store XYZ','PRODUCE','Russle Sauerkraut','Miguel Angel Paolino',14,435.60,609.84,174.24,'AR','PT'),
	 ('2023-08-28','Store XYZ','BEVERAGES','Steeleye Stout','Helen Bennett',10,118.58,169.40,50.82,'GB','TH'),
	 ('2024-04-04','Store QWE','MEAT/POULTRY','Mishi Kobe Niku','Karl Jablonski',6,352.11,704.22,352.11,'PL','IN'),
	 ('2024-02-19','Store QWE','SEAFOOD','Rid Kaviar','Karl Jablonski',15,181.50,272.25,90.75,'PL','PT'),
	 ('2024-06-06','Store XYZ','CONDIMENTS','Northwoods Cranberry Sauce','Matti Karttunen',10,338.80,484.00,145.20,'FI','TH'),
	 ('2023-12-23','Store XYZ','DAIRY PRODUCTS','Queso Manchego La Pastora','Matti Karttunen',4,91.96,183.92,91.96,'FI','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-11-12','Store RTY','CONDIMENTS','Genen Shouyu','Philip Cramer',5,43.56,72.60,29.04,'US','TH'),
	 ('2023-04-17','Store RTY','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Philip Cramer',4,26.62,53.24,26.62,'US','PY'),
	 ('2024-04-24','Store RTY','BEVERAGES','Chartreuse verte','Philip Cramer',4,33.88,67.76,33.88,'US','TH'),
	 ('2023-02-15','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Felipe Izquierdo',7,54.45,76.23,21.78,'ES','UK'),
	 ('2022-12-13','Store QWE','BEVERAGES','Steeleye Stout','Felipe Izquierdo',9,152.46,196.02,43.56,'ES','UK'),
	 ('2023-09-01','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Roland Mendel',15,254.10,381.15,127.05,'DE','PT'),
	 ('2022-12-09','Store XYZ','MEAT/POULTRY','Alice Mutton','Roland Mendel',8,235.95,377.52,141.57,'DE','TH'),
	 ('2023-09-26','Store XYZ','MEAT/POULTRY','Thringer Rostbratwurst','Roland Mendel',12,1500.40,1800.48,300.08,'DE','PT'),
	 ('2023-03-09','Store XYZ','BEVERAGES','Outback Lager','Roland Mendel',8,90.75,145.20,54.45,'DE','HK'),
	 ('2024-11-08','Store JKL','CONFECTIONS','Zaanse koeken','Alexander Feuer',12,121.00,145.20,24.20,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-09-05','Store RTY','CONDIMENTS','Grandma','Philip Cramer',6,72.60,145.20,72.60,'US','TH'),
	 ('2023-07-08','Store RTY','SEAFOOD','Konbu','Philip Cramer',12,60.50,72.60,12.10,'US','PY'),
	 ('2024-08-10','Store RTY','PRODUCE','Tofu','Philip Cramer',9,160.93,206.91,45.98,'US','TH'),
	 ('2023-08-23','Store RTY','DAIRY PRODUCTS','Gorgonzola Telino','Philip Cramer',4,24.20,48.40,24.20,'US','PT'),
	 ('2024-10-26','Store QWE','SEAFOOD','Chai','Jose Pavarotti',5,65.34,108.90,43.56,'IT','TH'),
	 ('2024-02-27','Store QWE','BEVERAGES','Sasquatch Ale','Jose Pavarotti',12,169.40,203.28,33.88,'IT','TH'),
	 ('2023-04-12','New England','GRAINS/CEREALS','Ravioli Angelo','Martin Sommer',16,193.60,309.76,116.16,'DE','TH'),
	 ('2023-01-23','Store QWE','CONDIMENTS','Aniseed Syrup','Maria Anders s',6,36.30,72.60,36.30,'DE','PT'),
	 ('2023-01-09','Store QWE','BEVERAGES','Lakkalikri','Maria Anders s',15,217.80,326.70,108.90,'DE','PT'),
	 ('2022-11-29','Store QWE','BEVERAGES','Chang 555','Maria Larsson',5,68.97,114.95,45.98,'SE','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-03-07','Store XYZ','CONDIMENTS','Chef Anton''s Cajun Seasoning','Lucia Carvalho',6,79.86,159.72,79.86,'BR','PT'),
	 ('2023-05-18','Store JKL','DAIRY PRODUCTS','Raclette Courdavault','Lino Rodriguez',9,372.68,479.16,106.48,'ES','PT'),
	 ('2023-12-02','Store JKL','CONFECTIONS','Scottish Longbreads','Lino Rodriguez',10,84.70,121.00,36.30,'ES','UK'),
	 ('2023-11-07','Store JKL','DAIRY PRODUCTS','Mascarpone Fabioli','Carlos Hernandez',4,77.44,154.88,77.44,'MX','IN'),
	 ('2024-02-07','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Art Braunschweiger',10,59.29,84.70,25.41,'DE','TH'),
	 ('2024-05-04','Store QWE','SEAFOOD','Nord-Ost Matjeshering','Art Braunschweiger',8,127.05,203.28,76.23,'DE','PT'),
	 ('2023-04-01','Store QWE','GRAINS/CEREALS','Gnocchi di nonna Alice','Art Braunschweiger',12,363.00,435.60,72.60,'DE','PT'),
	 ('2023-07-06','Store JKL','DAIRY PRODUCTS','Raclette Courdavault','Rene Phillips',8,332.75,532.40,199.65,'US','TH'),
	 ('2024-04-03','Store QWE','MEAT/POULTRY','Tourtire','Laurence Lebihan',15,72.60,108.90,36.30,'FR','HK'),
	 ('2024-07-18','Store XYZ','CONDIMENTS','Chef Anton''s Gumbo Mix','Liz Nixon',4,50.82,101.64,50.82,'US','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-07-24','Store XYZ','SEAFOOD','Inlagd Sill','Liz Nixon',5,68.97,114.95,45.98,'US','PT'),
	 ('2023-09-01','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Andresa Fonseca',10,287.98,411.40,123.42,'BR','IN'),
	 ('2023-10-10','Store QWE','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Jean Fresniere',10,93.17,133.10,39.93,'CA','UK'),
	 ('2023-06-28','Store QWE','CONFECTIONS','Zaanse koeken','Jean Fresniere',16,96.80,154.88,58.08,'CA','TH'),
	 ('2023-07-26','Store XYZ','PRODUCE','Tofu','Pirkko Koskitalo',10,160.93,229.90,68.97,'FI','TH'),
	 ('2024-10-04','Store XYZ','CONFECTIONS','Sir Rodney','Pirkko Koskitalo',10,67.76,96.80,29.04,'FI','PT'),
	 ('2024-05-10','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Paolo Accorti',5,32.67,54.45,21.78,'IT','PT'),
	 ('2023-05-27','Store QWE','CONFECTIONS','Zaanse koeken','Paolo Accorti',5,36.30,60.50,24.20,'IT','TH'),
	 ('2023-08-11','Store ABC','CONFECTIONS','Scottish Longbreads','Mary Saveley',10,84.70,121.00,36.30,'US','TH'),
	 ('2024-05-09','Store QWE','CONFECTIONS','Teatime Chocolate Biscuits','Jose Pavarotti',12,108.90,130.68,21.78,'IT','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-05','Store QWE','MEAT/POULTRY','Perth Pasties','Patricia McKenna',3,79.86,119.79,39.93,'US','PT'),
	 ('2023-01-09','Store ABC','GRAINS/CEREALS','Filo Mix','Mary Saveley',8,36.30,58.08,21.78,'US','TH'),
	 ('2024-06-23','Store QWE','BEVERAGES','Chang 555','Patricia McKenna',7,90.75,127.05,36.30,'US','TH'),
	 ('2023-11-20','Store QWE','DAIRY PRODUCTS','Mascarpone Fabioli','Patricia McKenna',6,94.38,188.76,94.38,'US','PT'),
	 ('2024-07-21','Store QWE','SEAFOOD','Escargots de Bourgogne','Jose Pavarotti',12,157.30,188.76,31.46,'IT','PT'),
	 ('2023-01-23','Store ABC','CONFECTIONS','Sir Rodney','Sergio Gutierrez',5,36.30,60.50,24.20,'AR','UK'),
	 ('2023-12-24','Store ABC','PRODUCE','Manjimup Dried Apples','Sergio Gutierrez',7,320.65,448.91,128.26,'AR','PT'),
	 ('2023-11-02','Store ABC','CONDIMENTS','Sirop d''rable','Sergio Gutierrez',10,245.63,350.90,105.27,'AR','TH'),
	 ('2024-06-24','Store ABC','MEAT/POULTRY','Tourtire','Peter Franken',15,84.70,127.05,42.35,'DE','TH'),
	 ('2023-05-27','Store JKL','SEAFOOD','Nord-Ost Matjeshering','Rene Phillips',15,254.10,381.15,127.05,'US','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-01-06','Store QWE','SEAFOOD','Carnarvon Tigers','Jaime Yorres',12,762.30,914.76,152.46,'ES','PT'),
	 ('2023-12-22','Store QWE','SEAFOOD','Nord-Ost Matjeshering','Jaime Yorres',3,62.92,94.38,31.46,'ES','UK'),
	 ('2024-07-01','Store QWE','CONDIMENTS','Chef Anton''s Cajun Seasoning','Jean Fresniere',10,152.46,217.80,65.34,'CA','UK'),
	 ('2023-04-08','Store ABC','DAIRY PRODUCTS','Flotemysost','Bernardo Batista',8,133.10,212.96,79.86,'BR','PT'),
	 ('2024-01-15','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Laurence Lebihan',12,96.80,116.16,19.36,'FR','PY'),
	 ('2023-02-11','Store QWE','DAIRY PRODUCTS','Geitost','Jytte Petersen',8,1210.00,19.36,1190.64,'DK','HK'),
	 ('2023-07-31','Store QWE','DAIRY PRODUCTS','Raclette Courdavault','Jytte Petersen',9,372.68,479.16,106.48,'DK','UK'),
	 ('2024-09-03','Store QWE','BEVERAGES','Chang 555','Jose Pavarotti',3,45.98,68.97,22.99,'IT','TH'),
	 ('2023-08-02','Store QWE','CONFECTIONS','Gumber Gummibrchen','Karl Jablonski',15,375.10,562.65,187.55,'PL','HK'),
	 ('2023-03-24','Store QWE','SEAFOOD','Ikura','Jean Fresniere',16,375.10,600.16,225.06,'CA','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-08-13','Store QWE','CONDIMENTS','Sirop d''rable','Jean Fresniere',5,105.27,175.45,70.18,'CA','IN'),
	 ('2023-05-17','Store JKL','CONFECTIONS','Scottish Longbreads','Renate Messner',4,24.20,48.40,24.20,'DE','PT'),
	 ('2024-04-02','Store JKL','BEVERAGES','Lakkalikri','Renate Messner',15,169.40,254.10,84.70,'DE','PT'),
	 ('2023-08-27','Store JKL','SEAFOOD','Jack''s New England Clam Chowder','Aria Cruz',12,121.00,145.20,24.20,'US','TH'),
	 ('2023-02-20','Store JKL','GRAINS/CEREALS','Filo Mix','Aria Cruz',4,16.94,33.88,16.94,'US','HK'),
	 ('2023-03-17','Store JKL','MEAT/POULTRY','Piti chinois','Aria Cruz',6,87.12,174.24,87.12,'US','PT'),
	 ('2023-01-22','Store ABC','DAIRY PRODUCTS','Queso Cabrales','Ann Devon',5,76.23,127.05,50.82,'US','TH'),
	 ('2024-08-10','Store QWE','GRAINS/CEREALS','Gnocchi di nonna Alice','Maurizio Moroni',10,321.86,459.80,137.94,'IT','TH'),
	 ('2024-08-19','Store QWE','DAIRY PRODUCTS','Raclette Courdavault','Maurizio Moroni',10,465.85,665.50,199.65,'IT','HK'),
	 ('2023-01-29','Store QWE','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Horst Kloss',9,93.17,119.79,26.62,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-06-17','Store XYZ','SEAFOOD','Nord-Ost Matjeshering','Lucia Carvalho',15,314.60,471.90,157.30,'BR','PT'),
	 ('2023-09-08','Store XYZ','SEAFOOD','Boston Crab Meat','Lucia Carvalho',6,65.34,130.68,65.34,'BR','PT'),
	 ('2023-01-09','Store XYZ','MEAT/POULTRY','Piti chinois','Lucia Carvalho',12,290.40,348.48,58.08,'BR','PT'),
	 ('2024-03-18','Store XYZ','DAIRY PRODUCTS','Camembert Pierrot','Lucia Carvalho',15,411.40,617.10,205.70,'BR','PT'),
	 ('2024-04-15','Store QWE','CONFECTIONS','Pavlova','Laurence Lebihan',15,205.70,308.55,102.85,'FR','IN'),
	 ('2024-08-23','Store QWE','DAIRY PRODUCTS','Gorgonzola Telino','Laurence Lebihan',3,31.46,47.19,15.73,'FR','PT'),
	 ('2023-03-22','Store QWE','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Laurence Lebihan',10,177.87,254.10,76.23,'FR','PY'),
	 ('2023-02-20','Store JKL','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Aria Cruz',10,93.17,133.10,39.93,'US','PT'),
	 ('2022-11-28','Store JKL','SEAFOOD','Boston Crab Meat','Aria Cruz',4,36.30,72.60,36.30,'US','PT'),
	 ('2024-08-04','Store JKL','BEVERAGES','Rhinbru Klosterbier','Aria Cruz',6,21.78,43.56,21.78,'US','UK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-07-10','Store QWE','SEAFOOD','Chai','Rita Muller',15,169.40,254.10,84.70,'DE','TH'),
	 ('2023-02-24','Store QWE','PRODUCE','Tofu','Christina Berglund',16,278.30,445.28,166.98,'SE','TH'),
	 ('2023-12-16','Store QWE','SEAFOOD','Nord-Ost Matjeshering','Andresa Fonseca',15,314.60,471.90,157.30,'BR','PT'),
	 ('2023-10-09','Store XYZ','CONFECTIONS','Valkoinen suklaa','Annette Roulet',15,157.30,235.95,78.65,'FR','PY'),
	 ('2024-01-19','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Roland Mendel',13,96.80,125.84,29.04,'DE','PT'),
	 ('2024-02-15','Store XYZ','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Roland Mendel',10,143.99,205.70,61.71,'DE','PT'),
	 ('2024-03-23','Store RTY','SEAFOOD','Konbu','Paul Henriot',4,14.52,29.04,14.52,'FR','HK'),
	 ('2023-03-29','Store RTY','SEAFOOD','Jack''s New England Clam Chowder','Paul Henriot',12,121.00,145.20,24.20,'FR','HK'),
	 ('2023-08-29','Store JKL','BEVERAGES','Guarana Fantastica','Lino Rodriguez',10,33.88,48.40,14.52,'ES','PT'),
	 ('2024-01-03','New England','CONFECTIONS','Pavlova','Dominique Perrier',3,41.14,61.71,20.57,'FR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-11-17','Store RTY','SEAFOOD','Inlagd Sill','Paul Henriot',6,68.97,137.94,68.97,'FR','PY'),
	 ('2024-04-22','Store JKL','DAIRY PRODUCTS','Queso Cabrales','Georg Pipps',12,205.70,246.84,41.14,'AT','UK'),
	 ('2022-12-18','Store QWE','PRODUCE','Russle Sauerkraut','Karl Jablonski',5,166.98,278.30,111.32,'PL','PT'),
	 ('2023-12-31','Store QWE','GRAINS/CEREALS','Gnocchi di nonna Alice','Karl Jablonski',14,459.80,643.72,183.92,'PL','UK'),
	 ('2023-12-20','Store JKL','SEAFOOD','Chai','Guillermo Fernandez',12,169.40,203.28,33.88,'AR','PY'),
	 ('2024-04-26','Store JKL','MEAT/POULTRY','Thringer Rostbratwurst','Guillermo Fernandez',4,239.58,479.16,239.58,'AR','TH'),
	 ('2023-05-18','Store XYZ','BEVERAGES','Chang 555','Thomas Hardy',15,229.90,344.85,114.95,'GB','PT'),
	 ('2024-04-19','Store QWE','MEAT/POULTRY','Piti chinois','Rita Muller',12,229.90,275.88,45.98,'DE','PT'),
	 ('2023-04-05','Store QWE','CONDIMENTS','Gula Malacca','Horst Kloss',16,229.90,367.84,137.94,'DE','IN'),
	 ('2023-12-02','Store QWE','DAIRY PRODUCTS','Mozzarella di Giovanni','Horst Kloss',7,211.75,296.45,84.70,'DE','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-04-06','Store QWE','CONFECTIONS','Gumber Gummibrchen','Carlos Gonzalez',16,302.50,484.00,181.50,'ES','UK'),
	 ('2024-10-07','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Carlos Gonzalez',8,163.35,261.36,98.01,'ES','UK'),
	 ('2024-03-17','Store RTY','SEAFOOD','Konbu','Yang Wang',6,21.78,43.56,21.78,'CN','TH'),
	 ('2024-02-06','Store RTY','CONFECTIONS','Tarte au sucre','Yang Wang',9,415.03,533.61,118.58,'CN','TH'),
	 ('2022-12-03','Store JKL','DAIRY PRODUCTS','Gorgonzola Telino','Georg Pipps',8,78.65,125.84,47.19,'AT','IN'),
	 ('2023-04-19','Store JKL','CONDIMENTS','Vegie-spread','Georg Pipps',9,372.68,479.16,106.48,'AT','TH'),
	 ('2024-04-18','Store XYZ','BEVERAGES','Guarana Fantastica','Annette Roulet',10,33.88,48.40,14.52,'FR','HK'),
	 ('2023-11-04','Store XYZ','BEVERAGES','Sasquatch Ale','Annette Roulet',10,93.17,133.10,39.93,'FR','PY'),
	 ('2023-01-23','Store XYZ','GRAINS/CEREALS','Gnocchi di nonna Alice','Helen Bennett',15,459.80,689.70,229.90,'GB','TH'),
	 ('2023-06-29','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Helen Bennett',6,199.65,399.30,199.65,'GB','HK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-10-03','Store XYZ','BEVERAGES','Lakkalikri','Helen Bennett',10,152.46,217.80,65.34,'GB','PT'),
	 ('2024-09-12','Store XYZ','PRODUCE','Tofu','Pirkko Koskitalo',5,83.49,139.15,55.66,'FI','TH'),
	 ('2023-04-09','Store XYZ','BEVERAGES','Cite de Blaye','Frederique Citeaux',10,1787.17,2553.10,765.93,'FR','TH'),
	 ('2024-10-04','New England','CONFECTIONS','Gumber Gummibrchen','Michael Holz',12,375.10,450.12,75.02,'DE','IN'),
	 ('2024-02-04','New England','SEAFOOD','Rid Kaviar','Michael Holz',15,181.50,272.25,90.75,'DE','PT'),
	 ('2024-09-02','Store XYZ','SEAFOOD','Chai','Simon Crowther',8,108.90,174.24,65.34,'GB','TH'),
	 ('2023-01-26','Store XYZ','DAIRY PRODUCTS','Gudbrandsdalsost','Simon Crowther',3,87.12,130.68,43.56,'GB','PY'),
	 ('2023-08-07','Store QWE','SEAFOOD','Rogede sild','Paolo Accorti',4,24.20,48.40,24.20,'IT','TH'),
	 ('2023-07-07','Store QWE','PRODUCE','Longlife Tofu','Paolo Accorti',5,36.30,60.50,24.20,'IT','IN'),
	 ('2024-07-29','Store XYZ','SEAFOOD','Boston Crab Meat','Giovanni Rovelli',3,43.56,65.34,21.78,'IT','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-02-10','Store ABC','BEVERAGES','Rhinbru Klosterbier','Sven Ottlieb',12,72.60,87.12,14.52,'DE','PT'),
	 ('2023-01-09','Store ABC','BEVERAGES','Lakkalikri','Sven Ottlieb',12,169.40,203.28,33.88,'DE','PT'),
	 ('2023-09-26','Store ABC','DAIRY PRODUCTS','Flotemysost','Ann Devon',5,61.71,102.85,41.14,'US','TH'),
	 ('2023-07-02','Store QWE','GRAINS/CEREALS','Ravioli Angelo','Laurence Lebihan',14,242.00,338.80,96.80,'FR','TH'),
	 ('2023-01-26','Store QWE','CONFECTIONS','Scottish Longbreads','Art Braunschweiger',6,47.19,94.38,47.19,'DE','PT'),
	 ('2023-07-15','Store QWE','DAIRY PRODUCTS','Raclette Courdavault','Jose Pavarotti',7,332.75,465.85,133.10,'IT','IN'),
	 ('2024-10-01','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Palle Ibsen',7,60.50,84.70,24.20,'DK','IN'),
	 ('2023-11-22','Store QWE','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Eduardo Saavedra',5,61.71,102.85,41.14,'ES','UK'),
	 ('2024-06-25','Store QWE','CONDIMENTS','Original Frankfurter grine Sode','Eduardo Saavedra',5,36.30,60.50,24.20,'ES','PT'),
	 ('2024-06-22','Store ABC','CONDIMENTS','Louisiana Fiery Hot Pepper Sauce','Palle Ibsen',15,205.70,308.55,102.85,'DK','PY');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-06-05','Store XYZ','DAIRY PRODUCTS','Mascarpone Fabioli','Ana Trujillo',10,271.04,387.20,116.16,'MX','PT'),
	 ('2023-02-02','Store XYZ','CONFECTIONS','Sir Rodney','Roland Mendel',5,29.04,48.40,19.36,'DE','PT'),
	 ('2023-02-23','Store XYZ','PRODUCE','Russle Sauerkraut','Roland Mendel',13,435.60,566.28,130.68,'DE','TH'),
	 ('2024-10-15','Store ABC','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Catherine Dewey',12,169.40,203.28,33.88,'US','TH'),
	 ('2024-07-31','Store QWE','BEVERAGES','Chartreuse verte','Maria Larsson',16,217.80,348.48,130.68,'SE','PT'),
	 ('2023-12-24','Store RTY','SEAFOOD','Chai','Yang Wang',15,169.40,254.10,84.70,'CN','TH'),
	 ('2024-01-26','Store XYZ','SEAFOOD','Inlagd Sill','Annette Roulet',6,54.45,108.90,54.45,'FR','HK'),
	 ('2024-07-14','Store RTY','GRAINS/CEREALS','Gustaf','Martine Rance',6,76.23,152.46,76.23,'SN','IN'),
	 ('2024-06-07','Store XYZ','CONFECTIONS','Sir Rodney','Lucia Carvalho',12,786.50,943.80,157.30,'BR','PT'),
	 ('2023-10-10','Store QWE','SEAFOOD','Escargots de Bourgogne','Zbyszek  Piestrzeniewicz',15,133.10,199.65,66.55,'','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-08-19','Store XYZ','PRODUCE','Tofu','Yoshi Latimer',15,229.90,344.85,114.95,'JP','PT'),
	 ('2024-07-06','Store XYZ','MEAT/POULTRY','Tourtire','Yoshi Latimer',10,50.82,72.60,21.78,'JP','IN'),
	 ('2023-05-24','Store XYZ','GRAINS/CEREALS','Gustaf','Thomas Hardy',4,50.82,101.64,50.82,'GB','TH'),
	 ('2023-11-16','Store XYZ','DAIRY PRODUCTS','Camembert Pierrot','Thomas Hardy',15,411.40,617.10,205.70,'GB','PT'),
	 ('2024-06-17','Store XYZ','DAIRY PRODUCTS','Flotemysost','Thomas Hardy',12,266.20,319.44,53.24,'GB','TH'),
	 ('2023-03-19','Store ABC','GRAINS/CEREALS','Filo Mix','Palle Ibsen',15,84.70,127.05,42.35,'DK','TH'),
	 ('2023-03-02','Store ABC','CONFECTIONS','Tarte au sucre','Palle Ibsen',15,592.90,889.35,296.45,'DK','PT'),
	 ('2023-09-13','Store XYZ','DAIRY PRODUCTS','Queso Cabrales','Mario Pontes',15,254.10,381.15,127.05,'BR','PT'),
	 ('2023-03-25','Store QWE','DAIRY PRODUCTS','Flotemysost','Maria Larsson',6,61.71,123.42,61.71,'SE','TH'),
	 ('2022-12-04','Store XYZ','DAIRY PRODUCTS','Flotemysost','Roland Mendel',16,266.20,425.92,159.72,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-03-25','Store ABC','SEAFOOD','Jack''s New England Clam Chowder','Bernardo Batista',8,48.40,77.44,29.04,'BR','PT'),
	 ('2024-08-16','Store ABC','CONDIMENTS','Vegie-spread','Bernardo Batista',16,423.50,677.60,254.10,'BR','PT'),
	 ('2024-11-17','Store XYZ','BEVERAGES','Rhinbru Klosterbier','Roland Mendel',7,48.40,67.76,19.36,'DE','PT'),
	 ('2024-07-22','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Patricia McKenna',6,98.01,196.02,98.01,'US','PT'),
	 ('2023-08-31','Store QWE','PRODUCE','Longlife Tofu','Carlos Gonzalez',14,96.80,135.52,38.72,'ES','UK'),
	 ('2024-09-10','Store QWE','SEAFOOD','Ikura','Liu Wong',6,112.53,225.06,112.53,'CN','PT'),
	 ('2023-08-27','Store QWE','BEVERAGES','Laughing Lumberjack Lager','Liu Wong',3,33.88,50.82,16.94,'CN','UK'),
	 ('2024-01-31','Store XYZ','SEAFOOD','Carnarvon Tigers','Roland Mendel',9,423.50,544.50,121.00,'DE','TH'),
	 ('2024-11-05','Store XYZ','MEAT/POULTRY','Thringer Rostbratwurst','Roland Mendel',14,1197.90,1677.06,479.16,'DE','HK'),
	 ('2024-07-10','Store XYZ','DAIRY PRODUCTS','Gorgonzola Telino','Roland Mendel',16,157.30,251.68,94.38,'DE','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-11-26','Store XYZ','GRAINS/CEREALS','Singaporean Hokkien Fried Mee','Roland Mendel',12,169.40,203.28,33.88,'DE','TH'),
	 ('2024-03-26','Store QWE','SEAFOOD','Jack''s New England Clam Chowder','Christina Berglund',10,84.70,121.00,36.30,'SE','TH'),
	 ('2024-03-24','Store QWE','CONDIMENTS','Original Frankfurter grine Sode','Carlos Gonzalez',15,157.30,235.95,78.65,'ES','PY'),
	 ('2023-07-25','Store XYZ','CONFECTIONS','Valkoinen suklaa','Thomas Hardy',15,157.30,235.95,78.65,'GB','HK'),
	 ('2024-08-05','Store QWE','DAIRY PRODUCTS','Camembert Pierrot','Christina Berglund',15,326.70,490.05,163.35,'SE','PT'),
	 ('2024-07-17','Store XYZ','MEAT/POULTRY','Tourtire','Pirkko Koskitalo',3,16.94,25.41,8.47,'FI','TH'),
	 ('2023-04-04','Store QWE','PRODUCE','Uncle Bob','Art Braunschweiger',10,203.28,290.40,87.12,'DE','TH'),
	 ('2024-06-10','Store QWE','CONFECTIONS','Scottish Longbreads','Art Braunschweiger',8,60.50,96.80,36.30,'DE','TH'),
	 ('2024-05-01','Store XYZ','DAIRY PRODUCTS','Gorgonzola Telino','Mario Pontes',10,110.11,157.30,47.19,'BR','PT'),
	 ('2023-07-18','Store XYZ','BEVERAGES','Cite de Blaye','Mario Pontes',5,958.32,1597.20,638.88,'BR','PT');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2023-08-10','Store QWE','SEAFOOD','Ikura','Manuel Pereira',10,262.57,375.10,112.53,'BR','TH'),
	 ('2022-12-21','Store QWE','BEVERAGES','Rhinbru Klosterbier','Manuel Pereira',10,67.76,96.80,29.04,'BR','UK'),
	 ('2024-02-17','Store JKL','BEVERAGES','Guarana Fantastica','Aria Cruz',15,48.40,72.60,24.20,'US','PY'),
	 ('2024-02-06','Store JKL','BEVERAGES','Sasquatch Ale','Aria Cruz',10,93.17,133.10,39.93,'US','HK'),
	 ('2023-11-29','Store XYZ','BEVERAGES','Guarana Fantastica','Jonas Bergulfsen',15,48.40,72.60,24.20,'NO','HK'),
	 ('2022-12-15','Store XYZ','PRODUCE','Russle Sauerkraut','Jonas Bergulfsen',6,130.68,261.36,130.68,'NO','PT'),
	 ('2024-08-20','Store XYZ','DAIRY PRODUCTS','Raclette Courdavault','Jonas Bergulfsen',12,532.40,638.88,106.48,'NO','TH'),
	 ('2023-10-09','Store XYZ','DAIRY PRODUCTS','Flotemysost','Jonas Bergulfsen',15,205.70,308.55,102.85,'NO','UK'),
	 ('2024-09-09','Store XYZ','SEAFOOD','Nord-Ost Matjeshering','Lucia Carvalho',15,314.60,471.90,157.30,'BR','PT'),
	 ('2023-02-03','Store XYZ','BEVERAGES','Chang 555','Annette Roulet',15,229.90,344.85,114.95,'FR','HK');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-04-21','Store XYZ','SEAFOOD','Rogede sild','Hari Kumar',15,96.80,145.20,48.40,'US','TH'),
	 ('2024-04-24','Store JKL','SEAFOOD','Ikura','Elizabeth Lincoln',16,302.50,484.00,181.50,'US','TH'),
	 ('2024-01-21','Store JKL','MEAT/POULTRY','Piti chinois','Elizabeth Lincoln',15,229.90,344.85,114.95,'US','HK'),
	 ('2024-01-07','Store RTY','BEVERAGES','Steeleye Stout','Martine Rance',15,217.80,326.70,108.90,'SN','UK'),
	 ('2022-12-01','Store QWE','PRODUCE','Uncle Bob','Andresa Fonseca',3,72.60,108.90,36.30,'BR','PT'),
	 ('2023-12-14','Store ABC','MEAT/POULTRY','Thringer Rostbratwurst','Peter Franken',14,1500.40,2100.56,600.16,'DE','IN'),
	 ('2024-04-26','Store QWE','BEVERAGES','Chang 555','Zbyszek  Piestrzeniewicz',10,160.93,229.90,68.97,'','PT'),
	 ('2023-01-23','Store QWE','MEAT/POULTRY','Tourtire','Zbyszek  Piestrzeniewicz',3,16.94,25.41,8.47,'','PT'),
	 ('2023-10-10','Store QWE','CONFECTIONS','Scottish Longbreads','Zbyszek  Piestrzeniewicz',15,157.30,235.95,78.65,'','UK'),
	 ('2024-07-11','Store XYZ','SEAFOOD','Jack''s New England Clam Chowder','Thomas Hardy',14,121.00,169.40,48.40,'GB','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-05-26','Store XYZ','GRAINS/CEREALS','Filo Mix','Thomas Hardy',8,42.35,67.76,25.41,'GB','TH'),
	 ('2022-12-05','Store ABC','PRODUCE','Tofu','Bernardo Batista',15,278.30,417.45,139.15,'BR','PT'),
	 ('2023-04-01','Store ABC','MEAT/POULTRY','Tourtire','Bernardo Batista',6,25.41,50.82,25.41,'BR','PT'),
	 ('2024-01-28','Store JKL','CONDIMENTS','Gula Malacca','Carlos Hernandez',10,160.93,229.90,68.97,'MX','PY'),
	 ('2024-08-15','Store QWE','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Jose Pavarotti',7,66.55,93.17,26.62,'IT','TH'),
	 ('2023-04-08','Store XYZ','SEAFOOD','Konbu','Yoshi Latimer',10,42.35,60.50,18.15,'JP','PT'),
	 ('2024-06-24','Store XYZ','CONFECTIONS','Tarte au sucre','Yoshi Latimer',10,330.33,471.90,141.57,'JP','IN'),
	 ('2023-11-04','Store XYZ','DAIRY PRODUCTS','Mozzarella di Giovanni','Helen Bennett',10,296.45,423.50,127.05,'GB','TH'),
	 ('2024-07-22','Store XYZ','PRODUCE','Manjimup Dried Apples','Hari Kumar',10,448.91,641.30,192.39,'US','PT'),
	 ('2024-11-03','Store XYZ','MEAT/POULTRY','Tourtire','Hari Kumar',7,42.35,59.29,16.94,'US','TH');
INSERT INTO `sales2` (`date`,store,product_category,product,customer_name,qtysold,cost,sales,profit,country,ship_from) VALUES
	 ('2024-05-04','Store JKL','DAIRY PRODUCTS','Gudbrandsdalsost','Carlos Hernandez',8,175.45,280.72,105.27,'MX','PT'),
	 ('2024-11-12','Store QWE','CONFECTIONS','Sir Rodney','Isabel de Castro',10,67.76,96.80,29.04,'BR','UK'),
	 ('2023-10-08','Store QWE','CONFECTIONS','Tarte au sucre','Jytte Petersen',5,177.87,296.45,118.58,'DK','PT'),
	 ('2024-04-07','Store JKL','CONFECTIONS','NuNuCa Nu-Nougat-Creme','Paula Parente',15,169.40,254.10,84.70,'AO','PT'),
	 ('2024-09-01','Store JKL','DAIRY PRODUCTS','Raclette Courdavault','Paula Parente',15,665.50,998.25,332.75,'AO','PT'),
	 ('2024-06-08','Store XYZ','CONFECTIONS','Maxilaku','Hari Kumar',4,48.40,96.80,48.40,'US','TH'),
	 ('2024-04-26','Store XYZ','BEVERAGES','Sasquatch Ale','Liz Nixon',10,118.58,169.40,50.82,'US','TH'),
	 ('2024-10-20','Store XYZ','BEVERAGES','Cite de Blaye','Liz Nixon',10,2236.08,3194.40,958.32,'US','PT'),
	 ('2023-01-07','Store ABC','PRODUCE','Longlife Tofu','Mary Saveley',15,121.00,181.50,60.50,'US','PT'),
	 ('2024-08-20','Store ABC','CONDIMENTS','Original Frankfurter grine Sode','Palle Ibsen',14,121.00,169.40,48.40,'DK','PT');

-- Creating the org_chart table for a fictional IT company
CREATE TABLE `org_chart` (
    `emp_id` INT AUTO_INCREMENT,
    `emp_name` VARCHAR(100) NOT NULL,
    `emp_department` VARCHAR(100) NOT NULL,
    `emp_sub_department` VARCHAR(100),
    `emp_role` VARCHAR(100) NOT NULL,
    `emp_parent` INT,
    `emp_salary` DECIMAL(10, 2) NOT NULL,
    PRIMARY KEY (`emp_id`),
    FOREIGN KEY (`emp_parent`) REFERENCES `org_chart`(`emp_id`)
);

-- Inserting sample data into the org_chart table
INSERT INTO `org_chart` (`emp_id`, `emp_name`, `emp_department`, `emp_sub_department`, `emp_role`, `emp_parent`, `emp_salary`) VALUES
    (1, 'Alice Johnson', 'President', 'Executive Management', 'CEO', NULL, 250000.00),
    (2, 'Bob Smith', 'Management', 'Executive Management', 'CTO', 1, 200000.00),
    (3, 'Charlie Lee', 'Management', 'Executive Management', 'CFO', 1, 180000.00),
    (4, 'David Wilson', 'Development', 'Backend', 'Head of Development', 2, 150000.00),
    (5, 'Emily Davis', 'Development', 'Backend', 'Senior Software Engineer', 4, 120000.00),
    (6, 'Frank Miller', 'Development', 'Frontend', 'Junior Software Engineer', 53, 80000.00),
    (7, 'Grace Brown', 'Development', 'Frontend', 'Software Engineer', 53, 100000.00),
    (8, 'Henry Green', 'DevOps', 'Infrastructure', 'Head of DevOps', 2, 140000.00),
    (9, 'Ivy White', 'DevOps', 'Infrastructure', 'DevOps Engineer', 8, 95000.00),
    (10, 'Jack Black', 'Marketing', 'Digital Marketing', 'Head of Marketing', 51, 130000.00),
    (12, 'Liam Turner', 'Sales', 'B2B', 'Head of Sales', 1, 145000.00),
    (20, 'Tina Black', 'HR', 'Recruitment', 'Head of HR', 52, 130000.00),
    (21, 'Uma Jones', 'HR', 'Recruitment', 'Recruiter', 20, 70000.00),
    (13, 'Mike Brown', 'Sales', 'B2B', 'Sales Executive', 12, 90000.00),
    (14, 'Nancy Green', 'Development', 'Backend', 'Intern', 4, 45000.00),
    (15, 'Oscar White', 'Development', 'Frontend', 'Software Engineer', 53, 100000.00),
    (16, 'Paul Adams', 'DevOps', 'Automation', 'Junior DevOps Engineer', 54, 80000.00),
    (17, 'Quincy Hall', 'Development', 'Backend', 'Senior Software Engineer', 4, 120000.00),
    (18, 'Rachel Scott', 'Sales', 'B2C', 'Sales Representative', 12, 85000.00),
    (19, 'Steve Brown', 'Marketing', 'Content Creation', 'Content Creator', 10, 75000.00),
    (22, 'Victor Miller', 'Development', 'Backend', 'Team Lead', 4, 130000.00),
    (23, 'Wendy Clark', 'Finance', 'Financial Planning', 'Financial Analyst', 3, 95000.00),
    (24, 'Xavier Lewis', 'Finance', 'Accounting', 'Accountant', 3, 85000.00),
    (25, 'Yvonne Green', 'Development', 'Frontend', 'Software Engineer', 53, 100000.00),
    (26, 'Zara Smith', 'Marketing', 'SEO', 'SEO Specialist', 10, 80000.00),
    (27, 'Alan Turner', 'Sales', 'B2B', 'Sales Executive', 12, 90000.00),
    (28, 'Betty White', 'Sales', 'B2C', 'Sales Representative', 12, 85000.00),
    (29, 'Carl Brown', 'DevOps', 'Infrastructure', 'DevOps Engineer', 8, 95000.00),
    (30, 'Diana King', 'HR', 'Employee Relations', 'HR Specialist', 20, 70000.00),
    (31, 'Evan Lee', 'Development', 'Backend', 'Intern', 4, 45000.00),
    (32, 'Fiona Adams', 'Finance', 'Financial Planning', 'Senior Financial Analyst', 3, 105000.00),
    (33, 'George Miller', 'Development', 'Frontend', 'Software Engineer', 53, 100000.00),
    (34, 'Hannah Clark', 'Marketing', 'Social Media', 'Social Media Manager', 10, 90000.00),
    (35, 'Isaac Brown', 'DevOps', 'Automation', 'Senior DevOps Engineer', 54, 115000.00),
    (36, 'Julia White', 'Sales', 'B2B', 'Account Manager', 12, 95000.00),
    (37, 'Kevin Green', 'Development', 'Frontend', 'Junior Software Engineer', 53, 80000.00),
    (38, 'Linda Black', 'HR', 'Employee Relations', 'HR Assistant', 20, 55000.00),
    (39, 'Martin Smith', 'Finance', 'Accounting', 'Accountant', 3, 85000.00),
    (40, 'Nina Turner', 'Development', 'Backend', 'Software Engineer', 4, 100000.00),
    (41, 'Oliver King', 'DevOps', 'Infrastructure', 'DevOps Engineer', 8, 95000.00),
    (42, 'Patricia Scott', 'Marketing', 'Brand Management', 'Brand Manager', 10, 100000.00),
    (43, 'Quentin Adams', 'Sales', 'B2C', 'Sales Executive', 12, 90000.00),
    (44, 'Rita Green', 'Finance', 'Accounting', 'Junior Accountant', 3, 75000.00),
    (45, 'Sam White', 'Development', 'Backend', 'Senior Software Engineer', 4, 120000.00),
    (46, 'Terry Brown', 'DevOps', 'Automation', 'DevOps Engineer', 54, 95000.00),
    (47, 'Ursula Clark', 'Marketing', 'Content Strategy', 'Content Strategist', 10, 85000.00),
    (48, 'Vera King', 'HR', 'Training and Development', 'HR Coordinator', 20, 65000.00),
    (49, 'Walter Scott', 'Development', 'Frontend', 'Software Engineer', 53, 100000.00),
    (50, 'Xena Lewis', 'Sales', 'B2C', 'Sales Representative', 12, 85000.00),
	(51, 'Nora James', 'Management', 'Executive Management', 'CMO', 1, 180000.00),
    (52, 'Robert White', 'Management', 'Executive Management', 'CHRO', 1, 175000.00),
	(53, 'Helen Parker', 'Development', 'Frontend', 'Head of Frontend Development', 2, 140000.00),
	(54, 'Simon Carter', 'DevOps', 'Automation', 'Head of DevOps Automation', 2, 145000.00);

-- Creating the task_management table for tracking project tasks
CREATE TABLE `task_management` (
    `taskid` INT AUTO_INCREMENT,
    `taskname` VARCHAR(255) NOT NULL,
    `projectname` VARCHAR(255) NOT NULL,
    `plannedstart` DATE NOT NULL,
    `plannedfinish` DATE NOT NULL,
    `starteddate` DATE,
    `finisheddate` DATE,
    `assignedto` VARCHAR(100) NOT NULL,
    `percentcomplete` INT NOT NULL,
    `taskstatus` VARCHAR(50) NOT NULL,
    `milestone` VARCHAR(100),
    `dependencies` VARCHAR(255),
    PRIMARY KEY (`taskid`)
);


-- Inserindo registros na tabela task_management para três projetos: um finalizado e dois em andamento

-- Projeto 1: "Website Redesign" (Finalizado)
INSERT INTO `task_management` (`taskname`, `projectname`, `plannedstart`, `plannedfinish`, `starteddate`, `finisheddate`, `assignedto`, `percentcomplete`, `taskstatus`, `milestone`, `dependencies`) VALUES
('Project Planning', 'Website Redesign', '2024-11-01', '2024-11-05', '2024-11-01', '2024-11-05', 'Alice', 100, 'Completed', 'Planning Phase', NULL),
('Initial Design', 'Website Redesign', '2024-11-06', '2024-11-10', '2024-11-06', '2024-11-10', 'Bob', 100, 'Completed', NULL, '1'),
('Wireframe Approval', 'Website Redesign', '2024-11-11', '2024-11-15', '2024-11-11', '2024-11-15', 'Alice', 100, 'Completed', NULL, '2'),
('Frontend Development', 'Website Redesign', '2024-11-16', '2024-11-25', '2024-11-16', '2024-11-25', 'Charlie', 100, 'Completed', NULL, '3'),
('Backend Integration', 'Website Redesign', '2024-11-26', '2024-12-05', '2024-11-26', '2024-12-05', 'David', 100, 'Completed', NULL, '4'),
('Testing Phase', 'Website Redesign', '2024-12-06', '2024-12-10', '2024-12-06', '2024-12-10', 'Alice', 100, 'Completed', NULL, '5'),
('User Feedback', 'Website Redesign', '2024-12-11', '2024-12-15', '2024-12-11', '2024-12-15', 'Bob', 100, 'Completed', NULL, '6'),
('Bug Fixes', 'Website Redesign', '2024-12-16', '2024-12-20', '2024-12-16', '2024-12-20', 'Charlie', 100, 'Completed', NULL, '7'),
('Final Review', 'Website Redesign', '2024-12-21', '2024-12-25', '2024-12-21', '2024-12-25', 'Alice', 100, 'Completed', 'Final Review', '8'),
('Launch', 'Website Redesign', '2024-12-26', '2024-12-30', '2024-12-26', '2024-12-30', 'David', 100, 'Completed', 'Launch', '9');

-- Projeto 2: "Mobile App Development" (Em andamento)
INSERT INTO `task_management` (`taskname`, `projectname`, `plannedstart`, `plannedfinish`, `starteddate`, `finisheddate`, `assignedto`, `percentcomplete`, `taskstatus`, `milestone`, `dependencies`) VALUES
('Requirement Gathering', 'Mobile App Development', '2024-11-01', '2024-11-05', '2024-11-01', '2024-11-05', 'Emily', 100, 'Completed', 'Requirement Gathering', NULL),
('UI Design', 'Mobile App Development', '2024-11-06', '2024-11-15', '2024-11-06', '2024-11-15', 'Frank', 100, 'Completed', NULL, '11'),
('Backend Setup', 'Mobile App Development', '2024-11-16', '2024-11-25', '2024-11-16', '2024-11-25', 'Grace', 100, 'Completed', NULL, '12'),
('Frontend Development', 'Mobile App Development', '2024-11-26', '2024-12-05', '2024-11-26', '2024-12-05', 'Hank', 100, 'Completed', NULL, '13'),
('API Integration', 'Mobile App Development', '2024-12-06', '2024-12-15', '2024-12-06', '2024-12-15', 'Grace', 100, 'Completed', NULL, '14'),
('Testing & QA', 'Mobile App Development', '2024-12-16', '2024-12-25', '2024-12-16', '2024-12-25', 'Emily', 100, 'Completed', NULL, '15'),
('User Feedback', 'Mobile App Development', '2024-12-26', '2025-01-05', '2024-12-26', '2025-01-05', 'Frank', 100, 'Completed', NULL, '16'),
('Bug Fixing', 'Mobile App Development', '2025-01-06', '2025-01-15', '2025-01-06', NULL, 'Hank', 50, 'In Progress', NULL, '17'),
('App Deployment', 'Mobile App Development', '2025-01-16', '2025-01-25', NULL, NULL, 'David', 0, 'Pending', 'Deployment', '18'),
('Marketing Campaign', 'Mobile App Development', '2025-01-26', '2025-01-31', NULL, NULL, 'Emily', 0, 'Pending', NULL, '19');

-- Projeto 3: "Data Migration Project" (Em andamento)
INSERT INTO `task_management` (`taskname`, `projectname`, `plannedstart`, `plannedfinish`, `starteddate`, `finisheddate`, `assignedto`, `percentcomplete`, `taskstatus`, `milestone`, `dependencies`) VALUES
('Data Assessment', 'Data Migration Project', '2024-11-01', '2024-11-10', '2024-11-01', '2024-11-10', 'Isaac', 100, 'Completed', 'Data Assessment', NULL),
('Database Design', 'Data Migration Project', '2024-11-11', '2024-11-20', '2024-11-11', '2024-11-20', 'Jack', 100, 'Completed', NULL, '21'),
('ETL Development', 'Data Migration Project', '2024-11-21', '2024-11-30', '2024-11-21', '2024-11-30', 'Karen', 100, 'Completed', NULL, '22'),
('Data Validation', 'Data Migration Project', '2024-12-01', '2024-12-10', '2024-12-01', '2024-12-10', 'Liam', 100, 'Completed', NULL, '23'),
('Migration Testing', 'Data Migration Project', '2024-12-11', '2024-12-20', '2024-12-11', '2024-12-20', 'Isaac', 100, 'Completed', NULL, '24'),
('System Downtime Planning', 'Data Migration Project', '2024-12-21', '2024-12-25', '2024-12-21', '2024-12-25', 'Jack', 100, 'Completed', 'Downtime Planning', '25'),
('Data Migration Execution', 'Data Migration Project', '2024-12-26', '2024-12-30', '2024-12-26', NULL, 'Karen', 50, 'In Progress', NULL, '26'),
('Post-Migration Validation', 'Data Migration Project', '2025-01-01', '2025-01-05', NULL, NULL, 'Liam', 0, 'Pending', NULL, '27'),
('Final Report', 'Data Migration Project', '2025-01-06', '2025-01-10', NULL, NULL, 'Jack', 0, 'Pending', 'Final Report', '28');

-- ----------------------------
-- Table structure for comparison
-- ----------------------------
CREATE TABLE `comparison`  (
  `seq` int(11) NOT NULL AUTO_INCREMENT,
  `TypeClient` varchar(250) ,
  `Continent` varchar(255),
  `Country` varchar(50),
  `OrderDate` date NOT NULL,
  `Category` varchar(255),
  `Product` varchar(255) ,
  `Qty` int(11) NOT NULL,
  `PriceUnit` numeric(18,2) DEFAULT NULL,
  `TotalPrice` numeric(18, 2) NOT NULL,
  PRIMARY KEY (`seq`)
);

-- ----------------------------
-- Records of comparison
-- ----------------------------
INSERT INTO `comparison` VALUES (1,	'Natural Person',	'North America',	'United States',	'2013-05-08',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	209,	209),  (2,	'Legal entity',	'Europe',	'United Kingdom',	'2022-11-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	494.55,	494.55),  (3,	'Natural Person',	'Europe',	'Spain',	'2013-01-04',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (4,	'Natural Person',	'North America',	'United States',	'2013-01-07',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (5,	'Natural Person',	'Europe',	'Switzerland',	'2013-01-08',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (6,	'Natural Person',	'Asia',	'United Arab Emirates',	'2013-01-10',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (7,	'Legal entity',	'South America',	'Peru',	'2013-01-12',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (8,	'Natural Person',	'Asia',	'Indonesia',	'2013-01-13',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (9,	'Natural Person',	'North America',	'Panama',	'2013-01-15',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (10,	'Natural Person',	'Europe',	'France',	'2013-01-16',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (11,	'Legal entity',	'North America',	'Mexico',	'2013-01-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (12,	'Natural Person',	'North America',	'United States',	'2013-01-18',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (13,	'Natural Person',	'North America',	'United States',	'2013-01-21',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	292.5,	292.5),  (14,	'Natural Person',	'North America',	'United States',	'2013-01-22',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (15,	'Legal entity',	'South America',	'Colombia',	'2013-01-23',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	270,	270),  (16,	'Legal entity',	'South America',	'Chile',	'2013-01-24',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (17,	'Legal entity',	'Europe',	'Spain',	'2013-01-26',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (18,	'Natural Person',	'Asia',	'Indonesia',	'2013-01-29',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (19,	'Natural Person',	'North America',	'United States',	'2013-01-31',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	247.5,	247.5),  (20,	'Natural Person',	'North America',	'Mexico',	'2013-02-01',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	270,	270),  (21,	'Legal entity',	'North America',	'Canada',	'2013-01-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (22,	'Legal entity',	'North America',	'Guatemala',	'2013-01-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	842.4,	842.4),  (23,	'Legal entity',	'Europe',	'Italy',	'2013-01-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (24,	'Natural Person',	'Asia',	'Malaysia',	'2013-01-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (25,	'Legal entity',	'North America',	'Costa Rica',	'2013-01-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	270,	270),  (26,	'public company',	'North America',	'United States',	'2013-01-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	11250,	11250),  (27,	'Natural Person',	'Asia',	'Indonesia',	'2013-01-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (28,	'Natural Person',	'Europe',	'Portugal',	'2013-01-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (29,	'Natural Person',	'North America',	'United States',	'2013-02-22',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	150,	150),  (30,	'Natural Person',	'Europe',	'Italy',	'2013-02-23',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	150,	150),  (31,	'Natural Person',	'Asia',	'Indonesia',	'2013-03-01',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (32,	'Legal entity',	'North America',	'United States',	'2013-03-19',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (33,	'Natural Person',	'North America',	'United States',	'2013-03-21',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (34,	'Legal entity',	'Oceania',	'Australia',	'2013-04-01',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (35,	'Natural Person',	'Europe',	'United Kingdom',	'2013-04-04',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (36,	'Natural Person',	'South America',	'Colombia',	'2013-04-11',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (37,	'Natural Person',	'North America',	'Canada',	'2013-04-15',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (38,	'Legal entity',	'South America',	'Colombia',	'2013-04-17',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (39,	'Natural Person',	'North America',	'Canada',	'2013-04-30',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	150,	150),  (40,	'Natural Person',	'North America',	'United States',	'2013-05-09',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	150,	150),  (41,	'Natural Person',	'Europe',	'Switzerland',	'2013-05-25',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (44,	'Natural Person',	'South America',	'Uruguay',	'2013-06-12',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (45,	'Natural Person',	'Europe',	'France',	'2013-06-25',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (46,	'Legal entity',	'Asia',	'Philippines',	'2013-07-01',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (47,	'Natural Person',	'Asia',	'China',	'2013-07-09',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	250,	250),  (48,	'public company',	'Europe',	'Netherlands',	'2013-01-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7200,	7200),  (49,	'Legal entity',	'South America',	'Paraguay',	'2013-09-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2700,	2700),  (50,	'Legal entity',	'North America',	'Mexico',	'2013-05-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	199,	199),  (51,	'Legal entity',	'South America',	'Colombia',	'2013-06-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	199,	199),  (52,	'Natural Person',	'North America',	'Canada',	'2013-01-05',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (53,	'Natural Person',	'Asia',	'Japan',	'2013-01-06',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (54,	'Natural Person',	'Oceania',	'French Polynesia',	'2013-01-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (55,	'Natural Person',	'Africa',	'Algeria',	'2013-01-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (56,	'Natural Person',	'North America',	'United States',	'2013-01-27',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (57,	'Legal entity',	'North America',	'Mexico',	'2013-05-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	45,	45),  (58,	'Legal entity',	'North America',	'United States',	'2013-05-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	45,	45),  (59,	'Natural Person',	'Europe',	'France',	'2013-07-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	45,	45),  (60,	'Legal entity',	'Europe',	'Spain',	'2013-09-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	45,	45),  (61,	'Natural Person',	'South America',	'Colombia',	'2013-04-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	250,	250),  (62,	'Natural Person',	'Europe',	'France',	'2013-02-03',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (63,	'Natural Person',	'Europe',	'Italy',	'2013-02-04',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	292.5,	292.5),  (64,	'Natural Person',	'South America',	'Peru',	'2013-02-02',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (65,	'Natural Person',	'North America',	'Canada',	'2013-02-05',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (66,	'Natural Person',	'Europe',	'United Kingdom',	'2013-02-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	405,	405),  (67,	'Legal entity',	'North America',	'Costa Rica',	'2013-02-07',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	270,	270),  (68,	'Natural Person',	'Europe',	'France',	'2013-02-08',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (69,	'Natural Person',	'Europe',	'Italy',	'2013-02-11',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (70,	'Natural Person',	'Europe',	'Italy',	'2013-02-12',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (71,	'Natural Person',	'Europe',	'Czech Republic',	'2013-02-14',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	270,	270),  (72,	'Legal entity',	'North America',	'Mexico',	'2013-02-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (73,	'Natural Person',	'Europe',	'Germany',	'2013-02-19',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (74,	'Legal entity',	'South America',	'Venezuela',	'2013-02-20',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (75,	'Natural Person',	'Asia',	'Indonesia',	'2013-02-21',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	270,	270),  (76,	'Natural Person',	'South America',	'Colombia',	'2013-02-25',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (77,	'Natural Person',	'North America',	'United States',	'2013-02-26',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (78,	'Natural Person',	'Asia',	'China',	'2013-02-27',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (79,	'Natural Person',	'Europe',	'Spain',	'2013-03-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (80,	'Natural Person',	'Europe',	'Italy',	'2013-03-07',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	450,	450),  (81,	'Natural Person',	'Europe',	'Italy',	'2013-03-11',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (82,	'Legal entity',	'Africa',	'South Africa',	'2013-03-12',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (83,	'Natural Person',	'North America',	'United States',	'2013-03-15',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (84,	'Natural Person',	'Africa',	'Morocco',	'2013-03-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (85,	'Natural Person',	'Africa',	'South Africa',	'2013-03-18',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (86,	'Legal entity',	'North America',	'El Salvador',	'2013-03-22',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (87,	'Natural Person',	'Europe',	'Switzerland',	'2013-03-23',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (88,	'Natural Person',	'North America',	'United States',	'2013-03-25',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (89,	'Legal entity',	'Europe',	'Spain',	'2013-03-30',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (90,	'Natural Person',	'South America',	'Ecuador',	'2013-03-31',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (91,	'Legal entity',	'Oceania',	'Australia',	'2013-04-02',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (92,	'Legal entity',	'Europe',	'Spain',	'2013-04-03',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (93,	'Legal entity',	'South America',	'Argentina',	'2013-04-05',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (94,	'Legal entity',	'Europe',	'Netherlands',	'2013-04-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (95,	'Natural Person',	'Asia',	'United Arab Emirates',	'2013-04-12',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (96,	'Natural Person',	'Europe',	'Italy',	'2013-04-13',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (97,	'Natural Person',	'Asia',	'China',	'2013-04-14',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (98,	'Natural Person',	'North America',	'United States',	'2013-04-16',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (99,	'Natural Person',	'Europe',	'Italy',	'2013-04-18',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (100,	'Natural Person',	'South America',	'Venezuela',	'2013-04-21',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (101,	'Natural Person',	'North America',	'United States',	'2013-05-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (102,	'Natural Person',	'North America',	'Panama',	'2013-05-10',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (103,	'Legal entity',	'North America',	'Mexico',	'2013-05-15',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	210,	210),  (104,	'Natural Person',	'Europe',	'Spain',	'2013-05-20',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	292.5,	292.5),  (105,	'Natural Person',	'North America',	'United States',	'2013-05-26',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	270,	270),  (106,	'Legal entity',	'Europe',	'United Kingdom',	'2013-05-29',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (107,	'Natural Person',	'Europe',	'United Kingdom',	'2013-06-05',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (108,	'Legal entity',	'Europe',	'Netherlands',	'2013-06-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (109,	'Natural Person',	'Europe',	'Germany',	'2013-06-08',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (110,	'Natural Person',	'North America',	'Mexico',	'2013-06-13',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (111,	'Legal entity',	'South America',	'Argentina',	'2013-06-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (112,	'Natural Person',	'Europe',	'Slovenia',	'2013-06-22',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (113,	'Natural Person',	'South America',	'Colombia',	'2013-06-23',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (114,	'Natural Person',	'Europe',	'Germany',	'2013-06-24',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	180,	180),  (115,	'Legal entity',	'South America',	'Uruguay',	'2013-06-26',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (116,	'Legal entity',	'South America',	'Colombia',	'2013-06-27',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	140,	140),  (117,	'Natural Person',	'Europe',	'United Kingdom',	'2013-07-03',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	450.3,	450.3),  (118,	'Natural Person',	'Europe',	'Belgium',	'2013-07-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	139.6,	139.6),  (119,	'Legal entity',	'Europe',	'Spain',	'2013-07-07',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	139.6,	139.6),  (120,	'Natural Person',	'North America',	'United States',	'2013-07-08',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	209.4,	209.4),  (121,	'Natural Person',	'Europe',	'Netherlands',	'2013-07-10',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	139.6,	139.6),  (122,	'Natural Person',	'Europe',	'Spain',	'2013-07-11',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	139.6,	139.6),  (123,	'Natural Person',	'Asia',	'Israel',	'2013-07-15',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	139.6,	139.6),  (124,	'Natural Person',	'Asia',	'Indonesia',	'2013-07-18',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	494.55,	494.55),  (125,	'Natural Person',	'Oceania',	'French Polynesia',	'2013-07-22',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	494.55,	494.55),  (126,	'Natural Person',	'Asia',	'Hong Kong',	'2013-08-14',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	445.1,	445.1),  (127,	'Natural Person',	'South America',	'Brazil',	'2013-08-28',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	494.55,	494.55),  (128,	'Legal entity',	'Africa',	'Guinea',	'2013-11-22',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	494.55,	494.55),  (129,	'Natural Person',	'Europe',	'United Kingdom',	'2013-12-05',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	329.55,	329.55),  (130,	'Natural Person',	'Europe',	'Netherlands',	'2013-12-13',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	494.55,	494.55),  (131,	'Natural Person',	'Europe',	'Switzerland',	'2014-01-13',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	450,	450),  (132,	'Natural Person',	'Europe',	'United Kingdom',	'2014-02-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	825.6,	825.6),  (133,	'Legal entity',	'South America',	'Argentina',	'2014-04-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	494.55,	494.55),  (134,	'Natural Person',	'Europe',	'United Kingdom',	'2014-05-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	412.8,	412.8),  (135,	'Natural Person',	'Africa',	'Botswana',	'2014-05-21',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	412.43,	412.43),  (136,	'Legal entity',	'Europe',	'Russian Federation',	'2014-06-26',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	412.13,	412.13),  (137,	'Legal entity',	'Europe',	'Netherlands',	'2013-06-14',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	2160,	2160),  (138,	'Legal entity',	'Europe',	'France',	'2014-05-08',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	1747.73,	1747.73),  (139,	'public company',	'South America',	'Brazil',	'2014-01-29',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	3944.25,	3944.25),  (142,	'Natural Person',	'Asia',	'Qatar',	'2013-03-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1170,	1170),  (143,	'Legal entity',	'South America',	'Brazil',	'2013-03-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	936,	936),  (144,	'Legal entity',	'Africa',	'South Africa',	'2013-04-10',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1053,	1053),  (145,	'Natural Person',	'Europe',	'Hungary',	'2013-05-23',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1053,	1053),  (146,	'Natural Person',	'Asia',	'Indonesia',	'2013-06-18',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1012.13,	1012.13),  (147,	'Natural Person',	'Europe',	'Netherlands',	'2013-08-13',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (148,	'Legal entity',	'Asia',	'Hong Kong',	'2013-08-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (149,	'Legal entity',	'Asia',	'China',	'2013-08-21',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (150,	'Natural Person',	'Europe',	'United Kingdom',	'2013-09-04',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	750.3,	750.3),  (151,	'Legal entity',	'Africa',	'Sierra Leone',	'2013-09-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (152,	'Natural Person',	'Europe',	'France',	'2013-10-08',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	674.73,	674.73),  (153,	'public company',	'Africa',	'South Africa',	'2013-10-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2250,	2250),  (154,	'Legal entity',	'South America',	'Brazil',	'2013-10-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	749.7,	749.7),  (155,	'Natural Person',	'Europe',	'Czech Republic',	'2013-11-21',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1012.05,	1012.05),  (156,	'Natural Person',	'South America',	'Brazil',	'2013-11-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	787.28,	787.28),  (157,	'Legal entity',	'South America',	'Argentina',	'2013-12-16',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	787.49,	787.49),  (158,	'Legal entity',	'North America',	'Canada',	'2014-01-10',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (159,	'Legal entity',	'Africa',	'Namibia',	'2014-02-25',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	901.05,	901.05),  (160,	'Legal entity',	'Asia',	'Qatar',	'2014-03-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (161,	'Legal entity',	'Europe',	'France',	'2014-04-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (162,	'Natural Person',	'South America',	'Brazil',	'2014-04-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	937.05,	937.05),  (163,	'Legal entity',	'Europe',	'United Kingdom',	'2014-05-05',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	843.41,	843.41),  (164,	'Natural Person',	'Europe',	'France',	'2014-05-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	937.05,	937.05),  (165,	'Natural Person',	'North America',	'El Salvador',	'2014-05-22',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	937.43,	937.43),  (166,	'Natural Person',	'Europe',	'Russian Federation',	'2014-05-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	524.78,	524.78),  (167,	'Natural Person',	'South America',	'Brazil',	'2014-05-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1687.35,	1687.35),  (168,	'Natural Person',	'North America',	'United States',	'2014-06-02',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	877.13,	877.13),  (169,	'Legal entity',	'Europe',	'Switzerland',	'2014-06-12',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1012.1,	1012.1),  (170,	'Natural Person',	'Asia',	'Oman',	'2014-06-25',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	900.3,	900.3),  (171,	'Legal entity',	'South America',	'Brazil',	'2014-06-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	937.8,	937.8),  (172,	'Legal entity',	'Europe',	'United Kingdom',	'2014-07-03',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	843.41,	843.41),  (173,	'Legal entity',	'Asia',	'Pakistan',	'2014-07-25',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.55,	1124.55),  (174,	'public company',	'Africa',	'Gabon',	'2014-09-22',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	5997.6,	5997.6),  (175,	'Natural Person',	'Europe',	'Finland',	'2013-02-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (176,	'Natural Person',	'North America',	'United States',	'2013-03-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	842.4,	842.4),  (177,	'Natural Person',	'Europe',	'Russian Federation',	'2013-03-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1156.88,	1156.88),  (178,	'Natural Person',	'Asia',	'Indonesia',	'2013-03-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1156.88,	1156.88),  (179,	'Legal entity',	'North America',	'Mexico',	'2013-03-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (180,	'Natural Person',	'North America',	'United States',	'2013-03-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (181,	'Legal entity',	'South America',	'Colombia',	'2013-04-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (182,	'Legal entity',	'South America',	'Chile',	'2013-04-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (183,	'Natural Person',	'Europe',	'Germany',	'2013-04-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (184,	'Natural Person',	'North America',	'Canada',	'2013-05-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (185,	'Legal entity',	'Europe',	'Spain',	'2013-06-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1156.88,	1156.88),  (186,	'Natural Person',	'Europe',	'Switzerland',	'2013-06-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (187,	'Legal entity',	'North America',	'United States',	'2013-07-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (188,	'Legal entity',	'South America',	'Ecuador',	'2013-08-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	842.4,	842.4),  (189,	'Natural Person',	'Europe',	'Switzerland',	'2013-08-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (190,	'Legal entity',	'Oceania',	'Australia',	'2013-08-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1426.43,	1426.43),  (191,	'Legal entity',	'South America',	'Chile',	'2013-08-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (192,	'Legal entity',	'South America',	'Colombia',	'2013-08-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (193,	'Legal entity',	'South America',	'Peru',	'2013-08-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (194,	'Legal entity',	'Europe',	'Germany',	'2013-09-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (195,	'Natural Person',	'Oceania',	'Australia',	'2013-09-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	983.35,	983.35),  (196,	'Natural Person',	'Europe',	'Germany',	'2013-09-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	483,	483),  (197,	'Legal entity',	'North America',	'United States',	'2013-09-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (198,	'Legal entity',	'Africa',	'South Africa',	'2013-10-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	3105,	3105),  (199,	'Natural Person',	'South America',	'Colombia',	'2013-10-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (200,	'Natural Person',	'North America',	'United States',	'2013-10-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (201,	'Legal entity',	'Europe',	'Russian Federation',	'2013-11-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	440.4,	440.4),  (202,	'Natural Person',	'North America',	'United States',	'2013-12-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	411,	411),  (203,	'Natural Person',	'Europe',	'United Kingdom',	'2014-01-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	411,	411),  (204,	'Natural Person',	'Europe',	'Greece',	'2014-01-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (205,	'Legal entity',	'North America',	'Mexico',	'2014-01-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1159.88,	1159.88),  (206,	'Natural Person',	'Europe',	'Germany',	'2014-02-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (207,	'Natural Person',	'Asia',	'Indonesia',	'2014-02-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (208,	'Natural Person',	'Europe',	'France',	'2014-02-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (209,	'public company',	'Europe',	'Netherlands',	'2014-03-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	3450,	3450),  (210,	'Legal entity',	'North America',	'Mexico',	'2014-04-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (211,	'Legal entity',	'North America',	'Mexico',	'2014-04-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (212,	'Legal entity',	'Europe',	'United Kingdom',	'2014-04-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	485.19,	485.19),  (213,	'Legal entity',	'North America',	'Mexico',	'2014-05-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	396.15,	396.15),  (214,	'Natural Person',	'North America',	'United States',	'2014-05-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	396.15,	396.15),  (215,	'Legal entity',	'North America',	'Mexico',	'2014-06-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	396.15,	396.15),  (216,	'Natural Person',	'North America',	'United States',	'2014-07-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	396.15,	396.15),  (217,	'Natural Person',	'South America',	'Colombia',	'2014-07-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (218,	'Legal entity',	'North America',	'Mexico',	'2013-05-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	882.9,	882.9),  (219,	'public company',	'Europe',	'United Kingdom',	'2013-06-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	4170,	4170),  (220,	'Legal entity',	'North America',	'Mexico',	'2013-07-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	310.5,	310.5),  (221,	'Legal entity',	'Asia',	'Hong Kong',	'2013-07-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	523.5,	523.5),  (222,	'Legal entity',	'North America',	'United States',	'2013-08-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	523.5,	523.5),  (223,	'Natural Person',	'North America',	'United States',	'2013-08-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	523.5,	523.5),  (226,	'Legal entity',	'South America',	'Chile',	'2013-11-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1123.11,	1123.11),  (227,	'public company',	'South America',	'Brazil',	'2013-11-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	7395,	7395),  (228,	'public company',	'Europe',	'United Kingdom',	'2013-12-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	12450,	12450),  (229,	'Natural Person',	'Europe',	'France',	'2014-01-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	441,	441),  (230,	'Legal entity',	'North America',	'Mexico',	'2014-01-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	740.4,	740.4),  (231,	'Natural Person',	'North America',	'Haiti',	'2014-02-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	516,	516),  (232,	'Legal entity',	'South America',	'Ecuador',	'2014-01-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1392.66,	1392.66),  (233,	'Natural Person',	'Asia',	'India',	'2014-02-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	381,	381),  (234,	'Natural Person',	'North America',	'Mexico',	'2014-03-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	875.4,	875.4),  (235,	'public company',	'Europe',	'Spain',	'2014-07-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	3750,	3750),  (236,	'public company',	'Europe',	'Netherlands',	'2013-03-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	8070,	8070),  (237,	'public company',	'Europe',	'Liechtenstein',	'2013-04-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	4470,	4470),  (238,	'Legal entity',	'Europe',	'France',	'2013-05-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	4309.5,	4309.5),  (239,	'Natural Person',	'North America',	'United States',	'2013-05-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	598.5,	598.5),  (240,	'public company',	'Europe',	'France',	'2013-08-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	4117.5,	4117.5),  (241,	'Legal entity',	'Europe',	'Spain',	'2013-11-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	957.9,	957.9),  (242,	'Legal entity',	'North America',	'United States',	'2013-11-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	957.9,	957.9),  (243,	'public company',	'Asia',	'Hong Kong',	'2013-11-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	4192.5,	4192.5),  (244,	'Legal entity',	'North America',	'Mexico',	'2013-11-26',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	957.9,	957.9),  (245,	'public company',	'South America',	'Uruguay',	'2013-11-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	8070,	8070),  (246,	'Natural Person',	'North America',	'United States',	'2013-12-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	523.5,	523.5),  (247,	'Natural Person',	'North America',	'Canada',	'2014-02-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	598.5,	598.5),  (248,	'Legal entity',	'Africa',	'Zambia',	'2014-03-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	808.65,	808.65),  (249,	'Legal entity',	'Asia',	'Malaysia',	'2014-03-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2295.6,	2295.6),  (250,	'Natural Person',	'Europe',	'Italy',	'2014-03-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	598.5,	598.5),  (251,	'Legal entity',	'South America',	'Colombia',	'2014-04-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1272.38,	1272.38),  (252,	'Legal entity',	'Europe',	'Netherlands',	'2014-05-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	4056,	4056),  (253,	'Legal entity',	'Asia',	'Turkey',	'2014-05-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	565.65,	565.65),  (254,	'public company',	'Europe',	'United Kingdom',	'2014-06-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	8070,	8070),  (255,	'Natural Person',	'Europe',	'France',	'2014-06-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.65,	508.65),  (256,	'Natural Person',	'North America',	'Canada',	'2014-06-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.65,	508.65),  (257,	'Legal entity',	'Asia',	'Indonesia',	'2014-06-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	796.17,	796.17),  (258,	'Legal entity',	'South America',	'Chile',	'2014-07-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.65,	508.65),  (259,	'Legal entity',	'Europe',	'United Kingdom',	'2014-07-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	716.48,	716.48),  (260,	'Legal entity',	'Africa',	'Nigeria',	'2014-07-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	934.88,	934.88),  (261,	'Legal entity',	'North America',	'United States',	'2014-08-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	449.25,	449.25),  (262,	'public company',	'Asia',	'Indonesia',	'2014-08-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	11025,	11025),  (263,	'Natural Person',	'North America',	'United States',	'2013-02-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.25,	539.25),  (264,	'Legal entity',	'Europe',	'Belgium',	'2013-02-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	240,	240),  (265,	'Natural Person',	'Europe',	'Austria',	'2013-02-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	270,	270),  (266,	'Legal entity',	'North America',	'Costa Rica',	'2013-02-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	270,	270),  (267,	'Legal entity',	'North America',	'United States',	'2013-04-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	270,	270),  (268,	'Legal entity',	'South America',	'Colombia',	'2013-04-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	240,	240),  (269,	'Legal entity',	'South America',	'Chile',	'2013-05-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.25,	539.25),  (270,	'Natural Person',	'Europe',	'Switzerland',	'2013-06-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	240,	240),  (271,	'Legal entity',	'North America',	'Mexico',	'2013-06-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	360,	360),  (272,	'Legal entity',	'North America',	'United States',	'2013-06-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	240,	240),  (273,	'Natural Person',	'South America',	'Peru',	'2013-07-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	239.6,	239.6),  (274,	'public company',	'Europe',	'Germany',	'2013-08-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5992.5,	5992.5),  (275,	'Natural Person',	'South America',	'Colombia',	'2013-09-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	269.55,	269.55),  (276,	'public company',	'Europe',	'Spain',	'2013-10-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3600,	3600),  (277,	'Natural Person',	'Africa',	'South Africa',	'2013-11-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1080,	1080),  (278,	'Legal entity',	'North America',	'United States',	'2013-12-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	756,	756),  (279,	'Natural Person',	'Europe',	'United Kingdom',	'2013-12-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1260,	1260),  (280,	'public company',	'Asia',	'Afghanistan',	'2013-12-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1200,	1200),  (281,	'Legal entity',	'Asia',	'Thailand',	'2014-03-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1620,	1620),  (282,	'Legal entity',	'North America',	'Canada',	'2014-05-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1800,	1800),  (283,	'Legal entity',	'Europe',	'United Kingdom',	'2014-06-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2280,	2280),  (284,	'public company',	'Europe',	'Germany',	'2014-08-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3600,	3600),  (285,	'public company',	'Asia',	'Hong Kong',	'2014-09-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1800,	1800),  (286,	'Legal entity',	'South America',	'Argentina',	'2014-09-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	566.19,	566.19),  (287,	'Legal entity',	'Europe',	'Italy',	'2013-05-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (288,	'Natural Person',	'South America',	'Peru',	'2013-05-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (289,	'Legal entity',	'Europe',	'Italy',	'2013-07-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (290,	'Legal entity',	'South America',	'Argentina',	'2013-07-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (291,	'Natural Person',	'Europe',	'Spain',	'2013-07-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (292,	'Natural Person',	'Europe',	'United Kingdom',	'2013-08-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	741.83,	741.83),  (293,	'Natural Person',	'Europe',	'France',	'2013-08-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (294,	'Natural Person',	'Europe',	'Switzerland',	'2013-08-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	741.83,	741.83),  (295,	'Natural Person',	'Europe',	'Spain',	'2013-08-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (296,	'Natural Person',	'South America',	'Ecuador',	'2013-09-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (297,	'Natural Person',	'Europe',	'France',	'2013-09-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (298,	'Natural Person',	'Asia',	'Bangladesh',	'2013-09-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (299,	'Natural Person',	'North America',	'Costa Rica',	'2013-09-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (300,	'Legal entity',	'Asia',	'China',	'2013-09-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	249,	249),  (301,	'Natural Person',	'South America',	'Brazil',	'2013-09-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (302,	'Natural Person',	'Africa',	'Sierra Leone',	'2013-10-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (303,	'Legal entity',	'South America',	'Argentina',	'2013-10-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (304,	'Natural Person',	'Europe',	'Belgium',	'2013-10-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	286.24,	286.24),  (305,	'Legal entity',	'Europe',	'Spain',	'2013-10-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (306,	'Natural Person',	'North America',	'United States',	'2013-10-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (307,	'Natural Person',	'South America',	'Brazil',	'2013-10-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (308,	'Natural Person',	'North America',	'United States',	'2013-11-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (309,	'Natural Person',	'South America',	'Brazil',	'2013-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	519.28,	519.28),  (310,	'Natural Person',	'Europe',	'Switzerland',	'2013-12-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	235.73,	235.73),  (311,	'Natural Person',	'Europe',	'Germany',	'2013-12-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (312,	'Natural Person',	'Africa',	'South Africa',	'2013-12-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	576.98,	576.98),  (313,	'Natural Person',	'North America',	'Mexico',	'2013-12-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (314,	'Legal entity',	'Europe',	'France',	'2013-12-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (315,	'Legal entity',	'South America',	'Peru',	'2013-12-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (316,	'Natural Person',	'North America',	'United States',	'2013-12-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (317,	'Legal entity',	'Asia',	'India',	'2013-12-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (318,	'Natural Person',	'North America',	'Mexico',	'2013-12-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (319,	'Natural Person',	'South America',	'Bolivia',	'2013-12-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (320,	'Natural Person',	'North America',	'United States',	'2013-12-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (321,	'Legal entity',	'North America',	'United States',	'2013-12-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (322,	'Natural Person',	'North America',	'Mexico',	'2014-01-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (323,	'Natural Person',	'Asia',	'Thailand',	'2014-01-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	249,	249),  (324,	'Natural Person',	'North America',	'Canada',	'2014-01-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (325,	'Natural Person',	'Europe',	'Germany',	'2014-01-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (326,	'Natural Person',	'North America',	'United States',	'2014-01-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (327,	'Natural Person',	'South America',	'Ecuador',	'2014-01-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (328,	'Natural Person',	'North America',	'Mexico',	'2014-01-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (329,	'Natural Person',	'Europe',	'France',	'2014-01-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (330,	'Legal entity',	'Europe',	'United Kingdom',	'2014-01-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	254.36,	254.36),  (331,	'Natural Person',	'North America',	'Guatemala',	'2014-01-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (332,	'Natural Person',	'Africa',	'Uganda',	'2014-01-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (333,	'Natural Person',	'Europe',	'Spain',	'2014-01-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (334,	'Natural Person',	'North America',	'United States',	'2014-01-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (335,	'Natural Person',	'South America',	'Uruguay',	'2014-01-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (336,	'Natural Person',	'Europe',	'Germany',	'2014-01-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (337,	'Natural Person',	'Asia',	'Indonesia',	'2014-02-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (338,	'Natural Person',	'Europe',	'Hungary',	'2014-02-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (339,	'Natural Person',	'South America',	'Peru',	'2014-02-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (340,	'Natural Person',	'North America',	'Canada',	'2014-02-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (341,	'Natural Person',	'South America',	'Argentina',	'2014-02-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	741.83,	741.83),  (342,	'Legal entity',	'North America',	'United States',	'2014-02-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (343,	'Natural Person',	'North America',	'Dominican Republic',	'2014-02-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (344,	'Natural Person',	'South America',	'Venezuela',	'2014-02-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (345,	'Legal entity',	'South America',	'Colombia',	'2014-02-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (346,	'Natural Person',	'Europe',	'Belgium',	'2014-03-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (347,	'Legal entity',	'Asia',	'Japan',	'2014-03-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	286.24,	286.24),  (348,	'Legal entity',	'Europe',	'Spain',	'2014-03-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (349,	'Legal entity',	'Asia',	'United Arab Emirates',	'2014-03-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (350,	'Legal entity',	'North America',	'Honduras',	'2014-03-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	741.83,	741.83),  (351,	'Legal entity',	'Europe',	'Liechtenstein',	'2014-03-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (352,	'Natural Person',	'Europe',	'Poland',	'2014-03-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (353,	'Legal entity',	'North America',	'United States',	'2014-03-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (354,	'Legal entity',	'Europe',	'Italy',	'2014-03-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (355,	'Legal entity',	'Europe',	'Germany',	'2014-04-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (356,	'Natural Person',	'Europe',	'Sweden',	'2014-04-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (357,	'Legal entity',	'Europe',	'Spain',	'2014-04-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (358,	'Natural Person',	'Europe',	'Switzerland',	'2014-04-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (359,	'Natural Person',	'North America',	'Mexico',	'2014-04-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (360,	'Natural Person',	'Asia',	'Indonesia',	'2014-04-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (361,	'Natural Person',	'Europe',	'France',	'2014-04-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (362,	'Legal entity',	'South America',	'Chile',	'2014-04-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (363,	'Legal entity',	'North America',	'United States',	'2014-04-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (364,	'Natural Person',	'Europe',	'France',	'2014-04-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (365,	'Natural Person',	'Europe',	'Germany',	'2014-05-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	593.46,	593.46),  (366,	'Natural Person',	'Europe',	'Spain',	'2014-05-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (367,	'Natural Person',	'South America',	'Colombia',	'2014-05-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (368,	'Natural Person',	'South America',	'Colombia',	'2014-05-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (369,	'Natural Person',	'Asia',	'Hong Kong',	'2014-05-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (370,	'Natural Person',	'Europe',	'Italy',	'2014-05-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (371,	'Natural Person',	'Europe',	'France',	'2014-05-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (372,	'Legal entity',	'Asia',	'Iraq',	'2014-05-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	593.46,	593.46),  (373,	'public company',	'Europe',	'Luxembourg',	'2014-05-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	593.46,	593.46),  (374,	'Natural Person',	'North America',	'United States',	'2014-05-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (375,	'Natural Person',	'Europe',	'Germany',	'2014-05-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (376,	'Natural Person',	'Europe',	'Italy',	'2014-05-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (377,	'Natural Person',	'Europe',	'Germany',	'2014-05-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (378,	'Natural Person',	'Europe',	'United Kingdom',	'2014-06-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	659.4,	659.4),  (379,	'Legal entity',	'Africa',	'South Africa',	'2014-06-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	593.46,	593.46),  (380,	'Natural Person',	'Europe',	'Netherlands',	'2014-06-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	659.4,	659.4),  (381,	'Legal entity',	'North America',	'Mexico',	'2014-06-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (382,	'Natural Person',	'Europe',	'Germany',	'2014-06-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (383,	'Legal entity',	'North America',	'Honduras',	'2014-06-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (384,	'Natural Person',	'Asia',	'Indonesia',	'2014-06-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (385,	'Natural Person',	'Europe',	'Netherlands',	'2014-06-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (386,	'Legal entity',	'South America',	'Brazil',	'2014-06-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	593.46,	593.46),  (387,	'Natural Person',	'North America',	'United States',	'2014-07-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	525,	525),  (388,	'Legal entity',	'Europe',	'United Kingdom',	'2014-07-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	593.46,	593.46),  (389,	'Legal entity',	'North America',	'Guatemala',	'2014-07-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (390,	'Natural Person',	'Europe',	'Germany',	'2014-07-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (391,	'Legal entity',	'Africa',	'Angola',	'2014-07-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (392,	'Natural Person',	'South America',	'Argentina',	'2014-07-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	659.4,	659.4),  (393,	'Natural Person',	'Europe',	'Italy',	'2014-07-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.75,	336.75),  (394,	'Natural Person',	'Europe',	'Luxembourg',	'2014-07-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.25,	719.25),  (395,	'Natural Person',	'South America',	'Brazil',	'2013-02-28',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1950,	1950),  (396,	'Legal entity',	'South America',	'Argentina',	'2013-07-16',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1686.83,	1686.83),  (397,	'Legal entity',	'South America',	'Brazil',	'2013-07-29',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	9000,	9000),  (398,	'Legal entity',	'Africa',	'Uganda',	'2013-08-27',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1874.25,	1874.25),  (399,	'Natural Person',	'North America',	'United States',	'2013-10-02',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	599.99,	599.99),  (400,	'Legal entity',	'Europe',	'United Kingdom',	'2014-03-05',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1686.83,	1686.83),  (401,	'Natural Person',	'Africa',	'South Africa',	'2014-03-10',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1874.25,	1874.25),  (402,	'Legal entity',	'Europe',	'Switzerland',	'2014-03-13',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1874.25,	1874.25),  (403,	'Natural Person',	'Asia',	'Thailand',	'2013-03-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (404,	'Natural Person',	'Asia',	'Japan',	'2013-03-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	808.65,	808.65),  (405,	'public company',	'North America',	'United States',	'2013-03-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (406,	'Legal entity',	'North America',	'Dominican Republic',	'2013-04-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3000,	3000),  (407,	'Natural Person',	'North America',	'United States',	'2013-04-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	381.86,	381.86),  (408,	'Natural Person',	'Europe',	'Germany',	'2013-05-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3000,	3000),  (409,	'Natural Person',	'South America',	'Colombia',	'2013-05-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	808.65,	808.65),  (410,	'Natural Person',	'Asia',	'Indonesia',	'2013-05-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (411,	'Natural Person',	'North America',	'United States',	'2013-05-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (412,	'Natural Person',	'North America',	'United States',	'2013-06-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (413,	'Legal entity',	'South America',	'Peru',	'2013-06-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (414,	'Natural Person',	'North America',	'United States',	'2013-07-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (415,	'Natural Person',	'Asia',	'Philippines',	'2013-07-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	292.5,	292.5),  (416,	'Natural Person',	'Europe',	'Italy',	'2013-07-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (417,	'Natural Person',	'Europe',	'Spain',	'2013-07-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (418,	'Natural Person',	'Asia',	'Indonesia',	'2013-08-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (419,	'Legal entity',	'North America',	'Panama',	'2013-08-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (420,	'public company',	'Asia',	'Israel',	'2013-08-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3000,	3000),  (421,	'Legal entity',	'Asia',	'India',	'2013-09-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	299,	299),  (422,	'Natural Person',	'Europe',	'Greece',	'2013-10-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (423,	'Natural Person',	'Europe',	'Belgium',	'2013-10-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (424,	'Natural Person',	'North America',	'United States',	'2013-10-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (425,	'Natural Person',	'South America',	'Chile',	'2013-10-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (426,	'Natural Person',	'South America',	'Ecuador',	'2013-10-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (427,	'Legal entity',	'North America',	'Mexico',	'2013-10-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	441.75,	441.75),  (428,	'Natural Person',	'Europe',	'Italy',	'2013-10-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (429,	'Natural Person',	'Europe',	'Malta',	'2013-11-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (430,	'Natural Person',	'Europe',	'Romania',	'2013-11-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (431,	'Natural Person',	'Europe',	'United Kingdom',	'2013-11-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (432,	'Natural Person',	'North America',	'Panama',	'2013-11-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (433,	'Natural Person',	'South America',	'Chile',	'2013-11-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (434,	'Legal entity',	'Asia',	'Indonesia',	'2013-11-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1123.13,	1123.13),  (435,	'Natural Person',	'Europe',	'Germany',	'2013-12-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (436,	'Natural Person',	'South America',	'Chile',	'2013-12-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (437,	'Legal entity',	'South America',	'Colombia',	'2013-12-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	374.25,	374.25),  (438,	'Natural Person',	'North America',	'United States',	'2014-01-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	374.25,	374.25),  (439,	'Legal entity',	'North America',	'United States',	'2014-01-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2700,	2700),  (440,	'Natural Person',	'North America',	'United States',	'2014-01-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	374.25,	374.25),  (441,	'Legal entity',	'South America',	'Colombia',	'2014-02-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (442,	'Natural Person',	'Asia',	'Indonesia',	'2014-02-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (443,	'Natural Person',	'Asia',	'Hong Kong',	'2014-02-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.25,	314.25),  (444,	'Natural Person',	'Europe',	'France',	'2014-03-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	381.86,	381.86),  (445,	'Legal entity',	'Europe',	'Russian Federation',	'2014-03-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.25,	314.25),  (446,	'Natural Person',	'Asia',	'Hong Kong',	'2014-03-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	565.65,	565.65),  (447,	'Legal entity',	'South America',	'Paraguay',	'2014-03-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (448,	'Legal entity',	'Europe',	'Russian Federation',	'2014-03-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.25,	314.25),  (449,	'Legal entity',	'Europe',	'United Kingdom',	'2014-03-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	269.55,	269.55),  (450,	'Natural Person',	'South America',	'Venezuela',	'2014-03-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (451,	'Legal entity',	'Europe',	'Russian Federation',	'2014-04-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.25,	314.25),  (452,	'Legal entity',	'Europe',	'Italy',	'2014-04-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (453,	'Natural Person',	'Europe',	'France',	'2014-04-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (454,	'Natural Person',	'North America',	'United States',	'2014-04-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (455,	'Legal entity',	'Asia',	'Singapore',	'2014-04-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	381.86,	381.86),  (456,	'Natural Person',	'Asia',	'Singapore',	'2014-05-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (457,	'Natural Person',	'North America',	'Panama',	'2014-05-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (458,	'Legal entity',	'South America',	'Colombia',	'2014-05-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (459,	'Natural Person',	'North America',	'United States',	'2014-06-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (460,	'Natural Person',	'South America',	'Ecuador',	'2014-06-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	646.92,	646.92),  (461,	'Legal entity',	'South America',	'Ecuador',	'2014-06-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	323.46,	323.46),  (462,	'Natural Person',	'North America',	'Mexico',	'2014-06-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (463,	'Natural Person',	'North America',	'United States',	'2014-06-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (464,	'Legal entity',	'Europe',	'Greece',	'2014-06-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (465,	'Natural Person',	'South America',	'Ecuador',	'2014-07-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (466,	'Natural Person',	'South America',	'Colombia',	'2014-07-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	359.4,	359.4),  (467,	'Legal entity',	'South America',	'Chile',	'2014-07-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (470,	'Legal entity',	'North America',	'Mexico',	'2014-08-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	524.25,	524.25),  (471,	'Legal entity',	'Europe',	'United Kingdom',	'2014-08-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.55,	314.55),  (472,	'public company',	'Asia',	'Hong Kong',	'2014-09-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	12750,	12750),  (473,	'public company',	'Africa',	'South Africa',	'2014-10-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4800,	4800),  (474,	'Natural Person',	'Europe',	'United Kingdom',	'2014-04-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (475,	'Legal entity',	'Europe',	'Romania',	'2013-04-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	780,	780),  (476,	'Natural Person',	'South America',	'Brazil',	'2013-08-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	599.4,	599.4),  (477,	'Natural Person',	'Europe',	'United Kingdom',	'2013-09-03',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	749.7,	749.7),  (478,	'Legal entity',	'South America',	'Argentina',	'2013-09-16',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1499.4,	1499.4),  (479,	'Legal entity',	'Europe',	'United Kingdom',	'2013-09-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6000,	6000),  (480,	'public company',	'South America',	'Paraguay',	'2013-10-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1200,	1200),  (481,	'Legal entity',	'South America',	'Argentina',	'2014-09-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	297.6,	297.6),  (482,	'public company',	'North America',	'Guatemala',	'2014-10-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1650,	1650),  (483,	'public company',	'Europe',	'United Kingdom',	'2014-08-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3195,	3195),  (484,	'Legal entity',	'South America',	'Brazil',	'2014-09-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3553.65,	3553.65),  (485,	'Legal entity',	'Asia',	'United Arab Emirates',	'2013-09-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8070,	8070),  (486,	'Legal entity',	'South America',	'Chile',	'2014-04-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	269.55,	269.55),  (487,	'public company',	'North America',	'United States',	'2014-09-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11070,	11070),  (488,	'public company',	'Africa',	'Mali',	'2014-09-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7470,	7470),  (489,	'Legal entity',	'South America',	'Argentina',	'2014-01-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1650,	1650),  (490,	'Legal entity',	'Asia',	'Hong Kong',	'2014-08-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10320,	10320),  (491,	'Legal entity',	'South America',	'Colombia',	'2013-09-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	199,	199),  (492,	'Legal entity',	'Europe',	'Italy',	'2013-10-29',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	521.75,	521.75),  (493,	'Legal entity',	'South America',	'Argentina',	'2013-11-15',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	191.68,	191.68),  (494,	'Legal entity',	'Asia',	'Philippines',	'2013-11-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	239.2,	239.2),  (495,	'Natural Person',	'North America',	'Puerto Rico',	'2014-04-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	357.82,	357.82),  (496,	'Natural Person',	'Asia',	'Philippines',	'2014-07-23',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	284.17,	284.17),  (497,	'Natural Person',	'North America',	'United States',	'2014-07-29',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	419.4,	419.4),  (498,	'Natural Person',	'South America',	'Argentina',	'2014-07-31',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	416.18,	416.18),  (499,	'Legal entity',	'North America',	'Mexico',	'2014-08-11',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	411.12,	411.12);
INSERT INTO `comparison` VALUES (500,	'Natural Person',	'Oceania',	'Australia',	'2013-02-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (501,	'Natural Person',	'Europe',	'Sweden',	'2013-03-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (502,	'Natural Person',	'Africa',	'South Africa',	'2013-03-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	539.33,	539.33),  (503,	'Legal entity',	'South America',	'Colombia',	'2013-03-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (504,	'Natural Person',	'Asia',	'Japan',	'2013-03-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (505,	'Legal entity',	'Europe',	'Spain',	'2013-04-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (506,	'Natural Person',	'Europe',	'Germany',	'2013-04-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (507,	'Natural Person',	'Africa',	'Tunisia',	'2013-05-04',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (508,	'Legal entity',	'Africa',	'South Africa',	'2013-05-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (509,	'Legal entity',	'North America',	'Mexico',	'2013-05-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (510,	'Legal entity',	'Europe',	'Bosnia and Herzegovina',	'2013-05-21',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (511,	'Legal entity',	'Asia',	'Saudi Arabia',	'2013-06-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (512,	'Legal entity',	'Asia',	'India',	'2013-06-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (513,	'Natural Person',	'South America',	'Colombia',	'2013-07-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (514,	'Natural Person',	'North America',	'United States',	'2013-07-21',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (515,	'Natural Person',	'Europe',	'Spain',	'2013-07-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (516,	'Natural Person',	'Europe',	'United Kingdom',	'2013-08-22',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (517,	'Natural Person',	'Asia',	'Saudi Arabia',	'2013-08-26',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (518,	'Natural Person',	'North America',	'United States',	'2013-08-31',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (519,	'Natural Person',	'Asia',	'Qatar',	'2013-09-05',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (520,	'Natural Person',	'North America',	'Canada',	'2013-09-08',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (521,	'Natural Person',	'Europe',	'Italy',	'2013-09-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (522,	'Natural Person',	'Europe',	'Italy',	'2013-09-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (523,	'Legal entity',	'South America',	'Chile',	'2013-09-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (524,	'Legal entity',	'South America',	'Chile',	'2013-09-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (525,	'Legal entity',	'North America',	'Barbados',	'2013-10-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (526,	'Natural Person',	'Europe',	'Italy',	'2013-10-21',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (527,	'Legal entity',	'Asia',	'Jordan',	'2013-10-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	539.33,	539.33),  (528,	'Legal entity',	'South America',	'Paraguay',	'2013-10-27',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (529,	'Natural Person',	'Europe',	'France',	'2013-10-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (530,	'Natural Person',	'Asia',	'Thailand',	'2013-11-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	199,	199),  (531,	'Natural Person',	'Europe',	'Spain',	'2013-11-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (532,	'Natural Person',	'Europe',	'France',	'2013-11-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (533,	'Natural Person',	'Europe',	'Greece',	'2013-11-24',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (534,	'Natural Person',	'Asia',	'India',	'2013-11-25',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	199,	199),  (535,	'Natural Person',	'North America',	'United States',	'2013-12-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (536,	'Natural Person',	'Europe',	'Romania',	'2013-12-11',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (537,	'Natural Person',	'South America',	'Ecuador',	'2013-12-21',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (538,	'Natural Person',	'Asia',	'Singapore',	'2013-12-25',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (539,	'Legal entity',	'Europe',	'Italy',	'2013-12-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (540,	'Natural Person',	'Asia',	'Malaysia',	'2014-01-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	199,	199),  (541,	'Natural Person',	'Asia',	'Hong Kong',	'2014-02-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (542,	'Natural Person',	'Oceania',	'Australia',	'2014-02-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (543,	'Natural Person',	'Asia',	'Indonesia',	'2014-02-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (544,	'Legal entity',	'Europe',	'Italy',	'2014-02-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (545,	'Natural Person',	'North America',	'United States',	'2014-03-01',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (546,	'Legal entity',	'Europe',	'United Kingdom',	'2014-03-04',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	539.33,	539.33),  (547,	'Natural Person',	'Europe',	'Belgium',	'2014-04-06',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (548,	'Natural Person',	'Asia',	'Indonesia',	'2014-04-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (549,	'Natural Person',	'North America',	'Mexico',	'2014-04-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (550,	'Natural Person',	'North America',	'United States',	'2014-05-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (551,	'Natural Person',	'North America',	'Canada',	'2014-06-09',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	479.4,	479.4),  (552,	'Natural Person',	'South America',	'Argentina',	'2014-06-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (553,	'Natural Person',	'Europe',	'Norway',	'2014-06-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (554,	'Legal entity',	'Asia',	'Oman',	'2014-07-06',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (555,	'Natural Person',	'Europe',	'Switzerland',	'2014-07-12',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (556,	'Natural Person',	'North America',	'United States',	'2014-07-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	261.75,	261.75),  (557,	'Natural Person',	'North America',	'Bahamas',	'2014-07-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	599.25,	599.25),  (558,	'Legal entity',	'Europe',	'Italy',	'2014-10-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (559,	'Natural Person',	'South America',	'Brazil',	'2013-06-29',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	599.25,	599.25),  (560,	'Natural Person',	'Europe',	'France',	'2013-11-09',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	261.75,	261.75),  (561,	'Legal entity',	'North America',	'United States',	'2013-12-26',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	261.75,	261.75),  (562,	'Natural Person',	'South America',	'Argentina',	'2014-04-16',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	539.33,	539.33),  (563,	'Natural Person',	'North America',	'Panama',	'2013-08-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	45,	45),  (564,	'Natural Person',	'Europe',	'Italy',	'2013-08-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	45,	45),  (565,	'Natural Person',	'Asia',	'Indonesia',	'2014-07-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (566,	'Legal entity',	'Asia',	'Indonesia',	'2014-03-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3555,	3555),  (567,	'Natural Person',	'Europe',	'Spain',	'2013-09-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	239.6,	239.6),  (568,	'Legal entity',	'North America',	'Puerto Rico',	'2014-02-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	239.6,	239.6),  (569,	'Natural Person',	'North America',	'Costa Rica',	'2014-02-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	269.55,	269.55),  (570,	'Natural Person',	'Asia',	'India',	'2014-02-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	167.6,	167.6),  (571,	'Legal entity',	'North America',	'Panama',	'2014-04-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	449.25,	449.25),  (572,	'Natural Person',	'South America',	'Chile',	'2014-10-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	254.48,	254.48),  (573,	'Natural Person',	'Asia',	'Singapore',	'2013-07-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	139.6,	139.6),  (574,	'Natural Person',	'Europe',	'Germany',	'2013-10-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	179.6,	179.6),  (575,	'Natural Person',	'North America',	'United States',	'2014-01-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	159.6,	159.6),  (576,	'Legal entity',	'South America',	'Brazil',	'2014-05-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1078.92,	1078.92),  (577,	'Natural Person',	'Europe',	'Germany',	'2013-06-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	419.48,	419.48),  (578,	'Legal entity',	'South America',	'Brazil',	'2014-08-28',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	2732.06,	2732.06),  (579,	'Legal entity',	'Europe',	'Italy',	'2014-10-20',	'2.4 Sports and Outdoors',	'TrailBlazer Outdoor Adventure Backpack',	1,	38.25,	38.25),  (580,	'Natural Person',	'Europe',	'Latvia',	'2013-08-11',	'2.4 Sports and Outdoors',	'AeroFlex High-Performance Running Shoes',	1,	100,	100),  (581,	'Natural Person',	'Europe',	'Belgium',	'2013-09-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	199,	199),  (582,	'Natural Person',	'Europe',	'Italy',	'2013-10-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	49,	49),  (583,	'public company',	'Asia',	'China',	'2014-08-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (585,	'public company',	'Africa',	'Senegal',	'2014-08-26',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	446.02,	446.02),  (586,	'public company',	'Europe',	'Germany',	'2014-10-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	198.23,	198.23),  (587,	'public company',	'Europe',	'France',	'2014-10-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	727.31,	727.31),  (588,	'Legal entity',	'South America',	'Paraguay',	'2014-09-09',	'2.1 Books and Stationery',	'SketchSync Artists Sketchbook',	1,	2700,	2700),  (589,	'public company',	'Europe',	'Italy',	'2014-10-06',	'2.1 Books and Stationery',	'SketchSync Artists Sketchbook',	1,	11250,	11250),  (590,	'Natural Person',	'Africa',	'South Africa',	'2014-09-11',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	525,	525),  (591,	'Natural Person',	'Europe',	'Switzerland',	'2014-09-12',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	539.55,	539.55),  (592,	'Natural Person',	'Europe',	'Spain',	'2014-09-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	539.55,	539.55),  (593,	'Natural Person',	'Asia',	'Indonesia',	'2014-09-18',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	485.59,	485.59),  (594,	'Natural Person',	'South America',	'Brazil',	'2014-10-29',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	539.55,	539.55),  (595,	'Natural Person',	'South America',	'Brazil',	'2014-11-28',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	323.85,	323.85),  (596,	'Natural Person',	'Europe',	'United Kingdom',	'2014-12-05',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	324.03,	324.03),  (597,	'Natural Person',	'Europe',	'United Kingdom',	'2015-02-03',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	291.23,	291.23),  (598,	'Natural Person',	'North America',	'United States',	'2015-03-02',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	361.6,	361.6),  (599,	'Legal entity',	'South America',	'Brazil',	'2015-04-28',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	288.06,	288.06),  (600,	'Natural Person',	'Europe',	'Spain',	'2015-09-17',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	410.06,	410.06),  (601,	'Natural Person',	'Africa',	'South Africa',	'2015-11-11',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	431.79,	431.79),  (602,	'Natural Person',	'Europe',	'Netherlands',	'2015-11-13',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	359.7,	359.7),  (603,	'Natural Person',	'South America',	'Brazil',	'2015-11-29',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	287.76,	287.76),  (604,	'Natural Person',	'Europe',	'United Kingdom',	'2015-12-04',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	242.73,	242.73),  (605,	'Legal entity',	'Europe',	'Spain',	'2014-11-17',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	4275,	4275),  (606,	'Legal entity',	'Europe',	'United Kingdom',	'2015-02-06',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	7920,	7920),  (607,	'Legal entity',	'Europe',	'United Kingdom',	'2015-03-05',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	4500,	4500),  (608,	'Legal entity',	'Europe',	'United Kingdom',	'2015-04-06',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	2700,	2700),  (609,	'Legal entity',	'South America',	'Brazil',	'2015-04-30',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	2160,	2160),  (610,	'Legal entity',	'Europe',	'France',	'2015-10-08',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	2160,	2160),  (611,	'Legal entity',	'South America',	'Argentina',	'2015-11-16',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	4950,	4950),  (612,	'Natural Person',	'Europe',	'United Kingdom',	'2015-12-03',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	1620,	1620),  (613,	'Legal entity',	'North America',	'Canada',	'2014-10-09',	'2.3 Beauty and Personal Care',	'VelvetTouch Luxury Hair Brush',	1,	6120,	6120),  (614,	'Legal entity',	'Europe',	'United Kingdom',	'2014-08-06',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2400,	2400),  (615,	'Natural Person',	'Asia',	'Bangladesh',	'2014-08-20',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1050,	1050),  (616,	'Legal entity',	'North America',	'Panama',	'2014-08-25',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1350,	1350),  (617,	'Legal entity',	'Africa',	'South Africa',	'2014-09-10',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1229.55,	1229.55),  (618,	'Natural Person',	'Europe',	'United Kingdom',	'2014-10-03',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1215,	1215),  (619,	'Legal entity',	'Europe',	'France',	'2014-10-08',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1215,	1215),  (620,	'Legal entity',	'South America',	'Brazil',	'2014-10-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1215,	1215),  (621,	'Legal entity',	'Europe',	'United Kingdom',	'2014-11-05',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1350,	1350),  (622,	'Legal entity',	'South America',	'Uruguay',	'2014-11-27',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1124.25,	1124.25),  (623,	'Natural Person',	'North America',	'United States',	'2014-12-01',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	769.5,	769.5),  (624,	'Natural Person',	'Europe',	'United Kingdom',	'2014-12-03',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	810,	810),  (625,	'Legal entity',	'North America',	'Canada',	'2014-12-09',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1350,	1350),  (626,	'Legal entity',	'Africa',	'Algeria',	'2014-12-19',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	5400,	5400),  (627,	'Legal entity',	'Europe',	'Switzerland',	'2015-01-13',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1215,	1215),  (628,	'Natural Person',	'South America',	'Argentina',	'2015-01-16',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	675,	675),  (629,	'Legal entity',	'North America',	'Canada',	'2015-02-09',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3645,	3645),  (630,	'Legal entity',	'Africa',	'South Africa',	'2015-02-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	810,	810),  (631,	'Legal entity',	'Africa',	'Libyan Arab Jamahiriya',	'2015-02-24',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	810,	810),  (632,	'Natural Person',	'Asia',	'Qatar',	'2015-02-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	729,	729),  (633,	'Natural Person',	'Africa',	'South Africa',	'2015-03-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	900,	900),  (634,	'Natural Person',	'Europe',	'Switzerland',	'2015-03-12',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	900,	900),  (635,	'Natural Person',	'Asia',	'Qatar',	'2015-03-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	675,	675),  (636,	'Legal entity',	'Africa',	'South Africa',	'2015-04-10',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	900,	900),  (637,	'Natural Person',	'Europe',	'Netherlands',	'2015-04-14',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	824.25,	824.25),  (638,	'Natural Person',	'Asia',	'Thailand',	'2015-04-27',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	750,	750),  (639,	'Legal entity',	'South America',	'Brazil',	'2015-04-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1080,	1080),  (640,	'Natural Person',	'Europe',	'United Kingdom',	'2015-05-04',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	525,	525),  (641,	'Natural Person',	'Africa',	'South Africa',	'2015-05-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	648,	648),  (642,	'Natural Person',	'Asia',	'Hong Kong',	'2015-05-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	450,	450),  (643,	'Natural Person',	'Asia',	'Hong Kong',	'2015-05-19',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	972,	972),  (644,	'Legal entity',	'South America',	'Brazil',	'2015-05-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	720,	720),  (645,	'Legal entity',	'South America',	'Brazil',	'2015-05-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1080,	1080),  (646,	'Legal entity',	'Africa',	'South Africa',	'2015-06-10',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	864,	864),  (647,	'Natural Person',	'Asia',	'Hong Kong',	'2015-06-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	720,	720),  (648,	'Legal entity',	'South America',	'Argentina',	'2015-06-16',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1080,	1080),  (649,	'Legal entity',	'Europe',	'France',	'2015-07-08',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	614.78,	614.78),  (650,	'Legal entity',	'Europe',	'Netherlands',	'2015-07-13',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	720,	720),  (651,	'Legal entity',	'South America',	'Brazil',	'2015-07-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	540,	540),  (652,	'Legal entity',	'Europe',	'France',	'2015-08-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	874.5,	874.5),  (653,	'Natural Person',	'Europe',	'Germany',	'2015-09-01',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1080,	1080),  (654,	'Legal entity',	'North America',	'United States',	'2015-09-02',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1440,	1440),  (655,	'Legal entity',	'North America',	'Panama',	'2015-09-25',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	972,	972),  (656,	'Legal entity',	'Asia',	'Hong Kong',	'2015-10-14',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	972,	972),  (657,	'Legal entity',	'Asia',	'Singapore',	'2015-10-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1215,	1215),  (658,	'Legal entity',	'Asia',	'Singapore',	'2015-11-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	810,	810),  (659,	'Natural Person',	'South America',	'Uruguay',	'2015-11-27',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	540,	540),  (660,	'Legal entity',	'South America',	'Brazil',	'2015-11-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	810,	810),  (661,	'Natural Person',	'Asia',	'Indonesia',	'2016-01-19',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1012.5,	1012.5),  (662,	'Natural Person',	'Europe',	'Italy',	'2014-09-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	561,	561),  (663,	'Natural Person',	'North America',	'Mexico',	'2014-11-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.58,	508.58),  (664,	'Natural Person',	'South America',	'Colombia',	'2014-11-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	336.6,	336.6),  (665,	'Natural Person',	'North America',	'United States',	'2014-12-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	336.6,	336.6),  (666,	'Natural Person',	'North America',	'United States',	'2015-01-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	504.9,	504.9),  (667,	'Natural Person',	'North America',	'Canada',	'2015-03-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	886.04,	886.04),  (668,	'Legal entity',	'Asia',	'Saudi Arabia',	'2015-05-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.58,	508.58),  (669,	'Legal entity',	'Europe',	'Germany',	'2015-03-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.58,	508.58),  (670,	'Natural Person',	'Europe',	'Spain',	'2015-04-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	457.72,	457.72),  (671,	'Legal entity',	'South America',	'Chile',	'2015-04-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	508.58,	508.58),  (672,	'Legal entity',	'Africa',	'Egypt',	'2015-04-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	3746.25,	3746.25),  (673,	'Natural Person',	'Asia',	'Philippines',	'2015-04-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	396.15,	396.15),  (674,	'Natural Person',	'South America',	'Ecuador',	'2015-05-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	448.8,	448.8),  (675,	'Natural Person',	'South America',	'Paraguay',	'2015-06-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (676,	'Natural Person',	'North America',	'United States',	'2015-06-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (677,	'Natural Person',	'South America',	'Chile',	'2015-07-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (678,	'Legal entity',	'South America',	'Ecuador',	'2015-07-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	486,	486),  (679,	'Natural Person',	'Asia',	'India',	'2015-09-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	246.45,	246.45),  (680,	'Natural Person',	'South America',	'Ecuador',	'2015-09-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	403.73,	403.73),  (681,	'Natural Person',	'North America',	'United States',	'2015-10-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	456.15,	456.15),  (682,	'Natural Person',	'South America',	'Peru',	'2015-10-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	403.73,	403.73),  (683,	'Legal entity',	'Africa',	'Cameroon',	'2015-10-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1829.69,	1829.69),  (684,	'Natural Person',	'North America',	'El Salvador',	'2015-10-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	708.83,	708.83),  (685,	'Natural Person',	'Asia',	'Malaysia',	'2015-11-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	860.63,	860.63),  (686,	'Natural Person',	'Europe',	'Italy',	'2015-12-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1017.9,	1017.9),  (687,	'Natural Person',	'South America',	'Colombia',	'2015-12-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299.25,	299.25),  (688,	'Natural Person',	'Europe',	'Switzerland',	'2016-01-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1017.9,	1017.9),  (689,	'Natural Person',	'Europe',	'Italy',	'2016-01-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	478.8,	478.8),  (690,	'Natural Person',	'Asia',	'Malaysia',	'2014-10-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1460.4,	1460.4),  (691,	'Natural Person',	'North America',	'United States',	'2014-10-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	916.04,	916.04),  (692,	'Legal entity',	'South America',	'Peru',	'2015-03-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	538.58,	538.58),  (693,	'Natural Person',	'North America',	'United States',	'2015-06-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	516,	516),  (694,	'Natural Person',	'South America',	'Colombia',	'2015-07-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1189.88,	1189.88),  (695,	'Legal entity',	'North America',	'Mexico',	'2015-08-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	516,	516),  (696,	'Natural Person',	'North America',	'United States',	'2015-08-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	516,	516),  (697,	'public company',	'Asia',	'Bangladesh',	'2015-08-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	7995,	7995),  (698,	'Natural Person',	'North America',	'United States',	'2015-09-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	821.67,	821.67),  (699,	'Natural Person',	'South America',	'Chile',	'2015-10-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	433.73,	433.73),  (700,	'Legal entity',	'North America',	'United States',	'2015-12-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	336.75,	336.75),  (701,	'Natural Person',	'North America',	'United States',	'2014-07-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1092.9,	1092.9),  (702,	'Natural Person',	'Africa',	'Cameroon',	'2014-11-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1942.19,	1942.19),  (703,	'Natural Person',	'Asia',	'Malaysia',	'2014-11-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1066.13,	1066.13),  (704,	'Natural Person',	'Europe',	'Switzerland',	'2014-11-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	998.54,	998.54),  (705,	'Legal entity',	'North America',	'United States',	'2014-12-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	404.1,	404.1),  (706,	'Legal entity',	'Europe',	'Austria',	'2014-12-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	673.5,	673.5),  (707,	'Natural Person',	'South America',	'Colombia',	'2014-12-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	998.54,	998.54),  (708,	'Legal entity',	'Europe',	'Spain',	'2014-12-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	606.15,	606.15),  (709,	'Natural Person',	'North America',	'United States',	'2015-01-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	606.15,	606.15),  (710,	'Legal entity',	'North America',	'Nicaragua',	'2015-02-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1313.89,	1313.89),  (711,	'Legal entity',	'Europe',	'Germany',	'2015-02-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	606.15,	606.15),  (712,	'Legal entity',	'Asia',	'Malaysia',	'2015-02-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1271.25,	1271.25),  (713,	'Legal entity',	'North America',	'United States',	'2015-03-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	848.75,	848.75),  (714,	'Legal entity',	'Europe',	'United Kingdom',	'2015-03-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1328.25,	1328.25),  (715,	'Natural Person',	'Europe',	'Spain',	'2015-03-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1942.19,	1942.19),  (716,	'Legal entity',	'Africa',	'Namibia',	'2015-03-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	983.33,	983.33),  (717,	'Legal entity',	'Europe',	'United Kingdom',	'2015-05-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	538.8,	538.8),  (718,	'Legal entity',	'North America',	'United States',	'2015-05-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	874.32,	874.32),  (719,	'public company',	'Europe',	'Germany',	'2015-07-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	5820,	5820),  (720,	'Legal entity',	'South America',	'Paraguay',	'2015-07-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	598.5,	598.5),  (721,	'Natural Person',	'South America',	'Colombia',	'2015-07-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1272.38,	1272.38),  (722,	'Natural Person',	'South America',	'Paraguay',	'2015-07-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	957.9,	957.9),  (723,	'public company',	'Europe',	'Spain',	'2015-08-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	5325,	5325),  (724,	'Natural Person',	'North America',	'Panama',	'2015-08-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	516.23,	516.23),  (725,	'Natural Person',	'North America',	'United States',	'2015-08-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	598.5,	598.5),  (726,	'public company',	'Europe',	'United Kingdom',	'2015-09-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	12375,	12375),  (727,	'public company',	'South America',	'Brazil',	'2015-09-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	23175,	23175),  (728,	'Legal entity',	'Europe',	'Finland',	'2015-10-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	598.5,	598.5),  (729,	'public company',	'Asia',	'Hong Kong',	'2015-10-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	11970,	11970),  (730,	'Natural Person',	'Europe',	'Netherlands',	'2015-10-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	568.65,	568.65),  (731,	'Legal entity',	'South America',	'Peru',	'2015-10-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1543.76,	1543.76),  (732,	'Natural Person',	'North America',	'United States',	'2015-10-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	848.75,	848.75),  (733,	'Legal entity',	'North America',	'United States',	'2015-11-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	493.41,	493.41),  (734,	'Legal entity',	'North America',	'United States',	'2015-11-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	673.5,	673.5),  (735,	'Natural Person',	'Africa',	'Cameroon',	'2015-11-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2216.4,	2216.4),  (736,	'public company',	'Europe',	'Latvia',	'2015-12-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	5992.5,	5992.5),  (737,	'Natural Person',	'North America',	'United States',	'2016-01-26',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	839.96,	839.96),  (738,	'Legal entity',	'Asia',	'Hong Kong',	'2014-08-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2475,	2475),  (739,	'Legal entity',	'Europe',	'Netherlands',	'2015-05-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1980,	1980),  (740,	'public company',	'Europe',	'Switzerland',	'2015-06-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2475,	2475),  (741,	'public company',	'South America',	'Argentina',	'2015-06-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4800,	4800),  (742,	'public company',	'Asia',	'Iraq',	'2015-06-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5400,	5400),  (743,	'Legal entity',	'Asia',	'Hong Kong',	'2015-08-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1320,	1320),  (744,	'public company',	'South America',	'Argentina',	'2015-12-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6000,	6000),  (745,	'public company',	'Europe',	'Russian Federation',	'2017-05-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7425,	7425),  (746,	'Natural Person',	'Africa',	'Uganda',	'2014-07-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	899.25,	899.25),  (747,	'Natural Person',	'Europe',	'United Kingdom',	'2014-08-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	899.25,	899.25),  (748,	'Natural Person',	'Asia',	'Philippines',	'2014-08-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (749,	'Natural Person',	'Europe',	'Italy',	'2014-08-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (750,	'Natural Person',	'South America',	'Argentina',	'2014-08-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	899.25,	899.25),  (751,	'Natural Person',	'Asia',	'India',	'2014-08-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (752,	'Natural Person',	'Europe',	'Austria',	'2014-08-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (753,	'Natural Person',	'Europe',	'Czech Republic',	'2014-08-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (754,	'Natural Person',	'Europe',	'United Kingdom',	'2014-09-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (755,	'Natural Person',	'Europe',	'Italy',	'2014-09-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (756,	'Natural Person',	'Europe',	'Germany',	'2014-09-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (757,	'Natural Person',	'Europe',	'France',	'2014-09-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (758,	'Natural Person',	'North America',	'Panama',	'2014-09-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (759,	'Natural Person',	'South America',	'Ecuador',	'2014-10-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (760,	'Natural Person',	'Europe',	'Germany',	'2014-10-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (761,	'Natural Person',	'North America',	'Mexico',	'2014-10-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (762,	'Legal entity',	'Europe',	'United Kingdom',	'2014-11-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (763,	'Legal entity',	'North America',	'Mexico',	'2014-11-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (764,	'Natural Person',	'Europe',	'Switzerland',	'2014-11-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (765,	'Legal entity',	'Asia',	'Indonesia',	'2014-11-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (766,	'Natural Person',	'Europe',	'Belgium',	'2014-11-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (767,	'Natural Person',	'South America',	'Ecuador',	'2014-11-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (768,	'Natural Person',	'Asia',	'United Arab Emirates',	'2014-11-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (769,	'Legal entity',	'South America',	'Colombia',	'2014-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (770,	'Natural Person',	'South America',	'Paraguay',	'2014-12-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (771,	'public company',	'Asia',	'Indonesia',	'2014-12-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (772,	'Natural Person',	'Europe',	'Greece',	'2014-12-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (773,	'Natural Person',	'Africa',	'South Africa',	'2014-12-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (774,	'Legal entity',	'South America',	'Colombia',	'2014-12-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (775,	'Natural Person',	'Europe',	'United Kingdom',	'2015-01-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (776,	'Natural Person',	'Europe',	'Italy',	'2015-01-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (777,	'Legal entity',	'Europe',	'France',	'2015-01-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (778,	'Natural Person',	'North America',	'Canada',	'2015-01-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (779,	'Legal entity',	'North America',	'Guatemala',	'2015-01-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (780,	'Natural Person',	'South America',	'Bolivia',	'2015-01-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (781,	'Natural Person',	'North America',	'United States',	'2015-01-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (782,	'Legal entity',	'Europe',	'Italy',	'2015-01-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (783,	'Natural Person',	'Europe',	'Germany',	'2015-01-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (784,	'Natural Person',	'North America',	'United States',	'2015-02-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (785,	'Legal entity',	'South America',	'Colombia',	'2015-02-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (786,	'Natural Person',	'Asia',	'Indonesia',	'2015-02-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (787,	'Legal entity',	'Africa',	'Angola',	'2015-02-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (788,	'Natural Person',	'Europe',	'Spain',	'2015-02-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (789,	'Legal entity',	'North America',	'United States',	'2015-02-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (790,	'Natural Person',	'Asia',	'Singapore',	'2015-03-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (791,	'Legal entity',	'South America',	'Ecuador',	'2015-03-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (792,	'Natural Person',	'South America',	'Ecuador',	'2015-03-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (793,	'Natural Person',	'Europe',	'Italy',	'2015-03-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (794,	'Natural Person',	'Europe',	'Switzerland',	'2015-03-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (795,	'Natural Person',	'Africa',	'South Africa',	'2015-03-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (796,	'Natural Person',	'Asia',	'Indonesia',	'2015-03-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.75,	261.75),  (797,	'Natural Person',	'Europe',	'Italy',	'2015-03-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (798,	'Natural Person',	'Asia',	'Israel',	'2015-03-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (799,	'Natural Person',	'Asia',	'Kuwait',	'2015-04-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (800,	'Legal entity',	'Europe',	'Spain',	'2015-04-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (801,	'Natural Person',	'North America',	'United States',	'2015-04-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (802,	'Natural Person',	'Europe',	'France',	'2015-04-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (803,	'Natural Person',	'Europe',	'Romania',	'2015-04-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (804,	'Natural Person',	'Europe',	'United Kingdom',	'2015-05-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (805,	'Natural Person',	'North America',	'United States',	'2015-05-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (806,	'Natural Person',	'Europe',	'Spain',	'2015-05-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (807,	'Legal entity',	'Africa',	'Botswana',	'2015-05-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (808,	'Natural Person',	'Asia',	'Hong Kong',	'2015-05-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (809,	'Natural Person',	'South America',	'Colombia',	'2015-05-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (810,	'Natural Person',	'Europe',	'Hungary',	'2015-05-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (811,	'Natural Person',	'Oceania',	'Australia',	'2015-05-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (812,	'Natural Person',	'South America',	'Paraguay',	'2015-06-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (813,	'Legal entity',	'South America',	'Colombia',	'2015-05-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (814,	'Natural Person',	'North America',	'United States',	'2015-06-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (815,	'Legal entity',	'North America',	'Mexico',	'2015-06-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (816,	'Natural Person',	'Europe',	'France',	'2015-06-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	647.46,	647.46),  (817,	'Natural Person',	'North America',	'United States',	'2015-06-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (818,	'Natural Person',	'Europe',	'France',	'2015-06-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (819,	'Natural Person',	'Oceania',	'Australia',	'2015-06-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (820,	'Natural Person',	'Asia',	'Indonesia',	'2015-06-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (821,	'Natural Person',	'South America',	'Argentina',	'2015-06-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (822,	'Natural Person',	'North America',	'United States',	'2015-06-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (823,	'Legal entity',	'North America',	'United States',	'2015-06-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (824,	'Natural Person',	'Asia',	'Thailand',	'2015-06-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (825,	'Natural Person',	'South America',	'Colombia',	'2015-06-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	254.36,	254.36),  (826,	'Natural Person',	'Europe',	'Italy',	'2015-06-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (827,	'Natural Person',	'North America',	'Mexico',	'2015-06-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (828,	'Natural Person',	'South America',	'Brazil',	'2015-06-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	287.76,	287.76),  (829,	'Legal entity',	'North America',	'United States',	'2015-07-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (830,	'Natural Person',	'Europe',	'Germany',	'2015-07-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (831,	'Legal entity',	'Europe',	'Spain',	'2015-07-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	254.36,	254.36),  (832,	'Natural Person',	'North America',	'United States',	'2015-07-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (833,	'Natural Person',	'North America',	'Mexico',	'2015-07-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (834,	'Natural Person',	'North America',	'United States',	'2015-07-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (835,	'Natural Person',	'Europe',	'Germany',	'2015-07-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (836,	'Natural Person',	'Europe',	'Netherlands',	'2015-07-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (837,	'Legal entity',	'Europe',	'Romania',	'2015-07-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (838,	'Legal entity',	'Europe',	'Germany',	'2015-07-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (839,	'Natural Person',	'North America',	'United States',	'2015-07-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (840,	'Natural Person',	'Europe',	'Germany',	'2015-08-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (841,	'Natural Person',	'Asia',	'Hong Kong',	'2015-08-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (842,	'Natural Person',	'North America',	'United States',	'2015-08-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (843,	'Legal entity',	'Europe',	'France',	'2015-08-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	647.46,	647.46),  (844,	'Natural Person',	'Africa',	'South Africa',	'2015-08-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	647.46,	647.46),  (845,	'Natural Person',	'Africa',	'South Africa',	'2015-08-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (846,	'Natural Person',	'North America',	'Mexico',	'2015-08-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (847,	'Natural Person',	'North America',	'United States',	'2015-08-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (848,	'Legal entity',	'South America',	'Colombia',	'2015-08-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	269.33,	269.33),  (849,	'Legal entity',	'Europe',	'Portugal',	'2015-08-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (850,	'Natural Person',	'Europe',	'United Kingdom',	'2015-08-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (851,	'Natural Person',	'Asia',	'Malaysia',	'2015-08-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (852,	'Natural Person',	'Europe',	'France',	'2015-08-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (853,	'Legal entity',	'South America',	'Colombia',	'2015-08-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (854,	'Natural Person',	'Europe',	'Italy',	'2015-08-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (855,	'Legal entity',	'North America',	'Costa Rica',	'2015-08-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (856,	'Legal entity',	'Asia',	'Indonesia',	'2015-09-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	199.6,	199.6),  (857,	'Natural Person',	'Asia',	'Indonesia',	'2015-09-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	199.6,	199.6),  (858,	'Natural Person',	'South America',	'Colombia',	'2015-09-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (859,	'Natural Person',	'Asia',	'Thailand',	'2015-09-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	199.6,	199.6),  (860,	'Natural Person',	'Africa',	'South Africa',	'2015-09-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (861,	'Natural Person',	'Europe',	'Germany',	'2015-09-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (862,	'Natural Person',	'Europe',	'United Kingdom',	'2015-09-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (863,	'Natural Person',	'North America',	'Mexico',	'2015-09-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (864,	'Natural Person',	'Asia',	'Indonesia',	'2015-09-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	199.6,	199.6),  (865,	'Natural Person',	'Asia',	'Indonesia',	'2015-09-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (866,	'Legal entity',	'Asia',	'Saudi Arabia',	'2015-09-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.25,	299.25),  (867,	'Natural Person',	'North America',	'Mexico',	'2015-09-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (868,	'Natural Person',	'North America',	'Jamaica',	'2015-09-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	647.33,	647.33),  (869,	'Natural Person',	'Africa',	'Sierra Leone',	'2015-09-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	719.4,	719.4),  (870,	'Natural Person',	'North America',	'Canada',	'2015-10-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (871,	'Legal entity',	'Asia',	'Malaysia',	'2015-10-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	199.6,	199.6),  (872,	'Legal entity',	'Asia',	'India',	'2015-10-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	189.62,	189.62),  (873,	'Natural Person',	'North America',	'Costa Rica',	'2015-10-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (874,	'Natural Person',	'Asia',	'Lebanon',	'2015-10-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (875,	'Natural Person',	'North America',	'United States',	'2015-10-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (876,	'Natural Person',	'Europe',	'United Kingdom',	'2015-10-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (877,	'Legal entity',	'North America',	'Canada',	'2015-10-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (878,	'Natural Person',	'Asia',	'Thailand',	'2015-10-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	199.6,	199.6),  (879,	'Natural Person',	'Europe',	'Czech Republic',	'2015-10-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (880,	'Natural Person',	'Asia',	'Jordan',	'2015-10-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (881,	'Natural Person',	'Oceania',	'Australia',	'2015-10-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (882,	'Legal entity',	'Europe',	'Spain',	'2015-10-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	269.46,	269.46),  (883,	'Natural Person',	'North America',	'United States',	'2015-11-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (884,	'Natural Person',	'North America',	'United States',	'2015-11-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (885,	'Legal entity',	'Europe',	'Netherlands',	'2015-11-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (886,	'Legal entity',	'South America',	'Colombia',	'2015-11-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (887,	'Legal entity',	'Europe',	'Spain',	'2015-11-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	336.83,	336.83),  (888,	'Natural Person',	'Asia',	'Hong Kong',	'2015-11-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.33,	809.33),  (889,	'Legal entity',	'Asia',	'Indonesia',	'2015-11-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (890,	'Natural Person',	'Asia',	'Afghanistan',	'2015-11-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	728.39,	728.39),  (891,	'Natural Person',	'Asia',	'Afghanistan',	'2015-11-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (892,	'Natural Person',	'North America',	'United States',	'2015-11-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	249.5,	249.5),  (893,	'Legal entity',	'North America',	'United States',	'2015-12-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	539.55,	539.55),  (894,	'Natural Person',	'Asia',	'Turkey',	'2015-12-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (895,	'Natural Person',	'Asia',	'Malaysia',	'2015-12-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (896,	'Legal entity',	'Asia',	'Hong Kong',	'2015-12-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	809.25,	809.25),  (897,	'Natural Person',	'South America',	'Colombia',	'2015-12-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (898,	'Legal entity',	'Asia',	'Indonesia',	'2015-12-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (899,	'Natural Person',	'Asia',	'India',	'2016-01-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (900,	'Natural Person',	'North America',	'United States',	'2016-01-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	318.11,	318.11),  (901,	'Natural Person',	'Africa',	'South Africa',	'2016-01-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	910.58,	910.58),  (902,	'Natural Person',	'North America',	'El Salvador',	'2016-01-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (903,	'Legal entity',	'Europe',	'Switzerland',	'2016-01-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	750,	750),  (904,	'Natural Person',	'Europe',	'France',	'2016-01-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (905,	'Natural Person',	'Asia',	'Hong Kong',	'2016-01-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	859.99,	859.99),  (906,	'Natural Person',	'North America',	'United States',	'2016-01-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	299.4,	299.4),  (907,	'Legal entity',	'Asia',	'Lebanon',	'2016-01-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	773.99,	773.99),  (908,	'Natural Person',	'North America',	'United States',	'2016-01-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (909,	'Natural Person',	'Oceania',	'Australia',	'2016-01-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (910,	'Natural Person',	'North America',	'United States',	'2016-01-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (911,	'Natural Person',	'Europe',	'United Kingdom',	'2016-01-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	261.98,	261.98),  (912,	'Legal entity',	'North America',	'Mexico',	'2017-05-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	374.25,	374.25),  (913,	'Legal entity',	'Europe',	'Spain',	'2014-10-17',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1500,	1500),  (914,	'Natural Person',	'Europe',	'United Kingdom',	'2015-01-05',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1350,	1350),  (915,	'Natural Person',	'Asia',	'Thailand',	'2015-03-27',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1425.75,	1425.75),  (916,	'Legal entity',	'Europe',	'Germany',	'2015-04-01',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	4556.25,	4556.25),  (917,	'Legal entity',	'South America',	'Colombia',	'2014-08-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	524.25,	524.25),  (918,	'Legal entity',	'North America',	'Puerto Rico',	'2014-09-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	524.25,	524.25),  (919,	'Legal entity',	'Asia',	'Indonesia',	'2014-10-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.75,	366.75),  (920,	'Natural Person',	'Asia',	'Hong Kong',	'2014-10-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.75,	366.75),  (921,	'Natural Person',	'Europe',	'Belgium',	'2014-11-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (922,	'Legal entity',	'Africa',	'Cameroon',	'2014-11-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.75,	366.75),  (923,	'Natural Person',	'North America',	'United States',	'2014-11-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (924,	'Legal entity',	'North America',	'United States',	'2014-11-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3826.65,	3826.65),  (925,	'Legal entity',	'South America',	'Argentina',	'2014-12-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (926,	'Natural Person',	'Europe',	'Germany',	'2014-12-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	524.25,	524.25),  (927,	'Natural Person',	'Europe',	'Switzerland',	'2014-12-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (928,	'Natural Person',	'North America',	'Mexico',	'2014-12-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	849.29,	849.29),  (929,	'public company',	'Africa',	'South Africa',	'2015-01-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4950,	4950),  (930,	'Natural Person',	'Asia',	'Indonesia',	'2015-01-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.75,	366.75),  (931,	'Legal entity',	'Africa',	'Uganda',	'2015-01-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.98,	366.98),  (932,	'Legal entity',	'Asia',	'Turkey',	'2015-01-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	660.15,	660.15),  (933,	'Natural Person',	'Asia',	'Malaysia',	'2015-01-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1393.65,	1393.65),  (934,	'Legal entity',	'South America',	'Peru',	'2015-02-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (935,	'Legal entity',	'Europe',	'Poland',	'2015-02-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	424.64,	424.64),  (936,	'Legal entity',	'North America',	'Mexico',	'2015-02-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (937,	'Natural Person',	'North America',	'Mexico',	'2015-03-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (938,	'Natural Person',	'South America',	'Argentina',	'2015-03-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1179.56,	1179.56),  (939,	'Natural Person',	'North America',	'United States',	'2015-03-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (940,	'Natural Person',	'Europe',	'Italy',	'2015-04-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (941,	'Natural Person',	'Asia',	'Indonesia',	'2015-04-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.75,	366.75),  (942,	'Natural Person',	'South America',	'Chile',	'2015-05-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	419.4,	419.4),  (943,	'Legal entity',	'North America',	'Costa Rica',	'2015-05-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	419.4,	419.4),  (944,	'Legal entity',	'North America',	'Mexico',	'2015-07-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (945,	'Natural Person',	'South America',	'Chile',	'2015-07-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (946,	'Natural Person',	'Europe',	'Austria',	'2015-07-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	449.25,	449.25),  (947,	'Natural Person',	'South America',	'Colombia',	'2015-07-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	727.79,	727.79),  (948,	'Natural Person',	'North America',	'United States',	'2015-07-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	808.65,	808.65),  (949,	'Natural Person',	'Asia',	'Indonesia',	'2015-07-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.55,	314.55),  (950,	'Legal entity',	'South America',	'Argentina',	'2015-09-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	366.98,	366.98),  (951,	'Natural Person',	'North America',	'United States',	'2015-09-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	419.4,	419.4),  (952,	'Legal entity',	'North America',	'United States',	'2015-09-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	293.58,	293.58),  (953,	'Natural Person',	'Asia',	'Philippines',	'2015-10-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	279.6,	279.6),  (954,	'Legal entity',	'South America',	'Colombia',	'2015-11-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (955,	'Natural Person',	'Asia',	'Indonesia',	'2015-11-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.55,	314.55),  (956,	'Natural Person',	'Europe',	'Portugal',	'2015-11-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (957,	'Natural Person',	'Europe',	'Germany',	'2015-11-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (958,	'Legal entity',	'South America',	'Chile',	'2015-11-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	471.83,	471.83),  (959,	'Legal entity',	'Africa',	'South Africa',	'2015-12-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2475,	2475),  (960,	'Natural Person',	'Europe',	'Italy',	'2015-12-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	524.25,	524.25),  (961,	'Legal entity',	'Asia',	'India',	'2015-12-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	509.57,	509.57),  (962,	'Legal entity',	'Asia',	'Malaysia',	'2015-12-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	314.55,	314.55),  (963,	'Natural Person',	'North America',	'United States',	'2015-12-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	393.19,	393.19),  (964,	'Natural Person',	'Asia',	'Saudi Arabia',	'2016-01-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	524.25,	524.25),  (965,	'Natural Person',	'North America',	'Panama',	'2016-01-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	419.4,	419.4),  (966,	'Natural Person',	'Europe',	'Italy',	'2016-01-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	419.4,	419.4),  (967,	'Legal entity',	'South America',	'Argentina',	'2016-01-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	660.56,	660.56),  (968,	'Natural Person',	'Europe',	'United Kingdom',	'2015-03-06',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	291.95,	291.95),  (969,	'Natural Person',	'Europe',	'Netherlands',	'2014-11-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.7,	359.7),  (970,	'Natural Person',	'South America',	'Brazil',	'2015-01-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	323.43,	323.43),  (971,	'Natural Person',	'Oceania',	'Australia',	'2015-04-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	290.93,	290.93),  (972,	'Natural Person',	'Asia',	'Indonesia',	'2015-08-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	119.76,	119.76),  (973,	'Legal entity',	'Africa',	'South Africa',	'2014-12-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2250,	2250),  (974,	'Natural Person',	'Europe',	'United Kingdom',	'2015-01-06',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	720,	720),  (975,	'Legal entity',	'South America',	'Argentina',	'2015-04-16',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	494.25,	494.25),  (976,	'Legal entity',	'Europe',	'United Kingdom',	'2015-05-06',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	648,	648),  (977,	'Natural Person',	'Europe',	'Italy',	'2016-01-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	900,	900),  (978,	'public company',	'Europe',	'Spain',	'2015-12-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8808.25,	8808.25),  (979,	'public company',	'Europe',	'United Kingdom',	'2014-11-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5400,	5400),  (980,	'Legal entity',	'Asia',	'Indonesia',	'2015-12-18',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	5436,	5436),  (981,	'public company',	'North America',	'El Salvador',	'2017-05-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3045,	3045),  (982,	'Legal entity',	'Europe',	'Spain',	'2014-12-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6450,	6450),  (983,	'public company',	'South America',	'Brazil',	'2017-05-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7195.5,	7195.5),  (984,	'Legal entity',	'North America',	'United States',	'2015-10-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5616,	5616),  (985,	'Legal entity',	'Europe',	'France',	'2017-05-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1395,	1395),  (986,	'Legal entity',	'Africa',	'Namibia',	'2016-01-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1759.5,	1759.5),  (987,	'Natural Person',	'Asia',	'Malaysia',	'2014-08-15',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	233.59,	233.59),  (988,	'Natural Person',	'North America',	'United States',	'2014-11-01',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	419.4,	419.4),  (989,	'Legal entity',	'South America',	'Colombia',	'2014-11-21',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	377.46,	377.46),  (990,	'Natural Person',	'Europe',	'Germany',	'2014-12-30',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	370.43,	370.43),  (991,	'Legal entity',	'South America',	'Argentina',	'2015-01-26',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	358.85,	358.85),  (992,	'Legal entity',	'North America',	'Mexico',	'2015-02-08',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	346.43,	346.43),  (993,	'Natural Person',	'Europe',	'Italy',	'2015-02-14',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	201.31,	201.31),  (994,	'Natural Person',	'North America',	'Panama',	'2015-02-18',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	304.24,	304.24),  (995,	'Natural Person',	'North America',	'El Salvador',	'2015-02-27',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	377.46,	377.46),  (996,	'Natural Person',	'Africa',	'South Africa',	'2015-05-09',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	260.14,	260.14),  (997,	'Legal entity',	'South America',	'Chile',	'2015-06-13',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	359.4,	359.4),  (998,	'Natural Person',	'Europe',	'Switzerland',	'2015-08-12',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	359.4,	359.4),  (999,	'Natural Person',	'North America',	'United States',	'2015-08-16',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	359.4,	359.4);
INSERT INTO `comparison` VALUES (1000,	'Natural Person',	'Asia',	'Malaysia',	'2015-12-19',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	298.35,	298.35),  (1001,	'Legal entity',	'Asia',	'Cyprus',	'2014-07-30',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1002,	'Natural Person',	'Asia',	'Japan',	'2014-08-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1003,	'Natural Person',	'Europe',	'Italy',	'2014-09-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1004,	'Natural Person',	'Europe',	'Netherlands',	'2014-09-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.25,	674.25),  (1005,	'Legal entity',	'Europe',	'Italy',	'2014-09-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1006,	'Natural Person',	'Asia',	'Indonesia',	'2014-09-21',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1007,	'Natural Person',	'Africa',	'Morocco',	'2014-09-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1008,	'Legal entity',	'South America',	'Colombia',	'2014-09-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1009,	'Natural Person',	'Europe',	'Austria',	'2014-10-05',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1010,	'Natural Person',	'Africa',	'South Africa',	'2014-10-11',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.25,	674.25),  (1011,	'Legal entity',	'North America',	'Mexico',	'2014-10-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1012,	'Natural Person',	'Europe',	'Romania',	'2014-10-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1013,	'Natural Person',	'North America',	'United States',	'2014-10-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1014,	'Natural Person',	'Asia',	'Singapore',	'2014-10-26',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.25,	674.25),  (1015,	'Natural Person',	'Asia',	'Thailand',	'2014-11-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1016,	'Natural Person',	'Asia',	'Malaysia',	'2014-11-08',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1017,	'Legal entity',	'Europe',	'Italy',	'2014-12-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1018,	'Legal entity',	'Europe',	'Spain',	'2014-12-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1019,	'Natural Person',	'Europe',	'Portugal',	'2015-01-01',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1020,	'Natural Person',	'Asia',	'Pakistan',	'2015-01-04',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1021,	'Natural Person',	'Europe',	'Finland',	'2015-01-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1022,	'Legal entity',	'South America',	'Venezuela',	'2015-01-11',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1023,	'Natural Person',	'Asia',	'Indonesia',	'2015-01-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1024,	'Natural Person',	'North America',	'Mexico',	'2015-01-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1025,	'Natural Person',	'Africa',	'Namibia',	'2015-01-25',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	546.14,	546.14),  (1026,	'Natural Person',	'Asia',	'Malaysia',	'2015-02-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1027,	'Legal entity',	'Europe',	'Italy',	'2015-02-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1028,	'Natural Person',	'Asia',	'United Arab Emirates',	'2015-02-12',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1029,	'Natural Person',	'Europe',	'Germany',	'2015-02-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1030,	'Natural Person',	'South America',	'Chile',	'2015-02-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299,	299),  (1031,	'Natural Person',	'Asia',	'India',	'2015-03-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1032,	'Natural Person',	'Asia',	'Turkey',	'2015-03-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1033,	'Natural Person',	'South America',	'Argentina',	'2015-03-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	606.83,	606.83),  (1034,	'Natural Person',	'Oceania',	'Australia',	'2015-03-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1035,	'Natural Person',	'Asia',	'Malaysia',	'2015-04-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279,	279),  (1036,	'Natural Person',	'Europe',	'Germany',	'2015-04-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1037,	'Natural Person',	'Europe',	'United Kingdom',	'2015-04-04',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.25,	674.25),  (1038,	'Natural Person',	'Europe',	'France',	'2015-04-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	606.83,	606.83),  (1039,	'Legal entity',	'Europe',	'Switzerland',	'2015-04-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.25,	674.25),  (1040,	'Natural Person',	'Europe',	'Spain',	'2015-04-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1041,	'Natural Person',	'Europe',	'Portugal',	'2015-05-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1042,	'Natural Person',	'South America',	'Argentina',	'2015-05-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	485.46,	485.46),  (1043,	'Legal entity',	'South America',	'Argentina',	'2015-05-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	539.4,	539.4),  (1044,	'Natural Person',	'South America',	'Colombia',	'2015-05-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1045,	'Natural Person',	'Europe',	'United Kingdom',	'2015-06-02',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1046,	'Natural Person',	'South America',	'Brazil',	'2015-06-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	539.4,	539.4),  (1047,	'Natural Person',	'Asia',	'India',	'2015-07-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1048,	'Natural Person',	'Europe',	'Italy',	'2015-08-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	269.33,	269.33),  (1049,	'Natural Person',	'Asia',	'Hong Kong',	'2015-08-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	539.4,	539.4),  (1050,	'Natural Person',	'North America',	'Mexico',	'2015-09-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279.3,	279.3),  (1051,	'Natural Person',	'North America',	'Costa Rica',	'2015-09-27',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	265.34,	265.34),  (1052,	'Natural Person',	'South America',	'Ecuador',	'2015-10-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	279.3,	279.3),  (1053,	'Natural Person',	'Europe',	'Austria',	'2015-11-22',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1054,	'Natural Person',	'Asia',	'United Arab Emirates',	'2015-12-06',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1055,	'Legal entity',	'Asia',	'India',	'2015-12-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1056,	'Natural Person',	'South America',	'Brazil',	'2015-12-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.33,	674.33),  (1057,	'Legal entity',	'Asia',	'China',	'2015-12-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1058,	'Legal entity',	'Europe',	'United Kingdom',	'2016-01-05',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	749.25,	749.25),  (1059,	'Natural Person',	'Europe',	'France',	'2016-01-08',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	674.33,	674.33),  (1060,	'Legal entity',	'South America',	'Colombia',	'2016-01-09',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	299.25,	299.25),  (1061,	'Natural Person',	'Asia',	'Indonesia',	'2016-01-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	573.18,	573.18),  (1062,	'Natural Person',	'Europe',	'Belgium',	'2016-01-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	239.4,	239.4),  (1063,	'Natural Person',	'North America',	'United States',	'2015-04-11',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	269.33,	269.33),  (1064,	'Natural Person',	'Europe',	'United Kingdom',	'2015-05-03',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	539.4,	539.4),  (1065,	'Legal entity',	'Europe',	'France',	'2014-12-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (1066,	'Legal entity',	'South America',	'Ecuador',	'2014-07-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	279.6,	279.6),  (1067,	'Natural Person',	'Europe',	'Germany',	'2014-08-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	629.1,	629.1),  (1068,	'Natural Person',	'Europe',	'Greece',	'2015-01-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	251.64,	251.64),  (1069,	'Legal entity',	'South America',	'Chile',	'2015-04-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	377.46,	377.46),  (1070,	'Legal entity',	'South America',	'Argentina',	'2015-08-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	239.6,	239.6),  (1071,	'Natural Person',	'North America',	'United States',	'2015-11-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	251.64,	251.64),  (1072,	'Legal entity',	'Europe',	'Italy',	'2017-05-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	279.6,	279.6),  (1073,	'Legal entity',	'South America',	'Colombia',	'2019-08-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (1074,	'Legal entity',	'North America',	'Mexico',	'2019-11-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	323.73,	323.73),  (1075,	'Legal entity',	'South America',	'Ecuador',	'2014-09-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	629.1,	629.1),  (1076,	'Natural Person',	'North America',	'United States',	'2014-10-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	283.1,	283.1),  (1077,	'Legal entity',	'North America',	'Mexico',	'2015-02-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	566.19,	566.19),  (1078,	'Natural Person',	'North America',	'United States',	'2015-05-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	251.64,	251.64),  (1079,	'Natural Person',	'North America',	'United States',	'2015-06-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	269.55,	269.55),  (1080,	'Natural Person',	'South America',	'Colombia',	'2016-01-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	251.64,	251.64),  (1081,	'Natural Person',	'Europe',	'Spain',	'2019-11-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	323.73,	323.73),  (1082,	'Natural Person',	'North America',	'United States',	'2014-08-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	159.6,	159.6),  (1083,	'Natural Person',	'Europe',	'Belgium',	'2014-09-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	159.6,	159.6),  (1084,	'Natural Person',	'Europe',	'Slovakia',	'2014-11-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	143.64,	143.64),  (1085,	'Natural Person',	'North America',	'Canada',	'2014-11-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	179.64,	179.64),  (1086,	'Natural Person',	'Europe',	'United Kingdom',	'2015-07-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	287.68,	287.68),  (1087,	'Natural Person',	'Europe',	'United Kingdom',	'2015-07-05',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	287.68,	287.68),  (1088,	'Natural Person',	'South America',	'Argentina',	'2015-07-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	143.64,	143.64),  (1089,	'Natural Person',	'Europe',	'Germany',	'2015-09-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	159.6,	159.6),  (1090,	'Natural Person',	'Europe',	'Switzerland',	'2015-09-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	287.68,	287.68),  (1091,	'Natural Person',	'Europe',	'Malta',	'2015-10-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	242.73,	242.73),  (1092,	'Natural Person',	'North America',	'Mexico',	'2015-10-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	143.64,	143.64),  (1093,	'Legal entity',	'Asia',	'Indonesia',	'2015-11-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	111.72,	111.72),  (1094,	'Natural Person',	'Europe',	'Italy',	'2016-01-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	199.6,	199.6),  (1095,	'Natural Person',	'North America',	'Canada',	'2014-08-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.55,	539.55),  (1096,	'Natural Person',	'Europe',	'Switzerland',	'2014-08-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.4,	299.4),  (1097,	'Natural Person',	'Asia',	'Qatar',	'2014-09-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	215.46,	215.46),  (1098,	'Legal entity',	'North America',	'Mexico',	'2014-12-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.4,	239.4),  (1099,	'Legal entity',	'Europe',	'Romania',	'2014-12-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	269.46,	269.46),  (1100,	'Natural Person',	'Europe',	'Netherlands',	'2015-12-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	404.55,	404.55),  (1101,	'Legal entity',	'Europe',	'Romania',	'2016-01-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.4,	299.4),  (1102,	'Natural Person',	'Europe',	'Romania',	'2014-12-14',	'2.4 Sports and Outdoors',	'TrailBlazer Outdoor Adventure Backpack',	1,	299.55,	299.55),  (1103,	'Natural Person',	'North America',	'United States',	'2015-12-05',	'2.4 Sports and Outdoors',	'TrailBlazer Outdoor Adventure Backpack',	1,	100,	100),  (1104,	'Legal entity',	'Europe',	'United Kingdom',	'2017-05-03',	'2.1 Books and Stationery',	'Satchel Leather Notebook Cover',	1,	899.7,	899.7),  (1105,	'Legal entity',	'Europe',	'United Kingdom',	'2021-09-03',	'2.4 Sports and Outdoors',	'TrailBlazer Outdoor Adventure Backpack',	1,	4412.25,	4412.25),  (1106,	'Natural Person',	'Asia',	'Indonesia',	'2021-12-29',	'2.4 Sports and Outdoors',	'TrailBlazer Outdoor Adventure Backpack',	1,	1888.65,	1888.65),  (1107,	'Natural Person',	'South America',	'Chile',	'2017-05-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	90,	90),  (1108,	'Natural Person',	'North America',	'Mexico',	'2017-05-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (1109,	'Legal entity',	'South America',	'Colombia',	'2017-05-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	717.6,	717.6),  (1110,	'Natural Person',	'North America',	'United States',	'2018-11-27',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	111.68,	111.68),  (1111,	'Natural Person',	'South America',	'Brazil',	'2019-01-31',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	719.64,	719.64),  (1112,	'Legal entity',	'Europe',	'United Kingdom',	'2023-05-04',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	1174.1,	1174.1),  (1113,	'Natural Person',	'Europe',	'United Kingdom',	'2023-07-03',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	900,	900),  (1114,	'Legal entity',	'South America',	'Brazil',	'2018-08-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1133.72,	1133.72),  (1115,	'Legal entity',	'South America',	'Brazil',	'2018-08-31',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2582.97,	2582.97),  (1116,	'Legal entity',	'Africa',	'South Africa',	'2018-09-10',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	12750,	12750),  (1117,	'Legal entity',	'Africa',	'Kenya',	'2018-11-23',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1439.64,	1439.64),  (1118,	'Legal entity',	'Europe',	'United Kingdom',	'2018-12-04',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	719.82,	719.82),  (1119,	'Legal entity',	'North America',	'Honduras',	'2019-01-23',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2879.51,	2879.51),  (1120,	'Legal entity',	'South America',	'Brazil',	'2019-01-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	8640,	8640),  (1121,	'public company',	'Europe',	'Netherlands',	'2019-02-14',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2849.1,	2849.1),  (1122,	'Natural Person',	'Africa',	'South Africa',	'2019-12-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1025.74,	1025.74),  (1123,	'public company',	'South America',	'Brazil',	'2019-12-30',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	10797.3,	10797.3),  (1124,	'Legal entity',	'Europe',	'France',	'2020-08-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1799.55,	1799.55),  (1125,	'Legal entity',	'Europe',	'Spain',	'2020-08-17',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1799.7,	1799.7),  (1126,	'Legal entity',	'Europe',	'France',	'2020-12-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	12308.92,	12308.92),  (1127,	'Legal entity',	'Europe',	'Germany',	'2021-09-01',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	7798.5,	7798.5),  (1128,	'Legal entity',	'North America',	'Canada',	'2021-11-09',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2105.6,	2105.6),  (1129,	'Legal entity',	'Europe',	'Switzerland',	'2022-01-12',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1988.62,	1988.62),  (1130,	'Legal entity',	'North America',	'Dominican Republic',	'2022-03-22',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	6316.5,	6316.5),  (1131,	'Natural Person',	'Europe',	'Germany',	'2022-06-01',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1875,	1875),  (1132,	'Natural Person',	'South America',	'Brazil',	'2022-06-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1875,	1875),  (1133,	'Natural Person',	'Europe',	'United Kingdom',	'2022-07-04',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	4350,	4350),  (1134,	'Legal entity',	'Europe',	'United Kingdom',	'2022-08-04',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2100,	2100),  (1135,	'Natural Person',	'Africa',	'South Africa',	'2022-08-11',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2339.55,	2339.55),  (1136,	'Natural Person',	'South America',	'Brazil',	'2022-11-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1565.73,	1565.73),  (1137,	'Legal entity',	'North America',	'Canada',	'2022-12-08',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1565.73,	1565.73),  (1138,	'Legal entity',	'Africa',	'Libyan Arab Jamahiriya',	'2023-02-24',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2348.6,	2348.6),  (1139,	'Legal entity',	'Europe',	'Russian Federation',	'2023-05-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	8250,	8250),  (1140,	'Legal entity',	'Europe',	'France',	'2023-11-08',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	4875,	4875),  (1141,	'Natural Person',	'North America',	'United States',	'2017-05-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	823.5,	823.5),  (1142,	'Natural Person',	'Europe',	'Portugal',	'2017-05-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	823.5,	823.5),  (1143,	'Natural Person',	'North America',	'Honduras',	'2017-05-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1947.38,	1947.38),  (1144,	'public company',	'Asia',	'Oman',	'2020-05-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	5699.25,	5699.25),  (1145,	'public company',	'Africa',	'South Africa',	'2020-12-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	5699.25,	5699.25),  (1146,	'public company',	'Europe',	'Netherlands',	'2021-06-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	5699.25,	5699.25),  (1147,	'public company',	'North America',	'Bahamas',	'2022-06-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	10948.5,	10948.5),  (1148,	'public company',	'South America',	'Brazil',	'2022-12-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	7274.25,	7274.25),  (1149,	'public company',	'Europe',	'United Kingdom',	'2018-12-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	11893.5,	11893.5),  (1150,	'public company',	'Europe',	'Norway',	'2019-04-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	6644.25,	6644.25),  (1151,	'public company',	'North America',	'Bahamas',	'2019-06-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	6644.25,	6644.25),  (1152,	'public company',	'Europe',	'France',	'2019-11-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	6644.25,	6644.25),  (1153,	'public company',	'Africa',	'South Africa',	'2021-03-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	14780.59,	14780.59),  (1154,	'public company',	'Asia',	'Afghanistan',	'2021-10-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	11893.5,	11893.5),  (1155,	'Legal entity',	'Europe',	'United Kingdom',	'2017-05-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	581.36,	581.36),  (1156,	'public company',	'Europe',	'Spain',	'2018-09-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	13950,	13950),  (1157,	'Natural Person',	'North America',	'Panama',	'2019-04-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2517.34,	2517.34),  (1158,	'public company',	'North America',	'United States',	'2019-08-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	11289.23,	11289.23),  (1159,	'Natural Person',	'Africa',	'Botswana',	'2019-11-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1123.5,	1123.5),  (1160,	'Natural Person',	'South America',	'Colombia',	'2019-11-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1842.9,	1842.9),  (1161,	'Natural Person',	'South America',	'Paraguay',	'2019-12-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2157.86,	2157.86),  (1162,	'public company',	'Africa',	'South Africa',	'2020-02-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	18113.25,	18113.25),  (1163,	'public company',	'North America',	'Canada',	'2021-04-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	12602.25,	12602.25),  (1164,	'public company',	'Asia',	'Indonesia',	'2021-10-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	12864,	12864),  (1165,	'public company',	'South America',	'Brazil',	'2021-10-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	23362.5,	23362.5),  (1166,	'public company',	'Europe',	'Netherlands',	'2021-12-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	28611.74,	28611.74),  (1167,	'public company',	'North America',	'United States',	'2022-03-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	12864,	12864),  (1168,	'public company',	'Europe',	'Netherlands',	'2022-07-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	12864,	12864),  (1169,	'Natural Person',	'Asia',	'Malaysia',	'2022-07-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	14844.75,	14844.75),  (1170,	'public company',	'South America',	'Brazil',	'2022-08-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	9189.75,	9189.75),  (1171,	'public company',	'North America',	'United States',	'2023-08-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	22838.25,	22838.25),  (1172,	'public company',	'Europe',	'United Kingdom',	'2018-09-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2475,	2475),  (1173,	'public company',	'North America',	'Canada',	'2018-10-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4950,	4950),  (1174,	'Legal entity',	'South America',	'Brazil',	'2018-11-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	720,	720),  (1175,	'public company',	'Europe',	'Netherlands',	'2018-12-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3149.55,	3149.55),  (1176,	'public company',	'North America',	'United States',	'2019-01-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2475,	2475),  (1177,	'Legal entity',	'Africa',	'South Africa',	'2019-02-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1701,	1701),  (1178,	'public company',	'South America',	'Brazil',	'2019-05-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9000,	9000),  (1179,	'public company',	'Asia',	'Hong Kong',	'2019-07-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6299.1,	6299.1),  (1180,	'public company',	'Asia',	'Pakistan',	'2019-07-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4199.4,	4199.4),  (1181,	'public company',	'Europe',	'United Kingdom',	'2019-08-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1800,	1800),  (1182,	'public company',	'South America',	'Brazil',	'2019-08-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4199.4,	4199.4),  (1183,	'public company',	'North America',	'Canada',	'2019-10-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2700,	2700),  (1184,	'public company',	'Africa',	'South Africa',	'2019-10-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2475,	2475),  (1185,	'public company',	'Europe',	'United Kingdom',	'2019-11-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6299.1,	6299.1),  (1186,	'Legal entity',	'North America',	'Mexico',	'2019-12-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	323.73,	323.73),  (1187,	'Natural Person',	'North America',	'Panama',	'2019-12-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	323.73,	323.73),  (1188,	'public company',	'Europe',	'Italy',	'2019-12-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6298.8,	6298.8),  (1189,	'Natural Person',	'North America',	'Mexico',	'2019-12-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (1190,	'public company',	'Asia',	'Indonesia',	'2019-12-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6299.4,	6299.4),  (1191,	'public company',	'South America',	'Brazil',	'2020-01-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6000,	6000),  (1192,	'public company',	'Europe',	'Switzerland',	'2020-02-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9448.65,	9448.65),  (1193,	'Legal entity',	'Europe',	'Hungary',	'2020-03-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4200,	4200),  (1194,	'Legal entity',	'South America',	'Chile',	'2020-03-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (1195,	'Legal entity',	'North America',	'Mexico',	'2020-04-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	863.28,	863.28),  (1196,	'public company',	'Asia',	'Iraq',	'2020-06-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7499.25,	7499.25),  (1197,	'Legal entity',	'Europe',	'Portugal',	'2020-08-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (1198,	'Natural Person',	'Africa',	'South Africa',	'2020-08-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	323.73,	323.73),  (1199,	'Natural Person',	'Europe',	'Germany',	'2020-08-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	628.95,	628.95),  (1200,	'Legal entity',	'South America',	'Peru',	'2020-09-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1375.85,	1375.85),  (1201,	'public company',	'Europe',	'France',	'2020-10-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12598.2,	12598.2),  (1202,	'Natural Person',	'North America',	'United States',	'2020-10-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1079.1,	1079.1),  (1203,	'Natural Person',	'North America',	'Canada',	'2020-10-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	314.48,	314.48),  (1204,	'public company',	'Europe',	'United Kingdom',	'2020-12-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11775,	11775),  (1205,	'Natural Person',	'North America',	'United States',	'2021-01-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1079.1,	1079.1),  (1206,	'Natural Person',	'South America',	'Colombia',	'2021-02-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	314.48,	314.48),  (1207,	'public company',	'Europe',	'United Kingdom',	'2021-07-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4199.4,	4199.4),  (1208,	'public company',	'South America',	'Colombia',	'2021-08-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (1209,	'Legal entity',	'Europe',	'United Kingdom',	'2021-08-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2849.6,	2849.6),  (1210,	'Legal entity',	'Europe',	'Netherlands',	'2021-10-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2099.7,	2099.7),  (1211,	'public company',	'Asia',	'Hong Kong',	'2021-12-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6299.1,	6299.1),  (1212,	'Legal entity',	'South America',	'Chile',	'2022-01-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	629.55,	629.55),  (1213,	'public company',	'Europe',	'Hungary',	'2022-03-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9000,	9000),  (1214,	'public company',	'Europe',	'France',	'2022-04-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	31495.5,	31495.5),  (1215,	'Legal entity',	'Africa',	'Tunisia',	'2022-04-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	16378.2,	16378.2),  (1216,	'public company',	'South America',	'Brazil',	'2022-04-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12598.2,	12598.2),  (1217,	'public company',	'Asia',	'Hong Kong',	'2022-05-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3149.55,	3149.55),  (1218,	'public company',	'Africa',	'Uganda',	'2022-06-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2475,	2475),  (1219,	'public company',	'Europe',	'United Kingdom',	'2022-07-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9448.65,	9448.65),  (1220,	'public company',	'Asia',	'Hong Kong',	'2022-07-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5489.55,	5489.55),  (1221,	'Legal entity',	'Asia',	'Hong Kong',	'2022-07-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4094.55,	4094.55),  (1222,	'Natural Person',	'Europe',	'Germany',	'2022-09-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	629.55,	629.55),  (1223,	'Legal entity',	'South America',	'Argentina',	'2022-09-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1886.04,	1886.04),  (1224,	'Legal entity',	'North America',	'Nicaragua',	'2022-10-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2788.2,	2788.2),  (1225,	'public company',	'Europe',	'Spain',	'2022-10-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4162.05,	4162.05),  (1226,	'Legal entity',	'Europe',	'Malta',	'2022-10-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6750,	6750),  (1227,	'public company',	'Europe',	'United Kingdom',	'2022-11-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4398.6,	4398.6),  (1228,	'Natural Person',	'Europe',	'United Kingdom',	'2022-11-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	418.23,	418.23),  (1229,	'Legal entity',	'North America',	'United States',	'2022-12-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4094.55,	4094.55),  (1230,	'Legal entity',	'Europe',	'Netherlands',	'2022-12-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4707,	4707),  (1231,	'public company',	'South America',	'Brazil',	'2022-12-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	13785.45,	13785.45),  (1232,	'public company',	'South America',	'Argentina',	'2023-02-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4094.55,	4094.55),  (1233,	'public company',	'South America',	'Argentina',	'2023-05-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	16378.2,	16378.2),  (1234,	'Natural Person',	'South America',	'Brazil',	'2023-05-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4455,	4455),  (1235,	'public company',	'Europe',	'United Kingdom',	'2023-07-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	28500,	28500),  (1236,	'public company',	'Asia',	'Indonesia',	'2023-10-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9448.65,	9448.65),  (1237,	'public company',	'Europe',	'Germany',	'2018-08-01',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	37500,	37500),  (1238,	'public company',	'Asia',	'Saudi Arabia',	'2020-06-26',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	37500,	37500),  (1239,	'public company',	'South America',	'Brazil',	'2021-04-30',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	37500,	37500),  (1240,	'public company',	'Asia',	'Hong Kong',	'2021-07-19',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	37500,	37500),  (1241,	'public company',	'South America',	'Brazil',	'2021-08-31',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	30000,	30000),  (1242,	'Legal entity',	'Europe',	'Bosnia and Herzegovina',	'2022-03-21',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	45000,	45000),  (1243,	'public company',	'Asia',	'Indonesia',	'2022-11-18',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	37500,	37500),  (1244,	'public company',	'Asia',	'Hong Kong',	'2022-12-14',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	37500,	37500),  (1245,	'public company',	'North America',	'United States',	'2023-01-03',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	45000,	45000),  (1246,	'public company',	'Asia',	'Hong Kong',	'2023-11-14',	'1.1 Eletronics',	'QuantumVision HD Smart TV',	1,	48750,	48750),  (1247,	'Natural Person',	'South America',	'Paraguay',	'2020-05-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1248,	'Natural Person',	'South America',	'Chile',	'2017-05-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1249,	'Natural Person',	'South America',	'Argentina',	'2017-05-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1250,	'Natural Person',	'South America',	'Argentina',	'2017-05-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1251,	'Natural Person',	'South America',	'Peru',	'2018-08-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1252,	'Legal entity',	'North America',	'Guatemala',	'2018-08-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1253,	'Natural Person',	'Europe',	'France',	'2018-08-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	944.53,	944.53),  (1254,	'Natural Person',	'Asia',	'Indonesia',	'2018-08-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1255,	'Natural Person',	'Europe',	'Germany',	'2018-08-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1256,	'Natural Person',	'Asia',	'Bangladesh',	'2018-08-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1257,	'Natural Person',	'Asia',	'Indonesia',	'2018-08-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1258,	'Natural Person',	'South America',	'Colombia',	'2018-08-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1259,	'Natural Person',	'South America',	'Brazil',	'2018-08-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1260,	'Natural Person',	'Europe',	'United Kingdom',	'2018-09-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1261,	'Natural Person',	'South America',	'Chile',	'2018-09-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1262,	'Natural Person',	'Asia',	'Hong Kong',	'2018-09-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1263,	'Natural Person',	'Europe',	'Germany',	'2018-09-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1264,	'Natural Person',	'South America',	'Colombia',	'2018-09-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1265,	'Natural Person',	'North America',	'Guatemala',	'2018-09-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1266,	'Natural Person',	'Asia',	'United Arab Emirates',	'2018-09-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1267,	'Natural Person',	'North America',	'Guatemala',	'2018-09-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	341.57,	341.57),  (1268,	'Natural Person',	'Europe',	'Germany',	'2018-10-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.44,	449.44),  (1269,	'Natural Person',	'South America',	'Venezuela',	'2018-10-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.44,	449.44),  (1270,	'Natural Person',	'South America',	'Colombia',	'2018-10-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.44,	449.44),  (1271,	'Natural Person',	'Europe',	'Netherlands',	'2018-10-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.44,	449.44),  (1272,	'Natural Person',	'Asia',	'Oman',	'2018-10-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	382.04,	382.04),  (1273,	'Natural Person',	'Europe',	'Slovenia',	'2018-10-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	419.48,	419.48),  (1274,	'Natural Person',	'South America',	'Brazil',	'2018-10-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	755.62,	755.62),  (1275,	'Natural Person',	'South America',	'Brazil',	'2018-10-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1276,	'Natural Person',	'North America',	'United States',	'2018-11-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1049.48,	1049.48),  (1277,	'Natural Person',	'Europe',	'Italy',	'2018-11-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1278,	'Natural Person',	'Europe',	'Germany',	'2018-11-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	419.48,	419.48),  (1279,	'Natural Person',	'Europe',	'Belgium',	'2018-11-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1199.4,	1199.4),  (1280,	'Natural Person',	'Europe',	'Germany',	'2018-11-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	239.7,	239.7),  (1281,	'Natural Person',	'Africa',	'Mauritius',	'2018-11-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.7,	599.7),  (1282,	'Natural Person',	'South America',	'Chile',	'2018-11-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	239.7,	239.7),  (1283,	'Natural Person',	'North America',	'Mexico',	'2018-11-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	239.7,	239.7),  (1284,	'Natural Person',	'South America',	'Brazil',	'2018-11-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.7,	599.7),  (1285,	'Natural Person',	'South America',	'Brazil',	'2018-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.7,	599.7),  (1286,	'Natural Person',	'North America',	'Mexico',	'2018-12-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	239.7,	239.7),  (1287,	'Natural Person',	'Asia',	'Indonesia',	'2018-12-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	239.7,	239.7),  (1288,	'Natural Person',	'Europe',	'United Kingdom',	'2018-12-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.7,	599.7),  (1289,	'Natural Person',	'Africa',	'South Africa',	'2018-12-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.7,	599.7),  (1290,	'Natural Person',	'South America',	'Paraguay',	'2018-12-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1291,	'Legal entity',	'South America',	'Argentina',	'2018-12-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1292,	'Natural Person',	'Europe',	'Germany',	'2018-12-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1293,	'Natural Person',	'North America',	'Canada',	'2018-12-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1294,	'Natural Person',	'Europe',	'Hungary',	'2019-01-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1295,	'Natural Person',	'Asia',	'Lebanon',	'2019-01-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	971.52,	971.52),  (1296,	'Natural Person',	'North America',	'United States',	'2019-02-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1297,	'Natural Person',	'Europe',	'Italy',	'2019-02-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1079.46,	1079.46),  (1298,	'Natural Person',	'North America',	'Mexico',	'2019-02-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1299,	'Natural Person',	'Asia',	'Hong Kong',	'2019-02-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1199.4,	1199.4),  (1300,	'Natural Person',	'Europe',	'Germany',	'2019-02-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1301,	'Natural Person',	'North America',	'Mexico',	'2019-02-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1302,	'Natural Person',	'North America',	'United States',	'2019-03-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1303,	'Natural Person',	'Europe',	'United Kingdom',	'2019-03-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1304,	'Legal entity',	'North America',	'United States',	'2019-03-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1305,	'Natural Person',	'Europe',	'Spain',	'2019-03-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1306,	'Natural Person',	'South America',	'Argentina',	'2019-03-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	479.4,	479.4),  (1307,	'Natural Person',	'South America',	'Brazil',	'2019-03-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1079.46,	1079.46),  (1308,	'Natural Person',	'Europe',	'Italy',	'2019-04-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	396.35,	396.35),  (1309,	'Natural Person',	'Europe',	'United Kingdom',	'2019-04-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1199.4,	1199.4),  (1310,	'Natural Person',	'North America',	'United States',	'2019-04-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1311,	'Natural Person',	'South America',	'Peru',	'2019-04-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1312,	'Natural Person',	'North America',	'Mexico',	'2019-04-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1313,	'Natural Person',	'North America',	'United States',	'2019-05-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	539.33,	539.33),  (1314,	'Natural Person',	'Europe',	'United Kingdom',	'2019-05-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1315,	'Natural Person',	'South America',	'Colombia',	'2019-05-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1316,	'Natural Person',	'South America',	'Bolivia',	'2019-05-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1317,	'Natural Person',	'Africa',	'Senegal',	'2019-05-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1318,	'Natural Person',	'Europe',	'Austria',	'2019-05-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1319,	'Natural Person',	'Oceania',	'Australia',	'2019-05-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1320,	'Natural Person',	'Europe',	'Italy',	'2019-06-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1321,	'Natural Person',	'Europe',	'Netherlands',	'2019-06-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1322,	'Legal entity',	'North America',	'Mexico',	'2019-06-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1323,	'Natural Person',	'Asia',	'Saudi Arabia',	'2019-06-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1324,	'Natural Person',	'North America',	'Mexico',	'2019-06-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1325,	'Natural Person',	'Europe',	'United Kingdom',	'2019-07-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1326,	'Natural Person',	'Africa',	'South Africa',	'2019-07-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1327,	'Natural Person',	'Asia',	'Indonesia',	'2019-07-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1328,	'Natural Person',	'Europe',	'Austria',	'2019-07-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1329,	'Natural Person',	'Europe',	'France',	'2019-08-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1330,	'Natural Person',	'North America',	'Canada',	'2019-08-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1331,	'Natural Person',	'Asia',	'Malaysia',	'2019-08-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1332,	'Natural Person',	'Asia',	'Indonesia',	'2019-08-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1333,	'Natural Person',	'Asia',	'Hong Kong',	'2019-08-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1334,	'Natural Person',	'Africa',	'Kenya',	'2019-08-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1335,	'Natural Person',	'North America',	'United States',	'2019-08-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1336,	'Natural Person',	'South America',	'Peru',	'2019-09-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1337,	'Natural Person',	'South America',	'Colombia',	'2019-09-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1338,	'Natural Person',	'South America',	'Colombia',	'2019-09-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1339,	'Natural Person',	'Europe',	'Romania',	'2019-09-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1340,	'Natural Person',	'South America',	'Brazil',	'2019-09-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1341,	'Natural Person',	'North America',	'United States',	'2019-10-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1342,	'Natural Person',	'South America',	'Peru',	'2019-10-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1343,	'Natural Person',	'South America',	'Brazil',	'2019-10-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1344,	'Legal entity',	'South America',	'Brazil',	'2019-10-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1199.4,	1199.4),  (1345,	'Natural Person',	'Europe',	'France',	'2019-11-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1346,	'Natural Person',	'North America',	'United States',	'2019-11-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1347,	'Natural Person',	'North America',	'Guatemala',	'2019-11-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1348,	'Natural Person',	'North America',	'Mexico',	'2019-11-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1349,	'Natural Person',	'South America',	'Colombia',	'2019-11-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1350,	'Natural Person',	'North America',	'Honduras',	'2019-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1351,	'Natural Person',	'South America',	'Argentina',	'2019-12-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1352,	'Natural Person',	'Europe',	'Czech Republic',	'2019-12-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1353,	'Natural Person',	'South America',	'Ecuador',	'2019-12-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1354,	'Natural Person',	'North America',	'United States',	'2019-12-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1355,	'Natural Person',	'Europe',	'Switzerland',	'2019-12-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1356,	'Natural Person',	'South America',	'Bolivia',	'2019-12-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1357,	'Natural Person',	'Europe',	'Italy',	'2020-01-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1358,	'Natural Person',	'South America',	'Colombia',	'2020-01-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1359,	'Natural Person',	'North America',	'Honduras',	'2020-01-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1360,	'Natural Person',	'Europe',	'Germany',	'2020-02-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1361,	'Natural Person',	'Asia',	'India',	'2020-02-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1362,	'Natural Person',	'Asia',	'India',	'2020-02-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1363,	'Natural Person',	'North America',	'United States',	'2020-03-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1364,	'Natural Person',	'South America',	'Colombia',	'2020-03-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1365,	'Natural Person',	'South America',	'Colombia',	'2020-03-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1366,	'Natural Person',	'South America',	'Colombia',	'2020-03-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1367,	'Natural Person',	'South America',	'Argentina',	'2020-03-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1368,	'Natural Person',	'Europe',	'Spain',	'2020-03-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1369,	'Natural Person',	'South America',	'Brazil',	'2020-03-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1370,	'Natural Person',	'North America',	'United States',	'2020-04-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1146.84,	1146.84),  (1371,	'Natural Person',	'Europe',	'Netherlands',	'2020-04-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1372,	'Natural Person',	'North America',	'Canada',	'2020-04-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1373,	'Natural Person',	'Asia',	'Hong Kong',	'2020-04-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1374,	'Natural Person',	'South America',	'Chile',	'2020-04-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1375,	'Natural Person',	'Africa',	'Morocco',	'2020-05-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1376,	'Legal entity',	'Europe',	'United Kingdom',	'2020-05-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1377,	'Natural Person',	'Europe',	'Spain',	'2020-05-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1378,	'Natural Person',	'Europe',	'Germany',	'2020-06-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1379,	'Natural Person',	'Europe',	'United Kingdom',	'2020-06-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1380,	'Natural Person',	'Africa',	'Kenya',	'2020-06-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1381,	'Natural Person',	'Europe',	'France',	'2020-06-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.63,	749.63),  (1382,	'Natural Person',	'Europe',	'Croatia',	'2020-06-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1383,	'Natural Person',	'Asia',	'Indonesia',	'2020-06-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1384,	'Natural Person',	'Africa',	'Ethiopia',	'2020-06-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1385,	'Natural Person',	'Europe',	'Greece',	'2020-06-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1386,	'Natural Person',	'South America',	'Brazil',	'2020-06-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1387,	'Natural Person',	'North America',	'United States',	'2020-07-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1388,	'Natural Person',	'Europe',	'United Kingdom',	'2020-07-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1389,	'Natural Person',	'Europe',	'Netherlands',	'2020-07-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1390,	'Natural Person',	'Europe',	'Spain',	'2020-07-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1391,	'Natural Person',	'Asia',	'Bangladesh',	'2020-07-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1274.36,	1274.36),  (1392,	'Natural Person',	'Asia',	'Israel',	'2020-07-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1393,	'Natural Person',	'Asia',	'Qatar',	'2020-07-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1394,	'Natural Person',	'South America',	'Brazil',	'2020-07-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1395,	'Natural Person',	'North America',	'United States',	'2020-08-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1396,	'Natural Person',	'South America',	'Peru',	'2020-08-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1397,	'Natural Person',	'Europe',	'Germany',	'2020-09-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1398,	'Natural Person',	'North America',	'Canada',	'2020-09-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1399,	'Natural Person',	'Asia',	'Indonesia',	'2020-09-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1400,	'Natural Person',	'North America',	'Barbados',	'2020-09-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1401,	'Natural Person',	'North America',	'Mexico',	'2020-09-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1402,	'Natural Person',	'Europe',	'United Kingdom',	'2020-10-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1403,	'Natural Person',	'South America',	'Peru',	'2020-10-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1404,	'Natural Person',	'South America',	'Colombia',	'2020-10-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1405,	'Natural Person',	'Europe',	'France',	'2020-10-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1406,	'Natural Person',	'North America',	'Mexico',	'2020-10-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1407,	'Natural Person',	'South America',	'Argentina',	'2020-10-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1281.79,	1281.79),  (1408,	'Natural Person',	'South America',	'Colombia',	'2020-10-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1409,	'Natural Person',	'Europe',	'Spain',	'2020-10-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1410,	'Natural Person',	'South America',	'Uruguay',	'2020-10-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1411,	'Legal entity',	'South America',	'Brazil',	'2020-10-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1488.24,	1488.24),  (1412,	'Natural Person',	'North America',	'United States',	'2020-11-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1413,	'Natural Person',	'Asia',	'Indonesia',	'2020-11-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1414,	'Natural Person',	'Asia',	'Malaysia',	'2020-11-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1415,	'Natural Person',	'South America',	'Colombia',	'2020-11-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1416,	'Natural Person',	'North America',	'Mexico',	'2020-11-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1417,	'Natural Person',	'North America',	'Dominican Republic',	'2020-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1418,	'Natural Person',	'Europe',	'Germany',	'2020-12-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1419,	'Natural Person',	'North America',	'Mexico',	'2020-12-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1420,	'Natural Person',	'South America',	'Paraguay',	'2020-12-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	359.55,	359.55),  (1421,	'Natural Person',	'Asia',	'Turkey',	'2020-12-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1422,	'Natural Person',	'Africa',	'South Africa',	'2020-12-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1281.86,	1281.86),  (1423,	'Natural Person',	'Europe',	'Switzerland',	'2020-12-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1424,	'Natural Person',	'Asia',	'Indonesia',	'2020-12-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	855.17,	855.17),  (1425,	'Natural Person',	'Asia',	'Indonesia',	'2020-12-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1305,	1305),  (1426,	'Natural Person',	'North America',	'Mexico',	'2020-12-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1427,	'Natural Person',	'Europe',	'Spain',	'2020-12-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1428,	'Legal entity',	'Europe',	'Spain',	'2020-12-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1429,	'Natural Person',	'Europe',	'Germany',	'2021-01-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1430,	'Legal entity',	'Europe',	'France',	'2021-01-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1199.4,	1199.4),  (1431,	'Natural Person',	'Europe',	'Switzerland',	'2021-01-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1432,	'Natural Person',	'South America',	'Argentina',	'2021-01-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1433,	'Natural Person',	'South America',	'Argentina',	'2021-01-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1434,	'Natural Person',	'Africa',	'Angola',	'2021-01-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1435,	'Natural Person',	'Europe',	'United Kingdom',	'2021-01-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1436,	'Natural Person',	'South America',	'Colombia',	'2021-01-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1437,	'Legal entity',	'Europe',	'United Kingdom',	'2021-01-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1438,	'Natural Person',	'South America',	'Brazil',	'2021-01-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1439,	'Natural Person',	'North America',	'United States',	'2021-03-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1440,	'Natural Person',	'Europe',	'United Kingdom',	'2021-03-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1441,	'Natural Person',	'Europe',	'Italy',	'2021-03-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1442,	'Natural Person',	'South America',	'Colombia',	'2021-03-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1443,	'Natural Person',	'North America',	'United States',	'2021-04-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1444,	'Natural Person',	'North America',	'Mexico',	'2021-04-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1445,	'Natural Person',	'Africa',	'Cameroon',	'2021-05-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1446,	'Natural Person',	'Asia',	'China',	'2021-05-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1447,	'Natural Person',	'Asia',	'Indonesia',	'2021-05-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1448,	'Natural Person',	'Africa',	'Botswana',	'2021-05-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1449,	'Natural Person',	'Africa',	'Morocco',	'2021-05-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1450,	'Natural Person',	'Europe',	'Germany',	'2021-05-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1451,	'Legal entity',	'Europe',	'Russian Federation',	'2021-05-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1214.39,	1214.39),  (1452,	'Natural Person',	'South America',	'Paraguay',	'2021-06-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1453,	'Natural Person',	'South America',	'Chile',	'2021-06-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1454,	'Natural Person',	'South America',	'Argentina',	'2021-06-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1455,	'Natural Person',	'Europe',	'Spain',	'2021-06-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1456,	'Natural Person',	'Europe',	'Italy',	'2021-06-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2996.25,	2996.25),  (1457,	'Natural Person',	'North America',	'United States',	'2021-07-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1349.33,	1349.33),  (1458,	'Natural Person',	'Africa',	'South Africa',	'2021-07-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1459,	'Natural Person',	'Asia',	'Indonesia',	'2021-07-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1460,	'Natural Person',	'Asia',	'Bangladesh',	'2021-07-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1281.79,	1281.79),  (1461,	'Natural Person',	'Africa',	'Cameroon',	'2021-08-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1462,	'Natural Person',	'Asia',	'Hong Kong',	'2021-08-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1463,	'Natural Person',	'Europe',	'United Kingdom',	'2021-08-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1464,	'Natural Person',	'Europe',	'Germany',	'2021-08-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1465,	'Natural Person',	'South America',	'Chile',	'2021-09-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1466,	'Natural Person',	'Europe',	'France',	'2021-09-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1467,	'Natural Person',	'Europe',	'Netherlands',	'2021-09-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1468,	'Natural Person',	'North America',	'Canada',	'2021-09-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1469,	'Natural Person',	'Europe',	'Netherlands',	'2021-09-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1424.29,	1424.29),  (1470,	'Natural Person',	'South America',	'Peru',	'2021-09-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1471,	'Natural Person',	'Africa',	'Gabon',	'2021-09-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1499.25,	1499.25),  (1472,	'Natural Person',	'South America',	'Ecuador',	'2021-09-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1473,	'Natural Person',	'Asia',	'United Arab Emirates',	'2021-09-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1214.63,	1214.63),  (1474,	'Natural Person',	'Europe',	'Netherlands',	'2021-10-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1475,	'Natural Person',	'South America',	'Colombia',	'2021-10-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1476,	'Natural Person',	'South America',	'Colombia',	'2021-10-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	599.25,	599.25),  (1477,	'Natural Person',	'North America',	'United States',	'2021-10-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1478,	'Natural Person',	'North America',	'United States',	'2021-11-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1274.36,	1274.36),  (1479,	'Natural Person',	'Europe',	'United Kingdom',	'2021-11-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1656.86,	1656.86),  (1480,	'Natural Person',	'Africa',	'Ghana',	'2021-11-08',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1481,	'Natural Person',	'Europe',	'Italy',	'2021-11-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1482,	'Natural Person',	'Asia',	'India',	'2021-11-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1483,	'Legal entity',	'Europe',	'Spain',	'2021-11-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1484,	'Natural Person',	'Europe',	'Slovenia',	'2021-11-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1169.55,	1169.55),  (1485,	'Natural Person',	'Africa',	'South Africa',	'2021-11-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.55,	449.55),  (1486,	'Natural Person',	'Europe',	'France',	'2021-11-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.55,	449.55),  (1487,	'Natural Person',	'South America',	'Brazil',	'2021-11-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1169.55,	1169.55),  (1488,	'Natural Person',	'Europe',	'Germany',	'2021-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.55,	449.55),  (1489,	'Natural Person',	'Europe',	'Spain',	'2021-12-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.55,	449.55),  (1490,	'Natural Person',	'North America',	'United States',	'2021-12-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1169.55,	1169.55),  (1491,	'Natural Person',	'Europe',	'United Kingdom',	'2021-12-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1169.55,	1169.55),  (1492,	'Natural Person',	'North America',	'Barbados',	'2021-12-04',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.55,	449.55),  (1493,	'Natural Person',	'Europe',	'United Kingdom',	'2021-12-05',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1169.55,	1169.55),  (1494,	'Natural Person',	'Asia',	'Singapore',	'2021-12-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1495,	'Natural Person',	'Europe',	'United Kingdom',	'2022-01-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1949.25,	1949.25),  (1496,	'Natural Person',	'Europe',	'Liechtenstein',	'2022-01-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1497,	'Legal entity',	'North America',	'United States',	'2022-02-02',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1949.25,	1949.25),  (1498,	'Natural Person',	'Europe',	'United Kingdom',	'2022-02-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1851.79,	1851.79),  (1499,	'Natural Person',	'North America',	'United States',	'2022-08-01',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75);
INSERT INTO `comparison` VALUES (1500,	'Natural Person',	'Europe',	'Austria',	'2022-07-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75),  (1501,	'Natural Person',	'Africa',	'South Africa',	'2022-02-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1949.25,	1949.25),  (1502,	'Natural Person',	'Africa',	'Libyan Arab Jamahiriya',	'2022-02-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1754.33,	1754.33),  (1503,	'Natural Person',	'Africa',	'Ethiopia',	'2022-03-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1504,	'Natural Person',	'South America',	'Colombia',	'2022-04-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	449.55,	449.55),  (1505,	'Natural Person',	'Europe',	'Italy',	'2022-07-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75),  (1506,	'Natural Person',	'Europe',	'United Kingdom',	'2022-07-22',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75),  (1507,	'Natural Person',	'North America',	'Mexico',	'2022-07-05',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75),  (1508,	'Natural Person',	'Asia',	'India',	'2022-06-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1509,	'Natural Person',	'South America',	'Brazil',	'2022-06-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1949.25,	1949.25),  (1510,	'Natural Person',	'Europe',	'Netherlands',	'2022-07-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1461.94,	1461.94),  (1511,	'Legal entity',	'Africa',	'Uganda',	'2022-07-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1709.29,	1709.29),  (1512,	'Natural Person',	'Asia',	'Indonesia',	'2022-08-18',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1709.36,	1709.36),  (1513,	'Legal entity',	'Europe',	'United Kingdom',	'2022-08-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1514,	'Natural Person',	'South America',	'Bolivia',	'2022-08-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1498.5,	1498.5),  (1515,	'Natural Person',	'North America',	'Mexico',	'2022-06-24',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75),  (1516,	'Natural Person',	'Europe',	'Netherlands',	'2022-09-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1949.25,	1949.25),  (1517,	'Natural Person',	'Asia',	'Hong Kong',	'2022-09-14',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1350,	1350),  (1518,	'Natural Person',	'Africa',	'South Africa',	'2022-10-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1956.83,	1956.83),  (1519,	'Natural Person',	'North America',	'Guatemala',	'2022-10-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1520,	'Legal entity',	'Europe',	'United Kingdom',	'2022-10-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	749.25,	749.25),  (1521,	'Natural Person',	'North America',	'Mexico',	'2022-10-31',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1522,	'Natural Person',	'South America',	'Argentina',	'2022-11-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1523,	'Natural Person',	'North America',	'Mexico',	'2022-11-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1524,	'Natural Person',	'Europe',	'Latvia',	'2022-11-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1304.55,	1304.55),  (1525,	'Natural Person',	'Europe',	'Spain',	'2022-11-24',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	494.55,	494.55),  (1526,	'Natural Person',	'North America',	'United States',	'2022-11-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	494.55,	494.55),  (1527,	'Natural Person',	'Europe',	'Italy',	'2022-11-27',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	494.55,	494.55),  (1528,	'Legal entity',	'South America',	'Brazil',	'2022-11-28',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1174.1,	1174.1),  (1529,	'Natural Person',	'South America',	'Brazil',	'2022-11-30',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1304.55,	1304.55),  (1530,	'Natural Person',	'North America',	'United States',	'2023-01-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1531,	'Natural Person',	'Africa',	'Morocco',	'2023-01-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1532,	'Natural Person',	'Asia',	'Indonesia',	'2023-01-19',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1956.83,	1956.83),  (1533,	'Natural Person',	'Asia',	'Indonesia',	'2023-01-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1534,	'Legal entity',	'South America',	'Ecuador',	'2023-02-03',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1535,	'Natural Person',	'South America',	'Chile',	'2023-02-07',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1536,	'Natural Person',	'South America',	'Colombia',	'2023-02-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1537,	'Natural Person',	'Africa',	'Morocco',	'2023-02-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1538,	'Natural Person',	'North America',	'Dominican Republic',	'2023-02-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1956.83,	1956.83),  (1539,	'Natural Person',	'Europe',	'Germany',	'2023-03-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2174.25,	2174.25),  (1540,	'Natural Person',	'Europe',	'United Kingdom',	'2023-03-06',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2174.25,	2174.25),  (1541,	'Natural Person',	'Europe',	'Switzerland',	'2023-03-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2174.25,	2174.25),  (1542,	'Natural Person',	'South America',	'Argentina',	'2023-03-16',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1875,	1875),  (1543,	'Natural Person',	'North America',	'Dominican Republic',	'2023-03-22',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1956.83,	1956.83),  (1544,	'Natural Person',	'Europe',	'Netherlands',	'2023-04-13',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1739.4,	1739.4),  (1545,	'Natural Person',	'Europe',	'Italy',	'2023-04-17',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	700.61,	700.61),  (1546,	'Natural Person',	'Africa',	'South Africa',	'2023-05-11',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1174.1,	1174.1),  (1547,	'Natural Person',	'North America',	'Canada',	'2023-06-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1956.83,	1956.83),  (1548,	'Natural Person',	'Europe',	'Switzerland',	'2023-06-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1739.25,	1739.25),  (1549,	'Natural Person',	'North America',	'Bahamas',	'2023-06-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2174.25,	2174.25),  (1550,	'Natural Person',	'North America',	'Mexico',	'2023-06-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1551,	'Natural Person',	'Asia',	'Saudi Arabia',	'2023-06-26',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1956.83,	1956.83),  (1552,	'Natural Person',	'South America',	'Brazil',	'2023-06-29',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2174.25,	2174.25),  (1553,	'Natural Person',	'North America',	'Canada',	'2023-07-09',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2174.25,	2174.25),  (1554,	'Natural Person',	'Europe',	'Switzerland',	'2023-07-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1858.91,	1858.91),  (1555,	'Natural Person',	'Asia',	'Bangladesh',	'2023-07-20',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	1858.98,	1858.98),  (1556,	'Natural Person',	'Europe',	'Italy',	'2023-08-01',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1557,	'Legal entity',	'Europe',	'United Kingdom',	'2023-08-23',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	824.25,	824.25),  (1558,	'Legal entity',	'North America',	'Mexico',	'2023-09-25',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	906.75,	906.75),  (1559,	'Natural Person',	'Asia',	'Viet Nam',	'2023-10-10',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	906.75,	906.75),  (1560,	'Natural Person',	'Europe',	'Switzerland',	'2023-10-12',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	2399.25,	2399.25),  (1561,	'Legal entity',	'South America',	'Colombia',	'2023-10-21',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	906.75,	906.75),  (1562,	'Natural Person',	'North America',	'United States',	'2023-11-15',	'1.1 Eletronics',	'CyberPulse Gaming Laptop',	1,	906.75,	906.75),  (1563,	'Natural Person',	'South America',	'Brazil',	'2017-05-31',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2999.25,	2999.25),  (1564,	'Legal entity',	'Europe',	'Netherlands',	'2018-08-13',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1889.53,	1889.53),  (1565,	'Legal entity',	'Africa',	'Mali',	'2018-09-24',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2099.48,	2099.48),  (1566,	'Legal entity',	'North America',	'Panama',	'2018-09-25',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1889.53,	1889.53),  (1567,	'Legal entity',	'North America',	'United States',	'2018-10-02',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3828.41,	3828.41),  (1568,	'Natural Person',	'Asia',	'Hong Kong',	'2018-10-15',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2159.33,	2159.33),  (1569,	'Legal entity',	'Europe',	'France',	'2018-11-08',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2159.46,	2159.46),  (1570,	'Natural Person',	'Asia',	'Indonesia',	'2019-01-18',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2399.4,	2399.4),  (1571,	'Legal entity',	'Europe',	'Italy',	'2019-03-07',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2159.46,	2159.46),  (1572,	'Legal entity',	'North America',	'United States',	'2019-05-02',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.33,	2699.33),  (1573,	'Legal entity',	'Europe',	'United Kingdom',	'2019-05-03',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.25,	2699.25),  (1574,	'public company',	'Europe',	'Netherlands',	'2019-05-13',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	4324.5,	4324.5),  (1575,	'Legal entity',	'Africa',	'South Africa',	'2019-07-11',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2850,	2850),  (1576,	'Legal entity',	'Europe',	'Germany',	'2019-08-01',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.25,	2699.25),  (1577,	'Legal entity',	'Europe',	'United Kingdom',	'2019-09-04',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.33,	2699.33),  (1578,	'Legal entity',	'Europe',	'Spain',	'2019-10-17',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.33,	2699.33),  (1579,	'Natural Person',	'Europe',	'France',	'2019-12-07',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1799.55,	1799.55),  (1580,	'Legal entity',	'Europe',	'Switzerland',	'2020-08-12',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	5398.65,	5398.65),  (1581,	'Legal entity',	'Asia',	'Jordan',	'2020-10-23',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.33,	2699.33),  (1582,	'Legal entity',	'North America',	'Canada',	'2020-12-09',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	1799.55,	1799.55),  (1583,	'Legal entity',	'North America',	'United States',	'2021-02-02',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2850,	2850),  (1584,	'Legal entity',	'South America',	'Argentina',	'2021-02-17',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	9597.6,	9597.6),  (1585,	'Legal entity',	'Asia',	'Qatar',	'2021-02-26',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	5398.65,	5398.65),  (1586,	'Legal entity',	'Asia',	'Indonesia',	'2021-03-19',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2699.33,	2699.33),  (1587,	'Natural Person',	'North America',	'Dominican Republic',	'2021-03-22',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2625,	2625),  (1588,	'Legal entity',	'Europe',	'United Kingdom',	'2021-04-06',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2999.25,	2999.25),  (1589,	'Legal entity',	'Europe',	'Hungary',	'2021-04-23',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2999.25,	2999.25),  (1590,	'Legal entity',	'Europe',	'United Kingdom',	'2021-05-03',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2999.25,	2999.25),  (1591,	'Legal entity',	'North America',	'Canada',	'2021-06-09',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	4858.79,	4858.79),  (1592,	'Legal entity',	'South America',	'Brazil',	'2021-09-29',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2999.25,	2999.25),  (1593,	'Legal entity',	'Europe',	'United Kingdom',	'2022-01-05',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3509.33,	3509.33),  (1594,	'Legal entity',	'Europe',	'Switzerland',	'2022-03-12',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	2999.25,	2999.25),  (1595,	'Legal entity',	'Europe',	'United Kingdom',	'2022-04-04',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3899.25,	3899.25),  (1596,	'Legal entity',	'North America',	'United States',	'2022-05-02',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	900,	900),  (1597,	'Legal entity',	'Africa',	'South Africa',	'2022-08-10',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3509.33,	3509.33),  (1598,	'Natural Person',	'North America',	'Panama',	'2022-08-25',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3899.25,	3899.25),  (1599,	'Legal entity',	'Asia',	'Hong Kong',	'2022-09-19',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3899.25,	3899.25),  (1600,	'Legal entity',	'Asia',	'United Arab Emirates',	'2022-09-27',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	4349.25,	4349.25),  (1601,	'Natural Person',	'Europe',	'United Kingdom',	'2023-01-06',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3000,	3000),  (1602,	'Natural Person',	'Europe',	'Switzerland',	'2023-01-13',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3000,	3000),  (1603,	'Legal entity',	'South America',	'Brazil',	'2023-01-31',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	7045.79,	7045.79),  (1604,	'Legal entity',	'Europe',	'Netherlands',	'2023-02-14',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	9975,	9975),  (1605,	'Legal entity',	'Oceania',	'Australia',	'2023-03-20',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	4349.25,	4349.25),  (1606,	'Legal entity',	'Asia',	'Indonesia',	'2023-05-18',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	7828.65,	7828.65),  (1607,	'Legal entity',	'South America',	'Argentina',	'2023-06-16',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	3914.33,	3914.33),  (1608,	'Legal entity',	'Europe',	'United Kingdom',	'2023-08-04',	'1.1 Eletronics',	'AstroWave Noise-Canceling Headphones',	1,	4349.25,	4349.25),  (1609,	'Legal entity',	'Europe',	'Germany',	'2017-05-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	749.25,	749.25),  (1610,	'Legal entity',	'Asia',	'Indonesia',	'2017-05-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1992.15,	1992.15),  (1611,	'Natural Person',	'Europe',	'Italy',	'2018-09-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	971.19,	971.19),  (1612,	'Natural Person',	'North America',	'United States',	'2018-09-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	539.55,	539.55),  (1613,	'Natural Person',	'Europe',	'Portugal',	'2018-09-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	971.19,	971.19),  (1614,	'Natural Person',	'South America',	'Chile',	'2018-09-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1375.85,	1375.85),  (1615,	'Natural Person',	'South America',	'Paraguay',	'2018-10-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1213.98,	1213.98),  (1616,	'Natural Person',	'Asia',	'Malaysia',	'2018-10-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	539.55,	539.55),  (1617,	'Natural Person',	'Europe',	'United Kingdom',	'2018-10-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	674.44,	674.44),  (1618,	'Natural Person',	'South America',	'Ecuador',	'2018-10-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	674.44,	674.44),  (1619,	'Natural Person',	'South America',	'Argentina',	'2018-10-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	599.25,	599.25),  (1620,	'Natural Person',	'South America',	'Chile',	'2018-10-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1213.98,	1213.98),  (1621,	'Natural Person',	'Europe',	'Italy',	'2018-10-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1238.27,	1238.27),  (1622,	'Legal entity',	'North America',	'Guatemala',	'2018-10-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	566.53,	566.53),  (1623,	'Natural Person',	'Europe',	'Switzerland',	'2018-11-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1294.92,	1294.92),  (1624,	'Natural Person',	'Oceania',	'Kiribati',	'2018-11-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	941.19,	941.19),  (1625,	'Legal entity',	'South America',	'Chile',	'2018-11-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1626,	'Natural Person',	'Europe',	'Switzerland',	'2018-11-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1627,	'Natural Person',	'North America',	'Mexico',	'2018-12-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2302.08,	2302.08),  (1628,	'Natural Person',	'North America',	'Panama',	'2018-12-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1294.92,	1294.92),  (1629,	'Natural Person',	'Europe',	'Italy',	'2018-12-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	611.25,	611.25),  (1630,	'Natural Person',	'Europe',	'United Kingdom',	'2019-01-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1631,	'Natural Person',	'Europe',	'Italy',	'2019-01-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	611.25,	611.25),  (1632,	'Natural Person',	'Europe',	'Italy',	'2019-01-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1633,	'Natural Person',	'North America',	'United States',	'2019-01-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1634,	'Natural Person',	'Europe',	'Germany',	'2019-01-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1294.92,	1294.92),  (1635,	'Natural Person',	'Asia',	'Saudi Arabia',	'2019-02-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1035.93,	1035.93),  (1636,	'Natural Person',	'South America',	'Ecuador',	'2019-02-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1637,	'Natural Person',	'North America',	'Mexico',	'2019-03-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1834.47,	1834.47),  (1638,	'Natural Person',	'Europe',	'Germany',	'2019-03-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1294.92,	1294.92),  (1639,	'Natural Person',	'South America',	'Ecuador',	'2019-03-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1640,	'Natural Person',	'Africa',	'Kenya',	'2019-03-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1641,	'Legal entity',	'Europe',	'United Kingdom',	'2019-03-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1834.47,	1834.47),  (1642,	'Natural Person',	'Europe',	'Spain',	'2019-03-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1643,	'Natural Person',	'North America',	'United States',	'2019-04-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1644,	'Legal entity',	'Asia',	'Indonesia',	'2019-04-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1294.92,	1294.92),  (1645,	'Legal entity',	'Europe',	'United Kingdom',	'2019-04-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1646,	'Natural Person',	'South America',	'Colombia',	'2019-05-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1,	1),  (1647,	'Natural Person',	'Europe',	'Germany',	'2019-05-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1648,	'Natural Person',	'South America',	'Argentina',	'2019-05-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1649,	'Natural Person',	'North America',	'Canada',	'2019-05-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1650,	'Natural Person',	'South America',	'Ecuador',	'2019-05-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1651,	'Natural Person',	'Asia',	'India',	'2019-06-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1652,	'Natural Person',	'North America',	'United States',	'2019-06-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1653,	'Legal entity',	'North America',	'Mexico',	'2019-07-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1798.5,	1798.5),  (1654,	'public company',	'Asia',	'Hong Kong',	'2019-07-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1655,	'Natural Person',	'South America',	'Argentina',	'2019-07-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1656,	'Natural Person',	'Europe',	'Italy',	'2019-08-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1657,	'Natural Person',	'Africa',	'Angola',	'2019-08-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1658,	'public company',	'South America',	'Argentina',	'2019-08-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1659,	'Natural Person',	'Europe',	'France',	'2019-08-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1660,	'Natural Person',	'South America',	'Ecuador',	'2019-09-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1661,	'Natural Person',	'South America',	'Chile',	'2019-09-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1662,	'Natural Person',	'North America',	'Canada',	'2019-09-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1663,	'Natural Person',	'Asia',	'Thailand',	'2019-09-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1664,	'Natural Person',	'Asia',	'Malaysia',	'2019-09-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1665,	'Natural Person',	'Europe',	'Germany',	'2019-10-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1666,	'Natural Person',	'North America',	'United States',	'2019-10-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1667,	'public company',	'Asia',	'Hong Kong',	'2019-11-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1668,	'Natural Person',	'Asia',	'Thailand',	'2019-11-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1669,	'Natural Person',	'North America',	'Mexico',	'2019-12-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1670,	'Natural Person',	'South America',	'Argentina',	'2020-01-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1671,	'Legal entity',	'North America',	'United States',	'2020-01-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4724.33,	4724.33),  (1672,	'public company',	'Europe',	'Switzerland',	'2020-01-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1673,	'Natural Person',	'Asia',	'Indonesia',	'2020-01-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1674,	'Natural Person',	'South America',	'Paraguay',	'2020-02-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1675,	'Natural Person',	'Europe',	'Spain',	'2020-02-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1676,	'Natural Person',	'North America',	'Mexico',	'2020-02-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1677,	'Natural Person',	'Asia',	'Lebanon',	'2020-03-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1678,	'Natural Person',	'South America',	'Colombia',	'2020-04-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1679,	'Natural Person',	'Europe',	'Italy',	'2020-04-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1680,	'Legal entity',	'Africa',	'Angola',	'2020-04-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1681,	'Natural Person',	'North America',	'United States',	'2020-05-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1682,	'Natural Person',	'South America',	'Colombia',	'2020-05-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1683,	'Natural Person',	'Europe',	'Spain',	'2020-05-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1684,	'public company',	'South America',	'Brazil',	'2020-05-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1685,	'Natural Person',	'Asia',	'India',	'2020-05-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1686,	'public company',	'North America',	'United States',	'2020-06-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	26246.25,	26246.25),  (1687,	'Legal entity',	'Europe',	'United Kingdom',	'2020-06-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3149.55,	3149.55),  (1688,	'Natural Person',	'South America',	'Colombia',	'2020-06-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1689,	'Natural Person',	'Europe',	'Belgium',	'2020-06-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1690,	'Legal entity',	'Africa',	'Morocco',	'2020-06-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1691,	'Natural Person',	'North America',	'United States',	'2020-08-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1169.55,	1169.55),  (1692,	'Legal entity',	'Asia',	'Indonesia',	'2020-08-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	719.4,	719.4),  (1693,	'Legal entity',	'Africa',	'Sierra Leone',	'2020-08-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	11250,	11250),  (1694,	'Natural Person',	'South America',	'Ecuador',	'2020-09-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1695,	'Natural Person',	'Asia',	'Philippines',	'2020-09-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	809.33,	809.33),  (1696,	'Legal entity',	'Asia',	'Hong Kong',	'2020-09-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1697,	'Natural Person',	'South America',	'Chile',	'2020-09-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1698,	'Natural Person',	'Europe',	'United Kingdom',	'2020-09-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1699,	'Natural Person',	'Europe',	'Switzerland',	'2020-10-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1700,	'public company',	'Europe',	'United Kingdom',	'2020-11-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	7650,	7650),  (1701,	'Natural Person',	'North America',	'Nicaragua',	'2020-11-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3372.19,	3372.19),  (1702,	'Legal entity',	'Europe',	'Spain',	'2020-11-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1703,	'Legal entity',	'Asia',	'Afghanistan',	'2020-11-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3150,	3150),  (1704,	'Natural Person',	'Europe',	'Italy',	'2020-12-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1705,	'Natural Person',	'South America',	'Colombia',	'2020-12-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1706,	'Natural Person',	'Europe',	'Spain',	'2021-01-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2293.09,	2293.09),  (1707,	'Natural Person',	'Europe',	'Italy',	'2021-01-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1708,	'Legal entity',	'Europe',	'Switzerland',	'2021-01-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1709,	'Natural Person',	'Asia',	'Turkey',	'2021-02-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1710,	'Legal entity',	'Europe',	'United Kingdom',	'2021-02-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4461.86,	4461.86),  (1711,	'Legal entity',	'North America',	'Canada',	'2021-02-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	8923.5,	8923.5),  (1712,	'Natural Person',	'Europe',	'Spain',	'2021-02-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1713,	'Natural Person',	'North America',	'Guatemala',	'2021-02-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1714,	'Natural Person',	'North America',	'El Salvador',	'2021-03-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3203.55,	3203.55),  (1715,	'Natural Person',	'Europe',	'Italy',	'2021-03-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1716,	'Legal entity',	'Europe',	'Romania',	'2021-03-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4200,	4200),  (1717,	'Natural Person',	'Europe',	'Spain',	'2021-04-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1718,	'Natural Person',	'Europe',	'Germany',	'2021-04-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	247.8,	247.8),  (1719,	'Natural Person',	'Asia',	'Malaysia',	'2021-04-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2293.09,	2293.09),  (1720,	'Natural Person',	'North America',	'United States',	'2021-04-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1721,	'Natural Person',	'South America',	'Chile',	'2021-04-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1722,	'public company',	'Europe',	'United Kingdom',	'2021-05-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1723,	'public company',	'Africa',	'South Africa',	'2021-05-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	26246.25,	26246.25),  (1724,	'Natural Person',	'Oceania',	'Australia',	'2021-05-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1725,	'Natural Person',	'Asia',	'Thailand',	'2021-06-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1726,	'Natural Person',	'South America',	'Ecuador',	'2021-06-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1727,	'Natural Person',	'Europe',	'Italy',	'2021-07-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1728,	'Legal entity',	'Europe',	'Spain',	'2021-07-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1729,	'Natural Person',	'Africa',	'Nigeria',	'2021-07-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1730,	'Natural Person',	'South America',	'Ecuador',	'2021-08-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5395.5,	5395.5),  (1731,	'Natural Person',	'North America',	'Mexico',	'2021-08-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1732,	'Natural Person',	'South America',	'Ecuador',	'2021-08-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1733,	'Natural Person',	'South America',	'Colombia',	'2021-08-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1618.65,	1618.65),  (1734,	'Legal entity',	'Europe',	'United Kingdom',	'2021-09-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	899.25,	899.25),  (1735,	'Natural Person',	'South America',	'Chile',	'2021-09-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2293.09,	2293.09),  (1736,	'Natural Person',	'North America',	'Mexico',	'2021-10-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2675.59,	2675.59),  (1737,	'Legal entity',	'South America',	'Colombia',	'2021-10-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1738,	'Natural Person',	'North America',	'Mexico',	'2021-10-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1739,	'Natural Person',	'Africa',	'South Africa',	'2021-10-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1740,	'Natural Person',	'North America',	'United States',	'2021-10-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1741,	'Natural Person',	'Asia',	'Thailand',	'2021-11-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1742,	'public company',	'North America',	'Haiti',	'2021-11-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	10498.5,	10498.5),  (1743,	'public company',	'South America',	'Bolivia',	'2021-12-20',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	10498.5,	10498.5),  (1744,	'Natural Person',	'Asia',	'Cyprus',	'2021-12-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1745,	'Natural Person',	'Asia',	'Thailand',	'2022-01-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1746,	'Natural Person',	'North America',	'United States',	'2022-01-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1747,	'Natural Person',	'Asia',	'Hong Kong',	'2022-01-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1748,	'Natural Person',	'South America',	'Peru',	'2022-01-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4197,	4197),  (1749,	'Natural Person',	'North America',	'Panama',	'2022-01-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	7869.38,	7869.38),  (1750,	'Natural Person',	'North America',	'Mexico',	'2022-01-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3357.6,	3357.6),  (1751,	'Natural Person',	'North America',	'Mexico',	'2022-02-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1752,	'Natural Person',	'Europe',	'Italy',	'2022-03-04',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1753,	'public company',	'Europe',	'Italy',	'2022-03-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	5249.25,	5249.25),  (1754,	'Natural Person',	'South America',	'Ecuador',	'2022-03-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1755,	'Natural Person',	'Europe',	'Germany',	'2022-03-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1756,	'Legal entity',	'North America',	'Nicaragua',	'2022-03-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2675.59,	2675.59),  (1757,	'Legal entity',	'South America',	'Chile',	'2022-03-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1758,	'Natural Person',	'Asia',	'Jordan',	'2022-03-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1759,	'Natural Person',	'Asia',	'Yemen',	'2022-03-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1760,	'Natural Person',	'Europe',	'Italy',	'2022-04-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1761,	'Natural Person',	'Asia',	'Thailand',	'2022-04-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1762,	'Natural Person',	'North America',	'United States',	'2022-04-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1763,	'Natural Person',	'South America',	'Colombia',	'2022-05-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1764,	'Legal entity',	'South America',	'Peru',	'2022-05-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1765,	'Natural Person',	'Europe',	'Portugal',	'2022-05-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1766,	'public company',	'Asia',	'Oman',	'2022-05-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	13648.5,	13648.5),  (1767,	'Natural Person',	'South America',	'Colombia',	'2022-05-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1888.65,	1888.65),  (1768,	'Natural Person',	'North America',	'El Salvador',	'2022-05-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1888.65,	1888.65),  (1769,	'Legal entity',	'Europe',	'United Kingdom',	'2022-06-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1770,	'Natural Person',	'Europe',	'Italy',	'2022-06-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1771,	'Legal entity',	'North America',	'Mexico',	'2022-06-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1888.65,	1888.65),  (1772,	'Legal entity',	'Asia',	'Philippines',	'2022-06-29',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1773,	'Legal entity',	'Asia',	'Indonesia',	'2022-07-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	10498.5,	10498.5),  (1774,	'Natural Person',	'North America',	'United States',	'2022-08-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1775,	'Natural Person',	'Asia',	'Thailand',	'2022-08-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2098.5,	2098.5),  (1776,	'Natural Person',	'North America',	'Honduras',	'2022-08-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1777,	'Legal entity',	'North America',	'Mexico',	'2022-08-17',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1888.65,	1888.65),  (1778,	'Natural Person',	'South America',	'Ecuador',	'2022-08-26',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2675.59,	2675.59),  (1779,	'Natural Person',	'Asia',	'Thailand',	'2022-09-01',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1780,	'Natural Person',	'South America',	'Argentina',	'2022-09-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1049.25,	1049.25),  (1781,	'public company',	'South America',	'Argentina',	'2022-09-16',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	6824.25,	6824.25),  (1782,	'Natural Person',	'North America',	'Honduras',	'2022-09-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3717.6,	3717.6),  (1783,	'Natural Person',	'North America',	'United States',	'2022-10-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1784,	'Legal entity',	'Europe',	'Italy',	'2022-10-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1882.04,	1882.04),  (1785,	'public company',	'Asia',	'Hong Kong',	'2022-10-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	20472.75,	20472.75),  (1786,	'Natural Person',	'Asia',	'Malaysia',	'2022-10-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1787,	'Legal entity',	'North America',	'Canada',	'2022-12-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4009.88,	4009.88),  (1788,	'Natural Person',	'South America',	'Colombia',	'2022-12-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1789,	'Natural Person',	'South America',	'Ecuador',	'2022-12-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	3357.6,	3357.6),  (1790,	'Natural Person',	'Africa',	'Algeria',	'2022-12-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1791,	'Legal entity',	'South America',	'Chile',	'2022-12-28',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1792,	'Natural Person',	'Europe',	'Spain',	'2023-01-02',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1793,	'Natural Person',	'Europe',	'United Kingdom',	'2023-01-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1794,	'Natural Person',	'Europe',	'Spain',	'2023-01-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1795,	'Legal entity',	'Europe',	'United Kingdom',	'2023-01-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4356.56,	4356.56),  (1796,	'Legal entity',	'Europe',	'United Kingdom',	'2023-02-06',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	7425,	7425),  (1797,	'Natural Person',	'North America',	'Mexico',	'2023-03-07',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1798,	'Natural Person',	'South America',	'Venezuela',	'2023-03-08',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1799,	'Natural Person',	'North America',	'Dominican Republic',	'2023-03-09',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2962.46,	2962.46),  (1800,	'Legal entity',	'Europe',	'United Kingdom',	'2023-03-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1801,	'Legal entity',	'Europe',	'United Kingdom',	'2023-03-21',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1802,	'Natural Person',	'Africa',	'South Africa',	'2023-03-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1803,	'Natural Person',	'Europe',	'Italy',	'2023-03-30',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1804,	'Natural Person',	'North America',	'Panama',	'2023-04-05',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4356.56,	4356.56),  (1805,	'Legal entity',	'Europe',	'United Kingdom',	'2023-04-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1806,	'Legal entity',	'Europe',	'United Kingdom',	'2023-04-25',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1807,	'Legal entity',	'Europe',	'Lithuania',	'2023-04-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	29250,	29250),  (1808,	'Natural Person',	'South America',	'Ecuador',	'2023-06-14',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1809,	'Legal entity',	'North America',	'Mexico',	'2023-06-15',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1810,	'Natural Person',	'Europe',	'Spain',	'2023-06-23',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1811,	'Legal entity',	'North America',	'Mexico',	'2023-07-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1812,	'Natural Person',	'Asia',	'Thailand',	'2023-08-10',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1813,	'Legal entity',	'South America',	'Uruguay',	'2023-08-11',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1814,	'Natural Person',	'North America',	'Mexico',	'2023-08-18',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1045.58,	1045.58),  (1815,	'Natural Person',	'Asia',	'Thailand',	'2023-08-24',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1816,	'Natural Person',	'Asia',	'Thailand',	'2023-08-31',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1161.75,	1161.75),  (1817,	'Natural Person',	'North America',	'Canada',	'2023-09-12',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	1289.25,	1289.25),  (1818,	'Legal entity',	'South America',	'Ecuador',	'2023-09-13',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	2091.15,	2091.15),  (1819,	'public company',	'Africa',	'Gabon',	'2023-09-22',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	6824.25,	6824.25),  (1820,	'public company',	'Asia',	'United Arab Emirates',	'2023-09-27',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	13200,	13200),  (1821,	'Legal entity',	'Europe',	'United Kingdom',	'2023-10-19',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	4834.69,	4834.69),  (1822,	'public company',	'Europe',	'United Kingdom',	'2023-11-03',	'1.1 Eletronics',	'SmartTech Pro-2000 Smartphone',	1,	8174.25,	8174.25),  (1823,	'Natural Person',	'Europe',	'United Kingdom',	'2021-10-05',	'2.4 Sports and Outdoors',	'SummitSeeker Lightweight Camping Tent',	1,	1893.75,	1893.75),  (1824,	'Legal entity',	'Europe',	'Italy',	'2022-01-20',	'2.1 Books and Stationery',	'QuillCraft Deluxe Fountain Pen',	1,	254.7,	254.7),  (1825,	'Natural Person',	'Europe',	'United Kingdom',	'2018-10-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	863.4,	863.4),  (1826,	'Legal entity',	'Asia',	'Indonesia',	'2018-12-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	431.78,	431.78),  (1827,	'Legal entity',	'South America',	'Argentina',	'2019-05-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	525,	525),  (1828,	'Natural Person',	'Europe',	'Germany',	'2019-07-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.73,	539.73),  (1829,	'Legal entity',	'North America',	'United States',	'2019-10-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.73,	539.73),  (1830,	'Natural Person',	'Asia',	'Jordan',	'2019-10-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.73,	239.73),  (1831,	'Legal entity',	'Asia',	'Indonesia',	'2020-05-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.73,	539.73),  (1832,	'Natural Person',	'Europe',	'Italy',	'2020-08-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.3,	279.3),  (1833,	'Legal entity',	'Asia',	'Singapore',	'2020-10-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	487.5,	487.5),  (1834,	'Natural Person',	'South America',	'Argentina',	'2021-08-30',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.6,	299.6),  (1835,	'Natural Person',	'South America',	'Argentina',	'2021-10-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (1836,	'Natural Person',	'Europe',	'Italy',	'2021-12-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.76,	239.76),  (1837,	'Legal entity',	'Europe',	'Italy',	'2021-12-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.76,	239.76),  (1838,	'Natural Person',	'Europe',	'France',	'2022-07-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (1839,	'Legal entity',	'Europe',	'Portugal',	'2022-07-08',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (1840,	'Natural Person',	'Europe',	'Switzerland',	'2022-07-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	701.73,	701.73),  (1841,	'Natural Person',	'Europe',	'Italy',	'2022-11-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	329.7,	329.7),  (1842,	'Natural Person',	'Africa',	'South Africa',	'2023-05-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	782.73,	782.73),  (1843,	'Natural Person',	'Asia',	'United Arab Emirates',	'2018-08-27',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	755.81,	755.81),  (1844,	'Natural Person',	'Europe',	'Netherlands',	'2018-11-13',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	960,	960),  (1845,	'Legal entity',	'Africa',	'Algeria',	'2018-12-19',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2879.28,	2879.28),  (1846,	'Legal entity',	'Europe',	'Germany',	'2019-02-01',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1538.61,	1538.61),  (1847,	'Legal entity',	'South America',	'Paraguay',	'2019-10-25',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3599.1,	3599.1),  (1848,	'public company',	'Africa',	'Algeria',	'2019-12-19',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	5398.65,	5398.65),  (1849,	'Natural Person',	'Europe',	'Latvia',	'2019-12-23',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	719.82,	719.82),  (1850,	'Legal entity',	'Europe',	'France',	'2020-04-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2250,	2250),  (1851,	'Legal entity',	'Europe',	'United Kingdom',	'2020-08-05',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1079.73,	1079.73),  (1852,	'Legal entity',	'Europe',	'United Kingdom',	'2022-02-04',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3000,	3000),  (1853,	'Legal entity',	'Europe',	'United Kingdom',	'2022-05-05',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1379.7,	1379.7),  (1854,	'Legal entity',	'Asia',	'Saudi Arabia',	'2022-07-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2625,	2625),  (1855,	'Legal entity',	'Asia',	'Hong Kong',	'2022-09-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1559.7,	1559.7),  (1856,	'Legal entity',	'Europe',	'Netherlands',	'2022-10-13',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1391.76,	1391.76),  (1857,	'Natural Person',	'Europe',	'France',	'2022-12-07',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	750,	750),  (1858,	'Legal entity',	'Asia',	'Hong Kong',	'2022-12-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3757.82,	3757.82),  (1859,	'Legal entity',	'North America',	'Puerto Rico',	'2023-01-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3300,	3300),  (1860,	'Legal entity',	'Europe',	'Spain',	'2023-07-17',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1560,	1560),  (1861,	'Legal entity',	'Asia',	'Hong Kong',	'2023-07-19',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2790,	2790),  (1862,	'Legal entity',	'Asia',	'Hong Kong',	'2023-08-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	6958.8,	6958.8),  (1863,	'Legal entity',	'South America',	'Brazil',	'2023-08-29',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	3131.46,	3131.46),  (1864,	'Legal entity',	'Europe',	'United Kingdom',	'2023-09-06',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1739.7,	1739.7),  (1865,	'Natural Person',	'Asia',	'Singapore',	'2023-09-26',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	7678.8,	7678.8),  (1866,	'Legal entity',	'North America',	'United States',	'2023-10-02',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1725,	1725),  (1867,	'public company',	'Europe',	'United Kingdom',	'2018-08-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10800,	10800),  (1868,	'Legal entity',	'Asia',	'Hong Kong',	'2018-11-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2190,	2190),  (1869,	'Natural Person',	'Europe',	'Austria',	'2019-02-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	863.28,	863.28),  (1870,	'Legal entity',	'South America',	'Argentina',	'2019-04-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9000,	9000),  (1871,	'Legal entity',	'Asia',	'Indonesia',	'2019-04-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4798.8,	4798.8),  (1872,	'Natural Person',	'Europe',	'Italy',	'2019-05-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (1873,	'Legal entity',	'Africa',	'Botswana',	'2019-05-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3149.55,	3149.55),  (1874,	'Legal entity',	'Europe',	'Italy',	'2019-06-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (1875,	'public company',	'Europe',	'France',	'2019-07-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2099.7,	2099.7),  (1876,	'public company',	'Europe',	'Netherlands',	'2019-09-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4199.4,	4199.4),  (1877,	'public company',	'Europe',	'Croatia',	'2019-10-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	14850,	14850),  (1878,	'public company',	'Europe',	'Denmark',	'2020-01-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6299.1,	6299.1),  (1879,	'public company',	'Africa',	'South Africa',	'2020-03-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2099.7,	2099.7),  (1880,	'Natural Person',	'Europe',	'Italy',	'2020-04-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (1881,	'public company',	'Europe',	'Netherlands',	'2020-07-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11700,	11700),  (1882,	'Legal entity',	'Europe',	'Romania',	'2020-08-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	611.49,	611.49),  (1883,	'public company',	'North America',	'United States',	'2020-09-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2099.7,	2099.7),  (1884,	'public company',	'South America',	'Brazil',	'2020-09-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6300,	6300),  (1885,	'Legal entity',	'South America',	'Ecuador',	'2021-02-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (1886,	'public company',	'Europe',	'United Kingdom',	'2021-03-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4199.4,	4199.4),  (1887,	'Legal entity',	'North America',	'Mexico',	'2021-03-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	943.43,	943.43),  (1888,	'Legal entity',	'South America',	'Brazil',	'2021-03-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2250,	2250),  (1889,	'Natural Person',	'South America',	'Ecuador',	'2021-04-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2158.2,	2158.2),  (1890,	'public company',	'Europe',	'Switzerland',	'2021-05-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3149.55,	3149.55),  (1891,	'Legal entity',	'South America',	'Peru',	'2021-07-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1438.8,	1438.8),  (1892,	'public company',	'South America',	'Argentina',	'2021-08-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12375,	12375),  (1893,	'public company',	'Asia',	'Hong Kong',	'2021-09-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6300,	6300),  (1894,	'Legal entity',	'North America',	'United States',	'2022-01-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7102.5,	7102.5),  (1895,	'Legal entity',	'South America',	'Argentina',	'2022-01-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	13266.12,	13266.12),  (1896,	'Legal entity',	'Europe',	'Germany',	'2022-02-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4500,	4500),  (1897,	'Legal entity',	'Europe',	'United Kingdom',	'2022-02-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (1898,	'public company',	'Europe',	'Liechtenstein',	'2022-03-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5459.4,	5459.4),  (1899,	'public company',	'Europe',	'United Kingdom',	'2022-06-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	16378.2,	16378.2),  (1900,	'public company',	'Europe',	'France',	'2022-06-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4199.4,	4199.4),  (1901,	'public company',	'North America',	'Canada',	'2022-06-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10498.5,	10498.5),  (1902,	'public company',	'Asia',	'Hong Kong',	'2022-08-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6299.1,	6299.1),  (1903,	'Natural Person',	'Europe',	'Slovenia',	'2022-09-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (1904,	'Legal entity',	'North America',	'Guatemala',	'2022-10-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1259.1,	1259.1),  (1905,	'public company',	'Europe',	'United Kingdom',	'2022-10-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12375,	12375),  (1906,	'Natural Person',	'South America',	'Argentina',	'2022-10-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (1907,	'public company',	'Europe',	'France',	'2022-11-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10918.8,	10918.8),  (1908,	'Legal entity',	'North America',	'United States',	'2022-12-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8910,	8910),  (1909,	'Legal entity',	'Europe',	'Switzerland',	'2022-12-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5219.1,	5219.1),  (1910,	'Legal entity',	'Europe',	'Germany',	'2023-02-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	24003.54,	24003.54),  (1911,	'Legal entity',	'Asia',	'Hong Kong',	'2023-03-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5940,	5940),  (1912,	'Natural Person',	'South America',	'Argentina',	'2023-04-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1394.1,	1394.1),  (1913,	'Natural Person',	'North America',	'United States',	'2023-04-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (1914,	'Legal entity',	'South America',	'Argentina',	'2023-05-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (1915,	'Legal entity',	'North America',	'United States',	'2023-06-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12000,	12000),  (1916,	'public company',	'Europe',	'United Kingdom',	'2023-07-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	16394.4,	16394.4),  (1917,	'Legal entity',	'South America',	'Paraguay',	'2023-10-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	20417.25,	20417.25),  (1918,	'public company',	'North America',	'United States',	'2023-11-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	17820,	17820),  (1919,	'Natural Person',	'Europe',	'Germany',	'2023-11-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1031.4,	1031.4),  (1920,	'public company',	'Asia',	'Hong Kong',	'2019-08-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2549.7,	2549.7),  (1921,	'public company',	'Asia',	'Indonesia',	'2021-02-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9898.65,	9898.65),  (1922,	'public company',	'Europe',	'Netherlands',	'2023-04-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3179.7,	3179.7),  (1923,	'public company',	'Europe',	'United Kingdom',	'2023-08-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8639.1,	8639.1),  (1924,	'public company',	'Asia',	'Hong Kong',	'2019-04-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6345,	6345),  (1925,	'public company',	'South America',	'Brazil',	'2020-04-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11295,	11295),  (1926,	'public company',	'Europe',	'France',	'2023-06-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4124.7,	4124.7),  (1927,	'public company',	'Europe',	'Faroe Islands',	'2023-06-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9584.1,	9584.1),  (1928,	'public company',	'Asia',	'Hong Kong',	'2020-10-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	4764.9,	4764.9),  (1929,	'public company',	'South America',	'Brazil',	'2017-05-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11970,	11970),  (1930,	'Legal entity',	'Europe',	'United Kingdom',	'2019-02-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11576.25,	11576.25),  (1931,	'public company',	'Europe',	'Switzerland',	'2019-06-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	14740.5,	14740.5),  (1932,	'public company',	'South America',	'Argentina',	'2021-12-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10764.3,	10764.3),  (1933,	'public company',	'South America',	'Brazil',	'2022-09-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	18743.7,	18743.7),  (1934,	'Natural Person',	'Oceania',	'Kiribati',	'2019-06-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	786.15,	786.15),  (1935,	'public company',	'South America',	'Brazil',	'2020-08-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2549.7,	2549.7),  (1936,	'public company',	'South America',	'Brazil',	'2021-12-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4649.4,	4649.4),  (1937,	'public company',	'Asia',	'Indonesia',	'2023-04-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5909.4,	5909.4),  (1938,	'public company',	'North America',	'Canada',	'2023-11-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12733.65,	12733.65),  (1939,	'public company',	'Europe',	'United Kingdom',	'2019-06-03',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2594.7,	2594.7),  (1940,	'public company',	'Asia',	'Bangladesh',	'2020-08-20',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2455.2,	2455.2),  (1941,	'public company',	'South America',	'Brazil',	'2021-06-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2455.2,	2455.2),  (1942,	'public company',	'Europe',	'France',	'2020-07-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11893.5,	11893.5),  (1943,	'public company',	'Asia',	'Philippines',	'2020-11-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6345,	6345),  (1944,	'public company',	'Europe',	'France',	'2021-06-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11893.5,	11893.5),  (1945,	'public company',	'North America',	'Canada',	'2022-02-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6854.4,	6854.4),  (1946,	'public company',	'Europe',	'Czech Republic',	'2022-11-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	4544.55,	4544.55),  (1947,	'Legal entity',	'Europe',	'Italy',	'2022-12-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8250,	8250),  (1948,	'public company',	'Europe',	'United Kingdom',	'2023-04-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	13708.8,	13708.8),  (1949,	'public company',	'Africa',	'Tunisia',	'2023-04-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10843.65,	10843.65),  (1950,	'public company',	'South America',	'Argentina',	'2023-08-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	5148.57,	5148.57),  (1951,	'public company',	'Europe',	'Spain',	'2023-08-17',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	12803.7,	12803.7),  (1952,	'public company',	'North America',	'Costa Rica',	'2023-08-21',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	9950.1,	9950.1),  (1953,	'public company',	'Europe',	'Russian Federation',	'2019-04-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	9495,	9495),  (1954,	'public company',	'Asia',	'Turkey',	'2019-05-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11814.15,	11814.15),  (1955,	'public company',	'Europe',	'United Kingdom',	'2019-06-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7020,	7020),  (1956,	'public company',	'South America',	'Brazil',	'2020-06-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8664.6,	8664.6),  (1957,	'public company',	'North America',	'United States',	'2020-10-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	14850,	14850),  (1958,	'public company',	'Europe',	'Italy',	'2020-11-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10764.3,	10764.3),  (1959,	'public company',	'South America',	'Argentina',	'2020-12-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	14964.3,	14964.3),  (1960,	'public company',	'Asia',	'Oman',	'2021-05-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6564.9,	6564.9),  (1961,	'public company',	'Asia',	'Turkey',	'2021-05-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	18113.25,	18113.25),  (1962,	'public company',	'North America',	'Canada',	'2022-03-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	14963.7,	14963.7),  (1963,	'public company',	'Asia',	'Hong Kong',	'2022-06-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7315.5,	7315.5),  (1964,	'public company',	'South America',	'Argentina',	'2022-06-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	8929.5,	8929.5),  (1965,	'public company',	'Europe',	'Bulgaria',	'2022-06-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	14521.5,	14521.5),  (1966,	'public company',	'Africa',	'Gabon',	'2022-09-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	10554.6,	10554.6),  (1967,	'public company',	'Asia',	'Oman',	'2023-05-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7395.93,	7395.93),  (1968,	'public company',	'North America',	'Panama',	'2023-08-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	16014,	16014),  (1969,	'public company',	'Europe',	'Spain',	'2023-10-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7824.9,	7824.9),  (1970,	'Natural Person',	'North America',	'Canada',	'2018-08-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (1971,	'Legal entity',	'Africa',	'South Africa',	'2018-08-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (1972,	'Natural Person',	'Asia',	'Hong Kong',	'2018-08-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (1973,	'public company',	'North America',	'Nicaragua',	'2021-02-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	28125,	28125),  (1974,	'public company',	'Asia',	'China',	'2023-07-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	23759.17,	23759.17),  (1975,	'public company',	'Europe',	'Netherlands',	'2023-11-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	28125,	28125),  (1976,	'public company',	'North America',	'United States',	'2022-11-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	22500,	22500),  (1977,	'Legal entity',	'Asia',	'Jordan',	'2018-10-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	837.44,	837.44),  (1978,	'Legal entity',	'Europe',	'Hungary',	'2019-04-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1395,	1395),  (1979,	'Legal entity',	'Europe',	'France',	'2021-04-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1255.5,	1255.5),  (1980,	'Legal entity',	'South America',	'Brazil',	'2021-07-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	783.79,	783.79),  (1981,	'public company',	'South America',	'Brazil',	'2021-07-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1395,	1395),  (1982,	'Legal entity',	'Europe',	'United Kingdom',	'2022-05-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1170,	1170),  (1983,	'Natural Person',	'Europe',	'Belgium',	'2018-08-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1984,	'Legal entity',	'South America',	'Ecuador',	'2018-10-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1985,	'public company',	'South America',	'Brazil',	'2018-12-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2365.5,	2365.5),  (1986,	'Legal entity',	'South America',	'Colombia',	'2019-02-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	702,	702),  (1987,	'Natural Person',	'North America',	'United States',	'2019-03-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	620.25,	620.25),  (1988,	'Natural Person',	'North America',	'Mexico',	'2019-05-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1989,	'Legal entity',	'Europe',	'United Kingdom',	'2019-05-24',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1990,	'Natural Person',	'South America',	'Chile',	'2019-09-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1991,	'Natural Person',	'Asia',	'Hong Kong',	'2019-10-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1992,	'Legal entity',	'North America',	'Honduras',	'2020-01-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1632.59,	1632.59),  (1993,	'Natural Person',	'Asia',	'Jordan',	'2020-02-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1994,	'Natural Person',	'North America',	'Mexico',	'2020-05-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1995,	'Natural Person',	'Europe',	'Croatia',	'2021-02-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1996,	'Natural Person',	'Oceania',	'Kiribati',	'2021-03-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1997,	'Legal entity',	'Europe',	'United Kingdom',	'2021-03-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	1500,	1500),  (1998,	'Natural Person',	'North America',	'Mexico',	'2021-03-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (1999,	'Natural Person',	'South America',	'Colombia',	'2021-04-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	60.8,	60.8);
INSERT INTO `comparison` VALUES  (2000,	'Legal entity',	'Europe',	'United Kingdom',	'2021-08-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2001,	'Natural Person',	'Europe',	'Italy',	'2021-09-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2002,	'Natural Person',	'Asia',	'Philippines',	'2021-10-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2003,	'Natural Person',	'Europe',	'Croatia',	'2022-02-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2004,	'Natural Person',	'North America',	'Panama',	'2022-05-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2005,	'Legal entity',	'North America',	'El Salvador',	'2022-09-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2006,	'Legal entity',	'Europe',	'France',	'2023-02-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	2365.5,	2365.5),  (2007,	'Natural Person',	'Europe',	'Switzerland',	'2023-03-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	269.1,	269.1),  (2008,	'Natural Person',	'North America',	'Panama',	'2023-03-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	358.8,	358.8),  (2009,	'Natural Person',	'North America',	'United States',	'2023-06-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2010,	'Legal entity',	'North America',	'United States',	'2023-06-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2011,	'Legal entity',	'Europe',	'Italy',	'2023-07-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2012,	'Natural Person',	'Europe',	'Switzerland',	'2023-11-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	246.75,	246.75),  (2013,	'Natural Person',	'North America',	'United States',	'2017-05-18',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	599.4,	599.4),  (2014,	'Natural Person',	'Asia',	'Singapore',	'2017-05-28',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	599.4,	599.4),  (2015,	'Natural Person',	'Oceania',	'Australia',	'2018-08-08',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	242.6,	242.6),  (2016,	'Natural Person',	'North America',	'United States',	'2018-09-06',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	787.56,	787.56),  (2017,	'Natural Person',	'Africa',	'Nigeria',	'2018-09-13',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	314.77,	314.77),  (2018,	'Natural Person',	'South America',	'Peru',	'2018-09-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	32.78,	32.78),  (2019,	'Natural Person',	'South America',	'Ecuador',	'2018-09-22',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	278.26,	278.26),  (2020,	'Natural Person',	'North America',	'United States',	'2018-10-21',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	491.19,	491.19),  (2021,	'Legal entity',	'North America',	'Mexico',	'2018-12-24',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	550.96,	550.96),  (2022,	'Natural Person',	'Europe',	'Germany',	'2019-01-09',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	610.98,	610.98),  (2023,	'Legal entity',	'North America',	'Mexico',	'2019-01-10',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	101.61,	101.61),  (2024,	'Natural Person',	'North America',	'United States',	'2019-02-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	948.23,	948.23),  (2025,	'Legal entity',	'Europe',	'Finland',	'2019-03-18',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	314.6,	314.6),  (2026,	'Legal entity',	'South America',	'Colombia',	'2019-03-22',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	647.46,	647.46),  (2027,	'Natural Person',	'Europe',	'Germany',	'2019-04-10',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	197.92,	197.92),  (2028,	'Legal entity',	'South America',	'Colombia',	'2019-06-11',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	538.81,	538.81),  (2029,	'Natural Person',	'Europe',	'Germany',	'2019-06-29',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2030,	'Legal entity',	'North America',	'United States',	'2019-07-02',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	10498.5,	10498.5),  (2031,	'Natural Person',	'Europe',	'France',	'2019-07-12',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	228.2,	228.2),  (2032,	'Legal entity',	'Europe',	'Spain',	'2019-09-30',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	763.73,	763.73),  (2033,	'Natural Person',	'Europe',	'Spain',	'2019-10-03',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	313.49,	313.49),  (2034,	'Natural Person',	'Europe',	'Italy',	'2019-10-14',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	726.84,	726.84),  (2035,	'Natural Person',	'South America',	'Colombia',	'2019-11-27',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	242.6,	242.6),  (2036,	'Natural Person',	'Asia',	'Thailand',	'2020-01-18',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	1296.05,	1296.05),  (2037,	'Legal entity',	'North America',	'Mexico',	'2020-01-25',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	763.73,	763.73),  (2038,	'Natural Person',	'Europe',	'Italy',	'2020-02-19',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	268.81,	268.81),  (2039,	'Legal entity',	'South America',	'Argentina',	'2020-03-01',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2040,	'Natural Person',	'South America',	'Uruguay',	'2020-04-12',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2041,	'Natural Person',	'North America',	'United States',	'2020-04-13',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2042,	'Natural Person',	'Asia',	'Thailand',	'2020-04-22',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	326.78,	326.78),  (2043,	'Natural Person',	'North America',	'Dominican Republic',	'2020-05-09',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2044,	'Natural Person',	'Asia',	'India',	'2020-05-11',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	358.91,	358.91),  (2045,	'Natural Person',	'Europe',	'United Kingdom',	'2020-07-02',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	693.14,	693.14),  (2046,	'Legal entity',	'South America',	'Colombia',	'2020-07-15',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	124.07,	124.07),  (2047,	'Legal entity',	'North America',	'Mexico',	'2020-07-24',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2048,	'Natural Person',	'North America',	'Mexico',	'2020-08-13',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	228.08,	228.08),  (2049,	'Natural Person',	'South America',	'Bolivia',	'2020-09-11',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	559.21,	559.21),  (2050,	'Natural Person',	'North America',	'United States',	'2020-09-28',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	594.86,	594.86),  (2051,	'Natural Person',	'North America',	'El Salvador',	'2020-11-09',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	232.63,	232.63),  (2052,	'Natural Person',	'South America',	'Chile',	'2021-03-06',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	229.31,	229.31),  (2053,	'Natural Person',	'Europe',	'Italy',	'2021-03-09',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	718.86,	718.86),  (2054,	'Natural Person',	'South America',	'Colombia',	'2021-03-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	529.38,	529.38),  (2055,	'Natural Person',	'Europe',	'Germany',	'2021-04-03',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	651.45,	651.45),  (2056,	'Legal entity',	'South America',	'Colombia',	'2021-04-13',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	688.4,	688.4),  (2057,	'Natural Person',	'Europe',	'France',	'2021-05-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	315.95,	315.95),  (2058,	'Natural Person',	'Europe',	'Germany',	'2021-07-01',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2059,	'Natural Person',	'North America',	'United States',	'2021-07-17',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	341.18,	341.18),  (2060,	'Natural Person',	'Asia',	'Hong Kong',	'2021-07-26',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	599.12,	599.12),  (2061,	'Natural Person',	'Asia',	'India',	'2021-08-05',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	466.61,	466.61),  (2062,	'Natural Person',	'North America',	'Panama',	'2021-08-10',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2063,	'Natural Person',	'South America',	'Argentina',	'2021-08-18',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	322.35,	322.35),  (2064,	'Natural Person',	'Asia',	'Malaysia',	'2021-08-22',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	572.51,	572.51),  (2065,	'Natural Person',	'Europe',	'Spain',	'2021-09-02',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	231.89,	231.89),  (2066,	'Natural Person',	'South America',	'Chile',	'2021-09-30',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	404.33,	404.33),  (2067,	'Natural Person',	'Asia',	'Thailand',	'2021-10-02',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	194.96,	194.96),  (2068,	'Natural Person',	'Asia',	'India',	'2021-10-26',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	225.64,	225.64),  (2069,	'Natural Person',	'South America',	'Peru',	'2021-11-24',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	312.05,	312.05),  (2070,	'Natural Person',	'South America',	'Colombia',	'2021-12-07',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	424.88,	424.88),  (2071,	'Natural Person',	'Europe',	'Spain',	'2021-12-28',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	399.67,	399.67),  (2072,	'Natural Person',	'North America',	'United States',	'2022-02-19',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	438.08,	438.08),  (2073,	'Natural Person',	'South America',	'Ecuador',	'2022-04-05',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	810.83,	810.83),  (2074,	'Natural Person',	'South America',	'Argentina',	'2022-08-24',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	944.33,	944.33),  (2075,	'Natural Person',	'Europe',	'Belgium',	'2022-08-29',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	944.33,	944.33),  (2076,	'Natural Person',	'North America',	'United States',	'2022-09-02',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	810.83,	810.83),  (2077,	'Natural Person',	'South America',	'Peru',	'2022-11-02',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	891.23,	891.23),  (2078,	'Natural Person',	'South America',	'Argentina',	'2022-12-20',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	368.42,	368.42),  (2079,	'Natural Person',	'Asia',	'Turkey',	'2022-12-27',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	1045.58,	1045.58),  (2080,	'Natural Person',	'North America',	'United States',	'2023-01-09',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	284.39,	284.39),  (2081,	'Legal entity',	'South America',	'Peru',	'2023-04-10',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	891.23,	891.23),  (2082,	'Natural Person',	'North America',	'United States',	'2023-05-30',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	456.6,	456.6),  (2083,	'Natural Person',	'North America',	'United States',	'2023-09-08',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	1160.33,	1160.33),  (2084,	'Natural Person',	'South America',	'Argentina',	'2023-09-18',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	490.64,	490.64),  (2085,	'Natural Person',	'South America',	'Colombia',	'2023-10-04',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	492.05,	492.05),  (2086,	'Natural Person',	'South America',	'Peru',	'2023-11-07',	'2.5 Toys and Games',	'RoboRacers Remote-Controlled Car',	1,	513.39,	513.39),  (2087,	'Legal entity',	'North America',	'Mexico',	'2017-05-09',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	404.33,	404.33),  (2088,	'Legal entity',	'Europe',	'United Kingdom',	'2018-08-16',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	314.55,	314.55),  (2089,	'Natural Person',	'Africa',	'Egypt',	'2018-08-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	314.55,	314.55),  (2090,	'Natural Person',	'South America',	'Peru',	'2018-08-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	314.55,	314.55),  (2091,	'Legal entity',	'South America',	'Colombia',	'2018-09-12',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	277.05,	277.05),  (2092,	'Natural Person',	'Europe',	'France',	'2018-11-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	809.46,	809.46),  (2093,	'Natural Person',	'Asia',	'Indonesia',	'2018-11-09',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	419.4,	419.4),  (2094,	'Legal entity',	'Europe',	'United Kingdom',	'2019-02-12',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	251.64,	251.64),  (2095,	'Natural Person',	'Europe',	'Germany',	'2019-03-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	419.4,	419.4),  (2096,	'Natural Person',	'Europe',	'Spain',	'2019-03-06',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	419.4,	419.4),  (2097,	'Natural Person',	'South America',	'Peru',	'2019-03-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	419.4,	419.4),  (2098,	'Natural Person',	'Europe',	'Spain',	'2019-03-21',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	419.4,	419.4),  (2099,	'Natural Person',	'Africa',	'South Africa',	'2019-03-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	419.4,	419.4),  (2100,	'Natural Person',	'South America',	'Chile',	'2019-04-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	471.83,	471.83),  (2101,	'Natural Person',	'Asia',	'Malaysia',	'2019-04-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2102,	'Natural Person',	'Europe',	'Romania',	'2019-06-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2103,	'Natural Person',	'South America',	'Ecuador',	'2019-06-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2104,	'Natural Person',	'Africa',	'South Africa',	'2019-06-15',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2105,	'Natural Person',	'Europe',	'Spain',	'2019-06-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2106,	'Legal entity',	'Europe',	'United Kingdom',	'2019-07-04',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2107,	'Natural Person',	'South America',	'Colombia',	'2019-07-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2108,	'Natural Person',	'Africa',	'Kenya',	'2019-07-30',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2109,	'Natural Person',	'Asia',	'Thailand',	'2019-08-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2110,	'Natural Person',	'South America',	'Chile',	'2019-08-25',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2111,	'Natural Person',	'South America',	'Peru',	'2019-09-19',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2112,	'Natural Person',	'South America',	'Argentina',	'2019-09-26',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2113,	'Natural Person',	'Asia',	'Philippines',	'2019-10-22',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2114,	'Natural Person',	'Africa',	'Egypt',	'2019-11-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2115,	'Natural Person',	'North America',	'Mexico',	'2020-01-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2116,	'Natural Person',	'Europe',	'Spain',	'2020-02-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2117,	'Natural Person',	'North America',	'Mexico',	'2020-02-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2118,	'Natural Person',	'North America',	'United States',	'2020-03-20',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2119,	'Natural Person',	'Europe',	'Spain',	'2020-03-24',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2120,	'Natural Person',	'Europe',	'Germany',	'2020-04-25',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2121,	'Legal entity',	'Europe',	'United Kingdom',	'2020-06-12',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2122,	'Natural Person',	'South America',	'Chile',	'2020-08-28',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2123,	'Natural Person',	'South America',	'Chile',	'2020-09-08',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2124,	'Natural Person',	'Europe',	'Finland',	'2020-09-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2125,	'Natural Person',	'South America',	'Ecuador',	'2020-10-14',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2126,	'Natural Person',	'Africa',	'South Africa',	'2021-01-18',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2127,	'Natural Person',	'South America',	'Colombia',	'2021-02-05',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2128,	'Natural Person',	'Europe',	'Germany',	'2021-03-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2129,	'Natural Person',	'North America',	'Mexico',	'2021-04-01',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2130,	'Natural Person',	'South America',	'Uruguay',	'2021-04-07',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2131,	'Natural Person',	'Europe',	'Hungary',	'2021-05-23',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2132,	'Natural Person',	'North America',	'Mexico',	'2021-06-03',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2133,	'Natural Person',	'Europe',	'United Kingdom',	'2021-06-10',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2134,	'Natural Person',	'North America',	'Mexico',	'2021-06-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2135,	'Natural Person',	'Europe',	'Spain',	'2021-08-17',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	524.25,	524.25),  (2136,	'Natural Person',	'Europe',	'Germany',	'2022-03-29',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	636.75,	636.75),  (2137,	'Natural Person',	'North America',	'Bahamas',	'2023-10-13',	'1.1 Eletronics',	'PowerMax UltraFast Charger',	1,	786.75,	786.75),  (2138,	'Natural Person',	'North America',	'United States',	'2019-03-09',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	419.4,	419.4),  (2139,	'Natural Person',	'Asia',	'Malaysia',	'2022-10-12',	'1.1 Eletronics',	'QuantumDrive External SSD',	1,	711.75,	711.75),  (2140,	'Legal entity',	'Europe',	'Netherlands',	'2019-01-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2141,	'Natural Person',	'Asia',	'Hong Kong',	'2019-06-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	405,	405),  (2142,	'Legal entity',	'South America',	'Brazil',	'2019-08-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	405,	405),  (2143,	'Natural Person',	'Europe',	'Netherlands',	'2019-10-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2144,	'Legal entity',	'Africa',	'Angola',	'2020-01-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2145,	'Natural Person',	'Asia',	'Hong Kong',	'2020-03-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2146,	'Legal entity',	'South America',	'Brazil',	'2020-07-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	337.5,	337.5),  (2147,	'Legal entity',	'Europe',	'United Kingdom',	'2020-08-06',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	337.5,	337.5),  (2148,	'Legal entity',	'Europe',	'Spain',	'2020-09-17',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2149,	'Legal entity',	'Africa',	'South Africa',	'2020-11-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	405,	405),  (2150,	'Legal entity',	'Europe',	'United Kingdom',	'2020-12-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	256.5,	256.5),  (2151,	'Legal entity',	'Asia',	'Hong Kong',	'2020-12-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	375,	375),  (2152,	'Legal entity',	'North America',	'Dominican Republic',	'2021-02-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	319.01,	319.01),  (2153,	'Natural Person',	'Africa',	'South Africa',	'2021-06-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2154,	'Legal entity',	'Asia',	'Hong Kong',	'2021-06-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	330.07,	330.07),  (2155,	'Natural Person',	'South America',	'Brazil',	'2021-07-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2156,	'Natural Person',	'Europe',	'Netherlands',	'2021-08-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2157,	'public company',	'Europe',	'United Kingdom',	'2022-03-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2158,	'Legal entity',	'Europe',	'Netherlands',	'2022-03-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2159,	'Natural Person',	'Asia',	'Indonesia',	'2022-05-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2160,	'Natural Person',	'South America',	'Brazil',	'2022-05-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	450,	450),  (2161,	'Legal entity',	'Europe',	'United Kingdom',	'2022-12-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (2162,	'Natural Person',	'Europe',	'Netherlands',	'2023-06-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	405,	405),  (2163,	'Natural Person',	'South America',	'Brazil',	'2023-09-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	495,	495),  (2164,	'Legal entity',	'South America',	'Argentina',	'2018-11-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (2165,	'Natural Person',	'Europe',	'France',	'2019-02-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2166,	'Legal entity',	'Asia',	'Indonesia',	'2019-02-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2167,	'Natural Person',	'Europe',	'France',	'2019-03-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2168,	'Natural Person',	'South America',	'Brazil',	'2019-05-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2169,	'Natural Person',	'South America',	'Brazil',	'2019-05-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2170,	'Natural Person',	'Asia',	'Israel',	'2019-07-23',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2171,	'Legal entity',	'Europe',	'France',	'2019-08-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2172,	'Natural Person',	'Europe',	'Netherlands',	'2019-08-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2173,	'Natural Person',	'South America',	'Brazil',	'2019-08-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2174,	'Natural Person',	'North America',	'Panama',	'2019-09-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	200,	200),  (2175,	'Natural Person',	'Europe',	'Netherlands',	'2019-11-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	240,	240),  (2176,	'Natural Person',	'South America',	'Brazil',	'2020-01-31',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	240,	240),  (2177,	'Legal entity',	'North America',	'Dominican Republic',	'2020-02-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2178,	'Natural Person',	'Asia',	'Indonesia',	'2020-03-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	240,	240),  (2179,	'Natural Person',	'Asia',	'Thailand',	'2020-03-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2180,	'Legal entity',	'Europe',	'Netherlands',	'2020-04-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2181,	'Natural Person',	'Europe',	'Netherlands',	'2020-05-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2182,	'Natural Person',	'Asia',	'Hong Kong',	'2020-05-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2183,	'Natural Person',	'South America',	'Brazil',	'2020-05-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2184,	'Legal entity',	'Europe',	'France',	'2020-06-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2185,	'Legal entity',	'Asia',	'China',	'2020-07-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (2186,	'Legal entity',	'Europe',	'United Kingdom',	'2021-01-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2187,	'Natural Person',	'Africa',	'South Africa',	'2021-01-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2188,	'Natural Person',	'North America',	'Dominican Republic',	'2021-01-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2189,	'Legal entity',	'Asia',	'Hong Kong',	'2021-02-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2190,	'Legal entity',	'Asia',	'Indonesia',	'2021-03-18',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2191,	'Legal entity',	'Europe',	'United Kingdom',	'2021-04-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2192,	'Legal entity',	'Europe',	'United Kingdom',	'2021-05-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2193,	'Natural Person',	'Europe',	'France',	'2021-05-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (2194,	'Legal entity',	'South America',	'Argentina',	'2021-05-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2195,	'Natural Person',	'Asia',	'Hong Kong',	'2021-05-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2196,	'Legal entity',	'South America',	'Brazil',	'2021-05-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2197,	'Natural Person',	'Asia',	'Hong Kong',	'2021-06-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2198,	'Natural Person',	'Africa',	'Ethiopia',	'2021-06-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	270,	270),  (2199,	'Natural Person',	'South America',	'Argentina',	'2021-09-16',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2200,	'Natural Person',	'Europe',	'United Kingdom',	'2021-11-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	255,	255),  (2201,	'Legal entity',	'Europe',	'Czech Republic',	'2021-11-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2202,	'Natural Person',	'Asia',	'Philippines',	'2021-11-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	180,	180),  (2203,	'Natural Person',	'Europe',	'Netherlands',	'2022-01-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	162.06,	162.06),  (2204,	'Natural Person',	'Europe',	'Bosnia and Herzegovina',	'2022-02-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2205,	'Natural Person',	'Asia',	'Thailand',	'2022-03-27',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2206,	'Natural Person',	'South America',	'Brazil',	'2022-03-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2207,	'Legal entity',	'Europe',	'Norway',	'2022-04-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2208,	'Natural Person',	'South America',	'Brazil',	'2022-04-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	230,	230),  (2209,	'Natural Person',	'Africa',	'South Africa',	'2022-05-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2210,	'Natural Person',	'Africa',	'South Africa',	'2022-07-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2211,	'Natural Person',	'Asia',	'China',	'2022-07-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2212,	'Natural Person',	'South America',	'Brazil',	'2022-08-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2213,	'Legal entity',	'Asia',	'Hong Kong',	'2022-11-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2214,	'Legal entity',	'Europe',	'Netherlands',	'2023-01-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2215,	'Natural Person',	'Europe',	'United Kingdom',	'2023-03-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2216,	'Legal entity',	'Europe',	'United Kingdom',	'2023-05-03',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2217,	'Natural Person',	'South America',	'Brazil',	'2023-06-28',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2218,	'Legal entity',	'Europe',	'United Kingdom',	'2023-07-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	255,	255),  (2219,	'Natural Person',	'Africa',	'Gabon',	'2023-08-22',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2220,	'Legal entity',	'South America',	'Brazil',	'2023-08-30',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2221,	'Legal entity',	'Asia',	'Hong Kong',	'2023-09-14',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	300,	300),  (2222,	'Legal entity',	'Europe',	'Belgium',	'2023-10-20',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	297,	297),  (2223,	'Legal entity',	'South America',	'Colombia',	'2017-05-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	299.7,	299.7),  (2224,	'Legal entity',	'Asia',	'Hong Kong',	'2018-08-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1256.66,	1256.66),  (2225,	'Natural Person',	'South America',	'Ecuador',	'2018-08-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2226,	'Natural Person',	'Europe',	'Russian Federation',	'2018-08-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	258.98,	258.98),  (2227,	'Natural Person',	'Asia',	'Indonesia',	'2018-09-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2228,	'Legal entity',	'North America',	'United States',	'2018-09-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2229,	'Legal entity',	'Africa',	'South Africa',	'2018-10-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3023.57,	3023.57),  (2230,	'Natural Person',	'North America',	'United States',	'2018-10-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2231,	'Legal entity',	'North America',	'Canada',	'2018-10-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	251.79,	251.79),  (2232,	'Natural Person',	'Asia',	'India',	'2018-10-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1510.74,	1510.74),  (2233,	'Legal entity',	'Europe',	'Italy',	'2018-11-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2234,	'Natural Person',	'Europe',	'Spain',	'2018-11-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2235,	'Natural Person',	'North America',	'United States',	'2018-11-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2236,	'Legal entity',	'South America',	'Colombia',	'2018-11-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	575.52,	575.52),  (2237,	'Legal entity',	'South America',	'Argentina',	'2018-12-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	575.52,	575.52),  (2238,	'Legal entity',	'Europe',	'France',	'2018-12-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7500,	7500),  (2239,	'Natural Person',	'Europe',	'Spain',	'2019-01-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	575.52,	575.52),  (2240,	'Natural Person',	'Europe',	'Spain',	'2019-01-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	863.28,	863.28),  (2241,	'Natural Person',	'South America',	'Ecuador',	'2019-02-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2242,	'Legal entity',	'Asia',	'Qatar',	'2019-02-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3023.57,	3023.57),  (2243,	'Natural Person',	'Oceania',	'Australia',	'2019-03-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2244,	'Legal entity',	'South America',	'Chile',	'2019-03-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1510.74,	1510.74),  (2245,	'Natural Person',	'North America',	'Mexico',	'2019-03-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2246,	'Legal entity',	'North America',	'United States',	'2019-03-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2247,	'Legal entity',	'South America',	'Venezuela',	'2019-04-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2248,	'Legal entity',	'South America',	'Colombia',	'2019-04-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	287.76,	287.76),  (2249,	'Legal entity',	'Europe',	'United Kingdom',	'2019-04-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2250,	'Natural Person',	'Europe',	'Italy',	'2019-04-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2251,	'Natural Person',	'Asia',	'Malaysia',	'2019-04-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2252,	'Natural Person',	'South America',	'Colombia',	'2019-04-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2253,	'Natural Person',	'Africa',	'South Africa',	'2019-04-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2254,	'Legal entity',	'South America',	'Colombia',	'2019-05-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2255,	'Natural Person',	'South America',	'Ecuador',	'2019-05-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2256,	'Natural Person',	'North America',	'United States',	'2019-06-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2257,	'Natural Person',	'North America',	'United States',	'2019-06-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2258,	'Natural Person',	'South America',	'Chile',	'2019-07-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2259,	'Natural Person',	'Africa',	'South Africa',	'2019-07-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2260,	'Natural Person',	'South America',	'Colombia',	'2019-07-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2261,	'Natural Person',	'Europe',	'Italy',	'2019-07-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2262,	'Natural Person',	'Europe',	'Netherlands',	'2019-08-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2263,	'public company',	'South America',	'Colombia',	'2019-08-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2264,	'Natural Person',	'North America',	'United States',	'2019-08-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	647.46,	647.46),  (2265,	'Natural Person',	'North America',	'United States',	'2019-08-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2266,	'Natural Person',	'Europe',	'Italy',	'2019-09-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2267,	'Legal entity',	'North America',	'Barbados',	'2019-09-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3900,	3900),  (2268,	'Natural Person',	'Africa',	'Kenya',	'2019-09-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2269,	'Legal entity',	'Europe',	'Spain',	'2019-10-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2270,	'Natural Person',	'Europe',	'Spain',	'2019-10-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2271,	'Legal entity',	'South America',	'Uruguay',	'2019-10-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2272,	'Natural Person',	'Europe',	'Italy',	'2019-10-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1079.1,	1079.1),  (2273,	'Natural Person',	'Asia',	'India',	'2019-10-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2158.2,	2158.2),  (2274,	'Natural Person',	'Europe',	'Italy',	'2019-10-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2275,	'Legal entity',	'Europe',	'United Kingdom',	'2019-11-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2925,	2925),  (2276,	'Legal entity',	'South America',	'Uruguay',	'2019-11-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2277,	'Natural Person',	'Europe',	'Switzerland',	'2019-11-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2278,	'Natural Person',	'South America',	'Ecuador',	'2019-11-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2279,	'Natural Person',	'Europe',	'Italy',	'2019-11-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2280,	'Natural Person',	'Europe',	'Spain',	'2019-11-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2281,	'Legal entity',	'Asia',	'Indonesia',	'2019-12-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1079.1,	1079.1),  (2282,	'Natural Person',	'North America',	'Panama',	'2019-12-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2877.6,	2877.6),  (2283,	'Natural Person',	'Asia',	'Indonesia',	'2019-12-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2284,	'Legal entity',	'Africa',	'South Africa',	'2020-01-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	11340,	11340),  (2285,	'Natural Person',	'Europe',	'Italy',	'2020-01-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2286,	'Natural Person',	'South America',	'Argentina',	'2020-01-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2287,	'Natural Person',	'Europe',	'Italy',	'2020-02-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2288,	'Natural Person',	'Europe',	'Germany',	'2020-02-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2289,	'Legal entity',	'South America',	'Colombia',	'2020-02-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2290,	'Natural Person',	'Europe',	'Norway',	'2020-02-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2291,	'Legal entity',	'Europe',	'Belgium',	'2020-03-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2292,	'Legal entity',	'Africa',	'South Africa',	'2020-03-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	6750,	6750),  (2293,	'Natural Person',	'Oceania',	'New Zealand',	'2020-03-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2294,	'Natural Person',	'Europe',	'United Kingdom',	'2020-03-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2295,	'Legal entity',	'South America',	'Argentina',	'2020-04-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2296,	'Natural Person',	'Europe',	'Italy',	'2020-04-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2297,	'Natural Person',	'North America',	'Costa Rica',	'2020-04-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2298,	'Natural Person',	'North America',	'United States',	'2020-05-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1438.8,	1438.8),  (2299,	'Legal entity',	'South America',	'Colombia',	'2020-05-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2300,	'Legal entity',	'North America',	'Mexico',	'2020-05-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2301,	'Legal entity',	'Europe',	'Italy',	'2020-05-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2158.2,	2158.2),  (2302,	'Legal entity',	'Europe',	'France',	'2020-05-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1794.79,	1794.79),  (2303,	'Legal entity',	'South America',	'Uruguay',	'2020-05-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2304,	'Natural Person',	'Europe',	'Finland',	'2020-05-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2305,	'Natural Person',	'South America',	'Ecuador',	'2020-05-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2306,	'Legal entity',	'South America',	'Argentina',	'2020-06-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2307,	'Legal entity',	'North America',	'Nicaragua',	'2020-06-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1438.8,	1438.8),  (2308,	'Natural Person',	'North America',	'United States',	'2020-07-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2309,	'Natural Person',	'North America',	'United States',	'2020-07-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2310,	'Natural Person',	'Europe',	'Spain',	'2020-07-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2311,	'Natural Person',	'Europe',	'Spain',	'2020-07-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	7194,	7194),  (2312,	'Natural Person',	'Europe',	'Belgium',	'2020-07-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2313,	'Natural Person',	'North America',	'United States',	'2020-07-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2314,	'Natural Person',	'North America',	'Guatemala',	'2020-07-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2315,	'Natural Person',	'Europe',	'Romania',	'2020-08-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	611.49,	611.49),  (2316,	'Natural Person',	'Europe',	'Netherlands',	'2020-08-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2317,	'Natural Person',	'Asia',	'Jordan',	'2020-09-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2318,	'Natural Person',	'Europe',	'Italy',	'2020-09-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2319,	'Legal entity',	'North America',	'Mexico',	'2020-09-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2320,	'Natural Person',	'North America',	'United States',	'2020-09-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2321,	'Natural Person',	'Europe',	'Spain',	'2020-09-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2322,	'Natural Person',	'North America',	'United States',	'2020-09-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2323,	'Natural Person',	'Asia',	'Philippines',	'2020-09-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2324,	'Natural Person',	'Asia',	'Hong Kong',	'2020-10-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2325,	'Natural Person',	'Europe',	'Spain',	'2020-10-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2326,	'Natural Person',	'Oceania',	'Australia',	'2020-10-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2327,	'Natural Person',	'North America',	'Canada',	'2020-11-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2328,	'Legal entity',	'South America',	'Uruguay',	'2020-11-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2329,	'Legal entity',	'North America',	'Mexico',	'2020-11-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2330,	'Natural Person',	'North America',	'United States',	'2020-11-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2331,	'Natural Person',	'Europe',	'Switzerland',	'2020-11-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2332,	'Legal entity',	'South America',	'Colombia',	'2020-11-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2333,	'Natural Person',	'North America',	'United States',	'2020-11-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2334,	'Natural Person',	'Europe',	'Bulgaria',	'2020-11-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2335,	'Natural Person',	'North America',	'United States',	'2021-01-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2336,	'Natural Person',	'Asia',	'Thailand',	'2021-01-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2337,	'Natural Person',	'North America',	'United States',	'2021-02-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2338,	'Natural Person',	'North America',	'United States',	'2021-03-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2339,	'Natural Person',	'Oceania',	'New Zealand',	'2021-03-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2340,	'Legal entity',	'Europe',	'United Kingdom',	'2021-03-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2341,	'Natural Person',	'Europe',	'Spain',	'2021-03-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2342,	'Natural Person',	'Europe',	'United Kingdom',	'2021-03-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2343,	'Natural Person',	'Europe',	'United Kingdom',	'2021-03-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2344,	'Legal entity',	'North America',	'Costa Rica',	'2021-04-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2345,	'Natural Person',	'South America',	'Argentina',	'2021-04-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2346,	'Natural Person',	'Asia',	'Malaysia',	'2021-04-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2347,	'Legal entity',	'South America',	'Chile',	'2021-04-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2348,	'Legal entity',	'South America',	'Chile',	'2021-05-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	719.4,	719.4),  (2349,	'Natural Person',	'North America',	'United States',	'2021-05-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1438.8,	1438.8),  (2350,	'Natural Person',	'South America',	'Chile',	'2021-05-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2158.2,	2158.2),  (2351,	'Legal entity',	'South America',	'Chile',	'2021-05-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2352,	'Natural Person',	'South America',	'Ecuador',	'2021-06-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2353,	'Natural Person',	'North America',	'United States',	'2021-06-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2354,	'Natural Person',	'North America',	'Canada',	'2021-07-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2355,	'Legal entity',	'Europe',	'Spain',	'2021-07-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2356,	'Natural Person',	'Asia',	'Singapore',	'2021-07-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2357,	'Legal entity',	'South America',	'Argentina',	'2021-07-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2358,	'Legal entity',	'Asia',	'Israel',	'2021-08-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	13705.5,	13705.5),  (2359,	'Natural Person',	'North America',	'United States',	'2021-08-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2360,	'Natural Person',	'Europe',	'Italy',	'2021-09-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2361,	'Legal entity',	'North America',	'Mexico',	'2021-09-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2362,	'Natural Person',	'Europe',	'Italy',	'2021-09-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2363,	'Natural Person',	'Europe',	'Germany',	'2021-09-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	359.7,	359.7),  (2364,	'Natural Person',	'North America',	'United States',	'2021-10-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2365,	'Natural Person',	'Europe',	'Italy',	'2021-10-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2366,	'Natural Person',	'Europe',	'Malta',	'2021-10-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2367,	'Natural Person',	'North America',	'United States',	'2021-11-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2368,	'Natural Person',	'North America',	'United States',	'2021-11-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2369,	'Natural Person',	'Europe',	'Italy',	'2021-11-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2370,	'Natural Person',	'Europe',	'Spain',	'2021-11-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2371,	'Natural Person',	'Asia',	'Thailand',	'2021-11-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2372,	'Legal entity',	'South America',	'Uruguay',	'2021-12-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2373,	'Legal entity',	'Africa',	'Morocco',	'2021-12-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	251.82,	251.82),  (2374,	'Natural Person',	'Asia',	'Indonesia',	'2021-12-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2375,	'Natural Person',	'Europe',	'Spain',	'2022-01-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2376,	'Natural Person',	'North America',	'United States',	'2022-01-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2377,	'Legal entity',	'North America',	'Mexico',	'2022-02-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2378,	'Natural Person',	'Africa',	'Zambia',	'2022-02-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2098.5,	2098.5),  (2379,	'Natural Person',	'Europe',	'Romania',	'2022-02-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2380,	'Natural Person',	'Europe',	'Germany',	'2022-02-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2381,	'Legal entity',	'Europe',	'United Kingdom',	'2022-03-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2382,	'Legal entity',	'South America',	'Argentina',	'2022-03-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2729.7,	2729.7),  (2383,	'Natural Person',	'Europe',	'Italy',	'2022-03-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2384,	'Natural Person',	'Europe',	'Netherlands',	'2022-04-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	755.46,	755.46),  (2385,	'Legal entity',	'South America',	'Colombia',	'2022-04-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2386,	'Natural Person',	'North America',	'United States',	'2022-04-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2387,	'Natural Person',	'North America',	'Canada',	'2022-04-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2388,	'Natural Person',	'North America',	'United States',	'2022-04-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2389,	'Natural Person',	'South America',	'Ecuador',	'2022-04-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2937.9,	2937.9),  (2390,	'Legal entity',	'South America',	'Colombia',	'2022-04-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2391,	'Natural Person',	'North America',	'United States',	'2022-05-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2392,	'Natural Person',	'North America',	'United States',	'2022-05-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2393,	'Natural Person',	'North America',	'United States',	'2022-05-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2394,	'Legal entity',	'South America',	'Argentina',	'2022-05-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2395,	'Natural Person',	'Asia',	'United Arab Emirates',	'2022-05-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2396,	'Legal entity',	'South America',	'Colombia',	'2022-06-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2397,	'Natural Person',	'Europe',	'Italy',	'2022-06-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2398,	'Natural Person',	'Asia',	'Indonesia',	'2022-07-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2399,	'Natural Person',	'Europe',	'France',	'2022-08-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2400,	'Natural Person',	'South America',	'Ecuador',	'2022-09-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2401,	'Natural Person',	'North America',	'United States',	'2022-09-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1678.8,	1678.8),  (2402,	'Natural Person',	'Africa',	'Ghana',	'2022-09-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2403,	'Natural Person',	'Europe',	'Italy',	'2022-09-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2404,	'Legal entity',	'South America',	'Chile',	'2022-09-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2405,	'Legal entity',	'South America',	'Peru',	'2022-09-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	419.7,	419.7),  (2407,	'Natural Person',	'Africa',	'Algeria',	'2022-09-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2408,	'Legal entity',	'North America',	'Mexico',	'2022-09-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	839.4,	839.4),  (2409,	'Natural Person',	'North America',	'United States',	'2022-10-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2410,	'Legal entity',	'Europe',	'Spain',	'2022-10-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2411,	'Natural Person',	'Europe',	'Italy',	'2022-10-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2412,	'Natural Person',	'North America',	'United States',	'2022-11-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2413,	'Natural Person',	'Africa',	'South Africa',	'2022-11-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2414,	'Natural Person',	'North America',	'Dominican Republic',	'2022-11-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2415,	'Natural Person',	'Europe',	'Italy',	'2022-11-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2416,	'Legal entity',	'Europe',	'Italy',	'2022-11-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2417,	'Natural Person',	'Europe',	'Italy',	'2022-12-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	278.82,	278.82),  (2418,	'Legal entity',	'North America',	'Mexico',	'2022-12-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	278.82,	278.82),  (2419,	'Legal entity',	'South America',	'Chile',	'2022-12-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1394.1,	1394.1),  (2420,	'Natural Person',	'Asia',	'Thailand',	'2022-12-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2421,	'Natural Person',	'Europe',	'Spain',	'2023-01-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1394.1,	1394.1),  (2422,	'Legal entity',	'South America',	'Uruguay',	'2023-01-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2423,	'Natural Person',	'Europe',	'Germany',	'2023-02-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2424,	'Natural Person',	'Asia',	'Indonesia',	'2023-02-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2425,	'Natural Person',	'Europe',	'Italy',	'2023-02-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2426,	'Legal entity',	'South America',	'Uruguay',	'2023-02-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2427,	'Legal entity',	'Europe',	'United Kingdom',	'2023-03-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2428,	'Natural Person',	'Europe',	'Germany',	'2023-03-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2429,	'Natural Person',	'Europe',	'United Kingdom',	'2023-03-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2430,	'Natural Person',	'South America',	'Colombia',	'2023-03-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2431,	'Legal entity',	'South America',	'Ecuador',	'2023-04-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2432,	'Natural Person',	'South America',	'Ecuador',	'2023-04-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3252.9,	3252.9),  (2433,	'Natural Person',	'Europe',	'United Kingdom',	'2023-04-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2434,	'Natural Person',	'North America',	'United States',	'2023-04-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2435,	'Natural Person',	'North America',	'United States',	'2023-04-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2436,	'Natural Person',	'South America',	'Ecuador',	'2023-04-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2437,	'Natural Person',	'North America',	'Costa Rica',	'2023-05-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2438,	'Legal entity',	'North America',	'United States',	'2023-05-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2439,	'Natural Person',	'Europe',	'France',	'2023-05-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2440,	'Legal entity',	'Asia',	'Hong Kong',	'2023-05-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2673,	2673),  (2441,	'Natural Person',	'Europe',	'Austria',	'2023-05-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2323.5,	2323.5),  (2442,	'Natural Person',	'South America',	'Chile',	'2023-05-22',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3717.6,	3717.6),  (2443,	'Legal entity',	'South America',	'Peru',	'2023-05-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2444,	'Natural Person',	'North America',	'Mexico',	'2023-06-19',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3252.9,	3252.9),  (2445,	'Natural Person',	'Europe',	'Italy',	'2023-06-30',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2446,	'Legal entity',	'North America',	'Mexico',	'2023-07-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1394.1,	1394.1),  (2447,	'Natural Person',	'Europe',	'Czech Republic',	'2023-07-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2448,	'Natural Person',	'Europe',	'Italy',	'2023-07-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2449,	'Natural Person',	'South America',	'Ecuador',	'2023-07-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2450,	'Natural Person',	'North America',	'Honduras',	'2023-07-25',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2451,	'Legal entity',	'North America',	'Nicaragua',	'2023-08-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1858.8,	1858.8),  (2452,	'Natural Person',	'North America',	'United States',	'2023-08-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	929.4,	929.4),  (2453,	'Legal entity',	'Europe',	'Spain',	'2023-09-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	464.7,	464.7),  (2454,	'Legal entity',	'South America',	'Colombia',	'2023-09-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2455,	'Natural Person',	'Africa',	'Ghana',	'2023-09-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2456,	'Legal entity',	'North America',	'Mexico',	'2023-09-20',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1031.4,	1031.4),  (2457,	'Natural Person',	'Europe',	'Spain',	'2023-09-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2458,	'Legal entity',	'South America',	'Chile',	'2023-10-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2459,	'Legal entity',	'Europe',	'Spain',	'2023-10-03',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2460,	'Natural Person',	'North America',	'United States',	'2023-10-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2461,	'Natural Person',	'Asia',	'Hong Kong',	'2023-10-26',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2462,	'Natural Person',	'Europe',	'Italy',	'2023-10-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2463,	'Natural Person',	'North America',	'United States',	'2023-11-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	515.7,	515.7),  (2464,	'Legal entity',	'Europe',	'Netherlands',	'2017-05-13',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1800,	1800),  (2465,	'Natural Person',	'North America',	'United States',	'2017-05-14',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	899.1,	899.1),  (2466,	'Natural Person',	'South America',	'Bolivia',	'2018-09-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	323.73,	323.73),  (2467,	'Natural Person',	'North America',	'United States',	'2019-01-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	431.64,	431.64),  (2468,	'Natural Person',	'Asia',	'Thailand',	'2019-01-04',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	431.64,	431.64),  (2469,	'Natural Person',	'North America',	'United States',	'2019-02-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	431.64,	431.64),  (2470,	'Legal entity',	'South America',	'Colombia',	'2019-02-21',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	431.64,	431.64),  (2471,	'Natural Person',	'Europe',	'Poland',	'2019-02-28',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	431.64,	431.64),  (2472,	'Legal entity',	'North America',	'Mexico',	'2019-04-05',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	431.64,	431.64),  (2473,	'Natural Person',	'North America',	'Mexico',	'2019-07-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2474,	'Natural Person',	'Asia',	'Saudi Arabia',	'2019-09-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2475,	'Natural Person',	'Europe',	'Spain',	'2019-10-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2476,	'Legal entity',	'South America',	'Chile',	'2019-12-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2477,	'Natural Person',	'Europe',	'Belgium',	'2020-01-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2478,	'Legal entity',	'Europe',	'France',	'2020-01-15',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2293.09,	2293.09),  (2479,	'Natural Person',	'North America',	'United States',	'2020-01-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2480,	'Legal entity',	'Europe',	'Italy',	'2020-02-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	12598.2,	12598.2),  (2481,	'Legal entity',	'South America',	'Argentina',	'2020-02-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2482,	'Natural Person',	'Europe',	'Czech Republic',	'2020-02-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2483,	'Legal entity',	'South America',	'Ecuador',	'2020-04-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2484,	'Natural Person',	'Europe',	'Portugal',	'2020-04-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2485,	'Legal entity',	'South America',	'Ecuador',	'2020-04-17',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2486,	'Legal entity',	'South America',	'Peru',	'2020-10-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2487,	'Natural Person',	'Europe',	'Germany',	'2021-02-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2488,	'Natural Person',	'North America',	'United States',	'2021-04-29',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2489,	'Legal entity',	'South America',	'Chile',	'2021-05-08',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2490,	'Natural Person',	'South America',	'Chile',	'2021-05-10',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2491,	'Natural Person',	'North America',	'United States',	'2021-05-31',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2492,	'Natural Person',	'Asia',	'United Arab Emirates',	'2021-06-06',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2493,	'Legal entity',	'Asia',	'Indonesia',	'2021-07-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	2697.75,	2697.75),  (2494,	'Natural Person',	'Europe',	'Greece',	'2021-07-27',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	539.55,	539.55),  (2495,	'Natural Person',	'Europe',	'Norway',	'2021-08-11',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1079.1,	1079.1),  (2496,	'Natural Person',	'Europe',	'Italy',	'2022-02-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	629.55,	629.55),  (2497,	'Legal entity',	'Africa',	'Zambia',	'2022-04-12',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1259.1,	1259.1),  (2498,	'Legal entity',	'Asia',	'Iraq',	'2022-05-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3889.82,	3889.82),  (2499,	'Legal entity',	'North America',	'Honduras',	'2022-07-01',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	3147.75,	3147.75);
INSERT INTO `comparison` VALUES (2500,	'Natural Person',	'Europe',	'Belgium',	'2022-10-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (2501,	'Natural Person',	'Europe',	'Italy',	'2023-02-09',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (2502,	'Natural Person',	'Asia',	'Pakistan',	'2023-03-02',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (2503,	'Legal entity',	'Africa',	'Zambia',	'2023-04-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	441.47,	441.47),  (2504,	'Natural Person',	'Oceania',	'French Polynesia',	'2023-05-16',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (2505,	'Natural Person',	'Asia',	'India',	'2023-05-23',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (2506,	'Natural Person',	'South America',	'Colombia',	'2023-07-18',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	1394.1,	1394.1),  (2507,	'Natural Person',	'Africa',	'Guinea',	'2023-07-24',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	697.05,	697.05),  (2508,	'Legal entity',	'South America',	'Colombia',	'2023-09-07',	'2.1 Books and Stationery',	'NovelNook Hardcover Journal',	1,	773.55,	773.55),  (2509,	'Natural Person',	'Europe',	'Italy',	'2017-05-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.6,	239.6),  (2510,	'Natural Person',	'North America',	'United States',	'2018-08-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	167.76,	167.76),  (2511,	'Natural Person',	'North America',	'Panama',	'2018-08-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	419.79,	419.79),  (2512,	'Natural Person',	'Europe',	'Italy',	'2018-08-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	167.76,	167.76),  (2513,	'Natural Person',	'North America',	'United States',	'2018-09-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	191.76,	191.76),  (2514,	'Legal entity',	'Asia',	'Hong Kong',	'2018-09-15',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	377.79,	377.79),  (2515,	'Natural Person',	'Europe',	'Germany',	'2018-09-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	191.76,	191.76),  (2516,	'Legal entity',	'Europe',	'Germany',	'2018-09-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	167.76,	167.76),  (2517,	'Natural Person',	'Europe',	'Poland',	'2018-10-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2518,	'Natural Person',	'South America',	'Argentina',	'2018-10-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	209.7,	209.7),  (2519,	'Natural Person',	'North America',	'United States',	'2018-12-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	255.68,	255.68),  (2520,	'Natural Person',	'South America',	'Brazil',	'2018-12-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	479.76,	479.76),  (2521,	'Natural Person',	'South America',	'Brazil',	'2018-12-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	388.58,	388.58),  (2522,	'Natural Person',	'Europe',	'Romania',	'2019-01-30',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	223.68,	223.68),  (2523,	'Legal entity',	'South America',	'Ecuador',	'2019-02-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	255.68,	255.68),  (2524,	'Natural Person',	'Asia',	'Israel',	'2019-04-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	223.68,	223.68),  (2525,	'Natural Person',	'South America',	'Argentina',	'2019-04-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2526,	'Legal entity',	'North America',	'Panama',	'2019-04-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2527,	'Natural Person',	'Europe',	'Bosnia and Herzegovina',	'2019-04-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2528,	'Natural Person',	'North America',	'United States',	'2019-05-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2529,	'Natural Person',	'Asia',	'United Arab Emirates',	'2019-05-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2530,	'Legal entity',	'South America',	'Colombia',	'2019-05-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2531,	'Natural Person',	'Europe',	'Spain',	'2019-06-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2532,	'Legal entity',	'South America',	'Brazil',	'2019-06-30',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	899.7,	899.7),  (2533,	'Natural Person',	'Europe',	'France',	'2019-07-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2534,	'Natural Person',	'Europe',	'Netherlands',	'2019-07-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2535,	'Natural Person',	'South America',	'Argentina',	'2019-07-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2536,	'Natural Person',	'Asia',	'China',	'2019-07-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2537,	'Legal entity',	'Europe',	'Spain',	'2019-07-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2538,	'Natural Person',	'North America',	'Guatemala',	'2019-08-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2539,	'Natural Person',	'Europe',	'Portugal',	'2019-09-08',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2540,	'Legal entity',	'South America',	'Peru',	'2019-09-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2541,	'Legal entity',	'Europe',	'Switzerland',	'2019-09-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2542,	'Natural Person',	'Europe',	'Austria',	'2019-09-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2543,	'Natural Person',	'Asia',	'Indonesia',	'2019-10-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2544,	'Natural Person',	'North America',	'United States',	'2019-11-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2545,	'Natural Person',	'Europe',	'Italy',	'2019-11-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2546,	'Legal entity',	'North America',	'Guatemala',	'2019-11-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2547,	'Natural Person',	'North America',	'United States',	'2020-01-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2548,	'Natural Person',	'Europe',	'Romania',	'2020-01-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2549,	'Natural Person',	'Asia',	'India',	'2020-02-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2550,	'Legal entity',	'Europe',	'United Kingdom',	'2020-03-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2551,	'Natural Person',	'Europe',	'Italy',	'2020-03-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.7,	539.7),  (2552,	'Natural Person',	'North America',	'United States',	'2020-03-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2553,	'Natural Person',	'Africa',	'Nigeria',	'2020-04-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2554,	'Natural Person',	'Africa',	'South Africa',	'2020-05-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2555,	'Natural Person',	'Asia',	'Thailand',	'2020-05-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2556,	'Natural Person',	'South America',	'Peru',	'2020-05-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2557,	'Natural Person',	'South America',	'Argentina',	'2020-05-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2558,	'Natural Person',	'Africa',	'South Africa',	'2020-06-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2559,	'Legal entity',	'Asia',	'Hong Kong',	'2020-06-15',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.7,	539.7),  (2560,	'Natural Person',	'Europe',	'Luxembourg',	'2020-06-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2561,	'Natural Person',	'Africa',	'Uganda',	'2020-06-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2562,	'Legal entity',	'North America',	'Guatemala',	'2020-07-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2563,	'Natural Person',	'Europe',	'Germany',	'2020-07-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2564,	'Natural Person',	'Asia',	'Indonesia',	'2020-07-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2565,	'Natural Person',	'Europe',	'Spain',	'2020-07-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2566,	'Legal entity',	'Europe',	'Spain',	'2020-07-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2567,	'Natural Person',	'North America',	'Canada',	'2020-08-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2568,	'Natural Person',	'Europe',	'Netherlands',	'2020-08-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2569,	'Legal entity',	'Africa',	'Gabon',	'2020-08-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2570,	'Natural Person',	'North America',	'United States',	'2020-08-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2571,	'Natural Person',	'Africa',	'South Africa',	'2020-08-30',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2572,	'Natural Person',	'Europe',	'Austria',	'2020-09-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2573,	'Natural Person',	'South America',	'Argentina',	'2020-09-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2574,	'Natural Person',	'Europe',	'Switzerland',	'2020-09-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2575,	'Natural Person',	'Asia',	'Malaysia',	'2020-10-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2576,	'Natural Person',	'North America',	'United States',	'2020-10-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2577,	'Natural Person',	'North America',	'United States',	'2020-10-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2578,	'Natural Person',	'Europe',	'Netherlands',	'2020-10-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2579,	'Legal entity',	'South America',	'Argentina',	'2020-11-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2580,	'Natural Person',	'Europe',	'United Kingdom',	'2020-11-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2581,	'Natural Person',	'North America',	'United States',	'2020-11-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2582,	'Legal entity',	'Europe',	'Italy',	'2020-11-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2583,	'Natural Person',	'Europe',	'Italy',	'2020-12-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2584,	'Natural Person',	'Europe',	'Germany',	'2020-12-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2585,	'Natural Person',	'Asia',	'Lebanon',	'2020-12-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	539.7,	539.7),  (2586,	'Natural Person',	'North America',	'Guatemala',	'2020-12-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2587,	'Legal entity',	'Africa',	'South Africa',	'2021-01-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2588,	'Legal entity',	'Europe',	'Germany',	'2021-02-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2589,	'Natural Person',	'Europe',	'United Kingdom',	'2021-02-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2590,	'Natural Person',	'South America',	'Argentina',	'2021-02-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2591,	'Legal entity',	'North America',	'United States',	'2021-02-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2592,	'Natural Person',	'Europe',	'Netherlands',	'2021-02-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2593,	'Natural Person',	'North America',	'United States',	'2021-03-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2594,	'Natural Person',	'Europe',	'Netherlands',	'2021-04-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2595,	'Natural Person',	'Europe',	'Netherlands',	'2021-04-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2596,	'Natural Person',	'Europe',	'Italy',	'2021-04-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2597,	'Natural Person',	'Europe',	'United Kingdom',	'2021-04-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2598,	'Legal entity',	'South America',	'Chile',	'2021-04-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2599,	'Natural Person',	'Europe',	'Italy',	'2021-06-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2600,	'Natural Person',	'Asia',	'Hong Kong',	'2021-06-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2601,	'Natural Person',	'Africa',	'Uganda',	'2021-06-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2602,	'Natural Person',	'Europe',	'Switzerland',	'2021-07-08',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2603,	'Legal entity',	'Europe',	'Romania',	'2021-07-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2604,	'Natural Person',	'Oceania',	'French Polynesia',	'2021-07-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2605,	'Legal entity',	'North America',	'Mexico',	'2021-08-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	279.6,	279.6),  (2606,	'Natural Person',	'Asia',	'Indonesia',	'2021-09-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.7,	449.7),  (2607,	'Natural Person',	'North America',	'Barbados',	'2021-09-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1199.7,	1199.7),  (2609,	'Natural Person',	'Asia',	'Oman',	'2021-10-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2610,	'Natural Person',	'Europe',	'United Kingdom',	'2021-10-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	239.7,	239.7),  (2611,	'Natural Person',	'Europe',	'Netherlands',	'2021-10-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2612,	'Legal entity',	'Asia',	'Hong Kong',	'2021-10-15',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2613,	'Natural Person',	'North America',	'United States',	'2021-10-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2614,	'Natural Person',	'Europe',	'Netherlands',	'2021-10-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2615,	'Natural Person',	'Europe',	'Italy',	'2021-11-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2616,	'Natural Person',	'Asia',	'Lebanon',	'2021-11-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2617,	'Natural Person',	'Africa',	'South Africa',	'2021-11-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	599.7,	599.7),  (2618,	'Natural Person',	'North America',	'Mexico',	'2021-11-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2619,	'Natural Person',	'Europe',	'Italy',	'2021-11-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2620,	'Natural Person',	'Africa',	'Algeria',	'2021-12-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	584.7,	584.7),  (2621,	'Natural Person',	'Europe',	'Germany',	'2022-01-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2622,	'Natural Person',	'Europe',	'Italy',	'2022-01-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2623,	'Natural Person',	'South America',	'Argentina',	'2022-02-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	584.7,	584.7),  (2624,	'Natural Person',	'Africa',	'South Africa',	'2022-03-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2625,	'Legal entity',	'Oceania',	'New Zealand',	'2022-03-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2626,	'Natural Person',	'Europe',	'Hungary',	'2022-04-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2627,	'Legal entity',	'South America',	'Argentina',	'2022-04-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2628,	'Legal entity',	'North America',	'Costa Rica',	'2022-04-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2629,	'Natural Person',	'Europe',	'Italy',	'2022-04-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2630,	'Legal entity',	'Europe',	'Hungary',	'2022-04-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	719.7,	719.7),  (2631,	'Natural Person',	'Europe',	'United Kingdom',	'2022-05-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	701.73,	701.73),  (2632,	'Natural Person',	'North America',	'Canada',	'2022-05-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2633,	'Natural Person',	'Europe',	'Italy',	'2022-05-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2634,	'Natural Person',	'Europe',	'Italy',	'2022-05-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2635,	'Legal entity',	'South America',	'Chile',	'2022-06-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2636,	'Legal entity',	'Europe',	'United Kingdom',	'2022-06-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2637,	'Natural Person',	'Asia',	'Hong Kong',	'2022-06-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2638,	'Natural Person',	'South America',	'Ecuador',	'2022-06-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2639,	'Natural Person',	'Europe',	'Spain',	'2022-06-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2640,	'Natural Person',	'Europe',	'Netherlands',	'2022-06-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2641,	'Natural Person',	'North America',	'United States',	'2022-07-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2642,	'Natural Person',	'North America',	'Jamaica',	'2022-07-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2643,	'Natural Person',	'Europe',	'United Kingdom',	'2022-08-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	779.7,	779.7),  (2644,	'Legal entity',	'North America',	'Canada',	'2022-08-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1559.7,	1559.7),  (2645,	'Natural Person',	'Asia',	'Hong Kong',	'2022-08-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	584.7,	584.7),  (2646,	'Legal entity',	'North America',	'Mexico',	'2022-08-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	299.7,	299.7),  (2647,	'Legal entity',	'Europe',	'Italy',	'2022-08-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2648,	'Natural Person',	'North America',	'United States',	'2022-09-05',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2649,	'Legal entity',	'Europe',	'Malta',	'2022-09-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	869.7,	869.7),  (2650,	'Natural Person',	'Africa',	'South Africa',	'2022-09-30',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2651,	'Natural Person',	'Europe',	'Switzerland',	'2022-10-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2652,	'Legal entity',	'Europe',	'United Kingdom',	'2022-10-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	254.7,	254.7),  (2653,	'Natural Person',	'Europe',	'Belgium',	'2022-10-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	869.7,	869.7),  (2654,	'Natural Person',	'Asia',	'India',	'2022-10-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	329.7,	329.7),  (2655,	'Natural Person',	'Europe',	'Italy',	'2022-11-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2656,	'Natural Person',	'Europe',	'United Kingdom',	'2022-11-05',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	643.17,	643.17),  (2657,	'Natural Person',	'Europe',	'Belgium',	'2022-11-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	869.7,	869.7),  (2658,	'Legal entity',	'Europe',	'Spain',	'2023-01-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2659,	'Natural Person',	'Europe',	'Italy',	'2023-01-28',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	329.7,	329.7),  (2660,	'Natural Person',	'Africa',	'South Africa',	'2023-02-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	825,	825),  (2661,	'Legal entity',	'Europe',	'Switzerland',	'2023-02-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	869.7,	869.7),  (2662,	'Natural Person',	'Europe',	'Hungary',	'2023-02-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2663,	'Natural Person',	'Asia',	'Indonesia',	'2023-03-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	643.17,	643.17),  (2664,	'Natural Person',	'Europe',	'Romania',	'2023-04-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2665,	'Legal entity',	'South America',	'Argentina',	'2023-04-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2666,	'Legal entity',	'South America',	'Chile',	'2023-04-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2667,	'Legal entity',	'North America',	'Costa Rica',	'2023-05-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2668,	'Natural Person',	'Europe',	'Italy',	'2023-05-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	329.7,	329.7),  (2669,	'Natural Person',	'Europe',	'Switzerland',	'2023-05-12',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	869.7,	869.7),  (2670,	'Natural Person',	'Europe',	'Belgium',	'2023-05-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2671,	'Natural Person',	'Europe',	'Luxembourg',	'2023-05-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	782.73,	782.73),  (2672,	'Natural Person',	'Europe',	'Germany',	'2023-06-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2673,	'Natural Person',	'Europe',	'Netherlands',	'2023-06-08',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2674,	'Legal entity',	'South America',	'Colombia',	'2023-06-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2675,	'Natural Person',	'North America',	'Canada',	'2023-06-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	329.7,	329.7),  (2676,	'Natural Person',	'North America',	'United States',	'2023-07-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2677,	'Natural Person',	'North America',	'United States',	'2023-07-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2678,	'Legal entity',	'Europe',	'Spain',	'2023-07-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	329.7,	329.7),  (2679,	'Natural Person',	'Europe',	'France',	'2023-08-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	869.7,	869.7),  (2680,	'Legal entity',	'Europe',	'Italy',	'2023-08-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2681,	'Natural Person',	'Asia',	'Hong Kong',	'2023-08-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	643.17,	643.17),  (2682,	'Natural Person',	'Asia',	'Bangladesh',	'2023-08-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	643.17,	643.17),  (2683,	'Legal entity',	'North America',	'Mexico',	'2023-08-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	284.7,	284.7),  (2684,	'Natural Person',	'Africa',	'South Africa',	'2023-09-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	782.73,	782.73),  (2685,	'Natural Person',	'Asia',	'Hong Kong',	'2023-09-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	959.7,	959.7),  (2686,	'Natural Person',	'Asia',	'Indonesia',	'2023-09-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	362.7,	362.7),  (2687,	'Legal entity',	'Europe',	'Malta',	'2023-09-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	959.7,	959.7),  (2688,	'Legal entity',	'South America',	'Argentina',	'2023-10-05',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.7,	314.7),  (2689,	'Natural Person',	'Europe',	'France',	'2023-10-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	362.7,	362.7),  (2690,	'Natural Person',	'Oceania',	'Australia',	'2023-10-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	362.7,	362.7),  (2691,	'Legal entity',	'Europe',	'Spain',	'2023-10-24',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	362.7,	362.7),  (2692,	'Natural Person',	'Europe',	'Spain',	'2023-10-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	283.23,	283.23),  (2693,	'Natural Person',	'Europe',	'United Kingdom',	'2023-11-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	959.7,	959.7),  (2694,	'Natural Person',	'Asia',	'Cyprus',	'2023-11-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	362.7,	362.7),  (2695,	'Legal entity',	'Europe',	'Italy',	'2023-11-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	362.7,	362.7),  (2696,	'Natural Person',	'Asia',	'Hong Kong',	'2018-08-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	251.64,	251.64),  (2697,	'Natural Person',	'Europe',	'Netherlands',	'2018-10-14',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	269.66,	269.66),  (2698,	'Natural Person',	'Asia',	'Israel',	'2018-11-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	251.64,	251.64),  (2699,	'Natural Person',	'Europe',	'Belgium',	'2018-11-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	251.64,	251.64),  (2700,	'Legal entity',	'South America',	'Colombia',	'2018-12-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	287.64,	287.64),  (2701,	'Natural Person',	'Asia',	'Oman',	'2019-01-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	244.49,	244.49),  (2702,	'Natural Person',	'South America',	'Bolivia',	'2019-01-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	485.68,	485.68),  (2703,	'Natural Person',	'Europe',	'France',	'2019-01-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	287.64,	287.64),  (2704,	'Natural Person',	'Asia',	'Oman',	'2019-05-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	899.55,	899.55),  (2705,	'Natural Person',	'Europe',	'Spain',	'2019-06-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2706,	'Natural Person',	'South America',	'Argentina',	'2019-06-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	899.55,	899.55),  (2707,	'Legal entity',	'Europe',	'United Kingdom',	'2019-07-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	674.55,	674.55),  (2708,	'Natural Person',	'North America',	'United States',	'2019-09-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2709,	'Natural Person',	'Africa',	'Gabon',	'2019-09-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	674.55,	674.55),  (2710,	'Legal entity',	'South America',	'Venezuela',	'2019-10-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2711,	'Natural Person',	'Asia',	'Hong Kong',	'2019-12-15',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	809.55,	809.55),  (2712,	'Natural Person',	'Africa',	'Morocco',	'2019-12-27',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2713,	'Legal entity',	'North America',	'Mexico',	'2019-12-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2714,	'Natural Person',	'Europe',	'United Kingdom',	'2020-01-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	899.55,	899.55),  (2715,	'Natural Person',	'Europe',	'Belgium',	'2020-01-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2716,	'Natural Person',	'Europe',	'Germany',	'2020-02-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2717,	'Legal entity',	'Europe',	'Germany',	'2020-03-18',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2718,	'Legal entity',	'North America',	'Dominican Republic',	'2020-03-22',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	674.55,	674.55),  (2719,	'Natural Person',	'North America',	'Guatemala',	'2020-04-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2720,	'Natural Person',	'Europe',	'Switzerland',	'2020-04-19',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2721,	'Natural Person',	'Europe',	'Netherlands',	'2020-06-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	899.55,	899.55),  (2722,	'Natural Person',	'North America',	'Canada',	'2020-07-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	674.55,	674.55),  (2723,	'Natural Person',	'Europe',	'Switzerland',	'2020-08-15',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2724,	'Natural Person',	'Europe',	'Spain',	'2020-10-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	674.55,	674.55),  (2725,	'Natural Person',	'South America',	'Brazil',	'2020-10-28',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	768.79,	768.79),  (2726,	'Natural Person',	'Asia',	'United Arab Emirates',	'2020-12-25',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2727,	'Natural Person',	'South America',	'Argentina',	'2020-12-26',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2728,	'Natural Person',	'Europe',	'United Kingdom',	'2021-01-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	674.55,	674.55),  (2729,	'Natural Person',	'Europe',	'Norway',	'2021-01-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2730,	'Natural Person',	'North America',	'United States',	'2021-01-31',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2731,	'Natural Person',	'Europe',	'Italy',	'2021-06-05',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2732,	'Natural Person',	'North America',	'Honduras',	'2021-06-30',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2733,	'Natural Person',	'Asia',	'Thailand',	'2021-09-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	359.55,	359.55),  (2734,	'Natural Person',	'Europe',	'Spain',	'2021-10-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.55,	314.55),  (2735,	'Natural Person',	'Europe',	'Romania',	'2021-11-11',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.55,	449.55),  (2736,	'Natural Person',	'Asia',	'Malaysia',	'2021-11-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	382.05,	382.05),  (2737,	'Natural Person',	'Asia',	'Indonesia',	'2021-12-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1052.6,	1052.6),  (2738,	'Natural Person',	'Europe',	'Austria',	'2022-01-02',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	382.05,	382.05),  (2739,	'Natural Person',	'South America',	'Argentina',	'2022-01-07',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	382.05,	382.05),  (2740,	'Natural Person',	'South America',	'Argentina',	'2022-01-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1169.55,	1169.55),  (2741,	'Natural Person',	'Europe',	'Spain',	'2022-07-17',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	877.05,	877.05),  (2742,	'Natural Person',	'South America',	'Colombia',	'2022-08-15',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	449.55,	449.55),  (2743,	'Natural Person',	'North America',	'United States',	'2023-02-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	427.05,	427.05),  (2744,	'Natural Person',	'Europe',	'United Kingdom',	'2023-02-20',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	427.05,	427.05),  (2745,	'Natural Person',	'Europe',	'Netherlands',	'2023-03-29',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	427.05,	427.05),  (2746,	'Natural Person',	'North America',	'Honduras',	'2023-04-21',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	494.55,	494.55),  (2747,	'Natural Person',	'Europe',	'Finland',	'2023-06-04',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	494.55,	494.55),  (2748,	'Natural Person',	'Europe',	'United Kingdom',	'2023-06-06',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1056.38,	1056.38),  (2749,	'Natural Person',	'Asia',	'Jordan',	'2023-10-23',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	1165.73,	1165.73),  (2751,	'Legal entity',	'Europe',	'France',	'2020-01-08',	'2.5 Toys and Games',	'PlayfulPals Plush Toy Set',	1,	2046.45,	2046.45),  (2752,	'Natural Person',	'Europe',	'Germany',	'2019-01-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	143,	143),  (2753,	'Natural Person',	'Europe',	'Germany',	'2019-06-01',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	404.73,	404.73),  (2754,	'Natural Person',	'Europe',	'United Kingdom',	'2021-08-03',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	384.5,	384.5),  (2755,	'Natural Person',	'Europe',	'Switzerland',	'2022-01-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	499.5,	499.5),  (2756,	'Natural Person',	'Africa',	'South Africa',	'2022-06-10',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	584.7,	584.7),  (2757,	'Natural Person',	'Europe',	'Switzerland',	'2023-03-13',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	578.85,	578.85),  (2758,	'Natural Person',	'Europe',	'Switzerland',	'2023-10-09',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	314.7,	314.7),  (2759,	'Natural Person',	'South America',	'Argentina',	'2019-07-16',	'2.1 Books and Stationery',	'PageTurner Bookshelf Organizer',	1,	607.1,	607.1),  (2760,	'Natural Person',	'Asia',	'India',	'2019-03-17',	'2.4 Sports and Outdoors',	'TrailBlazer Outdoor Adventure Backpack',	1,	80,	80),  (2761,	'Natural Person',	'Europe',	'Italy',	'2023-02-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	199,	199),  (2762,	'Natural Person',	'North America',	'United States',	'2023-07-29',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	199,	199),  (2763,	'Natural Person',	'Europe',	'Netherlands',	'2021-01-07',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2764,	'Natural Person',	'North America',	'Panama',	'2021-12-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2765,	'Natural Person',	'South America',	'Argentina',	'2022-07-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2766,	'Natural Person',	'North America',	'Panama',	'2022-12-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2767,	'Natural Person',	'Europe',	'United Kingdom',	'2023-01-04',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2768,	'Natural Person',	'North America',	'United States',	'2023-03-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	299,	299),  (2769,	'Natural Person',	'North America',	'United States',	'2017-05-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2770,	'Natural Person',	'Africa',	'South Africa',	'2018-08-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2771,	'Natural Person',	'North America',	'Mexico',	'2019-01-26',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2772,	'Natural Person',	'North America',	'United States',	'2019-03-10',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2773,	'Natural Person',	'Europe',	'France',	'2019-06-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2774,	'Natural Person',	'Africa',	'Namibia',	'2019-06-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2775,	'Natural Person',	'South America',	'Argentina',	'2020-01-09',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2776,	'Natural Person',	'Asia',	'Saudi Arabia',	'2020-01-26',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2777,	'Natural Person',	'Europe',	'Belgium',	'2020-02-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2778,	'Natural Person',	'North America',	'United States',	'2020-02-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2779,	'Natural Person',	'Europe',	'France',	'2020-03-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2780,	'Natural Person',	'Asia',	'Kuwait',	'2020-04-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2781,	'Natural Person',	'North America',	'Canada',	'2020-06-21',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2782,	'Natural Person',	'Europe',	'United Kingdom',	'2020-07-05',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2783,	'Natural Person',	'North America',	'Mexico',	'2020-07-11',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2784,	'Natural Person',	'Europe',	'Spain',	'2021-01-19',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2785,	'Natural Person',	'Asia',	'Kuwait',	'2021-03-13',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2786,	'Natural Person',	'Europe',	'Germany',	'2021-12-12',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2787,	'Natural Person',	'North America',	'United States',	'2021-12-25',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2788,	'Natural Person',	'Africa',	'Nigeria',	'2022-03-01',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2789,	'Natural Person',	'Asia',	'Oman',	'2022-05-08',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2790,	'Natural Person',	'North America',	'Mexico',	'2022-10-02',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2791,	'Natural Person',	'Europe',	'Spain',	'2023-01-15',	'2.3 Beauty and Personal Care',	'GlowGoddess Illuminating Facial Serum',	1,	99,	99),  (2792,	'public company',	'North America',	'Canada',	'2020-03-09',	'2.1 Books and Stationery',	'SketchSync Artists Sketchbook',	1,	50625,	50625),  (2794,	'Legal entity',	'South America',	'Brazil',	'2023-07-28',	'2.1 Books and Stationery',	'EcoWrite Recycled Paper Set',	1,	578.85,	578.85),  (2795,	'Natural Person',	'Europe',	'Austria',	'2022-05-20',	'2.1 Books and Stationery',	'PoetPulse Poetry Anthology',	1,	789,	789),  (2796,	'Legal entity',	'Asia',	'Hong Kong',	'2019-01-15',	'2.1 Books and Stationery',	'LuminaLuxe Reading Lamp',	1,	388.58,	388.58),  (2797,	'Legal entity',	'Asia',	'Hong Kong',	'2021-09-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2159.46,	2159.46),  (2798,	'Legal entity',	'Asia',	'Hong Kong',	'2022-02-15',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	12375,	12375),  (2799,	'Legal entity',	'South America',	'Brazil',	'2022-07-28',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	1333.54,	1333.54),  (2800,	'Legal entity',	'Europe',	'France',	'2022-08-08',	'2.1 Books and Stationery',	'TechTome Coding Notebook',	1,	2666.25,	2666.25),  (2801,	'Natural Person',	'Europe',	'Portugal',	'2018-12-25',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	539.73,	539.73),  (2802,	'Natural Person',	'South America',	'Brazil',	'2018-12-30',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	599.7,	599.7),  (2803,	'Natural Person',	'Europe',	'United Kingdom',	'2019-01-05',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	599.7,	599.7),  (2804,	'Natural Person',	'North America',	'Mexico',	'2019-01-19',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	239.4,	239.4),  (2805,	'Natural Person',	'North America',	'Mexico',	'2019-02-23',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	239.4,	239.4),  (2806,	'Natural Person',	'North America',	'United States',	'2019-03-02',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	239.4,	239.4),  (2807,	'Natural Person',	'Europe',	'Liechtenstein',	'2019-03-24',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	599.7,	599.7),  (2808,	'Natural Person',	'Asia',	'India',	'2019-08-04',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2809,	'Natural Person',	'North America',	'United States',	'2019-11-02',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	749.63,	749.63),  (2810,	'Natural Person',	'North America',	'United States',	'2019-12-21',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2811,	'Legal entity',	'South America',	'Brazil',	'2020-01-30',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	524.74,	524.74),  (2812,	'Natural Person',	'South America',	'Ecuador',	'2020-03-14',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2813,	'Natural Person',	'South America',	'Chile',	'2020-05-16',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2814,	'Natural Person',	'Europe',	'United Kingdom',	'2020-06-06',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	749.63,	749.63),  (2815,	'Natural Person',	'Europe',	'United Kingdom',	'2020-09-05',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	749.63,	749.63),  (2816,	'Natural Person',	'Europe',	'France',	'2020-10-18',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2817,	'Natural Person',	'Asia',	'India',	'2020-11-02',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2818,	'Natural Person',	'North America',	'United States',	'2021-01-10',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2819,	'Natural Person',	'Europe',	'Netherlands',	'2021-01-14',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	749.63,	749.63),  (2820,	'Natural Person',	'Europe',	'Spain',	'2021-01-23',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2821,	'Natural Person',	'North America',	'Honduras',	'2021-04-04',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2822,	'Natural Person',	'Africa',	'Nigeria',	'2021-06-12',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2823,	'Legal entity',	'North America',	'Bahamas',	'2021-06-20',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	749.63,	749.63),  (2824,	'Natural Person',	'South America',	'Ecuador',	'2021-07-03',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2825,	'Natural Person',	'North America',	'United States',	'2021-07-25',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	299.25,	299.25),  (2826,	'Natural Person',	'Asia',	'Hong Kong',	'2021-08-14',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	749.63,	749.63),  (2827,	'Natural Person',	'Europe',	'Spain',	'2021-10-17',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	336.75,	336.75),  (2828,	'Natural Person',	'North America',	'Haiti',	'2021-12-22',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	861.75,	861.75),  (2829,	'Natural Person',	'South America',	'Bolivia',	'2022-01-21',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	861.75,	861.75),  (2830,	'Natural Person',	'North America',	'United States',	'2022-04-02',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	861.75,	861.75),  (2831,	'Natural Person',	'North America',	'Mexico',	'2022-04-03',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	235.73,	235.73),  (2832,	'Legal entity',	'Europe',	'France',	'2022-04-07',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	775.58,	775.58),  (2833,	'Natural Person',	'Europe',	'France',	'2022-05-07',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	861.75,	861.75),  (2834,	'Natural Person',	'Europe',	'Netherlands',	'2022-05-14',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	861.75,	861.75),  (2835,	'Natural Person',	'South America',	'Brazil',	'2022-07-31',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	861.75,	861.75),  (2836,	'Natural Person',	'South America',	'Chile',	'2022-08-13',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	336.75,	336.75),  (2837,	'Legal entity',	'Africa',	'Uganda',	'2022-12-17',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	374.25,	374.25),  (2838,	'Natural Person',	'Europe',	'Switzerland',	'2023-01-12',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	959.25,	959.25),  (2839,	'Natural Person',	'Asia',	'Indonesia',	'2023-01-18',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	837.35,	837.35),  (2840,	'Natural Person',	'South America',	'Colombia',	'2023-02-27',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	374.25,	374.25),  (2841,	'Legal entity',	'North America',	'Canada',	'2023-03-25',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	374.25,	374.25),  (2842,	'Legal entity',	'Africa',	'Egypt',	'2023-04-22',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	959.25,	959.25),  (2843,	'Natural Person',	'South America',	'Colombia',	'2023-05-06',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	243.26,	243.26),  (2844,	'Natural Person',	'Europe',	'United Kingdom',	'2023-06-05',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	671.48,	671.48),  (2845,	'Natural Person',	'Europe',	'Germany',	'2023-07-01',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	959.25,	959.25),  (2846,	'Natural Person',	'North America',	'United States',	'2023-07-02',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	863.33,	863.33),  (2847,	'Natural Person',	'Asia',	'Indonesia',	'2023-07-08',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	374.25,	374.25),  (2848,	'Natural Person',	'Europe',	'France',	'2023-07-15',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	374.25,	374.25),  (2849,	'Natural Person',	'South America',	'Chile',	'2023-09-02',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	411.75,	411.75),  (2851,	'Natural Person',	'North America',	'Honduras',	'2023-10-28',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	411.75,	411.75),  (2852,	'Natural Person',	'South America',	'Brazil',	'2023-10-30',	'1.2 Food and Beverages',	'SpiceHarbor Artisanal Spice Collection',	1,	1056.75,	1056.75),  (2853,	'Natural Person',	'South America',	'Argentina',	'2020-05-17',	'1.2 Food and Beverages',	'MunchMaster Snack Variety Pack',	1,	1499.63,	1499.63),  (2854,	'Legal entity',	'South America',	'Brazil',	'2020-12-27',	'1.2 Food and Beverages',	'MunchMaster Snack Variety Pack',	1,	1499.63,	1499.63),  (2855,	'Legal entity',	'Europe',	'United Kingdom',	'2022-06-03',	'1.2 Food and Beverages',	'MunchMaster Snack Variety Pack',	1,	1551.83,	1551.83),  (2856,	'Legal entity',	'North America',	'Honduras',	'2023-02-23',	'1.2 Food and Beverages',	'MunchMaster Snack Variety Pack',	1,	1912.5,	1912.5),  (2857,	'Natural Person',	'South America',	'Argentina',	'2018-09-01',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	269.55,	269.55),  (2858,	'Natural Person',	'South America',	'Colombia',	'2018-11-03',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	359.4,	359.4),  (2859,	'Natural Person',	'Europe',	'Hungary',	'2019-01-12',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	359.4,	359.4),  (2860,	'Legal entity',	'South America',	'Colombia',	'2019-05-19',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	449.25,	449.25),  (2861,	'Natural Person',	'North America',	'Costa Rica',	'2020-02-01',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	449.25,	449.25),  (2862,	'Natural Person',	'South America',	'Peru',	'2022-01-19',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	876.15,	876.15),  (2863,	'Natural Person',	'Asia',	'United Arab Emirates',	'2022-02-05',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	486.75,	486.75),  (2864,	'Natural Person',	'South America',	'Colombia',	'2022-09-04',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	486.75,	486.75),  (2865,	'Natural Person',	'South America',	'Brazil',	'2020-03-29',	'1.2 Food and Beverages',	'PureDelight Dark Chocolate Truffles',	1,	1124.63,	1124.63),  (2866,	'Legal entity',	'Asia',	'Hong Kong',	'2021-05-15',	'1.2 Food and Beverages',	'PureDelight Dark Chocolate Truffles',	1,	1124.63,	1124.63),  (2867,	'Natural Person',	'North America',	'Canada',	'2021-12-08',	'1.2 Food and Beverages',	'PureDelight Dark Chocolate Truffles',	1,	2623.5,	2623.5),  (2868,	'Natural Person',	'Europe',	'Germany',	'2019-01-06',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	279.2,	279.2),  (2869,	'Natural Person',	'South America',	'Colombia',	'2019-08-31',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2870,	'Natural Person',	'South America',	'Argentina',	'2019-09-01',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2871,	'Natural Person',	'Asia',	'United Arab Emirates',	'2019-11-10',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2872,	'Natural Person',	'Asia',	'Saudi Arabia',	'2020-01-05',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2873,	'Natural Person',	'South America',	'Ecuador',	'2020-02-09',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2874,	'Natural Person',	'Europe',	'Germany',	'2020-02-16',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2875,	'Natural Person',	'South America',	'Paraguay',	'2020-12-28',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2876,	'Natural Person',	'North America',	'United States',	'2021-01-09',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2877,	'Natural Person',	'Europe',	'Italy',	'2021-02-13',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2878,	'Natural Person',	'Europe',	'United Kingdom',	'2021-06-13',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2879,	'Natural Person',	'South America',	'Chile',	'2021-08-07',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2880,	'Natural Person',	'North America',	'United States',	'2021-08-28',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	261.75,	261.75),  (2881,	'Natural Person',	'Europe',	'Switzerland',	'2022-02-22',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	299.25,	299.25),  (2882,	'Natural Person',	'North America',	'United States',	'2022-02-26',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	299.25,	299.25),  (2883,	'Natural Person',	'South America',	'Argentina',	'2022-03-05',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	299.25,	299.25),  (2884,	'Natural Person',	'Europe',	'Netherlands',	'2022-06-19',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	299.25,	299.25),  (2885,	'Natural Person',	'South America',	'Peru',	'2022-08-28',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	299.25,	299.25),  (2886,	'Natural Person',	'Europe',	'Italy',	'2022-09-03',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	299.25,	299.25),  (2887,	'Natural Person',	'South America',	'Chile',	'2023-09-03',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	374.25,	374.25),  (2888,	'Natural Person',	'Europe',	'France',	'2023-09-04',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	374.25,	374.25),  (2889,	'Natural Person',	'Europe',	'Switzerland',	'2023-09-30',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	374.25,	374.25),  (2890,	'Legal entity',	'North America',	'Mexico',	'2019-10-12',	'1.2 Food and Beverages',	'HeavenlyHarvest Quinoa Crunch Cereal',	1,	299.25,	299.25),  (2891,	'Natural Person',	'North America',	'United States',	'2022-02-12',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	239.4,	239.4),  (2892,	'Natural Person',	'Europe',	'Netherlands',	'2022-02-28',	'1.2 Food and Beverages',	'ZenTea Elixir Collection',	1,	239.4,	239.4),  (2893,	'Natural Person',	'Asia',	'Thailand',	'2022-02-13',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	778.8,	778.8),  (2894,	'Natural Person',	'Europe',	'Italy',	'2022-04-21',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	389.4,	389.4),  (2895,	'Natural Person',	'South America',	'Venezuela',	'2022-10-15',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2896,	'Natural Person',	'Europe',	'Germany',	'2022-12-18',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2897,	'Natural Person',	'South America',	'Chile',	'2023-01-21',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2898,	'Natural Person',	'Europe',	'Poland',	'2023-01-24',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2899,	'Legal entity',	'South America',	'Colombia',	'2023-04-30',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2900,	'Natural Person',	'Europe',	'Romania',	'2023-05-28',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2901,	'Natural Person',	'Asia',	'Thailand',	'2023-07-16',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	419.4,	419.4),  (2902,	'Natural Person',	'South America',	'Peru',	'2023-08-13',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	838.8,	838.8),  (2903,	'Legal entity',	'Asia',	'Philippines',	'2023-09-10',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	461.4,	461.4),  (2904,	'Natural Person',	'North America',	'Honduras',	'2023-11-05',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	461.4,	461.4),  (2905,	'Natural Person',	'North America',	'Mexico',	'2023-11-11',	'2.2 Home and Decor',	'TranquilHue Aromatherapy Diffuser',	1,	461.4,	461.4),  (2906,	'Natural Person',	'South America',	'Peru',	'2022-01-22',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2907,	'Natural Person',	'North America',	'Mexico',	'2022-01-23',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	239.4,	239.4),  (2908,	'Natural Person',	'South America',	'Peru',	'2022-01-29',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.33,	269.33),  (2909,	'Natural Person',	'Europe',	'Greece',	'2022-03-06',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	239.4,	239.4),  (2910,	'Natural Person',	'North America',	'Mexico',	'2022-06-26',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2911,	'Natural Person',	'Europe',	'Italy',	'2022-07-03',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	239.4,	239.4),  (2912,	'Natural Person',	'North America',	'Guatemala',	'2022-07-16',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2913,	'Natural Person',	'Africa',	'Mali',	'2022-07-23',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	303.08,	303.08),  (2914,	'Natural Person',	'Europe',	'France',	'2022-08-07',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	689.4,	689.4),  (2915,	'Natural Person',	'Europe',	'Hungary',	'2022-10-23',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2916,	'Natural Person',	'South America',	'Ecuador',	'2022-10-29',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2917,	'Natural Person',	'North America',	'United States',	'2022-11-06',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2918,	'Legal entity',	'North America',	'Mexico',	'2022-11-13',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2919,	'Natural Person',	'Europe',	'Spain',	'2023-01-22',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2920,	'Natural Person',	'South America',	'Chile',	'2023-02-12',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2921,	'Natural Person',	'South America',	'Ecuador',	'2023-02-18',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2922,	'Natural Person',	'Asia',	'Japan',	'2023-03-04',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2923,	'Natural Person',	'North America',	'United States',	'2023-03-05',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2924,	'Natural Person',	'South America',	'Ecuador',	'2023-03-26',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2925,	'Natural Person',	'North America',	'United States',	'2023-04-07',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2926,	'Natural Person',	'Oceania',	'Australia',	'2023-04-08',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2927,	'Natural Person',	'Europe',	'Finland',	'2023-05-13',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2928,	'Natural Person',	'Africa',	'South Africa',	'2023-06-11',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	767.4,	767.4),  (2929,	'Natural Person',	'Europe',	'Italy',	'2023-06-24',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2930,	'Natural Person',	'Africa',	'South Africa',	'2023-07-23',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2931,	'Natural Person',	'Oceania',	'Australia',	'2023-08-06',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2932,	'Natural Person',	'South America',	'Peru',	'2023-08-27',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	269.4,	269.4),  (2933,	'Natural Person',	'South America',	'Chile',	'2023-09-09',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	329.4,	329.4),  (2934,	'Natural Person',	'Europe',	'Italy',	'2023-10-11',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	299.4,	299.4),  (2935,	'Natural Person',	'Asia',	'Hong Kong',	'2023-10-15',	'2.2 Home and Decor',	'LuxeLoom Velvet Throw Pillows',	1,	845.4,	845.4),  (2936,	'Natural Person',	'North America',	'United States',	'2022-02-27',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	200,	200),  (2937,	'Natural Person',	'Asia',	'Malaysia',	'2022-12-11',	'1.2 Food and Beverages',	'BioFuel Protein Bars',	1,	200,	200),  (2938,	'Legal entity',	'South America',	'Colombia',	'2020-07-19',	'1.2 Food and Beverages',	'GourmetBlend Coffee Beans',	1,	50,	50),  (2939,	'Natural Person',	'Europe',	'Sweden',	'2017-01-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2940,	'Legal entity',	'North America',	'United States',	'2017-01-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (2941,	'Legal entity',	'South America',	'Brazil',	'2017-01-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	300.36,	300.36),  (2942,	'Natural Person',	'North America',	'Honduras',	'2017-01-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (2943,	'Natural Person',	'Asia',	'Indonesia',	'2017-01-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (2944,	'Natural Person',	'Europe',	'Germany',	'2017-01-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.63,	299.63),  (2945,	'Legal entity',	'Africa',	'Angola',	'2017-01-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.7,	239.7),  (2946,	'Natural Person',	'Europe',	'Germany',	'2017-01-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2947,	'Legal entity',	'South America',	'Argentina',	'2017-01-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.2,	239.2),  (2948,	'Natural Person',	'Europe',	'Germany',	'2017-01-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.2,	239.2),  (2949,	'Legal entity',	'North America',	'Costa Rica',	'2017-01-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2950,	'Legal entity',	'North America',	'Panama',	'2016-02-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2951,	'Legal entity',	'North America',	'Panama',	'2016-02-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2952,	'Natural Person',	'Africa',	'South Africa',	'2016-02-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2953,	'Legal entity',	'South America',	'Chile',	'2016-02-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2954,	'Natural Person',	'North America',	'United States',	'2016-02-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2955,	'Natural Person',	'Europe',	'United Kingdom',	'2016-02-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2956,	'Natural Person',	'North America',	'United States',	'2016-02-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2957,	'Natural Person',	'North America',	'Dominican Republic',	'2016-02-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2958,	'Legal entity',	'North America',	'United States',	'2016-02-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2959,	'Legal entity',	'North America',	'United States',	'2016-02-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2960,	'Legal entity',	'North America',	'United States',	'2016-02-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99.75,	99.75),  (2961,	'Natural Person',	'Africa',	'Nigeria',	'2016-02-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2962,	'Natural Person',	'Europe',	'Italy',	'2016-02-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2963,	'Natural Person',	'Europe',	'Germany',	'2016-02-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2964,	'Natural Person',	'North America',	'United States',	'2016-02-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2965,	'Natural Person',	'Europe',	'Switzerland',	'2016-02-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2966,	'Legal entity',	'South America',	'Colombia',	'2016-02-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2967,	'Natural Person',	'Europe',	'Germany',	'2016-02-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2968,	'Legal entity',	'North America',	'Mexico',	'2016-12-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2969,	'Natural Person',	'North America',	'United States',	'2016-12-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.2,	239.2),  (2970,	'Legal entity',	'South America',	'Chile',	'2016-12-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2971,	'Natural Person',	'North America',	'United States',	'2016-12-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2972,	'Natural Person',	'Asia',	'Japan',	'2016-12-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2973,	'Legal entity',	'South America',	'Argentina',	'2016-12-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2974,	'Legal entity',	'South America',	'Ecuador',	'2016-12-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	447,	447),  (2975,	'Legal entity',	'North America',	'Mexico',	'2016-12-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	897,	897),  (2976,	'Natural Person',	'Asia',	'Indonesia',	'2016-12-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (2977,	'public company',	'Europe',	'France',	'2016-12-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (2978,	'Natural Person',	'Europe',	'Italy',	'2016-12-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.75,	199.75),  (2979,	'Natural Person',	'North America',	'United States',	'2016-12-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	59.4,	59.4),  (2980,	'Legal entity',	'Europe',	'Latvia',	'2016-12-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (2981,	'Natural Person',	'Europe',	'United Kingdom',	'2016-12-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	284.64,	284.64),  (2982,	'Natural Person',	'Africa',	'Nigeria',	'2017-04-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2983,	'Natural Person',	'North America',	'United States',	'2017-04-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2984,	'Natural Person',	'North America',	'United States',	'2017-04-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2985,	'Legal entity',	'North America',	'Mexico',	'2017-04-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2986,	'Natural Person',	'Europe',	'Italy',	'2017-04-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2987,	'Natural Person',	'North America',	'Mexico',	'2017-04-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2988,	'Legal entity',	'South America',	'Chile',	'2017-04-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2989,	'Natural Person',	'North America',	'United States',	'2017-04-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2990,	'Natural Person',	'Asia',	'Thailand',	'2017-04-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2991,	'Natural Person',	'North America',	'United States',	'2017-04-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2992,	'Legal entity',	'North America',	'Costa Rica',	'2017-04-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	198,	198),  (2993,	'Natural Person',	'North America',	'Canada',	'2017-04-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.66,	269.66),  (2994,	'Natural Person',	'Europe',	'France',	'2017-04-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (2995,	'Natural Person',	'North America',	'United States',	'2016-03-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2996,	'Legal entity',	'Oceania',	'Australia',	'2016-03-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2997,	'Natural Person',	'North America',	'Jamaica',	'2016-03-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (2998,	'Natural Person',	'Oceania',	'Australia',	'2016-03-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (2999,	'Natural Person',	'South America',	'Chile',	'2016-03-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99);
INSERT INTO `comparison` VALUES (3000,	'Natural Person',	'Europe',	'Italy',	'2016-03-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3001,	'Legal entity',	'South America',	'Chile',	'2016-03-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	297,	297),  (3002,	'Natural Person',	'North America',	'Mexico',	'2016-03-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3003,	'Legal entity',	'Africa',	'Nigeria',	'2016-03-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3004,	'public company',	'South America',	'Ecuador',	'2016-03-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	297,	297),  (3005,	'Natural Person',	'South America',	'Colombia',	'2016-03-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3006,	'Natural Person',	'Europe',	'Italy',	'2016-03-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3007,	'Natural Person',	'Asia',	'Malaysia',	'2016-03-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3008,	'Natural Person',	'North America',	'United States',	'2016-04-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99.75,	99.75),  (3009,	'Natural Person',	'North America',	'Mexico',	'2016-04-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3010,	'Natural Person',	'Asia',	'Indonesia',	'2016-04-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3011,	'Natural Person',	'Europe',	'Bosnia and Herzegovina',	'2016-04-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3012,	'Natural Person',	'Africa',	'Egypt',	'2016-04-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3013,	'Legal entity',	'Europe',	'Norway',	'2016-04-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3014,	'Legal entity',	'Europe',	'Romania',	'2016-04-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	337.16,	337.16),  (3015,	'Natural Person',	'South America',	'Brazil',	'2016-04-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3016,	'Legal entity',	'Africa',	'South Africa',	'2017-06-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3017,	'Legal entity',	'Africa',	'South Africa',	'2017-06-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3018,	'Natural Person',	'Europe',	'Switzerland',	'2017-06-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3019,	'Legal entity',	'Europe',	'Netherlands',	'2017-06-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3020,	'Natural Person',	'Africa',	'Ethiopia',	'2017-06-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.63,	299.63),  (3021,	'public company',	'Europe',	'Switzerland',	'2016-04-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	600,	600),  (3022,	'Natural Person',	'North America',	'United States',	'2016-03-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3023,	'Natural Person',	'Asia',	'Indonesia',	'2016-03-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3024,	'Natural Person',	'Africa',	'South Africa',	'2016-03-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	79.2,	79.2),  (3025,	'Legal entity',	'South America',	'Argentina',	'2016-03-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3026,	'Natural Person',	'South America',	'Argentina',	'2016-04-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3027,	'Legal entity',	'South America',	'Colombia',	'2016-04-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3028,	'Legal entity',	'Europe',	'United Kingdom',	'2016-04-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3029,	'Natural Person',	'Europe',	'Germany',	'2016-04-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3030,	'Natural Person',	'Asia',	'Turkey',	'2016-04-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3031,	'Legal entity',	'South America',	'Colombia',	'2016-04-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3032,	'Legal entity',	'North America',	'United States',	'2016-04-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3033,	'Natural Person',	'North America',	'Mexico',	'2016-04-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3034,	'Natural Person',	'Europe',	'United Kingdom',	'2016-04-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3035,	'Natural Person',	'Europe',	'Portugal',	'2016-04-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3036,	'Natural Person',	'Europe',	'Netherlands',	'2016-04-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3037,	'Natural Person',	'North America',	'Panama',	'2017-06-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3038,	'Natural Person',	'Europe',	'Switzerland',	'2017-06-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3039,	'Legal entity',	'North America',	'Guatemala',	'2017-06-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3040,	'Natural Person',	'Africa',	'Libyan Arab Jamahiriya',	'2017-02-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3041,	'public company',	'Asia',	'Hong Kong',	'2017-06-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	287.64,	287.64),  (3042,	'Natural Person',	'South America',	'Brazil',	'2017-06-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	179.55,	179.55),  (3043,	'Legal entity',	'South America',	'Colombia',	'2017-06-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3044,	'Natural Person',	'Europe',	'France',	'2017-06-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3045,	'Natural Person',	'North America',	'Honduras',	'2017-02-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3046,	'Natural Person',	'Europe',	'Bosnia and Herzegovina',	'2017-02-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	279.65,	279.65),  (3047,	'Natural Person',	'Africa',	'Angola',	'2017-02-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3048,	'Legal entity',	'South America',	'Argentina',	'2017-02-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	287.64,	287.64),  (3049,	'Legal entity',	'Europe',	'Netherlands',	'2017-02-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.1,	269.1),  (3050,	'Natural Person',	'Europe',	'Switzerland',	'2017-02-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3051,	'Natural Person',	'Europe',	'France',	'2017-02-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3052,	'Natural Person',	'Europe',	'Germany',	'2017-02-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	287.64,	287.64),  (3053,	'Legal entity',	'North America',	'United States',	'2017-02-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3054,	'Legal entity',	'South America',	'Chile',	'2017-02-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3055,	'Natural Person',	'South America',	'Ecuador',	'2017-02-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3056,	'Natural Person',	'Europe',	'Italy',	'2017-02-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3057,	'Natural Person',	'Europe',	'Germany',	'2017-02-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3058,	'Natural Person',	'Europe',	'Italy',	'2017-02-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3059,	'Legal entity',	'North America',	'Mexico',	'2017-02-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3060,	'Legal entity',	'South America',	'Ecuador',	'2017-02-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3061,	'Natural Person',	'Asia',	'Qatar',	'2017-02-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.2,	239.2),  (3062,	'Legal entity',	'North America',	'Mexico',	'2017-02-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3063,	'Legal entity',	'South America',	'Colombia',	'2016-06-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3064,	'Natural Person',	'Europe',	'Romania',	'2016-06-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3065,	'Natural Person',	'South America',	'Argentina',	'2016-06-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3066,	'Natural Person',	'Europe',	'Belgium',	'2016-06-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3067,	'Natural Person',	'South America',	'Peru',	'2016-06-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3068,	'Legal entity',	'South America',	'Ecuador',	'2016-06-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3069,	'Natural Person',	'North America',	'Puerto Rico',	'2016-06-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3070,	'Natural Person',	'Europe',	'Spain',	'2016-06-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3071,	'Natural Person',	'North America',	'Mexico',	'2016-06-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99.75,	99.75),  (3072,	'Legal entity',	'North America',	'United States',	'2016-06-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3073,	'Legal entity',	'Europe',	'United Kingdom',	'2016-06-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3074,	'Legal entity',	'Europe',	'France',	'2016-06-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	448.5,	448.5),  (3075,	'Natural Person',	'Africa',	'South Africa',	'2016-06-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3076,	'Natural Person',	'Asia',	'Hong Kong',	'2016-06-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3077,	'Natural Person',	'Asia',	'Indonesia',	'2016-06-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3078,	'Natural Person',	'Europe',	'Luxembourg',	'2016-06-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3079,	'Natural Person',	'Asia',	'Pakistan',	'2016-06-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3080,	'Legal entity',	'Oceania',	'Australia',	'2017-03-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3081,	'Legal entity',	'Europe',	'Liechtenstein',	'2017-03-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.66,	269.66),  (3082,	'Natural Person',	'South America',	'Brazil',	'2017-03-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3083,	'Legal entity',	'South America',	'Colombia',	'2016-06-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3084,	'Natural Person',	'North America',	'Puerto Rico',	'2016-06-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3085,	'Legal entity',	'Europe',	'Finland',	'2016-06-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3086,	'Natural Person',	'Europe',	'Spain',	'2016-06-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3087,	'Legal entity',	'South America',	'Colombia',	'2017-03-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3088,	'Natural Person',	'North America',	'Panama',	'2017-03-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3089,	'Natural Person',	'North America',	'Canada',	'2017-03-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3090,	'Legal entity',	'North America',	'United States',	'2017-03-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3091,	'Natural Person',	'South America',	'Colombia',	'2017-03-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3092,	'Natural Person',	'North America',	'United States',	'2017-03-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3093,	'Natural Person',	'Asia',	'Indonesia',	'2017-03-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3094,	'Legal entity',	'North America',	'United States',	'2017-03-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3095,	'Legal entity',	'South America',	'Chile',	'2017-03-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3096,	'Natural Person',	'Europe',	'Ireland',	'2017-03-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3097,	'Natural Person',	'Europe',	'Belgium',	'2017-03-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	198,	198),  (3098,	'Natural Person',	'North America',	'United States',	'2017-03-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3099,	'Legal entity',	'South America',	'Colombia',	'2017-03-31',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3100,	'Natural Person',	'South America',	'Paraguay',	'2016-10-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3101,	'Natural Person',	'South America',	'Brazil',	'2016-10-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.66,	269.66),  (3102,	'Natural Person',	'Europe',	'United Kingdom',	'2017-03-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3103,	'Natural Person',	'Europe',	'United Kingdom',	'2017-03-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3104,	'Natural Person',	'North America',	'Canada',	'2017-03-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3105,	'Natural Person',	'Europe',	'Switzerland',	'2017-03-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3106,	'Natural Person',	'Asia',	'Indonesia',	'2017-03-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3107,	'Legal entity',	'Europe',	'United Kingdom',	'2016-10-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3108,	'Natural Person',	'North America',	'United States',	'2016-10-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3109,	'Natural Person',	'North America',	'United States',	'2016-10-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3110,	'Natural Person',	'North America',	'United States',	'2016-10-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3111,	'Natural Person',	'Asia',	'United Arab Emirates',	'2016-10-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3112,	'Natural Person',	'Europe',	'Belgium',	'2016-10-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3113,	'Natural Person',	'Asia',	'Malaysia',	'2016-10-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3114,	'Natural Person',	'North America',	'United States',	'2016-10-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3115,	'Natural Person',	'Europe',	'Italy',	'2016-10-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3116,	'Natural Person',	'North America',	'United States',	'2016-10-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3117,	'Natural Person',	'South America',	'Brazil',	'2016-10-31',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	224.1,	224.1),  (3118,	'Natural Person',	'Europe',	'Malta',	'2016-10-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3119,	'Natural Person',	'Asia',	'Jordan',	'2016-10-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3120,	'Natural Person',	'Europe',	'Croatia',	'2016-10-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3121,	'Legal entity',	'Asia',	'Indonesia',	'2016-10-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3122,	'Legal entity',	'North America',	'Guatemala',	'2016-10-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3123,	'Natural Person',	'South America',	'Peru',	'2016-10-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3124,	'Natural Person',	'North America',	'United States',	'2016-10-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3125,	'Natural Person',	'Europe',	'Italy',	'2016-10-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3126,	'Legal entity',	'Europe',	'Czech Republic',	'2016-11-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	59,	59),  (3127,	'Legal entity',	'Europe',	'Belgium',	'2016-11-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3128,	'Natural Person',	'Asia',	'Indonesia',	'2016-11-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3129,	'Natural Person',	'Africa',	'South Africa',	'2016-11-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	89.1,	89.1),  (3130,	'Natural Person',	'South America',	'Brazil',	'2016-11-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.7,	239.7),  (3131,	'Natural Person',	'Europe',	'Romania',	'2016-11-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3132,	'Natural Person',	'South America',	'Peru',	'2016-11-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.7,	239.7),  (3133,	'Natural Person',	'South America',	'Chile',	'2016-11-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3134,	'Natural Person',	'Africa',	'Cameroon',	'2016-11-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	445.5,	445.5),  (3135,	'Natural Person',	'Asia',	'Hong Kong',	'2016-11-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	249,	249),  (3136,	'Natural Person',	'Africa',	'South Africa',	'2016-11-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	224,	224),  (3137,	'Natural Person',	'Europe',	'Italy',	'2016-11-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	249,	249),  (3138,	'Legal entity',	'Europe',	'United Kingdom',	'2016-11-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	224.1,	224.1),  (3139,	'Legal entity',	'South America',	'Brazil',	'2016-11-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.7,	239.7),  (3140,	'Natural Person',	'Asia',	'Viet Nam',	'2016-11-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	239.7,	239.7),  (3141,	'Natural Person',	'Europe',	'Slovenia',	'2016-11-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	227.71,	227.71),  (3142,	'public company',	'Europe',	'France',	'2016-11-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (3143,	'Legal entity',	'North America',	'Puerto Rico',	'2016-11-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3144,	'Natural Person',	'Asia',	'Thailand',	'2016-11-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3145,	'Natural Person',	'North America',	'Canada',	'2016-11-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3146,	'Natural Person',	'North America',	'Canada',	'2016-11-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3147,	'Legal entity',	'South America',	'Paraguay',	'2016-11-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	746.25,	746.25),  (3148,	'Natural Person',	'Africa',	'Guinea',	'2016-11-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3149,	'Legal entity',	'Africa',	'Guinea',	'2016-11-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	89.1,	89.1),  (3150,	'Legal entity',	'South America',	'Colombia',	'2016-05-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3151,	'Natural Person',	'North America',	'Dominican Republic',	'2016-05-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3152,	'Legal entity',	'Europe',	'Spain',	'2016-05-31',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3153,	'Legal entity',	'South America',	'Argentina',	'2016-08-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3154,	'Natural Person',	'South America',	'Colombia',	'2016-08-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3155,	'Legal entity',	'South America',	'Chile',	'2016-08-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3156,	'Legal entity',	'Oceania',	'Australia',	'2016-08-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3157,	'Natural Person',	'North America',	'United States',	'2016-08-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3158,	'Natural Person',	'Oceania',	'New Zealand',	'2016-08-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3159,	'Natural Person',	'Europe',	'France',	'2016-08-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3160,	'Natural Person',	'North America',	'United States',	'2016-08-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3161,	'Natural Person',	'Africa',	'South Africa',	'2016-08-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3162,	'Legal entity',	'North America',	'United States',	'2016-08-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3163,	'Legal entity',	'South America',	'Chile',	'2016-08-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3164,	'Natural Person',	'North America',	'Mexico',	'2016-08-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3165,	'Natural Person',	'South America',	'Argentina',	'2016-09-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3166,	'Legal entity',	'South America',	'Ecuador',	'2016-09-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3167,	'Natural Person',	'Europe',	'United Kingdom',	'2016-09-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3168,	'Legal entity',	'South America',	'Argentina',	'2016-09-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3169,	'Natural Person',	'South America',	'Paraguay',	'2016-09-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3170,	'Legal entity',	'Europe',	'Spain',	'2016-09-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3171,	'Legal entity',	'North America',	'Mexico',	'2016-09-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3172,	'Legal entity',	'South America',	'Colombia',	'2016-09-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3173,	'Natural Person',	'North America',	'United States',	'2016-09-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3174,	'Natural Person',	'Asia',	'Thailand',	'2016-09-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3175,	'Natural Person',	'North America',	'United States',	'2016-09-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3176,	'Natural Person',	'North America',	'United States',	'2016-09-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3177,	'Natural Person',	'Europe',	'Germany',	'2016-09-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3178,	'Natural Person',	'Asia',	'Philippines',	'2016-09-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3179,	'Natural Person',	'North America',	'United States',	'2016-05-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3180,	'Legal entity',	'Europe',	'United Kingdom',	'2016-05-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3181,	'Legal entity',	'Europe',	'United Kingdom',	'2016-05-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3182,	'Natural Person',	'Europe',	'United Kingdom',	'2016-05-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3183,	'Legal entity',	'North America',	'Canada',	'2016-05-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	337.16,	337.16),  (3184,	'Legal entity',	'Africa',	'South Africa',	'2016-05-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3185,	'Legal entity',	'Africa',	'South Africa',	'2016-05-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.1,	269.1),  (3186,	'Legal entity',	'Europe',	'Switzerland',	'2016-05-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3187,	'Natural Person',	'Europe',	'Netherlands',	'2016-05-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269,	269),  (3188,	'Natural Person',	'Europe',	'Netherlands',	'2016-05-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	374.25,	374.25),  (3189,	'Legal entity',	'South America',	'Argentina',	'2016-05-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.1,	269.1),  (3190,	'Natural Person',	'Europe',	'Austria',	'2016-05-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3191,	'Natural Person',	'North America',	'El Salvador',	'2016-05-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3192,	'Legal entity',	'Europe',	'Luxembourg',	'2016-05-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3193,	'Natural Person',	'Europe',	'France',	'2016-08-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3194,	'Natural Person',	'Africa',	'South Africa',	'2016-08-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.63,	299.63),  (3195,	'Natural Person',	'Africa',	'South Africa',	'2016-08-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3196,	'Legal entity',	'South America',	'Brazil',	'2016-08-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.5,	269.5),  (3197,	'Legal entity',	'South America',	'Brazil',	'2016-08-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	120,	120),  (3198,	'Natural Person',	'South America',	'Brazil',	'2016-08-31',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.1,	269.1),  (3199,	'Natural Person',	'Europe',	'Germany',	'2016-09-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3200,	'Natural Person',	'North America',	'United States',	'2016-09-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3201,	'Legal entity',	'Asia',	'Hong Kong',	'2016-09-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3202,	'Legal entity',	'Europe',	'Spain',	'2016-09-17',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3203,	'Natural Person',	'North America',	'Jamaica',	'2016-09-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3204,	'Natural Person',	'Africa',	'Sierra Leone',	'2016-08-26',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	249,	249),  (3205,	'Natural Person',	'South America',	'Brazil',	'2016-08-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	249,	249),  (3206,	'public company',	'Asia',	'Thailand',	'2018-03-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (3207,	'Natural Person',	'Oceania',	'French Polynesia',	'2018-01-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3208,	'Legal entity',	'South America',	'Argentina',	'2018-03-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3209,	'Natural Person',	'Europe',	'Switzerland',	'2018-01-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3210,	'Natural Person',	'Europe',	'France',	'2018-01-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	179.54,	179.54),  (3211,	'Natural Person',	'South America',	'Brazil',	'2017-08-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3212,	'Natural Person',	'North America',	'United States',	'2017-08-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3213,	'Natural Person',	'Europe',	'Czech Republic',	'2016-09-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3214,	'Legal entity',	'South America',	'Chile',	'2016-09-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3215,	'Natural Person',	'Europe',	'Italy',	'2016-09-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3216,	'Natural Person',	'Asia',	'Thailand',	'2016-09-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3217,	'Legal entity',	'South America',	'Paraguay',	'2016-08-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3218,	'Legal entity',	'North America',	'Costa Rica',	'2016-08-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3219,	'Legal entity',	'South America',	'Ecuador',	'2016-08-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3220,	'Legal entity',	'North America',	'Mexico',	'2016-08-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3221,	'Natural Person',	'Europe',	'Germany',	'2016-08-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3222,	'Natural Person',	'North America',	'United States',	'2016-05-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3223,	'Natural Person',	'South America',	'Peru',	'2016-05-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	189.53,	189.53),  (3224,	'Natural Person',	'South America',	'Colombia',	'2016-05-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3225,	'Legal entity',	'North America',	'Mexico',	'2016-05-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3226,	'Legal entity',	'South America',	'Paraguay',	'2016-05-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3227,	'Legal entity',	'South America',	'Colombia',	'2016-05-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3228,	'Natural Person',	'North America',	'Dominican Republic',	'2016-05-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3229,	'Natural Person',	'Asia',	'India',	'2016-05-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3230,	'Legal entity',	'North America',	'Puerto Rico',	'2016-05-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3231,	'Legal entity',	'Europe',	'France',	'2016-05-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3232,	'Natural Person',	'South America',	'Brazil',	'2017-08-31',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3233,	'Natural Person',	'Europe',	'United Kingdom',	'2017-08-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3234,	'Natural Person',	'Europe',	'United Kingdom',	'2017-08-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3235,	'Natural Person',	'North America',	'United States',	'2017-08-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	169.55,	169.55),  (3236,	'public company',	'Asia',	'Hong Kong',	'2017-12-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (3237,	'public company',	'Europe',	'United Kingdom',	'2017-12-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (3238,	'Natural Person',	'Asia',	'Thailand',	'2018-02-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3239,	'Legal entity',	'Oceania',	'Australia',	'2018-04-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.33,	269.33),  (3240,	'Legal entity',	'North America',	'United States',	'2018-04-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	119.7,	119.7),  (3241,	'Natural Person',	'Asia',	'Thailand',	'2018-02-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3242,	'Legal entity',	'Asia',	'Indonesia',	'2018-02-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (3243,	'Natural Person',	'Europe',	'United Kingdom',	'2017-12-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3244,	'Natural Person',	'South America',	'Ecuador',	'2018-02-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149,	149),  (3245,	'Natural Person',	'Europe',	'Spain',	'2016-07-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3246,	'Natural Person',	'South America',	'Chile',	'2016-07-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3247,	'Legal entity',	'South America',	'Colombia',	'2016-07-03',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3248,	'Legal entity',	'South America',	'Argentina',	'2016-07-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3249,	'Natural Person',	'South America',	'Chile',	'2016-07-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3250,	'Natural Person',	'Europe',	'France',	'2016-07-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3251,	'public company',	'North America',	'United States',	'2016-07-08',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3252,	'Natural Person',	'South America',	'Argentina',	'2016-07-11',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3253,	'Natural Person',	'North America',	'United States',	'2016-07-13',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3254,	'Legal entity',	'South America',	'Colombia',	'2016-07-14',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3255,	'Natural Person',	'Europe',	'United Kingdom',	'2016-07-15',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3256,	'Natural Person',	'North America',	'Canada',	'2016-07-16',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	297,	297),  (3257,	'Natural Person',	'North America',	'United States',	'2016-07-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3258,	'Natural Person',	'North America',	'United States',	'2016-07-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3259,	'Natural Person',	'North America',	'United States',	'2016-07-20',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3260,	'Natural Person',	'South America',	'Peru',	'2016-07-21',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3261,	'Legal entity',	'Africa',	'Ghana',	'2016-07-22',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3262,	'Natural Person',	'Asia',	'Saudi Arabia',	'2016-07-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3263,	'Natural Person',	'Asia',	'Malaysia',	'2016-07-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	149.5,	149.5),  (3264,	'Natural Person',	'Europe',	'United Kingdom',	'2016-07-27',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3265,	'Legal entity',	'South America',	'Venezuela',	'2016-07-29',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3266,	'Natural Person',	'Asia',	'Yemen',	'2016-07-30',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3267,	'Natural Person',	'Europe',	'France',	'2016-07-07',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3268,	'Natural Person',	'North America',	'Canada',	'2016-07-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	374.63,	374.63),  (3269,	'Natural Person',	'Africa',	'South Africa',	'2016-07-10',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3270,	'Natural Person',	'Europe',	'Switzerland',	'2016-07-12',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3271,	'Legal entity',	'Asia',	'Pakistan',	'2016-07-25',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	337.5,	337.5),  (3272,	'Natural Person',	'South America',	'Brazil',	'2016-07-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3273,	'Legal entity',	'Europe',	'Germany',	'2017-09-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3274,	'Natural Person',	'North America',	'United States',	'2017-09-02',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.55,	269.55),  (3275,	'Natural Person',	'Europe',	'United Kingdom',	'2017-09-04',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5),  (3276,	'Natural Person',	'Europe',	'United Kingdom',	'2017-09-05',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199,	199),  (3277,	'Natural Person',	'Europe',	'United Kingdom',	'2017-09-06',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3278,	'public company',	'Asia',	'Hong Kong',	'2018-06-19',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	900,	900),  (3279,	'public company',	'South America',	'Brazil',	'2017-10-31',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	599.25,	599.25),  (3280,	'Legal entity',	'Asia',	'Indonesia',	'2018-06-18',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	637.5,	637.5),  (3281,	'public company',	'Europe',	'Germany',	'2018-06-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3282,	'Legal entity',	'North America',	'Canada',	'2018-05-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299,	299),  (3283,	'Legal entity',	'Asia',	'Jordan',	'2017-10-23',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	269.1,	269.1),  (3284,	'Natural Person',	'South America',	'Colombia',	'2017-11-01',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3285,	'Legal entity',	'North America',	'Mexico',	'2017-11-28',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	99,	99),  (3286,	'Legal entity',	'Africa',	'Mauritius',	'2017-11-24',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	199.5,	199.5),  (3287,	'Legal entity',	'North America',	'Canada',	'2017-11-09',	'2.6 Fashion',	'VogueVista Elegant Leather Handbag',	1,	299.5,	299.5);


-- ----------------------------
-- Table structure for mindmaps
-- ----------------------------
CREATE TABLE `mindmaps` (
`mindmap_id`  int(11) PRIMARY KEY AUTO_INCREMENT,
`mindmap_title`  varchar(50) NOT NULL,
`mindmap_json`  text
);

-- ----------------------------
-- Records of mindmaps
-- ----------------------------
INSERT INTO `mindmaps` VALUES (1, 'My Mindmap 1', '{ "class": "go.TreeModel",
  "nodeDataArray": [ 
{"key":0, "text":"Mind Map", "brush":"black", "loc":"0 0", "stroke":"#ffffff", "background":"#000000", "font":" 10pt sans-serif"},
{"key":1, "parent":0, "text":"Getting more time", "brush":"skyblue", "dir":"right", "loc":"77 -22", "stroke":"#000000", "background":"skyblue"},
{"key":11, "parent":1, "text":"Wake up early", "brush":"skyblue", "dir":"right", "loc":"200 -48", "stroke":"#000000", "background":"skyblue"},
{"key":12, "parent":1, "text":"Delegate", "brush":"skyblue", "dir":"right", "loc":"200 -22", "stroke":"#000000", "background":"skyblue"},
{"key":13, "parent":1, "text":"Simplify", "brush":"skyblue", "dir":"right", "loc":"200 4", "stroke":"#000000", "background":"skyblue"},
{"key":2, "parent":0, "text":"More effective use", "brush":"darkseagreen", "dir":"right", "loc":"77 43", "stroke":"#000000", "background":"darkseagreen"},
{"key":21, "parent":2, "text":"Planning", "brush":"darkseagreen", "dir":"right", "loc":"203 30", "stroke":"#000000", "background":"darkseagreen"},
{"key":211, "parent":21, "text":"Priorities", "brush":"darkseagreen", "dir":"right", "loc":"274 17", "stroke":"#000000", "background":"darkseagreen"},
{"key":212, "parent":21, "text":"Ways to focus", "brush":"darkseagreen", "dir":"right", "loc":"274 43", "stroke":"#000000", "background":"darkseagreen"},
{"key":22, "parent":2, "text":"Goals", "brush":"darkseagreen", "dir":"right", "loc":"203 56", "stroke":"#000000", "background":"darkseagreen"},
{"key":3, "parent":0, "text":"Time wasting", "brush":"palevioletred", "dir":"left", "loc":"-20 -31.75", "stroke":"#000000", "background":"palevioletred"},
{"key":31, "parent":3, "text":"Too many meetings", "brush":"palevioletred", "dir":"left", "loc":"-117 -64.25", "stroke":"#000000", "background":"palevioletred"},
{"key":32, "parent":3, "text":"Too much time spent on details", "brush":"palevioletred", "dir":"left", "loc":"-117 -25.25", "stroke":"#000000", "background":"palevioletred"},
{"key":33, "parent":3, "text":"Message fatigue", "brush":"palevioletred", "dir":"left", "loc":"-117 0.75", "stroke":"#000000", "background":"palevioletred"},
{"key":331, "parent":31, "text":"Check messages less", "brush":"palevioletred", "dir":"left", "loc":"-251 -77.25", "stroke":"#000000", "background":"palevioletred"},
{"key":332, "parent":31, "text":"Message filters", "brush":"palevioletred", "dir":"left", "loc":"-251 -51.25", "stroke":"#000000", "background":"palevioletred"},
{"key":4, "parent":0, "text":"Key issues", "brush":"coral", "dir":"left", "loc":"-20 52.75", "stroke":"#000000", "background":"coral"},
{"key":41, "parent":4, "text":"Methods", "brush":"coral", "dir":"left", "loc":"-103 26.75", "stroke":"#000000", "background":"coral"},
{"key":42, "parent":4, "text":"Deadlines", "brush":"coral", "dir":"left", "loc":"-103 52.75", "stroke":"#000000", "background":"coral"},
{"key":43, "parent":4, "text":"Checkpoints", "brush":"coral", "dir":"left", "loc":"-103 78.75", "stroke":"#000000", "background":"coral"}
 ]}'), (2, 'My Mindmap 2', '{ "class": "go.TreeModel",
  "nodeDataArray": [ 
{"key":0, "text":"Mind Map", "loc":"-6 -2", "font":" 12pt sans-serif", "stroke":"#ffffff", "background":"#dc2127", "brush":"#dc2127"},
{"key":2, "parent":0, "text":"More effective use", "brush":"#7ae7bf", "dir":"right", "loc":"92.7728474983079 -58.4864674970389", "stroke":"#000000", "background":"#7ae7bf", "font":" 12pt sans-serif"},
{"key":22, "parent":2, "text":"Goals", "brush":"#7ae7bf", "dir":"right", "loc":"251.73319499661585 -58.48646749703889", "stroke":"#000000", "background":"#7ae7bf", "font":" 12pt sans-serif"},
{"key":3, "parent":0, "text":"Time wasting", "brush":"#fbd75b", "dir":"left", "loc":"-25.999999999999986 10.924704999153967", "font":" 10pt sans-serif", "stroke":"#000000", "background":"#fbd75b"},
{"key":33, "parent":3, "text":"Message fatigue", "brush":"#fbd75b", "dir":"left", "loc":"-132.55008443678435 -4.5000000000000036", "background":"#fbd75b", "stroke":"#000000", "font":"bold 12pt sans-serif"},
{"text":"idea", "brush":"#fbd75b", "dir":"left", "parent":3, "key":-8, "loc":"-132.55008443678446 26.349409998307934", "stroke":"#000000", "background":"#fbd75b", "font":"bold 12pt sans-serif"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#dc2127", "brush":"#dc2127", "stroke":"#ffffff", "parent":0, "key":-10, "loc":"92.77284749830794 3.212352499576988", "dir":"right"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#7ae7bf", "brush":"#7ae7bf", "stroke":"#000000", "dir":"right", "parent":22, "key":-16, "loc":"322.0529174949238 -58.48646749703889"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#ff887c", "brush":"#ff887c", "stroke":"#dc2127", "parent":0, "key":-17, "loc":"92.77284749830794 80.33587749534688", "dir":"right"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#dc2127", "brush":"#dc2127", "stroke":"#ffffff", "dir":"right", "parent":-10, "key":-11, "loc":"151.54569499661577 -27.637057498730954"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#ff887c", "brush":"#ff887c", "stroke":"#dc2127", "dir":"right", "parent":-17, "key":-14, "loc":"151.54569499661574 64.91117249619289"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#ff887c", "brush":"#ff887c", "stroke":"#dc2127", "dir":"right", "parent":-17, "key":-15, "loc":"151.54569499661574 95.76058249450084"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#dc2127", "brush":"#dc2127", "stroke":"#ffffff", "dir":"right", "parent":-10, "key":-18, "loc":"151.54569499661588 3.2123524995769825"},
{"text":"idea", "font":" 12pt sans-serif", "background":"#dc2127", "brush":"#dc2127", "stroke":"#ffffff", "dir":"right", "parent":-10, "key":-19, "loc":"151.54569499661588 34.06176249788492"}
 ]}'), (3, 'My Mindmap 3', '{ "class": "go.TreeModel",
  "nodeDataArray": [ 
{"key":0, "text":"Mind Map", "brush":"black", "loc":"0 0", "stroke":"#000000", "background":"#FFFFFF"},
{"key":1, "parent":0, "text":"Getting more time", "brush":"skyblue", "dir":"right", "loc":"77 -22", "stroke":"#000000", "background":"#FFFFFF"},
{"key":2, "parent":0, "text":"More effective use", "brush":"darkseagreen", "dir":"right", "loc":"77 43", "stroke":"#000000", "background":"#FFFFFF"},
{"key":3, "parent":0, "text":"Time wasting", "brush":"palevioletred", "dir":"left", "loc":"-20 -31.75", "stroke":"#000000", "background":"#FFFFFF"},
{"key":4, "parent":0, "text":"Key issues", "brush":"coral", "dir":"left", "loc":"-20 52.75", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "font":" 8ptpt sans-serif", "brush":"darkseagreen", "dir":"right", "parent":2, "key":-6, "loc":"202.98046875000017 29.999999999999986", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "font":" 8ptpt sans-serif", "brush":"darkseagreen", "dir":"right", "parent":2, "key":-7, "loc":"202.98046875 56", "stroke":"#000000", "background":"#FFFFFF"}
 ]}'), (4, 'My Mindmap 4', '{ "class": "go.TreeModel",
  "nodeDataArray": [ 
{"key":0, "text":"Mind Map", "brush":"black", "loc":"0 0", "stroke":"#000000", "background":"#FFFFFF"},
{"key":1, "parent":0, "text":"Getting more time", "brush":"skyblue", "dir":"right", "loc":"85.60097249830793 -2.4999999999999822", "stroke":"#000000", "background":"#FFFFFF"},
{"key":2, "parent":0, "text":"More effective use", "brush":"darkseagreen", "dir":"left", "loc":"-20.00000000000003 -16.76142374915395", "stroke":"#000000", "background":"#FFFFFF"},
{"key":3, "parent":0, "text":"Time wasting", "brush":"palevioletred", "dir":"left", "loc":"-19.999999999999986 11.761423749153975", "stroke":"#000000", "background":"#FFFFFF"},
{"key":4, "parent":0, "text":"Key issues", "brush":"coral", "dir":"left", "loc":"-20.000000000000014 40.2842712474619", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "brush":"skyblue", "dir":"right", "parent":1, "key":-6, "loc":"217.43827312161594 -31.02284749830789", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "dir":"right", "parent":0, "key":-7, "loc":"85.60097249830793 26.02284749830794", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "brush":"skyblue", "dir":"right", "parent":-6, "key":-8, "loc":"275.9611206199237 -31.022847498307947", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "brush":"skyblue", "dir":"right", "parent":1, "key":-9, "loc":"217.43827312161588 -2.4999999999999787", "stroke":"#000000", "background":"#FFFFFF"},
{"text":"idea", "brush":"skyblue", "dir":"right", "parent":1, "key":-10, "loc":"217.43827312161588 26.022847498307947", "stroke":"#000000", "background":"#FFFFFF"}
 ]}'), (5, 'My Mindmap 5', '{ "class": "go.TreeModel",
  "nodeDataArray": [ 
{"key":0, "text":"Mind Map", "brush":"black", "loc":"0 0", "stroke":"#ffffff", "background":"#000000", "font":" 8pt sans-serif"},
{"key":1, "parent":0, "text":"Getting more time", "brush":"skyblue", "dir":"right", "loc":"89.06453125000004 -2.657910156249997", "stroke":"#000000", "background":"skyblue"},
{"key":2, "parent":0, "text":"More effective use", "brush":"darkseagreen", "dir":"right", "loc":"89.06453125000004 26.807910156250024", "stroke":"#000000", "background":"darkseagreen"},
{"key":3, "parent":0, "text":"Time wasting", "brush":"palevioletred", "dir":"left", "loc":"-20 -0.924999999999983", "stroke":"#000000", "background":"palevioletred"},
{"key":4, "parent":0, "text":"Key issues", "brush":"coral", "dir":"left", "loc":"-20 25.07499999999999", "stroke":"#000000", "background":"coral"},
{"text":"idea", "brush":"skyblue", "dir":"right", "parent":1, "key":-6, "loc":"212.37898437500013 -15.657910156249997", "stroke":"#000000", "background":"skyblue"},
{"text":"idea 2", "brush":"skyblue", "dir":"right", "parent":1, "key":-7, "loc":"212.37898437500013 10.342089843750003", "stroke":"#000000", "background":"skyblue"}
 ]}');

-- ----------------------------
-- Table structure for new_calendar
-- ----------------------------
CREATE TABLE `new_calendar` (
`id`  int(11) PRIMARY KEY AUTO_INCREMENT,
`title`  varchar(300) NOT NULL,
`description`  text,
`start_date`  date NOT NULL,
`start_time`  time,
`end_date`  date,
`end_time`  time,
`recurrence`  varchar(1),
`period`  varchar(1),
`category`  int(11),
`id_api`  varchar(255),
`id_event_google`  varchar(255),
`recur_info`  varchar(255),
`event_color`  varchar(255),
`creator`  varchar(255),
`reminder`  varchar(255)
);

-- ----------------------------
-- Records of new_calendar
-- ----------------------------
-- ----------------------------
-- Records of new_calendar
-- ----------------------------
INSERT INTO `new_calendar` VALUES 
(4398, 'Training', 'Time to body build!', '2017-09-06', null, '2017-09-07', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '31om4jfrge1e5r0ogscc9d446d_20170906', '', '#a4bdfc', '', ''), 
(4399, 'Training', 'Time to body build!', '2017-09-12', null, '2017-09-13', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '31om4jfrge1e5r0ogscc9d446d_20170912', '', '#a4bdfc', '', ''), 
(4400, 'Training', 'Time to body build!', '2017-09-24', null, '2017-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20170924', '', '#a4bdfc', '', ''), 
(4401, 'Training', 'Time to body build!', '2017-10-24', null, '2017-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20171024', '', '#a4bdfc', '', ''), 
(4402, 'Training', 'Time to body build!', '2017-11-24', null, '2017-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20171124', '', '#a4bdfc', '', ''), 
(4403, 'Training', 'Time to body build!', '2017-12-24', null, '2017-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20171224', '', '#a4bdfc', '', ''), 
(4404, 'Training', 'Time to body build!', '2018-01-24', null, '2018-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180124', '', '#a4bdfc', '', ''), 
(4405, 'Training', 'Time to body build!', '2018-02-24', null, '2018-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180224', '', '#a4bdfc', '', ''), 
(4406, 'Training', 'Time to body build!', '2018-03-24', null, '2018-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180324', '', '#a4bdfc', '', ''), 
(4407, 'Training', 'Time to body build!', '2018-04-24', null, '2018-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180424', '', '#a4bdfc', '', ''), 
(4408, 'Training', 'Time to body build!', '2018-05-24', null, '2018-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180524', '', '#a4bdfc', '', ''), 
(4409, 'Training', 'Time to body build!', '2018-06-24', null, '2018-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180624', '', '#a4bdfc', '', ''), 
(4410, 'Training', 'Time to body build!', '2018-07-24', null, '2018-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180724', '', '#a4bdfc', '', ''), 
(4411, 'Training', 'Time to body build!', '2018-08-24', null, '2018-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180824', '', '#a4bdfc', '', ''), 
(4412, 'Training', 'Time to body build!', '2018-09-24', null, '2018-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20180924', '', '#a4bdfc', '', ''), 
(4413, 'Training', 'Time to body build!', '2018-10-24', null, '2018-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20181024', '', '#a4bdfc', '', ''), 
(4414, 'Training', 'Time to body build!', '2018-11-24', null, '2018-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20181124', '', '#a4bdfc', '', ''), 
(4415, 'Training', 'Time to body build!', '2018-12-24', null, '2018-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20181224', '', '#a4bdfc', '', ''), 
(4416, 'Training', 'Time to body build!', '2019-01-24', null, '2019-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190124', '', '#a4bdfc', '', ''), 
(4417, 'Training', 'Time to body build!', '2019-02-24', null, '2019-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190224', '', '#a4bdfc', '', ''), 
(4418, 'Training', 'Time to body build!', '2019-03-24', null, '2019-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190324', '', '#a4bdfc', '', ''), 
(4419, 'Training', 'Time to body build!', '2019-04-24', null, '2019-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190424', '', '#a4bdfc', '', ''), 
(4420, 'Training', 'Time to body build!', '2019-05-24', null, '2019-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190524', '', '#a4bdfc', '', ''), 
(4421, 'Training', 'Time to body build!', '2019-06-24', null, '2019-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190624', '', '#a4bdfc', '', ''), 
(4422, 'Training', 'Time to body build!', '2019-07-24', null, '2019-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190724', '', '#a4bdfc', '', ''), 
(4423, 'Training', 'Time to body build!', '2019-08-24', null, '2019-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190824', '', '#a4bdfc', '', ''), 
(4424, 'Training', 'Time to body build!', '2019-09-24', null, '2019-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20190924', '', '#a4bdfc', '', ''), 
(4425, 'Training', 'Time to body build!', '2019-10-24', null, '2019-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20191024', '', '#a4bdfc', '', ''), 
(4426, 'Training', 'Time to body build!', '2019-11-24', null, '2019-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20191124', '', '#a4bdfc', '', ''), 
(4427, 'Training', 'Time to body build!', '2019-12-24', null, '2019-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20191224', '', '#a4bdfc', '', ''), 
(4428, 'Training', 'Time to body build!', '2020-01-24', null, '2020-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200124', '', '#a4bdfc', '', ''), 
(4429, 'Training', 'Time to body build!', '2020-02-24', null, '2020-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200224', '', '#a4bdfc', '', ''), 
(4430, 'Training', 'Time to body build!', '2020-03-24', null, '2020-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200324', '', '#a4bdfc', '', ''), 
(4431, 'Training', 'Time to body build!', '2020-04-24', null, '2020-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200424', '', '#a4bdfc', '', ''), 
(4432, 'Training', 'Time to body build!', '2020-05-24', null, '2020-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200524', '', '#a4bdfc', '', ''), 
(4433, 'Training', 'Time to body build!', '2020-06-24', null, '2020-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200624', '', '#a4bdfc', '', ''), 
(4434, 'Training', 'Time to body build!', '2020-07-24', null, '2020-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200724', '', '#a4bdfc', '', ''), 
(4435, 'Training', 'Time to body build!', '2020-08-24', null, '2020-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200824', '', '#a4bdfc', '', ''), 
(4436, 'Training', 'Time to body build!', '2020-09-24', null, '2020-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20200924', '', '#a4bdfc', '', ''), 
(4437, 'Training', 'Time to body build!', '2020-10-24', null, '2020-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20201024', '', '#a4bdfc', '', ''), 
(4438, 'Training', 'Time to body build!', '2020-11-24', null, '2020-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20201124', '', '#a4bdfc', '', ''), 
(4439, 'Training', 'Time to body build!', '2020-12-24', null, '2020-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20201224', '', '#a4bdfc', '', ''), 
(4440, 'Training', 'Time to body build!', '2021-01-24', null, '2021-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210124', '', '#a4bdfc', '', ''), 
(4441, 'Training', 'Time to body build!', '2021-02-24', null, '2021-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210224', '', '#a4bdfc', '', ''), 
(4442, 'Training', 'Time to body build!', '2021-03-24', null, '2021-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210324', '', '#a4bdfc', '', ''), 
(4443, 'Training', 'Time to body build!', '2021-04-24', null, '2021-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210424', '', '#a4bdfc', '', ''), 
(4444, 'Training', 'Time to body build!', '2021-05-24', null, '2021-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210524', '', '#a4bdfc', '', ''), 
(4445, 'Training', 'Time to body build!', '2021-06-24', null, '2021-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210624', '', '#a4bdfc', '', ''), 
(4446, 'Training', 'Time to body build!', '2021-07-24', null, '2021-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210724', '', '#a4bdfc', '', ''), 
(4447, 'Training', 'Time to body build!', '2021-08-24', null, '2021-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210824', '', '#a4bdfc', '', ''), 
(4448, 'Training', 'Time to body build!', '2021-09-24', null, '2021-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20210924', '', '#a4bdfc', '', ''), 
(4449, 'Training', 'Time to body build!', '2021-10-24', null, '2021-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20211024', '', '#a4bdfc', '', ''), 
(4450, 'Training', 'Time to body build!', '2021-11-24', null, '2021-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20211124', '', '#a4bdfc', '', ''), 
(4451, 'Training', 'Time to body build!', '2021-12-24', null, '2021-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20211224', '', '#a4bdfc', '', ''), 
(4452, 'Training', 'Time to body build!', '2022-01-24', null, '2022-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220124', '', '#a4bdfc', '', ''), 
(4453, 'Training', 'Time to body build!', '2022-02-24', null, '2022-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220224', '', '#a4bdfc', '', ''), 
(4454, 'Training', 'Time to body build!', '2022-03-24', null, '2022-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220324', '', '#a4bdfc', '', ''), 
(4455, 'Training', 'Time to body build!', '2022-04-24', null, '2022-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220424', '', '#a4bdfc', '', ''), 
(4456, 'Training', 'Time to body build!', '2022-05-24', null, '2022-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220524', '', '#a4bdfc', '', ''), 
(4457, 'Training', 'Time to body build!', '2022-06-24', null, '2022-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220624', '', '#a4bdfc', '', ''), 
(4458, 'Training', 'Time to body build!', '2022-07-24', null, '2022-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220724', '', '#a4bdfc', '', ''), 
(4459, 'Training', 'Time to body build!', '2022-08-24', null, '2022-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220824', '', '#a4bdfc', '', ''), 
(4460, 'Training', 'Time to body build!', '2022-09-24', null, '2022-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20220924', '', '#a4bdfc', '', ''), 
(4461, 'Training', 'Time to body build!', '2022-10-24', null, '2022-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20221024', '', '#a4bdfc', '', ''), 
(4462, 'Training', 'Time to body build!', '2022-11-24', null, '2022-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20221124', '', '#a4bdfc', '', ''), 
(4463, 'Training', 'Time to body build!', '2022-12-24', null, '2022-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20221224', '', '#a4bdfc', '', ''), 
(4464, 'Training', 'Time to body build!', '2023-01-24', null, '2023-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230124', '', '#a4bdfc', '', ''), 
(4465, 'Training', 'Time to body build!', '2023-02-24', null, '2023-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230224', '', '#a4bdfc', '', ''), 
(4466, 'Training', 'Time to body build!', '2023-03-24', null, '2023-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230324', '', '#a4bdfc', '', ''), 
(4467, 'Training', 'Time to body build!', '2023-04-24', null, '2023-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230424', '', '#a4bdfc', '', ''), 
(4468, 'Training', 'Time to body build!', '2023-05-24', null, '2023-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230524', '', '#a4bdfc', '', ''), 
(4469, 'Training', 'Time to body build!', '2023-06-24', null, '2023-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230624', '', '#a4bdfc', '', ''), 
(4470, 'Training', 'Time to body build!', '2023-07-24', null, '2023-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230724', '', '#a4bdfc', '', ''), 
(4471, 'Training', 'Time to body build!', '2023-08-24', null, '2023-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230824', '', '#a4bdfc', '', ''), 
(4472, 'Training', 'Time to body build!', '2023-09-24', null, '2023-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20230924', '', '#a4bdfc', '', ''), 
(4473, 'Training', 'Time to body build!', '2023-10-24', null, '2023-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20231024', '', '#a4bdfc', '', ''), 
(4474, 'Training', 'Time to body build!', '2023-11-24', null, '2023-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20231124', '', '#a4bdfc', '', ''), 
(4475, 'Training', 'Time to body build!', '2023-12-24', null, '2023-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20231224', '', '#a4bdfc', '', ''), 
(4476, 'Training', 'Time to body build!', '2024-01-24', null, '2024-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240124', '', '#a4bdfc', '', ''), 
(4477, 'Training', 'Time to body build!', '2024-02-24', null, '2024-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240224', '', '#a4bdfc', '', '');

INSERT INTO `new_calendar` VALUES 
(4478, 'Training', 'Time to body build!', '2024-03-24', null, '2024-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240324', '', '#a4bdfc', '', ''), 
(4479, 'Training', 'Time to body build!', '2024-04-24', null, '2024-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240424', '', '#a4bdfc', '', ''), 
(4480, 'Training', 'Time to body build!', '2024-05-24', null, '2024-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240524', '', '#a4bdfc', '', ''), 
(4481, 'Training', 'Time to body build!', '2024-06-24', null, '2024-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240624', '', '#a4bdfc', '', ''), 
(4482, 'Training', 'Time to body build!', '2024-07-24', null, '2024-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240724', '', '#a4bdfc', '', ''), 
(4483, 'Training', 'Time to body build!', '2024-08-24', null, '2024-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240824', '', '#a4bdfc', '', ''), 
(4484, 'Training', 'Time to body build!', '2024-09-24', null, '2024-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20240924', '', '#a4bdfc', '', ''), 
(4485, 'Training', 'Time to body build!', '2024-10-24', null, '2024-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20241024', '', '#a4bdfc', '', ''), 
(4486, 'Training', 'Time to body build!', '2024-11-24', null, '2024-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20241124', '', '#a4bdfc', '', ''), 
(4487, 'Training', 'Time to body build!', '2024-12-24', null, '2024-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20241224', '', '#a4bdfc', '', ''), 
(4488, 'Training', 'Time to body build!', '2025-01-24', null, '2025-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250124', '', '#a4bdfc', '', ''), 
(4489, 'Training', 'Time to body build!', '2025-02-24', null, '2025-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250224', '', '#a4bdfc', '', ''), 
(4490, 'Training', 'Time to body build!', '2025-03-24', null, '2025-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250324', '', '#a4bdfc', '', ''), 
(4491, 'Training', 'Time to body build!', '2025-04-24', null, '2025-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250424', '', '#a4bdfc', '', ''), 
(4492, 'Training', 'Time to body build!', '2025-05-24', null, '2025-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250524', '', '#a4bdfc', '', ''), 
(4493, 'Training', 'Time to body build!', '2025-06-24', null, '2025-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250624', '', '#a4bdfc', '', ''), 
(4494, 'Training', 'Time to body build!', '2025-07-24', null, '2025-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250724', '', '#a4bdfc', '', ''), 
(4495, 'Training', 'Time to body build!', '2025-08-24', null, '2025-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250824', '', '#a4bdfc', '', ''), 
(4496, 'Training', 'Time to body build!', '2025-09-24', null, '2025-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20250924', '', '#a4bdfc', '', ''), 
(4497, 'Training', 'Time to body build!', '2025-10-24', null, '2025-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20251024', '', '#a4bdfc', '', ''), 
(4498, 'Training', 'Time to body build!', '2025-11-24', null, '2025-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20251124', '', '#a4bdfc', '', ''), 
(4499, 'Training', 'Time to body build!', '2025-12-24', null, '2025-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20251224', '', '#a4bdfc', '', ''), 
(4500, 'Training', 'Time to body build!', '2026-01-24', null, '2026-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260124', '', '#a4bdfc', '', ''), 
(4501, 'Training', 'Time to body build!', '2026-02-24', null, '2026-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260224', '', '#a4bdfc', '', ''), 
(4502, 'Training', 'Time to body build!', '2026-03-24', null, '2026-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260324', '', '#a4bdfc', '', ''), 
(4503, 'Training', 'Time to body build!', '2026-04-24', null, '2026-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260424', '', '#a4bdfc', '', ''), 
(4504, 'Training', 'Time to body build!', '2026-05-24', null, '2026-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260524', '', '#a4bdfc', '', ''), 
(4505, 'Training', 'Time to body build!', '2026-06-24', null, '2026-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260624', '', '#a4bdfc', '', ''), 
(4506, 'Training', 'Time to body build!', '2026-07-24', null, '2026-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260724', '', '#a4bdfc', '', ''), 
(4507, 'Training', 'Time to body build!', '2026-08-24', null, '2026-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260824', '', '#a4bdfc', '', ''), 
(4508, 'Training', 'Time to body build!', '2026-09-24', null, '2026-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20260924', '', '#a4bdfc', '', ''), 
(4509, 'Training', 'Time to body build!', '2026-10-24', null, '2026-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20261024', '', '#a4bdfc', '', ''), 
(4510, 'Training', 'Time to body build!', '2026-11-24', null, '2026-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20261124', '', '#a4bdfc', '', ''), 
(4511, 'Training', 'Time to body build!', '2026-12-24', null, '2026-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20261224', '', '#a4bdfc', '', ''), 
(4512, 'Training', 'Time to body build!', '2027-01-24', null, '2027-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270124', '', '#a4bdfc', '', ''), 
(4513, 'Training', 'Time to body build!', '2027-02-24', null, '2027-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270224', '', '#a4bdfc', '', ''), 
(4514, 'Training', 'Time to body build!', '2027-03-24', null, '2027-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270324', '', '#a4bdfc', '', ''), 
(4515, 'Training', 'Time to body build!', '2027-04-24', null, '2027-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270424', '', '#a4bdfc', '', ''), 
(4516, 'Training', 'Time to body build!', '2027-05-24', null, '2027-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270524', '', '#a4bdfc', '', ''), 
(4517, 'Training', 'Time to body build!', '2027-06-24', null, '2027-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270624', '', '#a4bdfc', '', ''), 
(4518, 'Training', 'Time to body build!', '2027-07-24', null, '2027-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270724', '', '#a4bdfc', '', ''), 
(4519, 'Training', 'Time to body build!', '2027-08-24', null, '2027-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270824', '', '#a4bdfc', '', ''), 
(4520, 'Training', 'Time to body build!', '2027-09-24', null, '2027-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20270924', '', '#a4bdfc', '', ''), 
(4521, 'Training', 'Time to body build!', '2027-10-24', null, '2027-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20271024', '', '#a4bdfc', '', ''), 
(4522, 'Training', 'Time to body build!', '2027-11-24', null, '2027-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20271124', '', '#a4bdfc', '', ''), 
(4523, 'Training', 'Time to body build!', '2027-12-24', null, '2027-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20271224', '', '#a4bdfc', '', ''), 
(4524, 'Training', 'Time to body build!', '2028-01-24', null, '2028-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280124', '', '#a4bdfc', '', ''), 
(4525, 'Training', 'Time to body build!', '2028-02-24', null, '2028-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280224', '', '#a4bdfc', '', ''), 
(4526, 'Training', 'Time to body build!', '2028-03-24', null, '2028-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280324', '', '#a4bdfc', '', ''), 
(4527, 'Training', 'Time to body build!', '2028-04-24', null, '2028-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280424', '', '#a4bdfc', '', ''), 
(4528, 'Training', 'Time to body build!', '2028-05-24', null, '2028-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280524', '', '#a4bdfc', '', ''), 
(4529, 'Training', 'Time to body build!', '2028-06-24', null, '2028-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280624', '', '#a4bdfc', '', ''), 
(4530, 'Training', 'Time to body build!', '2028-07-24', null, '2028-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280724', '', '#a4bdfc', '', ''), 
(4531, 'Training', 'Time to body build!', '2028-08-24', null, '2028-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280824', '', '#a4bdfc', '', ''), 
(4532, 'Training', 'Time to body build!', '2028-09-24', null, '2028-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20280924', '', '#a4bdfc', '', ''), 
(4533, 'Training', 'Time to body build!', '2028-10-24', null, '2028-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20281024', '', '#a4bdfc', '', ''), 
(4534, 'Training', 'Time to body build!', '2028-11-24', null, '2028-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20281124', '', '#a4bdfc', '', ''), 
(4535, 'Training', 'Time to body build!', '2028-12-24', null, '2028-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20281224', '', '#a4bdfc', '', ''), 
(4536, 'Training', 'Time to body build!', '2029-01-24', null, '2029-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290124', '', '#a4bdfc', '', ''), 
(4537, 'Training', 'Time to body build!', '2029-02-24', null, '2029-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290224', '', '#a4bdfc', '', ''), 
(4538, 'Training', 'Time to body build!', '2029-03-24', null, '2029-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290324', '', '#a4bdfc', '', ''), 
(4539, 'Training', 'Time to body build!', '2029-04-24', null, '2029-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290424', '', '#a4bdfc', '', ''), 
(4540, 'Training', 'Time to body build!', '2029-05-24', null, '2029-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290524', '', '#a4bdfc', '', ''), 
(4541, 'Training', 'Time to body build!', '2029-06-24', null, '2029-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290624', '', '#a4bdfc', '', ''), 
(4542, 'Training', 'Time to body build!', '2029-07-24', null, '2029-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290724', '', '#a4bdfc', '', ''), 
(4543, 'Training', 'Time to body build!', '2029-08-24', null, '2029-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290824', '', '#a4bdfc', '', ''), 
(4544, 'Training', 'Time to body build!', '2029-09-24', null, '2029-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20290924', '', '#a4bdfc', '', ''), 
(4545, 'Training', 'Time to body build!', '2029-10-24', null, '2029-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20291024', '', '#a4bdfc', '', ''), 
(4546, 'Training', 'Time to body build!', '2029-11-24', null, '2029-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20291124', '', '#a4bdfc', '', ''), 
(4547, 'Training', 'Time to body build!', '2029-12-24', null, '2029-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20291224', '', '#a4bdfc', '', ''), 
(4548, 'Training', 'Time to body build!', '2030-01-24', null, '2030-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300124', '', '#a4bdfc', '', ''), 
(4549, 'Training', 'Time to body build!', '2030-02-24', null, '2030-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300224', '', '#a4bdfc', '', ''), 
(4550, 'Training', 'Time to body build!', '2030-03-24', null, '2030-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300324', '', '#a4bdfc', '', ''), 
(4551, 'Training', 'Time to body build!', '2030-04-24', null, '2030-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300424', '', '#a4bdfc', '', ''), 
(4552, 'Training', 'Time to body build!', '2030-05-24', null, '2030-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300524', '', '#a4bdfc', '', ''), 
(4553, 'Training', 'Time to body build!', '2030-06-24', null, '2030-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300624', '', '#a4bdfc', '', ''), 
(4554, 'Training', 'Time to body build!', '2030-07-24', null, '2030-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300724', '', '#a4bdfc', '', ''), 
(4555, 'Training', 'Time to body build!', '2030-08-24', null, '2030-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300824', '', '#a4bdfc', '', ''), 
(4556, 'Training', 'Time to body build!', '2030-09-24', null, '2030-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20300924', '', '#a4bdfc', '', ''), 
(4557, 'Training', 'Time to body build!', '2030-10-24', null, '2030-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20301024', '', '#a4bdfc', '', ''), 
(4558, 'Training', 'Time to body build!', '2030-11-24', null, '2030-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20301124', '', '#a4bdfc', '', ''), 
(4559, 'Training', 'Time to body build!', '2030-12-24', null, '2030-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20301224', '', '#a4bdfc', '', ''), 
(4560, 'Training', 'Time to body build!', '2031-01-24', null, '2031-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310124', '', '#a4bdfc', '', ''), 
(4561, 'Training', 'Time to body build!', '2031-02-24', null, '2031-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310224', '', '#a4bdfc', '', ''), 
(4562, 'Training', 'Time to body build!', '2031-03-24', null, '2031-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310324', '', '#a4bdfc', '', ''), 
(4563, 'Training', 'Time to body build!', '2031-04-24', null, '2031-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310424', '', '#a4bdfc', '', ''), 
(4564, 'Training', 'Time to body build!', '2031-05-24', null, '2031-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310524', '', '#a4bdfc', '', ''), 
(4565, 'Training', 'Time to body build!', '2031-06-24', null, '2031-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310624', '', '#a4bdfc', '', ''), 
(4566, 'Training', 'Time to body build!', '2031-07-24', null, '2031-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310724', '', '#a4bdfc', '', ''), 
(4567, 'Training', 'Time to body build!', '2031-08-24', null, '2031-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310824', '', '#a4bdfc', '', ''), 
(4568, 'Training', 'Time to body build!', '2031-09-24', null, '2031-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20310924', '', '#a4bdfc', '', ''), 
(4569, 'Training', 'Time to body build!', '2031-10-24', null, '2031-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20311024', '', '#a4bdfc', '', ''), 
(4570, 'Training', 'Time to body build!', '2031-11-24', null, '2031-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20311124', '', '#a4bdfc', '', ''), 
(4571, 'Training', 'Time to body build!', '2031-12-24', null, '2031-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20311224', '', '#a4bdfc', '', ''), 
(4572, 'Training', 'Time to body build!', '2032-01-24', null, '2032-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320124', '', '#a4bdfc', '', ''), 
(4573, 'Training', 'Time to body build!', '2032-02-24', null, '2032-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320224', '', '#a4bdfc', '', ''), 
(4574, 'Training', 'Time to body build!', '2032-03-24', null, '2032-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320324', '', '#a4bdfc', '', ''), 
(4575, 'Training', 'Time to body build!', '2032-04-24', null, '2032-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320424', '', '#a4bdfc', '', ''), 
(4576, 'Training', 'Time to body build!', '2032-05-24', null, '2032-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320524', '', '#a4bdfc', '', ''), 
(4577, 'Training', 'Time to body build!', '2032-06-24', null, '2032-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320624', '', '#a4bdfc', '', ''), 
(4578, 'Training', 'Time to body build!', '2032-07-24', null, '2032-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320724', '', '#a4bdfc', '', '');

INSERT INTO `new_calendar` VALUES 
(4579, 'Training', 'Time to body build!', '2032-08-24', null, '2032-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320824', '', '#a4bdfc', '', ''), 
(4580, 'Training', 'Time to body build!', '2032-09-24', null, '2032-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20320924', '', '#a4bdfc', '', ''), 
(4581, 'Training', 'Time to body build!', '2032-10-24', null, '2032-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20321024', '', '#a4bdfc', '', ''), 
(4582, 'Training', 'Time to body build!', '2032-11-24', null, '2032-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20321124', '', '#a4bdfc', '', ''), 
(4583, 'Training', 'Time to body build!', '2032-12-24', null, '2032-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20321224', '', '#a4bdfc', '', ''), 
(4584, 'Training', 'Time to body build!', '2033-01-24', null, '2033-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330124', '', '#a4bdfc', '', ''), 
(4585, 'Training', 'Time to body build!', '2033-02-24', null, '2033-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330224', '', '#a4bdfc', '', ''), 
(4586, 'Training', 'Time to body build!', '2033-03-24', null, '2033-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330324', '', '#a4bdfc', '', ''), 
(4587, 'Training', 'Time to body build!', '2033-04-24', null, '2033-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330424', '', '#a4bdfc', '', ''), 
(4588, 'Training', 'Time to body build!', '2033-05-24', null, '2033-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330524', '', '#a4bdfc', '', ''), 
(4589, 'Training', 'Time to body build!', '2033-06-24', null, '2033-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330624', '', '#a4bdfc', '', ''), 
(4590, 'Training', 'Time to body build!', '2033-07-24', null, '2033-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330724', '', '#a4bdfc', '', ''), 
(4591, 'Training', 'Time to body build!', '2033-08-24', null, '2033-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330824', '', '#a4bdfc', '', ''), 
(4592, 'Training', 'Time to body build!', '2033-09-24', null, '2033-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20330924', '', '#a4bdfc', '', ''), 
(4593, 'Training', 'Time to body build!', '2033-10-24', null, '2033-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20331024', '', '#a4bdfc', '', ''), 
(4594, 'Training', 'Time to body build!', '2033-11-24', null, '2033-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20331124', '', '#a4bdfc', '', ''), 
(4595, 'Training', 'Time to body build!', '2033-12-24', null, '2033-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20331224', '', '#a4bdfc', '', ''), 
(4596, 'Training', 'Time to body build!', '2034-01-24', null, '2034-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340124', '', '#a4bdfc', '', ''), 
(4597, 'Training', 'Time to body build!', '2034-02-24', null, '2034-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340224', '', '#a4bdfc', '', ''), 
(4598, 'Training', 'Time to body build!', '2034-03-24', null, '2034-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340324', '', '#a4bdfc', '', ''), 
(4599, 'Training', 'Time to body build!', '2034-04-24', null, '2034-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340424', '', '#a4bdfc', '', ''), 
(4600, 'Training', 'Time to body build!', '2034-05-24', null, '2034-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340524', '', '#a4bdfc', '', ''), 
(4601, 'Training', 'Time to body build!', '2034-06-24', null, '2034-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340624', '', '#a4bdfc', '', ''), 
(4602, 'Training', 'Time to body build!', '2034-07-24', null, '2034-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340724', '', '#a4bdfc', '', ''), 
(4603, 'Training', 'Time to body build!', '2034-08-24', null, '2034-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340824', '', '#a4bdfc', '', ''), 
(4604, 'Training', 'Time to body build!', '2034-09-24', null, '2034-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20340924', '', '#a4bdfc', '', ''), 
(4605, 'Training', 'Time to body build!', '2034-10-24', null, '2034-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20341024', '', '#a4bdfc', '', ''), 
(4606, 'Training', 'Time to body build!', '2034-11-24', null, '2034-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20341124', '', '#a4bdfc', '', ''), 
(4607, 'Training', 'Time to body build!', '2034-12-24', null, '2034-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20341224', '', '#a4bdfc', '', ''), 
(4608, 'Training', 'Time to body build!', '2035-01-24', null, '2035-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350124', '', '#a4bdfc', '', ''), 
(4609, 'Training', 'Time to body build!', '2035-02-24', null, '2035-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350224', '', '#a4bdfc', '', ''), 
(4610, 'Training', 'Time to body build!', '2035-03-24', null, '2035-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350324', '', '#a4bdfc', '', ''), 
(4611, 'Training', 'Time to body build!', '2035-04-24', null, '2035-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350424', '', '#a4bdfc', '', ''), 
(4612, 'Training', 'Time to body build!', '2035-05-24', null, '2035-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350524', '', '#a4bdfc', '', ''), 
(4613, 'Training', 'Time to body build!', '2035-06-24', null, '2035-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350624', '', '#a4bdfc', '', ''), 
(4614, 'Training', 'Time to body build!', '2035-07-24', null, '2035-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350724', '', '#a4bdfc', '', ''), 
(4615, 'Training', 'Time to body build!', '2035-08-24', null, '2035-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350824', '', '#a4bdfc', '', ''), 
(4616, 'Training', 'Time to body build!', '2035-09-24', null, '2035-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20350924', '', '#a4bdfc', '', ''), 
(4617, 'Training', 'Time to body build!', '2035-10-24', null, '2035-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20351024', '', '#a4bdfc', '', ''), 
(4618, 'Training', 'Time to body build!', '2035-11-24', null, '2035-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20351124', '', '#a4bdfc', '', ''), 
(4619, 'Training', 'Time to body build!', '2035-12-24', null, '2035-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20351224', '', '#a4bdfc', '', ''), 
(4620, 'Training', 'Time to body build!', '2036-01-24', null, '2036-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360124', '', '#a4bdfc', '', ''), 
(4621, 'Training', 'Time to body build!', '2036-02-24', null, '2036-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360224', '', '#a4bdfc', '', ''), 
(4622, 'Training', 'Time to body build!', '2036-03-24', null, '2036-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360324', '', '#a4bdfc', '', ''), 
(4623, 'Training', 'Time to body build!', '2036-04-24', null, '2036-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360424', '', '#a4bdfc', '', ''), 
(4624, 'Training', 'Time to body build!', '2036-05-24', null, '2036-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360524', '', '#a4bdfc', '', ''), 
(4625, 'Training', 'Time to body build!', '2036-06-24', null, '2036-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360624', '', '#a4bdfc', '', ''), 
(4626, 'Training', 'Time to body build!', '2036-07-24', null, '2036-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360724', '', '#a4bdfc', '', ''), 
(4627, 'Training', 'Time to body build!', '2036-08-24', null, '2036-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360824', '', '#a4bdfc', '', ''), 
(4628, 'Training', 'Time to body build!', '2036-09-24', null, '2036-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20360924', '', '#a4bdfc', '', ''), 
(4629, 'Training', 'Time to body build!', '2036-10-24', null, '2036-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20361024', '', '#a4bdfc', '', ''), 
(4630, 'Training', 'Time to body build!', '2036-11-24', null, '2036-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20361124', '', '#a4bdfc', '', ''), 
(4631, 'Training', 'Time to body build!', '2036-12-24', null, '2036-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20361224', '', '#a4bdfc', '', ''), 
(4632, 'Training', 'Time to body build!', '2037-01-24', null, '2037-01-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370124', '', '#a4bdfc', '', ''), 
(4633, 'Training', 'Time to body build!', '2037-02-24', null, '2037-02-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370224', '', '#a4bdfc', '', ''), 
(4634, 'Training', 'Time to body build!', '2037-03-24', null, '2037-03-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370324', '', '#a4bdfc', '', ''), 
(4635, 'Training', 'Time to body build!', '2037-04-24', null, '2037-04-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370424', '', '#a4bdfc', '', ''), 
(4636, 'Training', 'Time to body build!', '2037-05-24', null, '2037-05-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370524', '', '#a4bdfc', '', ''), 
(4637, 'Training', 'Time to body build!', '2037-06-24', null, '2037-06-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370624', '', '#a4bdfc', '', ''), 
(4638, 'Training', 'Time to body build!', '2037-07-24', null, '2037-07-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370724', '', '#a4bdfc', '', ''), 
(4639, 'Training', 'Time to body build!', '2037-08-24', null, '2037-08-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370824', '', '#a4bdfc', '', ''), 
(4640, 'Training', 'Time to body build!', '2037-09-24', null, '2037-09-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20370924', '', '#a4bdfc', '', ''), 
(4641, 'Training', 'Time to body build!', '2037-10-24', null, '2037-10-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20371024', '', '#a4bdfc', '', ''), 
(4642, 'Training', 'Time to body build!', '2037-11-24', null, '2037-11-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20371124', '', '#a4bdfc', '', ''), 
(4643, 'Training', 'Time to body build!', '2037-12-24', null, '2037-12-25', null, '', '', 0, '03unknuv0jdggdc7us9v8nchsg@group.calendar.google.com', '5caq3kd909ue2vgcbvppjd7g2o_20371224', '', '#a4bdfc', '', ''), 
(9759, 'Yellow day', 'Are you ready?', '2017-08-28', null, '2017-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20170828', '', '#fbd75b', '', ''), 
(9760, 'Day 1', 'Starting activities..', '2017-09-01', '10:00:00', '2017-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20170901T130000Z', '', '#ff887c', '', ''), 
(9761, 'Hobbie time', 'shhhh...It''s a secret!', '2017-09-11', null, '2017-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20170911', '', '#7ae7bf', '', ''), 
(9762, 'Resting...', 'I''m...nevermind', '2017-09-16', null, '2017-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20170916', '', '#e1e1e1', '', ''), 
(9763, 'Work time', 'Let''s job! :)', '2017-09-27', '08:00:00', '2017-09-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20170927T110000Z', '', '#dbadff', '', ''), 
(9764, 'Yellow day', 'Are you ready?', '2017-09-28', null, '2017-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20170928', '', '#fbd75b', '', ''), 
(9765, 'Work time', 'Let''s job! :)', '2017-09-28', '08:00:00', '2017-09-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20170928T110000Z', '', '#dbadff', '', ''), 
(9766, 'Day 1', 'Starting activities..', '2017-10-01', '10:00:00', '2017-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20171001T130000Z', '', '#ff887c', '', ''), 
(9767, 'Work time', 'Let''s job! :)', '2017-10-02', '08:00:00', '2017-10-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171002T110000Z', '', '#dbadff', '', ''), 
(9768, 'Work time', 'Let''s job! :)', '2017-10-05', '08:00:00', '2017-10-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171005T110000Z', '', '#dbadff', '', ''), 
(9769, 'Work time', 'Let''s job! :)', '2017-10-09', '08:00:00', '2017-10-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171009T110000Z', '', '#dbadff', '', ''), 
(9770, 'Hobbie time', 'shhhh...It''s a secret!', '2017-10-11', null, '2017-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20171011', '', '#7ae7bf', '', ''), 
(9771, 'Work time', 'Let''s job! :)', '2017-10-11', '08:00:00', '2017-10-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171011T110000Z', '', '#dbadff', '', ''), 
(9772, 'Work time', 'Let''s job! :)', '2017-10-12', '08:00:00', '2017-10-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171012T110000Z', '', '#dbadff', '', ''), 
(9773, 'Resting...', 'I''m...nevermind', '2017-10-16', null, '2017-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20171016', '', '#e1e1e1', '', ''), 
(9774, 'Work time', 'Let''s job! :)', '2017-10-16', '08:00:00', '2017-10-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171016T110000Z', '', '#dbadff', '', ''), 
(9775, 'Work time', '', '2017-10-18', '08:00:00', '2017-10-18', '12:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171018T110000Z', '', '#dbadff', '', ''), 
(9776, 'Work time', 'Let''s job! :)', '2017-10-19', '08:00:00', '2017-10-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171019T110000Z', '', '#dbadff', '', ''), 
(9777, 'Work time', 'Let''s job! :)', '2017-10-23', '08:00:00', '2017-10-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171023T110000Z', '', '#dbadff', '', ''), 
(9778, 'Work time', 'Let''s job! :)', '2017-10-25', '08:00:00', '2017-10-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171025T110000Z', '', '#dbadff', '', ''), 
(9779, 'Work time', 'Let''s job! :)', '2017-10-26', '08:00:00', '2017-10-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171026T110000Z', '', '#dbadff', '', ''), 
(9780, 'Yellow day', 'Are you ready?', '2017-10-28', null, '2017-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20171028', '', '#fbd75b', '', ''), 
(9781, 'Work time', 'Let''s job! :)', '2017-10-30', '08:00:00', '2017-10-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171030T110000Z', '', '#dbadff', '', ''), 
(9782, 'Work time', 'Let''s job! :)', '2017-11-01', '08:00:00', '2017-11-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171101T110000Z', '', '#dbadff', '', ''), 
(9783, 'Day 1', 'Starting activities..', '2017-11-01', '10:00:00', '2017-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20171101T130000Z', '', '#ff887c', '', ''), 
(9784, 'Work time', 'Let''s job! :)', '2017-11-02', '08:00:00', '2017-11-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171102T110000Z', '', '#dbadff', '', ''), 
(9785, 'Work time', 'Let''s job! :)', '2017-11-06', '08:00:00', '2017-11-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171106T110000Z', '', '#dbadff', '', ''), 
(9786, 'Work time', 'Let''s job! :)', '2017-11-08', '08:00:00', '2017-11-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171108T110000Z', '', '#dbadff', '', ''), 
(9787, 'Work time', 'Let''s job! :)', '2017-11-09', '08:00:00', '2017-11-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171109T110000Z', '', '#dbadff', '', ''), 
(9788, 'Hobbie time', 'shhhh...It''s a secret!', '2017-11-11', null, '2017-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20171111', '', '#7ae7bf', '', ''), 
(9789, 'Work time', 'Let''s job! :)', '2017-11-13', '08:00:00', '2017-11-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171113T110000Z', '', '#dbadff', '', ''), 
(9790, 'Work time', 'Let''s job! :)', '2017-11-15', '08:00:00', '2017-11-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171115T110000Z', '', '#dbadff', '', ''), 
(9791, 'Resting...', 'I''m...nevermind', '2017-11-16', null, '2017-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20171116', '', '#e1e1e1', '', ''), 
(9792, 'Work time', 'Let''s job! :)', '2017-11-16', '08:00:00', '2017-11-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171116T110000Z', '', '#dbadff', '', ''), 
(9793, 'Work time', 'Let''s job! :)', '2017-11-20', '08:00:00', '2017-11-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171120T110000Z', '', '#dbadff', '', '');

INSERT INTO `new_calendar` VALUES 
(9794, 'Work time', 'Let''s job! :)', '2017-11-22', '08:00:00', '2017-11-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171122T110000Z', '', '#dbadff', '', ''), 
(9795, 'Work time', 'Let''s job! :)', '2017-11-23', '08:00:00', '2017-11-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171123T110000Z', '', '#dbadff', '', ''), 
(9796, 'Work time', 'Let''s job! :)', '2017-11-27', '08:00:00', '2017-11-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171127T110000Z', '', '#dbadff', '', ''), 
(9797, 'Yellow day', 'Are you ready?', '2017-11-28', null, '2017-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20171128', '', '#fbd75b', '', ''), 
(9798, 'Work time', 'Let''s job! :)', '2017-11-29', '08:00:00', '2017-11-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171129T110000Z', '', '#dbadff', '', ''), 
(9799, 'Work time', 'Let''s job! :)', '2017-11-30', '08:00:00', '2017-11-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171130T110000Z', '', '#dbadff', '', ''), 
(9800, 'Day 1', 'Starting activities..', '2017-12-01', '10:00:00', '2017-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20171201T130000Z', '', '#ff887c', '', ''), 
(9801, 'Work time', 'Let''s job! :)', '2017-12-04', '08:00:00', '2017-12-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171204T110000Z', '', '#dbadff', '', ''), 
(9802, 'Work time', 'Let''s job! :)', '2017-12-06', '08:00:00', '2017-12-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171206T110000Z', '', '#dbadff', '', ''), 
(9803, 'Work time', 'Let''s job! :)', '2017-12-07', '08:00:00', '2017-12-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171207T110000Z', '', '#dbadff', '', ''), 
(9804, 'Hobbie time', 'shhhh...It''s a secret!', '2017-12-11', null, '2017-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20171211', '', '#7ae7bf', '', ''), 
(9805, 'Work time', 'Let''s job! :)', '2017-12-11', '08:00:00', '2017-12-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171211T110000Z', '', '#dbadff', '', ''), 
(9806, 'Work time', 'Let''s job! :)', '2017-12-13', '08:00:00', '2017-12-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171213T110000Z', '', '#dbadff', '', ''), 
(9807, 'Work time', 'Let''s job! :)', '2017-12-14', '08:00:00', '2017-12-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171214T110000Z', '', '#dbadff', '', ''), 
(9808, 'Resting...', 'I''m...nevermind', '2017-12-16', null, '2017-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20171216', '', '#e1e1e1', '', ''), 
(9809, 'Work time', 'Let''s job! :)', '2017-12-18', '08:00:00', '2017-12-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171218T110000Z', '', '#dbadff', '', ''), 
(9810, 'Work time', 'Let''s job! :)', '2017-12-20', '08:00:00', '2017-12-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171220T110000Z', '', '#dbadff', '', ''), 
(9811, 'Work time', 'Let''s job! :)', '2017-12-21', '08:00:00', '2017-12-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171221T110000Z', '', '#dbadff', '', ''), 
(9812, 'Work time', 'Let''s job! :)', '2017-12-25', '08:00:00', '2017-12-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171225T110000Z', '', '#dbadff', '', ''), 
(9813, 'Work time', 'Let''s job! :)', '2017-12-27', '08:00:00', '2017-12-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171227T110000Z', '', '#dbadff', '', ''), 
(9814, 'Yellow day', 'Are you ready?', '2017-12-28', null, '2017-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20171228', '', '#fbd75b', '', ''), 
(9815, 'Work time', 'Let''s job! :)', '2017-12-28', '08:00:00', '2017-12-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20171228T110000Z', '', '#dbadff', '', ''), 
(9816, 'Work time', 'Let''s job! :)', '2018-01-01', '08:00:00', '2018-01-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180101T110000Z', '', '#dbadff', '', ''), 
(9817, 'Day 1', 'Starting activities..', '2018-01-01', '10:00:00', '2018-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180101T130000Z', '', '#ff887c', '', ''), 
(9818, 'Work time', 'Let''s job! :)', '2018-01-03', '08:00:00', '2018-01-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180103T110000Z', '', '#dbadff', '', ''), 
(9819, 'Work time', 'Let''s job! :)', '2018-01-04', '08:00:00', '2018-01-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180104T110000Z', '', '#dbadff', '', ''), 
(9820, 'Work time', 'Let''s job! :)', '2018-01-08', '08:00:00', '2018-01-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180108T110000Z', '', '#dbadff', '', ''), 
(9821, 'Work time', 'Let''s job! :)', '2018-01-10', '08:00:00', '2018-01-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180110T110000Z', '', '#dbadff', '', ''), 
(9822, 'Hobbie time', 'shhhh...It''s a secret!', '2018-01-11', null, '2018-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180111', '', '#7ae7bf', '', ''), 
(9823, 'Work time', 'Let''s job! :)', '2018-01-11', '08:00:00', '2018-01-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180111T110000Z', '', '#dbadff', '', ''), 
(9824, 'Work time', 'Let''s job! :)', '2018-01-15', '08:00:00', '2018-01-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180115T110000Z', '', '#dbadff', '', ''), 
(9825, 'Resting...', 'I''m...nevermind', '2018-01-16', null, '2018-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180116', '', '#e1e1e1', '', ''), 
(9826, 'Work time', 'Let''s job! :)', '2018-01-17', '08:00:00', '2018-01-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180117T110000Z', '', '#dbadff', '', ''), 
(9827, 'Work time', 'Let''s job! :)', '2018-01-18', '08:00:00', '2018-01-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180118T110000Z', '', '#dbadff', '', ''), 
(9828, 'Work time', 'Let''s job! :)', '2018-01-22', '08:00:00', '2018-01-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180122T110000Z', '', '#dbadff', '', ''), 
(9829, 'Work time', 'Let''s job! :)', '2018-01-24', '08:00:00', '2018-01-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180124T110000Z', '', '#dbadff', '', ''), 
(9830, 'Work time', 'Let''s job! :)', '2018-01-25', '08:00:00', '2018-01-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180125T110000Z', '', '#dbadff', '', ''), 
(9831, 'Yellow day', 'Are you ready?', '2018-01-28', null, '2018-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180128', '', '#fbd75b', '', ''), 
(9832, 'Work time', 'Let''s job! :)', '2018-01-29', '08:00:00', '2018-01-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180129T110000Z', '', '#dbadff', '', ''), 
(9833, 'Work time', 'Let''s job! :)', '2018-01-31', '08:00:00', '2018-01-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180131T110000Z', '', '#dbadff', '', ''), 
(9834, 'Work time', 'Let''s job! :)', '2018-02-01', '08:00:00', '2018-02-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180201T110000Z', '', '#dbadff', '', ''), 
(9835, 'Day 1', 'Starting activities..', '2018-02-01', '10:00:00', '2018-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180201T130000Z', '', '#ff887c', '', ''), 
(9836, 'Work time', 'Let''s job! :)', '2018-02-05', '08:00:00', '2018-02-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180205T110000Z', '', '#dbadff', '', ''), 
(9837, 'Work time', 'Let''s job! :)', '2018-02-07', '08:00:00', '2018-02-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180207T110000Z', '', '#dbadff', '', ''), 
(9838, 'Work time', 'Let''s job! :)', '2018-02-08', '08:00:00', '2018-02-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180208T110000Z', '', '#dbadff', '', ''), 
(9839, 'Hobbie time', 'shhhh...It''s a secret!', '2018-02-11', null, '2018-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180211', '', '#7ae7bf', '', ''), 
(9840, 'Work time', 'Let''s job! :)', '2018-02-12', '08:00:00', '2018-02-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180212T110000Z', '', '#dbadff', '', ''), 
(9841, 'Work time', 'Let''s job! :)', '2018-02-14', '08:00:00', '2018-02-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180214T110000Z', '', '#dbadff', '', ''), 
(9842, 'Work time', 'Let''s job! :)', '2018-02-15', '08:00:00', '2018-02-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180215T110000Z', '', '#dbadff', '', ''), 
(9843, 'Resting...', 'I''m...nevermind', '2018-02-16', null, '2018-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180216', '', '#e1e1e1', '', ''), 
(9844, 'Work time', 'Let''s job! :)', '2018-02-19', '08:00:00', '2018-02-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180219T110000Z', '', '#dbadff', '', ''), 
(9845, 'Work time', 'Let''s job! :)', '2018-02-21', '08:00:00', '2018-02-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180221T110000Z', '', '#dbadff', '', ''), 
(9846, 'Work time', 'Let''s job! :)', '2018-02-22', '08:00:00', '2018-02-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180222T110000Z', '', '#dbadff', '', ''), 
(9847, 'Work time', 'Let''s job! :)', '2018-02-26', '08:00:00', '2018-02-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180226T110000Z', '', '#dbadff', '', ''), 
(9848, 'Yellow day', 'Are you ready?', '2018-02-28', null, '2018-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180228', '', '#fbd75b', '', ''), 
(9849, 'Work time', 'Let''s job! :)', '2018-02-28', '08:00:00', '2018-02-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180228T110000Z', '', '#dbadff', '', ''), 
(9850, 'Work time', 'Let''s job! :)', '2018-03-01', '08:00:00', '2018-03-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180301T110000Z', '', '#dbadff', '', ''), 
(9851, 'Day 1', 'Starting activities..', '2018-03-01', '10:00:00', '2018-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180301T130000Z', '', '#ff887c', '', ''), 
(9852, 'Work time', 'Let''s job! :)', '2018-03-05', '08:00:00', '2018-03-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180305T110000Z', '', '#dbadff', '', ''), 
(9853, 'Work time', 'Let''s job! :)', '2018-03-07', '08:00:00', '2018-03-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180307T110000Z', '', '#dbadff', '', ''), 
(9854, 'Work time', 'Let''s job! :)', '2018-03-08', '08:00:00', '2018-03-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180308T110000Z', '', '#dbadff', '', ''), 
(9855, 'Hobbie time', 'shhhh...It''s a secret!', '2018-03-11', null, '2018-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180311', '', '#7ae7bf', '', ''), 
(9856, 'Work time', 'Let''s job! :)', '2018-03-12', '08:00:00', '2018-03-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180312T110000Z', '', '#dbadff', '', ''), 
(9857, 'Work time', 'Let''s job! :)', '2018-03-14', '08:00:00', '2018-03-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180314T110000Z', '', '#dbadff', '', ''), 
(9858, 'Work time', 'Let''s job! :)', '2018-03-15', '08:00:00', '2018-03-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180315T110000Z', '', '#dbadff', '', ''), 
(9859, 'Resting...', 'I''m...nevermind', '2018-03-16', null, '2018-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180316', '', '#e1e1e1', '', ''), 
(9860, 'Work time', 'Let''s job! :)', '2018-03-19', '08:00:00', '2018-03-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180319T110000Z', '', '#dbadff', '', ''), 
(9861, 'Work time', 'Let''s job! :)', '2018-03-21', '08:00:00', '2018-03-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180321T110000Z', '', '#dbadff', '', ''), 
(9862, 'Work time', 'Let''s job! :)', '2018-03-22', '08:00:00', '2018-03-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180322T110000Z', '', '#dbadff', '', ''), 
(9863, 'Work time', 'Let''s job! :)', '2018-03-26', '08:00:00', '2018-03-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180326T110000Z', '', '#dbadff', '', ''), 
(9864, 'Yellow day', 'Are you ready?', '2018-03-28', null, '2018-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180328', '', '#fbd75b', '', ''), 
(9865, 'Work time', 'Let''s job! :)', '2018-03-28', '08:00:00', '2018-03-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180328T110000Z', '', '#dbadff', '', ''), 
(9866, 'Work time', 'Let''s job! :)', '2018-03-29', '08:00:00', '2018-03-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180329T110000Z', '', '#dbadff', '', ''), 
(9867, 'Day 1', 'Starting activities..', '2018-04-01', '10:00:00', '2018-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180401T130000Z', '', '#ff887c', '', ''), 
(9868, 'Work time', 'Let''s job! :)', '2018-04-02', '08:00:00', '2018-04-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180402T110000Z', '', '#dbadff', '', ''), 
(9869, 'Work time', 'Let''s job! :)', '2018-04-04', '08:00:00', '2018-04-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180404T110000Z', '', '#dbadff', '', ''), 
(9870, 'Work time', 'Let''s job! :)', '2018-04-05', '08:00:00', '2018-04-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180405T110000Z', '', '#dbadff', '', ''), 
(9871, 'Work time', 'Let''s job! :)', '2018-04-09', '08:00:00', '2018-04-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180409T110000Z', '', '#dbadff', '', ''), 
(9872, 'Hobbie time', 'shhhh...It''s a secret!', '2018-04-11', null, '2018-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180411', '', '#7ae7bf', '', ''), 
(9873, 'Work time', 'Let''s job! :)', '2018-04-11', '08:00:00', '2018-04-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180411T110000Z', '', '#dbadff', '', ''), 
(9874, 'Work time', 'Let''s job! :)', '2018-04-12', '08:00:00', '2018-04-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180412T110000Z', '', '#dbadff', '', ''), 
(9875, 'Resting...', 'I''m...nevermind', '2018-04-16', null, '2018-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180416', '', '#e1e1e1', '', ''), 
(9876, 'Work time', 'Let''s job! :)', '2018-04-16', '08:00:00', '2018-04-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180416T110000Z', '', '#dbadff', '', ''), 
(9877, 'Work time', 'Let''s job! :)', '2018-04-18', '08:00:00', '2018-04-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180418T110000Z', '', '#dbadff', '', ''), 
(9878, 'Work time', 'Let''s job! :)', '2018-04-19', '08:00:00', '2018-04-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180419T110000Z', '', '#dbadff', '', ''), 
(9879, 'Work time', 'Let''s job! :)', '2018-04-23', '08:00:00', '2018-04-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180423T110000Z', '', '#dbadff', '', ''), 
(9880, 'Work time', 'Let''s job! :)', '2018-04-25', '08:00:00', '2018-04-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180425T110000Z', '', '#dbadff', '', ''), 
(9881, 'Work time', 'Let''s job! :)', '2018-04-26', '08:00:00', '2018-04-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180426T110000Z', '', '#dbadff', '', ''), 
(9882, 'Yellow day', 'Are you ready?', '2018-04-28', null, '2018-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180428', '', '#fbd75b', '', ''), 
(9883, 'Work time', 'Let''s job! :)', '2018-04-30', '08:00:00', '2018-04-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180430T110000Z', '', '#dbadff', '', ''), 
(9884, 'Day 1', 'Starting activities..', '2018-05-01', '10:00:00', '2018-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180501T130000Z', '', '#ff887c', '', ''), 
(9885, 'Work time', 'Let''s job! :)', '2018-05-02', '08:00:00', '2018-05-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180502T110000Z', '', '#dbadff', '', ''), 
(9886, 'Work time', 'Let''s job! :)', '2018-05-03', '08:00:00', '2018-05-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180503T110000Z', '', '#dbadff', '', ''), 
(9887, 'Work time', 'Let''s job! :)', '2018-05-07', '08:00:00', '2018-05-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180507T110000Z', '', '#dbadff', '', ''), 
(9888, 'Work time', 'Let''s job! :)', '2018-05-09', '08:00:00', '2018-05-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180509T110000Z', '', '#dbadff', '', ''), 
(9889, 'Work time', 'Let''s job! :)', '2018-05-10', '08:00:00', '2018-05-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180510T110000Z', '', '#dbadff', '', ''), 
(9890, 'Hobbie time', 'shhhh...It''s a secret!', '2018-05-11', null, '2018-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180511', '', '#7ae7bf', '', ''), 
(9891, 'Work time', 'Let''s job! :)', '2018-05-14', '08:00:00', '2018-05-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180514T110000Z', '', '#dbadff', '', ''), 
(9892, 'Resting...', 'I''m...nevermind', '2018-05-16', null, '2018-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180516', '', '#e1e1e1', '', ''), 
(9893, 'Work time', 'Let''s job! :)', '2018-05-16', '08:00:00', '2018-05-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180516T110000Z', '', '#dbadff', '', ''); 

INSERT INTO `new_calendar` VALUES 
(9894, 'Work time', 'Let''s job! :)', '2018-05-17', '08:00:00', '2018-05-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180517T110000Z', '', '#dbadff', '', ''), 
(9895, 'Work time', 'Let''s job! :)', '2018-05-21', '08:00:00', '2018-05-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180521T110000Z', '', '#dbadff', '', ''), 
(9896, 'Work time', 'Let''s job! :)', '2018-05-23', '08:00:00', '2018-05-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180523T110000Z', '', '#dbadff', '', ''), 
(9897, 'Work time', 'Let''s job! :)', '2018-05-24', '08:00:00', '2018-05-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180524T110000Z', '', '#dbadff', '', ''), 
(9898, 'Yellow day', 'Are you ready?', '2018-05-28', null, '2018-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180528', '', '#fbd75b', '', ''), 
(9899, 'Work time', 'Let''s job! :)', '2018-05-28', '08:00:00', '2018-05-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180528T110000Z', '', '#dbadff', '', ''), 
(9900, 'Work time', 'Let''s job! :)', '2018-05-30', '08:00:00', '2018-05-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180530T110000Z', '', '#dbadff', '', ''), 
(9901, 'Work time', 'Let''s job! :)', '2018-05-31', '08:00:00', '2018-05-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180531T110000Z', '', '#dbadff', '', ''), 
(9902, 'Day 1', 'Starting activities..', '2018-06-01', '10:00:00', '2018-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180601T130000Z', '', '#ff887c', '', ''), 
(9903, 'Work time', 'Let''s job! :)', '2018-06-04', '08:00:00', '2018-06-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180604T110000Z', '', '#dbadff', '', ''), 
(9904, 'Work time', 'Let''s job! :)', '2018-06-06', '08:00:00', '2018-06-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180606T110000Z', '', '#dbadff', '', ''), 
(9905, 'Work time', 'Let''s job! :)', '2018-06-07', '08:00:00', '2018-06-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180607T110000Z', '', '#dbadff', '', ''), 
(9906, 'Hobbie time', 'shhhh...It''s a secret!', '2018-06-11', null, '2018-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180611', '', '#7ae7bf', '', ''), 
(9907, 'Work time', 'Let''s job! :)', '2018-06-11', '08:00:00', '2018-06-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180611T110000Z', '', '#dbadff', '', ''), 
(9908, 'Work time', 'Let''s job! :)', '2018-06-13', '08:00:00', '2018-06-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180613T110000Z', '', '#dbadff', '', ''), 
(9909, 'Work time', 'Let''s job! :)', '2018-06-14', '08:00:00', '2018-06-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180614T110000Z', '', '#dbadff', '', ''), 
(9910, 'Resting...', 'I''m...nevermind', '2018-06-16', null, '2018-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180616', '', '#e1e1e1', '', ''), 
(9911, 'Work time', 'Let''s job! :)', '2018-06-18', '08:00:00', '2018-06-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180618T110000Z', '', '#dbadff', '', ''), 
(9912, 'Work time', 'Let''s job! :)', '2018-06-20', '08:00:00', '2018-06-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180620T110000Z', '', '#dbadff', '', ''), 
(9913, 'Work time', 'Let''s job! :)', '2018-06-21', '08:00:00', '2018-06-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180621T110000Z', '', '#dbadff', '', ''), 
(9914, 'Work time', 'Let''s job! :)', '2018-06-25', '08:00:00', '2018-06-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180625T110000Z', '', '#dbadff', '', ''), 
(9915, 'Work time', 'Let''s job! :)', '2018-06-27', '08:00:00', '2018-06-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180627T110000Z', '', '#dbadff', '', ''), 
(9916, 'Yellow day', 'Are you ready?', '2018-06-28', null, '2018-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180628', '', '#fbd75b', '', ''), 
(9917, 'Work time', 'Let''s job! :)', '2018-06-28', '08:00:00', '2018-06-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180628T110000Z', '', '#dbadff', '', ''), 
(9918, 'Day 1', 'Starting activities..', '2018-07-01', '10:00:00', '2018-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180701T130000Z', '', '#ff887c', '', ''), 
(9919, 'Work time', 'Let''s job! :)', '2018-07-02', '08:00:00', '2018-07-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180702T110000Z', '', '#dbadff', '', ''), 
(9920, 'Work time', 'Let''s job! :)', '2018-07-04', '08:00:00', '2018-07-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180704T110000Z', '', '#dbadff', '', ''), 
(9921, 'Work time', 'Let''s job! :)', '2018-07-05', '08:00:00', '2018-07-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180705T110000Z', '', '#dbadff', '', ''), 
(9922, 'Work time', 'Let''s job! :)', '2018-07-09', '08:00:00', '2018-07-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180709T110000Z', '', '#dbadff', '', ''), 
(9923, 'Hobbie time', 'shhhh...It''s a secret!', '2018-07-11', null, '2018-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180711', '', '#7ae7bf', '', ''), 
(9924, 'Work time', 'Let''s job! :)', '2018-07-11', '08:00:00', '2018-07-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180711T110000Z', '', '#dbadff', '', ''), 
(9925, 'Work time', 'Let''s job! :)', '2018-07-12', '08:00:00', '2018-07-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180712T110000Z', '', '#dbadff', '', ''), 
(9926, 'Resting...', 'I''m...nevermind', '2018-07-16', null, '2018-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180716', '', '#e1e1e1', '', ''), 
(9927, 'Work time', 'Let''s job! :)', '2018-07-16', '08:00:00', '2018-07-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180716T110000Z', '', '#dbadff', '', ''), 
(9928, 'Work time', 'Let''s job! :)', '2018-07-18', '08:00:00', '2018-07-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180718T110000Z', '', '#dbadff', '', ''), 
(9929, 'Work time', 'Let''s job! :)', '2018-07-19', '08:00:00', '2018-07-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180719T110000Z', '', '#dbadff', '', ''), 
(9930, 'Work time', 'Let''s job! :)', '2018-07-23', '08:00:00', '2018-07-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180723T110000Z', '', '#dbadff', '', ''), 
(9931, 'Work time', 'Let''s job! :)', '2018-07-25', '08:00:00', '2018-07-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180725T110000Z', '', '#dbadff', '', ''), 
(9932, 'Work time', 'Let''s job! :)', '2018-07-26', '08:00:00', '2018-07-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180726T110000Z', '', '#dbadff', '', ''), 
(9933, 'Yellow day', 'Are you ready?', '2018-07-28', null, '2018-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180728', '', '#fbd75b', '', ''), 
(9934, 'Work time', 'Let''s job! :)', '2018-07-30', '08:00:00', '2018-07-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180730T110000Z', '', '#dbadff', '', ''), 
(9935, 'Work time', 'Let''s job! :)', '2018-08-01', '08:00:00', '2018-08-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180801T110000Z', '', '#dbadff', '', ''), 
(9936, 'Day 1', 'Starting activities..', '2018-08-01', '10:00:00', '2018-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180801T130000Z', '', '#ff887c', '', ''), 
(9937, 'Work time', 'Let''s job! :)', '2018-08-02', '08:00:00', '2018-08-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180802T110000Z', '', '#dbadff', '', ''), 
(9938, 'Work time', 'Let''s job! :)', '2018-08-06', '08:00:00', '2018-08-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180806T110000Z', '', '#dbadff', '', ''), 
(9939, 'Work time', 'Let''s job! :)', '2018-08-08', '08:00:00', '2018-08-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180808T110000Z', '', '#dbadff', '', ''), 
(9940, 'Work time', 'Let''s job! :)', '2018-08-09', '08:00:00', '2018-08-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180809T110000Z', '', '#dbadff', '', ''), 
(9941, 'Hobbie time', 'shhhh...It''s a secret!', '2018-08-11', null, '2018-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180811', '', '#7ae7bf', '', ''), 
(9942, 'Work time', 'Let''s job! :)', '2018-08-13', '08:00:00', '2018-08-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180813T110000Z', '', '#dbadff', '', ''), 
(9943, 'Work time', 'Let''s job! :)', '2018-08-15', '08:00:00', '2018-08-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180815T110000Z', '', '#dbadff', '', ''), 
(9944, 'Resting...', 'I''m...nevermind', '2018-08-16', null, '2018-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180816', '', '#e1e1e1', '', ''), 
(9945, 'Work time', 'Let''s job! :)', '2018-08-16', '08:00:00', '2018-08-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180816T110000Z', '', '#dbadff', '', ''), 
(9946, 'Work time', 'Let''s job! :)', '2018-08-20', '08:00:00', '2018-08-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180820T110000Z', '', '#dbadff', '', ''), 
(9947, 'Work time', 'Let''s job! :)', '2018-08-22', '08:00:00', '2018-08-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180822T110000Z', '', '#dbadff', '', ''), 
(9948, 'Work time', 'Let''s job! :)', '2018-08-23', '08:00:00', '2018-08-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180823T110000Z', '', '#dbadff', '', ''), 
(9949, 'Work time', 'Let''s job! :)', '2018-08-27', '08:00:00', '2018-08-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180827T110000Z', '', '#dbadff', '', ''), 
(9950, 'Yellow day', 'Are you ready?', '2018-08-28', null, '2018-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180828', '', '#fbd75b', '', ''), 
(9951, 'Work time', 'Let''s job! :)', '2018-08-29', '08:00:00', '2018-08-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180829T110000Z', '', '#dbadff', '', ''), 
(9952, 'Work time', 'Let''s job! :)', '2018-08-30', '08:00:00', '2018-08-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180830T110000Z', '', '#dbadff', '', ''), 
(9953, 'Day 1', 'Starting activities..', '2018-09-01', '10:00:00', '2018-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20180901T130000Z', '', '#ff887c', '', ''), 
(9954, 'Work time', 'Let''s job! :)', '2018-09-03', '08:00:00', '2018-09-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180903T110000Z', '', '#dbadff', '', ''), 
(9955, 'Work time', 'Let''s job! :)', '2018-09-05', '08:00:00', '2018-09-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180905T110000Z', '', '#dbadff', '', ''), 
(9956, 'Work time', 'Let''s job! :)', '2018-09-06', '08:00:00', '2018-09-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180906T110000Z', '', '#dbadff', '', ''), 
(9957, 'Work time', 'Let''s job! :)', '2018-09-10', '08:00:00', '2018-09-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180910T110000Z', '', '#dbadff', '', ''), 
(9958, 'Hobbie time', 'shhhh...It''s a secret!', '2018-09-11', null, '2018-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20180911', '', '#7ae7bf', '', ''), 
(9959, 'Work time', 'Let''s job! :)', '2018-09-12', '08:00:00', '2018-09-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180912T110000Z', '', '#dbadff', '', ''), 
(9960, 'Work time', 'Let''s job! :)', '2018-09-13', '08:00:00', '2018-09-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180913T110000Z', '', '#dbadff', '', ''), 
(9961, 'Resting...', 'I''m...nevermind', '2018-09-16', null, '2018-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20180916', '', '#e1e1e1', '', ''), 
(9962, 'Work time', 'Let''s job! :)', '2018-09-17', '08:00:00', '2018-09-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180917T110000Z', '', '#dbadff', '', ''), 
(9963, 'Work time', 'Let''s job! :)', '2018-09-19', '08:00:00', '2018-09-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180919T110000Z', '', '#dbadff', '', ''), 
(9964, 'Work time', 'Let''s job! :)', '2018-09-20', '08:00:00', '2018-09-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180920T110000Z', '', '#dbadff', '', ''), 
(9965, 'Work time', 'Let''s job! :)', '2018-09-24', '08:00:00', '2018-09-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180924T110000Z', '', '#dbadff', '', ''), 
(9966, 'Work time', 'Let''s job! :)', '2018-09-26', '08:00:00', '2018-09-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180926T110000Z', '', '#dbadff', '', ''), 
(9967, 'Work time', 'Let''s job! :)', '2018-09-27', '08:00:00', '2018-09-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20180927T110000Z', '', '#dbadff', '', ''), 
(9968, 'Yellow day', 'Are you ready?', '2018-09-28', null, '2018-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20180928', '', '#fbd75b', '', ''), 
(9969, 'Work time', 'Let''s job! :)', '2018-10-01', '08:00:00', '2018-10-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181001T110000Z', '', '#dbadff', '', ''), 
(9970, 'Day 1', 'Starting activities..', '2018-10-01', '10:00:00', '2018-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20181001T130000Z', '', '#ff887c', '', ''), 
(9971, 'Work time', 'Let''s job! :)', '2018-10-03', '08:00:00', '2018-10-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181003T110000Z', '', '#dbadff', '', ''), 
(9972, 'Work time', 'Let''s job! :)', '2018-10-04', '08:00:00', '2018-10-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181004T110000Z', '', '#dbadff', '', ''), 
(9973, 'Work time', 'Let''s job! :)', '2018-10-08', '08:00:00', '2018-10-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181008T110000Z', '', '#dbadff', '', ''), 
(9974, 'Work time', 'Let''s job! :)', '2018-10-10', '08:00:00', '2018-10-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181010T110000Z', '', '#dbadff', '', ''), 
(9975, 'Hobbie time', 'shhhh...It''s a secret!', '2018-10-11', null, '2018-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20181011', '', '#7ae7bf', '', ''), 
(9976, 'Work time', 'Let''s job! :)', '2018-10-11', '08:00:00', '2018-10-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181011T110000Z', '', '#dbadff', '', ''), 
(9977, 'Work time', 'Let''s job! :)', '2018-10-15', '08:00:00', '2018-10-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181015T110000Z', '', '#dbadff', '', ''), 
(9978, 'Resting...', 'I''m...nevermind', '2018-10-16', null, '2018-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20181016', '', '#e1e1e1', '', ''), 
(9979, 'Work time', 'Let''s job! :)', '2018-10-17', '08:00:00', '2018-10-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181017T110000Z', '', '#dbadff', '', ''), 
(9980, 'Work time', 'Let''s job! :)', '2018-10-18', '08:00:00', '2018-10-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181018T110000Z', '', '#dbadff', '', ''), 
(9981, 'Work time', 'Let''s job! :)', '2018-10-22', '08:00:00', '2018-10-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181022T110000Z', '', '#dbadff', '', ''), 
(9982, 'Work time', 'Let''s job! :)', '2018-10-24', '08:00:00', '2018-10-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181024T110000Z', '', '#dbadff', '', ''), 
(9983, 'Work time', 'Let''s job! :)', '2018-10-25', '08:00:00', '2018-10-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181025T110000Z', '', '#dbadff', '', ''), 
(9984, 'Yellow day', 'Are you ready?', '2018-10-28', null, '2018-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20181028', '', '#fbd75b', '', ''), 
(9985, 'Work time', 'Let''s job! :)', '2018-10-29', '08:00:00', '2018-10-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181029T110000Z', '', '#dbadff', '', ''), 
(9986, 'Work time', 'Let''s job! :)', '2018-10-31', '08:00:00', '2018-10-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181031T110000Z', '', '#dbadff', '', ''), 
(9987, 'Work time', 'Let''s job! :)', '2018-11-01', '08:00:00', '2018-11-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181101T110000Z', '', '#dbadff', '', ''), 
(9988, 'Day 1', 'Starting activities..', '2018-11-01', '10:00:00', '2018-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20181101T130000Z', '', '#ff887c', '', ''), 
(9989, 'Work time', 'Let''s job! :)', '2018-11-05', '08:00:00', '2018-11-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181105T110000Z', '', '#dbadff', '', ''), 
(9990, 'Work time', 'Let''s job! :)', '2018-11-07', '08:00:00', '2018-11-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181107T110000Z', '', '#dbadff', '', ''), 
(9991, 'Work time', 'Let''s job! :)', '2018-11-08', '08:00:00', '2018-11-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181108T110000Z', '', '#dbadff', '', ''), 
(9992, 'Hobbie time', 'shhhh...It''s a secret!', '2018-11-11', null, '2018-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20181111', '', '#7ae7bf', '', ''), 
(9993, 'Work time', 'Let''s job! :)', '2018-11-12', '08:00:00', '2018-11-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181112T110000Z', '', '#dbadff', '', ''); 

INSERT INTO `new_calendar` VALUES 
(9994, 'Work time', 'Let''s job! :)', '2018-11-14', '08:00:00', '2018-11-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181114T110000Z', '', '#dbadff', '', ''), 
(9995, 'Work time', 'Let''s job! :)', '2018-11-15', '08:00:00', '2018-11-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181115T110000Z', '', '#dbadff', '', ''), 
(9996, 'Resting...', 'I''m...nevermind', '2018-11-16', null, '2018-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20181116', '', '#e1e1e1', '', ''), 
(9997, 'Work time', 'Let''s job! :)', '2018-11-19', '08:00:00', '2018-11-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181119T110000Z', '', '#dbadff', '', ''), 
(9998, 'Work time', 'Let''s job! :)', '2018-11-21', '08:00:00', '2018-11-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181121T110000Z', '', '#dbadff', '', ''), 
(9999, 'Work time', 'Let''s job! :)', '2018-11-22', '08:00:00', '2018-11-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181122T110000Z', '', '#dbadff', '', ''), 
(10000, 'Work time', 'Let''s job! :)', '2018-11-26', '08:00:00', '2018-11-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181126T110000Z', '', '#dbadff', '', ''), 
(10001, 'Yellow day', 'Are you ready?', '2018-11-28', null, '2018-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20181128', '', '#fbd75b', '', ''), 
(10002, 'Work time', 'Let''s job! :)', '2018-11-28', '08:00:00', '2018-11-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181128T110000Z', '', '#dbadff', '', ''), 
(10003, 'Work time', 'Let''s job! :)', '2018-11-29', '08:00:00', '2018-11-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181129T110000Z', '', '#dbadff', '', ''), 
(10004, 'Day 1', 'Starting activities..', '2018-12-01', '10:00:00', '2018-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20181201T130000Z', '', '#ff887c', '', ''), 
(10005, 'Work time', 'Let''s job! :)', '2018-12-03', '08:00:00', '2018-12-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181203T110000Z', '', '#dbadff', '', ''), 
(10006, 'Work time', 'Let''s job! :)', '2018-12-05', '08:00:00', '2018-12-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181205T110000Z', '', '#dbadff', '', ''), 
(10007, 'Work time', 'Let''s job! :)', '2018-12-06', '08:00:00', '2018-12-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181206T110000Z', '', '#dbadff', '', ''), 
(10008, 'Work time', 'Let''s job! :)', '2018-12-10', '08:00:00', '2018-12-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181210T110000Z', '', '#dbadff', '', ''), 
(10009, 'Hobbie time', 'shhhh...It''s a secret!', '2018-12-11', null, '2018-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20181211', '', '#7ae7bf', '', ''), 
(10010, 'Work time', 'Let''s job! :)', '2018-12-12', '08:00:00', '2018-12-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181212T110000Z', '', '#dbadff', '', ''), 
(10011, 'Work time', 'Let''s job! :)', '2018-12-13', '08:00:00', '2018-12-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181213T110000Z', '', '#dbadff', '', ''), 
(10012, 'Resting...', 'I''m...nevermind', '2018-12-16', null, '2018-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20181216', '', '#e1e1e1', '', ''), 
(10013, 'Work time', 'Let''s job! :)', '2018-12-17', '08:00:00', '2018-12-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181217T110000Z', '', '#dbadff', '', ''), 
(10014, 'Work time', 'Let''s job! :)', '2018-12-19', '08:00:00', '2018-12-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181219T110000Z', '', '#dbadff', '', ''), 
(10015, 'Work time', 'Let''s job! :)', '2018-12-20', '08:00:00', '2018-12-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181220T110000Z', '', '#dbadff', '', ''), 
(10016, 'Work time', 'Let''s job! :)', '2018-12-24', '08:00:00', '2018-12-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181224T110000Z', '', '#dbadff', '', ''), 
(10017, 'Work time', 'Let''s job! :)', '2018-12-26', '08:00:00', '2018-12-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181226T110000Z', '', '#dbadff', '', ''), 
(10018, 'Work time', 'Let''s job! :)', '2018-12-27', '08:00:00', '2018-12-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181227T110000Z', '', '#dbadff', '', ''), 
(10019, 'Yellow day', 'Are you ready?', '2018-12-28', null, '2018-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20181228', '', '#fbd75b', '', ''), 
(10020, 'Work time', 'Let''s job! :)', '2018-12-31', '08:00:00', '2018-12-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20181231T110000Z', '', '#dbadff', '', ''), 
(10021, 'Day 1', 'Starting activities..', '2019-01-01', '10:00:00', '2019-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190101T130000Z', '', '#ff887c', '', ''), 
(10022, 'Work time', 'Let''s job! :)', '2019-01-02', '08:00:00', '2019-01-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190102T110000Z', '', '#dbadff', '', ''), 
(10023, 'Work time', 'Let''s job! :)', '2019-01-03', '08:00:00', '2019-01-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190103T110000Z', '', '#dbadff', '', ''), 
(10024, 'Work time', 'Let''s job! :)', '2019-01-07', '08:00:00', '2019-01-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190107T110000Z', '', '#dbadff', '', ''), 
(10025, 'Work time', 'Let''s job! :)', '2019-01-09', '08:00:00', '2019-01-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190109T110000Z', '', '#dbadff', '', ''), 
(10026, 'Work time', 'Let''s job! :)', '2019-01-10', '08:00:00', '2019-01-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190110T110000Z', '', '#dbadff', '', ''), 
(10027, 'Hobbie time', 'shhhh...It''s a secret!', '2019-01-11', null, '2019-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190111', '', '#7ae7bf', '', ''), 
(10028, 'Work time', 'Let''s job! :)', '2019-01-14', '08:00:00', '2019-01-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190114T110000Z', '', '#dbadff', '', ''), 
(10029, 'Resting...', 'I''m...nevermind', '2019-01-16', null, '2019-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190116', '', '#e1e1e1', '', ''), 
(10030, 'Work time', 'Let''s job! :)', '2019-01-16', '08:00:00', '2019-01-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190116T110000Z', '', '#dbadff', '', ''), 
(10031, 'Work time', 'Let''s job! :)', '2019-01-17', '08:00:00', '2019-01-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190117T110000Z', '', '#dbadff', '', ''), 
(10032, 'Work time', 'Let''s job! :)', '2019-01-21', '08:00:00', '2019-01-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190121T110000Z', '', '#dbadff', '', ''), 
(10033, 'Work time', 'Let''s job! :)', '2019-01-23', '08:00:00', '2019-01-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190123T110000Z', '', '#dbadff', '', ''), 
(10034, 'Work time', 'Let''s job! :)', '2019-01-24', '08:00:00', '2019-01-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190124T110000Z', '', '#dbadff', '', ''), 
(10035, 'Yellow day', 'Are you ready?', '2019-01-28', null, '2019-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190128', '', '#fbd75b', '', ''), 
(10036, 'Work time', 'Let''s job! :)', '2019-01-28', '08:00:00', '2019-01-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190128T110000Z', '', '#dbadff', '', ''), 
(10037, 'Work time', 'Let''s job! :)', '2019-01-30', '08:00:00', '2019-01-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190130T110000Z', '', '#dbadff', '', ''), 
(10038, 'Work time', 'Let''s job! :)', '2019-01-31', '08:00:00', '2019-01-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190131T110000Z', '', '#dbadff', '', ''), 
(10039, 'Day 1', 'Starting activities..', '2019-02-01', '10:00:00', '2019-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190201T130000Z', '', '#ff887c', '', ''), 
(10040, 'Work time', 'Let''s job! :)', '2019-02-04', '08:00:00', '2019-02-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190204T110000Z', '', '#dbadff', '', ''), 
(10041, 'Work time', 'Let''s job! :)', '2019-02-06', '08:00:00', '2019-02-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190206T110000Z', '', '#dbadff', '', ''), 
(10042, 'Work time', 'Let''s job! :)', '2019-02-07', '08:00:00', '2019-02-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190207T110000Z', '', '#dbadff', '', ''), 
(10043, 'Hobbie time', 'shhhh...It''s a secret!', '2019-02-11', null, '2019-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190211', '', '#7ae7bf', '', ''), 
(10044, 'Work time', 'Let''s job! :)', '2019-02-11', '08:00:00', '2019-02-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190211T110000Z', '', '#dbadff', '', ''), 
(10045, 'Work time', 'Let''s job! :)', '2019-02-13', '08:00:00', '2019-02-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190213T110000Z', '', '#dbadff', '', ''), 
(10046, 'Work time', 'Let''s job! :)', '2019-02-14', '08:00:00', '2019-02-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190214T110000Z', '', '#dbadff', '', ''), 
(10047, 'Resting...', 'I''m...nevermind', '2019-02-16', null, '2019-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190216', '', '#e1e1e1', '', ''), 
(10048, 'Work time', 'Let''s job! :)', '2019-02-18', '08:00:00', '2019-02-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190218T110000Z', '', '#dbadff', '', ''), 
(10049, 'Work time', 'Let''s job! :)', '2019-02-20', '08:00:00', '2019-02-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190220T110000Z', '', '#dbadff', '', ''), 
(10050, 'Work time', 'Let''s job! :)', '2019-02-21', '08:00:00', '2019-02-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190221T110000Z', '', '#dbadff', '', ''), 
(10051, 'Work time', 'Let''s job! :)', '2019-02-25', '08:00:00', '2019-02-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190225T110000Z', '', '#dbadff', '', ''), 
(10052, 'Work time', 'Let''s job! :)', '2019-02-27', '08:00:00', '2019-02-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190227T110000Z', '', '#dbadff', '', ''), 
(10053, 'Yellow day', 'Are you ready?', '2019-02-28', null, '2019-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190228', '', '#fbd75b', '', ''), 
(10054, 'Work time', 'Let''s job! :)', '2019-02-28', '08:00:00', '2019-02-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190228T110000Z', '', '#dbadff', '', ''), 
(10055, 'Day 1', 'Starting activities..', '2019-03-01', '10:00:00', '2019-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190301T130000Z', '', '#ff887c', '', ''), 
(10056, 'Work time', 'Let''s job! :)', '2019-03-04', '08:00:00', '2019-03-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190304T110000Z', '', '#dbadff', '', ''), 
(10057, 'Work time', 'Let''s job! :)', '2019-03-06', '08:00:00', '2019-03-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190306T110000Z', '', '#dbadff', '', ''), 
(10058, 'Work time', 'Let''s job! :)', '2019-03-07', '08:00:00', '2019-03-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190307T110000Z', '', '#dbadff', '', ''), 
(10059, 'Hobbie time', 'shhhh...It''s a secret!', '2019-03-11', null, '2019-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190311', '', '#7ae7bf', '', ''), 
(10060, 'Work time', 'Let''s job! :)', '2019-03-11', '08:00:00', '2019-03-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190311T110000Z', '', '#dbadff', '', ''), 
(10061, 'Work time', 'Let''s job! :)', '2019-03-13', '08:00:00', '2019-03-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190313T110000Z', '', '#dbadff', '', ''), 
(10062, 'Work time', 'Let''s job! :)', '2019-03-14', '08:00:00', '2019-03-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190314T110000Z', '', '#dbadff', '', ''), 
(10063, 'Resting...', 'I''m...nevermind', '2019-03-16', null, '2019-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190316', '', '#e1e1e1', '', ''), 
(10064, 'Work time', 'Let''s job! :)', '2019-03-18', '08:00:00', '2019-03-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190318T110000Z', '', '#dbadff', '', ''), 
(10065, 'Work time', 'Let''s job! :)', '2019-03-20', '08:00:00', '2019-03-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190320T110000Z', '', '#dbadff', '', ''), 
(10066, 'Work time', 'Let''s job! :)', '2019-03-21', '08:00:00', '2019-03-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190321T110000Z', '', '#dbadff', '', ''), 
(10067, 'Work time', 'Let''s job! :)', '2019-03-25', '08:00:00', '2019-03-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190325T110000Z', '', '#dbadff', '', ''), 
(10068, 'Work time', 'Let''s job! :)', '2019-03-27', '08:00:00', '2019-03-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190327T110000Z', '', '#dbadff', '', ''), 
(10069, 'Yellow day', 'Are you ready?', '2019-03-28', null, '2019-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190328', '', '#fbd75b', '', ''), 
(10070, 'Work time', 'Let''s job! :)', '2019-03-28', '08:00:00', '2019-03-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190328T110000Z', '', '#dbadff', '', ''), 
(10071, 'Work time', 'Let''s job! :)', '2019-04-01', '08:00:00', '2019-04-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190401T110000Z', '', '#dbadff', '', ''), 
(10072, 'Day 1', 'Starting activities..', '2019-04-01', '10:00:00', '2019-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190401T130000Z', '', '#ff887c', '', ''), 
(10073, 'Work time', 'Let''s job! :)', '2019-04-03', '08:00:00', '2019-04-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190403T110000Z', '', '#dbadff', '', ''), 
(10074, 'Work time', 'Let''s job! :)', '2019-04-04', '08:00:00', '2019-04-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190404T110000Z', '', '#dbadff', '', ''), 
(10075, 'Work time', 'Let''s job! :)', '2019-04-08', '08:00:00', '2019-04-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190408T110000Z', '', '#dbadff', '', ''), 
(10076, 'Work time', 'Let''s job! :)', '2019-04-10', '08:00:00', '2019-04-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190410T110000Z', '', '#dbadff', '', ''), 
(10077, 'Hobbie time', 'shhhh...It''s a secret!', '2019-04-11', null, '2019-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190411', '', '#7ae7bf', '', ''), 
(10078, 'Work time', 'Let''s job! :)', '2019-04-11', '08:00:00', '2019-04-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190411T110000Z', '', '#dbadff', '', ''), 
(10079, 'Work time', 'Let''s job! :)', '2019-04-15', '08:00:00', '2019-04-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190415T110000Z', '', '#dbadff', '', ''), 
(10080, 'Resting...', 'I''m...nevermind', '2019-04-16', null, '2019-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190416', '', '#e1e1e1', '', ''), 
(10081, 'Work time', 'Let''s job! :)', '2019-04-17', '08:00:00', '2019-04-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190417T110000Z', '', '#dbadff', '', ''), 
(10082, 'Work time', 'Let''s job! :)', '2019-04-18', '08:00:00', '2019-04-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190418T110000Z', '', '#dbadff', '', ''), 
(10083, 'Work time', 'Let''s job! :)', '2019-04-22', '08:00:00', '2019-04-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190422T110000Z', '', '#dbadff', '', ''); 

INSERT INTO `new_calendar` VALUES 
(10084, 'Work time', 'Let''s job! :)', '2019-04-24', '08:00:00', '2019-04-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190424T110000Z', '', '#dbadff', '', ''), 
(10085, 'Work time', 'Let''s job! :)', '2019-04-25', '08:00:00', '2019-04-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190425T110000Z', '', '#dbadff', '', ''), 
(10086, 'Yellow day', 'Are you ready?', '2019-04-28', null, '2019-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190428', '', '#fbd75b', '', ''), 
(10087, 'Work time', 'Let''s job! :)', '2019-04-29', '08:00:00', '2019-04-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190429T110000Z', '', '#dbadff', '', ''), 
(10088, 'Work time', 'Let''s job! :)', '2019-05-01', '08:00:00', '2019-05-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190501T110000Z', '', '#dbadff', '', ''), 
(10089, 'Day 1', 'Starting activities..', '2019-05-01', '10:00:00', '2019-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190501T130000Z', '', '#ff887c', '', ''), 
(10090, 'Work time', 'Let''s job! :)', '2019-05-02', '08:00:00', '2019-05-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190502T110000Z', '', '#dbadff', '', ''), 
(10091, 'Work time', 'Let''s job! :)', '2019-05-06', '08:00:00', '2019-05-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190506T110000Z', '', '#dbadff', '', ''), 
(10092, 'Work time', 'Let''s job! :)', '2019-05-08', '08:00:00', '2019-05-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190508T110000Z', '', '#dbadff', '', ''), 
(10093, 'Work time', 'Let''s job! :)', '2019-05-09', '08:00:00', '2019-05-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190509T110000Z', '', '#dbadff', '', ''), 
(10094, 'Hobbie time', 'shhhh...It''s a secret!', '2019-05-11', null, '2019-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190511', '', '#7ae7bf', '', ''), 
(10095, 'Work time', 'Let''s job! :)', '2019-05-13', '08:00:00', '2019-05-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190513T110000Z', '', '#dbadff', '', ''), 
(10096, 'Work time', 'Let''s job! :)', '2019-05-15', '08:00:00', '2019-05-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190515T110000Z', '', '#dbadff', '', ''), 
(10097, 'Resting...', 'I''m...nevermind', '2019-05-16', null, '2019-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190516', '', '#e1e1e1', '', ''), 
(10098, 'Work time', 'Let''s job! :)', '2019-05-16', '08:00:00', '2019-05-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190516T110000Z', '', '#dbadff', '', ''), 
(10099, 'Work time', 'Let''s job! :)', '2019-05-20', '08:00:00', '2019-05-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190520T110000Z', '', '#dbadff', '', ''), 
(10100, 'Work time', 'Let''s job! :)', '2019-05-22', '08:00:00', '2019-05-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190522T110000Z', '', '#dbadff', '', ''), 
(10101, 'Work time', 'Let''s job! :)', '2019-05-23', '08:00:00', '2019-05-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190523T110000Z', '', '#dbadff', '', ''), 
(10102, 'Work time', 'Let''s job! :)', '2019-05-27', '08:00:00', '2019-05-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190527T110000Z', '', '#dbadff', '', ''), 
(10103, 'Yellow day', 'Are you ready?', '2019-05-28', null, '2019-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190528', '', '#fbd75b', '', ''), 
(10104, 'Work time', 'Let''s job! :)', '2019-05-29', '08:00:00', '2019-05-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190529T110000Z', '', '#dbadff', '', ''), 
(10105, 'Work time', 'Let''s job! :)', '2019-05-30', '08:00:00', '2019-05-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190530T110000Z', '', '#dbadff', '', ''), 
(10106, 'Day 1', 'Starting activities..', '2019-06-01', '10:00:00', '2019-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190601T130000Z', '', '#ff887c', '', ''), 
(10107, 'Work time', 'Let''s job! :)', '2019-06-03', '08:00:00', '2019-06-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190603T110000Z', '', '#dbadff', '', ''), 
(10108, 'Work time', 'Let''s job! :)', '2019-06-05', '08:00:00', '2019-06-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190605T110000Z', '', '#dbadff', '', ''), 
(10109, 'Work time', 'Let''s job! :)', '2019-06-06', '08:00:00', '2019-06-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190606T110000Z', '', '#dbadff', '', ''), 
(10110, 'Work time', 'Let''s job! :)', '2019-06-10', '08:00:00', '2019-06-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190610T110000Z', '', '#dbadff', '', ''), 
(10111, 'Hobbie time', 'shhhh...It''s a secret!', '2019-06-11', null, '2019-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190611', '', '#7ae7bf', '', ''), 
(10112, 'Work time', 'Let''s job! :)', '2019-06-12', '08:00:00', '2019-06-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190612T110000Z', '', '#dbadff', '', ''), 
(10113, 'Work time', 'Let''s job! :)', '2019-06-13', '08:00:00', '2019-06-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190613T110000Z', '', '#dbadff', '', ''), 
(10114, 'Resting...', 'I''m...nevermind', '2019-06-16', null, '2019-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190616', '', '#e1e1e1', '', ''), 
(10115, 'Work time', 'Let''s job! :)', '2019-06-17', '08:00:00', '2019-06-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190617T110000Z', '', '#dbadff', '', ''), 
(10116, 'Work time', 'Let''s job! :)', '2019-06-19', '08:00:00', '2019-06-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190619T110000Z', '', '#dbadff', '', ''), 
(10117, 'Work time', 'Let''s job! :)', '2019-06-20', '08:00:00', '2019-06-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190620T110000Z', '', '#dbadff', '', ''), 
(10118, 'Work time', 'Let''s job! :)', '2019-06-24', '08:00:00', '2019-06-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190624T110000Z', '', '#dbadff', '', ''), 
(10119, 'Work time', 'Let''s job! :)', '2019-06-26', '08:00:00', '2019-06-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190626T110000Z', '', '#dbadff', '', ''), 
(10120, 'Work time', 'Let''s job! :)', '2019-06-27', '08:00:00', '2019-06-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190627T110000Z', '', '#dbadff', '', ''), 
(10121, 'Yellow day', 'Are you ready?', '2019-06-28', null, '2019-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190628', '', '#fbd75b', '', ''), 
(10122, 'Work time', 'Let''s job! :)', '2019-07-01', '08:00:00', '2019-07-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190701T110000Z', '', '#dbadff', '', ''), 
(10123, 'Day 1', 'Starting activities..', '2019-07-01', '10:00:00', '2019-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190701T130000Z', '', '#ff887c', '', ''), 
(10124, 'Work time', 'Let''s job! :)', '2019-07-03', '08:00:00', '2019-07-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190703T110000Z', '', '#dbadff', '', ''), 
(10125, 'Work time', 'Let''s job! :)', '2019-07-04', '08:00:00', '2019-07-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190704T110000Z', '', '#dbadff', '', ''), 
(10126, 'Work time', 'Let''s job! :)', '2019-07-08', '08:00:00', '2019-07-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190708T110000Z', '', '#dbadff', '', ''), 
(10127, 'Work time', 'Let''s job! :)', '2019-07-10', '08:00:00', '2019-07-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190710T110000Z', '', '#dbadff', '', ''), 
(10128, 'Hobbie time', 'shhhh...It''s a secret!', '2019-07-11', null, '2019-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190711', '', '#7ae7bf', '', ''), 
(10129, 'Work time', 'Let''s job! :)', '2019-07-11', '08:00:00', '2019-07-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190711T110000Z', '', '#dbadff', '', ''), 
(10130, 'Work time', 'Let''s job! :)', '2019-07-15', '08:00:00', '2019-07-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190715T110000Z', '', '#dbadff', '', ''), 
(10131, 'Resting...', 'I''m...nevermind', '2019-07-16', null, '2019-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190716', '', '#e1e1e1', '', ''), 
(10132, 'Work time', 'Let''s job! :)', '2019-07-17', '08:00:00', '2019-07-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190717T110000Z', '', '#dbadff', '', ''), 
(10133, 'Work time', 'Let''s job! :)', '2019-07-18', '08:00:00', '2019-07-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190718T110000Z', '', '#dbadff', '', ''), 
(10134, 'Work time', 'Let''s job! :)', '2019-07-22', '08:00:00', '2019-07-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190722T110000Z', '', '#dbadff', '', ''), 
(10135, 'Work time', 'Let''s job! :)', '2019-07-24', '08:00:00', '2019-07-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190724T110000Z', '', '#dbadff', '', ''), 
(10136, 'Work time', 'Let''s job! :)', '2019-07-25', '08:00:00', '2019-07-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190725T110000Z', '', '#dbadff', '', ''), 
(10137, 'Yellow day', 'Are you ready?', '2019-07-28', null, '2019-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190728', '', '#fbd75b', '', ''), 
(10138, 'Work time', 'Let''s job! :)', '2019-07-29', '08:00:00', '2019-07-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190729T110000Z', '', '#dbadff', '', ''), 
(10139, 'Work time', 'Let''s job! :)', '2019-07-31', '08:00:00', '2019-07-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190731T110000Z', '', '#dbadff', '', ''), 
(10140, 'Work time', 'Let''s job! :)', '2019-08-01', '08:00:00', '2019-08-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190801T110000Z', '', '#dbadff', '', ''), 
(10141, 'Day 1', 'Starting activities..', '2019-08-01', '10:00:00', '2019-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190801T130000Z', '', '#ff887c', '', ''), 
(10142, 'Work time', 'Let''s job! :)', '2019-08-05', '08:00:00', '2019-08-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190805T110000Z', '', '#dbadff', '', ''), 
(10143, 'Work time', 'Let''s job! :)', '2019-08-07', '08:00:00', '2019-08-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190807T110000Z', '', '#dbadff', '', ''), 
(10144, 'Work time', 'Let''s job! :)', '2019-08-08', '08:00:00', '2019-08-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190808T110000Z', '', '#dbadff', '', '');

INSERT INTO `new_calendar` VALUES 
(10145, 'Hobbie time', 'shhhh...It''s a secret!', '2019-08-11', null, '2019-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190811', '', '#7ae7bf', '', ''), 
(10146, 'Work time', 'Let''s job! :)', '2019-08-12', '08:00:00', '2019-08-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190812T110000Z', '', '#dbadff', '', ''), 
(10147, 'Work time', 'Let''s job! :)', '2019-08-14', '08:00:00', '2019-08-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190814T110000Z', '', '#dbadff', '', ''), 
(10148, 'Work time', 'Let''s job! :)', '2019-08-15', '08:00:00', '2019-08-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190815T110000Z', '', '#dbadff', '', ''), 
(10149, 'Resting...', 'I''m...nevermind', '2019-08-16', null, '2019-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190816', '', '#e1e1e1', '', ''), 
(10150, 'Work time', 'Let''s job! :)', '2019-08-19', '08:00:00', '2019-08-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190819T110000Z', '', '#dbadff', '', ''), 
(10151, 'Work time', 'Let''s job! :)', '2019-08-21', '08:00:00', '2019-08-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190821T110000Z', '', '#dbadff', '', ''), 
(10152, 'Work time', 'Let''s job! :)', '2019-08-22', '08:00:00', '2019-08-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190822T110000Z', '', '#dbadff', '', ''), 
(10153, 'Work time', 'Let''s job! :)', '2019-08-26', '08:00:00', '2019-08-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190826T110000Z', '', '#dbadff', '', ''), 
(10154, 'Yellow day', 'Are you ready?', '2019-08-28', null, '2019-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190828', '', '#fbd75b', '', ''), 
(10155, 'Work time', 'Let''s job! :)', '2019-08-28', '08:00:00', '2019-08-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190828T110000Z', '', '#dbadff', '', ''), 
(10156, 'Work time', 'Let''s job! :)', '2019-08-29', '08:00:00', '2019-08-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190829T110000Z', '', '#dbadff', '', ''), 
(10157, 'Day 1', 'Starting activities..', '2019-09-01', '10:00:00', '2019-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20190901T130000Z', '', '#ff887c', '', ''), 
(10158, 'Work time', 'Let''s job! :)', '2019-09-02', '08:00:00', '2019-09-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190902T110000Z', '', '#dbadff', '', ''), 
(10159, 'Work time', 'Let''s job! :)', '2019-09-04', '08:00:00', '2019-09-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190904T110000Z', '', '#dbadff', '', ''), 
(10160, 'Work time', 'Let''s job! :)', '2019-09-05', '08:00:00', '2019-09-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190905T110000Z', '', '#dbadff', '', ''), 
(10161, 'Work time', 'Let''s job! :)', '2019-09-09', '08:00:00', '2019-09-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190909T110000Z', '', '#dbadff', '', ''), 
(10162, 'Hobbie time', 'shhhh...It''s a secret!', '2019-09-11', null, '2019-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20190911', '', '#7ae7bf', '', ''), 
(10163, 'Work time', 'Let''s job! :)', '2019-09-11', '08:00:00', '2019-09-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190911T110000Z', '', '#dbadff', '', ''), 
(10164, 'Work time', 'Let''s job! :)', '2019-09-12', '08:00:00', '2019-09-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190912T110000Z', '', '#dbadff', '', ''), 
(10165, 'Resting...', 'I''m...nevermind', '2019-09-16', null, '2019-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20190916', '', '#e1e1e1', '', ''), 
(10166, 'Work time', 'Let''s job! :)', '2019-09-16', '08:00:00', '2019-09-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190916T110000Z', '', '#dbadff', '', ''), 
(10167, 'Work time', 'Let''s job! :)', '2019-09-18', '08:00:00', '2019-09-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190918T110000Z', '', '#dbadff', '', ''), 
(10168, 'Work time', 'Let''s job! :)', '2019-09-19', '08:00:00', '2019-09-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190919T110000Z', '', '#dbadff', '', ''), 
(10169, 'Work time', 'Let''s job! :)', '2019-09-23', '08:00:00', '2019-09-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190923T110000Z', '', '#dbadff', '', ''), 
(10170, 'Work time', 'Let''s job! :)', '2019-09-25', '08:00:00', '2019-09-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190925T110000Z', '', '#dbadff', '', ''), 
(10171, 'Work time', 'Let''s job! :)', '2019-09-26', '08:00:00', '2019-09-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190926T110000Z', '', '#dbadff', '', ''), 
(10172, 'Yellow day', 'Are you ready?', '2019-09-28', null, '2019-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20190928', '', '#fbd75b', '', ''), 
(10173, 'Work time', 'Let''s job! :)', '2019-09-30', '08:00:00', '2019-09-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20190930T110000Z', '', '#dbadff', '', ''), 
(10174, 'Day 1', 'Starting activities..', '2019-10-01', '10:00:00', '2019-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20191001T130000Z', '', '#ff887c', '', ''), 
(10175, 'Work time', 'Let''s job! :)', '2019-10-02', '08:00:00', '2019-10-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191002T110000Z', '', '#dbadff', '', ''), 
(10176, 'Work time', 'Let''s job! :)', '2019-10-03', '08:00:00', '2019-10-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191003T110000Z', '', '#dbadff', '', ''), 
(10177, 'Work time', 'Let''s job! :)', '2019-10-07', '08:00:00', '2019-10-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191007T110000Z', '', '#dbadff', '', ''), 
(10178, 'Work time', 'Let''s job! :)', '2019-10-09', '08:00:00', '2019-10-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191009T110000Z', '', '#dbadff', '', ''), 
(10179, 'Work time', 'Let''s job! :)', '2019-10-10', '08:00:00', '2019-10-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191010T110000Z', '', '#dbadff', '', ''), 
(10180, 'Hobbie time', 'shhhh...It''s a secret!', '2019-10-11', null, '2019-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20191011', '', '#7ae7bf', '', ''), 
(10181, 'Work time', 'Let''s job! :)', '2019-10-14', '08:00:00', '2019-10-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191014T110000Z', '', '#dbadff', '', ''), 
(10182, 'Resting...', 'I''m...nevermind', '2019-10-16', null, '2019-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20191016', '', '#e1e1e1', '', ''), 
(10183, 'Work time', 'Let''s job! :)', '2019-10-16', '08:00:00', '2019-10-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191016T110000Z', '', '#dbadff', '', ''), 
(10184, 'Work time', 'Let''s job! :)', '2019-10-17', '08:00:00', '2019-10-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191017T110000Z', '', '#dbadff', '', ''), 
(10185, 'Work time', 'Let''s job! :)', '2019-10-21', '08:00:00', '2019-10-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191021T110000Z', '', '#dbadff', '', ''), 
(10186, 'Work time', 'Let''s job! :)', '2019-10-23', '08:00:00', '2019-10-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191023T110000Z', '', '#dbadff', '', ''), 
(10187, 'Work time', 'Let''s job! :)', '2019-10-24', '08:00:00', '2019-10-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191024T110000Z', '', '#dbadff', '', ''), 
(10188, 'Yellow day', 'Are you ready?', '2019-10-28', null, '2019-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20191028', '', '#fbd75b', '', ''), 
(10189, 'Work time', 'Let''s job! :)', '2019-10-28', '08:00:00', '2019-10-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191028T110000Z', '', '#dbadff', '', ''), 
(10190, 'Work time', 'Let''s job! :)', '2019-10-30', '08:00:00', '2019-10-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191030T110000Z', '', '#dbadff', '', ''), 
(10191, 'Work time', 'Let''s job! :)', '2019-10-31', '08:00:00', '2019-10-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191031T110000Z', '', '#dbadff', '', ''), 
(10192, 'Day 1', 'Starting activities..', '2019-11-01', '10:00:00', '2019-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20191101T130000Z', '', '#ff887c', '', ''), 
(10193, 'Work time', 'Let''s job! :)', '2019-11-04', '08:00:00', '2019-11-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191104T110000Z', '', '#dbadff', '', ''), 
(10194, 'Work time', 'Let''s job! :)', '2019-11-06', '08:00:00', '2019-11-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191106T110000Z', '', '#dbadff', '', ''), 
(10195, 'Work time', 'Let''s job! :)', '2019-11-07', '08:00:00', '2019-11-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191107T110000Z', '', '#dbadff', '', ''), 
(10196, 'Hobbie time', 'shhhh...It''s a secret!', '2019-11-11', null, '2019-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20191111', '', '#7ae7bf', '', ''), 
(10197, 'Work time', 'Let''s job! :)', '2019-11-11', '08:00:00', '2019-11-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191111T110000Z', '', '#dbadff', '', ''), 
(10198, 'Work time', 'Let''s job! :)', '2019-11-13', '08:00:00', '2019-11-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191113T110000Z', '', '#dbadff', '', ''), 
(10199, 'Work time', 'Let''s job! :)', '2019-11-14', '08:00:00', '2019-11-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191114T110000Z', '', '#dbadff', '', ''), 
(10200, 'Resting...', 'I''m...nevermind', '2019-11-16', null, '2019-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20191116', '', '#e1e1e1', '', ''), 
(10201, 'Work time', 'Let''s job! :)', '2019-11-18', '08:00:00', '2019-11-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191118T110000Z', '', '#dbadff', '', ''), 
(10202, 'Work time', 'Let''s job! :)', '2019-11-20', '08:00:00', '2019-11-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191120T110000Z', '', '#dbadff', '', ''), 
(10203, 'Work time', 'Let''s job! :)', '2019-11-21', '08:00:00', '2019-11-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191121T110000Z', '', '#dbadff', '', ''), 
(10204, 'Work time', 'Let''s job! :)', '2019-11-25', '08:00:00', '2019-11-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191125T110000Z', '', '#dbadff', '', ''), 
(10205, 'Work time', 'Let''s job! :)', '2019-11-27', '08:00:00', '2019-11-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191127T110000Z', '', '#dbadff', '', ''), 
(10206, 'Yellow day', 'Are you ready?', '2019-11-28', null, '2019-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20191128', '', '#fbd75b', '', ''), 
(10207, 'Work time', 'Let''s job! :)', '2019-11-28', '08:00:00', '2019-11-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191128T110000Z', '', '#dbadff', '', ''), 
(10208, 'Day 1', 'Starting activities..', '2019-12-01', '10:00:00', '2019-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20191201T130000Z', '', '#ff887c', '', ''), 
(10209, 'Work time', 'Let''s job! :)', '2019-12-02', '08:00:00', '2019-12-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191202T110000Z', '', '#dbadff', '', ''), 
(10210, 'Work time', 'Let''s job! :)', '2019-12-04', '08:00:00', '2019-12-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191204T110000Z', '', '#dbadff', '', ''), 
(10211, 'Work time', 'Let''s job! :)', '2019-12-05', '08:00:00', '2019-12-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191205T110000Z', '', '#dbadff', '', ''), 
(10212, 'Work time', 'Let''s job! :)', '2019-12-09', '08:00:00', '2019-12-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191209T110000Z', '', '#dbadff', '', ''), 
(10213, 'Hobbie time', 'shhhh...It''s a secret!', '2019-12-11', null, '2019-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20191211', '', '#7ae7bf', '', ''), 
(10214, 'Work time', 'Let''s job! :)', '2019-12-11', '08:00:00', '2019-12-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191211T110000Z', '', '#dbadff', '', ''), 
(10215, 'Work time', 'Let''s job! :)', '2019-12-12', '08:00:00', '2019-12-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191212T110000Z', '', '#dbadff', '', ''), 
(10216, 'Resting...', 'I''m...nevermind', '2019-12-16', null, '2019-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20191216', '', '#e1e1e1', '', ''), 
(10217, 'Work time', 'Let''s job! :)', '2019-12-16', '08:00:00', '2019-12-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191216T110000Z', '', '#dbadff', '', ''), 
(10218, 'Work time', 'Let''s job! :)', '2019-12-18', '08:00:00', '2019-12-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191218T110000Z', '', '#dbadff', '', ''), 
(10219, 'Work time', 'Let''s job! :)', '2019-12-19', '08:00:00', '2019-12-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191219T110000Z', '', '#dbadff', '', ''), 
(10220, 'Work time', 'Let''s job! :)', '2019-12-23', '08:00:00', '2019-12-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191223T110000Z', '', '#dbadff', '', ''), 
(10221, 'Work time', 'Let''s job! :)', '2019-12-25', '08:00:00', '2019-12-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191225T110000Z', '', '#dbadff', '', ''), 
(10222, 'Work time', 'Let''s job! :)', '2019-12-26', '08:00:00', '2019-12-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191226T110000Z', '', '#dbadff', '', ''), 
(10223, 'Yellow day', 'Are you ready?', '2019-12-28', null, '2019-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20191228', '', '#fbd75b', '', ''), 
(10224, 'Work time', 'Let''s job! :)', '2019-12-30', '08:00:00', '2019-12-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20191230T110000Z', '', '#dbadff', '', ''), 
(10225, 'Work time', 'Let''s job! :)', '2020-01-01', '08:00:00', '2020-01-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200101T110000Z', '', '#dbadff', '', ''), 
(10226, 'Day 1', 'Starting activities..', '2020-01-01', '10:00:00', '2020-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200101T130000Z', '', '#ff887c', '', ''), 
(10227, 'Work time', 'Let''s job! :)', '2020-01-02', '08:00:00', '2020-01-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200102T110000Z', '', '#dbadff', '', ''), 
(10228, 'Work time', 'Let''s job! :)', '2020-01-06', '08:00:00', '2020-01-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200106T110000Z', '', '#dbadff', '', ''), 
(10229, 'Work time', 'Let''s job! :)', '2020-01-08', '08:00:00', '2020-01-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200108T110000Z', '', '#dbadff', '', ''), 
(10230, 'Work time', 'Let''s job! :)', '2020-01-09', '08:00:00', '2020-01-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200109T110000Z', '', '#dbadff', '', ''), 
(10231, 'Hobbie time', 'shhhh...It''s a secret!', '2020-01-11', null, '2020-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200111', '', '#7ae7bf', '', ''), 
(10232, 'Work time', 'Let''s job! :)', '2020-01-13', '08:00:00', '2020-01-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200113T110000Z', '', '#dbadff', '', ''), 
(10233, 'Work time', 'Let''s job! :)', '2020-01-15', '08:00:00', '2020-01-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200115T110000Z', '', '#dbadff', '', ''), 
(10234, 'Resting...', 'I''m...nevermind', '2020-01-16', null, '2020-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200116', '', '#e1e1e1', '', ''), 
(10235, 'Work time', 'Let''s job! :)', '2020-01-16', '08:00:00', '2020-01-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200116T110000Z', '', '#dbadff', '', ''), 
(10236, 'Work time', 'Let''s job! :)', '2020-01-20', '08:00:00', '2020-01-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200120T110000Z', '', '#dbadff', '', ''), 
(10237, 'Work time', 'Let''s job! :)', '2020-01-22', '08:00:00', '2020-01-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200122T110000Z', '', '#dbadff', '', ''), 
(10238, 'Work time', 'Let''s job! :)', '2020-01-23', '08:00:00', '2020-01-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200123T110000Z', '', '#dbadff', '', ''), 
(10239, 'Work time', 'Let''s job! :)', '2020-01-27', '08:00:00', '2020-01-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200127T110000Z', '', '#dbadff', '', ''), 
(10240, 'Yellow day', 'Are you ready?', '2020-01-28', null, '2020-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200128', '', '#fbd75b', '', ''), 
(10241, 'Work time', 'Let''s job! :)', '2020-01-29', '08:00:00', '2020-01-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200129T110000Z', '', '#dbadff', '', ''), 
(10242, 'Work time', 'Let''s job! :)', '2020-01-30', '08:00:00', '2020-01-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200130T110000Z', '', '#dbadff', '', ''), 
(10243, 'Day 1', 'Starting activities..', '2020-02-01', '10:00:00', '2020-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200201T130000Z', '', '#ff887c', '', ''), 
(10244, 'Work time', 'Let''s job! :)', '2020-02-03', '08:00:00', '2020-02-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200203T110000Z', '', '#dbadff', '', '');

INSERT INTO `new_calendar` VALUES 
(10245, 'Work time', 'Let''s job! :)', '2020-02-05', '08:00:00', '2020-02-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200205T110000Z', '', '#dbadff', '', ''), 
(10246, 'Work time', 'Let''s job! :)', '2020-02-06', '08:00:00', '2020-02-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200206T110000Z', '', '#dbadff', '', ''), 
(10247, 'Work time', 'Let''s job! :)', '2020-02-10', '08:00:00', '2020-02-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200210T110000Z', '', '#dbadff', '', ''), 
(10248, 'Hobbie time', 'shhhh...It''s a secret!', '2020-02-11', null, '2020-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200211', '', '#7ae7bf', '', ''), 
(10249, 'Work time', 'Let''s job! :)', '2020-02-12', '08:00:00', '2020-02-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200212T110000Z', '', '#dbadff', '', ''), 
(10250, 'Work time', 'Let''s job! :)', '2020-02-13', '08:00:00', '2020-02-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200213T110000Z', '', '#dbadff', '', ''), 
(10251, 'Resting...', 'I''m...nevermind', '2020-02-16', null, '2020-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200216', '', '#e1e1e1', '', ''), 
(10252, 'Work time', 'Let''s job! :)', '2020-02-17', '08:00:00', '2020-02-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200217T110000Z', '', '#dbadff', '', ''), 
(10253, 'Work time', 'Let''s job! :)', '2020-02-19', '08:00:00', '2020-02-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200219T110000Z', '', '#dbadff', '', ''), 
(10254, 'Work time', 'Let''s job! :)', '2020-02-20', '08:00:00', '2020-02-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200220T110000Z', '', '#dbadff', '', ''), 
(10255, 'Work time', 'Let''s job! :)', '2020-02-24', '08:00:00', '2020-02-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200224T110000Z', '', '#dbadff', '', ''), 
(10256, 'Work time', 'Let''s job! :)', '2020-02-26', '08:00:00', '2020-02-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200226T110000Z', '', '#dbadff', '', ''), 
(10257, 'Work time', 'Let''s job! :)', '2020-02-27', '08:00:00', '2020-02-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200227T110000Z', '', '#dbadff', '', ''), 
(10258, 'Yellow day', 'Are you ready?', '2020-02-28', null, '2020-02-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200228', '', '#fbd75b', '', ''), 
(10259, 'Day 1', 'Starting activities..', '2020-03-01', '10:00:00', '2020-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200301T130000Z', '', '#ff887c', '', ''), 
(10260, 'Work time', 'Let''s job! :)', '2020-03-02', '08:00:00', '2020-03-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200302T110000Z', '', '#dbadff', '', ''), 
(10261, 'Work time', 'Let''s job! :)', '2020-03-04', '08:00:00', '2020-03-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200304T110000Z', '', '#dbadff', '', ''), 
(10262, 'Work time', 'Let''s job! :)', '2020-03-05', '08:00:00', '2020-03-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200305T110000Z', '', '#dbadff', '', ''), 
(10263, 'Work time', 'Let''s job! :)', '2020-03-09', '08:00:00', '2020-03-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200309T110000Z', '', '#dbadff', '', ''), 
(10264, 'Hobbie time', 'shhhh...It''s a secret!', '2020-03-11', null, '2020-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200311', '', '#7ae7bf', '', ''), 
(10265, 'Work time', 'Let''s job! :)', '2020-03-11', '08:00:00', '2020-03-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200311T110000Z', '', '#dbadff', '', ''), 
(10266, 'Work time', 'Let''s job! :)', '2020-03-12', '08:00:00', '2020-03-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200312T110000Z', '', '#dbadff', '', ''), 
(10267, 'Resting...', 'I''m...nevermind', '2020-03-16', null, '2020-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200316', '', '#e1e1e1', '', ''), 
(10268, 'Work time', 'Let''s job! :)', '2020-03-16', '08:00:00', '2020-03-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200316T110000Z', '', '#dbadff', '', ''), 
(10269, 'Work time', 'Let''s job! :)', '2020-03-18', '08:00:00', '2020-03-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200318T110000Z', '', '#dbadff', '', ''), 
(10270, 'Work time', 'Let''s job! :)', '2020-03-19', '08:00:00', '2020-03-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200319T110000Z', '', '#dbadff', '', ''), 
(10271, 'Work time', 'Let''s job! :)', '2020-03-23', '08:00:00', '2020-03-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200323T110000Z', '', '#dbadff', '', ''), 
(10272, 'Work time', 'Let''s job! :)', '2020-03-25', '08:00:00', '2020-03-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200325T110000Z', '', '#dbadff', '', ''), 
(10273, 'Work time', 'Let''s job! :)', '2020-03-26', '08:00:00', '2020-03-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200326T110000Z', '', '#dbadff', '', ''), 
(10274, 'Yellow day', 'Are you ready?', '2020-03-28', null, '2020-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200328', '', '#fbd75b', '', ''), 
(10275, 'Work time', 'Let''s job! :)', '2020-03-30', '08:00:00', '2020-03-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200330T110000Z', '', '#dbadff', '', ''), 
(10276, 'Work time', 'Let''s job! :)', '2020-04-01', '08:00:00', '2020-04-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200401T110000Z', '', '#dbadff', '', ''), 
(10277, 'Day 1', 'Starting activities..', '2020-04-01', '10:00:00', '2020-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200401T130000Z', '', '#ff887c', '', ''), 
(10278, 'Work time', 'Let''s job! :)', '2020-04-02', '08:00:00', '2020-04-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200402T110000Z', '', '#dbadff', '', ''), 
(10279, 'Work time', 'Let''s job! :)', '2020-04-06', '08:00:00', '2020-04-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200406T110000Z', '', '#dbadff', '', ''), 
(10280, 'Work time', 'Let''s job! :)', '2020-04-08', '08:00:00', '2020-04-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200408T110000Z', '', '#dbadff', '', ''), 
(10281, 'Work time', 'Let''s job! :)', '2020-04-09', '08:00:00', '2020-04-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200409T110000Z', '', '#dbadff', '', ''), 
(10282, 'Hobbie time', 'shhhh...It''s a secret!', '2020-04-11', null, '2020-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200411', '', '#7ae7bf', '', ''), 
(10283, 'Work time', 'Let''s job! :)', '2020-04-13', '08:00:00', '2020-04-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200413T110000Z', '', '#dbadff', '', ''), 
(10284, 'Work time', 'Let''s job! :)', '2020-04-15', '08:00:00', '2020-04-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200415T110000Z', '', '#dbadff', '', ''), 
(10285, 'Resting...', 'I''m...nevermind', '2020-04-16', null, '2020-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200416', '', '#e1e1e1', '', ''), 
(10286, 'Work time', 'Let''s job! :)', '2020-04-16', '08:00:00', '2020-04-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200416T110000Z', '', '#dbadff', '', ''), 
(10287, 'Work time', 'Let''s job! :)', '2020-04-20', '08:00:00', '2020-04-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200420T110000Z', '', '#dbadff', '', ''), 
(10288, 'Work time', 'Let''s job! :)', '2020-04-22', '08:00:00', '2020-04-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200422T110000Z', '', '#dbadff', '', ''), 
(10289, 'Work time', 'Let''s job! :)', '2020-04-23', '08:00:00', '2020-04-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200423T110000Z', '', '#dbadff', '', ''), 
(10290, 'Work time', 'Let''s job! :)', '2020-04-27', '08:00:00', '2020-04-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200427T110000Z', '', '#dbadff', '', ''), 
(10291, 'Yellow day', 'Are you ready?', '2020-04-28', null, '2020-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200428', '', '#fbd75b', '', ''), 
(10292, 'Work time', 'Let''s job! :)', '2020-04-29', '08:00:00', '2020-04-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200429T110000Z', '', '#dbadff', '', ''), 
(10293, 'Work time', 'Let''s job! :)', '2020-04-30', '08:00:00', '2020-04-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200430T110000Z', '', '#dbadff', '', ''), 
(10294, 'Day 1', 'Starting activities..', '2020-05-01', '10:00:00', '2020-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200501T130000Z', '', '#ff887c', '', ''), 
(10295, 'Work time', 'Let''s job! :)', '2020-05-04', '08:00:00', '2020-05-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200504T110000Z', '', '#dbadff', '', ''), 
(10296, 'Work time', 'Let''s job! :)', '2020-05-06', '08:00:00', '2020-05-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200506T110000Z', '', '#dbadff', '', ''), 
(10297, 'Work time', 'Let''s job! :)', '2020-05-07', '08:00:00', '2020-05-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200507T110000Z', '', '#dbadff', '', ''), 
(10298, 'Hobbie time', 'shhhh...It''s a secret!', '2020-05-11', null, '2020-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200511', '', '#7ae7bf', '', ''), 
(10299, 'Work time', 'Let''s job! :)', '2020-05-11', '08:00:00', '2020-05-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200511T110000Z', '', '#dbadff', '', ''), 
(10300, 'Work time', 'Let''s job! :)', '2020-05-13', '08:00:00', '2020-05-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200513T110000Z', '', '#dbadff', '', ''), 
(10301, 'Work time', 'Let''s job! :)', '2020-05-14', '08:00:00', '2020-05-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200514T110000Z', '', '#dbadff', '', ''), 
(10302, 'Resting...', 'I''m...nevermind', '2020-05-16', null, '2020-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200516', '', '#e1e1e1', '', ''), 
(10303, 'Work time', 'Let''s job! :)', '2020-05-18', '08:00:00', '2020-05-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200518T110000Z', '', '#dbadff', '', ''), 
(10304, 'Work time', 'Let''s job! :)', '2020-05-20', '08:00:00', '2020-05-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200520T110000Z', '', '#dbadff', '', ''), 
(10305, 'Work time', 'Let''s job! :)', '2020-05-21', '08:00:00', '2020-05-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200521T110000Z', '', '#dbadff', '', ''), 
(10306, 'Work time', 'Let''s job! :)', '2020-05-25', '08:00:00', '2020-05-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200525T110000Z', '', '#dbadff', '', ''), 
(10307, 'Work time', 'Let''s job! :)', '2020-05-27', '08:00:00', '2020-05-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200527T110000Z', '', '#dbadff', '', ''), 
(10308, 'Yellow day', 'Are you ready?', '2020-05-28', null, '2020-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200528', '', '#fbd75b', '', ''), 
(10309, 'Work time', 'Let''s job! :)', '2020-05-28', '08:00:00', '2020-05-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200528T110000Z', '', '#dbadff', '', ''), 
(10310, 'Work time', 'Let''s job! :)', '2020-06-01', '08:00:00', '2020-06-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200601T110000Z', '', '#dbadff', '', ''), 
(10311, 'Day 1', 'Starting activities..', '2020-06-01', '10:00:00', '2020-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200601T130000Z', '', '#ff887c', '', ''), 
(10312, 'Work time', 'Let''s job! :)', '2020-06-03', '08:00:00', '2020-06-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200603T110000Z', '', '#dbadff', '', ''), 
(10313, 'Work time', 'Let''s job! :)', '2020-06-04', '08:00:00', '2020-06-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200604T110000Z', '', '#dbadff', '', ''), 
(10314, 'Work time', 'Let''s job! :)', '2020-06-08', '08:00:00', '2020-06-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200608T110000Z', '', '#dbadff', '', ''), 
(10315, 'Work time', 'Let''s job! :)', '2020-06-10', '08:00:00', '2020-06-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200610T110000Z', '', '#dbadff', '', ''), 
(10316, 'Hobbie time', 'shhhh...It''s a secret!', '2020-06-11', null, '2020-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200611', '', '#7ae7bf', '', ''), 
(10317, 'Work time', 'Let''s job! :)', '2020-06-11', '08:00:00', '2020-06-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200611T110000Z', '', '#dbadff', '', ''), 
(10318, 'Work time', 'Let''s job! :)', '2020-06-15', '08:00:00', '2020-06-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200615T110000Z', '', '#dbadff', '', ''), 
(10319, 'Resting...', 'I''m...nevermind', '2020-06-16', null, '2020-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200616', '', '#e1e1e1', '', ''), 
(10320, 'Work time', 'Let''s job! :)', '2020-06-17', '08:00:00', '2020-06-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200617T110000Z', '', '#dbadff', '', ''), 
(10321, 'Work time', 'Let''s job! :)', '2020-06-18', '08:00:00', '2020-06-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200618T110000Z', '', '#dbadff', '', ''), 
(10322, 'Work time', 'Let''s job! :)', '2020-06-22', '08:00:00', '2020-06-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200622T110000Z', '', '#dbadff', '', ''), 
(10323, 'Work time', 'Let''s job! :)', '2020-06-24', '08:00:00', '2020-06-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200624T110000Z', '', '#dbadff', '', ''), 
(10324, 'Work time', 'Let''s job! :)', '2020-06-25', '08:00:00', '2020-06-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200625T110000Z', '', '#dbadff', '', ''), 
(10325, 'Yellow day', 'Are you ready?', '2020-06-28', null, '2020-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200628', '', '#fbd75b', '', ''), 
(10326, 'Work time', 'Let''s job! :)', '2020-06-29', '08:00:00', '2020-06-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200629T110000Z', '', '#dbadff', '', ''), 
(10327, 'Work time', 'Let''s job! :)', '2020-07-01', '08:00:00', '2020-07-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200701T110000Z', '', '#dbadff', '', ''), 
(10328, 'Day 1', 'Starting activities..', '2020-07-01', '10:00:00', '2020-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200701T130000Z', '', '#ff887c', '', ''), 
(10329, 'Work time', 'Let''s job! :)', '2020-07-02', '08:00:00', '2020-07-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200702T110000Z', '', '#dbadff', '', ''), 
(10330, 'Work time', 'Let''s job! :)', '2020-07-06', '08:00:00', '2020-07-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200706T110000Z', '', '#dbadff', '', ''), 
(10331, 'Work time', 'Let''s job! :)', '2020-07-08', '08:00:00', '2020-07-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200708T110000Z', '', '#dbadff', '', ''), 
(10332, 'Work time', 'Let''s job! :)', '2020-07-09', '08:00:00', '2020-07-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200709T110000Z', '', '#dbadff', '', ''), 
(10333, 'Hobbie time', 'shhhh...It''s a secret!', '2020-07-11', null, '2020-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200711', '', '#7ae7bf', '', ''), 
(10334, 'Work time', 'Let''s job! :)', '2020-07-13', '08:00:00', '2020-07-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200713T110000Z', '', '#dbadff', '', ''), 
(10335, 'Work time', 'Let''s job! :)', '2020-07-15', '08:00:00', '2020-07-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200715T110000Z', '', '#dbadff', '', ''), 
(10336, 'Resting...', 'I''m...nevermind', '2020-07-16', null, '2020-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200716', '', '#e1e1e1', '', ''), 
(10337, 'Work time', 'Let''s job! :)', '2020-07-16', '08:00:00', '2020-07-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200716T110000Z', '', '#dbadff', '', ''), 
(10338, 'Work time', 'Let''s job! :)', '2020-07-20', '08:00:00', '2020-07-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200720T110000Z', '', '#dbadff', '', ''), 
(10339, 'Work time', 'Let''s job! :)', '2020-07-22', '08:00:00', '2020-07-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200722T110000Z', '', '#dbadff', '', ''), 
(10340, 'Work time', 'Let''s job! :)', '2020-07-23', '08:00:00', '2020-07-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200723T110000Z', '', '#dbadff', '', ''), 
(10341, 'Work time', 'Let''s job! :)', '2020-07-27', '08:00:00', '2020-07-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200727T110000Z', '', '#dbadff', '', ''), 
(10342, 'Yellow day', 'Are you ready?', '2020-07-28', null, '2020-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200728', '', '#fbd75b', '', ''), 
(10343, 'Work time', 'Let''s job! :)', '2020-07-29', '08:00:00', '2020-07-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200729T110000Z', '', '#dbadff', '', ''), 
(10344, 'Work time', 'Let''s job! :)', '2020-07-30', '08:00:00', '2020-07-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200730T110000Z', '', '#dbadff', '', ''), 
(10345, 'Day 1', 'Starting activities..', '2020-08-01', '10:00:00', '2020-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200801T130000Z', '', '#ff887c', '', '');

INSERT INTO `new_calendar` VALUES 
(10346, 'Work time', 'Let''s job! :)', '2020-08-03', '08:00:00', '2020-08-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200803T110000Z', '', '#dbadff', '', ''), 
(10347, 'Work time', 'Let''s job! :)', '2020-08-05', '08:00:00', '2020-08-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200805T110000Z', '', '#dbadff', '', ''), 
(10348, 'Work time', 'Let''s job! :)', '2020-08-06', '08:00:00', '2020-08-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200806T110000Z', '', '#dbadff', '', ''), 
(10349, 'Work time', 'Let''s job! :)', '2020-08-10', '08:00:00', '2020-08-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200810T110000Z', '', '#dbadff', '', ''), 
(10350, 'Hobbie time', 'shhhh...It''s a secret!', '2020-08-11', null, '2020-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200811', '', '#7ae7bf', '', ''), 
(10351, 'Work time', 'Let''s job! :)', '2020-08-12', '08:00:00', '2020-08-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200812T110000Z', '', '#dbadff', '', ''), 
(10352, 'Work time', 'Let''s job! :)', '2020-08-13', '08:00:00', '2020-08-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200813T110000Z', '', '#dbadff', '', ''), 
(10353, 'Resting...', 'I''m...nevermind', '2020-08-16', null, '2020-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200816', '', '#e1e1e1', '', ''), 
(10354, 'Work time', 'Let''s job! :)', '2020-08-17', '08:00:00', '2020-08-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200817T110000Z', '', '#dbadff', '', ''), 
(10355, 'Work time', 'Let''s job! :)', '2020-08-19', '08:00:00', '2020-08-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200819T110000Z', '', '#dbadff', '', ''), 
(10356, 'Work time', 'Let''s job! :)', '2020-08-20', '08:00:00', '2020-08-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200820T110000Z', '', '#dbadff', '', ''), 
(10357, 'Work time', 'Let''s job! :)', '2020-08-24', '08:00:00', '2020-08-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200824T110000Z', '', '#dbadff', '', ''), 
(10358, 'Work time', 'Let''s job! :)', '2020-08-26', '08:00:00', '2020-08-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200826T110000Z', '', '#dbadff', '', ''), 
(10359, 'Work time', 'Let''s job! :)', '2020-08-27', '08:00:00', '2020-08-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200827T110000Z', '', '#dbadff', '', ''), 
(10360, 'Yellow day', 'Are you ready?', '2020-08-28', null, '2020-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200828', '', '#fbd75b', '', ''), 
(10361, 'Work time', 'Let''s job! :)', '2020-08-31', '08:00:00', '2020-08-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200831T110000Z', '', '#dbadff', '', ''), 
(10362, 'Day 1', 'Starting activities..', '2020-09-01', '10:00:00', '2020-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20200901T130000Z', '', '#ff887c', '', ''), 
(10363, 'Work time', 'Let''s job! :)', '2020-09-02', '08:00:00', '2020-09-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200902T110000Z', '', '#dbadff', '', ''), 
(10364, 'Work time', 'Let''s job! :)', '2020-09-03', '08:00:00', '2020-09-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200903T110000Z', '', '#dbadff', '', ''), 
(10365, 'Work time', 'Let''s job! :)', '2020-09-07', '08:00:00', '2020-09-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200907T110000Z', '', '#dbadff', '', ''), 
(10366, 'Work time', 'Let''s job! :)', '2020-09-09', '08:00:00', '2020-09-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200909T110000Z', '', '#dbadff', '', ''), 
(10367, 'Work time', 'Let''s job! :)', '2020-09-10', '08:00:00', '2020-09-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200910T110000Z', '', '#dbadff', '', ''), 
(10368, 'Hobbie time', 'shhhh...It''s a secret!', '2020-09-11', null, '2020-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20200911', '', '#7ae7bf', '', ''), 
(10369, 'Work time', 'Let''s job! :)', '2020-09-14', '08:00:00', '2020-09-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200914T110000Z', '', '#dbadff', '', ''), 
(10370, 'Resting...', 'I''m...nevermind', '2020-09-16', null, '2020-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20200916', '', '#e1e1e1', '', ''), 
(10371, 'Work time', 'Let''s job! :)', '2020-09-16', '08:00:00', '2020-09-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200916T110000Z', '', '#dbadff', '', ''), 
(10372, 'Work time', 'Let''s job! :)', '2020-09-17', '08:00:00', '2020-09-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200917T110000Z', '', '#dbadff', '', ''), 
(10373, 'Work time', 'Let''s job! :)', '2020-09-21', '08:00:00', '2020-09-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200921T110000Z', '', '#dbadff', '', ''), 
(10374, 'Work time', 'Let''s job! :)', '2020-09-23', '08:00:00', '2020-09-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200923T110000Z', '', '#dbadff', '', ''), 
(10375, 'Work time', 'Let''s job! :)', '2020-09-24', '08:00:00', '2020-09-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200924T110000Z', '', '#dbadff', '', ''), 
(10376, 'Yellow day', 'Are you ready?', '2020-09-28', null, '2020-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20200928', '', '#fbd75b', '', ''), 
(10377, 'Work time', 'Let''s job! :)', '2020-09-28', '08:00:00', '2020-09-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200928T110000Z', '', '#dbadff', '', ''), 
(10378, 'Work time', 'Let''s job! :)', '2020-09-30', '08:00:00', '2020-09-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20200930T110000Z', '', '#dbadff', '', ''), 
(10379, 'Work time', 'Let''s job! :)', '2020-10-01', '08:00:00', '2020-10-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201001T110000Z', '', '#dbadff', '', ''), 
(10380, 'Day 1', 'Starting activities..', '2020-10-01', '10:00:00', '2020-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20201001T130000Z', '', '#ff887c', '', ''), 
(10381, 'Work time', 'Let''s job! :)', '2020-10-05', '08:00:00', '2020-10-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201005T110000Z', '', '#dbadff', '', ''), 
(10382, 'Work time', 'Let''s job! :)', '2020-10-07', '08:00:00', '2020-10-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201007T110000Z', '', '#dbadff', '', ''), 
(10383, 'Work time', 'Let''s job! :)', '2020-10-08', '08:00:00', '2020-10-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201008T110000Z', '', '#dbadff', '', ''), 
(10384, 'Hobbie time', 'shhhh...It''s a secret!', '2020-10-11', null, '2020-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20201011', '', '#7ae7bf', '', ''), 
(10385, 'Work time', 'Let''s job! :)', '2020-10-12', '08:00:00', '2020-10-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201012T110000Z', '', '#dbadff', '', ''), 
(10386, 'Work time', 'Let''s job! :)', '2020-10-14', '08:00:00', '2020-10-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201014T110000Z', '', '#dbadff', '', ''), 
(10387, 'Work time', 'Let''s job! :)', '2020-10-15', '08:00:00', '2020-10-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201015T110000Z', '', '#dbadff', '', ''), 
(10388, 'Resting...', 'I''m...nevermind', '2020-10-16', null, '2020-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20201016', '', '#e1e1e1', '', ''), 
(10389, 'Work time', 'Let''s job! :)', '2020-10-19', '08:00:00', '2020-10-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201019T110000Z', '', '#dbadff', '', ''), 
(10390, 'Work time', 'Let''s job! :)', '2020-10-21', '08:00:00', '2020-10-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201021T110000Z', '', '#dbadff', '', ''), 
(10391, 'Work time', 'Let''s job! :)', '2020-10-22', '08:00:00', '2020-10-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201022T110000Z', '', '#dbadff', '', ''), 
(10392, 'Work time', 'Let''s job! :)', '2020-10-26', '08:00:00', '2020-10-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201026T110000Z', '', '#dbadff', '', ''), 
(10393, 'Yellow day', 'Are you ready?', '2020-10-28', null, '2020-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20201028', '', '#fbd75b', '', ''), 
(10394, 'Work time', 'Let''s job! :)', '2020-10-28', '08:00:00', '2020-10-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201028T110000Z', '', '#dbadff', '', ''), 
(10395, 'Work time', 'Let''s job! :)', '2020-10-29', '08:00:00', '2020-10-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201029T110000Z', '', '#dbadff', '', ''), 
(10396, 'Day 1', 'Starting activities..', '2020-11-01', '10:00:00', '2020-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20201101T130000Z', '', '#ff887c', '', ''), 
(10397, 'Work time', 'Let''s job! :)', '2020-11-02', '08:00:00', '2020-11-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201102T110000Z', '', '#dbadff', '', ''), 
(10398, 'Work time', 'Let''s job! :)', '2020-11-04', '08:00:00', '2020-11-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201104T110000Z', '', '#dbadff', '', ''), 
(10399, 'Work time', 'Let''s job! :)', '2020-11-05', '08:00:00', '2020-11-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201105T110000Z', '', '#dbadff', '', ''), 
(10400, 'Work time', 'Let''s job! :)', '2020-11-09', '08:00:00', '2020-11-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201109T110000Z', '', '#dbadff', '', ''), 
(10401, 'Hobbie time', 'shhhh...It''s a secret!', '2020-11-11', null, '2020-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20201111', '', '#7ae7bf', '', ''), 
(10402, 'Work time', 'Let''s job! :)', '2020-11-11', '08:00:00', '2020-11-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201111T110000Z', '', '#dbadff', '', ''), 
(10403, 'Work time', 'Let''s job! :)', '2020-11-12', '08:00:00', '2020-11-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201112T110000Z', '', '#dbadff', '', ''), 
(10404, 'Resting...', 'I''m...nevermind', '2020-11-16', null, '2020-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20201116', '', '#e1e1e1', '', ''), 
(10405, 'Work time', 'Let''s job! :)', '2020-11-16', '08:00:00', '2020-11-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201116T110000Z', '', '#dbadff', '', ''), 
(10406, 'Work time', 'Let''s job! :)', '2020-11-18', '08:00:00', '2020-11-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201118T110000Z', '', '#dbadff', '', ''), 
(10407, 'Work time', 'Let''s job! :)', '2020-11-19', '08:00:00', '2020-11-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201119T110000Z', '', '#dbadff', '', ''), 
(10408, 'Work time', 'Let''s job! :)', '2020-11-23', '08:00:00', '2020-11-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201123T110000Z', '', '#dbadff', '', ''), 
(10409, 'Work time', 'Let''s job! :)', '2020-11-25', '08:00:00', '2020-11-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201125T110000Z', '', '#dbadff', '', ''), 
(10410, 'Work time', 'Let''s job! :)', '2020-11-26', '08:00:00', '2020-11-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201126T110000Z', '', '#dbadff', '', ''), 
(10411, 'Yellow day', 'Are you ready?', '2020-11-28', null, '2020-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20201128', '', '#fbd75b', '', ''), 
(10412, 'Work time', 'Let''s job! :)', '2020-11-30', '08:00:00', '2020-11-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201130T110000Z', '', '#dbadff', '', ''), 
(10413, 'Day 1', 'Starting activities..', '2020-12-01', '10:00:00', '2020-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20201201T130000Z', '', '#ff887c', '', ''), 
(10414, 'Work time', 'Let''s job! :)', '2020-12-02', '08:00:00', '2020-12-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201202T110000Z', '', '#dbadff', '', ''), 
(10415, 'Work time', 'Let''s job! :)', '2020-12-03', '08:00:00', '2020-12-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201203T110000Z', '', '#dbadff', '', ''), 
(10416, 'Work time', 'Let''s job! :)', '2020-12-07', '08:00:00', '2020-12-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201207T110000Z', '', '#dbadff', '', ''), 
(10417, 'Work time', 'Let''s job! :)', '2020-12-09', '08:00:00', '2020-12-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201209T110000Z', '', '#dbadff', '', ''), 
(10418, 'Work time', 'Let''s job! :)', '2020-12-10', '08:00:00', '2020-12-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201210T110000Z', '', '#dbadff', '', ''), 
(10419, 'Hobbie time', 'shhhh...It''s a secret!', '2020-12-11', null, '2020-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20201211', '', '#7ae7bf', '', ''), 
(10420, 'Work time', 'Let''s job! :)', '2020-12-14', '08:00:00', '2020-12-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201214T110000Z', '', '#dbadff', '', ''), 
(10421, 'Resting...', 'I''m...nevermind', '2020-12-16', null, '2020-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20201216', '', '#e1e1e1', '', ''), 
(10422, 'Work time', 'Let''s job! :)', '2020-12-16', '08:00:00', '2020-12-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201216T110000Z', '', '#dbadff', '', ''), 
(10423, 'Work time', 'Let''s job! :)', '2020-12-17', '08:00:00', '2020-12-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201217T110000Z', '', '#dbadff', '', ''), 
(10424, 'Work time', 'Let''s job! :)', '2020-12-21', '08:00:00', '2020-12-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201221T110000Z', '', '#dbadff', '', ''), 
(10425, 'Work time', 'Let''s job! :)', '2020-12-23', '08:00:00', '2020-12-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201223T110000Z', '', '#dbadff', '', ''), 
(10426, 'Work time', 'Let''s job! :)', '2020-12-24', '08:00:00', '2020-12-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201224T110000Z', '', '#dbadff', '', ''), 
(10427, 'Yellow day', 'Are you ready?', '2020-12-28', null, '2020-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20201228', '', '#fbd75b', '', ''), 
(10428, 'Work time', 'Let''s job! :)', '2020-12-28', '08:00:00', '2020-12-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201228T110000Z', '', '#dbadff', '', ''), 
(10429, 'Work time', 'Let''s job! :)', '2020-12-30', '08:00:00', '2020-12-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201230T110000Z', '', '#dbadff', '', ''), 
(10430, 'Work time', 'Let''s job! :)', '2020-12-31', '08:00:00', '2020-12-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20201231T110000Z', '', '#dbadff', '', ''), 
(10431, 'Day 1', 'Starting activities..', '2021-01-01', '10:00:00', '2021-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210101T130000Z', '', '#ff887c', '', ''), 
(10432, 'Work time', 'Let''s job! :)', '2021-01-04', '08:00:00', '2021-01-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210104T110000Z', '', '#dbadff', '', ''), 
(10433, 'Work time', 'Let''s job! :)', '2021-01-06', '08:00:00', '2021-01-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210106T110000Z', '', '#dbadff', '', ''), 
(10434, 'Work time', 'Let''s job! :)', '2021-01-07', '08:00:00', '2021-01-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210107T110000Z', '', '#dbadff', '', ''), 
(10435, 'Hobbie time', 'shhhh...It''s a secret!', '2021-01-11', null, '2021-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210111', '', '#7ae7bf', '', ''), 
(10436, 'Work time', 'Let''s job! :)', '2021-01-11', '08:00:00', '2021-01-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210111T110000Z', '', '#dbadff', '', ''), 
(10437, 'Work time', 'Let''s job! :)', '2021-01-13', '08:00:00', '2021-01-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210113T110000Z', '', '#dbadff', '', ''), 
(10438, 'Work time', 'Let''s job! :)', '2021-01-14', '08:00:00', '2021-01-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210114T110000Z', '', '#dbadff', '', ''), 
(10439, 'Resting...', 'I''m...nevermind', '2021-01-16', null, '2021-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210116', '', '#e1e1e1', '', ''), 
(10440, 'Work time', 'Let''s job! :)', '2021-01-18', '08:00:00', '2021-01-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210118T110000Z', '', '#dbadff', '', ''), 
(10441, 'Work time', 'Let''s job! :)', '2021-01-20', '08:00:00', '2021-01-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210120T110000Z', '', '#dbadff', '', ''), 
(10442, 'Work time', 'Let''s job! :)', '2021-01-21', '08:00:00', '2021-01-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210121T110000Z', '', '#dbadff', '', ''), 
(10443, 'Work time', 'Let''s job! :)', '2021-01-25', '08:00:00', '2021-01-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210125T110000Z', '', '#dbadff', '', ''), 
(10444, 'Work time', 'Let''s job! :)', '2021-01-27', '08:00:00', '2021-01-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210127T110000Z', '', '#dbadff', '', ''), 
(10445, 'Yellow day', 'Are you ready?', '2021-01-28', null, '2021-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210128', '', '#fbd75b', '', ''), 
(10446, 'Work time', 'Let''s job! :)', '2021-01-28', '08:00:00', '2021-01-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210128T110000Z', '', '#dbadff', '', '');

INSERT INTO `new_calendar` VALUES 
(10447, 'Work time', 'Let''s job! :)', '2021-02-01', '08:00:00', '2021-02-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210201T110000Z', '', '#dbadff', '', ''), 
(10448, 'Day 1', 'Starting activities..', '2021-02-01', '10:00:00', '2021-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210201T130000Z', '', '#ff887c', '', ''), 
(10449, 'Work time', 'Let''s job! :)', '2021-02-03', '08:00:00', '2021-02-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210203T110000Z', '', '#dbadff', '', ''), 
(10450, 'Work time', 'Let''s job! :)', '2021-02-04', '08:00:00', '2021-02-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210204T110000Z', '', '#dbadff', '', ''), 
(10451, 'Work time', 'Let''s job! :)', '2021-02-08', '08:00:00', '2021-02-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210208T110000Z', '', '#dbadff', '', ''), 
(10452, 'Work time', 'Let''s job! :)', '2021-02-10', '08:00:00', '2021-02-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210210T110000Z', '', '#dbadff', '', ''), 
(10453, 'Hobbie time', 'shhhh...It''s a secret!', '2021-02-11', null, '2021-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210211', '', '#7ae7bf', '', ''), 
(10454, 'Work time', 'Let''s job! :)', '2021-02-11', '08:00:00', '2021-02-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210211T110000Z', '', '#dbadff', '', ''), 
(10455, 'Work time', 'Let''s job! :)', '2021-02-15', '08:00:00', '2021-02-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210215T110000Z', '', '#dbadff', '', ''), 
(10456, 'Resting...', 'I''m...nevermind', '2021-02-16', null, '2021-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210216', '', '#e1e1e1', '', ''), 
(10457, 'Work time', 'Let''s job! :)', '2021-02-17', '08:00:00', '2021-02-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210217T110000Z', '', '#dbadff', '', ''), 
(10458, 'Work time', 'Let''s job! :)', '2021-02-18', '08:00:00', '2021-02-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210218T110000Z', '', '#dbadff', '', ''), 
(10459, 'Work time', 'Let''s job! :)', '2021-02-22', '08:00:00', '2021-02-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210222T110000Z', '', '#dbadff', '', ''), 
(10460, 'Work time', 'Let''s job! :)', '2021-02-24', '08:00:00', '2021-02-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210224T110000Z', '', '#dbadff', '', ''), 
(10461, 'Work time', 'Let''s job! :)', '2021-02-25', '08:00:00', '2021-02-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210225T110000Z', '', '#dbadff', '', ''), 
(10462, 'Yellow day', 'Are you ready?', '2021-02-28', null, '2021-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210228', '', '#fbd75b', '', ''), 
(10463, 'Work time', 'Let''s job! :)', '2021-03-01', '08:00:00', '2021-03-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210301T110000Z', '', '#dbadff', '', ''), 
(10464, 'Day 1', 'Starting activities..', '2021-03-01', '10:00:00', '2021-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210301T130000Z', '', '#ff887c', '', ''), 
(10465, 'Work time', 'Let''s job! :)', '2021-03-03', '08:00:00', '2021-03-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210303T110000Z', '', '#dbadff', '', ''), 
(10466, 'Work time', 'Let''s job! :)', '2021-03-04', '08:00:00', '2021-03-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210304T110000Z', '', '#dbadff', '', ''), 
(10467, 'Work time', 'Let''s job! :)', '2021-03-08', '08:00:00', '2021-03-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210308T110000Z', '', '#dbadff', '', ''), 
(10468, 'Work time', 'Let''s job! :)', '2021-03-10', '08:00:00', '2021-03-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210310T110000Z', '', '#dbadff', '', ''), 
(10469, 'Hobbie time', 'shhhh...It''s a secret!', '2021-03-11', null, '2021-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210311', '', '#7ae7bf', '', ''), 
(10470, 'Work time', 'Let''s job! :)', '2021-03-11', '08:00:00', '2021-03-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210311T110000Z', '', '#dbadff', '', ''), 
(10471, 'Work time', 'Let''s job! :)', '2021-03-15', '08:00:00', '2021-03-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210315T110000Z', '', '#dbadff', '', ''), 
(10472, 'Resting...', 'I''m...nevermind', '2021-03-16', null, '2021-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210316', '', '#e1e1e1', '', ''), 
(10473, 'Work time', 'Let''s job! :)', '2021-03-17', '08:00:00', '2021-03-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210317T110000Z', '', '#dbadff', '', ''), 
(10474, 'Work time', 'Let''s job! :)', '2021-03-18', '08:00:00', '2021-03-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210318T110000Z', '', '#dbadff', '', ''), 
(10475, 'Work time', 'Let''s job! :)', '2021-03-22', '08:00:00', '2021-03-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210322T110000Z', '', '#dbadff', '', ''), 
(10476, 'Work time', 'Let''s job! :)', '2021-03-24', '08:00:00', '2021-03-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210324T110000Z', '', '#dbadff', '', ''), 
(10477, 'Work time', 'Let''s job! :)', '2021-03-25', '08:00:00', '2021-03-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210325T110000Z', '', '#dbadff', '', ''), 
(10478, 'Yellow day', 'Are you ready?', '2021-03-28', null, '2021-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210328', '', '#fbd75b', '', ''), 
(10479, 'Work time', 'Let''s job! :)', '2021-03-29', '08:00:00', '2021-03-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210329T110000Z', '', '#dbadff', '', ''), 
(10480, 'Work time', 'Let''s job! :)', '2021-03-31', '08:00:00', '2021-03-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210331T110000Z', '', '#dbadff', '', ''), 
(10481, 'Work time', 'Let''s job! :)', '2021-04-01', '08:00:00', '2021-04-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210401T110000Z', '', '#dbadff', '', ''), 
(10482, 'Day 1', 'Starting activities..', '2021-04-01', '10:00:00', '2021-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210401T130000Z', '', '#ff887c', '', ''), 
(10483, 'Work time', 'Let''s job! :)', '2021-04-05', '08:00:00', '2021-04-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210405T110000Z', '', '#dbadff', '', ''), 
(10484, 'Work time', 'Let''s job! :)', '2021-04-07', '08:00:00', '2021-04-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210407T110000Z', '', '#dbadff', '', ''), 
(10485, 'Work time', 'Let''s job! :)', '2021-04-08', '08:00:00', '2021-04-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210408T110000Z', '', '#dbadff', '', ''), 
(10486, 'Hobbie time', 'shhhh...It''s a secret!', '2021-04-11', null, '2021-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210411', '', '#7ae7bf', '', ''), 
(10487, 'Work time', 'Let''s job! :)', '2021-04-12', '08:00:00', '2021-04-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210412T110000Z', '', '#dbadff', '', ''), 
(10488, 'Work time', 'Let''s job! :)', '2021-04-14', '08:00:00', '2021-04-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210414T110000Z', '', '#dbadff', '', ''), 
(10489, 'Work time', 'Let''s job! :)', '2021-04-15', '08:00:00', '2021-04-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210415T110000Z', '', '#dbadff', '', ''), 
(10490, 'Resting...', 'I''m...nevermind', '2021-04-16', null, '2021-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210416', '', '#e1e1e1', '', ''), 
(10491, 'Work time', 'Let''s job! :)', '2021-04-19', '08:00:00', '2021-04-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210419T110000Z', '', '#dbadff', '', ''), 
(10492, 'Work time', 'Let''s job! :)', '2021-04-21', '08:00:00', '2021-04-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210421T110000Z', '', '#dbadff', '', ''), 
(10493, 'Work time', 'Let''s job! :)', '2021-04-22', '08:00:00', '2021-04-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210422T110000Z', '', '#dbadff', '', ''), 
(10494, 'Work time', 'Let''s job! :)', '2021-04-26', '08:00:00', '2021-04-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210426T110000Z', '', '#dbadff', '', ''), 
(10495, 'Yellow day', 'Are you ready?', '2021-04-28', null, '2021-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210428', '', '#fbd75b', '', ''), 
(10496, 'Work time', 'Let''s job! :)', '2021-04-28', '08:00:00', '2021-04-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210428T110000Z', '', '#dbadff', '', ''), 
(10497, 'Work time', 'Let''s job! :)', '2021-04-29', '08:00:00', '2021-04-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210429T110000Z', '', '#dbadff', '', ''), 
(10498, 'Day 1', 'Starting activities..', '2021-05-01', '10:00:00', '2021-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210501T130000Z', '', '#ff887c', '', ''), 
(10499, 'Work time', 'Let''s job! :)', '2021-05-03', '08:00:00', '2021-05-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210503T110000Z', '', '#dbadff', '', ''), 
(10500, 'Work time', 'Let''s job! :)', '2021-05-05', '08:00:00', '2021-05-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210505T110000Z', '', '#dbadff', '', ''), 
(10501, 'Work time', 'Let''s job! :)', '2021-05-06', '08:00:00', '2021-05-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210506T110000Z', '', '#dbadff', '', ''), 
(10502, 'Work time', 'Let''s job! :)', '2021-05-10', '08:00:00', '2021-05-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210510T110000Z', '', '#dbadff', '', ''), 
(10503, 'Hobbie time', 'shhhh...It''s a secret!', '2021-05-11', null, '2021-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210511', '', '#7ae7bf', '', ''), 
(10504, 'Work time', 'Let''s job! :)', '2021-05-12', '08:00:00', '2021-05-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210512T110000Z', '', '#dbadff', '', ''), 
(10505, 'Work time', 'Let''s job! :)', '2021-05-13', '08:00:00', '2021-05-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210513T110000Z', '', '#dbadff', '', ''), 
(10506, 'Resting...', 'I''m...nevermind', '2021-05-16', null, '2021-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210516', '', '#e1e1e1', '', ''), 
(10507, 'Work time', 'Let''s job! :)', '2021-05-17', '08:00:00', '2021-05-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210517T110000Z', '', '#dbadff', '', ''), 
(10508, 'Work time', 'Let''s job! :)', '2021-05-19', '08:00:00', '2021-05-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210519T110000Z', '', '#dbadff', '', ''), 
(10509, 'Work time', 'Let''s job! :)', '2021-05-20', '08:00:00', '2021-05-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210520T110000Z', '', '#dbadff', '', ''), 
(10510, 'Work time', 'Let''s job! :)', '2021-05-24', '08:00:00', '2021-05-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210524T110000Z', '', '#dbadff', '', ''), 
(10511, 'Work time', 'Let''s job! :)', '2021-05-26', '08:00:00', '2021-05-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210526T110000Z', '', '#dbadff', '', ''), 
(10512, 'Work time', 'Let''s job! :)', '2021-05-27', '08:00:00', '2021-05-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210527T110000Z', '', '#dbadff', '', ''), 
(10513, 'Yellow day', 'Are you ready?', '2021-05-28', null, '2021-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210528', '', '#fbd75b', '', ''), 
(10514, 'Work time', 'Let''s job! :)', '2021-05-31', '08:00:00', '2021-05-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210531T110000Z', '', '#dbadff', '', ''), 
(10515, 'Day 1', 'Starting activities..', '2021-06-01', '10:00:00', '2021-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210601T130000Z', '', '#ff887c', '', ''), 
(10516, 'Work time', 'Let''s job! :)', '2021-06-02', '08:00:00', '2021-06-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210602T110000Z', '', '#dbadff', '', ''), 
(10517, 'Work time', 'Let''s job! :)', '2021-06-03', '08:00:00', '2021-06-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210603T110000Z', '', '#dbadff', '', ''), 
(10518, 'Work time', 'Let''s job! :)', '2021-06-07', '08:00:00', '2021-06-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210607T110000Z', '', '#dbadff', '', ''), 
(10519, 'Work time', 'Let''s job! :)', '2021-06-09', '08:00:00', '2021-06-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210609T110000Z', '', '#dbadff', '', ''), 
(10520, 'Work time', 'Let''s job! :)', '2021-06-10', '08:00:00', '2021-06-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210610T110000Z', '', '#dbadff', '', ''), 
(10521, 'Hobbie time', 'shhhh...It''s a secret!', '2021-06-11', null, '2021-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210611', '', '#7ae7bf', '', ''), 
(10522, 'Work time', 'Let''s job! :)', '2021-06-14', '08:00:00', '2021-06-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210614T110000Z', '', '#dbadff', '', ''), 
(10523, 'Resting...', 'I''m...nevermind', '2021-06-16', null, '2021-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210616', '', '#e1e1e1', '', ''), 
(10524, 'Work time', 'Let''s job! :)', '2021-06-16', '08:00:00', '2021-06-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210616T110000Z', '', '#dbadff', '', ''), 
(10525, 'Work time', 'Let''s job! :)', '2021-06-17', '08:00:00', '2021-06-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210617T110000Z', '', '#dbadff', '', ''), 
(10526, 'Work time', 'Let''s job! :)', '2021-06-21', '08:00:00', '2021-06-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210621T110000Z', '', '#dbadff', '', ''), 
(10527, 'Work time', 'Let''s job! :)', '2021-06-23', '08:00:00', '2021-06-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210623T110000Z', '', '#dbadff', '', ''), 
(10528, 'Work time', 'Let''s job! :)', '2021-06-24', '08:00:00', '2021-06-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210624T110000Z', '', '#dbadff', '', ''), 
(10529, 'Yellow day', 'Are you ready?', '2021-06-28', null, '2021-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210628', '', '#fbd75b', '', ''), 
(10530, 'Work time', 'Let''s job! :)', '2021-06-28', '08:00:00', '2021-06-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210628T110000Z', '', '#dbadff', '', ''), 
(10531, 'Work time', 'Let''s job! :)', '2021-06-30', '08:00:00', '2021-06-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210630T110000Z', '', '#dbadff', '', ''), 
(10532, 'Work time', 'Let''s job! :)', '2021-07-01', '08:00:00', '2021-07-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210701T110000Z', '', '#dbadff', '', ''), 
(10533, 'Day 1', 'Starting activities..', '2021-07-01', '10:00:00', '2021-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210701T130000Z', '', '#ff887c', '', ''), 
(10534, 'Work time', 'Let''s job! :)', '2021-07-05', '08:00:00', '2021-07-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210705T110000Z', '', '#dbadff', '', ''), 
(10535, 'Work time', 'Let''s job! :)', '2021-07-07', '08:00:00', '2021-07-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210707T110000Z', '', '#dbadff', '', ''), 
(10536, 'Work time', 'Let''s job! :)', '2021-07-08', '08:00:00', '2021-07-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210708T110000Z', '', '#dbadff', '', ''), 
(10537, 'Hobbie time', 'shhhh...It''s a secret!', '2021-07-11', null, '2021-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210711', '', '#7ae7bf', '', ''), 
(10538, 'Work time', 'Let''s job! :)', '2021-07-12', '08:00:00', '2021-07-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210712T110000Z', '', '#dbadff', '', ''), 
(10539, 'Work time', 'Let''s job! :)', '2021-07-14', '08:00:00', '2021-07-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210714T110000Z', '', '#dbadff', '', ''), 
(10540, 'Work time', 'Let''s job! :)', '2021-07-15', '08:00:00', '2021-07-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210715T110000Z', '', '#dbadff', '', ''), 
(10541, 'Resting...', 'I''m...nevermind', '2021-07-16', null, '2021-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210716', '', '#e1e1e1', '', ''), 
(10542, 'Work time', 'Let''s job! :)', '2021-07-19', '08:00:00', '2021-07-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210719T110000Z', '', '#dbadff', '', ''), 
(10543, 'Work time', 'Let''s job! :)', '2021-07-21', '08:00:00', '2021-07-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210721T110000Z', '', '#dbadff', '', ''), 
(10544, 'Work time', 'Let''s job! :)', '2021-07-22', '08:00:00', '2021-07-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210722T110000Z', '', '#dbadff', '', ''), 
(10545, 'Work time', 'Let''s job! :)', '2021-07-26', '08:00:00', '2021-07-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210726T110000Z', '', '#dbadff', '', ''), 
(10546, 'Yellow day', 'Are you ready?', '2021-07-28', null, '2021-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210728', '', '#fbd75b', '', ''), 
(10547, 'Work time', 'Let''s job! :)', '2021-07-28', '08:00:00', '2021-07-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210728T110000Z', '', '#dbadff', '', '');

INSERT INTO `new_calendar` VALUES 
(10548, 'Work time', 'Let''s job! :)', '2021-07-29', '08:00:00', '2021-07-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210729T110000Z', '', '#dbadff', '', ''), 
(10549, 'Day 1', 'Starting activities..', '2021-08-01', '10:00:00', '2021-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210801T130000Z', '', '#ff887c', '', ''), 
(10550, 'Work time', 'Let''s job! :)', '2021-08-02', '08:00:00', '2021-08-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210802T110000Z', '', '#dbadff', '', ''), 
(10551, 'Work time', 'Let''s job! :)', '2021-08-04', '08:00:00', '2021-08-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210804T110000Z', '', '#dbadff', '', ''), 
(10552, 'Work time', 'Let''s job! :)', '2021-08-05', '08:00:00', '2021-08-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210805T110000Z', '', '#dbadff', '', ''), 
(10553, 'Work time', 'Let''s job! :)', '2021-08-09', '08:00:00', '2021-08-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210809T110000Z', '', '#dbadff', '', ''), 
(10554, 'Hobbie time', 'shhhh...It''s a secret!', '2021-08-11', null, '2021-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210811', '', '#7ae7bf', '', ''), 
(10555, 'Work time', 'Let''s job! :)', '2021-08-11', '08:00:00', '2021-08-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210811T110000Z', '', '#dbadff', '', ''), 
(10556, 'Work time', 'Let''s job! :)', '2021-08-12', '08:00:00', '2021-08-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210812T110000Z', '', '#dbadff', '', ''), 
(10557, 'Resting...', 'I''m...nevermind', '2021-08-16', null, '2021-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210816', '', '#e1e1e1', '', ''), 
(10558, 'Work time', 'Let''s job! :)', '2021-08-16', '08:00:00', '2021-08-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210816T110000Z', '', '#dbadff', '', ''), 
(10559, 'Work time', 'Let''s job! :)', '2021-08-18', '08:00:00', '2021-08-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210818T110000Z', '', '#dbadff', '', ''), 
(10560, 'Work time', 'Let''s job! :)', '2021-08-19', '08:00:00', '2021-08-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210819T110000Z', '', '#dbadff', '', ''), 
(10561, 'Work time', 'Let''s job! :)', '2021-08-23', '08:00:00', '2021-08-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210823T110000Z', '', '#dbadff', '', ''), 
(10562, 'Work time', 'Let''s job! :)', '2021-08-25', '08:00:00', '2021-08-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210825T110000Z', '', '#dbadff', '', ''), 
(10563, 'Work time', 'Let''s job! :)', '2021-08-26', '08:00:00', '2021-08-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210826T110000Z', '', '#dbadff', '', ''), 
(10564, 'Yellow day', 'Are you ready?', '2021-08-28', null, '2021-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210828', '', '#fbd75b', '', ''), 
(10565, 'Work time', 'Let''s job! :)', '2021-08-30', '08:00:00', '2021-08-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210830T110000Z', '', '#dbadff', '', ''), 
(10566, 'Work time', 'Let''s job! :)', '2021-09-01', '08:00:00', '2021-09-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210901T110000Z', '', '#dbadff', '', ''), 
(10567, 'Day 1', 'Starting activities..', '2021-09-01', '10:00:00', '2021-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20210901T130000Z', '', '#ff887c', '', ''), 
(10568, 'Work time', 'Let''s job! :)', '2021-09-02', '08:00:00', '2021-09-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210902T110000Z', '', '#dbadff', '', ''), 
(10569, 'Work time', 'Let''s job! :)', '2021-09-06', '08:00:00', '2021-09-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210906T110000Z', '', '#dbadff', '', ''), 
(10570, 'Work time', 'Let''s job! :)', '2021-09-08', '08:00:00', '2021-09-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210908T110000Z', '', '#dbadff', '', ''), 
(10571, 'Work time', 'Let''s job! :)', '2021-09-09', '08:00:00', '2021-09-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210909T110000Z', '', '#dbadff', '', ''), 
(10572, 'Hobbie time', 'shhhh...It''s a secret!', '2021-09-11', null, '2021-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20210911', '', '#7ae7bf', '', ''), 
(10573, 'Work time', 'Let''s job! :)', '2021-09-13', '08:00:00', '2021-09-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210913T110000Z', '', '#dbadff', '', ''), 
(10574, 'Work time', 'Let''s job! :)', '2021-09-15', '08:00:00', '2021-09-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210915T110000Z', '', '#dbadff', '', ''), 
(10575, 'Resting...', 'I''m...nevermind', '2021-09-16', null, '2021-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20210916', '', '#e1e1e1', '', ''), 
(10576, 'Work time', 'Let''s job! :)', '2021-09-16', '08:00:00', '2021-09-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210916T110000Z', '', '#dbadff', '', ''), 
(10577, 'Work time', 'Let''s job! :)', '2021-09-20', '08:00:00', '2021-09-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210920T110000Z', '', '#dbadff', '', ''), 
(10578, 'Work time', 'Let''s job! :)', '2021-09-22', '08:00:00', '2021-09-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210922T110000Z', '', '#dbadff', '', ''), 
(10579, 'Work time', 'Let''s job! :)', '2021-09-23', '08:00:00', '2021-09-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210923T110000Z', '', '#dbadff', '', ''), 
(10580, 'Work time', 'Let''s job! :)', '2021-09-27', '08:00:00', '2021-09-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210927T110000Z', '', '#dbadff', '', ''), 
(10581, 'Yellow day', 'Are you ready?', '2021-09-28', null, '2021-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20210928', '', '#fbd75b', '', ''), 
(10582, 'Work time', 'Let''s job! :)', '2021-09-29', '08:00:00', '2021-09-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210929T110000Z', '', '#dbadff', '', ''), 
(10583, 'Work time', 'Let''s job! :)', '2021-09-30', '08:00:00', '2021-09-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20210930T110000Z', '', '#dbadff', '', ''), 
(10584, 'Day 1', 'Starting activities..', '2021-10-01', '10:00:00', '2021-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20211001T130000Z', '', '#ff887c', '', ''), 
(10585, 'Work time', 'Let''s job! :)', '2021-10-04', '08:00:00', '2021-10-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211004T110000Z', '', '#dbadff', '', ''), 
(10586, 'Work time', 'Let''s job! :)', '2021-10-06', '08:00:00', '2021-10-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211006T110000Z', '', '#dbadff', '', ''), 
(10587, 'Work time', 'Let''s job! :)', '2021-10-07', '08:00:00', '2021-10-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211007T110000Z', '', '#dbadff', '', ''), 
(10588, 'Hobbie time', 'shhhh...It''s a secret!', '2021-10-11', null, '2021-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20211011', '', '#7ae7bf', '', ''), 
(10589, 'Work time', 'Let''s job! :)', '2021-10-11', '08:00:00', '2021-10-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211011T110000Z', '', '#dbadff', '', ''), 
(10590, 'Work time', 'Let''s job! :)', '2021-10-13', '08:00:00', '2021-10-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211013T110000Z', '', '#dbadff', '', ''), 
(10591, 'Work time', 'Let''s job! :)', '2021-10-14', '08:00:00', '2021-10-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211014T110000Z', '', '#dbadff', '', ''), 
(10592, 'Resting...', 'I''m...nevermind', '2021-10-16', null, '2021-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20211016', '', '#e1e1e1', '', ''), 
(10593, 'Work time', 'Let''s job! :)', '2021-10-18', '08:00:00', '2021-10-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211018T110000Z', '', '#dbadff', '', ''), 
(10594, 'Work time', 'Let''s job! :)', '2021-10-20', '08:00:00', '2021-10-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211020T110000Z', '', '#dbadff', '', ''), 
(10595, 'Work time', 'Let''s job! :)', '2021-10-21', '08:00:00', '2021-10-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211021T110000Z', '', '#dbadff', '', ''), 
(10596, 'Work time', 'Let''s job! :)', '2021-10-25', '08:00:00', '2021-10-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211025T110000Z', '', '#dbadff', '', ''), 
(10597, 'Work time', 'Let''s job! :)', '2021-10-27', '08:00:00', '2021-10-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211027T110000Z', '', '#dbadff', '', ''), 
(10598, 'Yellow day', 'Are you ready?', '2021-10-28', null, '2021-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20211028', '', '#fbd75b', '', ''), 
(10599, 'Work time', 'Let''s job! :)', '2021-10-28', '08:00:00', '2021-10-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211028T110000Z', '', '#dbadff', '', ''), 
(10600, 'Work time', 'Let''s job! :)', '2021-11-01', '08:00:00', '2021-11-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211101T110000Z', '', '#dbadff', '', ''), 
(10601, 'Day 1', 'Starting activities..', '2021-11-01', '10:00:00', '2021-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20211101T130000Z', '', '#ff887c', '', ''), 
(10602, 'Work time', 'Let''s job! :)', '2021-11-03', '08:00:00', '2021-11-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211103T110000Z', '', '#dbadff', '', ''), 
(10603, 'Work time', 'Let''s job! :)', '2021-11-04', '08:00:00', '2021-11-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211104T110000Z', '', '#dbadff', '', ''), 
(10604, 'Work time', 'Let''s job! :)', '2021-11-08', '08:00:00', '2021-11-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211108T110000Z', '', '#dbadff', '', ''), 
(10605, 'Work time', 'Let''s job! :)', '2021-11-10', '08:00:00', '2021-11-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211110T110000Z', '', '#dbadff', '', ''), 
(10606, 'Hobbie time', 'shhhh...It''s a secret!', '2021-11-11', null, '2021-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20211111', '', '#7ae7bf', '', ''), 
(10607, 'Work time', 'Let''s job! :)', '2021-11-11', '08:00:00', '2021-11-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211111T110000Z', '', '#dbadff', '', ''), 
(10608, 'Work time', 'Let''s job! :)', '2021-11-15', '08:00:00', '2021-11-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211115T110000Z', '', '#dbadff', '', ''), 
(10609, 'Resting...', 'I''m...nevermind', '2021-11-16', null, '2021-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20211116', '', '#e1e1e1', '', ''), 
(10610, 'Work time', 'Let''s job! :)', '2021-11-17', '08:00:00', '2021-11-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211117T110000Z', '', '#dbadff', '', ''), 
(10611, 'Work time', 'Let''s job! :)', '2021-11-18', '08:00:00', '2021-11-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211118T110000Z', '', '#dbadff', '', ''), 
(10612, 'Work time', 'Let''s job! :)', '2021-11-22', '08:00:00', '2021-11-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211122T110000Z', '', '#dbadff', '', ''), 
(10613, 'Work time', 'Let''s job! :)', '2021-11-24', '08:00:00', '2021-11-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211124T110000Z', '', '#dbadff', '', ''), 
(10614, 'Work time', 'Let''s job! :)', '2021-11-25', '08:00:00', '2021-11-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211125T110000Z', '', '#dbadff', '', ''), 
(10615, 'Yellow day', 'Are you ready?', '2021-11-28', null, '2021-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20211128', '', '#fbd75b', '', ''), 
(10616, 'Work time', 'Let''s job! :)', '2021-11-29', '08:00:00', '2021-11-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211129T110000Z', '', '#dbadff', '', ''), 
(10617, 'Work time', 'Let''s job! :)', '2021-12-01', '08:00:00', '2021-12-01', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211201T110000Z', '', '#dbadff', '', ''), 
(10618, 'Day 1', 'Starting activities..', '2021-12-01', '10:00:00', '2021-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20211201T130000Z', '', '#ff887c', '', ''), 
(10619, 'Work time', 'Let''s job! :)', '2021-12-02', '08:00:00', '2021-12-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211202T110000Z', '', '#dbadff', '', ''), 
(10620, 'Work time', 'Let''s job! :)', '2021-12-06', '08:00:00', '2021-12-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211206T110000Z', '', '#dbadff', '', ''), 
(10621, 'Work time', 'Let''s job! :)', '2021-12-08', '08:00:00', '2021-12-08', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211208T110000Z', '', '#dbadff', '', ''), 
(10622, 'Work time', 'Let''s job! :)', '2021-12-09', '08:00:00', '2021-12-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211209T110000Z', '', '#dbadff', '', ''), 
(10623, 'Hobbie time', 'shhhh...It''s a secret!', '2021-12-11', null, '2021-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20211211', '', '#7ae7bf', '', ''), 
(10624, 'Work time', 'Let''s job! :)', '2021-12-13', '08:00:00', '2021-12-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211213T110000Z', '', '#dbadff', '', ''), 
(10625, 'Work time', 'Let''s job! :)', '2021-12-15', '08:00:00', '2021-12-15', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211215T110000Z', '', '#dbadff', '', ''), 
(10626, 'Resting...', 'I''m...nevermind', '2021-12-16', null, '2021-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20211216', '', '#e1e1e1', '', ''), 
(10627, 'Work time', 'Let''s job! :)', '2021-12-16', '08:00:00', '2021-12-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211216T110000Z', '', '#dbadff', '', ''), 
(10628, 'Work time', 'Let''s job! :)', '2021-12-20', '08:00:00', '2021-12-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211220T110000Z', '', '#dbadff', '', ''), 
(10629, 'Work time', 'Let''s job! :)', '2021-12-22', '08:00:00', '2021-12-22', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211222T110000Z', '', '#dbadff', '', ''), 
(10630, 'Work time', 'Let''s job! :)', '2021-12-23', '08:00:00', '2021-12-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211223T110000Z', '', '#dbadff', '', ''), 
(10631, 'Work time', 'Let''s job! :)', '2021-12-27', '08:00:00', '2021-12-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211227T110000Z', '', '#dbadff', '', ''), 
(10632, 'Yellow day', 'Are you ready?', '2021-12-28', null, '2021-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20211228', '', '#fbd75b', '', ''), 
(10633, 'Work time', 'Let''s job! :)', '2021-12-29', '08:00:00', '2021-12-29', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211229T110000Z', '', '#dbadff', '', ''), 
(10634, 'Work time', 'Let''s job! :)', '2021-12-30', '08:00:00', '2021-12-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20211230T110000Z', '', '#dbadff', '', ''), 
(10635, 'Day 1', 'Starting activities..', '2022-01-01', '10:00:00', '2022-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220101T130000Z', '', '#ff887c', '', ''), 
(10636, 'Work time', 'Let''s job! :)', '2022-01-03', '08:00:00', '2022-01-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220103T110000Z', '', '#dbadff', '', ''), 
(10637, 'Work time', 'Let''s job! :)', '2022-01-05', '08:00:00', '2022-01-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220105T110000Z', '', '#dbadff', '', ''), 
(10638, 'Work time', 'Let''s job! :)', '2022-01-06', '08:00:00', '2022-01-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220106T110000Z', '', '#dbadff', '', ''), 
(10639, 'Work time', 'Let''s job! :)', '2022-01-10', '08:00:00', '2022-01-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220110T110000Z', '', '#dbadff', '', ''), 
(10640, 'Hobbie time', 'shhhh...It''s a secret!', '2022-01-11', null, '2022-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220111', '', '#7ae7bf', '', ''), 
(10641, 'Work time', 'Let''s job! :)', '2022-01-12', '08:00:00', '2022-01-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220112T110000Z', '', '#dbadff', '', ''), 
(10642, 'Work time', 'Let''s job! :)', '2022-01-13', '08:00:00', '2022-01-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220113T110000Z', '', '#dbadff', '', ''), 
(10643, 'Resting...', 'I''m...nevermind', '2022-01-16', null, '2022-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220116', '', '#e1e1e1', '', ''), 
(10644, 'Work time', 'Let''s job! :)', '2022-01-17', '08:00:00', '2022-01-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220117T110000Z', '', '#dbadff', '', ''), 
(10645, 'Work time', 'Let''s job! :)', '2022-01-19', '08:00:00', '2022-01-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220119T110000Z', '', '#dbadff', '', ''), 
(10646, 'Work time', 'Let''s job! :)', '2022-01-20', '08:00:00', '2022-01-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220120T110000Z', '', '#dbadff', '', ''), 
(10647, 'Work time', 'Let''s job! :)', '2022-01-24', '08:00:00', '2022-01-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220124T110000Z', '', '#dbadff', '', '');

INSERT INTO `new_calendar` VALUES 
(10648, 'Work time', 'Let''s job! :)', '2022-01-26', '08:00:00', '2022-01-26', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220126T110000Z', '', '#dbadff', '', ''), 
(10649, 'Work time', 'Let''s job! :)', '2022-01-27', '08:00:00', '2022-01-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220127T110000Z', '', '#dbadff', '', ''), 
(10650, 'Yellow day', 'Are you ready?', '2022-01-28', null, '2022-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220128', '', '#fbd75b', '', ''), 
(10651, 'Work time', 'Let''s job! :)', '2022-01-31', '08:00:00', '2022-01-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220131T110000Z', '', '#dbadff', '', ''), 
(10652, 'Day 1', 'Starting activities..', '2022-02-01', '10:00:00', '2022-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220201T130000Z', '', '#ff887c', '', ''), 
(10653, 'Work time', 'Let''s job! :)', '2022-02-02', '08:00:00', '2022-02-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220202T110000Z', '', '#dbadff', '', ''), 
(10654, 'Work time', 'Let''s job! :)', '2022-02-03', '08:00:00', '2022-02-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220203T110000Z', '', '#dbadff', '', ''), 
(10655, 'Work time', 'Let''s job! :)', '2022-02-07', '08:00:00', '2022-02-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220207T110000Z', '', '#dbadff', '', ''), 
(10656, 'Work time', 'Let''s job! :)', '2022-02-09', '08:00:00', '2022-02-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220209T110000Z', '', '#dbadff', '', ''), 
(10657, 'Work time', 'Let''s job! :)', '2022-02-10', '08:00:00', '2022-02-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220210T110000Z', '', '#dbadff', '', ''), 
(10658, 'Hobbie time', 'shhhh...It''s a secret!', '2022-02-11', null, '2022-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220211', '', '#7ae7bf', '', ''), 
(10659, 'Work time', 'Let''s job! :)', '2022-02-14', '08:00:00', '2022-02-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220214T110000Z', '', '#dbadff', '', ''), 
(10660, 'Resting...', 'I''m...nevermind', '2022-02-16', null, '2022-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220216', '', '#e1e1e1', '', ''), 
(10661, 'Work time', 'Let''s job! :)', '2022-02-16', '08:00:00', '2022-02-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220216T110000Z', '', '#dbadff', '', ''), 
(10662, 'Work time', 'Let''s job! :)', '2022-02-17', '08:00:00', '2022-02-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220217T110000Z', '', '#dbadff', '', ''), 
(10663, 'Work time', 'Let''s job! :)', '2022-02-21', '08:00:00', '2022-02-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220221T110000Z', '', '#dbadff', '', ''), 
(10664, 'Work time', 'Let''s job! :)', '2022-02-23', '08:00:00', '2022-02-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220223T110000Z', '', '#dbadff', '', ''), 
(10665, 'Work time', 'Let''s job! :)', '2022-02-24', '08:00:00', '2022-02-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220224T110000Z', '', '#dbadff', '', ''), 
(10666, 'Yellow day', 'Are you ready?', '2022-02-28', null, '2022-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220228', '', '#fbd75b', '', ''), 
(10667, 'Work time', 'Let''s job! :)', '2022-02-28', '08:00:00', '2022-02-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220228T110000Z', '', '#dbadff', '', ''), 
(10668, 'Day 1', 'Starting activities..', '2022-03-01', '10:00:00', '2022-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220301T130000Z', '', '#ff887c', '', ''), 
(10669, 'Work time', 'Let''s job! :)', '2022-03-02', '08:00:00', '2022-03-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220302T110000Z', '', '#dbadff', '', ''), 
(10670, 'Work time', 'Let''s job! :)', '2022-03-03', '08:00:00', '2022-03-03', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220303T110000Z', '', '#dbadff', '', ''), 
(10671, 'Work time', 'Let''s job! :)', '2022-03-07', '08:00:00', '2022-03-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220307T110000Z', '', '#dbadff', '', ''), 
(10672, 'Work time', 'Let''s job! :)', '2022-03-09', '08:00:00', '2022-03-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220309T110000Z', '', '#dbadff', '', ''), 
(10673, 'Work time', 'Let''s job! :)', '2022-03-10', '08:00:00', '2022-03-10', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220310T110000Z', '', '#dbadff', '', ''), 
(10674, 'Hobbie time', 'shhhh...It''s a secret!', '2022-03-11', null, '2022-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220311', '', '#7ae7bf', '', ''), 
(10675, 'Work time', 'Let''s job! :)', '2022-03-14', '08:00:00', '2022-03-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220314T110000Z', '', '#dbadff', '', ''), 
(10676, 'Resting...', 'I''m...nevermind', '2022-03-16', null, '2022-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220316', '', '#e1e1e1', '', ''), 
(10677, 'Work time', 'Let''s job! :)', '2022-03-16', '08:00:00', '2022-03-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220316T110000Z', '', '#dbadff', '', ''), 
(10678, 'Work time', 'Let''s job! :)', '2022-03-17', '08:00:00', '2022-03-17', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220317T110000Z', '', '#dbadff', '', ''), 
(10679, 'Work time', 'Let''s job! :)', '2022-03-21', '08:00:00', '2022-03-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220321T110000Z', '', '#dbadff', '', ''), 
(10680, 'Work time', 'Let''s job! :)', '2022-03-23', '08:00:00', '2022-03-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220323T110000Z', '', '#dbadff', '', ''), 
(10681, 'Work time', 'Let''s job! :)', '2022-03-24', '08:00:00', '2022-03-24', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220324T110000Z', '', '#dbadff', '', ''), 
(10682, 'Yellow day', 'Are you ready?', '2022-03-28', null, '2022-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220328', '', '#fbd75b', '', ''), 
(10683, 'Work time', 'Let''s job! :)', '2022-03-28', '08:00:00', '2022-03-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220328T110000Z', '', '#dbadff', '', ''), 
(10684, 'Work time', 'Let''s job! :)', '2022-03-30', '08:00:00', '2022-03-30', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220330T110000Z', '', '#dbadff', '', ''), 
(10685, 'Work time', 'Let''s job! :)', '2022-03-31', '08:00:00', '2022-03-31', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220331T110000Z', '', '#dbadff', '', ''), 
(10686, 'Day 1', 'Starting activities..', '2022-04-01', '10:00:00', '2022-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220401T130000Z', '', '#ff887c', '', ''), 
(10687, 'Work time', 'Let''s job! :)', '2022-04-04', '08:00:00', '2022-04-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220404T110000Z', '', '#dbadff', '', ''), 
(10688, 'Work time', 'Let''s job! :)', '2022-04-06', '08:00:00', '2022-04-06', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220406T110000Z', '', '#dbadff', '', ''), 
(10689, 'Work time', 'Let''s job! :)', '2022-04-07', '08:00:00', '2022-04-07', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220407T110000Z', '', '#dbadff', '', ''), 
(10690, 'Hobbie time', 'shhhh...It''s a secret!', '2022-04-11', null, '2022-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220411', '', '#7ae7bf', '', ''), 
(10691, 'Work time', 'Let''s job! :)', '2022-04-11', '08:00:00', '2022-04-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220411T110000Z', '', '#dbadff', '', ''), 
(10692, 'Work time', 'Let''s job! :)', '2022-04-13', '08:00:00', '2022-04-13', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220413T110000Z', '', '#dbadff', '', ''), 
(10693, 'Work time', 'Let''s job! :)', '2022-04-14', '08:00:00', '2022-04-14', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220414T110000Z', '', '#dbadff', '', ''), 
(10694, 'Resting...', 'I''m...nevermind', '2022-04-16', null, '2022-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220416', '', '#e1e1e1', '', ''), 
(10695, 'Work time', 'Let''s job! :)', '2022-04-18', '08:00:00', '2022-04-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220418T110000Z', '', '#dbadff', '', ''), 
(10696, 'Work time', 'Let''s job! :)', '2022-04-20', '08:00:00', '2022-04-20', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220420T110000Z', '', '#dbadff', '', ''), 
(10697, 'Work time', 'Let''s job! :)', '2022-04-21', '08:00:00', '2022-04-21', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220421T110000Z', '', '#dbadff', '', ''), 
(10698, 'Work time', 'Let''s job! :)', '2022-04-25', '08:00:00', '2022-04-25', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220425T110000Z', '', '#dbadff', '', ''), 
(10699, 'Work time', 'Let''s job! :)', '2022-04-27', '08:00:00', '2022-04-27', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220427T110000Z', '', '#dbadff', '', ''), 
(10700, 'Yellow day', 'Are you ready?', '2022-04-28', null, '2022-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220428', '', '#fbd75b', '', ''), 
(10701, 'Work time', 'Let''s job! :)', '2022-04-28', '08:00:00', '2022-04-28', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220428T110000Z', '', '#dbadff', '', ''), 
(10702, 'Day 1', 'Starting activities..', '2022-05-01', '10:00:00', '2022-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220501T130000Z', '', '#ff887c', '', ''), 
(10703, 'Work time', 'Let''s job! :)', '2022-05-02', '08:00:00', '2022-05-02', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220502T110000Z', '', '#dbadff', '', ''), 
(10704, 'Work time', 'Let''s job! :)', '2022-05-04', '08:00:00', '2022-05-04', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220504T110000Z', '', '#dbadff', '', ''), 
(10705, 'Work time', 'Let''s job! :)', '2022-05-05', '08:00:00', '2022-05-05', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220505T110000Z', '', '#dbadff', '', ''), 
(10706, 'Work time', 'Let''s job! :)', '2022-05-09', '08:00:00', '2022-05-09', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220509T110000Z', '', '#dbadff', '', ''), 
(10707, 'Hobbie time', 'shhhh...It''s a secret!', '2022-05-11', null, '2022-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220511', '', '#7ae7bf', '', ''), 
(10708, 'Work time', 'Let''s job! :)', '2022-05-11', '08:00:00', '2022-05-11', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220511T110000Z', '', '#dbadff', '', ''), 
(10709, 'Work time', 'Let''s job! :)', '2022-05-12', '08:00:00', '2022-05-12', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220512T110000Z', '', '#dbadff', '', ''), 
(10710, 'Resting...', 'I''m...nevermind', '2022-05-16', null, '2022-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220516', '', '#e1e1e1', '', ''), 
(10711, 'Work time', 'Let''s job! :)', '2022-05-16', '08:00:00', '2022-05-16', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220516T110000Z', '', '#dbadff', '', ''), 
(10712, 'Work time', 'Let''s job! :)', '2022-05-18', '08:00:00', '2022-05-18', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220518T110000Z', '', '#dbadff', '', ''), 
(10713, 'Work time', 'Let''s job! :)', '2022-05-19', '08:00:00', '2022-05-19', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220519T110000Z', '', '#dbadff', '', ''), 
(10714, 'Work time', 'Let''s job! :)', '2022-05-23', '08:00:00', '2022-05-23', '18:00:00', '', '', 0, 'scriptcase.calendar@gmail.com', '4rpe9frh9ndjtsb4hhe7ng22bk_20220523T110000Z', '', '#dbadff', '', ''), 
(10715, 'Yellow day', 'Are you ready?', '2022-05-28', null, '2022-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220528', '', '#fbd75b', '', ''), 
(10716, 'Day 1', 'Starting activities..', '2022-06-01', '10:00:00', '2022-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220601T130000Z', '', '#ff887c', '', ''), 
(10717, 'Hobbie time', 'shhhh...It''s a secret!', '2022-06-11', null, '2022-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220611', '', '#7ae7bf', '', ''), 
(10718, 'Resting...', 'I''m...nevermind', '2022-06-16', null, '2022-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220616', '', '#e1e1e1', '', ''), 
(10719, 'Yellow day', 'Are you ready?', '2022-06-28', null, '2022-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220628', '', '#fbd75b', '', ''), 
(10720, 'Day 1', 'Starting activities..', '2022-07-01', '10:00:00', '2022-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220701T130000Z', '', '#ff887c', '', ''), 
(10721, 'Hobbie time', 'shhhh...It''s a secret!', '2022-07-11', null, '2022-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220711', '', '#7ae7bf', '', ''), 
(10722, 'Resting...', 'I''m...nevermind', '2022-07-16', null, '2022-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220716', '', '#e1e1e1', '', ''), 
(10723, 'Yellow day', 'Are you ready?', '2022-07-28', null, '2022-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220728', '', '#fbd75b', '', ''), 
(10724, 'Day 1', 'Starting activities..', '2022-08-01', '10:00:00', '2022-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220801T130000Z', '', '#ff887c', '', ''), 
(10725, 'Hobbie time', 'shhhh...It''s a secret!', '2022-08-11', null, '2022-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220811', '', '#7ae7bf', '', ''), 
(10726, 'Resting...', 'I''m...nevermind', '2022-08-16', null, '2022-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220816', '', '#e1e1e1', '', ''), 
(10727, 'Yellow day', 'Are you ready?', '2022-08-28', null, '2022-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220828', '', '#fbd75b', '', ''), 
(10728, 'Day 1', 'Starting activities..', '2022-09-01', '10:00:00', '2022-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20220901T130000Z', '', '#ff887c', '', ''), 
(10729, 'Hobbie time', 'shhhh...It''s a secret!', '2022-09-11', null, '2022-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20220911', '', '#7ae7bf', '', ''), 
(10730, 'Resting...', 'I''m...nevermind', '2022-09-16', null, '2022-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20220916', '', '#e1e1e1', '', ''), 
(10731, 'Yellow day', 'Are you ready?', '2022-09-28', null, '2022-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20220928', '', '#fbd75b', '', ''), 
(10732, 'Day 1', 'Starting activities..', '2022-10-01', '10:00:00', '2022-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20221001T130000Z', '', '#ff887c', '', ''), 
(10733, 'Hobbie time', 'shhhh...It''s a secret!', '2022-10-11', null, '2022-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20221011', '', '#7ae7bf', '', ''), 
(10734, 'Resting...', 'I''m...nevermind', '2022-10-16', null, '2022-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20221016', '', '#e1e1e1', '', ''), 
(10735, 'Yellow day', 'Are you ready?', '2022-10-28', null, '2022-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20221028', '', '#fbd75b', '', ''), 
(10736, 'Day 1', 'Starting activities..', '2022-11-01', '10:00:00', '2022-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20221101T130000Z', '', '#ff887c', '', ''), 
(10737, 'Hobbie time', 'shhhh...It''s a secret!', '2022-11-11', null, '2022-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20221111', '', '#7ae7bf', '', ''), 
(10738, 'Resting...', 'I''m...nevermind', '2022-11-16', null, '2022-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20221116', '', '#e1e1e1', '', ''), 
(10739, 'Yellow day', 'Are you ready?', '2022-11-28', null, '2022-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20221128', '', '#fbd75b', '', ''), 
(10740, 'Day 1', 'Starting activities..', '2022-12-01', '10:00:00', '2022-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20221201T130000Z', '', '#ff887c', '', ''), 
(10741, 'Hobbie time', 'shhhh...It''s a secret!', '2022-12-11', null, '2022-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20221211', '', '#7ae7bf', '', ''), 
(10742, 'Resting...', 'I''m...nevermind', '2022-12-16', null, '2022-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20221216', '', '#e1e1e1', '', ''), 
(10743, 'Yellow day', 'Are you ready?', '2022-12-28', null, '2022-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20221228', '', '#fbd75b', '', ''), 
(10744, 'Day 1', 'Starting activities..', '2023-01-01', '10:00:00', '2023-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230101T130000Z', '', '#ff887c', '', ''), 
(10745, 'Hobbie time', 'shhhh...It''s a secret!', '2023-01-11', null, '2023-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230111', '', '#7ae7bf', '', ''), 
(10746, 'Resting...', 'I''m...nevermind', '2023-01-16', null, '2023-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230116', '', '#e1e1e1', '', ''), 
(10747, 'Yellow day', 'Are you ready?', '2023-01-28', null, '2023-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230128', '', '#fbd75b', '', ''), 
(10748, 'Day 1', 'Starting activities..', '2023-02-01', '10:00:00', '2023-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230201T130000Z', '', '#ff887c', '', ''); 

INSERT INTO `new_calendar` VALUES 
(10749, 'Hobbie time', 'shhhh...It''s a secret!', '2023-02-11', null, '2023-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230211', '', '#7ae7bf', '', ''), 
(10750, 'Resting...', 'I''m...nevermind', '2023-02-16', null, '2023-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230216', '', '#e1e1e1', '', ''), 
(10751, 'Yellow day', 'Are you ready?', '2023-02-28', null, '2023-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230228', '', '#fbd75b', '', ''), 
(10752, 'Day 1', 'Starting activities..', '2023-03-01', '10:00:00', '2023-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230301T130000Z', '', '#ff887c', '', ''), 
(10753, 'Hobbie time', 'shhhh...It''s a secret!', '2023-03-11', null, '2023-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230311', '', '#7ae7bf', '', ''), 
(10754, 'Resting...', 'I''m...nevermind', '2023-03-16', null, '2023-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230316', '', '#e1e1e1', '', ''), 
(10755, 'Yellow day', 'Are you ready?', '2023-03-28', null, '2023-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230328', '', '#fbd75b', '', ''), 
(10756, 'Day 1', 'Starting activities..', '2023-04-01', '10:00:00', '2023-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230401T130000Z', '', '#ff887c', '', ''), 
(10757, 'Hobbie time', 'shhhh...It''s a secret!', '2023-04-11', null, '2023-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230411', '', '#7ae7bf', '', ''), 
(10758, 'Resting...', 'I''m...nevermind', '2023-04-16', null, '2023-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230416', '', '#e1e1e1', '', ''), 
(10759, 'Yellow day', 'Are you ready?', '2023-04-28', null, '2023-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230428', '', '#fbd75b', '', ''), 
(10760, 'Day 1', 'Starting activities..', '2023-05-01', '10:00:00', '2023-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230501T130000Z', '', '#ff887c', '', ''), 
(10761, 'Hobbie time', 'shhhh...It''s a secret!', '2023-05-11', null, '2023-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230511', '', '#7ae7bf', '', ''), 
(10762, 'Resting...', 'I''m...nevermind', '2023-05-16', null, '2023-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230516', '', '#e1e1e1', '', ''), 
(10763, 'Yellow day', 'Are you ready?', '2023-05-28', null, '2023-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230528', '', '#fbd75b', '', ''), 
(10764, 'Day 1', 'Starting activities..', '2023-06-01', '10:00:00', '2023-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230601T130000Z', '', '#ff887c', '', ''), 
(10765, 'Hobbie time', 'shhhh...It''s a secret!', '2023-06-11', null, '2023-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230611', '', '#7ae7bf', '', ''), 
(10766, 'Resting...', 'I''m...nevermind', '2023-06-16', null, '2023-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230616', '', '#e1e1e1', '', ''), 
(10767, 'Yellow day', 'Are you ready?', '2023-06-28', null, '2023-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230628', '', '#fbd75b', '', ''), 
(10768, 'Day 1', 'Starting activities..', '2023-07-01', '10:00:00', '2023-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230701T130000Z', '', '#ff887c', '', ''), 
(10769, 'Hobbie time', 'shhhh...It''s a secret!', '2023-07-11', null, '2023-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230711', '', '#7ae7bf', '', ''), 
(10770, 'Resting...', 'I''m...nevermind', '2023-07-16', null, '2023-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230716', '', '#e1e1e1', '', ''), 
(10771, 'Yellow day', 'Are you ready?', '2023-07-28', null, '2023-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230728', '', '#fbd75b', '', ''), 
(10772, 'Day 1', 'Starting activities..', '2023-08-01', '10:00:00', '2023-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230801T130000Z', '', '#ff887c', '', ''), 
(10773, 'Hobbie time', 'shhhh...It''s a secret!', '2023-08-11', null, '2023-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230811', '', '#7ae7bf', '', ''), 
(10774, 'Resting...', 'I''m...nevermind', '2023-08-16', null, '2023-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230816', '', '#e1e1e1', '', ''), 
(10775, 'Yellow day', 'Are you ready?', '2023-08-28', null, '2023-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230828', '', '#fbd75b', '', ''), 
(10776, 'Day 1', 'Starting activities..', '2023-09-01', '10:00:00', '2023-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20230901T130000Z', '', '#ff887c', '', ''), 
(10777, 'Hobbie time', 'shhhh...It''s a secret!', '2023-09-11', null, '2023-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20230911', '', '#7ae7bf', '', ''), 
(10778, 'Resting...', 'I''m...nevermind', '2023-09-16', null, '2023-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20230916', '', '#e1e1e1', '', ''), 
(10779, 'Yellow day', 'Are you ready?', '2023-09-28', null, '2023-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20230928', '', '#fbd75b', '', ''), 
(10780, 'Day 1', 'Starting activities..', '2023-10-01', '10:00:00', '2023-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20231001T130000Z', '', '#ff887c', '', ''), 
(10781, 'Hobbie time', 'shhhh...It''s a secret!', '2023-10-11', null, '2023-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20231011', '', '#7ae7bf', '', ''), 
(10782, 'Resting...', 'I''m...nevermind', '2023-10-16', null, '2023-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20231016', '', '#e1e1e1', '', ''), 
(10783, 'Yellow day', 'Are you ready?', '2023-10-28', null, '2023-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20231028', '', '#fbd75b', '', ''), 
(10784, 'Day 1', 'Starting activities..', '2023-11-01', '10:00:00', '2023-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20231101T130000Z', '', '#ff887c', '', ''), 
(10785, 'Hobbie time', 'shhhh...It''s a secret!', '2023-11-11', null, '2023-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20231111', '', '#7ae7bf', '', ''), 
(10786, 'Resting...', 'I''m...nevermind', '2023-11-16', null, '2023-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20231116', '', '#e1e1e1', '', ''), 
(10787, 'Yellow day', 'Are you ready?', '2023-11-28', null, '2023-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20231128', '', '#fbd75b', '', ''), 
(10788, 'Day 1', 'Starting activities..', '2023-12-01', '10:00:00', '2023-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20231201T130000Z', '', '#ff887c', '', ''), 
(10789, 'Hobbie time', 'shhhh...It''s a secret!', '2023-12-11', null, '2023-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20231211', '', '#7ae7bf', '', ''), 
(10790, 'Resting...', 'I''m...nevermind', '2023-12-16', null, '2023-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20231216', '', '#e1e1e1', '', ''), 
(10791, 'Yellow day', 'Are you ready?', '2023-12-28', null, '2023-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20231228', '', '#fbd75b', '', ''), 
(10792, 'Day 1', 'Starting activities..', '2024-01-01', '10:00:00', '2024-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240101T130000Z', '', '#ff887c', '', ''), 
(10793, 'Hobbie time', 'shhhh...It''s a secret!', '2024-01-11', null, '2024-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240111', '', '#7ae7bf', '', ''), 
(10794, 'Resting...', 'I''m...nevermind', '2024-01-16', null, '2024-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240116', '', '#e1e1e1', '', ''), 
(10795, 'Yellow day', 'Are you ready?', '2024-01-28', null, '2024-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240128', '', '#fbd75b', '', ''), 
(10796, 'Day 1', 'Starting activities..', '2024-02-01', '10:00:00', '2024-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240201T130000Z', '', '#ff887c', '', ''), 
(10797, 'Hobbie time', 'shhhh...It''s a secret!', '2024-02-11', null, '2024-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240211', '', '#7ae7bf', '', ''), 
(10798, 'Resting...', 'I''m...nevermind', '2024-02-16', null, '2024-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240216', '', '#e1e1e1', '', ''), 
(10799, 'Yellow day', 'Are you ready?', '2024-02-28', null, '2024-02-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240228', '', '#fbd75b', '', ''), 
(10800, 'Day 1', 'Starting activities..', '2024-03-01', '10:00:00', '2024-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240301T130000Z', '', '#ff887c', '', ''), 
(10801, 'Hobbie time', 'shhhh...It''s a secret!', '2024-03-11', null, '2024-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240311', '', '#7ae7bf', '', ''), 
(10802, 'Resting...', 'I''m...nevermind', '2024-03-16', null, '2024-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240316', '', '#e1e1e1', '', ''), 
(10803, 'Yellow day', 'Are you ready?', '2024-03-28', null, '2024-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240328', '', '#fbd75b', '', ''), 
(10804, 'Day 1', 'Starting activities..', '2024-04-01', '10:00:00', '2024-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240401T130000Z', '', '#ff887c', '', ''), 
(10805, 'Hobbie time', 'shhhh...It''s a secret!', '2024-04-11', null, '2024-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240411', '', '#7ae7bf', '', ''), 
(10806, 'Resting...', 'I''m...nevermind', '2024-04-16', null, '2024-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240416', '', '#e1e1e1', '', ''), 
(10807, 'Yellow day', 'Are you ready?', '2024-04-28', null, '2024-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240428', '', '#fbd75b', '', ''), 
(10808, 'Day 1', 'Starting activities..', '2024-05-01', '10:00:00', '2024-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240501T130000Z', '', '#ff887c', '', ''), 
(10809, 'Hobbie time', 'shhhh...It''s a secret!', '2024-05-11', null, '2024-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240511', '', '#7ae7bf', '', ''), 
(10810, 'Resting...', 'I''m...nevermind', '2024-05-16', null, '2024-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240516', '', '#e1e1e1', '', ''), 
(10811, 'Yellow day', 'Are you ready?', '2024-05-28', null, '2024-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240528', '', '#fbd75b', '', ''), 
(10812, 'Day 1', 'Starting activities..', '2024-06-01', '10:00:00', '2024-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240601T130000Z', '', '#ff887c', '', ''), 
(10813, 'Hobbie time', 'shhhh...It''s a secret!', '2024-06-11', null, '2024-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240611', '', '#7ae7bf', '', ''), 
(10814, 'Resting...', 'I''m...nevermind', '2024-06-16', null, '2024-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240616', '', '#e1e1e1', '', ''), 
(10815, 'Yellow day', 'Are you ready?', '2024-06-28', null, '2024-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240628', '', '#fbd75b', '', ''), 
(10816, 'Day 1', 'Starting activities..', '2024-07-01', '10:00:00', '2024-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240701T130000Z', '', '#ff887c', '', ''), 
(10817, 'Hobbie time', 'shhhh...It''s a secret!', '2024-07-11', null, '2024-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240711', '', '#7ae7bf', '', ''), 
(10818, 'Resting...', 'I''m...nevermind', '2024-07-16', null, '2024-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240716', '', '#e1e1e1', '', ''), 
(10819, 'Yellow day', 'Are you ready?', '2024-07-28', null, '2024-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240728', '', '#fbd75b', '', ''), 
(10820, 'Day 1', 'Starting activities..', '2024-08-01', '10:00:00', '2024-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240801T130000Z', '', '#ff887c', '', ''), 
(10821, 'Hobbie time', 'shhhh...It''s a secret!', '2024-08-11', null, '2024-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240811', '', '#7ae7bf', '', ''), 
(10822, 'Resting...', 'I''m...nevermind', '2024-08-16', null, '2024-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240816', '', '#e1e1e1', '', ''), 
(10823, 'Yellow day', 'Are you ready?', '2024-08-28', null, '2024-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240828', '', '#fbd75b', '', ''), 
(10824, 'Day 1', 'Starting activities..', '2024-09-01', '10:00:00', '2024-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20240901T130000Z', '', '#ff887c', '', ''), 
(10825, 'Hobbie time', 'shhhh...It''s a secret!', '2024-09-11', null, '2024-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20240911', '', '#7ae7bf', '', ''), 
(10826, 'Resting...', 'I''m...nevermind', '2024-09-16', null, '2024-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20240916', '', '#e1e1e1', '', ''), 
(10827, 'Yellow day', 'Are you ready?', '2024-09-28', null, '2024-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20240928', '', '#fbd75b', '', ''), 
(10828, 'Day 1', 'Starting activities..', '2024-10-01', '10:00:00', '2024-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20241001T130000Z', '', '#ff887c', '', ''), 
(10829, 'Hobbie time', 'shhhh...It''s a secret!', '2024-10-11', null, '2024-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20241011', '', '#7ae7bf', '', ''), 
(10830, 'Resting...', 'I''m...nevermind', '2024-10-16', null, '2024-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20241016', '', '#e1e1e1', '', ''), 
(10831, 'Yellow day', 'Are you ready?', '2024-10-28', null, '2024-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20241028', '', '#fbd75b', '', ''), 
(10832, 'Day 1', 'Starting activities..', '2024-11-01', '10:00:00', '2024-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20241101T130000Z', '', '#ff887c', '', ''), 
(10833, 'Hobbie time', 'shhhh...It''s a secret!', '2024-11-11', null, '2024-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20241111', '', '#7ae7bf', '', ''), 
(10834, 'Resting...', 'I''m...nevermind', '2024-11-16', null, '2024-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20241116', '', '#e1e1e1', '', ''), 
(10835, 'Yellow day', 'Are you ready?', '2024-11-28', null, '2024-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20241128', '', '#fbd75b', '', ''), 
(10836, 'Day 1', 'Starting activities..', '2024-12-01', '10:00:00', '2024-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20241201T130000Z', '', '#ff887c', '', ''), 
(10837, 'Hobbie time', 'shhhh...It''s a secret!', '2024-12-11', null, '2024-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20241211', '', '#7ae7bf', '', ''), 
(10838, 'Resting...', 'I''m...nevermind', '2024-12-16', null, '2024-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20241216', '', '#e1e1e1', '', ''), 
(10839, 'Yellow day', 'Are you ready?', '2024-12-28', null, '2024-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20241228', '', '#fbd75b', '', ''), 
(10840, 'Day 1', 'Starting activities..', '2025-01-01', '10:00:00', '2025-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250101T130000Z', '', '#ff887c', '', ''), 
(10841, 'Hobbie time', 'shhhh...It''s a secret!', '2025-01-11', null, '2025-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250111', '', '#7ae7bf', '', ''), 
(10842, 'Resting...', 'I''m...nevermind', '2025-01-16', null, '2025-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250116', '', '#e1e1e1', '', ''), 
(10843, 'Yellow day', 'Are you ready?', '2025-01-28', null, '2025-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250128', '', '#fbd75b', '', ''), 
(10844, 'Day 1', 'Starting activities..', '2025-02-01', '10:00:00', '2025-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250201T130000Z', '', '#ff887c', '', ''), 
(10845, 'Hobbie time', 'shhhh...It''s a secret!', '2025-02-11', null, '2025-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250211', '', '#7ae7bf', '', ''), 
(10846, 'Resting...', 'I''m...nevermind', '2025-02-16', null, '2025-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250216', '', '#e1e1e1', '', ''), 
(10847, 'Yellow day', 'Are you ready?', '2025-02-28', null, '2025-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250228', '', '#fbd75b', '', ''), 
(10848, 'Day 1', 'Starting activities..', '2025-03-01', '10:00:00', '2025-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250301T130000Z', '', '#ff887c', '', ''), 
(10849, 'Hobbie time', 'shhhh...It''s a secret!', '2025-03-11', null, '2025-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250311', '', '#7ae7bf', '', ''), 
(10850, 'Resting...', 'I''m...nevermind', '2025-03-16', null, '2025-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250316', '', '#e1e1e1', '', ''), 
(10851, 'Yellow day', 'Are you ready?', '2025-03-28', null, '2025-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250328', '', '#fbd75b', '', ''), 
(10852, 'Day 1', 'Starting activities..', '2025-04-01', '10:00:00', '2025-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250401T130000Z', '', '#ff887c', '', ''), 
(10853, 'Hobbie time', 'shhhh...It''s a secret!', '2025-04-11', null, '2025-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250411', '', '#7ae7bf', '', ''), 
(10854, 'Resting...', 'I''m...nevermind', '2025-04-16', null, '2025-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250416', '', '#e1e1e1', '', ''), 
(10855, 'Yellow day', 'Are you ready?', '2025-04-28', null, '2025-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250428', '', '#fbd75b', '', ''), 
(10856, 'Day 1', 'Starting activities..', '2025-05-01', '10:00:00', '2025-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250501T130000Z', '', '#ff887c', '', ''), 
(10857, 'Hobbie time', 'shhhh...It''s a secret!', '2025-05-11', null, '2025-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250511', '', '#7ae7bf', '', ''), 
(10858, 'Resting...', 'I''m...nevermind', '2025-05-16', null, '2025-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250516', '', '#e1e1e1', '', '');

INSERT INTO `new_calendar` VALUES 
(10859, 'Yellow day', 'Are you ready?', '2025-05-28', null, '2025-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250528', '', '#fbd75b', '', ''), 
(10860, 'Day 1', 'Starting activities..', '2025-06-01', '10:00:00', '2025-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250601T130000Z', '', '#ff887c', '', ''), 
(10861, 'Hobbie time', 'shhhh...It''s a secret!', '2025-06-11', null, '2025-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250611', '', '#7ae7bf', '', ''), 
(10862, 'Resting...', 'I''m...nevermind', '2025-06-16', null, '2025-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250616', '', '#e1e1e1', '', ''), 
(10863, 'Yellow day', 'Are you ready?', '2025-06-28', null, '2025-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250628', '', '#fbd75b', '', ''), 
(10864, 'Day 1', 'Starting activities..', '2025-07-01', '10:00:00', '2025-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250701T130000Z', '', '#ff887c', '', ''), 
(10865, 'Hobbie time', 'shhhh...It''s a secret!', '2025-07-11', null, '2025-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250711', '', '#7ae7bf', '', ''), 
(10866, 'Resting...', 'I''m...nevermind', '2025-07-16', null, '2025-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250716', '', '#e1e1e1', '', ''), 
(10867, 'Yellow day', 'Are you ready?', '2025-07-28', null, '2025-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250728', '', '#fbd75b', '', ''), 
(10868, 'Day 1', 'Starting activities..', '2025-08-01', '10:00:00', '2025-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250801T130000Z', '', '#ff887c', '', ''), 
(10869, 'Hobbie time', 'shhhh...It''s a secret!', '2025-08-11', null, '2025-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250811', '', '#7ae7bf', '', ''), 
(10870, 'Resting...', 'I''m...nevermind', '2025-08-16', null, '2025-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250816', '', '#e1e1e1', '', ''), 
(10871, 'Yellow day', 'Are you ready?', '2025-08-28', null, '2025-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250828', '', '#fbd75b', '', ''), 
(10872, 'Day 1', 'Starting activities..', '2025-09-01', '10:00:00', '2025-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20250901T130000Z', '', '#ff887c', '', ''), 
(10873, 'Hobbie time', 'shhhh...It''s a secret!', '2025-09-11', null, '2025-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20250911', '', '#7ae7bf', '', ''), 
(10874, 'Resting...', 'I''m...nevermind', '2025-09-16', null, '2025-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20250916', '', '#e1e1e1', '', ''), 
(10875, 'Yellow day', 'Are you ready?', '2025-09-28', null, '2025-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20250928', '', '#fbd75b', '', ''), 
(10876, 'Day 1', 'Starting activities..', '2025-10-01', '10:00:00', '2025-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20251001T130000Z', '', '#ff887c', '', ''), 
(10877, 'Hobbie time', 'shhhh...It''s a secret!', '2025-10-11', null, '2025-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20251011', '', '#7ae7bf', '', ''), 
(10878, 'Resting...', 'I''m...nevermind', '2025-10-16', null, '2025-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20251016', '', '#e1e1e1', '', ''), 
(10879, 'Yellow day', 'Are you ready?', '2025-10-28', null, '2025-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20251028', '', '#fbd75b', '', ''), 
(10880, 'Day 1', 'Starting activities..', '2025-11-01', '10:00:00', '2025-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20251101T130000Z', '', '#ff887c', '', ''), 
(10881, 'Hobbie time', 'shhhh...It''s a secret!', '2025-11-11', null, '2025-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20251111', '', '#7ae7bf', '', ''), 
(10882, 'Resting...', 'I''m...nevermind', '2025-11-16', null, '2025-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20251116', '', '#e1e1e1', '', ''), 
(10883, 'Yellow day', 'Are you ready?', '2025-11-28', null, '2025-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20251128', '', '#fbd75b', '', ''), 
(10884, 'Day 1', 'Starting activities..', '2025-12-01', '10:00:00', '2025-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20251201T130000Z', '', '#ff887c', '', ''), 
(10885, 'Hobbie time', 'shhhh...It''s a secret!', '2025-12-11', null, '2025-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20251211', '', '#7ae7bf', '', ''), 
(10886, 'Resting...', 'I''m...nevermind', '2025-12-16', null, '2025-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20251216', '', '#e1e1e1', '', ''), 
(10887, 'Yellow day', 'Are you ready?', '2025-12-28', null, '2025-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20251228', '', '#fbd75b', '', ''), 
(10888, 'Day 1', 'Starting activities..', '2026-01-01', '10:00:00', '2026-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260101T130000Z', '', '#ff887c', '', ''), 
(10889, 'Hobbie time', 'shhhh...It''s a secret!', '2026-01-11', null, '2026-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260111', '', '#7ae7bf', '', ''), 
(10890, 'Resting...', 'I''m...nevermind', '2026-01-16', null, '2026-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260116', '', '#e1e1e1', '', ''), 
(10891, 'Yellow day', 'Are you ready?', '2026-01-28', null, '2026-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260128', '', '#fbd75b', '', ''), 
(10892, 'Day 1', 'Starting activities..', '2026-02-01', '10:00:00', '2026-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260201T130000Z', '', '#ff887c', '', ''), 
(10893, 'Hobbie time', 'shhhh...It''s a secret!', '2026-02-11', null, '2026-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260211', '', '#7ae7bf', '', ''), 
(10894, 'Resting...', 'I''m...nevermind', '2026-02-16', null, '2026-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260216', '', '#e1e1e1', '', ''), 
(10895, 'Yellow day', 'Are you ready?', '2026-02-28', null, '2026-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260228', '', '#fbd75b', '', ''), 
(10896, 'Day 1', 'Starting activities..', '2026-03-01', '10:00:00', '2026-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260301T130000Z', '', '#ff887c', '', ''), 
(10897, 'Hobbie time', 'shhhh...It''s a secret!', '2026-03-11', null, '2026-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260311', '', '#7ae7bf', '', ''), 
(10898, 'Resting...', 'I''m...nevermind', '2026-03-16', null, '2026-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260316', '', '#e1e1e1', '', ''), 
(10899, 'Yellow day', 'Are you ready?', '2026-03-28', null, '2026-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260328', '', '#fbd75b', '', ''), 
(10900, 'Day 1', 'Starting activities..', '2026-04-01', '10:00:00', '2026-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260401T130000Z', '', '#ff887c', '', ''), 
(10901, 'Hobbie time', 'shhhh...It''s a secret!', '2026-04-11', null, '2026-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260411', '', '#7ae7bf', '', ''), 
(10902, 'Resting...', 'I''m...nevermind', '2026-04-16', null, '2026-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260416', '', '#e1e1e1', '', ''), 
(10903, 'Yellow day', 'Are you ready?', '2026-04-28', null, '2026-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260428', '', '#fbd75b', '', ''), 
(10904, 'Day 1', 'Starting activities..', '2026-05-01', '10:00:00', '2026-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260501T130000Z', '', '#ff887c', '', ''), 
(10905, 'Hobbie time', 'shhhh...It''s a secret!', '2026-05-11', null, '2026-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260511', '', '#7ae7bf', '', ''), 
(10906, 'Resting...', 'I''m...nevermind', '2026-05-16', null, '2026-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260516', '', '#e1e1e1', '', ''), 
(10907, 'Yellow day', 'Are you ready?', '2026-05-28', null, '2026-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260528', '', '#fbd75b', '', ''), 
(10908, 'Day 1', 'Starting activities..', '2026-06-01', '10:00:00', '2026-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260601T130000Z', '', '#ff887c', '', ''), 
(10909, 'Hobbie time', 'shhhh...It''s a secret!', '2026-06-11', null, '2026-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260611', '', '#7ae7bf', '', ''), 
(10910, 'Resting...', 'I''m...nevermind', '2026-06-16', null, '2026-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260616', '', '#e1e1e1', '', ''), 
(10911, 'Yellow day', 'Are you ready?', '2026-06-28', null, '2026-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260628', '', '#fbd75b', '', ''), 
(10912, 'Day 1', 'Starting activities..', '2026-07-01', '10:00:00', '2026-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260701T130000Z', '', '#ff887c', '', ''), 
(10913, 'Hobbie time', 'shhhh...It''s a secret!', '2026-07-11', null, '2026-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260711', '', '#7ae7bf', '', ''), 
(10914, 'Resting...', 'I''m...nevermind', '2026-07-16', null, '2026-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260716', '', '#e1e1e1', '', ''), 
(10915, 'Yellow day', 'Are you ready?', '2026-07-28', null, '2026-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260728', '', '#fbd75b', '', ''), 
(10916, 'Day 1', 'Starting activities..', '2026-08-01', '10:00:00', '2026-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260801T130000Z', '', '#ff887c', '', ''), 
(10917, 'Hobbie time', 'shhhh...It''s a secret!', '2026-08-11', null, '2026-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260811', '', '#7ae7bf', '', ''), 
(10918, 'Resting...', 'I''m...nevermind', '2026-08-16', null, '2026-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260816', '', '#e1e1e1', '', ''), 
(10919, 'Yellow day', 'Are you ready?', '2026-08-28', null, '2026-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260828', '', '#fbd75b', '', ''), 
(10920, 'Day 1', 'Starting activities..', '2026-09-01', '10:00:00', '2026-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20260901T130000Z', '', '#ff887c', '', ''), 
(10921, 'Hobbie time', 'shhhh...It''s a secret!', '2026-09-11', null, '2026-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20260911', '', '#7ae7bf', '', ''), 
(10922, 'Resting...', 'I''m...nevermind', '2026-09-16', null, '2026-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20260916', '', '#e1e1e1', '', ''), 
(10923, 'Yellow day', 'Are you ready?', '2026-09-28', null, '2026-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20260928', '', '#fbd75b', '', ''), 
(10924, 'Day 1', 'Starting activities..', '2026-10-01', '10:00:00', '2026-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20261001T130000Z', '', '#ff887c', '', ''), 
(10925, 'Hobbie time', 'shhhh...It''s a secret!', '2026-10-11', null, '2026-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20261011', '', '#7ae7bf', '', ''), 
(10926, 'Resting...', 'I''m...nevermind', '2026-10-16', null, '2026-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20261016', '', '#e1e1e1', '', ''), 
(10927, 'Yellow day', 'Are you ready?', '2026-10-28', null, '2026-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20261028', '', '#fbd75b', '', ''), 
(10928, 'Day 1', 'Starting activities..', '2026-11-01', '10:00:00', '2026-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20261101T130000Z', '', '#ff887c', '', ''), 
(10929, 'Hobbie time', 'shhhh...It''s a secret!', '2026-11-11', null, '2026-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20261111', '', '#7ae7bf', '', ''), 
(10930, 'Resting...', 'I''m...nevermind', '2026-11-16', null, '2026-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20261116', '', '#e1e1e1', '', ''), 
(10931, 'Yellow day', 'Are you ready?', '2026-11-28', null, '2026-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20261128', '', '#fbd75b', '', ''), 
(10932, 'Day 1', 'Starting activities..', '2026-12-01', '10:00:00', '2026-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20261201T130000Z', '', '#ff887c', '', ''), 
(10933, 'Hobbie time', 'shhhh...It''s a secret!', '2026-12-11', null, '2026-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20261211', '', '#7ae7bf', '', ''), 
(10934, 'Resting...', 'I''m...nevermind', '2026-12-16', null, '2026-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20261216', '', '#e1e1e1', '', ''), 
(10935, 'Yellow day', 'Are you ready?', '2026-12-28', null, '2026-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20261228', '', '#fbd75b', '', ''), 
(10936, 'Day 1', 'Starting activities..', '2027-01-01', '10:00:00', '2027-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270101T130000Z', '', '#ff887c', '', ''), 
(10937, 'Hobbie time', 'shhhh...It''s a secret!', '2027-01-11', null, '2027-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270111', '', '#7ae7bf', '', ''), 
(10938, 'Resting...', 'I''m...nevermind', '2027-01-16', null, '2027-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270116', '', '#e1e1e1', '', ''), 
(10939, 'Yellow day', 'Are you ready?', '2027-01-28', null, '2027-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270128', '', '#fbd75b', '', ''), 
(10940, 'Day 1', 'Starting activities..', '2027-02-01', '10:00:00', '2027-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270201T130000Z', '', '#ff887c', '', ''), 
(10941, 'Hobbie time', 'shhhh...It''s a secret!', '2027-02-11', null, '2027-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270211', '', '#7ae7bf', '', ''), 
(10942, 'Resting...', 'I''m...nevermind', '2027-02-16', null, '2027-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270216', '', '#e1e1e1', '', ''), 
(10943, 'Yellow day', 'Are you ready?', '2027-02-28', null, '2027-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270228', '', '#fbd75b', '', ''), 
(10944, 'Day 1', 'Starting activities..', '2027-03-01', '10:00:00', '2027-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270301T130000Z', '', '#ff887c', '', ''), 
(10945, 'Hobbie time', 'shhhh...It''s a secret!', '2027-03-11', null, '2027-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270311', '', '#7ae7bf', '', ''), 
(10946, 'Resting...', 'I''m...nevermind', '2027-03-16', null, '2027-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270316', '', '#e1e1e1', '', ''), 
(10947, 'Yellow day', 'Are you ready?', '2027-03-28', null, '2027-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270328', '', '#fbd75b', '', ''), 
(10948, 'Day 1', 'Starting activities..', '2027-04-01', '10:00:00', '2027-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270401T130000Z', '', '#ff887c', '', ''), 
(10949, 'Hobbie time', 'shhhh...It''s a secret!', '2027-04-11', null, '2027-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270411', '', '#7ae7bf', '', ''), 
(10950, 'Resting...', 'I''m...nevermind', '2027-04-16', null, '2027-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270416', '', '#e1e1e1', '', ''), 
(10951, 'Yellow day', 'Are you ready?', '2027-04-28', null, '2027-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270428', '', '#fbd75b', '', ''), 
(10952, 'Day 1', 'Starting activities..', '2027-05-01', '10:00:00', '2027-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270501T130000Z', '', '#ff887c', '', ''), 
(10953, 'Hobbie time', 'shhhh...It''s a secret!', '2027-05-11', null, '2027-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270511', '', '#7ae7bf', '', ''), 
(10954, 'Resting...', 'I''m...nevermind', '2027-05-16', null, '2027-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270516', '', '#e1e1e1', '', ''), 
(10955, 'Yellow day', 'Are you ready?', '2027-05-28', null, '2027-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270528', '', '#fbd75b', '', ''), 
(10956, 'Day 1', 'Starting activities..', '2027-06-01', '10:00:00', '2027-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270601T130000Z', '', '#ff887c', '', ''), 
(10957, 'Hobbie time', 'shhhh...It''s a secret!', '2027-06-11', null, '2027-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270611', '', '#7ae7bf', '', ''), 
(10958, 'Resting...', 'I''m...nevermind', '2027-06-16', null, '2027-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270616', '', '#e1e1e1', '', ''), 
(10959, 'Yellow day', 'Are you ready?', '2027-06-28', null, '2027-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270628', '', '#fbd75b', '', '');

INSERT INTO `new_calendar` VALUES 
(10960, 'Day 1', 'Starting activities..', '2027-07-01', '10:00:00', '2027-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270701T130000Z', '', '#ff887c', '', ''), 
(10961, 'Hobbie time', 'shhhh...It''s a secret!', '2027-07-11', null, '2027-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270711', '', '#7ae7bf', '', ''), 
(10962, 'Resting...', 'I''m...nevermind', '2027-07-16', null, '2027-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270716', '', '#e1e1e1', '', ''), 
(10963, 'Yellow day', 'Are you ready?', '2027-07-28', null, '2027-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270728', '', '#fbd75b', '', ''), 
(10964, 'Day 1', 'Starting activities..', '2027-08-01', '10:00:00', '2027-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270801T130000Z', '', '#ff887c', '', ''), 
(10965, 'Hobbie time', 'shhhh...It''s a secret!', '2027-08-11', null, '2027-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270811', '', '#7ae7bf', '', ''), 
(10966, 'Resting...', 'I''m...nevermind', '2027-08-16', null, '2027-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270816', '', '#e1e1e1', '', ''), 
(10967, 'Yellow day', 'Are you ready?', '2027-08-28', null, '2027-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270828', '', '#fbd75b', '', ''), 
(10968, 'Day 1', 'Starting activities..', '2027-09-01', '10:00:00', '2027-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20270901T130000Z', '', '#ff887c', '', ''), 
(10969, 'Hobbie time', 'shhhh...It''s a secret!', '2027-09-11', null, '2027-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20270911', '', '#7ae7bf', '', ''), 
(10970, 'Resting...', 'I''m...nevermind', '2027-09-16', null, '2027-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20270916', '', '#e1e1e1', '', ''), 
(10971, 'Yellow day', 'Are you ready?', '2027-09-28', null, '2027-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20270928', '', '#fbd75b', '', ''), 
(10972, 'Day 1', 'Starting activities..', '2027-10-01', '10:00:00', '2027-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20271001T130000Z', '', '#ff887c', '', ''), 
(10973, 'Hobbie time', 'shhhh...It''s a secret!', '2027-10-11', null, '2027-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20271011', '', '#7ae7bf', '', ''), 
(10974, 'Resting...', 'I''m...nevermind', '2027-10-16', null, '2027-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20271016', '', '#e1e1e1', '', ''), 
(10975, 'Yellow day', 'Are you ready?', '2027-10-28', null, '2027-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20271028', '', '#fbd75b', '', ''), 
(10976, 'Day 1', 'Starting activities..', '2027-11-01', '10:00:00', '2027-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20271101T130000Z', '', '#ff887c', '', ''), 
(10977, 'Hobbie time', 'shhhh...It''s a secret!', '2027-11-11', null, '2027-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20271111', '', '#7ae7bf', '', ''), 
(10978, 'Resting...', 'I''m...nevermind', '2027-11-16', null, '2027-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20271116', '', '#e1e1e1', '', ''), 
(10979, 'Yellow day', 'Are you ready?', '2027-11-28', null, '2027-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20271128', '', '#fbd75b', '', ''), 
(10980, 'Day 1', 'Starting activities..', '2027-12-01', '10:00:00', '2027-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20271201T130000Z', '', '#ff887c', '', ''), 
(10981, 'Hobbie time', 'shhhh...It''s a secret!', '2027-12-11', null, '2027-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20271211', '', '#7ae7bf', '', ''), 
(10982, 'Resting...', 'I''m...nevermind', '2027-12-16', null, '2027-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20271216', '', '#e1e1e1', '', ''), 
(10983, 'Yellow day', 'Are you ready?', '2027-12-28', null, '2027-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20271228', '', '#fbd75b', '', ''), 
(10984, 'Day 1', 'Starting activities..', '2028-01-01', '10:00:00', '2028-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280101T130000Z', '', '#ff887c', '', ''), 
(10985, 'Hobbie time', 'shhhh...It''s a secret!', '2028-01-11', null, '2028-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280111', '', '#7ae7bf', '', ''), 
(10986, 'Resting...', 'I''m...nevermind', '2028-01-16', null, '2028-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280116', '', '#e1e1e1', '', ''), 
(10987, 'Yellow day', 'Are you ready?', '2028-01-28', null, '2028-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280128', '', '#fbd75b', '', ''), 
(10988, 'Day 1', 'Starting activities..', '2028-02-01', '10:00:00', '2028-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280201T130000Z', '', '#ff887c', '', ''), 
(10989, 'Hobbie time', 'shhhh...It''s a secret!', '2028-02-11', null, '2028-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280211', '', '#7ae7bf', '', ''), 
(10990, 'Resting...', 'I''m...nevermind', '2028-02-16', null, '2028-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280216', '', '#e1e1e1', '', ''), 
(10991, 'Yellow day', 'Are you ready?', '2028-02-28', null, '2028-02-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280228', '', '#fbd75b', '', ''), 
(10992, 'Day 1', 'Starting activities..', '2028-03-01', '10:00:00', '2028-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280301T130000Z', '', '#ff887c', '', ''), 
(10993, 'Hobbie time', 'shhhh...It''s a secret!', '2028-03-11', null, '2028-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280311', '', '#7ae7bf', '', ''), 
(10994, 'Resting...', 'I''m...nevermind', '2028-03-16', null, '2028-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280316', '', '#e1e1e1', '', ''), 
(10995, 'Yellow day', 'Are you ready?', '2028-03-28', null, '2028-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280328', '', '#fbd75b', '', ''), 
(10996, 'Day 1', 'Starting activities..', '2028-04-01', '10:00:00', '2028-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280401T130000Z', '', '#ff887c', '', ''), 
(10997, 'Hobbie time', 'shhhh...It''s a secret!', '2028-04-11', null, '2028-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280411', '', '#7ae7bf', '', ''), 
(10998, 'Resting...', 'I''m...nevermind', '2028-04-16', null, '2028-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280416', '', '#e1e1e1', '', ''), 
(10999, 'Yellow day', 'Are you ready?', '2028-04-28', null, '2028-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280428', '', '#fbd75b', '', ''), 
(11000, 'Day 1', 'Starting activities..', '2028-05-01', '10:00:00', '2028-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280501T130000Z', '', '#ff887c', '', ''), 
(11001, 'Hobbie time', 'shhhh...It''s a secret!', '2028-05-11', null, '2028-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280511', '', '#7ae7bf', '', ''), 
(11002, 'Resting...', 'I''m...nevermind', '2028-05-16', null, '2028-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280516', '', '#e1e1e1', '', ''), 
(11003, 'Yellow day', 'Are you ready?', '2028-05-28', null, '2028-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280528', '', '#fbd75b', '', ''), 
(11004, 'Day 1', 'Starting activities..', '2028-06-01', '10:00:00', '2028-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280601T130000Z', '', '#ff887c', '', ''), 
(11005, 'Hobbie time', 'shhhh...It''s a secret!', '2028-06-11', null, '2028-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280611', '', '#7ae7bf', '', ''), 
(11006, 'Resting...', 'I''m...nevermind', '2028-06-16', null, '2028-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280616', '', '#e1e1e1', '', ''), 
(11007, 'Yellow day', 'Are you ready?', '2028-06-28', null, '2028-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280628', '', '#fbd75b', '', ''), 
(11008, 'Day 1', 'Starting activities..', '2028-07-01', '10:00:00', '2028-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280701T130000Z', '', '#ff887c', '', ''), 
(11009, 'Hobbie time', 'shhhh...It''s a secret!', '2028-07-11', null, '2028-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280711', '', '#7ae7bf', '', ''), 
(11010, 'Resting...', 'I''m...nevermind', '2028-07-16', null, '2028-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280716', '', '#e1e1e1', '', ''), 
(11011, 'Yellow day', 'Are you ready?', '2028-07-28', null, '2028-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280728', '', '#fbd75b', '', ''), 
(11012, 'Day 1', 'Starting activities..', '2028-08-01', '10:00:00', '2028-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280801T130000Z', '', '#ff887c', '', ''), 
(11013, 'Hobbie time', 'shhhh...It''s a secret!', '2028-08-11', null, '2028-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280811', '', '#7ae7bf', '', ''), 
(11014, 'Resting...', 'I''m...nevermind', '2028-08-16', null, '2028-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280816', '', '#e1e1e1', '', ''), 
(11015, 'Yellow day', 'Are you ready?', '2028-08-28', null, '2028-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280828', '', '#fbd75b', '', ''), 
(11016, 'Day 1', 'Starting activities..', '2028-09-01', '10:00:00', '2028-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20280901T130000Z', '', '#ff887c', '', ''), 
(11017, 'Hobbie time', 'shhhh...It''s a secret!', '2028-09-11', null, '2028-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20280911', '', '#7ae7bf', '', ''), 
(11018, 'Resting...', 'I''m...nevermind', '2028-09-16', null, '2028-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20280916', '', '#e1e1e1', '', ''), 
(11019, 'Yellow day', 'Are you ready?', '2028-09-28', null, '2028-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20280928', '', '#fbd75b', '', ''), 
(11020, 'Day 1', 'Starting activities..', '2028-10-01', '10:00:00', '2028-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20281001T130000Z', '', '#ff887c', '', ''), 
(11021, 'Hobbie time', 'shhhh...It''s a secret!', '2028-10-11', null, '2028-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20281011', '', '#7ae7bf', '', ''), 
(11022, 'Resting...', 'I''m...nevermind', '2028-10-16', null, '2028-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20281016', '', '#e1e1e1', '', ''), 
(11023, 'Yellow day', 'Are you ready?', '2028-10-28', null, '2028-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20281028', '', '#fbd75b', '', ''), 
(11024, 'Day 1', 'Starting activities..', '2028-11-01', '10:00:00', '2028-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20281101T130000Z', '', '#ff887c', '', ''), 
(11025, 'Hobbie time', 'shhhh...It''s a secret!', '2028-11-11', null, '2028-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20281111', '', '#7ae7bf', '', ''), 
(11026, 'Resting...', 'I''m...nevermind', '2028-11-16', null, '2028-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20281116', '', '#e1e1e1', '', ''), 
(11027, 'Yellow day', 'Are you ready?', '2028-11-28', null, '2028-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20281128', '', '#fbd75b', '', ''), 
(11028, 'Day 1', 'Starting activities..', '2028-12-01', '10:00:00', '2028-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20281201T130000Z', '', '#ff887c', '', ''), 
(11029, 'Hobbie time', 'shhhh...It''s a secret!', '2028-12-11', null, '2028-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20281211', '', '#7ae7bf', '', ''), 
(11030, 'Resting...', 'I''m...nevermind', '2028-12-16', null, '2028-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20281216', '', '#e1e1e1', '', ''), 
(11031, 'Yellow day', 'Are you ready?', '2028-12-28', null, '2028-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20281228', '', '#fbd75b', '', ''), 
(11032, 'Day 1', 'Starting activities..', '2029-01-01', '10:00:00', '2029-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290101T130000Z', '', '#ff887c', '', ''), 
(11033, 'Hobbie time', 'shhhh...It''s a secret!', '2029-01-11', null, '2029-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290111', '', '#7ae7bf', '', ''), 
(11034, 'Resting...', 'I''m...nevermind', '2029-01-16', null, '2029-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290116', '', '#e1e1e1', '', ''), 
(11035, 'Yellow day', 'Are you ready?', '2029-01-28', null, '2029-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290128', '', '#fbd75b', '', ''), 
(11036, 'Day 1', 'Starting activities..', '2029-02-01', '10:00:00', '2029-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290201T130000Z', '', '#ff887c', '', ''), 
(11037, 'Hobbie time', 'shhhh...It''s a secret!', '2029-02-11', null, '2029-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290211', '', '#7ae7bf', '', ''), 
(11038, 'Resting...', 'I''m...nevermind', '2029-02-16', null, '2029-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290216', '', '#e1e1e1', '', ''), 
(11039, 'Yellow day', 'Are you ready?', '2029-02-28', null, '2029-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290228', '', '#fbd75b', '', ''), 
(11040, 'Day 1', 'Starting activities..', '2029-03-01', '10:00:00', '2029-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290301T130000Z', '', '#ff887c', '', ''), 
(11041, 'Hobbie time', 'shhhh...It''s a secret!', '2029-03-11', null, '2029-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290311', '', '#7ae7bf', '', ''), 
(11042, 'Resting...', 'I''m...nevermind', '2029-03-16', null, '2029-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290316', '', '#e1e1e1', '', ''), 
(11043, 'Yellow day', 'Are you ready?', '2029-03-28', null, '2029-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290328', '', '#fbd75b', '', ''), 
(11044, 'Day 1', 'Starting activities..', '2029-04-01', '10:00:00', '2029-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290401T130000Z', '', '#ff887c', '', ''), 
(11045, 'Hobbie time', 'shhhh...It''s a secret!', '2029-04-11', null, '2029-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290411', '', '#7ae7bf', '', ''), 
(11046, 'Resting...', 'I''m...nevermind', '2029-04-16', null, '2029-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290416', '', '#e1e1e1', '', ''), 
(11047, 'Yellow day', 'Are you ready?', '2029-04-28', null, '2029-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290428', '', '#fbd75b', '', ''), 
(11048, 'Day 1', 'Starting activities..', '2029-05-01', '10:00:00', '2029-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290501T130000Z', '', '#ff887c', '', ''), 
(11049, 'Hobbie time', 'shhhh...It''s a secret!', '2029-05-11', null, '2029-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290511', '', '#7ae7bf', '', ''), 
(11050, 'Resting...', 'I''m...nevermind', '2029-05-16', null, '2029-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290516', '', '#e1e1e1', '', ''), 
(11051, 'Yellow day', 'Are you ready?', '2029-05-28', null, '2029-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290528', '', '#fbd75b', '', ''), 
(11052, 'Day 1', 'Starting activities..', '2029-06-01', '10:00:00', '2029-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290601T130000Z', '', '#ff887c', '', ''), 
(11053, 'Hobbie time', 'shhhh...It''s a secret!', '2029-06-11', null, '2029-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290611', '', '#7ae7bf', '', ''), 
(11054, 'Resting...', 'I''m...nevermind', '2029-06-16', null, '2029-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290616', '', '#e1e1e1', '', ''), 
(11055, 'Yellow day', 'Are you ready?', '2029-06-28', null, '2029-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290628', '', '#fbd75b', '', ''), 
(11056, 'Day 1', 'Starting activities..', '2029-07-01', '10:00:00', '2029-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290701T130000Z', '', '#ff887c', '', ''), 
(11057, 'Hobbie time', 'shhhh...It''s a secret!', '2029-07-11', null, '2029-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290711', '', '#7ae7bf', '', ''), 
(11058, 'Resting...', 'I''m...nevermind', '2029-07-16', null, '2029-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290716', '', '#e1e1e1', '', ''), 
(11059, 'Yellow day', 'Are you ready?', '2029-07-28', null, '2029-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290728', '', '#fbd75b', '', ''), 
(11060, 'Day 1', 'Starting activities..', '2029-08-01', '10:00:00', '2029-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290801T130000Z', '', '#ff887c', '', '');

INSERT INTO `new_calendar` VALUES  
(11061, 'Hobbie time', 'shhhh...It''s a secret!', '2029-08-11', null, '2029-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290811', '', '#7ae7bf', '', ''), 
(11062, 'Resting...', 'I''m...nevermind', '2029-08-16', null, '2029-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290816', '', '#e1e1e1', '', ''), 
(11063, 'Yellow day', 'Are you ready?', '2029-08-28', null, '2029-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290828', '', '#fbd75b', '', ''), 
(11064, 'Day 1', 'Starting activities..', '2029-09-01', '10:00:00', '2029-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20290901T130000Z', '', '#ff887c', '', ''), 
(11065, 'Hobbie time', 'shhhh...It''s a secret!', '2029-09-11', null, '2029-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20290911', '', '#7ae7bf', '', ''), 
(11066, 'Resting...', 'I''m...nevermind', '2029-09-16', null, '2029-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20290916', '', '#e1e1e1', '', ''), 
(11067, 'Yellow day', 'Are you ready?', '2029-09-28', null, '2029-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20290928', '', '#fbd75b', '', ''), 
(11068, 'Day 1', 'Starting activities..', '2029-10-01', '10:00:00', '2029-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20291001T130000Z', '', '#ff887c', '', ''), 
(11069, 'Hobbie time', 'shhhh...It''s a secret!', '2029-10-11', null, '2029-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20291011', '', '#7ae7bf', '', ''), 
(11070, 'Resting...', 'I''m...nevermind', '2029-10-16', null, '2029-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20291016', '', '#e1e1e1', '', ''), 
(11071, 'Yellow day', 'Are you ready?', '2029-10-28', null, '2029-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20291028', '', '#fbd75b', '', ''), 
(11072, 'Day 1', 'Starting activities..', '2029-11-01', '10:00:00', '2029-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20291101T130000Z', '', '#ff887c', '', ''), 
(11073, 'Hobbie time', 'shhhh...It''s a secret!', '2029-11-11', null, '2029-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20291111', '', '#7ae7bf', '', ''), 
(11074, 'Resting...', 'I''m...nevermind', '2029-11-16', null, '2029-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20291116', '', '#e1e1e1', '', ''), 
(11075, 'Yellow day', 'Are you ready?', '2029-11-28', null, '2029-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20291128', '', '#fbd75b', '', ''), 
(11076, 'Day 1', 'Starting activities..', '2029-12-01', '10:00:00', '2029-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20291201T130000Z', '', '#ff887c', '', ''), 
(11077, 'Hobbie time', 'shhhh...It''s a secret!', '2029-12-11', null, '2029-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20291211', '', '#7ae7bf', '', ''), 
(11078, 'Resting...', 'I''m...nevermind', '2029-12-16', null, '2029-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20291216', '', '#e1e1e1', '', ''), 
(11079, 'Yellow day', 'Are you ready?', '2029-12-28', null, '2029-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20291228', '', '#fbd75b', '', ''), 
(11080, 'Day 1', 'Starting activities..', '2030-01-01', '10:00:00', '2030-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300101T130000Z', '', '#ff887c', '', ''), 
(11081, 'Hobbie time', 'shhhh...It''s a secret!', '2030-01-11', null, '2030-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300111', '', '#7ae7bf', '', ''), 
(11082, 'Resting...', 'I''m...nevermind', '2030-01-16', null, '2030-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300116', '', '#e1e1e1', '', ''), 
(11083, 'Yellow day', 'Are you ready?', '2030-01-28', null, '2030-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300128', '', '#fbd75b', '', ''), 
(11084, 'Day 1', 'Starting activities..', '2030-02-01', '10:00:00', '2030-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300201T130000Z', '', '#ff887c', '', ''), 
(11085, 'Hobbie time', 'shhhh...It''s a secret!', '2030-02-11', null, '2030-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300211', '', '#7ae7bf', '', ''), 
(11086, 'Resting...', 'I''m...nevermind', '2030-02-16', null, '2030-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300216', '', '#e1e1e1', '', ''), 
(11087, 'Yellow day', 'Are you ready?', '2030-02-28', null, '2030-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300228', '', '#fbd75b', '', ''), 
(11088, 'Day 1', 'Starting activities..', '2030-03-01', '10:00:00', '2030-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300301T130000Z', '', '#ff887c', '', ''), 
(11089, 'Hobbie time', 'shhhh...It''s a secret!', '2030-03-11', null, '2030-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300311', '', '#7ae7bf', '', ''), 
(11090, 'Resting...', 'I''m...nevermind', '2030-03-16', null, '2030-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300316', '', '#e1e1e1', '', ''), 
(11091, 'Yellow day', 'Are you ready?', '2030-03-28', null, '2030-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300328', '', '#fbd75b', '', ''), 
(11092, 'Day 1', 'Starting activities..', '2030-04-01', '10:00:00', '2030-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300401T130000Z', '', '#ff887c', '', ''), 
(11093, 'Hobbie time', 'shhhh...It''s a secret!', '2030-04-11', null, '2030-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300411', '', '#7ae7bf', '', ''), 
(11094, 'Resting...', 'I''m...nevermind', '2030-04-16', null, '2030-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300416', '', '#e1e1e1', '', ''), 
(11095, 'Yellow day', 'Are you ready?', '2030-04-28', null, '2030-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300428', '', '#fbd75b', '', ''), 
(11096, 'Day 1', 'Starting activities..', '2030-05-01', '10:00:00', '2030-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300501T130000Z', '', '#ff887c', '', ''), 
(11097, 'Hobbie time', 'shhhh...It''s a secret!', '2030-05-11', null, '2030-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300511', '', '#7ae7bf', '', ''), 
(11098, 'Resting...', 'I''m...nevermind', '2030-05-16', null, '2030-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300516', '', '#e1e1e1', '', ''), 
(11099, 'Yellow day', 'Are you ready?', '2030-05-28', null, '2030-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300528', '', '#fbd75b', '', ''), 
(11100, 'Day 1', 'Starting activities..', '2030-06-01', '10:00:00', '2030-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300601T130000Z', '', '#ff887c', '', ''), 
(11101, 'Hobbie time', 'shhhh...It''s a secret!', '2030-06-11', null, '2030-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300611', '', '#7ae7bf', '', ''), 
(11102, 'Resting...', 'I''m...nevermind', '2030-06-16', null, '2030-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300616', '', '#e1e1e1', '', ''), 
(11103, 'Yellow day', 'Are you ready?', '2030-06-28', null, '2030-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300628', '', '#fbd75b', '', ''), 
(11104, 'Day 1', 'Starting activities..', '2030-07-01', '10:00:00', '2030-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300701T130000Z', '', '#ff887c', '', ''), 
(11105, 'Hobbie time', 'shhhh...It''s a secret!', '2030-07-11', null, '2030-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300711', '', '#7ae7bf', '', ''), 
(11106, 'Resting...', 'I''m...nevermind', '2030-07-16', null, '2030-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300716', '', '#e1e1e1', '', ''), 
(11107, 'Yellow day', 'Are you ready?', '2030-07-28', null, '2030-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300728', '', '#fbd75b', '', ''), 
(11108, 'Day 1', 'Starting activities..', '2030-08-01', '10:00:00', '2030-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300801T130000Z', '', '#ff887c', '', ''), 
(11109, 'Hobbie time', 'shhhh...It''s a secret!', '2030-08-11', null, '2030-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300811', '', '#7ae7bf', '', ''), 
(11110, 'Resting...', 'I''m...nevermind', '2030-08-16', null, '2030-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300816', '', '#e1e1e1', '', ''), 
(11111, 'Yellow day', 'Are you ready?', '2030-08-28', null, '2030-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300828', '', '#fbd75b', '', ''), 
(11112, 'Day 1', 'Starting activities..', '2030-09-01', '10:00:00', '2030-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20300901T130000Z', '', '#ff887c', '', ''), 
(11113, 'Hobbie time', 'shhhh...It''s a secret!', '2030-09-11', null, '2030-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20300911', '', '#7ae7bf', '', ''), 
(11114, 'Resting...', 'I''m...nevermind', '2030-09-16', null, '2030-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20300916', '', '#e1e1e1', '', ''), 
(11115, 'Yellow day', 'Are you ready?', '2030-09-28', null, '2030-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20300928', '', '#fbd75b', '', ''), 
(11116, 'Day 1', 'Starting activities..', '2030-10-01', '10:00:00', '2030-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20301001T130000Z', '', '#ff887c', '', ''), 
(11117, 'Hobbie time', 'shhhh...It''s a secret!', '2030-10-11', null, '2030-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20301011', '', '#7ae7bf', '', ''), 
(11118, 'Resting...', 'I''m...nevermind', '2030-10-16', null, '2030-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20301016', '', '#e1e1e1', '', ''), 
(11119, 'Yellow day', 'Are you ready?', '2030-10-28', null, '2030-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20301028', '', '#fbd75b', '', ''), 
(11120, 'Day 1', 'Starting activities..', '2030-11-01', '10:00:00', '2030-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20301101T130000Z', '', '#ff887c', '', ''), 
(11121, 'Hobbie time', 'shhhh...It''s a secret!', '2030-11-11', null, '2030-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20301111', '', '#7ae7bf', '', ''), 
(11122, 'Resting...', 'I''m...nevermind', '2030-11-16', null, '2030-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20301116', '', '#e1e1e1', '', ''), 
(11123, 'Yellow day', 'Are you ready?', '2030-11-28', null, '2030-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20301128', '', '#fbd75b', '', ''), 
(11124, 'Day 1', 'Starting activities..', '2030-12-01', '10:00:00', '2030-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20301201T130000Z', '', '#ff887c', '', ''), 
(11125, 'Hobbie time', 'shhhh...It''s a secret!', '2030-12-11', null, '2030-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20301211', '', '#7ae7bf', '', ''), 
(11126, 'Resting...', 'I''m...nevermind', '2030-12-16', null, '2030-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20301216', '', '#e1e1e1', '', ''), 
(11127, 'Yellow day', 'Are you ready?', '2030-12-28', null, '2030-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20301228', '', '#fbd75b', '', ''), 
(11128, 'Day 1', 'Starting activities..', '2031-01-01', '10:00:00', '2031-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310101T130000Z', '', '#ff887c', '', ''), 
(11129, 'Hobbie time', 'shhhh...It''s a secret!', '2031-01-11', null, '2031-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310111', '', '#7ae7bf', '', ''), 
(11130, 'Resting...', 'I''m...nevermind', '2031-01-16', null, '2031-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310116', '', '#e1e1e1', '', ''), 
(11131, 'Yellow day', 'Are you ready?', '2031-01-28', null, '2031-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310128', '', '#fbd75b', '', ''), 
(11132, 'Day 1', 'Starting activities..', '2031-02-01', '10:00:00', '2031-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310201T130000Z', '', '#ff887c', '', ''), 
(11133, 'Hobbie time', 'shhhh...It''s a secret!', '2031-02-11', null, '2031-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310211', '', '#7ae7bf', '', ''), 
(11134, 'Resting...', 'I''m...nevermind', '2031-02-16', null, '2031-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310216', '', '#e1e1e1', '', ''), 
(11135, 'Yellow day', 'Are you ready?', '2031-02-28', null, '2031-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310228', '', '#fbd75b', '', ''), 
(11136, 'Day 1', 'Starting activities..', '2031-03-01', '10:00:00', '2031-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310301T130000Z', '', '#ff887c', '', ''), 
(11137, 'Hobbie time', 'shhhh...It''s a secret!', '2031-03-11', null, '2031-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310311', '', '#7ae7bf', '', ''), 
(11138, 'Resting...', 'I''m...nevermind', '2031-03-16', null, '2031-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310316', '', '#e1e1e1', '', ''), 
(11139, 'Yellow day', 'Are you ready?', '2031-03-28', null, '2031-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310328', '', '#fbd75b', '', ''), 
(11140, 'Day 1', 'Starting activities..', '2031-04-01', '10:00:00', '2031-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310401T130000Z', '', '#ff887c', '', ''), 
(11141, 'Hobbie time', 'shhhh...It''s a secret!', '2031-04-11', null, '2031-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310411', '', '#7ae7bf', '', ''), 
(11142, 'Resting...', 'I''m...nevermind', '2031-04-16', null, '2031-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310416', '', '#e1e1e1', '', ''), 
(11143, 'Yellow day', 'Are you ready?', '2031-04-28', null, '2031-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310428', '', '#fbd75b', '', ''), 
(11144, 'Day 1', 'Starting activities..', '2031-05-01', '10:00:00', '2031-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310501T130000Z', '', '#ff887c', '', ''), 
(11145, 'Hobbie time', 'shhhh...It''s a secret!', '2031-05-11', null, '2031-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310511', '', '#7ae7bf', '', ''), 
(11146, 'Resting...', 'I''m...nevermind', '2031-05-16', null, '2031-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310516', '', '#e1e1e1', '', ''), 
(11147, 'Yellow day', 'Are you ready?', '2031-05-28', null, '2031-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310528', '', '#fbd75b', '', ''), 
(11148, 'Day 1', 'Starting activities..', '2031-06-01', '10:00:00', '2031-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310601T130000Z', '', '#ff887c', '', ''), 
(11149, 'Hobbie time', 'shhhh...It''s a secret!', '2031-06-11', null, '2031-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310611', '', '#7ae7bf', '', ''), 
(11150, 'Resting...', 'I''m...nevermind', '2031-06-16', null, '2031-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310616', '', '#e1e1e1', '', ''), 
(11151, 'Yellow day', 'Are you ready?', '2031-06-28', null, '2031-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310628', '', '#fbd75b', '', ''), 
(11152, 'Day 1', 'Starting activities..', '2031-07-01', '10:00:00', '2031-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310701T130000Z', '', '#ff887c', '', ''), 
(11153, 'Hobbie time', 'shhhh...It''s a secret!', '2031-07-11', null, '2031-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310711', '', '#7ae7bf', '', ''), 
(11154, 'Resting...', 'I''m...nevermind', '2031-07-16', null, '2031-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310716', '', '#e1e1e1', '', ''), 
(11155, 'Yellow day', 'Are you ready?', '2031-07-28', null, '2031-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310728', '', '#fbd75b', '', ''), 
(11156, 'Day 1', 'Starting activities..', '2031-08-01', '10:00:00', '2031-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310801T130000Z', '', '#ff887c', '', ''), 
(11157, 'Hobbie time', 'shhhh...It''s a secret!', '2031-08-11', null, '2031-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310811', '', '#7ae7bf', '', ''), 
(11158, 'Resting...', 'I''m...nevermind', '2031-08-16', null, '2031-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310816', '', '#e1e1e1', '', ''), 
(11159, 'Yellow day', 'Are you ready?', '2031-08-28', null, '2031-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310828', '', '#fbd75b', '', ''), 
(11160, 'Day 1', 'Starting activities..', '2031-09-01', '10:00:00', '2031-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20310901T130000Z', '', '#ff887c', '', ''), 
(11161, 'Hobbie time', 'shhhh...It''s a secret!', '2031-09-11', null, '2031-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20310911', '', '#7ae7bf', '', '');

INSERT INTO `new_calendar` VALUES 
(11162, 'Resting...', 'I''m...nevermind', '2031-09-16', null, '2031-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20310916', '', '#e1e1e1', '', ''), 
(11163, 'Yellow day', 'Are you ready?', '2031-09-28', null, '2031-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20310928', '', '#fbd75b', '', ''), 
(11164, 'Day 1', 'Starting activities..', '2031-10-01', '10:00:00', '2031-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20311001T130000Z', '', '#ff887c', '', ''), 
(11165, 'Hobbie time', 'shhhh...It''s a secret!', '2031-10-11', null, '2031-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20311011', '', '#7ae7bf', '', ''), 
(11166, 'Resting...', 'I''m...nevermind', '2031-10-16', null, '2031-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20311016', '', '#e1e1e1', '', ''), 
(11167, 'Yellow day', 'Are you ready?', '2031-10-28', null, '2031-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20311028', '', '#fbd75b', '', ''), 
(11168, 'Day 1', 'Starting activities..', '2031-11-01', '10:00:00', '2031-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20311101T130000Z', '', '#ff887c', '', ''), 
(11169, 'Hobbie time', 'shhhh...It''s a secret!', '2031-11-11', null, '2031-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20311111', '', '#7ae7bf', '', ''), 
(11170, 'Resting...', 'I''m...nevermind', '2031-11-16', null, '2031-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20311116', '', '#e1e1e1', '', ''), 
(11171, 'Yellow day', 'Are you ready?', '2031-11-28', null, '2031-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20311128', '', '#fbd75b', '', ''), 
(11172, 'Day 1', 'Starting activities..', '2031-12-01', '10:00:00', '2031-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20311201T130000Z', '', '#ff887c', '', ''), 
(11173, 'Hobbie time', 'shhhh...It''s a secret!', '2031-12-11', null, '2031-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20311211', '', '#7ae7bf', '', ''), 
(11174, 'Resting...', 'I''m...nevermind', '2031-12-16', null, '2031-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20311216', '', '#e1e1e1', '', ''), 
(11175, 'Yellow day', 'Are you ready?', '2031-12-28', null, '2031-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20311228', '', '#fbd75b', '', ''), 
(11176, 'Day 1', 'Starting activities..', '2032-01-01', '10:00:00', '2032-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320101T130000Z', '', '#ff887c', '', ''), 
(11177, 'Hobbie time', 'shhhh...It''s a secret!', '2032-01-11', null, '2032-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320111', '', '#7ae7bf', '', ''), 
(11178, 'Resting...', 'I''m...nevermind', '2032-01-16', null, '2032-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320116', '', '#e1e1e1', '', ''), 
(11179, 'Yellow day', 'Are you ready?', '2032-01-28', null, '2032-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320128', '', '#fbd75b', '', ''), 
(11180, 'Day 1', 'Starting activities..', '2032-02-01', '10:00:00', '2032-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320201T130000Z', '', '#ff887c', '', ''), 
(11181, 'Hobbie time', 'shhhh...It''s a secret!', '2032-02-11', null, '2032-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320211', '', '#7ae7bf', '', ''), 
(11182, 'Resting...', 'I''m...nevermind', '2032-02-16', null, '2032-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320216', '', '#e1e1e1', '', ''), 
(11183, 'Yellow day', 'Are you ready?', '2032-02-28', null, '2032-02-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320228', '', '#fbd75b', '', ''), 
(11184, 'Day 1', 'Starting activities..', '2032-03-01', '10:00:00', '2032-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320301T130000Z', '', '#ff887c', '', ''), 
(11185, 'Hobbie time', 'shhhh...It''s a secret!', '2032-03-11', null, '2032-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320311', '', '#7ae7bf', '', ''), 
(11186, 'Resting...', 'I''m...nevermind', '2032-03-16', null, '2032-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320316', '', '#e1e1e1', '', ''), 
(11187, 'Yellow day', 'Are you ready?', '2032-03-28', null, '2032-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320328', '', '#fbd75b', '', ''), 
(11188, 'Day 1', 'Starting activities..', '2032-04-01', '10:00:00', '2032-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320401T130000Z', '', '#ff887c', '', ''), 
(11189, 'Hobbie time', 'shhhh...It''s a secret!', '2032-04-11', null, '2032-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320411', '', '#7ae7bf', '', ''), 
(11190, 'Resting...', 'I''m...nevermind', '2032-04-16', null, '2032-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320416', '', '#e1e1e1', '', ''), 
(11191, 'Yellow day', 'Are you ready?', '2032-04-28', null, '2032-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320428', '', '#fbd75b', '', ''), 
(11192, 'Day 1', 'Starting activities..', '2032-05-01', '10:00:00', '2032-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320501T130000Z', '', '#ff887c', '', ''), 
(11193, 'Hobbie time', 'shhhh...It''s a secret!', '2032-05-11', null, '2032-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320511', '', '#7ae7bf', '', ''), 
(11194, 'Resting...', 'I''m...nevermind', '2032-05-16', null, '2032-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320516', '', '#e1e1e1', '', ''), 
(11195, 'Yellow day', 'Are you ready?', '2032-05-28', null, '2032-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320528', '', '#fbd75b', '', ''), 
(11196, 'Day 1', 'Starting activities..', '2032-06-01', '10:00:00', '2032-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320601T130000Z', '', '#ff887c', '', ''), 
(11197, 'Hobbie time', 'shhhh...It''s a secret!', '2032-06-11', null, '2032-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320611', '', '#7ae7bf', '', ''), 
(11198, 'Resting...', 'I''m...nevermind', '2032-06-16', null, '2032-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320616', '', '#e1e1e1', '', ''), 
(11199, 'Yellow day', 'Are you ready?', '2032-06-28', null, '2032-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320628', '', '#fbd75b', '', ''), 
(11200, 'Day 1', 'Starting activities..', '2032-07-01', '10:00:00', '2032-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320701T130000Z', '', '#ff887c', '', ''), 
(11201, 'Hobbie time', 'shhhh...It''s a secret!', '2032-07-11', null, '2032-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320711', '', '#7ae7bf', '', ''), 
(11202, 'Resting...', 'I''m...nevermind', '2032-07-16', null, '2032-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320716', '', '#e1e1e1', '', ''), 
(11203, 'Yellow day', 'Are you ready?', '2032-07-28', null, '2032-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320728', '', '#fbd75b', '', ''), 
(11204, 'Day 1', 'Starting activities..', '2032-08-01', '10:00:00', '2032-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320801T130000Z', '', '#ff887c', '', ''), 
(11205, 'Hobbie time', 'shhhh...It''s a secret!', '2032-08-11', null, '2032-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320811', '', '#7ae7bf', '', ''), 
(11206, 'Resting...', 'I''m...nevermind', '2032-08-16', null, '2032-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320816', '', '#e1e1e1', '', ''), 
(11207, 'Yellow day', 'Are you ready?', '2032-08-28', null, '2032-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320828', '', '#fbd75b', '', ''), 
(11208, 'Day 1', 'Starting activities..', '2032-09-01', '10:00:00', '2032-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20320901T130000Z', '', '#ff887c', '', ''), 
(11209, 'Hobbie time', 'shhhh...It''s a secret!', '2032-09-11', null, '2032-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20320911', '', '#7ae7bf', '', ''), 
(11210, 'Resting...', 'I''m...nevermind', '2032-09-16', null, '2032-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20320916', '', '#e1e1e1', '', ''), 
(11211, 'Yellow day', 'Are you ready?', '2032-09-28', null, '2032-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20320928', '', '#fbd75b', '', ''), 
(11212, 'Day 1', 'Starting activities..', '2032-10-01', '10:00:00', '2032-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20321001T130000Z', '', '#ff887c', '', ''), 
(11213, 'Hobbie time', 'shhhh...It''s a secret!', '2032-10-11', null, '2032-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20321011', '', '#7ae7bf', '', ''), 
(11214, 'Resting...', 'I''m...nevermind', '2032-10-16', null, '2032-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20321016', '', '#e1e1e1', '', ''), 
(11215, 'Yellow day', 'Are you ready?', '2032-10-28', null, '2032-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20321028', '', '#fbd75b', '', ''), 
(11216, 'Day 1', 'Starting activities..', '2032-11-01', '10:00:00', '2032-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20321101T130000Z', '', '#ff887c', '', ''), 
(11217, 'Hobbie time', 'shhhh...It''s a secret!', '2032-11-11', null, '2032-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20321111', '', '#7ae7bf', '', ''), 
(11218, 'Resting...', 'I''m...nevermind', '2032-11-16', null, '2032-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20321116', '', '#e1e1e1', '', ''), 
(11219, 'Yellow day', 'Are you ready?', '2032-11-28', null, '2032-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20321128', '', '#fbd75b', '', ''), 
(11220, 'Day 1', 'Starting activities..', '2032-12-01', '10:00:00', '2032-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20321201T130000Z', '', '#ff887c', '', ''), 
(11221, 'Hobbie time', 'shhhh...It''s a secret!', '2032-12-11', null, '2032-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20321211', '', '#7ae7bf', '', ''), 
(11222, 'Resting...', 'I''m...nevermind', '2032-12-16', null, '2032-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20321216', '', '#e1e1e1', '', ''), 
(11223, 'Yellow day', 'Are you ready?', '2032-12-28', null, '2032-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20321228', '', '#fbd75b', '', ''), 
(11224, 'Day 1', 'Starting activities..', '2033-01-01', '10:00:00', '2033-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330101T130000Z', '', '#ff887c', '', ''), 
(11225, 'Hobbie time', 'shhhh...It''s a secret!', '2033-01-11', null, '2033-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330111', '', '#7ae7bf', '', ''), 
(11226, 'Resting...', 'I''m...nevermind', '2033-01-16', null, '2033-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330116', '', '#e1e1e1', '', ''), 
(11227, 'Yellow day', 'Are you ready?', '2033-01-28', null, '2033-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330128', '', '#fbd75b', '', ''), 
(11228, 'Day 1', 'Starting activities..', '2033-02-01', '10:00:00', '2033-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330201T130000Z', '', '#ff887c', '', ''), 
(11229, 'Hobbie time', 'shhhh...It''s a secret!', '2033-02-11', null, '2033-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330211', '', '#7ae7bf', '', ''), 
(11230, 'Resting...', 'I''m...nevermind', '2033-02-16', null, '2033-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330216', '', '#e1e1e1', '', ''), 
(11231, 'Yellow day', 'Are you ready?', '2033-02-28', null, '2033-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330228', '', '#fbd75b', '', ''), 
(11232, 'Day 1', 'Starting activities..', '2033-03-01', '10:00:00', '2033-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330301T130000Z', '', '#ff887c', '', ''), 
(11233, 'Hobbie time', 'shhhh...It''s a secret!', '2033-03-11', null, '2033-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330311', '', '#7ae7bf', '', ''), 
(11234, 'Resting...', 'I''m...nevermind', '2033-03-16', null, '2033-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330316', '', '#e1e1e1', '', ''), 
(11235, 'Yellow day', 'Are you ready?', '2033-03-28', null, '2033-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330328', '', '#fbd75b', '', ''), 
(11236, 'Day 1', 'Starting activities..', '2033-04-01', '10:00:00', '2033-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330401T130000Z', '', '#ff887c', '', ''), 
(11237, 'Hobbie time', 'shhhh...It''s a secret!', '2033-04-11', null, '2033-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330411', '', '#7ae7bf', '', ''), 
(11238, 'Resting...', 'I''m...nevermind', '2033-04-16', null, '2033-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330416', '', '#e1e1e1', '', ''), 
(11239, 'Yellow day', 'Are you ready?', '2033-04-28', null, '2033-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330428', '', '#fbd75b', '', ''), 
(11240, 'Day 1', 'Starting activities..', '2033-05-01', '10:00:00', '2033-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330501T130000Z', '', '#ff887c', '', ''), 
(11241, 'Hobbie time', 'shhhh...It''s a secret!', '2033-05-11', null, '2033-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330511', '', '#7ae7bf', '', ''), 
(11242, 'Resting...', 'I''m...nevermind', '2033-05-16', null, '2033-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330516', '', '#e1e1e1', '', ''), 
(11243, 'Yellow day', 'Are you ready?', '2033-05-28', null, '2033-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330528', '', '#fbd75b', '', ''), 
(11244, 'Day 1', 'Starting activities..', '2033-06-01', '10:00:00', '2033-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330601T130000Z', '', '#ff887c', '', ''), 
(11245, 'Hobbie time', 'shhhh...It''s a secret!', '2033-06-11', null, '2033-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330611', '', '#7ae7bf', '', ''), 
(11246, 'Resting...', 'I''m...nevermind', '2033-06-16', null, '2033-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330616', '', '#e1e1e1', '', ''), 
(11247, 'Yellow day', 'Are you ready?', '2033-06-28', null, '2033-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330628', '', '#fbd75b', '', ''), 
(11248, 'Day 1', 'Starting activities..', '2033-07-01', '10:00:00', '2033-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330701T130000Z', '', '#ff887c', '', ''), 
(11249, 'Hobbie time', 'shhhh...It''s a secret!', '2033-07-11', null, '2033-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330711', '', '#7ae7bf', '', ''), 
(11250, 'Resting...', 'I''m...nevermind', '2033-07-16', null, '2033-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330716', '', '#e1e1e1', '', ''), 
(11251, 'Yellow day', 'Are you ready?', '2033-07-28', null, '2033-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330728', '', '#fbd75b', '', ''), 
(11252, 'Day 1', 'Starting activities..', '2033-08-01', '10:00:00', '2033-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330801T130000Z', '', '#ff887c', '', ''), 
(11253, 'Hobbie time', 'shhhh...It''s a secret!', '2033-08-11', null, '2033-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330811', '', '#7ae7bf', '', ''), 
(11254, 'Resting...', 'I''m...nevermind', '2033-08-16', null, '2033-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330816', '', '#e1e1e1', '', ''), 
(11255, 'Yellow day', 'Are you ready?', '2033-08-28', null, '2033-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330828', '', '#fbd75b', '', ''), 
(11256, 'Day 1', 'Starting activities..', '2033-09-01', '10:00:00', '2033-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20330901T130000Z', '', '#ff887c', '', ''), 
(11257, 'Hobbie time', 'shhhh...It''s a secret!', '2033-09-11', null, '2033-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20330911', '', '#7ae7bf', '', ''), 
(11258, 'Resting...', 'I''m...nevermind', '2033-09-16', null, '2033-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20330916', '', '#e1e1e1', '', ''), 
(11259, 'Yellow day', 'Are you ready?', '2033-09-28', null, '2033-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20330928', '', '#fbd75b', '', ''), 
(11260, 'Day 1', 'Starting activities..', '2033-10-01', '10:00:00', '2033-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20331001T130000Z', '', '#ff887c', '', ''), 
(11261, 'Hobbie time', 'shhhh...It''s a secret!', '2033-10-11', null, '2033-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20331011', '', '#7ae7bf', '', ''), 
(11262, 'Resting...', 'I''m...nevermind', '2033-10-16', null, '2033-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20331016', '', '#e1e1e1', '', '');

INSERT INTO `new_calendar` VALUES 
(11263, 'Yellow day', 'Are you ready?', '2033-10-28', null, '2033-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20331028', '', '#fbd75b', '', ''), 
(11264, 'Day 1', 'Starting activities..', '2033-11-01', '10:00:00', '2033-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20331101T130000Z', '', '#ff887c', '', ''), 
(11265, 'Hobbie time', 'shhhh...It''s a secret!', '2033-11-11', null, '2033-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20331111', '', '#7ae7bf', '', ''), 
(11266, 'Resting...', 'I''m...nevermind', '2033-11-16', null, '2033-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20331116', '', '#e1e1e1', '', ''), 
(11267, 'Yellow day', 'Are you ready?', '2033-11-28', null, '2033-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20331128', '', '#fbd75b', '', ''), 
(11268, 'Day 1', 'Starting activities..', '2033-12-01', '10:00:00', '2033-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20331201T130000Z', '', '#ff887c', '', ''), 
(11269, 'Hobbie time', 'shhhh...It''s a secret!', '2033-12-11', null, '2033-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20331211', '', '#7ae7bf', '', ''), 
(11270, 'Resting...', 'I''m...nevermind', '2033-12-16', null, '2033-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20331216', '', '#e1e1e1', '', ''), 
(11271, 'Yellow day', 'Are you ready?', '2033-12-28', null, '2033-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20331228', '', '#fbd75b', '', ''), 
(11272, 'Day 1', 'Starting activities..', '2034-01-01', '10:00:00', '2034-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340101T130000Z', '', '#ff887c', '', ''), 
(11273, 'Hobbie time', 'shhhh...It''s a secret!', '2034-01-11', null, '2034-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340111', '', '#7ae7bf', '', ''), 
(11274, 'Resting...', 'I''m...nevermind', '2034-01-16', null, '2034-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340116', '', '#e1e1e1', '', ''), 
(11275, 'Yellow day', 'Are you ready?', '2034-01-28', null, '2034-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340128', '', '#fbd75b', '', ''), 
(11276, 'Day 1', 'Starting activities..', '2034-02-01', '10:00:00', '2034-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340201T130000Z', '', '#ff887c', '', ''), 
(11277, 'Hobbie time', 'shhhh...It''s a secret!', '2034-02-11', null, '2034-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340211', '', '#7ae7bf', '', ''), 
(11278, 'Resting...', 'I''m...nevermind', '2034-02-16', null, '2034-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340216', '', '#e1e1e1', '', ''), 
(11279, 'Yellow day', 'Are you ready?', '2034-02-28', null, '2034-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340228', '', '#fbd75b', '', ''), 
(11280, 'Day 1', 'Starting activities..', '2034-03-01', '10:00:00', '2034-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340301T130000Z', '', '#ff887c', '', ''), 
(11281, 'Hobbie time', 'shhhh...It''s a secret!', '2034-03-11', null, '2034-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340311', '', '#7ae7bf', '', ''), 
(11282, 'Resting...', 'I''m...nevermind', '2034-03-16', null, '2034-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340316', '', '#e1e1e1', '', ''), 
(11283, 'Yellow day', 'Are you ready?', '2034-03-28', null, '2034-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340328', '', '#fbd75b', '', ''), 
(11284, 'Day 1', 'Starting activities..', '2034-04-01', '10:00:00', '2034-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340401T130000Z', '', '#ff887c', '', ''), 
(11285, 'Hobbie time', 'shhhh...It''s a secret!', '2034-04-11', null, '2034-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340411', '', '#7ae7bf', '', ''), 
(11286, 'Resting...', 'I''m...nevermind', '2034-04-16', null, '2034-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340416', '', '#e1e1e1', '', ''), 
(11287, 'Yellow day', 'Are you ready?', '2034-04-28', null, '2034-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340428', '', '#fbd75b', '', ''), 
(11288, 'Day 1', 'Starting activities..', '2034-05-01', '10:00:00', '2034-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340501T130000Z', '', '#ff887c', '', ''), 
(11289, 'Hobbie time', 'shhhh...It''s a secret!', '2034-05-11', null, '2034-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340511', '', '#7ae7bf', '', ''), 
(11290, 'Resting...', 'I''m...nevermind', '2034-05-16', null, '2034-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340516', '', '#e1e1e1', '', ''), 
(11291, 'Yellow day', 'Are you ready?', '2034-05-28', null, '2034-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340528', '', '#fbd75b', '', ''), 
(11292, 'Day 1', 'Starting activities..', '2034-06-01', '10:00:00', '2034-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340601T130000Z', '', '#ff887c', '', ''), 
(11293, 'Hobbie time', 'shhhh...It''s a secret!', '2034-06-11', null, '2034-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340611', '', '#7ae7bf', '', ''), 
(11294, 'Resting...', 'I''m...nevermind', '2034-06-16', null, '2034-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340616', '', '#e1e1e1', '', ''), 
(11295, 'Yellow day', 'Are you ready?', '2034-06-28', null, '2034-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340628', '', '#fbd75b', '', ''), 
(11296, 'Day 1', 'Starting activities..', '2034-07-01', '10:00:00', '2034-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340701T130000Z', '', '#ff887c', '', ''), 
(11297, 'Hobbie time', 'shhhh...It''s a secret!', '2034-07-11', null, '2034-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340711', '', '#7ae7bf', '', ''), 
(11298, 'Resting...', 'I''m...nevermind', '2034-07-16', null, '2034-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340716', '', '#e1e1e1', '', ''), 
(11299, 'Yellow day', 'Are you ready?', '2034-07-28', null, '2034-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340728', '', '#fbd75b', '', ''), 
(11300, 'Day 1', 'Starting activities..', '2034-08-01', '10:00:00', '2034-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340801T130000Z', '', '#ff887c', '', ''), 
(11301, 'Hobbie time', 'shhhh...It''s a secret!', '2034-08-11', null, '2034-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340811', '', '#7ae7bf', '', ''), 
(11302, 'Resting...', 'I''m...nevermind', '2034-08-16', null, '2034-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340816', '', '#e1e1e1', '', ''), 
(11303, 'Yellow day', 'Are you ready?', '2034-08-28', null, '2034-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340828', '', '#fbd75b', '', ''), 
(11304, 'Day 1', 'Starting activities..', '2034-09-01', '10:00:00', '2034-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20340901T130000Z', '', '#ff887c', '', ''), 
(11305, 'Hobbie time', 'shhhh...It''s a secret!', '2034-09-11', null, '2034-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20340911', '', '#7ae7bf', '', ''), 
(11306, 'Resting...', 'I''m...nevermind', '2034-09-16', null, '2034-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20340916', '', '#e1e1e1', '', ''), 
(11307, 'Yellow day', 'Are you ready?', '2034-09-28', null, '2034-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20340928', '', '#fbd75b', '', ''), 
(11308, 'Day 1', 'Starting activities..', '2034-10-01', '10:00:00', '2034-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20341001T130000Z', '', '#ff887c', '', ''), 
(11309, 'Hobbie time', 'shhhh...It''s a secret!', '2034-10-11', null, '2034-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20341011', '', '#7ae7bf', '', ''), 
(11310, 'Resting...', 'I''m...nevermind', '2034-10-16', null, '2034-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20341016', '', '#e1e1e1', '', ''), 
(11311, 'Yellow day', 'Are you ready?', '2034-10-28', null, '2034-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20341028', '', '#fbd75b', '', ''), 
(11312, 'Day 1', 'Starting activities..', '2034-11-01', '10:00:00', '2034-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20341101T130000Z', '', '#ff887c', '', ''), 
(11313, 'Hobbie time', 'shhhh...It''s a secret!', '2034-11-11', null, '2034-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20341111', '', '#7ae7bf', '', ''), 
(11314, 'Resting...', 'I''m...nevermind', '2034-11-16', null, '2034-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20341116', '', '#e1e1e1', '', ''), 
(11315, 'Yellow day', 'Are you ready?', '2034-11-28', null, '2034-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20341128', '', '#fbd75b', '', ''), 
(11316, 'Day 1', 'Starting activities..', '2034-12-01', '10:00:00', '2034-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20341201T130000Z', '', '#ff887c', '', ''), 
(11317, 'Hobbie time', 'shhhh...It''s a secret!', '2034-12-11', null, '2034-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20341211', '', '#7ae7bf', '', ''), 
(11318, 'Resting...', 'I''m...nevermind', '2034-12-16', null, '2034-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20341216', '', '#e1e1e1', '', ''), 
(11319, 'Yellow day', 'Are you ready?', '2034-12-28', null, '2034-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20341228', '', '#fbd75b', '', ''), 
(11320, 'Day 1', 'Starting activities..', '2035-01-01', '10:00:00', '2035-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350101T130000Z', '', '#ff887c', '', ''), 
(11321, 'Hobbie time', 'shhhh...It''s a secret!', '2035-01-11', null, '2035-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350111', '', '#7ae7bf', '', ''), 
(11322, 'Resting...', 'I''m...nevermind', '2035-01-16', null, '2035-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350116', '', '#e1e1e1', '', ''), 
(11323, 'Yellow day', 'Are you ready?', '2035-01-28', null, '2035-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350128', '', '#fbd75b', '', ''), 
(11324, 'Day 1', 'Starting activities..', '2035-02-01', '10:00:00', '2035-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350201T130000Z', '', '#ff887c', '', ''), 
(11325, 'Hobbie time', 'shhhh...It''s a secret!', '2035-02-11', null, '2035-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350211', '', '#7ae7bf', '', ''), 
(11326, 'Resting...', 'I''m...nevermind', '2035-02-16', null, '2035-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350216', '', '#e1e1e1', '', ''), 
(11327, 'Yellow day', 'Are you ready?', '2035-02-28', null, '2035-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350228', '', '#fbd75b', '', ''), 
(11328, 'Day 1', 'Starting activities..', '2035-03-01', '10:00:00', '2035-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350301T130000Z', '', '#ff887c', '', ''), 
(11329, 'Hobbie time', 'shhhh...It''s a secret!', '2035-03-11', null, '2035-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350311', '', '#7ae7bf', '', ''), 
(11330, 'Resting...', 'I''m...nevermind', '2035-03-16', null, '2035-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350316', '', '#e1e1e1', '', ''), 
(11331, 'Yellow day', 'Are you ready?', '2035-03-28', null, '2035-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350328', '', '#fbd75b', '', ''), 
(11332, 'Day 1', 'Starting activities..', '2035-04-01', '10:00:00', '2035-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350401T130000Z', '', '#ff887c', '', ''), 
(11333, 'Hobbie time', 'shhhh...It''s a secret!', '2035-04-11', null, '2035-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350411', '', '#7ae7bf', '', ''), 
(11334, 'Resting...', 'I''m...nevermind', '2035-04-16', null, '2035-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350416', '', '#e1e1e1', '', ''), 
(11335, 'Yellow day', 'Are you ready?', '2035-04-28', null, '2035-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350428', '', '#fbd75b', '', ''), 
(11336, 'Day 1', 'Starting activities..', '2035-05-01', '10:00:00', '2035-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350501T130000Z', '', '#ff887c', '', ''), 
(11337, 'Hobbie time', 'shhhh...It''s a secret!', '2035-05-11', null, '2035-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350511', '', '#7ae7bf', '', ''), 
(11338, 'Resting...', 'I''m...nevermind', '2035-05-16', null, '2035-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350516', '', '#e1e1e1', '', ''), 
(11339, 'Yellow day', 'Are you ready?', '2035-05-28', null, '2035-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350528', '', '#fbd75b', '', ''), 
(11340, 'Day 1', 'Starting activities..', '2035-06-01', '10:00:00', '2035-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350601T130000Z', '', '#ff887c', '', ''), 
(11341, 'Hobbie time', 'shhhh...It''s a secret!', '2035-06-11', null, '2035-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350611', '', '#7ae7bf', '', ''), 
(11342, 'Resting...', 'I''m...nevermind', '2035-06-16', null, '2035-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350616', '', '#e1e1e1', '', ''), 
(11343, 'Yellow day', 'Are you ready?', '2035-06-28', null, '2035-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350628', '', '#fbd75b', '', ''), 
(11344, 'Day 1', 'Starting activities..', '2035-07-01', '10:00:00', '2035-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350701T130000Z', '', '#ff887c', '', ''), 
(11345, 'Hobbie time', 'shhhh...It''s a secret!', '2035-07-11', null, '2035-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350711', '', '#7ae7bf', '', ''), 
(11346, 'Resting...', 'I''m...nevermind', '2035-07-16', null, '2035-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350716', '', '#e1e1e1', '', ''), 
(11347, 'Yellow day', 'Are you ready?', '2035-07-28', null, '2035-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350728', '', '#fbd75b', '', ''), 
(11348, 'Day 1', 'Starting activities..', '2035-08-01', '10:00:00', '2035-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350801T130000Z', '', '#ff887c', '', ''), 
(11349, 'Hobbie time', 'shhhh...It''s a secret!', '2035-08-11', null, '2035-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350811', '', '#7ae7bf', '', ''), 
(11350, 'Resting...', 'I''m...nevermind', '2035-08-16', null, '2035-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350816', '', '#e1e1e1', '', ''), 
(11351, 'Yellow day', 'Are you ready?', '2035-08-28', null, '2035-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350828', '', '#fbd75b', '', ''), 
(11352, 'Day 1', 'Starting activities..', '2035-09-01', '10:00:00', '2035-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20350901T130000Z', '', '#ff887c', '', ''), 
(11353, 'Hobbie time', 'shhhh...It''s a secret!', '2035-09-11', null, '2035-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20350911', '', '#7ae7bf', '', ''), 
(11354, 'Resting...', 'I''m...nevermind', '2035-09-16', null, '2035-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20350916', '', '#e1e1e1', '', ''), 
(11355, 'Yellow day', 'Are you ready?', '2035-09-28', null, '2035-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20350928', '', '#fbd75b', '', ''), 
(11356, 'Day 1', 'Starting activities..', '2035-10-01', '10:00:00', '2035-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20351001T130000Z', '', '#ff887c', '', ''), 
(11357, 'Hobbie time', 'shhhh...It''s a secret!', '2035-10-11', null, '2035-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20351011', '', '#7ae7bf', '', ''), 
(11358, 'Resting...', 'I''m...nevermind', '2035-10-16', null, '2035-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20351016', '', '#e1e1e1', '', ''), 
(11359, 'Yellow day', 'Are you ready?', '2035-10-28', null, '2035-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20351028', '', '#fbd75b', '', ''), 
(11360, 'Day 1', 'Starting activities..', '2035-11-01', '10:00:00', '2035-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20351101T130000Z', '', '#ff887c', '', ''), 
(11361, 'Hobbie time', 'shhhh...It''s a secret!', '2035-11-11', null, '2035-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20351111', '', '#7ae7bf', '', ''), 
(11362, 'Resting...', 'I''m...nevermind', '2035-11-16', null, '2035-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20351116', '', '#e1e1e1', '', ''), 
(11363, 'Yellow day', 'Are you ready?', '2035-11-28', null, '2035-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20351128', '', '#fbd75b', '', '');

INSERT INTO `new_calendar` VALUES  
(11364, 'Day 1', 'Starting activities..', '2035-12-01', '10:00:00', '2035-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20351201T130000Z', '', '#ff887c', '', ''), 
(11365, 'Hobbie time', 'shhhh...It''s a secret!', '2035-12-11', null, '2035-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20351211', '', '#7ae7bf', '', ''), 
(11366, 'Resting...', 'I''m...nevermind', '2035-12-16', null, '2035-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20351216', '', '#e1e1e1', '', ''), 
(11367, 'Yellow day', 'Are you ready?', '2035-12-28', null, '2035-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20351228', '', '#fbd75b', '', ''), 
(11368, 'Day 1', 'Starting activities..', '2036-01-01', '10:00:00', '2036-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360101T130000Z', '', '#ff887c', '', ''), 
(11369, 'Hobbie time', 'shhhh...It''s a secret!', '2036-01-11', null, '2036-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360111', '', '#7ae7bf', '', ''), 
(11370, 'Resting...', 'I''m...nevermind', '2036-01-16', null, '2036-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360116', '', '#e1e1e1', '', ''), 
(11371, 'Yellow day', 'Are you ready?', '2036-01-28', null, '2036-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360128', '', '#fbd75b', '', ''), 
(11372, 'Day 1', 'Starting activities..', '2036-02-01', '10:00:00', '2036-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360201T130000Z', '', '#ff887c', '', ''), 
(11373, 'Hobbie time', 'shhhh...It''s a secret!', '2036-02-11', null, '2036-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360211', '', '#7ae7bf', '', ''), 
(11374, 'Resting...', 'I''m...nevermind', '2036-02-16', null, '2036-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360216', '', '#e1e1e1', '', ''), 
(11375, 'Yellow day', 'Are you ready?', '2036-02-28', null, '2036-02-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360228', '', '#fbd75b', '', ''), 
(11376, 'Day 1', 'Starting activities..', '2036-03-01', '10:00:00', '2036-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360301T130000Z', '', '#ff887c', '', ''), 
(11377, 'Hobbie time', 'shhhh...It''s a secret!', '2036-03-11', null, '2036-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360311', '', '#7ae7bf', '', ''), 
(11378, 'Resting...', 'I''m...nevermind', '2036-03-16', null, '2036-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360316', '', '#e1e1e1', '', ''), 
(11379, 'Yellow day', 'Are you ready?', '2036-03-28', null, '2036-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360328', '', '#fbd75b', '', ''), 
(11380, 'Day 1', 'Starting activities..', '2036-04-01', '10:00:00', '2036-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360401T130000Z', '', '#ff887c', '', ''), 
(11381, 'Hobbie time', 'shhhh...It''s a secret!', '2036-04-11', null, '2036-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360411', '', '#7ae7bf', '', ''), 
(11382, 'Resting...', 'I''m...nevermind', '2036-04-16', null, '2036-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360416', '', '#e1e1e1', '', ''), 
(11383, 'Yellow day', 'Are you ready?', '2036-04-28', null, '2036-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360428', '', '#fbd75b', '', ''), 
(11384, 'Day 1', 'Starting activities..', '2036-05-01', '10:00:00', '2036-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360501T130000Z', '', '#ff887c', '', ''), 
(11385, 'Hobbie time', 'shhhh...It''s a secret!', '2036-05-11', null, '2036-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360511', '', '#7ae7bf', '', ''), 
(11386, 'Resting...', 'I''m...nevermind', '2036-05-16', null, '2036-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360516', '', '#e1e1e1', '', ''), 
(11387, 'Yellow day', 'Are you ready?', '2036-05-28', null, '2036-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360528', '', '#fbd75b', '', ''), 
(11388, 'Day 1', 'Starting activities..', '2036-06-01', '10:00:00', '2036-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360601T130000Z', '', '#ff887c', '', ''), 
(11389, 'Hobbie time', 'shhhh...It''s a secret!', '2036-06-11', null, '2036-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360611', '', '#7ae7bf', '', ''), 
(11390, 'Resting...', 'I''m...nevermind', '2036-06-16', null, '2036-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360616', '', '#e1e1e1', '', ''), 
(11391, 'Yellow day', 'Are you ready?', '2036-06-28', null, '2036-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360628', '', '#fbd75b', '', ''), 
(11392, 'Day 1', 'Starting activities..', '2036-07-01', '10:00:00', '2036-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360701T130000Z', '', '#ff887c', '', ''), 
(11393, 'Hobbie time', 'shhhh...It''s a secret!', '2036-07-11', null, '2036-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360711', '', '#7ae7bf', '', ''), 
(11394, 'Resting...', 'I''m...nevermind', '2036-07-16', null, '2036-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360716', '', '#e1e1e1', '', ''), 
(11395, 'Yellow day', 'Are you ready?', '2036-07-28', null, '2036-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360728', '', '#fbd75b', '', ''), 
(11396, 'Day 1', 'Starting activities..', '2036-08-01', '10:00:00', '2036-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360801T130000Z', '', '#ff887c', '', ''), 
(11397, 'Hobbie time', 'shhhh...It''s a secret!', '2036-08-11', null, '2036-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360811', '', '#7ae7bf', '', ''), 
(11398, 'Resting...', 'I''m...nevermind', '2036-08-16', null, '2036-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360816', '', '#e1e1e1', '', ''), 
(11399, 'Yellow day', 'Are you ready?', '2036-08-28', null, '2036-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360828', '', '#fbd75b', '', ''), 
(11400, 'Day 1', 'Starting activities..', '2036-09-01', '10:00:00', '2036-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20360901T130000Z', '', '#ff887c', '', ''), 
(11401, 'Hobbie time', 'shhhh...It''s a secret!', '2036-09-11', null, '2036-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20360911', '', '#7ae7bf', '', ''), 
(11402, 'Resting...', 'I''m...nevermind', '2036-09-16', null, '2036-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20360916', '', '#e1e1e1', '', ''), 
(11403, 'Yellow day', 'Are you ready?', '2036-09-28', null, '2036-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20360928', '', '#fbd75b', '', ''), 
(11404, 'Day 1', 'Starting activities..', '2036-10-01', '10:00:00', '2036-10-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20361001T130000Z', '', '#ff887c', '', ''), 
(11405, 'Hobbie time', 'shhhh...It''s a secret!', '2036-10-11', null, '2036-10-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20361011', '', '#7ae7bf', '', ''), 
(11406, 'Resting...', 'I''m...nevermind', '2036-10-16', null, '2036-10-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20361016', '', '#e1e1e1', '', ''), 
(11407, 'Yellow day', 'Are you ready?', '2036-10-28', null, '2036-10-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20361028', '', '#fbd75b', '', ''), 
(11408, 'Day 1', 'Starting activities..', '2036-11-01', '10:00:00', '2036-11-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20361101T130000Z', '', '#ff887c', '', ''), 
(11409, 'Hobbie time', 'shhhh...It''s a secret!', '2036-11-11', null, '2036-11-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20361111', '', '#7ae7bf', '', ''), 
(11410, 'Resting...', 'I''m...nevermind', '2036-11-16', null, '2036-11-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20361116', '', '#e1e1e1', '', ''), 
(11411, 'Yellow day', 'Are you ready?', '2036-11-28', null, '2036-11-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20361128', '', '#fbd75b', '', ''), 
(11412, 'Day 1', 'Starting activities..', '2036-12-01', '10:00:00', '2036-12-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20361201T130000Z', '', '#ff887c', '', ''), 
(11413, 'Hobbie time', 'shhhh...It''s a secret!', '2036-12-11', null, '2036-12-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20361211', '', '#7ae7bf', '', ''), 
(11414, 'Resting...', 'I''m...nevermind', '2036-12-16', null, '2036-12-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20361216', '', '#e1e1e1', '', ''), 
(11415, 'Yellow day', 'Are you ready?', '2036-12-28', null, '2036-12-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20361228', '', '#fbd75b', '', ''), 
(11416, 'Day 1', 'Starting activities..', '2037-01-01', '10:00:00', '2037-01-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370101T130000Z', '', '#ff887c', '', ''), 
(11417, 'Hobbie time', 'shhhh...It''s a secret!', '2037-01-11', null, '2037-01-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370111', '', '#7ae7bf', '', ''), 
(11418, 'Resting...', 'I''m...nevermind', '2037-01-16', null, '2037-01-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370116', '', '#e1e1e1', '', ''), 
(11419, 'Yellow day', 'Are you ready?', '2037-01-28', null, '2037-01-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370128', '', '#fbd75b', '', ''), 
(11420, 'Day 1', 'Starting activities..', '2037-02-01', '10:00:00', '2037-02-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370201T130000Z', '', '#ff887c', '', ''), 
(11421, 'Hobbie time', 'shhhh...It''s a secret!', '2037-02-11', null, '2037-02-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370211', '', '#7ae7bf', '', ''), 
(11422, 'Resting...', 'I''m...nevermind', '2037-02-16', null, '2037-02-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370216', '', '#e1e1e1', '', ''), 
(11423, 'Yellow day', 'Are you ready?', '2037-02-28', null, '2037-03-01', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370228', '', '#fbd75b', '', ''), 
(11424, 'Day 1', 'Starting activities..', '2037-03-01', '10:00:00', '2037-03-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370301T130000Z', '', '#ff887c', '', ''), 
(11425, 'Hobbie time', 'shhhh...It''s a secret!', '2037-03-11', null, '2037-03-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370311', '', '#7ae7bf', '', ''), 
(11426, 'Resting...', 'I''m...nevermind', '2037-03-16', null, '2037-03-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370316', '', '#e1e1e1', '', ''), 
(11427, 'Yellow day', 'Are you ready?', '2037-03-28', null, '2037-03-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370328', '', '#fbd75b', '', ''), 
(11428, 'Day 1', 'Starting activities..', '2037-04-01', '10:00:00', '2037-04-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370401T130000Z', '', '#ff887c', '', ''), 
(11429, 'Hobbie time', 'shhhh...It''s a secret!', '2037-04-11', null, '2037-04-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370411', '', '#7ae7bf', '', ''), 
(11430, 'Resting...', 'I''m...nevermind', '2037-04-16', null, '2037-04-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370416', '', '#e1e1e1', '', ''), 
(11431, 'Yellow day', 'Are you ready?', '2037-04-28', null, '2037-04-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370428', '', '#fbd75b', '', ''), 
(11432, 'Day 1', 'Starting activities..', '2037-05-01', '10:00:00', '2037-05-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370501T130000Z', '', '#ff887c', '', ''), 
(11433, 'Hobbie time', 'shhhh...It''s a secret!', '2037-05-11', null, '2037-05-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370511', '', '#7ae7bf', '', ''), 
(11434, 'Resting...', 'I''m...nevermind', '2037-05-16', null, '2037-05-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370516', '', '#e1e1e1', '', ''), 
(11435, 'Yellow day', 'Are you ready?', '2037-05-28', null, '2037-05-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370528', '', '#fbd75b', '', ''), 
(11436, 'Day 1', 'Starting activities..', '2037-06-01', '10:00:00', '2037-06-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370601T130000Z', '', '#ff887c', '', ''), 
(11437, 'Hobbie time', 'shhhh...It''s a secret!', '2037-06-11', null, '2037-06-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370611', '', '#7ae7bf', '', ''), 
(11438, 'Resting...', 'I''m...nevermind', '2037-06-16', null, '2037-06-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370616', '', '#e1e1e1', '', ''), 
(11439, 'Yellow day', 'Are you ready?', '2037-06-28', null, '2037-06-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370628', '', '#fbd75b', '', ''), 
(11440, 'Day 1', 'Starting activities..', '2037-07-01', '10:00:00', '2037-07-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370701T130000Z', '', '#ff887c', '', ''), 
(11441, 'Hobbie time', 'shhhh...It''s a secret!', '2037-07-11', null, '2037-07-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370711', '', '#7ae7bf', '', ''), 
(11442, 'Resting...', 'I''m...nevermind', '2037-07-16', null, '2037-07-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370716', '', '#e1e1e1', '', ''), 
(11443, 'Yellow day', 'Are you ready?', '2037-07-28', null, '2037-07-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370728', '', '#fbd75b', '', ''), 
(11444, 'Day 1', 'Starting activities..', '2037-08-01', '10:00:00', '2037-08-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370801T130000Z', '', '#ff887c', '', ''), 
(11445, 'Hobbie time', 'shhhh...It''s a secret!', '2037-08-11', null, '2037-08-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370811', '', '#7ae7bf', '', ''), 
(11446, 'Resting...', 'I''m...nevermind', '2037-08-16', null, '2037-08-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370816', '', '#e1e1e1', '', ''), 
(11447, 'Yellow day', 'Are you ready?', '2037-08-28', null, '2037-08-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370828', '', '#fbd75b', '', ''), 
(11448, 'Day 1', 'Starting activities..', '2037-09-01', '10:00:00', '2037-09-01', '15:30:00', '', '', 0, 'scriptcase.calendar@gmail.com', '53llpr1lgdpf8872qif2u0taeb_20370901T130000Z', '', '#ff887c', '', ''), 
(11449, 'Hobbie time', 'shhhh...It''s a secret!', '2037-09-11', null, '2037-09-13', null, '', '', 0, 'scriptcase.calendar@gmail.com', '0l60uars77bvd3eai7ascrjont_20370911', '', '#7ae7bf', '', ''), 
(11450, 'Resting...', 'I''m...nevermind', '2037-09-16', null, '2037-09-18', null, '', '', 0, 'scriptcase.calendar@gmail.com', '4t1g6f5vc6b89eon4kd28mj5pc_20370916', '', '#e1e1e1', '', ''), 
(11451, 'Yellow day', 'Are you ready?', '2037-09-28', null, '2037-09-29', null, '', '', 0, 'scriptcase.calendar@gmail.com', '1aho4ag5c9t7qgbi40o9f417dl_20370928', '', '#fbd75b', '', ''), 
(11452, 'Day 1', 'Starting activities..', '2037-10-01', '10:00:00', '2037-10-01', '15