<?php
//__NM____NM__FUNCTION__NM__//
function alertV94() {
	if (isset([proj_theme]) && [proj_theme] == 'Sc9_Rhino') {
		?>
			<style>
			@import url('https://fonts.googleapis.com/css?family=Open+Sans:400,700&display=swap');
				
			.hidden {
			  display: none !important;
			}
			
			.modal-content{
				font-family: 'Open Sans', sans-serif;
			}

			.modal {
			  position: absolute;
			  width: 100%;
			  height: 100%;
			  top: 0;
			  left: 0;
			  background: rgba(0, 0, 0, 0.7);
			  display: -webkit-box;
			  display: -ms-flexbox;
			  display: flex;
			  -webkit-box-orient: vertical;
			  -webkit-box-direction: normal;
				  -ms-flex-direction: column;
					  flex-direction: column;
			  -webkit-box-align: center;
				  -ms-flex-align: center;
					  align-items: center;
			  -webkit-animation: opacityup ease-in-out 0.5s forwards;
					  animation: opacityup ease-in-out 0.5s forwards;
				z-index: 99999;
			}

			.modal .btn-close {
			  -ms-flex-item-align: end;
				  align-self: flex-end;
			  padding: 25px;
			  color: aliceblue;
			  cursor: pointer;
			}

			.modal .btn-close:hover {
			  color: white;
			}	

			.modal-content{
				padding: 15px;
				max-width: 500px;
				background: white;
				display: flex;
				flex-direction: column;
				justify-content: center;
				align-items: center;
				border-radius: 10px;
			}

			.modal-content .icon{
				justify-content: center;
				display: flex;
				flex-direction: column;
				text-align: left;
				margin-bottom: 15px;
			}

			.icon .icon-color{
				color: #2185D0;
			}

			.modal-content .text{
				display: flex;
				flex-direction: column;
				justify-content: flex-start;
				min-height: 120px;
				flex-grow: 1;
			}

			.modal-content .title{
				color: #2185D0;
				font-weight: bold;
				font-size: 18px;
				margin: 0 0 10px 0;
				text-align: center;
			}

			.modal-content .message{
				font-size: 14px;
				color: #6C757D;
				padding: 10px;
			}
				
			.modal-content .message b{
				color: #6C757D;
			}

			.modal-content .message-link{
				text-decoration: underline;
				color: #2185D0;
			}

			.modal-content .message-link:hover{
				color: #4e5bf2;
			}

			.modal-content .btn-ok{
				padding: 10px 20px;
				background: #2185D0;
				color: white;
				font-weight: bold;
				border-radius: 10px;
				cursor: pointer;
				border: none;
				display: block;
				margin: 10px;
				text-decoration: none;
			}
				
			.scroll-lock {
			  margin: 0;
			  height: 100%;
			  overflow: hidden
			}
			</style>

			<div class="modal">
				<span class="btn-close">X</span>
				<div class="modal-content">
					<div class="text">
						<h3 class="title"><?php echo {lang_v94_alert_title}; ?></h3>
						<p class="message">
							<?php echo sprintf({lang_v94_alert_desc}, {lang_v94_alert_desc_link}); ?>
						</p>
					</div>
					<div class="button-holder">
						<a class="btn-ok" href="<?php echo {lang_v94_alert_btn_link}; ?>" target="_blank" id="OK"><?php echo {lang_v94_alert_btn}; ?></a>
					</div>
				</div>
			</div>

			<script>
				(function() {
				   	const modal = document.querySelector('.modal');
					const modalContent = document.querySelector('.modal-content');
					const close = document.querySelector('.btn-close');
					const body = document.querySelector('body');
					const html = document.querySelector('html');
					const btnOk = document.getElementById('OK');

					modal.addEventListener('click', () =>{
						if (event.target.classList.value === "modal") {
							modal.classList.add('hidden');
							scrollLock();
						}
					});

					close.addEventListener('click', () =>{
						modal.classList.add('hidden');
						scrollLock();
					});

					btnOk.addEventListener('click', () =>{
						modal.classList.toggle('hidden');
						scrollLock();
					})

					function scrollLock(){
						html.classList.toggle('scroll-lock');
						body.classList.toggle('scroll-lock');
					}

					scrollLock();	
				})();
			</script>
		<?php	
	}
}
?>